/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaOpenRequest is the corresponding interface of OpcuaOpenRequest
type OpcuaOpenRequest interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	MessagePDU
	// GetOpenRequest returns OpenRequest (property field)
	GetOpenRequest() OpenChannelMessage
	// GetMessage returns Message (property field)
	GetMessage() Payload
}

// OpcuaOpenRequestExactly can be used when we want exactly this type and not a type which fulfills OpcuaOpenRequest.
// This is useful for switch cases.
type OpcuaOpenRequestExactly interface {
	OpcuaOpenRequest
	isOpcuaOpenRequest() bool
}

// _OpcuaOpenRequest is the data-structure of this message
type _OpcuaOpenRequest struct {
	*_MessagePDU
	OpenRequest OpenChannelMessage
	Message     Payload

	// Arguments.
	TotalLength uint32
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_OpcuaOpenRequest) GetMessageType() string {
	return "OPN"
}

func (m *_OpcuaOpenRequest) GetResponse() bool {
	return bool(false)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_OpcuaOpenRequest) InitializeParent(parent MessagePDU, chunk ChunkType) {
	m.Chunk = chunk
}

func (m *_OpcuaOpenRequest) GetParent() MessagePDU {
	return m._MessagePDU
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_OpcuaOpenRequest) GetOpenRequest() OpenChannelMessage {
	return m.OpenRequest
}

func (m *_OpcuaOpenRequest) GetMessage() Payload {
	return m.Message
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewOpcuaOpenRequest factory function for _OpcuaOpenRequest
func NewOpcuaOpenRequest(openRequest OpenChannelMessage, message Payload, chunk ChunkType, totalLength uint32) *_OpcuaOpenRequest {
	_result := &_OpcuaOpenRequest{
		OpenRequest: openRequest,
		Message:     message,
		_MessagePDU: NewMessagePDU(chunk),
	}
	_result._MessagePDU._MessagePDUChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastOpcuaOpenRequest(structType any) OpcuaOpenRequest {
	if casted, ok := structType.(OpcuaOpenRequest); ok {
		return casted
	}
	if casted, ok := structType.(*OpcuaOpenRequest); ok {
		return *casted
	}
	return nil
}

func (m *_OpcuaOpenRequest) GetTypeName() string {
	return "OpcuaOpenRequest"
}

func (m *_OpcuaOpenRequest) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (openRequest)
	lengthInBits += m.OpenRequest.GetLengthInBits(ctx)

	// Simple field (message)
	lengthInBits += m.Message.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_OpcuaOpenRequest) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaOpenRequestParse(ctx context.Context, theBytes []byte, totalLength uint32, response bool) (OpcuaOpenRequest, error) {
	return OpcuaOpenRequestParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), totalLength, response)
}

func OpcuaOpenRequestParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, totalLength uint32, response bool) (OpcuaOpenRequest, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("OpcuaOpenRequest"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for OpcuaOpenRequest")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (openRequest)
	if pullErr := readBuffer.PullContext("openRequest"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for openRequest")
	}
	_openRequest, _openRequestErr := OpenChannelMessageParseWithBuffer(ctx, readBuffer, bool(response))
	if _openRequestErr != nil {
		return nil, errors.Wrap(_openRequestErr, "Error parsing 'openRequest' field of OpcuaOpenRequest")
	}
	openRequest := _openRequest.(OpenChannelMessage)
	if closeErr := readBuffer.CloseContext("openRequest"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for openRequest")
	}

	// Simple Field (message)
	if pullErr := readBuffer.PullContext("message"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for message")
	}
	_message, _messageErr := PayloadParseWithBuffer(ctx, readBuffer, bool(bool(false)), uint32(uint32(uint32(totalLength)-uint32(openRequest.GetLengthInBytes(ctx)))-uint32(uint32(16))))
	if _messageErr != nil {
		return nil, errors.Wrap(_messageErr, "Error parsing 'message' field of OpcuaOpenRequest")
	}
	message := _message.(Payload)
	if closeErr := readBuffer.CloseContext("message"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for message")
	}

	if closeErr := readBuffer.CloseContext("OpcuaOpenRequest"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for OpcuaOpenRequest")
	}

	// Create a partially initialized instance
	_child := &_OpcuaOpenRequest{
		_MessagePDU: &_MessagePDU{},
		OpenRequest: openRequest,
		Message:     message,
	}
	_child._MessagePDU._MessagePDUChildRequirements = _child
	return _child, nil
}

func (m *_OpcuaOpenRequest) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_OpcuaOpenRequest) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("OpcuaOpenRequest"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for OpcuaOpenRequest")
		}

		// Simple Field (openRequest)
		if pushErr := writeBuffer.PushContext("openRequest"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for openRequest")
		}
		_openRequestErr := writeBuffer.WriteSerializable(ctx, m.GetOpenRequest())
		if popErr := writeBuffer.PopContext("openRequest"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for openRequest")
		}
		if _openRequestErr != nil {
			return errors.Wrap(_openRequestErr, "Error serializing 'openRequest' field")
		}

		// Simple Field (message)
		if pushErr := writeBuffer.PushContext("message"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for message")
		}
		_messageErr := writeBuffer.WriteSerializable(ctx, m.GetMessage())
		if popErr := writeBuffer.PopContext("message"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for message")
		}
		if _messageErr != nil {
			return errors.Wrap(_messageErr, "Error serializing 'message' field")
		}

		if popErr := writeBuffer.PopContext("OpcuaOpenRequest"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for OpcuaOpenRequest")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

////
// Arguments Getter

func (m *_OpcuaOpenRequest) GetTotalLength() uint32 {
	return m.TotalLength
}

//
////

func (m *_OpcuaOpenRequest) isOpcuaOpenRequest() bool {
	return true
}

func (m *_OpcuaOpenRequest) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
