/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableWriter is an enum
type OpcuaNodeIdServicesVariableWriter int32

type IOpcuaNodeIdServicesVariableWriter interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_DataSetWriterProperties                                         OpcuaNodeIdServicesVariableWriter = 17490
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_HeaderLayoutUri                                                                               OpcuaNodeIdServicesVariableWriter = 17559
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_WriterGroupId                                                                                 OpcuaNodeIdServicesVariableWriter = 17736
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_PublishingInterval                                                                            OpcuaNodeIdServicesVariableWriter = 17737
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_KeepAliveTime                                                                                 OpcuaNodeIdServicesVariableWriter = 17738
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Priority                                                                                      OpcuaNodeIdServicesVariableWriter = 17739
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_LocaleIds                                                                                     OpcuaNodeIdServicesVariableWriter = 17740
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_DataSetWriterId                                                 OpcuaNodeIdServicesVariableWriter = 17744
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_DataSetFieldContentMask                                         OpcuaNodeIdServicesVariableWriter = 17745
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_KeyFrameCount                                                   OpcuaNodeIdServicesVariableWriter = 17746
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Status_State                                                    OpcuaNodeIdServicesVariableWriter = 17750
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel                                    OpcuaNodeIdServicesVariableWriter = 17754
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation                                    OpcuaNodeIdServicesVariableWriter = 17755
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active                             OpcuaNodeIdServicesVariableWriter = 17756
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification                     OpcuaNodeIdServicesVariableWriter = 17757
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel                   OpcuaNodeIdServicesVariableWriter = 17758
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange                    OpcuaNodeIdServicesVariableWriter = 17759
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError                                          OpcuaNodeIdServicesVariableWriter = 17760
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active                                   OpcuaNodeIdServicesVariableWriter = 17761
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification                           OpcuaNodeIdServicesVariableWriter = 17762
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel                         OpcuaNodeIdServicesVariableWriter = 17763
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange                          OpcuaNodeIdServicesVariableWriter = 17764
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_SubError                                            OpcuaNodeIdServicesVariableWriter = 17766
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError                                 OpcuaNodeIdServicesVariableWriter = 17768
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active                          OpcuaNodeIdServicesVariableWriter = 17769
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification                  OpcuaNodeIdServicesVariableWriter = 17770
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel                OpcuaNodeIdServicesVariableWriter = 17771
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange                 OpcuaNodeIdServicesVariableWriter = 17772
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod                   OpcuaNodeIdServicesVariableWriter = 17773
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active            OpcuaNodeIdServicesVariableWriter = 17774
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification    OpcuaNodeIdServicesVariableWriter = 17775
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel  OpcuaNodeIdServicesVariableWriter = 17776
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange   OpcuaNodeIdServicesVariableWriter = 17777
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent                   OpcuaNodeIdServicesVariableWriter = 17778
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active            OpcuaNodeIdServicesVariableWriter = 17779
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification    OpcuaNodeIdServicesVariableWriter = 17780
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel  OpcuaNodeIdServicesVariableWriter = 17781
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange   OpcuaNodeIdServicesVariableWriter = 17782
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError                  OpcuaNodeIdServicesVariableWriter = 17783
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active           OpcuaNodeIdServicesVariableWriter = 17784
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification   OpcuaNodeIdServicesVariableWriter = 17785
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel OpcuaNodeIdServicesVariableWriter = 17786
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange  OpcuaNodeIdServicesVariableWriter = 17787
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent                        OpcuaNodeIdServicesVariableWriter = 17788
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active                 OpcuaNodeIdServicesVariableWriter = 17789
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification         OpcuaNodeIdServicesVariableWriter = 17790
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel       OpcuaNodeIdServicesVariableWriter = 17791
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange        OpcuaNodeIdServicesVariableWriter = 17792
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod                      OpcuaNodeIdServicesVariableWriter = 17793
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active               OpcuaNodeIdServicesVariableWriter = 17794
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification       OpcuaNodeIdServicesVariableWriter = 17795
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel     OpcuaNodeIdServicesVariableWriter = 17796
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange      OpcuaNodeIdServicesVariableWriter = 17797
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages                      OpcuaNodeIdServicesVariableWriter = 17799
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active               OpcuaNodeIdServicesVariableWriter = 17800
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification       OpcuaNodeIdServicesVariableWriter = 17801
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel     OpcuaNodeIdServicesVariableWriter = 17802
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange      OpcuaNodeIdServicesVariableWriter = 17803
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber                    OpcuaNodeIdServicesVariableWriter = 17804
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel   OpcuaNodeIdServicesVariableWriter = 17805
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode                               OpcuaNodeIdServicesVariableWriter = 17806
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel              OpcuaNodeIdServicesVariableWriter = 17807
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion                             OpcuaNodeIdServicesVariableWriter = 17808
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel            OpcuaNodeIdServicesVariableWriter = 17809
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion                             OpcuaNodeIdServicesVariableWriter = 17810
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel            OpcuaNodeIdServicesVariableWriter = 17811
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_DiagnosticsLevel                                                                  OpcuaNodeIdServicesVariableWriter = 17813
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalInformation                                                                  OpcuaNodeIdServicesVariableWriter = 17814
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalInformation_Active                                                           OpcuaNodeIdServicesVariableWriter = 17815
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalInformation_Classification                                                   OpcuaNodeIdServicesVariableWriter = 17816
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalInformation_DiagnosticsLevel                                                 OpcuaNodeIdServicesVariableWriter = 17817
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalInformation_TimeFirstChange                                                  OpcuaNodeIdServicesVariableWriter = 17818
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalError                                                                        OpcuaNodeIdServicesVariableWriter = 17819
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalError_Active                                                                 OpcuaNodeIdServicesVariableWriter = 17820
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalError_Classification                                                         OpcuaNodeIdServicesVariableWriter = 17821
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalError_DiagnosticsLevel                                                       OpcuaNodeIdServicesVariableWriter = 17822
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalError_TimeFirstChange                                                        OpcuaNodeIdServicesVariableWriter = 17823
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_SubError                                                                          OpcuaNodeIdServicesVariableWriter = 17825
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateError                                                               OpcuaNodeIdServicesVariableWriter = 17827
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateError_Active                                                        OpcuaNodeIdServicesVariableWriter = 17828
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateError_Classification                                                OpcuaNodeIdServicesVariableWriter = 17829
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateError_DiagnosticsLevel                                              OpcuaNodeIdServicesVariableWriter = 17830
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateError_TimeFirstChange                                               OpcuaNodeIdServicesVariableWriter = 17831
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByMethod                                                 OpcuaNodeIdServicesVariableWriter = 17832
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_Active                                          OpcuaNodeIdServicesVariableWriter = 17833
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_Classification                                  OpcuaNodeIdServicesVariableWriter = 17834
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel                                OpcuaNodeIdServicesVariableWriter = 17835
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange                                 OpcuaNodeIdServicesVariableWriter = 17836
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByParent                                                 OpcuaNodeIdServicesVariableWriter = 17837
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByParent_Active                                          OpcuaNodeIdServicesVariableWriter = 17838
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByParent_Classification                                  OpcuaNodeIdServicesVariableWriter = 17839
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel                                OpcuaNodeIdServicesVariableWriter = 17840
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange                                 OpcuaNodeIdServicesVariableWriter = 17841
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalFromError                                                OpcuaNodeIdServicesVariableWriter = 17842
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalFromError_Active                                         OpcuaNodeIdServicesVariableWriter = 17843
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalFromError_Classification                                 OpcuaNodeIdServicesVariableWriter = 17844
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel                               OpcuaNodeIdServicesVariableWriter = 17845
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange                                OpcuaNodeIdServicesVariableWriter = 17846
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StatePausedByParent                                                      OpcuaNodeIdServicesVariableWriter = 17847
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StatePausedByParent_Active                                               OpcuaNodeIdServicesVariableWriter = 17848
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StatePausedByParent_Classification                                       OpcuaNodeIdServicesVariableWriter = 17849
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel                                     OpcuaNodeIdServicesVariableWriter = 17850
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StatePausedByParent_TimeFirstChange                                      OpcuaNodeIdServicesVariableWriter = 17851
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateDisabledByMethod                                                    OpcuaNodeIdServicesVariableWriter = 17853
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_Active                                             OpcuaNodeIdServicesVariableWriter = 17854
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_Classification                                     OpcuaNodeIdServicesVariableWriter = 17855
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel                                   OpcuaNodeIdServicesVariableWriter = 17856
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange                                    OpcuaNodeIdServicesVariableWriter = 17857
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_SentNetworkMessages                                                      OpcuaNodeIdServicesVariableWriter = 17859
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_SentNetworkMessages_Active                                               OpcuaNodeIdServicesVariableWriter = 17864
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_SentNetworkMessages_Classification                                       OpcuaNodeIdServicesVariableWriter = 17871
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_SentNetworkMessages_DiagnosticsLevel                                     OpcuaNodeIdServicesVariableWriter = 17872
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_SentNetworkMessages_TimeFirstChange                                      OpcuaNodeIdServicesVariableWriter = 17873
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_FailedTransmissions                                                      OpcuaNodeIdServicesVariableWriter = 17874
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_FailedTransmissions_Active                                               OpcuaNodeIdServicesVariableWriter = 17878
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_FailedTransmissions_Classification                                       OpcuaNodeIdServicesVariableWriter = 17885
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_FailedTransmissions_DiagnosticsLevel                                     OpcuaNodeIdServicesVariableWriter = 17892
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_FailedTransmissions_TimeFirstChange                                      OpcuaNodeIdServicesVariableWriter = 17899
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_EncryptionErrors                                                         OpcuaNodeIdServicesVariableWriter = 17900
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_EncryptionErrors_Active                                                  OpcuaNodeIdServicesVariableWriter = 17901
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_EncryptionErrors_Classification                                          OpcuaNodeIdServicesVariableWriter = 17902
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_EncryptionErrors_DiagnosticsLevel                                        OpcuaNodeIdServicesVariableWriter = 17903
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_EncryptionErrors_TimeFirstChange                                         OpcuaNodeIdServicesVariableWriter = 17906
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_ConfiguredDataSetWriters                                               OpcuaNodeIdServicesVariableWriter = 17913
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel                              OpcuaNodeIdServicesVariableWriter = 17920
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_OperationalDataSetWriters                                              OpcuaNodeIdServicesVariableWriter = 17927
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel                             OpcuaNodeIdServicesVariableWriter = 17934
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_SecurityTokenID                                                        OpcuaNodeIdServicesVariableWriter = 17941
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_SecurityTokenID_DiagnosticsLevel                                       OpcuaNodeIdServicesVariableWriter = 17948
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_TimeToNextTokenID                                                      OpcuaNodeIdServicesVariableWriter = 17955
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_TimeToNextTokenID_DiagnosticsLevel                                     OpcuaNodeIdServicesVariableWriter = 17962
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_AddDataSetWriter_InputArguments                                                               OpcuaNodeIdServicesVariableWriter = 17976
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_AddDataSetWriter_OutputArguments                                                              OpcuaNodeIdServicesVariableWriter = 17987
	OpcuaNodeIdServicesVariableWriter_WriterGroupType_RemoveDataSetWriter_InputArguments                                                            OpcuaNodeIdServicesVariableWriter = 17993
)

var OpcuaNodeIdServicesVariableWriterValues []OpcuaNodeIdServicesVariableWriter

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableWriterValues = []OpcuaNodeIdServicesVariableWriter{
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_DataSetWriterProperties,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_HeaderLayoutUri,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_WriterGroupId,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_PublishingInterval,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_KeepAliveTime,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Priority,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_LocaleIds,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_DataSetWriterId,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_DataSetFieldContentMask,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_KeyFrameCount,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Status_State,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_SubError,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalInformation,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalInformation_Active,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalInformation_Classification,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalInformation_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalInformation_TimeFirstChange,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalError,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalError_Active,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalError_Classification,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalError_TimeFirstChange,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_SubError,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateError,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateError_Active,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateError_Classification,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateError_TimeFirstChange,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByMethod,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_Active,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_Classification,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByParent,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByParent_Active,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByParent_Classification,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalFromError,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalFromError_Active,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalFromError_Classification,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StatePausedByParent,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StatePausedByParent_Active,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StatePausedByParent_Classification,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StatePausedByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateDisabledByMethod,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_Active,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_Classification,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_SentNetworkMessages,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_SentNetworkMessages_Active,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_SentNetworkMessages_Classification,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_SentNetworkMessages_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_SentNetworkMessages_TimeFirstChange,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_FailedTransmissions,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_FailedTransmissions_Active,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_FailedTransmissions_Classification,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_FailedTransmissions_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_FailedTransmissions_TimeFirstChange,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_EncryptionErrors,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_EncryptionErrors_Active,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_EncryptionErrors_Classification,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_EncryptionErrors_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_EncryptionErrors_TimeFirstChange,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_ConfiguredDataSetWriters,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_OperationalDataSetWriters,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_SecurityTokenID,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_SecurityTokenID_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_TimeToNextTokenID,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_TimeToNextTokenID_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_AddDataSetWriter_InputArguments,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_AddDataSetWriter_OutputArguments,
		OpcuaNodeIdServicesVariableWriter_WriterGroupType_RemoveDataSetWriter_InputArguments,
	}
}

func OpcuaNodeIdServicesVariableWriterByValue(value int32) (enum OpcuaNodeIdServicesVariableWriter, ok bool) {
	switch value {
	case 17490:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_DataSetWriterProperties, true
	case 17559:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_HeaderLayoutUri, true
	case 17736:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_WriterGroupId, true
	case 17737:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_PublishingInterval, true
	case 17738:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_KeepAliveTime, true
	case 17739:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Priority, true
	case 17740:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_LocaleIds, true
	case 17744:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_DataSetWriterId, true
	case 17745:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_DataSetFieldContentMask, true
	case 17746:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_KeyFrameCount, true
	case 17750:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Status_State, true
	case 17754:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel, true
	case 17755:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation, true
	case 17756:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active, true
	case 17757:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification, true
	case 17758:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel, true
	case 17759:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange, true
	case 17760:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError, true
	case 17761:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active, true
	case 17762:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification, true
	case 17763:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel, true
	case 17764:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange, true
	case 17766:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_SubError, true
	case 17768:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError, true
	case 17769:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active, true
	case 17770:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification, true
	case 17771:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel, true
	case 17772:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange, true
	case 17773:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod, true
	case 17774:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active, true
	case 17775:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification, true
	case 17776:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case 17777:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange, true
	case 17778:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent, true
	case 17779:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active, true
	case 17780:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification, true
	case 17781:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case 17782:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange, true
	case 17783:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError, true
	case 17784:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active, true
	case 17785:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification, true
	case 17786:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case 17787:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange, true
	case 17788:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent, true
	case 17789:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active, true
	case 17790:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification, true
	case 17791:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel, true
	case 17792:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange, true
	case 17793:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod, true
	case 17794:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active, true
	case 17795:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification, true
	case 17796:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case 17797:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange, true
	case 17799:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages, true
	case 17800:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active, true
	case 17801:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification, true
	case 17802:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel, true
	case 17803:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange, true
	case 17804:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber, true
	case 17805:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel, true
	case 17806:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode, true
	case 17807:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel, true
	case 17808:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion, true
	case 17809:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel, true
	case 17810:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion, true
	case 17811:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel, true
	case 17813:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_DiagnosticsLevel, true
	case 17814:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalInformation, true
	case 17815:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalInformation_Active, true
	case 17816:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalInformation_Classification, true
	case 17817:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalInformation_DiagnosticsLevel, true
	case 17818:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalInformation_TimeFirstChange, true
	case 17819:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalError, true
	case 17820:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalError_Active, true
	case 17821:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalError_Classification, true
	case 17822:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalError_DiagnosticsLevel, true
	case 17823:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalError_TimeFirstChange, true
	case 17825:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_SubError, true
	case 17827:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateError, true
	case 17828:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateError_Active, true
	case 17829:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateError_Classification, true
	case 17830:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateError_DiagnosticsLevel, true
	case 17831:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateError_TimeFirstChange, true
	case 17832:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByMethod, true
	case 17833:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_Active, true
	case 17834:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_Classification, true
	case 17835:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case 17836:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange, true
	case 17837:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByParent, true
	case 17838:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByParent_Active, true
	case 17839:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByParent_Classification, true
	case 17840:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case 17841:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange, true
	case 17842:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalFromError, true
	case 17843:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalFromError_Active, true
	case 17844:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalFromError_Classification, true
	case 17845:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case 17846:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange, true
	case 17847:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StatePausedByParent, true
	case 17848:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StatePausedByParent_Active, true
	case 17849:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StatePausedByParent_Classification, true
	case 17850:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel, true
	case 17851:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StatePausedByParent_TimeFirstChange, true
	case 17853:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateDisabledByMethod, true
	case 17854:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_Active, true
	case 17855:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_Classification, true
	case 17856:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case 17857:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange, true
	case 17859:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_SentNetworkMessages, true
	case 17864:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_SentNetworkMessages_Active, true
	case 17871:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_SentNetworkMessages_Classification, true
	case 17872:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_SentNetworkMessages_DiagnosticsLevel, true
	case 17873:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_SentNetworkMessages_TimeFirstChange, true
	case 17874:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_FailedTransmissions, true
	case 17878:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_FailedTransmissions_Active, true
	case 17885:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_FailedTransmissions_Classification, true
	case 17892:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_FailedTransmissions_DiagnosticsLevel, true
	case 17899:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_FailedTransmissions_TimeFirstChange, true
	case 17900:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_EncryptionErrors, true
	case 17901:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_EncryptionErrors_Active, true
	case 17902:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_EncryptionErrors_Classification, true
	case 17903:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_EncryptionErrors_DiagnosticsLevel, true
	case 17906:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_EncryptionErrors_TimeFirstChange, true
	case 17913:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_ConfiguredDataSetWriters, true
	case 17920:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel, true
	case 17927:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_OperationalDataSetWriters, true
	case 17934:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel, true
	case 17941:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_SecurityTokenID, true
	case 17948:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_SecurityTokenID_DiagnosticsLevel, true
	case 17955:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_TimeToNextTokenID, true
	case 17962:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_TimeToNextTokenID_DiagnosticsLevel, true
	case 17976:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_AddDataSetWriter_InputArguments, true
	case 17987:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_AddDataSetWriter_OutputArguments, true
	case 17993:
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_RemoveDataSetWriter_InputArguments, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableWriterByName(value string) (enum OpcuaNodeIdServicesVariableWriter, ok bool) {
	switch value {
	case "WriterGroupType_DataSetWriterName_Placeholder_DataSetWriterProperties":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_DataSetWriterProperties, true
	case "WriterGroupType_HeaderLayoutUri":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_HeaderLayoutUri, true
	case "WriterGroupType_WriterGroupId":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_WriterGroupId, true
	case "WriterGroupType_PublishingInterval":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_PublishingInterval, true
	case "WriterGroupType_KeepAliveTime":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_KeepAliveTime, true
	case "WriterGroupType_Priority":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Priority, true
	case "WriterGroupType_LocaleIds":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_LocaleIds, true
	case "WriterGroupType_DataSetWriterName_Placeholder_DataSetWriterId":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_DataSetWriterId, true
	case "WriterGroupType_DataSetWriterName_Placeholder_DataSetFieldContentMask":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_DataSetFieldContentMask, true
	case "WriterGroupType_DataSetWriterName_Placeholder_KeyFrameCount":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_KeyFrameCount, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Status_State":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Status_State, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_SubError":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_SubError, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel, true
	case "WriterGroupType_Diagnostics_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_DiagnosticsLevel, true
	case "WriterGroupType_Diagnostics_TotalInformation":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalInformation, true
	case "WriterGroupType_Diagnostics_TotalInformation_Active":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalInformation_Active, true
	case "WriterGroupType_Diagnostics_TotalInformation_Classification":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalInformation_Classification, true
	case "WriterGroupType_Diagnostics_TotalInformation_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalInformation_DiagnosticsLevel, true
	case "WriterGroupType_Diagnostics_TotalInformation_TimeFirstChange":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalInformation_TimeFirstChange, true
	case "WriterGroupType_Diagnostics_TotalError":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalError, true
	case "WriterGroupType_Diagnostics_TotalError_Active":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalError_Active, true
	case "WriterGroupType_Diagnostics_TotalError_Classification":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalError_Classification, true
	case "WriterGroupType_Diagnostics_TotalError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalError_DiagnosticsLevel, true
	case "WriterGroupType_Diagnostics_TotalError_TimeFirstChange":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalError_TimeFirstChange, true
	case "WriterGroupType_Diagnostics_SubError":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_SubError, true
	case "WriterGroupType_Diagnostics_Counters_StateError":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateError, true
	case "WriterGroupType_Diagnostics_Counters_StateError_Active":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateError_Active, true
	case "WriterGroupType_Diagnostics_Counters_StateError_Classification":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateError_Classification, true
	case "WriterGroupType_Diagnostics_Counters_StateError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateError_DiagnosticsLevel, true
	case "WriterGroupType_Diagnostics_Counters_StateError_TimeFirstChange":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateError_TimeFirstChange, true
	case "WriterGroupType_Diagnostics_Counters_StateOperationalByMethod":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByMethod, true
	case "WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_Active":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_Active, true
	case "WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_Classification":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_Classification, true
	case "WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case "WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange, true
	case "WriterGroupType_Diagnostics_Counters_StateOperationalByParent":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByParent, true
	case "WriterGroupType_Diagnostics_Counters_StateOperationalByParent_Active":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByParent_Active, true
	case "WriterGroupType_Diagnostics_Counters_StateOperationalByParent_Classification":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByParent_Classification, true
	case "WriterGroupType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case "WriterGroupType_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange, true
	case "WriterGroupType_Diagnostics_Counters_StateOperationalFromError":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalFromError, true
	case "WriterGroupType_Diagnostics_Counters_StateOperationalFromError_Active":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalFromError_Active, true
	case "WriterGroupType_Diagnostics_Counters_StateOperationalFromError_Classification":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalFromError_Classification, true
	case "WriterGroupType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case "WriterGroupType_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange, true
	case "WriterGroupType_Diagnostics_Counters_StatePausedByParent":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StatePausedByParent, true
	case "WriterGroupType_Diagnostics_Counters_StatePausedByParent_Active":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StatePausedByParent_Active, true
	case "WriterGroupType_Diagnostics_Counters_StatePausedByParent_Classification":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StatePausedByParent_Classification, true
	case "WriterGroupType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel, true
	case "WriterGroupType_Diagnostics_Counters_StatePausedByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StatePausedByParent_TimeFirstChange, true
	case "WriterGroupType_Diagnostics_Counters_StateDisabledByMethod":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateDisabledByMethod, true
	case "WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_Active":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_Active, true
	case "WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_Classification":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_Classification, true
	case "WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case "WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange, true
	case "WriterGroupType_Diagnostics_Counters_SentNetworkMessages":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_SentNetworkMessages, true
	case "WriterGroupType_Diagnostics_Counters_SentNetworkMessages_Active":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_SentNetworkMessages_Active, true
	case "WriterGroupType_Diagnostics_Counters_SentNetworkMessages_Classification":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_SentNetworkMessages_Classification, true
	case "WriterGroupType_Diagnostics_Counters_SentNetworkMessages_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_SentNetworkMessages_DiagnosticsLevel, true
	case "WriterGroupType_Diagnostics_Counters_SentNetworkMessages_TimeFirstChange":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_SentNetworkMessages_TimeFirstChange, true
	case "WriterGroupType_Diagnostics_Counters_FailedTransmissions":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_FailedTransmissions, true
	case "WriterGroupType_Diagnostics_Counters_FailedTransmissions_Active":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_FailedTransmissions_Active, true
	case "WriterGroupType_Diagnostics_Counters_FailedTransmissions_Classification":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_FailedTransmissions_Classification, true
	case "WriterGroupType_Diagnostics_Counters_FailedTransmissions_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_FailedTransmissions_DiagnosticsLevel, true
	case "WriterGroupType_Diagnostics_Counters_FailedTransmissions_TimeFirstChange":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_FailedTransmissions_TimeFirstChange, true
	case "WriterGroupType_Diagnostics_Counters_EncryptionErrors":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_EncryptionErrors, true
	case "WriterGroupType_Diagnostics_Counters_EncryptionErrors_Active":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_EncryptionErrors_Active, true
	case "WriterGroupType_Diagnostics_Counters_EncryptionErrors_Classification":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_EncryptionErrors_Classification, true
	case "WriterGroupType_Diagnostics_Counters_EncryptionErrors_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_EncryptionErrors_DiagnosticsLevel, true
	case "WriterGroupType_Diagnostics_Counters_EncryptionErrors_TimeFirstChange":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_EncryptionErrors_TimeFirstChange, true
	case "WriterGroupType_Diagnostics_LiveValues_ConfiguredDataSetWriters":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_ConfiguredDataSetWriters, true
	case "WriterGroupType_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel, true
	case "WriterGroupType_Diagnostics_LiveValues_OperationalDataSetWriters":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_OperationalDataSetWriters, true
	case "WriterGroupType_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel, true
	case "WriterGroupType_Diagnostics_LiveValues_SecurityTokenID":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_SecurityTokenID, true
	case "WriterGroupType_Diagnostics_LiveValues_SecurityTokenID_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_SecurityTokenID_DiagnosticsLevel, true
	case "WriterGroupType_Diagnostics_LiveValues_TimeToNextTokenID":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_TimeToNextTokenID, true
	case "WriterGroupType_Diagnostics_LiveValues_TimeToNextTokenID_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_TimeToNextTokenID_DiagnosticsLevel, true
	case "WriterGroupType_AddDataSetWriter_InputArguments":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_AddDataSetWriter_InputArguments, true
	case "WriterGroupType_AddDataSetWriter_OutputArguments":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_AddDataSetWriter_OutputArguments, true
	case "WriterGroupType_RemoveDataSetWriter_InputArguments":
		return OpcuaNodeIdServicesVariableWriter_WriterGroupType_RemoveDataSetWriter_InputArguments, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableWriterKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableWriterValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableWriter(structType any) OpcuaNodeIdServicesVariableWriter {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableWriter {
		if sOpcuaNodeIdServicesVariableWriter, ok := typ.(OpcuaNodeIdServicesVariableWriter); ok {
			return sOpcuaNodeIdServicesVariableWriter
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableWriter) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableWriter) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableWriterParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableWriter, error) {
	return OpcuaNodeIdServicesVariableWriterParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableWriterParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableWriter, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableWriter", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableWriter")
	}
	if enum, ok := OpcuaNodeIdServicesVariableWriterByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableWriter")
		return OpcuaNodeIdServicesVariableWriter(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableWriter) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableWriter) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableWriter", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableWriter) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_DataSetWriterProperties:
		return "WriterGroupType_DataSetWriterName_Placeholder_DataSetWriterProperties"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_HeaderLayoutUri:
		return "WriterGroupType_HeaderLayoutUri"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_WriterGroupId:
		return "WriterGroupType_WriterGroupId"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_PublishingInterval:
		return "WriterGroupType_PublishingInterval"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_KeepAliveTime:
		return "WriterGroupType_KeepAliveTime"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Priority:
		return "WriterGroupType_Priority"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_LocaleIds:
		return "WriterGroupType_LocaleIds"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_DataSetWriterId:
		return "WriterGroupType_DataSetWriterName_Placeholder_DataSetWriterId"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_DataSetFieldContentMask:
		return "WriterGroupType_DataSetWriterName_Placeholder_DataSetFieldContentMask"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_KeyFrameCount:
		return "WriterGroupType_DataSetWriterName_Placeholder_KeyFrameCount"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Status_State:
		return "WriterGroupType_DataSetWriterName_Placeholder_Status_State"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_SubError:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_SubError"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_DiagnosticsLevel:
		return "WriterGroupType_Diagnostics_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalInformation:
		return "WriterGroupType_Diagnostics_TotalInformation"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalInformation_Active:
		return "WriterGroupType_Diagnostics_TotalInformation_Active"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalInformation_Classification:
		return "WriterGroupType_Diagnostics_TotalInformation_Classification"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalInformation_DiagnosticsLevel:
		return "WriterGroupType_Diagnostics_TotalInformation_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalInformation_TimeFirstChange:
		return "WriterGroupType_Diagnostics_TotalInformation_TimeFirstChange"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalError:
		return "WriterGroupType_Diagnostics_TotalError"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalError_Active:
		return "WriterGroupType_Diagnostics_TotalError_Active"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalError_Classification:
		return "WriterGroupType_Diagnostics_TotalError_Classification"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalError_DiagnosticsLevel:
		return "WriterGroupType_Diagnostics_TotalError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_TotalError_TimeFirstChange:
		return "WriterGroupType_Diagnostics_TotalError_TimeFirstChange"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_SubError:
		return "WriterGroupType_Diagnostics_SubError"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateError:
		return "WriterGroupType_Diagnostics_Counters_StateError"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateError_Active:
		return "WriterGroupType_Diagnostics_Counters_StateError_Active"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateError_Classification:
		return "WriterGroupType_Diagnostics_Counters_StateError_Classification"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateError_DiagnosticsLevel:
		return "WriterGroupType_Diagnostics_Counters_StateError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateError_TimeFirstChange:
		return "WriterGroupType_Diagnostics_Counters_StateError_TimeFirstChange"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByMethod:
		return "WriterGroupType_Diagnostics_Counters_StateOperationalByMethod"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_Active:
		return "WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_Active"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_Classification:
		return "WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_Classification"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel:
		return "WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange:
		return "WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByParent:
		return "WriterGroupType_Diagnostics_Counters_StateOperationalByParent"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByParent_Active:
		return "WriterGroupType_Diagnostics_Counters_StateOperationalByParent_Active"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByParent_Classification:
		return "WriterGroupType_Diagnostics_Counters_StateOperationalByParent_Classification"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel:
		return "WriterGroupType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange:
		return "WriterGroupType_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalFromError:
		return "WriterGroupType_Diagnostics_Counters_StateOperationalFromError"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalFromError_Active:
		return "WriterGroupType_Diagnostics_Counters_StateOperationalFromError_Active"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalFromError_Classification:
		return "WriterGroupType_Diagnostics_Counters_StateOperationalFromError_Classification"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel:
		return "WriterGroupType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange:
		return "WriterGroupType_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StatePausedByParent:
		return "WriterGroupType_Diagnostics_Counters_StatePausedByParent"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StatePausedByParent_Active:
		return "WriterGroupType_Diagnostics_Counters_StatePausedByParent_Active"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StatePausedByParent_Classification:
		return "WriterGroupType_Diagnostics_Counters_StatePausedByParent_Classification"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel:
		return "WriterGroupType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StatePausedByParent_TimeFirstChange:
		return "WriterGroupType_Diagnostics_Counters_StatePausedByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateDisabledByMethod:
		return "WriterGroupType_Diagnostics_Counters_StateDisabledByMethod"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_Active:
		return "WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_Active"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_Classification:
		return "WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_Classification"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel:
		return "WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange:
		return "WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_SentNetworkMessages:
		return "WriterGroupType_Diagnostics_Counters_SentNetworkMessages"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_SentNetworkMessages_Active:
		return "WriterGroupType_Diagnostics_Counters_SentNetworkMessages_Active"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_SentNetworkMessages_Classification:
		return "WriterGroupType_Diagnostics_Counters_SentNetworkMessages_Classification"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_SentNetworkMessages_DiagnosticsLevel:
		return "WriterGroupType_Diagnostics_Counters_SentNetworkMessages_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_SentNetworkMessages_TimeFirstChange:
		return "WriterGroupType_Diagnostics_Counters_SentNetworkMessages_TimeFirstChange"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_FailedTransmissions:
		return "WriterGroupType_Diagnostics_Counters_FailedTransmissions"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_FailedTransmissions_Active:
		return "WriterGroupType_Diagnostics_Counters_FailedTransmissions_Active"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_FailedTransmissions_Classification:
		return "WriterGroupType_Diagnostics_Counters_FailedTransmissions_Classification"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_FailedTransmissions_DiagnosticsLevel:
		return "WriterGroupType_Diagnostics_Counters_FailedTransmissions_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_FailedTransmissions_TimeFirstChange:
		return "WriterGroupType_Diagnostics_Counters_FailedTransmissions_TimeFirstChange"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_EncryptionErrors:
		return "WriterGroupType_Diagnostics_Counters_EncryptionErrors"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_EncryptionErrors_Active:
		return "WriterGroupType_Diagnostics_Counters_EncryptionErrors_Active"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_EncryptionErrors_Classification:
		return "WriterGroupType_Diagnostics_Counters_EncryptionErrors_Classification"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_EncryptionErrors_DiagnosticsLevel:
		return "WriterGroupType_Diagnostics_Counters_EncryptionErrors_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_Counters_EncryptionErrors_TimeFirstChange:
		return "WriterGroupType_Diagnostics_Counters_EncryptionErrors_TimeFirstChange"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_ConfiguredDataSetWriters:
		return "WriterGroupType_Diagnostics_LiveValues_ConfiguredDataSetWriters"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel:
		return "WriterGroupType_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_OperationalDataSetWriters:
		return "WriterGroupType_Diagnostics_LiveValues_OperationalDataSetWriters"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel:
		return "WriterGroupType_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_SecurityTokenID:
		return "WriterGroupType_Diagnostics_LiveValues_SecurityTokenID"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_SecurityTokenID_DiagnosticsLevel:
		return "WriterGroupType_Diagnostics_LiveValues_SecurityTokenID_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_TimeToNextTokenID:
		return "WriterGroupType_Diagnostics_LiveValues_TimeToNextTokenID"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_Diagnostics_LiveValues_TimeToNextTokenID_DiagnosticsLevel:
		return "WriterGroupType_Diagnostics_LiveValues_TimeToNextTokenID_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_AddDataSetWriter_InputArguments:
		return "WriterGroupType_AddDataSetWriter_InputArguments"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_AddDataSetWriter_OutputArguments:
		return "WriterGroupType_AddDataSetWriter_OutputArguments"
	case OpcuaNodeIdServicesVariableWriter_WriterGroupType_RemoveDataSetWriter_InputArguments:
		return "WriterGroupType_RemoveDataSetWriter_InputArguments"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableWriter) String() string {
	return e.PLC4XEnumName()
}
