/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableTrip is an enum
type OpcuaNodeIdServicesVariableTrip int32

type IOpcuaNodeIdServicesVariableTrip interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_EventId                                              OpcuaNodeIdServicesVariableTrip = 10752
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_EventType                                            OpcuaNodeIdServicesVariableTrip = 10753
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_SourceNode                                           OpcuaNodeIdServicesVariableTrip = 10754
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_SourceName                                           OpcuaNodeIdServicesVariableTrip = 10755
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_Time                                                 OpcuaNodeIdServicesVariableTrip = 10756
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ReceiveTime                                          OpcuaNodeIdServicesVariableTrip = 10757
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_LocalTime                                            OpcuaNodeIdServicesVariableTrip = 10758
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_Message                                              OpcuaNodeIdServicesVariableTrip = 10759
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_Severity                                             OpcuaNodeIdServicesVariableTrip = 10760
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConditionName                                        OpcuaNodeIdServicesVariableTrip = 10761
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_BranchId                                             OpcuaNodeIdServicesVariableTrip = 10762
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_Retain                                               OpcuaNodeIdServicesVariableTrip = 10763
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState                                         OpcuaNodeIdServicesVariableTrip = 10764
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_Id                                      OpcuaNodeIdServicesVariableTrip = 10765
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_Name                                    OpcuaNodeIdServicesVariableTrip = 10766
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_Number                                  OpcuaNodeIdServicesVariableTrip = 10767
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableTrip = 10768
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_TransitionTime                          OpcuaNodeIdServicesVariableTrip = 10769
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableTrip = 10770
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_TrueState                               OpcuaNodeIdServicesVariableTrip = 10771
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_FalseState                              OpcuaNodeIdServicesVariableTrip = 10772
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_Quality                                              OpcuaNodeIdServicesVariableTrip = 10773
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_Quality_SourceTimestamp                              OpcuaNodeIdServicesVariableTrip = 10774
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_LastSeverity                                         OpcuaNodeIdServicesVariableTrip = 10775
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_LastSeverity_SourceTimestamp                         OpcuaNodeIdServicesVariableTrip = 10776
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_Comment                                              OpcuaNodeIdServicesVariableTrip = 10777
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_Comment_SourceTimestamp                              OpcuaNodeIdServicesVariableTrip = 10778
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ClientUserId                                         OpcuaNodeIdServicesVariableTrip = 10779
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_AddComment_InputArguments                            OpcuaNodeIdServicesVariableTrip = 10783
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConditionRefresh_InputArguments                      OpcuaNodeIdServicesVariableTrip = 10785
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState                                           OpcuaNodeIdServicesVariableTrip = 10786
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_Id                                        OpcuaNodeIdServicesVariableTrip = 10787
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_Name                                      OpcuaNodeIdServicesVariableTrip = 10788
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_Number                                    OpcuaNodeIdServicesVariableTrip = 10789
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableTrip = 10790
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_TransitionTime                            OpcuaNodeIdServicesVariableTrip = 10791
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableTrip = 10792
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_TrueState                                 OpcuaNodeIdServicesVariableTrip = 10793
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_FalseState                                OpcuaNodeIdServicesVariableTrip = 10794
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState                                       OpcuaNodeIdServicesVariableTrip = 10795
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_Id                                    OpcuaNodeIdServicesVariableTrip = 10796
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_Name                                  OpcuaNodeIdServicesVariableTrip = 10797
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_Number                                OpcuaNodeIdServicesVariableTrip = 10798
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_EffectiveDisplayName                  OpcuaNodeIdServicesVariableTrip = 10799
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_TransitionTime                        OpcuaNodeIdServicesVariableTrip = 10800
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_EffectiveTransitionTime               OpcuaNodeIdServicesVariableTrip = 10801
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_TrueState                             OpcuaNodeIdServicesVariableTrip = 10802
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_FalseState                            OpcuaNodeIdServicesVariableTrip = 10803
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_Acknowledge_InputArguments                           OpcuaNodeIdServicesVariableTrip = 10805
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_Confirm_InputArguments                               OpcuaNodeIdServicesVariableTrip = 10807
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState                                          OpcuaNodeIdServicesVariableTrip = 10808
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_Id                                       OpcuaNodeIdServicesVariableTrip = 10809
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_Name                                     OpcuaNodeIdServicesVariableTrip = 10810
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_Number                                   OpcuaNodeIdServicesVariableTrip = 10811
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_EffectiveDisplayName                     OpcuaNodeIdServicesVariableTrip = 10812
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_TransitionTime                           OpcuaNodeIdServicesVariableTrip = 10813
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_EffectiveTransitionTime                  OpcuaNodeIdServicesVariableTrip = 10814
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_TrueState                                OpcuaNodeIdServicesVariableTrip = 10815
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_FalseState                               OpcuaNodeIdServicesVariableTrip = 10816
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState                                      OpcuaNodeIdServicesVariableTrip = 10817
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_Id                                   OpcuaNodeIdServicesVariableTrip = 10818
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_Name                                 OpcuaNodeIdServicesVariableTrip = 10819
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_Number                               OpcuaNodeIdServicesVariableTrip = 10820
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_EffectiveDisplayName                 OpcuaNodeIdServicesVariableTrip = 10821
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_TransitionTime                       OpcuaNodeIdServicesVariableTrip = 10822
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_EffectiveTransitionTime              OpcuaNodeIdServicesVariableTrip = 10823
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_TrueState                            OpcuaNodeIdServicesVariableTrip = 10824
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_FalseState                           OpcuaNodeIdServicesVariableTrip = 10825
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_CurrentState                           OpcuaNodeIdServicesVariableTrip = 10827
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_CurrentState_Id                        OpcuaNodeIdServicesVariableTrip = 10828
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_CurrentState_Name                      OpcuaNodeIdServicesVariableTrip = 10829
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_CurrentState_Number                    OpcuaNodeIdServicesVariableTrip = 10830
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_CurrentState_EffectiveDisplayName      OpcuaNodeIdServicesVariableTrip = 10831
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_LastTransition                         OpcuaNodeIdServicesVariableTrip = 10832
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_LastTransition_Id                      OpcuaNodeIdServicesVariableTrip = 10833
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_LastTransition_Name                    OpcuaNodeIdServicesVariableTrip = 10834
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_LastTransition_Number                  OpcuaNodeIdServicesVariableTrip = 10835
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_LastTransition_TransitionTime          OpcuaNodeIdServicesVariableTrip = 10836
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_UnshelveTime                           OpcuaNodeIdServicesVariableTrip = 10837
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_TimedShelve_InputArguments             OpcuaNodeIdServicesVariableTrip = 10862
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedOrShelved                                  OpcuaNodeIdServicesVariableTrip = 10863
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_MaxTimeShelved                                       OpcuaNodeIdServicesVariableTrip = 10864
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConditionClassId                                     OpcuaNodeIdServicesVariableTrip = 11159
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConditionClassName                                   OpcuaNodeIdServicesVariableTrip = 11160
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_InputNode                                            OpcuaNodeIdServicesVariableTrip = 11161
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_NormalState                                          OpcuaNodeIdServicesVariableTrip = 11162
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime OpcuaNodeIdServicesVariableTrip = 11483
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConditionRefresh2_InputArguments                     OpcuaNodeIdServicesVariableTrip = 13011
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConditionSubClassId                                  OpcuaNodeIdServicesVariableTrip = 17008
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConditionSubClassName                                OpcuaNodeIdServicesVariableTrip = 17009
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState                                    OpcuaNodeIdServicesVariableTrip = 17010
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_Id                                 OpcuaNodeIdServicesVariableTrip = 17011
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_Name                               OpcuaNodeIdServicesVariableTrip = 17012
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_Number                             OpcuaNodeIdServicesVariableTrip = 17013
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_EffectiveDisplayName               OpcuaNodeIdServicesVariableTrip = 17014
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_TransitionTime                     OpcuaNodeIdServicesVariableTrip = 17015
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_EffectiveTransitionTime            OpcuaNodeIdServicesVariableTrip = 17016
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_TrueState                          OpcuaNodeIdServicesVariableTrip = 17017
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_FalseState                         OpcuaNodeIdServicesVariableTrip = 17018
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState                                         OpcuaNodeIdServicesVariableTrip = 17019
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_Id                                      OpcuaNodeIdServicesVariableTrip = 17020
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_Name                                    OpcuaNodeIdServicesVariableTrip = 17021
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_Number                                  OpcuaNodeIdServicesVariableTrip = 17022
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableTrip = 17023
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_TransitionTime                          OpcuaNodeIdServicesVariableTrip = 17024
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableTrip = 17025
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_TrueState                               OpcuaNodeIdServicesVariableTrip = 17026
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_FalseState                              OpcuaNodeIdServicesVariableTrip = 17027
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_AudibleEnabled                                       OpcuaNodeIdServicesVariableTrip = 17028
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_AudibleSound                                         OpcuaNodeIdServicesVariableTrip = 17029
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_OnDelay                                              OpcuaNodeIdServicesVariableTrip = 17034
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_OffDelay                                             OpcuaNodeIdServicesVariableTrip = 17035
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_FirstInGroupFlag                                     OpcuaNodeIdServicesVariableTrip = 17036
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ReAlarmTime                                          OpcuaNodeIdServicesVariableTrip = 17039
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ReAlarmRepeatCount                                   OpcuaNodeIdServicesVariableTrip = 17040
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_AvailableStates                        OpcuaNodeIdServicesVariableTrip = 17698
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_AvailableTransitions                   OpcuaNodeIdServicesVariableTrip = 17699
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_AudibleSound_ListId                                  OpcuaNodeIdServicesVariableTrip = 17963
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_AudibleSound_AgencyId                                OpcuaNodeIdServicesVariableTrip = 17964
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_AudibleSound_VersionId                               OpcuaNodeIdServicesVariableTrip = 17965
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState                                         OpcuaNodeIdServicesVariableTrip = 18337
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_Id                                      OpcuaNodeIdServicesVariableTrip = 18338
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_Name                                    OpcuaNodeIdServicesVariableTrip = 18339
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_Number                                  OpcuaNodeIdServicesVariableTrip = 18340
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableTrip = 18341
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_TransitionTime                          OpcuaNodeIdServicesVariableTrip = 18342
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableTrip = 18343
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_TrueState                               OpcuaNodeIdServicesVariableTrip = 18344
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_FalseState                              OpcuaNodeIdServicesVariableTrip = 18345
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_Suppress2_InputArguments                             OpcuaNodeIdServicesVariableTrip = 24459
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_Unsuppress2_InputArguments                           OpcuaNodeIdServicesVariableTrip = 24461
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_RemoveFromService2_InputArguments                    OpcuaNodeIdServicesVariableTrip = 24463
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_PlaceInService2_InputArguments                       OpcuaNodeIdServicesVariableTrip = 24465
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_Reset2_InputArguments                                OpcuaNodeIdServicesVariableTrip = 24467
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_TimedShelve2_InputArguments            OpcuaNodeIdServicesVariableTrip = 24931
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_Unshelve2_InputArguments               OpcuaNodeIdServicesVariableTrip = 24933
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_OneShotShelve2_InputArguments          OpcuaNodeIdServicesVariableTrip = 24935
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_GetGroupMemberships_OutputArguments                  OpcuaNodeIdServicesVariableTrip = 25171
	OpcuaNodeIdServicesVariableTrip_TripAlarmType_SupportsFilteredRetain                               OpcuaNodeIdServicesVariableTrip = 32239
)

var OpcuaNodeIdServicesVariableTripValues []OpcuaNodeIdServicesVariableTrip

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableTripValues = []OpcuaNodeIdServicesVariableTrip{
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_EventId,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_EventType,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_SourceNode,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_SourceName,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_Time,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ReceiveTime,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_LocalTime,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_Message,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_Severity,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConditionName,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_BranchId,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_Retain,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_Id,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_Name,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_Number,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_Quality,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_LastSeverity,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_Comment,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ClientUserId,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConditionRefresh_InputArguments,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_Id,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_Name,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_Number,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_TrueState,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_FalseState,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_Id,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_Name,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_Number,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_Id,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_Name,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_Number,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_MaxTimeShelved,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConditionClassId,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConditionClassName,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_InputNode,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_NormalState,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConditionRefresh2_InputArguments,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_Id,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_Name,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_Number,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_AudibleEnabled,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_AudibleSound,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_OnDelay,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_OffDelay,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ReAlarmTime,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_Id,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_Name,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_Number,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableTrip_TripAlarmType_SupportsFilteredRetain,
	}
}

func OpcuaNodeIdServicesVariableTripByValue(value int32) (enum OpcuaNodeIdServicesVariableTrip, ok bool) {
	switch value {
	case 10752:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_EventId, true
	case 10753:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_EventType, true
	case 10754:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SourceNode, true
	case 10755:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SourceName, true
	case 10756:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_Time, true
	case 10757:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ReceiveTime, true
	case 10758:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_LocalTime, true
	case 10759:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_Message, true
	case 10760:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_Severity, true
	case 10761:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConditionName, true
	case 10762:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_BranchId, true
	case 10763:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_Retain, true
	case 10764:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState, true
	case 10765:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_Id, true
	case 10766:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_Name, true
	case 10767:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_Number, true
	case 10768:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_EffectiveDisplayName, true
	case 10769:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_TransitionTime, true
	case 10770:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_EffectiveTransitionTime, true
	case 10771:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_TrueState, true
	case 10772:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_FalseState, true
	case 10773:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_Quality, true
	case 10774:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_Quality_SourceTimestamp, true
	case 10775:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_LastSeverity, true
	case 10776:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_LastSeverity_SourceTimestamp, true
	case 10777:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_Comment, true
	case 10778:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_Comment_SourceTimestamp, true
	case 10779:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ClientUserId, true
	case 10783:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_AddComment_InputArguments, true
	case 10785:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConditionRefresh_InputArguments, true
	case 10786:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState, true
	case 10787:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_Id, true
	case 10788:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_Name, true
	case 10789:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_Number, true
	case 10790:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_EffectiveDisplayName, true
	case 10791:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_TransitionTime, true
	case 10792:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_EffectiveTransitionTime, true
	case 10793:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_TrueState, true
	case 10794:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_FalseState, true
	case 10795:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState, true
	case 10796:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_Id, true
	case 10797:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_Name, true
	case 10798:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_Number, true
	case 10799:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_EffectiveDisplayName, true
	case 10800:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_TransitionTime, true
	case 10801:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_EffectiveTransitionTime, true
	case 10802:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_TrueState, true
	case 10803:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_FalseState, true
	case 10805:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_Acknowledge_InputArguments, true
	case 10807:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_Confirm_InputArguments, true
	case 10808:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState, true
	case 10809:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_Id, true
	case 10810:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_Name, true
	case 10811:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_Number, true
	case 10812:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_EffectiveDisplayName, true
	case 10813:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_TransitionTime, true
	case 10814:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_EffectiveTransitionTime, true
	case 10815:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_TrueState, true
	case 10816:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_FalseState, true
	case 10817:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState, true
	case 10818:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_Id, true
	case 10819:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_Name, true
	case 10820:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_Number, true
	case 10821:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_EffectiveDisplayName, true
	case 10822:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_TransitionTime, true
	case 10823:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_EffectiveTransitionTime, true
	case 10824:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_TrueState, true
	case 10825:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_FalseState, true
	case 10827:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_CurrentState, true
	case 10828:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_CurrentState_Id, true
	case 10829:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_CurrentState_Name, true
	case 10830:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_CurrentState_Number, true
	case 10831:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 10832:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_LastTransition, true
	case 10833:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_LastTransition_Id, true
	case 10834:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_LastTransition_Name, true
	case 10835:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_LastTransition_Number, true
	case 10836:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_LastTransition_TransitionTime, true
	case 10837:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_UnshelveTime, true
	case 10862:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_TimedShelve_InputArguments, true
	case 10863:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedOrShelved, true
	case 10864:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_MaxTimeShelved, true
	case 11159:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConditionClassId, true
	case 11160:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConditionClassName, true
	case 11161:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_InputNode, true
	case 11162:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_NormalState, true
	case 11483:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 13011:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConditionRefresh2_InputArguments, true
	case 17008:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConditionSubClassId, true
	case 17009:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConditionSubClassName, true
	case 17010:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState, true
	case 17011:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_Id, true
	case 17012:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_Name, true
	case 17013:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_Number, true
	case 17014:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_EffectiveDisplayName, true
	case 17015:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_TransitionTime, true
	case 17016:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_EffectiveTransitionTime, true
	case 17017:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_TrueState, true
	case 17018:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_FalseState, true
	case 17019:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState, true
	case 17020:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_Id, true
	case 17021:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_Name, true
	case 17022:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_Number, true
	case 17023:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_EffectiveDisplayName, true
	case 17024:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_TransitionTime, true
	case 17025:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_EffectiveTransitionTime, true
	case 17026:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_TrueState, true
	case 17027:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_FalseState, true
	case 17028:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_AudibleEnabled, true
	case 17029:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_AudibleSound, true
	case 17034:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_OnDelay, true
	case 17035:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_OffDelay, true
	case 17036:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_FirstInGroupFlag, true
	case 17039:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ReAlarmTime, true
	case 17040:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ReAlarmRepeatCount, true
	case 17698:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_AvailableStates, true
	case 17699:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_AvailableTransitions, true
	case 17963:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_AudibleSound_ListId, true
	case 17964:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_AudibleSound_AgencyId, true
	case 17965:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_AudibleSound_VersionId, true
	case 18337:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState, true
	case 18338:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_Id, true
	case 18339:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_Name, true
	case 18340:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_Number, true
	case 18341:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_EffectiveDisplayName, true
	case 18342:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_TransitionTime, true
	case 18343:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_EffectiveTransitionTime, true
	case 18344:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_TrueState, true
	case 18345:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_FalseState, true
	case 24459:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_Suppress2_InputArguments, true
	case 24461:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_Unsuppress2_InputArguments, true
	case 24463:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_RemoveFromService2_InputArguments, true
	case 24465:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_PlaceInService2_InputArguments, true
	case 24467:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_Reset2_InputArguments, true
	case 24931:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_TimedShelve2_InputArguments, true
	case 24933:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_Unshelve2_InputArguments, true
	case 24935:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_OneShotShelve2_InputArguments, true
	case 25171:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_GetGroupMemberships_OutputArguments, true
	case 32239:
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SupportsFilteredRetain, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableTripByName(value string) (enum OpcuaNodeIdServicesVariableTrip, ok bool) {
	switch value {
	case "TripAlarmType_EventId":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_EventId, true
	case "TripAlarmType_EventType":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_EventType, true
	case "TripAlarmType_SourceNode":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SourceNode, true
	case "TripAlarmType_SourceName":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SourceName, true
	case "TripAlarmType_Time":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_Time, true
	case "TripAlarmType_ReceiveTime":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ReceiveTime, true
	case "TripAlarmType_LocalTime":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_LocalTime, true
	case "TripAlarmType_Message":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_Message, true
	case "TripAlarmType_Severity":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_Severity, true
	case "TripAlarmType_ConditionName":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConditionName, true
	case "TripAlarmType_BranchId":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_BranchId, true
	case "TripAlarmType_Retain":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_Retain, true
	case "TripAlarmType_EnabledState":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState, true
	case "TripAlarmType_EnabledState_Id":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_Id, true
	case "TripAlarmType_EnabledState_Name":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_Name, true
	case "TripAlarmType_EnabledState_Number":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_Number, true
	case "TripAlarmType_EnabledState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_EffectiveDisplayName, true
	case "TripAlarmType_EnabledState_TransitionTime":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_TransitionTime, true
	case "TripAlarmType_EnabledState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_EffectiveTransitionTime, true
	case "TripAlarmType_EnabledState_TrueState":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_TrueState, true
	case "TripAlarmType_EnabledState_FalseState":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_FalseState, true
	case "TripAlarmType_Quality":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_Quality, true
	case "TripAlarmType_Quality_SourceTimestamp":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_Quality_SourceTimestamp, true
	case "TripAlarmType_LastSeverity":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_LastSeverity, true
	case "TripAlarmType_LastSeverity_SourceTimestamp":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_LastSeverity_SourceTimestamp, true
	case "TripAlarmType_Comment":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_Comment, true
	case "TripAlarmType_Comment_SourceTimestamp":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_Comment_SourceTimestamp, true
	case "TripAlarmType_ClientUserId":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ClientUserId, true
	case "TripAlarmType_AddComment_InputArguments":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_AddComment_InputArguments, true
	case "TripAlarmType_ConditionRefresh_InputArguments":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConditionRefresh_InputArguments, true
	case "TripAlarmType_AckedState":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState, true
	case "TripAlarmType_AckedState_Id":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_Id, true
	case "TripAlarmType_AckedState_Name":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_Name, true
	case "TripAlarmType_AckedState_Number":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_Number, true
	case "TripAlarmType_AckedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_EffectiveDisplayName, true
	case "TripAlarmType_AckedState_TransitionTime":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_TransitionTime, true
	case "TripAlarmType_AckedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_EffectiveTransitionTime, true
	case "TripAlarmType_AckedState_TrueState":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_TrueState, true
	case "TripAlarmType_AckedState_FalseState":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_FalseState, true
	case "TripAlarmType_ConfirmedState":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState, true
	case "TripAlarmType_ConfirmedState_Id":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_Id, true
	case "TripAlarmType_ConfirmedState_Name":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_Name, true
	case "TripAlarmType_ConfirmedState_Number":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_Number, true
	case "TripAlarmType_ConfirmedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_EffectiveDisplayName, true
	case "TripAlarmType_ConfirmedState_TransitionTime":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_TransitionTime, true
	case "TripAlarmType_ConfirmedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_EffectiveTransitionTime, true
	case "TripAlarmType_ConfirmedState_TrueState":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_TrueState, true
	case "TripAlarmType_ConfirmedState_FalseState":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_FalseState, true
	case "TripAlarmType_Acknowledge_InputArguments":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_Acknowledge_InputArguments, true
	case "TripAlarmType_Confirm_InputArguments":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_Confirm_InputArguments, true
	case "TripAlarmType_ActiveState":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState, true
	case "TripAlarmType_ActiveState_Id":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_Id, true
	case "TripAlarmType_ActiveState_Name":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_Name, true
	case "TripAlarmType_ActiveState_Number":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_Number, true
	case "TripAlarmType_ActiveState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_EffectiveDisplayName, true
	case "TripAlarmType_ActiveState_TransitionTime":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_TransitionTime, true
	case "TripAlarmType_ActiveState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_EffectiveTransitionTime, true
	case "TripAlarmType_ActiveState_TrueState":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_TrueState, true
	case "TripAlarmType_ActiveState_FalseState":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_FalseState, true
	case "TripAlarmType_SuppressedState":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState, true
	case "TripAlarmType_SuppressedState_Id":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_Id, true
	case "TripAlarmType_SuppressedState_Name":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_Name, true
	case "TripAlarmType_SuppressedState_Number":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_Number, true
	case "TripAlarmType_SuppressedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_EffectiveDisplayName, true
	case "TripAlarmType_SuppressedState_TransitionTime":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_TransitionTime, true
	case "TripAlarmType_SuppressedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_EffectiveTransitionTime, true
	case "TripAlarmType_SuppressedState_TrueState":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_TrueState, true
	case "TripAlarmType_SuppressedState_FalseState":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_FalseState, true
	case "TripAlarmType_ShelvingState_CurrentState":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_CurrentState, true
	case "TripAlarmType_ShelvingState_CurrentState_Id":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_CurrentState_Id, true
	case "TripAlarmType_ShelvingState_CurrentState_Name":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_CurrentState_Name, true
	case "TripAlarmType_ShelvingState_CurrentState_Number":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_CurrentState_Number, true
	case "TripAlarmType_ShelvingState_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_CurrentState_EffectiveDisplayName, true
	case "TripAlarmType_ShelvingState_LastTransition":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_LastTransition, true
	case "TripAlarmType_ShelvingState_LastTransition_Id":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_LastTransition_Id, true
	case "TripAlarmType_ShelvingState_LastTransition_Name":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_LastTransition_Name, true
	case "TripAlarmType_ShelvingState_LastTransition_Number":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_LastTransition_Number, true
	case "TripAlarmType_ShelvingState_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_LastTransition_TransitionTime, true
	case "TripAlarmType_ShelvingState_UnshelveTime":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_UnshelveTime, true
	case "TripAlarmType_ShelvingState_TimedShelve_InputArguments":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_TimedShelve_InputArguments, true
	case "TripAlarmType_SuppressedOrShelved":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedOrShelved, true
	case "TripAlarmType_MaxTimeShelved":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_MaxTimeShelved, true
	case "TripAlarmType_ConditionClassId":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConditionClassId, true
	case "TripAlarmType_ConditionClassName":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConditionClassName, true
	case "TripAlarmType_InputNode":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_InputNode, true
	case "TripAlarmType_NormalState":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_NormalState, true
	case "TripAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case "TripAlarmType_ConditionRefresh2_InputArguments":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConditionRefresh2_InputArguments, true
	case "TripAlarmType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConditionSubClassId, true
	case "TripAlarmType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConditionSubClassName, true
	case "TripAlarmType_OutOfServiceState":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState, true
	case "TripAlarmType_OutOfServiceState_Id":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_Id, true
	case "TripAlarmType_OutOfServiceState_Name":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_Name, true
	case "TripAlarmType_OutOfServiceState_Number":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_Number, true
	case "TripAlarmType_OutOfServiceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_EffectiveDisplayName, true
	case "TripAlarmType_OutOfServiceState_TransitionTime":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_TransitionTime, true
	case "TripAlarmType_OutOfServiceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_EffectiveTransitionTime, true
	case "TripAlarmType_OutOfServiceState_TrueState":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_TrueState, true
	case "TripAlarmType_OutOfServiceState_FalseState":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_FalseState, true
	case "TripAlarmType_SilenceState":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState, true
	case "TripAlarmType_SilenceState_Id":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_Id, true
	case "TripAlarmType_SilenceState_Name":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_Name, true
	case "TripAlarmType_SilenceState_Number":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_Number, true
	case "TripAlarmType_SilenceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_EffectiveDisplayName, true
	case "TripAlarmType_SilenceState_TransitionTime":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_TransitionTime, true
	case "TripAlarmType_SilenceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_EffectiveTransitionTime, true
	case "TripAlarmType_SilenceState_TrueState":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_TrueState, true
	case "TripAlarmType_SilenceState_FalseState":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_FalseState, true
	case "TripAlarmType_AudibleEnabled":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_AudibleEnabled, true
	case "TripAlarmType_AudibleSound":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_AudibleSound, true
	case "TripAlarmType_OnDelay":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_OnDelay, true
	case "TripAlarmType_OffDelay":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_OffDelay, true
	case "TripAlarmType_FirstInGroupFlag":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_FirstInGroupFlag, true
	case "TripAlarmType_ReAlarmTime":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ReAlarmTime, true
	case "TripAlarmType_ReAlarmRepeatCount":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ReAlarmRepeatCount, true
	case "TripAlarmType_ShelvingState_AvailableStates":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_AvailableStates, true
	case "TripAlarmType_ShelvingState_AvailableTransitions":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_AvailableTransitions, true
	case "TripAlarmType_AudibleSound_ListId":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_AudibleSound_ListId, true
	case "TripAlarmType_AudibleSound_AgencyId":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_AudibleSound_AgencyId, true
	case "TripAlarmType_AudibleSound_VersionId":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_AudibleSound_VersionId, true
	case "TripAlarmType_LatchedState":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState, true
	case "TripAlarmType_LatchedState_Id":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_Id, true
	case "TripAlarmType_LatchedState_Name":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_Name, true
	case "TripAlarmType_LatchedState_Number":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_Number, true
	case "TripAlarmType_LatchedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_EffectiveDisplayName, true
	case "TripAlarmType_LatchedState_TransitionTime":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_TransitionTime, true
	case "TripAlarmType_LatchedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_EffectiveTransitionTime, true
	case "TripAlarmType_LatchedState_TrueState":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_TrueState, true
	case "TripAlarmType_LatchedState_FalseState":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_FalseState, true
	case "TripAlarmType_Suppress2_InputArguments":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_Suppress2_InputArguments, true
	case "TripAlarmType_Unsuppress2_InputArguments":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_Unsuppress2_InputArguments, true
	case "TripAlarmType_RemoveFromService2_InputArguments":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_RemoveFromService2_InputArguments, true
	case "TripAlarmType_PlaceInService2_InputArguments":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_PlaceInService2_InputArguments, true
	case "TripAlarmType_Reset2_InputArguments":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_Reset2_InputArguments, true
	case "TripAlarmType_ShelvingState_TimedShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_TimedShelve2_InputArguments, true
	case "TripAlarmType_ShelvingState_Unshelve2_InputArguments":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_Unshelve2_InputArguments, true
	case "TripAlarmType_ShelvingState_OneShotShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_OneShotShelve2_InputArguments, true
	case "TripAlarmType_GetGroupMemberships_OutputArguments":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_GetGroupMemberships_OutputArguments, true
	case "TripAlarmType_SupportsFilteredRetain":
		return OpcuaNodeIdServicesVariableTrip_TripAlarmType_SupportsFilteredRetain, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableTripKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableTripValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableTrip(structType any) OpcuaNodeIdServicesVariableTrip {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableTrip {
		if sOpcuaNodeIdServicesVariableTrip, ok := typ.(OpcuaNodeIdServicesVariableTrip); ok {
			return sOpcuaNodeIdServicesVariableTrip
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableTrip) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableTrip) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableTripParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableTrip, error) {
	return OpcuaNodeIdServicesVariableTripParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableTripParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableTrip, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableTrip", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableTrip")
	}
	if enum, ok := OpcuaNodeIdServicesVariableTripByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableTrip")
		return OpcuaNodeIdServicesVariableTrip(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableTrip) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableTrip) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableTrip", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableTrip) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_EventId:
		return "TripAlarmType_EventId"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_EventType:
		return "TripAlarmType_EventType"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_SourceNode:
		return "TripAlarmType_SourceNode"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_SourceName:
		return "TripAlarmType_SourceName"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_Time:
		return "TripAlarmType_Time"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ReceiveTime:
		return "TripAlarmType_ReceiveTime"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_LocalTime:
		return "TripAlarmType_LocalTime"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_Message:
		return "TripAlarmType_Message"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_Severity:
		return "TripAlarmType_Severity"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConditionName:
		return "TripAlarmType_ConditionName"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_BranchId:
		return "TripAlarmType_BranchId"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_Retain:
		return "TripAlarmType_Retain"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState:
		return "TripAlarmType_EnabledState"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_Id:
		return "TripAlarmType_EnabledState_Id"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_Name:
		return "TripAlarmType_EnabledState_Name"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_Number:
		return "TripAlarmType_EnabledState_Number"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_EffectiveDisplayName:
		return "TripAlarmType_EnabledState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_TransitionTime:
		return "TripAlarmType_EnabledState_TransitionTime"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_EffectiveTransitionTime:
		return "TripAlarmType_EnabledState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_TrueState:
		return "TripAlarmType_EnabledState_TrueState"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_EnabledState_FalseState:
		return "TripAlarmType_EnabledState_FalseState"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_Quality:
		return "TripAlarmType_Quality"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_Quality_SourceTimestamp:
		return "TripAlarmType_Quality_SourceTimestamp"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_LastSeverity:
		return "TripAlarmType_LastSeverity"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_LastSeverity_SourceTimestamp:
		return "TripAlarmType_LastSeverity_SourceTimestamp"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_Comment:
		return "TripAlarmType_Comment"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_Comment_SourceTimestamp:
		return "TripAlarmType_Comment_SourceTimestamp"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ClientUserId:
		return "TripAlarmType_ClientUserId"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_AddComment_InputArguments:
		return "TripAlarmType_AddComment_InputArguments"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConditionRefresh_InputArguments:
		return "TripAlarmType_ConditionRefresh_InputArguments"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState:
		return "TripAlarmType_AckedState"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_Id:
		return "TripAlarmType_AckedState_Id"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_Name:
		return "TripAlarmType_AckedState_Name"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_Number:
		return "TripAlarmType_AckedState_Number"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_EffectiveDisplayName:
		return "TripAlarmType_AckedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_TransitionTime:
		return "TripAlarmType_AckedState_TransitionTime"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_EffectiveTransitionTime:
		return "TripAlarmType_AckedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_TrueState:
		return "TripAlarmType_AckedState_TrueState"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_AckedState_FalseState:
		return "TripAlarmType_AckedState_FalseState"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState:
		return "TripAlarmType_ConfirmedState"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_Id:
		return "TripAlarmType_ConfirmedState_Id"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_Name:
		return "TripAlarmType_ConfirmedState_Name"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_Number:
		return "TripAlarmType_ConfirmedState_Number"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_EffectiveDisplayName:
		return "TripAlarmType_ConfirmedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_TransitionTime:
		return "TripAlarmType_ConfirmedState_TransitionTime"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_EffectiveTransitionTime:
		return "TripAlarmType_ConfirmedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_TrueState:
		return "TripAlarmType_ConfirmedState_TrueState"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConfirmedState_FalseState:
		return "TripAlarmType_ConfirmedState_FalseState"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_Acknowledge_InputArguments:
		return "TripAlarmType_Acknowledge_InputArguments"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_Confirm_InputArguments:
		return "TripAlarmType_Confirm_InputArguments"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState:
		return "TripAlarmType_ActiveState"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_Id:
		return "TripAlarmType_ActiveState_Id"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_Name:
		return "TripAlarmType_ActiveState_Name"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_Number:
		return "TripAlarmType_ActiveState_Number"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_EffectiveDisplayName:
		return "TripAlarmType_ActiveState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_TransitionTime:
		return "TripAlarmType_ActiveState_TransitionTime"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_EffectiveTransitionTime:
		return "TripAlarmType_ActiveState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_TrueState:
		return "TripAlarmType_ActiveState_TrueState"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ActiveState_FalseState:
		return "TripAlarmType_ActiveState_FalseState"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState:
		return "TripAlarmType_SuppressedState"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_Id:
		return "TripAlarmType_SuppressedState_Id"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_Name:
		return "TripAlarmType_SuppressedState_Name"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_Number:
		return "TripAlarmType_SuppressedState_Number"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_EffectiveDisplayName:
		return "TripAlarmType_SuppressedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_TransitionTime:
		return "TripAlarmType_SuppressedState_TransitionTime"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_EffectiveTransitionTime:
		return "TripAlarmType_SuppressedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_TrueState:
		return "TripAlarmType_SuppressedState_TrueState"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedState_FalseState:
		return "TripAlarmType_SuppressedState_FalseState"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_CurrentState:
		return "TripAlarmType_ShelvingState_CurrentState"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_CurrentState_Id:
		return "TripAlarmType_ShelvingState_CurrentState_Id"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_CurrentState_Name:
		return "TripAlarmType_ShelvingState_CurrentState_Name"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_CurrentState_Number:
		return "TripAlarmType_ShelvingState_CurrentState_Number"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_CurrentState_EffectiveDisplayName:
		return "TripAlarmType_ShelvingState_CurrentState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_LastTransition:
		return "TripAlarmType_ShelvingState_LastTransition"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_LastTransition_Id:
		return "TripAlarmType_ShelvingState_LastTransition_Id"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_LastTransition_Name:
		return "TripAlarmType_ShelvingState_LastTransition_Name"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_LastTransition_Number:
		return "TripAlarmType_ShelvingState_LastTransition_Number"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_LastTransition_TransitionTime:
		return "TripAlarmType_ShelvingState_LastTransition_TransitionTime"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_UnshelveTime:
		return "TripAlarmType_ShelvingState_UnshelveTime"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_TimedShelve_InputArguments:
		return "TripAlarmType_ShelvingState_TimedShelve_InputArguments"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_SuppressedOrShelved:
		return "TripAlarmType_SuppressedOrShelved"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_MaxTimeShelved:
		return "TripAlarmType_MaxTimeShelved"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConditionClassId:
		return "TripAlarmType_ConditionClassId"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConditionClassName:
		return "TripAlarmType_ConditionClassName"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_InputNode:
		return "TripAlarmType_InputNode"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_NormalState:
		return "TripAlarmType_NormalState"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime:
		return "TripAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConditionRefresh2_InputArguments:
		return "TripAlarmType_ConditionRefresh2_InputArguments"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConditionSubClassId:
		return "TripAlarmType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ConditionSubClassName:
		return "TripAlarmType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState:
		return "TripAlarmType_OutOfServiceState"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_Id:
		return "TripAlarmType_OutOfServiceState_Id"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_Name:
		return "TripAlarmType_OutOfServiceState_Name"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_Number:
		return "TripAlarmType_OutOfServiceState_Number"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_EffectiveDisplayName:
		return "TripAlarmType_OutOfServiceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_TransitionTime:
		return "TripAlarmType_OutOfServiceState_TransitionTime"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_EffectiveTransitionTime:
		return "TripAlarmType_OutOfServiceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_TrueState:
		return "TripAlarmType_OutOfServiceState_TrueState"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_OutOfServiceState_FalseState:
		return "TripAlarmType_OutOfServiceState_FalseState"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState:
		return "TripAlarmType_SilenceState"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_Id:
		return "TripAlarmType_SilenceState_Id"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_Name:
		return "TripAlarmType_SilenceState_Name"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_Number:
		return "TripAlarmType_SilenceState_Number"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_EffectiveDisplayName:
		return "TripAlarmType_SilenceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_TransitionTime:
		return "TripAlarmType_SilenceState_TransitionTime"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_EffectiveTransitionTime:
		return "TripAlarmType_SilenceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_TrueState:
		return "TripAlarmType_SilenceState_TrueState"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_SilenceState_FalseState:
		return "TripAlarmType_SilenceState_FalseState"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_AudibleEnabled:
		return "TripAlarmType_AudibleEnabled"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_AudibleSound:
		return "TripAlarmType_AudibleSound"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_OnDelay:
		return "TripAlarmType_OnDelay"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_OffDelay:
		return "TripAlarmType_OffDelay"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_FirstInGroupFlag:
		return "TripAlarmType_FirstInGroupFlag"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ReAlarmTime:
		return "TripAlarmType_ReAlarmTime"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ReAlarmRepeatCount:
		return "TripAlarmType_ReAlarmRepeatCount"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_AvailableStates:
		return "TripAlarmType_ShelvingState_AvailableStates"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_AvailableTransitions:
		return "TripAlarmType_ShelvingState_AvailableTransitions"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_AudibleSound_ListId:
		return "TripAlarmType_AudibleSound_ListId"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_AudibleSound_AgencyId:
		return "TripAlarmType_AudibleSound_AgencyId"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_AudibleSound_VersionId:
		return "TripAlarmType_AudibleSound_VersionId"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState:
		return "TripAlarmType_LatchedState"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_Id:
		return "TripAlarmType_LatchedState_Id"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_Name:
		return "TripAlarmType_LatchedState_Name"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_Number:
		return "TripAlarmType_LatchedState_Number"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_EffectiveDisplayName:
		return "TripAlarmType_LatchedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_TransitionTime:
		return "TripAlarmType_LatchedState_TransitionTime"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_EffectiveTransitionTime:
		return "TripAlarmType_LatchedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_TrueState:
		return "TripAlarmType_LatchedState_TrueState"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_LatchedState_FalseState:
		return "TripAlarmType_LatchedState_FalseState"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_Suppress2_InputArguments:
		return "TripAlarmType_Suppress2_InputArguments"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_Unsuppress2_InputArguments:
		return "TripAlarmType_Unsuppress2_InputArguments"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_RemoveFromService2_InputArguments:
		return "TripAlarmType_RemoveFromService2_InputArguments"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_PlaceInService2_InputArguments:
		return "TripAlarmType_PlaceInService2_InputArguments"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_Reset2_InputArguments:
		return "TripAlarmType_Reset2_InputArguments"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_TimedShelve2_InputArguments:
		return "TripAlarmType_ShelvingState_TimedShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_Unshelve2_InputArguments:
		return "TripAlarmType_ShelvingState_Unshelve2_InputArguments"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_ShelvingState_OneShotShelve2_InputArguments:
		return "TripAlarmType_ShelvingState_OneShotShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_GetGroupMemberships_OutputArguments:
		return "TripAlarmType_GetGroupMemberships_OutputArguments"
	case OpcuaNodeIdServicesVariableTrip_TripAlarmType_SupportsFilteredRetain:
		return "TripAlarmType_SupportsFilteredRetain"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableTrip) String() string {
	return e.PLC4XEnumName()
}
