/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableTransparent is an enum
type OpcuaNodeIdServicesVariableTransparent int32

type IOpcuaNodeIdServicesVariableTransparent interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableTransparent_TransparentRedundancyType_CurrentServerId      OpcuaNodeIdServicesVariableTransparent = 2037
	OpcuaNodeIdServicesVariableTransparent_TransparentRedundancyType_RedundantServerArray OpcuaNodeIdServicesVariableTransparent = 2038
)

var OpcuaNodeIdServicesVariableTransparentValues []OpcuaNodeIdServicesVariableTransparent

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableTransparentValues = []OpcuaNodeIdServicesVariableTransparent{
		OpcuaNodeIdServicesVariableTransparent_TransparentRedundancyType_CurrentServerId,
		OpcuaNodeIdServicesVariableTransparent_TransparentRedundancyType_RedundantServerArray,
	}
}

func OpcuaNodeIdServicesVariableTransparentByValue(value int32) (enum OpcuaNodeIdServicesVariableTransparent, ok bool) {
	switch value {
	case 2037:
		return OpcuaNodeIdServicesVariableTransparent_TransparentRedundancyType_CurrentServerId, true
	case 2038:
		return OpcuaNodeIdServicesVariableTransparent_TransparentRedundancyType_RedundantServerArray, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableTransparentByName(value string) (enum OpcuaNodeIdServicesVariableTransparent, ok bool) {
	switch value {
	case "TransparentRedundancyType_CurrentServerId":
		return OpcuaNodeIdServicesVariableTransparent_TransparentRedundancyType_CurrentServerId, true
	case "TransparentRedundancyType_RedundantServerArray":
		return OpcuaNodeIdServicesVariableTransparent_TransparentRedundancyType_RedundantServerArray, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableTransparentKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableTransparentValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableTransparent(structType any) OpcuaNodeIdServicesVariableTransparent {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableTransparent {
		if sOpcuaNodeIdServicesVariableTransparent, ok := typ.(OpcuaNodeIdServicesVariableTransparent); ok {
			return sOpcuaNodeIdServicesVariableTransparent
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableTransparent) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableTransparent) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableTransparentParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableTransparent, error) {
	return OpcuaNodeIdServicesVariableTransparentParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableTransparentParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableTransparent, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableTransparent", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableTransparent")
	}
	if enum, ok := OpcuaNodeIdServicesVariableTransparentByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableTransparent")
		return OpcuaNodeIdServicesVariableTransparent(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableTransparent) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableTransparent) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableTransparent", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableTransparent) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableTransparent_TransparentRedundancyType_CurrentServerId:
		return "TransparentRedundancyType_CurrentServerId"
	case OpcuaNodeIdServicesVariableTransparent_TransparentRedundancyType_RedundantServerArray:
		return "TransparentRedundancyType_RedundantServerArray"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableTransparent) String() string {
	return e.PLC4XEnumName()
}
