/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableSubscription is an enum
type OpcuaNodeIdServicesVariableSubscription int32

type IOpcuaNodeIdServicesVariableSubscription interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_SessionId                                                 OpcuaNodeIdServicesVariableSubscription = 2173
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_SubscriptionId                                            OpcuaNodeIdServicesVariableSubscription = 2174
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_Priority                                                  OpcuaNodeIdServicesVariableSubscription = 2175
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_PublishingInterval                                        OpcuaNodeIdServicesVariableSubscription = 2176
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_MaxKeepAliveCount                                         OpcuaNodeIdServicesVariableSubscription = 2177
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_MaxNotificationsPerPublish                                OpcuaNodeIdServicesVariableSubscription = 2179
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_PublishingEnabled                                         OpcuaNodeIdServicesVariableSubscription = 2180
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_ModifyCount                                               OpcuaNodeIdServicesVariableSubscription = 2181
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_EnableCount                                               OpcuaNodeIdServicesVariableSubscription = 2182
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_DisableCount                                              OpcuaNodeIdServicesVariableSubscription = 2183
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_RepublishRequestCount                                     OpcuaNodeIdServicesVariableSubscription = 2184
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_RepublishMessageRequestCount                              OpcuaNodeIdServicesVariableSubscription = 2185
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_RepublishMessageCount                                     OpcuaNodeIdServicesVariableSubscription = 2186
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_TransferRequestCount                                      OpcuaNodeIdServicesVariableSubscription = 2187
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_TransferredToAltClientCount                               OpcuaNodeIdServicesVariableSubscription = 2188
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_TransferredToSameClientCount                              OpcuaNodeIdServicesVariableSubscription = 2189
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_PublishRequestCount                                       OpcuaNodeIdServicesVariableSubscription = 2190
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_DataChangeNotificationsCount                              OpcuaNodeIdServicesVariableSubscription = 2191
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_NotificationsCount                                        OpcuaNodeIdServicesVariableSubscription = 2193
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_EventNotificationsCount                                   OpcuaNodeIdServicesVariableSubscription = 2998
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_MaxLifetimeCount                                          OpcuaNodeIdServicesVariableSubscription = 8888
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_LatePublishRequestCount                                   OpcuaNodeIdServicesVariableSubscription = 8889
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_CurrentKeepAliveCount                                     OpcuaNodeIdServicesVariableSubscription = 8890
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_CurrentLifetimeCount                                      OpcuaNodeIdServicesVariableSubscription = 8891
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_UnacknowledgedMessageCount                                OpcuaNodeIdServicesVariableSubscription = 8892
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_DiscardedMessageCount                                     OpcuaNodeIdServicesVariableSubscription = 8893
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_MonitoredItemCount                                        OpcuaNodeIdServicesVariableSubscription = 8894
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_DisabledMonitoredItemCount                                OpcuaNodeIdServicesVariableSubscription = 8895
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_MonitoringQueueOverflowCount                              OpcuaNodeIdServicesVariableSubscription = 8896
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_NextSequenceNumber                                        OpcuaNodeIdServicesVariableSubscription = 8897
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_EventQueueOverflowCount                                   OpcuaNodeIdServicesVariableSubscription = 8902
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics                              OpcuaNodeIdServicesVariableSubscription = 12784
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_SessionId                    OpcuaNodeIdServicesVariableSubscription = 12785
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_SubscriptionId               OpcuaNodeIdServicesVariableSubscription = 12786
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_Priority                     OpcuaNodeIdServicesVariableSubscription = 12787
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishingInterval           OpcuaNodeIdServicesVariableSubscription = 12788
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxKeepAliveCount            OpcuaNodeIdServicesVariableSubscription = 12789
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxLifetimeCount             OpcuaNodeIdServicesVariableSubscription = 12790
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxNotificationsPerPublish   OpcuaNodeIdServicesVariableSubscription = 12791
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishingEnabled            OpcuaNodeIdServicesVariableSubscription = 12792
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_ModifyCount                  OpcuaNodeIdServicesVariableSubscription = 12793
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EnableCount                  OpcuaNodeIdServicesVariableSubscription = 12794
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DisableCount                 OpcuaNodeIdServicesVariableSubscription = 12795
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishRequestCount        OpcuaNodeIdServicesVariableSubscription = 12796
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishMessageRequestCount OpcuaNodeIdServicesVariableSubscription = 12797
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishMessageCount        OpcuaNodeIdServicesVariableSubscription = 12798
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferRequestCount         OpcuaNodeIdServicesVariableSubscription = 12799
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferredToAltClientCount  OpcuaNodeIdServicesVariableSubscription = 12800
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferredToSameClientCount OpcuaNodeIdServicesVariableSubscription = 12801
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishRequestCount          OpcuaNodeIdServicesVariableSubscription = 12802
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DataChangeNotificationsCount OpcuaNodeIdServicesVariableSubscription = 12803
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EventNotificationsCount      OpcuaNodeIdServicesVariableSubscription = 12804
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_NotificationsCount           OpcuaNodeIdServicesVariableSubscription = 12805
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_LatePublishRequestCount      OpcuaNodeIdServicesVariableSubscription = 12806
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_CurrentKeepAliveCount        OpcuaNodeIdServicesVariableSubscription = 12807
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_CurrentLifetimeCount         OpcuaNodeIdServicesVariableSubscription = 12808
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_UnacknowledgedMessageCount   OpcuaNodeIdServicesVariableSubscription = 12809
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DiscardedMessageCount        OpcuaNodeIdServicesVariableSubscription = 12810
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MonitoredItemCount           OpcuaNodeIdServicesVariableSubscription = 12811
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DisabledMonitoredItemCount   OpcuaNodeIdServicesVariableSubscription = 12812
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MonitoringQueueOverflowCount OpcuaNodeIdServicesVariableSubscription = 12813
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_NextSequenceNumber           OpcuaNodeIdServicesVariableSubscription = 12814
	OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EventQueueOverflowCount      OpcuaNodeIdServicesVariableSubscription = 12815
)

var OpcuaNodeIdServicesVariableSubscriptionValues []OpcuaNodeIdServicesVariableSubscription

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableSubscriptionValues = []OpcuaNodeIdServicesVariableSubscription{
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_SessionId,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_SubscriptionId,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_Priority,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_PublishingInterval,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_MaxKeepAliveCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_MaxNotificationsPerPublish,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_PublishingEnabled,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_ModifyCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_EnableCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_DisableCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_RepublishRequestCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_RepublishMessageRequestCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_RepublishMessageCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_TransferRequestCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_TransferredToAltClientCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_TransferredToSameClientCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_PublishRequestCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_DataChangeNotificationsCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_NotificationsCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_EventNotificationsCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_MaxLifetimeCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_LatePublishRequestCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_CurrentKeepAliveCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_CurrentLifetimeCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_UnacknowledgedMessageCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_DiscardedMessageCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_MonitoredItemCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_DisabledMonitoredItemCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_MonitoringQueueOverflowCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_NextSequenceNumber,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_EventQueueOverflowCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_SessionId,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_SubscriptionId,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_Priority,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishingInterval,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxKeepAliveCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxLifetimeCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxNotificationsPerPublish,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishingEnabled,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_ModifyCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EnableCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DisableCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishRequestCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishMessageRequestCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishMessageCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferRequestCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferredToAltClientCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferredToSameClientCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishRequestCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DataChangeNotificationsCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EventNotificationsCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_NotificationsCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_LatePublishRequestCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_CurrentKeepAliveCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_CurrentLifetimeCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_UnacknowledgedMessageCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DiscardedMessageCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MonitoredItemCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DisabledMonitoredItemCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MonitoringQueueOverflowCount,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_NextSequenceNumber,
		OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EventQueueOverflowCount,
	}
}

func OpcuaNodeIdServicesVariableSubscriptionByValue(value int32) (enum OpcuaNodeIdServicesVariableSubscription, ok bool) {
	switch value {
	case 12784:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics, true
	case 12785:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_SessionId, true
	case 12786:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_SubscriptionId, true
	case 12787:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_Priority, true
	case 12788:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishingInterval, true
	case 12789:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxKeepAliveCount, true
	case 12790:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxLifetimeCount, true
	case 12791:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxNotificationsPerPublish, true
	case 12792:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishingEnabled, true
	case 12793:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_ModifyCount, true
	case 12794:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EnableCount, true
	case 12795:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DisableCount, true
	case 12796:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishRequestCount, true
	case 12797:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishMessageRequestCount, true
	case 12798:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishMessageCount, true
	case 12799:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferRequestCount, true
	case 12800:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferredToAltClientCount, true
	case 12801:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferredToSameClientCount, true
	case 12802:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishRequestCount, true
	case 12803:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DataChangeNotificationsCount, true
	case 12804:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EventNotificationsCount, true
	case 12805:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_NotificationsCount, true
	case 12806:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_LatePublishRequestCount, true
	case 12807:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_CurrentKeepAliveCount, true
	case 12808:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_CurrentLifetimeCount, true
	case 12809:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_UnacknowledgedMessageCount, true
	case 12810:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DiscardedMessageCount, true
	case 12811:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MonitoredItemCount, true
	case 12812:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DisabledMonitoredItemCount, true
	case 12813:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MonitoringQueueOverflowCount, true
	case 12814:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_NextSequenceNumber, true
	case 12815:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EventQueueOverflowCount, true
	case 2173:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_SessionId, true
	case 2174:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_SubscriptionId, true
	case 2175:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_Priority, true
	case 2176:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_PublishingInterval, true
	case 2177:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_MaxKeepAliveCount, true
	case 2179:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_MaxNotificationsPerPublish, true
	case 2180:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_PublishingEnabled, true
	case 2181:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_ModifyCount, true
	case 2182:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_EnableCount, true
	case 2183:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_DisableCount, true
	case 2184:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_RepublishRequestCount, true
	case 2185:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_RepublishMessageRequestCount, true
	case 2186:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_RepublishMessageCount, true
	case 2187:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_TransferRequestCount, true
	case 2188:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_TransferredToAltClientCount, true
	case 2189:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_TransferredToSameClientCount, true
	case 2190:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_PublishRequestCount, true
	case 2191:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_DataChangeNotificationsCount, true
	case 2193:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_NotificationsCount, true
	case 2998:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_EventNotificationsCount, true
	case 8888:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_MaxLifetimeCount, true
	case 8889:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_LatePublishRequestCount, true
	case 8890:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_CurrentKeepAliveCount, true
	case 8891:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_CurrentLifetimeCount, true
	case 8892:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_UnacknowledgedMessageCount, true
	case 8893:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_DiscardedMessageCount, true
	case 8894:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_MonitoredItemCount, true
	case 8895:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_DisabledMonitoredItemCount, true
	case 8896:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_MonitoringQueueOverflowCount, true
	case 8897:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_NextSequenceNumber, true
	case 8902:
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_EventQueueOverflowCount, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableSubscriptionByName(value string) (enum OpcuaNodeIdServicesVariableSubscription, ok bool) {
	switch value {
	case "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics, true
	case "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_SessionId":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_SessionId, true
	case "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_SubscriptionId":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_SubscriptionId, true
	case "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_Priority":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_Priority, true
	case "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishingInterval":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishingInterval, true
	case "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxKeepAliveCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxKeepAliveCount, true
	case "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxLifetimeCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxLifetimeCount, true
	case "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxNotificationsPerPublish":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxNotificationsPerPublish, true
	case "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishingEnabled":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishingEnabled, true
	case "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_ModifyCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_ModifyCount, true
	case "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EnableCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EnableCount, true
	case "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DisableCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DisableCount, true
	case "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishRequestCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishRequestCount, true
	case "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishMessageRequestCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishMessageRequestCount, true
	case "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishMessageCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishMessageCount, true
	case "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferRequestCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferRequestCount, true
	case "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferredToAltClientCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferredToAltClientCount, true
	case "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferredToSameClientCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferredToSameClientCount, true
	case "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishRequestCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishRequestCount, true
	case "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DataChangeNotificationsCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DataChangeNotificationsCount, true
	case "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EventNotificationsCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EventNotificationsCount, true
	case "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_NotificationsCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_NotificationsCount, true
	case "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_LatePublishRequestCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_LatePublishRequestCount, true
	case "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_CurrentKeepAliveCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_CurrentKeepAliveCount, true
	case "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_CurrentLifetimeCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_CurrentLifetimeCount, true
	case "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_UnacknowledgedMessageCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_UnacknowledgedMessageCount, true
	case "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DiscardedMessageCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DiscardedMessageCount, true
	case "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MonitoredItemCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MonitoredItemCount, true
	case "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DisabledMonitoredItemCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DisabledMonitoredItemCount, true
	case "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MonitoringQueueOverflowCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MonitoringQueueOverflowCount, true
	case "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_NextSequenceNumber":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_NextSequenceNumber, true
	case "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EventQueueOverflowCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EventQueueOverflowCount, true
	case "SubscriptionDiagnosticsType_SessionId":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_SessionId, true
	case "SubscriptionDiagnosticsType_SubscriptionId":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_SubscriptionId, true
	case "SubscriptionDiagnosticsType_Priority":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_Priority, true
	case "SubscriptionDiagnosticsType_PublishingInterval":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_PublishingInterval, true
	case "SubscriptionDiagnosticsType_MaxKeepAliveCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_MaxKeepAliveCount, true
	case "SubscriptionDiagnosticsType_MaxNotificationsPerPublish":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_MaxNotificationsPerPublish, true
	case "SubscriptionDiagnosticsType_PublishingEnabled":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_PublishingEnabled, true
	case "SubscriptionDiagnosticsType_ModifyCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_ModifyCount, true
	case "SubscriptionDiagnosticsType_EnableCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_EnableCount, true
	case "SubscriptionDiagnosticsType_DisableCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_DisableCount, true
	case "SubscriptionDiagnosticsType_RepublishRequestCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_RepublishRequestCount, true
	case "SubscriptionDiagnosticsType_RepublishMessageRequestCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_RepublishMessageRequestCount, true
	case "SubscriptionDiagnosticsType_RepublishMessageCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_RepublishMessageCount, true
	case "SubscriptionDiagnosticsType_TransferRequestCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_TransferRequestCount, true
	case "SubscriptionDiagnosticsType_TransferredToAltClientCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_TransferredToAltClientCount, true
	case "SubscriptionDiagnosticsType_TransferredToSameClientCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_TransferredToSameClientCount, true
	case "SubscriptionDiagnosticsType_PublishRequestCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_PublishRequestCount, true
	case "SubscriptionDiagnosticsType_DataChangeNotificationsCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_DataChangeNotificationsCount, true
	case "SubscriptionDiagnosticsType_NotificationsCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_NotificationsCount, true
	case "SubscriptionDiagnosticsType_EventNotificationsCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_EventNotificationsCount, true
	case "SubscriptionDiagnosticsType_MaxLifetimeCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_MaxLifetimeCount, true
	case "SubscriptionDiagnosticsType_LatePublishRequestCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_LatePublishRequestCount, true
	case "SubscriptionDiagnosticsType_CurrentKeepAliveCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_CurrentKeepAliveCount, true
	case "SubscriptionDiagnosticsType_CurrentLifetimeCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_CurrentLifetimeCount, true
	case "SubscriptionDiagnosticsType_UnacknowledgedMessageCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_UnacknowledgedMessageCount, true
	case "SubscriptionDiagnosticsType_DiscardedMessageCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_DiscardedMessageCount, true
	case "SubscriptionDiagnosticsType_MonitoredItemCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_MonitoredItemCount, true
	case "SubscriptionDiagnosticsType_DisabledMonitoredItemCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_DisabledMonitoredItemCount, true
	case "SubscriptionDiagnosticsType_MonitoringQueueOverflowCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_MonitoringQueueOverflowCount, true
	case "SubscriptionDiagnosticsType_NextSequenceNumber":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_NextSequenceNumber, true
	case "SubscriptionDiagnosticsType_EventQueueOverflowCount":
		return OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_EventQueueOverflowCount, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableSubscriptionKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableSubscriptionValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableSubscription(structType any) OpcuaNodeIdServicesVariableSubscription {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableSubscription {
		if sOpcuaNodeIdServicesVariableSubscription, ok := typ.(OpcuaNodeIdServicesVariableSubscription); ok {
			return sOpcuaNodeIdServicesVariableSubscription
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableSubscription) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableSubscription) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableSubscriptionParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableSubscription, error) {
	return OpcuaNodeIdServicesVariableSubscriptionParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableSubscriptionParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableSubscription, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableSubscription", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableSubscription")
	}
	if enum, ok := OpcuaNodeIdServicesVariableSubscriptionByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableSubscription")
		return OpcuaNodeIdServicesVariableSubscription(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableSubscription) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableSubscription) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableSubscription", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableSubscription) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics:
		return "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_SessionId:
		return "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_SessionId"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_SubscriptionId:
		return "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_SubscriptionId"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_Priority:
		return "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_Priority"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishingInterval:
		return "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishingInterval"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxKeepAliveCount:
		return "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxKeepAliveCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxLifetimeCount:
		return "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxLifetimeCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxNotificationsPerPublish:
		return "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxNotificationsPerPublish"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishingEnabled:
		return "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishingEnabled"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_ModifyCount:
		return "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_ModifyCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EnableCount:
		return "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EnableCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DisableCount:
		return "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DisableCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishRequestCount:
		return "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishRequestCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishMessageRequestCount:
		return "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishMessageRequestCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishMessageCount:
		return "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishMessageCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferRequestCount:
		return "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferRequestCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferredToAltClientCount:
		return "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferredToAltClientCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferredToSameClientCount:
		return "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferredToSameClientCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishRequestCount:
		return "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishRequestCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DataChangeNotificationsCount:
		return "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DataChangeNotificationsCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EventNotificationsCount:
		return "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EventNotificationsCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_NotificationsCount:
		return "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_NotificationsCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_LatePublishRequestCount:
		return "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_LatePublishRequestCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_CurrentKeepAliveCount:
		return "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_CurrentKeepAliveCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_CurrentLifetimeCount:
		return "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_CurrentLifetimeCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_UnacknowledgedMessageCount:
		return "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_UnacknowledgedMessageCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DiscardedMessageCount:
		return "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DiscardedMessageCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MonitoredItemCount:
		return "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MonitoredItemCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DisabledMonitoredItemCount:
		return "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DisabledMonitoredItemCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MonitoringQueueOverflowCount:
		return "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MonitoringQueueOverflowCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_NextSequenceNumber:
		return "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_NextSequenceNumber"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EventQueueOverflowCount:
		return "SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EventQueueOverflowCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_SessionId:
		return "SubscriptionDiagnosticsType_SessionId"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_SubscriptionId:
		return "SubscriptionDiagnosticsType_SubscriptionId"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_Priority:
		return "SubscriptionDiagnosticsType_Priority"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_PublishingInterval:
		return "SubscriptionDiagnosticsType_PublishingInterval"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_MaxKeepAliveCount:
		return "SubscriptionDiagnosticsType_MaxKeepAliveCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_MaxNotificationsPerPublish:
		return "SubscriptionDiagnosticsType_MaxNotificationsPerPublish"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_PublishingEnabled:
		return "SubscriptionDiagnosticsType_PublishingEnabled"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_ModifyCount:
		return "SubscriptionDiagnosticsType_ModifyCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_EnableCount:
		return "SubscriptionDiagnosticsType_EnableCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_DisableCount:
		return "SubscriptionDiagnosticsType_DisableCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_RepublishRequestCount:
		return "SubscriptionDiagnosticsType_RepublishRequestCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_RepublishMessageRequestCount:
		return "SubscriptionDiagnosticsType_RepublishMessageRequestCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_RepublishMessageCount:
		return "SubscriptionDiagnosticsType_RepublishMessageCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_TransferRequestCount:
		return "SubscriptionDiagnosticsType_TransferRequestCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_TransferredToAltClientCount:
		return "SubscriptionDiagnosticsType_TransferredToAltClientCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_TransferredToSameClientCount:
		return "SubscriptionDiagnosticsType_TransferredToSameClientCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_PublishRequestCount:
		return "SubscriptionDiagnosticsType_PublishRequestCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_DataChangeNotificationsCount:
		return "SubscriptionDiagnosticsType_DataChangeNotificationsCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_NotificationsCount:
		return "SubscriptionDiagnosticsType_NotificationsCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_EventNotificationsCount:
		return "SubscriptionDiagnosticsType_EventNotificationsCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_MaxLifetimeCount:
		return "SubscriptionDiagnosticsType_MaxLifetimeCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_LatePublishRequestCount:
		return "SubscriptionDiagnosticsType_LatePublishRequestCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_CurrentKeepAliveCount:
		return "SubscriptionDiagnosticsType_CurrentKeepAliveCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_CurrentLifetimeCount:
		return "SubscriptionDiagnosticsType_CurrentLifetimeCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_UnacknowledgedMessageCount:
		return "SubscriptionDiagnosticsType_UnacknowledgedMessageCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_DiscardedMessageCount:
		return "SubscriptionDiagnosticsType_DiscardedMessageCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_MonitoredItemCount:
		return "SubscriptionDiagnosticsType_MonitoredItemCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_DisabledMonitoredItemCount:
		return "SubscriptionDiagnosticsType_DisabledMonitoredItemCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_MonitoringQueueOverflowCount:
		return "SubscriptionDiagnosticsType_MonitoringQueueOverflowCount"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_NextSequenceNumber:
		return "SubscriptionDiagnosticsType_NextSequenceNumber"
	case OpcuaNodeIdServicesVariableSubscription_SubscriptionDiagnosticsType_EventQueueOverflowCount:
		return "SubscriptionDiagnosticsType_EventQueueOverflowCount"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableSubscription) String() string {
	return e.PLC4XEnumName()
}
