/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableSession is an enum
type OpcuaNodeIdServicesVariableSession int32

type IOpcuaNodeIdServicesVariableSession interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics                                        OpcuaNodeIdServicesVariableSession = 2030
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics                                OpcuaNodeIdServicesVariableSession = 2031
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SubscriptionDiagnosticsArray                              OpcuaNodeIdServicesVariableSession = 2032
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_SessionId                                               OpcuaNodeIdServicesVariableSession = 2198
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_SessionName                                             OpcuaNodeIdServicesVariableSession = 2199
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ClientDescription                                       OpcuaNodeIdServicesVariableSession = 2200
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ServerUri                                               OpcuaNodeIdServicesVariableSession = 2201
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_EndpointUrl                                             OpcuaNodeIdServicesVariableSession = 2202
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_LocaleIds                                               OpcuaNodeIdServicesVariableSession = 2203
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ActualSessionTimeout                                    OpcuaNodeIdServicesVariableSession = 2204
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ClientConnectionTime                                    OpcuaNodeIdServicesVariableSession = 2205
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ClientLastContactTime                                   OpcuaNodeIdServicesVariableSession = 2206
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_CurrentSubscriptionsCount                               OpcuaNodeIdServicesVariableSession = 2207
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_CurrentMonitoredItemsCount                              OpcuaNodeIdServicesVariableSession = 2208
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_CurrentPublishRequestsInQueue                           OpcuaNodeIdServicesVariableSession = 2209
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ReadCount                                               OpcuaNodeIdServicesVariableSession = 2217
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_HistoryReadCount                                        OpcuaNodeIdServicesVariableSession = 2218
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_WriteCount                                              OpcuaNodeIdServicesVariableSession = 2219
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_HistoryUpdateCount                                      OpcuaNodeIdServicesVariableSession = 2220
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_CallCount                                               OpcuaNodeIdServicesVariableSession = 2221
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_CreateMonitoredItemsCount                               OpcuaNodeIdServicesVariableSession = 2222
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ModifyMonitoredItemsCount                               OpcuaNodeIdServicesVariableSession = 2223
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_SetMonitoringModeCount                                  OpcuaNodeIdServicesVariableSession = 2224
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_SetTriggeringCount                                      OpcuaNodeIdServicesVariableSession = 2225
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_DeleteMonitoredItemsCount                               OpcuaNodeIdServicesVariableSession = 2226
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_CreateSubscriptionCount                                 OpcuaNodeIdServicesVariableSession = 2227
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ModifySubscriptionCount                                 OpcuaNodeIdServicesVariableSession = 2228
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_SetPublishingModeCount                                  OpcuaNodeIdServicesVariableSession = 2229
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_PublishCount                                            OpcuaNodeIdServicesVariableSession = 2230
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_RepublishCount                                          OpcuaNodeIdServicesVariableSession = 2231
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_TransferSubscriptionsCount                              OpcuaNodeIdServicesVariableSession = 2232
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_DeleteSubscriptionsCount                                OpcuaNodeIdServicesVariableSession = 2233
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_AddNodesCount                                           OpcuaNodeIdServicesVariableSession = 2234
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_AddReferencesCount                                      OpcuaNodeIdServicesVariableSession = 2235
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_DeleteNodesCount                                        OpcuaNodeIdServicesVariableSession = 2236
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_DeleteReferencesCount                                   OpcuaNodeIdServicesVariableSession = 2237
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_BrowseCount                                             OpcuaNodeIdServicesVariableSession = 2238
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_BrowseNextCount                                         OpcuaNodeIdServicesVariableSession = 2239
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_TranslateBrowsePathsToNodeIdsCount                      OpcuaNodeIdServicesVariableSession = 2240
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_QueryFirstCount                                         OpcuaNodeIdServicesVariableSession = 2241
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_QueryNextCount                                          OpcuaNodeIdServicesVariableSession = 2242
	OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_SessionId                                               OpcuaNodeIdServicesVariableSession = 2245
	OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_ClientUserIdOfSession                                   OpcuaNodeIdServicesVariableSession = 2246
	OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_ClientUserIdHistory                                     OpcuaNodeIdServicesVariableSession = 2247
	OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_AuthenticationMechanism                                 OpcuaNodeIdServicesVariableSession = 2248
	OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_Encoding                                                OpcuaNodeIdServicesVariableSession = 2249
	OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_TransportProtocol                                       OpcuaNodeIdServicesVariableSession = 2250
	OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_SecurityMode                                            OpcuaNodeIdServicesVariableSession = 2251
	OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_SecurityPolicyUri                                       OpcuaNodeIdServicesVariableSession = 2252
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_RegisterNodesCount                                      OpcuaNodeIdServicesVariableSession = 2730
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_UnregisterNodesCount                                    OpcuaNodeIdServicesVariableSession = 2731
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_MaxResponseMessageSize                                  OpcuaNodeIdServicesVariableSession = 3050
	OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_ClientCertificate                                       OpcuaNodeIdServicesVariableSession = 3058
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_SessionId                              OpcuaNodeIdServicesVariableSession = 3131
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_SessionName                            OpcuaNodeIdServicesVariableSession = 3132
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ClientDescription                      OpcuaNodeIdServicesVariableSession = 3133
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ServerUri                              OpcuaNodeIdServicesVariableSession = 3134
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_EndpointUrl                            OpcuaNodeIdServicesVariableSession = 3135
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_LocaleIds                              OpcuaNodeIdServicesVariableSession = 3136
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ActualSessionTimeout                   OpcuaNodeIdServicesVariableSession = 3137
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_MaxResponseMessageSize                 OpcuaNodeIdServicesVariableSession = 3138
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ClientConnectionTime                   OpcuaNodeIdServicesVariableSession = 3139
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ClientLastContactTime                  OpcuaNodeIdServicesVariableSession = 3140
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_CurrentSubscriptionsCount              OpcuaNodeIdServicesVariableSession = 3141
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_CurrentMonitoredItemsCount             OpcuaNodeIdServicesVariableSession = 3142
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_CurrentPublishRequestsInQueue          OpcuaNodeIdServicesVariableSession = 3143
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ReadCount                              OpcuaNodeIdServicesVariableSession = 3151
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_HistoryReadCount                       OpcuaNodeIdServicesVariableSession = 3152
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_WriteCount                             OpcuaNodeIdServicesVariableSession = 3153
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_HistoryUpdateCount                     OpcuaNodeIdServicesVariableSession = 3154
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_CallCount                              OpcuaNodeIdServicesVariableSession = 3155
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_CreateMonitoredItemsCount              OpcuaNodeIdServicesVariableSession = 3156
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ModifyMonitoredItemsCount              OpcuaNodeIdServicesVariableSession = 3157
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_SetMonitoringModeCount                 OpcuaNodeIdServicesVariableSession = 3158
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_SetTriggeringCount                     OpcuaNodeIdServicesVariableSession = 3159
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_DeleteMonitoredItemsCount              OpcuaNodeIdServicesVariableSession = 3160
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_CreateSubscriptionCount                OpcuaNodeIdServicesVariableSession = 3161
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ModifySubscriptionCount                OpcuaNodeIdServicesVariableSession = 3162
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_SetPublishingModeCount                 OpcuaNodeIdServicesVariableSession = 3163
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_PublishCount                           OpcuaNodeIdServicesVariableSession = 3164
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_RepublishCount                         OpcuaNodeIdServicesVariableSession = 3165
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_TransferSubscriptionsCount             OpcuaNodeIdServicesVariableSession = 3166
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_DeleteSubscriptionsCount               OpcuaNodeIdServicesVariableSession = 3167
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_AddNodesCount                          OpcuaNodeIdServicesVariableSession = 3168
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_AddReferencesCount                     OpcuaNodeIdServicesVariableSession = 3169
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_DeleteNodesCount                       OpcuaNodeIdServicesVariableSession = 3170
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_DeleteReferencesCount                  OpcuaNodeIdServicesVariableSession = 3171
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_BrowseCount                            OpcuaNodeIdServicesVariableSession = 3172
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_BrowseNextCount                        OpcuaNodeIdServicesVariableSession = 3173
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount     OpcuaNodeIdServicesVariableSession = 3174
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_QueryFirstCount                        OpcuaNodeIdServicesVariableSession = 3175
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_QueryNextCount                         OpcuaNodeIdServicesVariableSession = 3176
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_RegisterNodesCount                     OpcuaNodeIdServicesVariableSession = 3177
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_UnregisterNodesCount                   OpcuaNodeIdServicesVariableSession = 3178
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SessionId                      OpcuaNodeIdServicesVariableSession = 3179
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientUserIdOfSession          OpcuaNodeIdServicesVariableSession = 3180
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientUserIdHistory            OpcuaNodeIdServicesVariableSession = 3181
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_AuthenticationMechanism        OpcuaNodeIdServicesVariableSession = 3182
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_Encoding                       OpcuaNodeIdServicesVariableSession = 3183
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_TransportProtocol              OpcuaNodeIdServicesVariableSession = 3184
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SecurityMode                   OpcuaNodeIdServicesVariableSession = 3185
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SecurityPolicyUri              OpcuaNodeIdServicesVariableSession = 3186
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientCertificate              OpcuaNodeIdServicesVariableSession = 3187
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_TotalRequestCount                      OpcuaNodeIdServicesVariableSession = 8898
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_TotalRequestCount                                       OpcuaNodeIdServicesVariableSession = 8900
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_UnauthorizedRequestCount               OpcuaNodeIdServicesVariableSession = 11891
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_UnauthorizedRequestCount                                OpcuaNodeIdServicesVariableSession = 11892
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics                                         OpcuaNodeIdServicesVariableSession = 12816
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_SessionId                               OpcuaNodeIdServicesVariableSession = 12817
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_SessionName                             OpcuaNodeIdServicesVariableSession = 12818
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ClientDescription                       OpcuaNodeIdServicesVariableSession = 12819
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ServerUri                               OpcuaNodeIdServicesVariableSession = 12820
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_EndpointUrl                             OpcuaNodeIdServicesVariableSession = 12821
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_LocaleIds                               OpcuaNodeIdServicesVariableSession = 12822
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ActualSessionTimeout                    OpcuaNodeIdServicesVariableSession = 12823
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_MaxResponseMessageSize                  OpcuaNodeIdServicesVariableSession = 12824
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ClientConnectionTime                    OpcuaNodeIdServicesVariableSession = 12825
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ClientLastContactTime                   OpcuaNodeIdServicesVariableSession = 12826
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_CurrentSubscriptionsCount               OpcuaNodeIdServicesVariableSession = 12827
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_CurrentMonitoredItemsCount              OpcuaNodeIdServicesVariableSession = 12828
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_CurrentPublishRequestsInQueue           OpcuaNodeIdServicesVariableSession = 12829
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_TotalRequestCount                       OpcuaNodeIdServicesVariableSession = 12830
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_UnauthorizedRequestCount                OpcuaNodeIdServicesVariableSession = 12831
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ReadCount                               OpcuaNodeIdServicesVariableSession = 12832
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_HistoryReadCount                        OpcuaNodeIdServicesVariableSession = 12833
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_WriteCount                              OpcuaNodeIdServicesVariableSession = 12834
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_HistoryUpdateCount                      OpcuaNodeIdServicesVariableSession = 12835
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_CallCount                               OpcuaNodeIdServicesVariableSession = 12836
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_CreateMonitoredItemsCount               OpcuaNodeIdServicesVariableSession = 12837
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ModifyMonitoredItemsCount               OpcuaNodeIdServicesVariableSession = 12838
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_SetMonitoringModeCount                  OpcuaNodeIdServicesVariableSession = 12839
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_SetTriggeringCount                      OpcuaNodeIdServicesVariableSession = 12840
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_DeleteMonitoredItemsCount               OpcuaNodeIdServicesVariableSession = 12841
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_CreateSubscriptionCount                 OpcuaNodeIdServicesVariableSession = 12842
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ModifySubscriptionCount                 OpcuaNodeIdServicesVariableSession = 12843
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_SetPublishingModeCount                  OpcuaNodeIdServicesVariableSession = 12844
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_PublishCount                            OpcuaNodeIdServicesVariableSession = 12845
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_RepublishCount                          OpcuaNodeIdServicesVariableSession = 12846
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_TransferSubscriptionsCount              OpcuaNodeIdServicesVariableSession = 12847
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_DeleteSubscriptionsCount                OpcuaNodeIdServicesVariableSession = 12848
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_AddNodesCount                           OpcuaNodeIdServicesVariableSession = 12849
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_AddReferencesCount                      OpcuaNodeIdServicesVariableSession = 12850
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_DeleteNodesCount                        OpcuaNodeIdServicesVariableSession = 12851
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_DeleteReferencesCount                   OpcuaNodeIdServicesVariableSession = 12852
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_BrowseCount                             OpcuaNodeIdServicesVariableSession = 12853
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_BrowseNextCount                         OpcuaNodeIdServicesVariableSession = 12854
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount      OpcuaNodeIdServicesVariableSession = 12855
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_QueryFirstCount                         OpcuaNodeIdServicesVariableSession = 12856
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_QueryNextCount                          OpcuaNodeIdServicesVariableSession = 12857
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_RegisterNodesCount                      OpcuaNodeIdServicesVariableSession = 12858
	OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_UnregisterNodesCount                    OpcuaNodeIdServicesVariableSession = 12859
	OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics                         OpcuaNodeIdServicesVariableSession = 12860
	OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SessionId               OpcuaNodeIdServicesVariableSession = 12861
	OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientUserIdOfSession   OpcuaNodeIdServicesVariableSession = 12862
	OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientUserIdHistory     OpcuaNodeIdServicesVariableSession = 12863
	OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_AuthenticationMechanism OpcuaNodeIdServicesVariableSession = 12864
	OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_Encoding                OpcuaNodeIdServicesVariableSession = 12865
	OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_TransportProtocol       OpcuaNodeIdServicesVariableSession = 12866
	OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SecurityMode            OpcuaNodeIdServicesVariableSession = 12867
	OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SecurityPolicyUri       OpcuaNodeIdServicesVariableSession = 12868
	OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientCertificate       OpcuaNodeIdServicesVariableSession = 12869
)

var OpcuaNodeIdServicesVariableSessionValues []OpcuaNodeIdServicesVariableSession

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableSessionValues = []OpcuaNodeIdServicesVariableSession{
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SubscriptionDiagnosticsArray,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_SessionId,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_SessionName,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ClientDescription,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ServerUri,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_EndpointUrl,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_LocaleIds,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ActualSessionTimeout,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ClientConnectionTime,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ClientLastContactTime,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_CurrentSubscriptionsCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_CurrentMonitoredItemsCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_CurrentPublishRequestsInQueue,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ReadCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_HistoryReadCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_WriteCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_HistoryUpdateCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_CallCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_CreateMonitoredItemsCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ModifyMonitoredItemsCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_SetMonitoringModeCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_SetTriggeringCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_DeleteMonitoredItemsCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_CreateSubscriptionCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ModifySubscriptionCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_SetPublishingModeCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_PublishCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_RepublishCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_TransferSubscriptionsCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_DeleteSubscriptionsCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_AddNodesCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_AddReferencesCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_DeleteNodesCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_DeleteReferencesCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_BrowseCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_BrowseNextCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_TranslateBrowsePathsToNodeIdsCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_QueryFirstCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_QueryNextCount,
		OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_SessionId,
		OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_ClientUserIdOfSession,
		OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_ClientUserIdHistory,
		OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_AuthenticationMechanism,
		OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_Encoding,
		OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_TransportProtocol,
		OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_SecurityMode,
		OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_SecurityPolicyUri,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_RegisterNodesCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_UnregisterNodesCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_MaxResponseMessageSize,
		OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_ClientCertificate,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_SessionId,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_SessionName,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ClientDescription,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ServerUri,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_EndpointUrl,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_LocaleIds,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ActualSessionTimeout,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_MaxResponseMessageSize,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ClientConnectionTime,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ClientLastContactTime,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_CurrentSubscriptionsCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_CurrentMonitoredItemsCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_CurrentPublishRequestsInQueue,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ReadCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_HistoryReadCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_WriteCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_HistoryUpdateCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_CallCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_CreateMonitoredItemsCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ModifyMonitoredItemsCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_SetMonitoringModeCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_SetTriggeringCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_DeleteMonitoredItemsCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_CreateSubscriptionCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ModifySubscriptionCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_SetPublishingModeCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_PublishCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_RepublishCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_TransferSubscriptionsCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_DeleteSubscriptionsCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_AddNodesCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_AddReferencesCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_DeleteNodesCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_DeleteReferencesCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_BrowseCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_BrowseNextCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_QueryFirstCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_QueryNextCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_RegisterNodesCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_UnregisterNodesCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SessionId,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientUserIdOfSession,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientUserIdHistory,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_AuthenticationMechanism,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_Encoding,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_TransportProtocol,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SecurityMode,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SecurityPolicyUri,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientCertificate,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_TotalRequestCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_TotalRequestCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_UnauthorizedRequestCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_UnauthorizedRequestCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_SessionId,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_SessionName,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ClientDescription,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ServerUri,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_EndpointUrl,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_LocaleIds,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ActualSessionTimeout,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_MaxResponseMessageSize,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ClientConnectionTime,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ClientLastContactTime,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_CurrentSubscriptionsCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_CurrentMonitoredItemsCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_CurrentPublishRequestsInQueue,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_TotalRequestCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_UnauthorizedRequestCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ReadCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_HistoryReadCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_WriteCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_HistoryUpdateCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_CallCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_CreateMonitoredItemsCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ModifyMonitoredItemsCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_SetMonitoringModeCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_SetTriggeringCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_DeleteMonitoredItemsCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_CreateSubscriptionCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ModifySubscriptionCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_SetPublishingModeCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_PublishCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_RepublishCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_TransferSubscriptionsCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_DeleteSubscriptionsCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_AddNodesCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_AddReferencesCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_DeleteNodesCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_DeleteReferencesCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_BrowseCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_BrowseNextCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_QueryFirstCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_QueryNextCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_RegisterNodesCount,
		OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_UnregisterNodesCount,
		OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics,
		OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SessionId,
		OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientUserIdOfSession,
		OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientUserIdHistory,
		OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_AuthenticationMechanism,
		OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_Encoding,
		OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_TransportProtocol,
		OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SecurityMode,
		OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SecurityPolicyUri,
		OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientCertificate,
	}
}

func OpcuaNodeIdServicesVariableSessionByValue(value int32) (enum OpcuaNodeIdServicesVariableSession, ok bool) {
	switch value {
	case 11891:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_UnauthorizedRequestCount, true
	case 11892:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_UnauthorizedRequestCount, true
	case 12816:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics, true
	case 12817:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_SessionId, true
	case 12818:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_SessionName, true
	case 12819:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ClientDescription, true
	case 12820:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ServerUri, true
	case 12821:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_EndpointUrl, true
	case 12822:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_LocaleIds, true
	case 12823:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ActualSessionTimeout, true
	case 12824:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_MaxResponseMessageSize, true
	case 12825:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ClientConnectionTime, true
	case 12826:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ClientLastContactTime, true
	case 12827:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_CurrentSubscriptionsCount, true
	case 12828:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_CurrentMonitoredItemsCount, true
	case 12829:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_CurrentPublishRequestsInQueue, true
	case 12830:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_TotalRequestCount, true
	case 12831:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_UnauthorizedRequestCount, true
	case 12832:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ReadCount, true
	case 12833:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_HistoryReadCount, true
	case 12834:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_WriteCount, true
	case 12835:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_HistoryUpdateCount, true
	case 12836:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_CallCount, true
	case 12837:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_CreateMonitoredItemsCount, true
	case 12838:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ModifyMonitoredItemsCount, true
	case 12839:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_SetMonitoringModeCount, true
	case 12840:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_SetTriggeringCount, true
	case 12841:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_DeleteMonitoredItemsCount, true
	case 12842:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_CreateSubscriptionCount, true
	case 12843:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ModifySubscriptionCount, true
	case 12844:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_SetPublishingModeCount, true
	case 12845:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_PublishCount, true
	case 12846:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_RepublishCount, true
	case 12847:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_TransferSubscriptionsCount, true
	case 12848:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_DeleteSubscriptionsCount, true
	case 12849:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_AddNodesCount, true
	case 12850:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_AddReferencesCount, true
	case 12851:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_DeleteNodesCount, true
	case 12852:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_DeleteReferencesCount, true
	case 12853:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_BrowseCount, true
	case 12854:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_BrowseNextCount, true
	case 12855:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount, true
	case 12856:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_QueryFirstCount, true
	case 12857:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_QueryNextCount, true
	case 12858:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_RegisterNodesCount, true
	case 12859:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_UnregisterNodesCount, true
	case 12860:
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics, true
	case 12861:
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SessionId, true
	case 12862:
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientUserIdOfSession, true
	case 12863:
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientUserIdHistory, true
	case 12864:
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_AuthenticationMechanism, true
	case 12865:
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_Encoding, true
	case 12866:
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_TransportProtocol, true
	case 12867:
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SecurityMode, true
	case 12868:
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SecurityPolicyUri, true
	case 12869:
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientCertificate, true
	case 2030:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics, true
	case 2031:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics, true
	case 2032:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SubscriptionDiagnosticsArray, true
	case 2198:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_SessionId, true
	case 2199:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_SessionName, true
	case 2200:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ClientDescription, true
	case 2201:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ServerUri, true
	case 2202:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_EndpointUrl, true
	case 2203:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_LocaleIds, true
	case 2204:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ActualSessionTimeout, true
	case 2205:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ClientConnectionTime, true
	case 2206:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ClientLastContactTime, true
	case 2207:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_CurrentSubscriptionsCount, true
	case 2208:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_CurrentMonitoredItemsCount, true
	case 2209:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_CurrentPublishRequestsInQueue, true
	case 2217:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ReadCount, true
	case 2218:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_HistoryReadCount, true
	case 2219:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_WriteCount, true
	case 2220:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_HistoryUpdateCount, true
	case 2221:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_CallCount, true
	case 2222:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_CreateMonitoredItemsCount, true
	case 2223:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ModifyMonitoredItemsCount, true
	case 2224:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_SetMonitoringModeCount, true
	case 2225:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_SetTriggeringCount, true
	case 2226:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_DeleteMonitoredItemsCount, true
	case 2227:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_CreateSubscriptionCount, true
	case 2228:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ModifySubscriptionCount, true
	case 2229:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_SetPublishingModeCount, true
	case 2230:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_PublishCount, true
	case 2231:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_RepublishCount, true
	case 2232:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_TransferSubscriptionsCount, true
	case 2233:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_DeleteSubscriptionsCount, true
	case 2234:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_AddNodesCount, true
	case 2235:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_AddReferencesCount, true
	case 2236:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_DeleteNodesCount, true
	case 2237:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_DeleteReferencesCount, true
	case 2238:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_BrowseCount, true
	case 2239:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_BrowseNextCount, true
	case 2240:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_TranslateBrowsePathsToNodeIdsCount, true
	case 2241:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_QueryFirstCount, true
	case 2242:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_QueryNextCount, true
	case 2245:
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_SessionId, true
	case 2246:
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_ClientUserIdOfSession, true
	case 2247:
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_ClientUserIdHistory, true
	case 2248:
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_AuthenticationMechanism, true
	case 2249:
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_Encoding, true
	case 2250:
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_TransportProtocol, true
	case 2251:
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_SecurityMode, true
	case 2252:
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_SecurityPolicyUri, true
	case 2730:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_RegisterNodesCount, true
	case 2731:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_UnregisterNodesCount, true
	case 3050:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_MaxResponseMessageSize, true
	case 3058:
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_ClientCertificate, true
	case 3131:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_SessionId, true
	case 3132:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_SessionName, true
	case 3133:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ClientDescription, true
	case 3134:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ServerUri, true
	case 3135:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_EndpointUrl, true
	case 3136:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_LocaleIds, true
	case 3137:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ActualSessionTimeout, true
	case 3138:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_MaxResponseMessageSize, true
	case 3139:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ClientConnectionTime, true
	case 3140:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ClientLastContactTime, true
	case 3141:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_CurrentSubscriptionsCount, true
	case 3142:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_CurrentMonitoredItemsCount, true
	case 3143:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_CurrentPublishRequestsInQueue, true
	case 3151:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ReadCount, true
	case 3152:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_HistoryReadCount, true
	case 3153:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_WriteCount, true
	case 3154:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_HistoryUpdateCount, true
	case 3155:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_CallCount, true
	case 3156:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_CreateMonitoredItemsCount, true
	case 3157:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ModifyMonitoredItemsCount, true
	case 3158:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_SetMonitoringModeCount, true
	case 3159:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_SetTriggeringCount, true
	case 3160:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_DeleteMonitoredItemsCount, true
	case 3161:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_CreateSubscriptionCount, true
	case 3162:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ModifySubscriptionCount, true
	case 3163:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_SetPublishingModeCount, true
	case 3164:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_PublishCount, true
	case 3165:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_RepublishCount, true
	case 3166:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_TransferSubscriptionsCount, true
	case 3167:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_DeleteSubscriptionsCount, true
	case 3168:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_AddNodesCount, true
	case 3169:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_AddReferencesCount, true
	case 3170:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_DeleteNodesCount, true
	case 3171:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_DeleteReferencesCount, true
	case 3172:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_BrowseCount, true
	case 3173:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_BrowseNextCount, true
	case 3174:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount, true
	case 3175:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_QueryFirstCount, true
	case 3176:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_QueryNextCount, true
	case 3177:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_RegisterNodesCount, true
	case 3178:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_UnregisterNodesCount, true
	case 3179:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SessionId, true
	case 3180:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientUserIdOfSession, true
	case 3181:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientUserIdHistory, true
	case 3182:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_AuthenticationMechanism, true
	case 3183:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_Encoding, true
	case 3184:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_TransportProtocol, true
	case 3185:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SecurityMode, true
	case 3186:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SecurityPolicyUri, true
	case 3187:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientCertificate, true
	case 8898:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_TotalRequestCount, true
	case 8900:
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_TotalRequestCount, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableSessionByName(value string) (enum OpcuaNodeIdServicesVariableSession, ok bool) {
	switch value {
	case "SessionDiagnosticsObjectType_SessionDiagnostics_UnauthorizedRequestCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_UnauthorizedRequestCount, true
	case "SessionDiagnosticsVariableType_UnauthorizedRequestCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_UnauthorizedRequestCount, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_SessionId":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_SessionId, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_SessionName":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_SessionName, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_ClientDescription":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ClientDescription, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_ServerUri":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ServerUri, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_EndpointUrl":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_EndpointUrl, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_LocaleIds":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_LocaleIds, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_ActualSessionTimeout":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ActualSessionTimeout, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_MaxResponseMessageSize":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_MaxResponseMessageSize, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_ClientConnectionTime":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ClientConnectionTime, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_ClientLastContactTime":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ClientLastContactTime, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_CurrentSubscriptionsCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_CurrentSubscriptionsCount, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_CurrentMonitoredItemsCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_CurrentMonitoredItemsCount, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_CurrentPublishRequestsInQueue":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_CurrentPublishRequestsInQueue, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_TotalRequestCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_TotalRequestCount, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_UnauthorizedRequestCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_UnauthorizedRequestCount, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_ReadCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ReadCount, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_HistoryReadCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_HistoryReadCount, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_WriteCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_WriteCount, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_HistoryUpdateCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_HistoryUpdateCount, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_CallCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_CallCount, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_CreateMonitoredItemsCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_CreateMonitoredItemsCount, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_ModifyMonitoredItemsCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ModifyMonitoredItemsCount, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_SetMonitoringModeCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_SetMonitoringModeCount, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_SetTriggeringCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_SetTriggeringCount, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_DeleteMonitoredItemsCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_DeleteMonitoredItemsCount, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_CreateSubscriptionCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_CreateSubscriptionCount, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_ModifySubscriptionCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ModifySubscriptionCount, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_SetPublishingModeCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_SetPublishingModeCount, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_PublishCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_PublishCount, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_RepublishCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_RepublishCount, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_TransferSubscriptionsCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_TransferSubscriptionsCount, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_DeleteSubscriptionsCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_DeleteSubscriptionsCount, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_AddNodesCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_AddNodesCount, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_AddReferencesCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_AddReferencesCount, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_DeleteNodesCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_DeleteNodesCount, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_DeleteReferencesCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_DeleteReferencesCount, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_BrowseCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_BrowseCount, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_BrowseNextCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_BrowseNextCount, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_QueryFirstCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_QueryFirstCount, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_QueryNextCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_QueryNextCount, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_RegisterNodesCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_RegisterNodesCount, true
	case "SessionDiagnosticsArrayType_SessionDiagnostics_UnregisterNodesCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_UnregisterNodesCount, true
	case "SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics":
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics, true
	case "SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SessionId":
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SessionId, true
	case "SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientUserIdOfSession":
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientUserIdOfSession, true
	case "SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientUserIdHistory":
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientUserIdHistory, true
	case "SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_AuthenticationMechanism":
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_AuthenticationMechanism, true
	case "SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_Encoding":
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_Encoding, true
	case "SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_TransportProtocol":
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_TransportProtocol, true
	case "SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SecurityMode":
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SecurityMode, true
	case "SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SecurityPolicyUri":
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SecurityPolicyUri, true
	case "SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientCertificate":
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientCertificate, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics, true
	case "SessionDiagnosticsObjectType_SessionSecurityDiagnostics":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics, true
	case "SessionDiagnosticsObjectType_SubscriptionDiagnosticsArray":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SubscriptionDiagnosticsArray, true
	case "SessionDiagnosticsVariableType_SessionId":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_SessionId, true
	case "SessionDiagnosticsVariableType_SessionName":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_SessionName, true
	case "SessionDiagnosticsVariableType_ClientDescription":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ClientDescription, true
	case "SessionDiagnosticsVariableType_ServerUri":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ServerUri, true
	case "SessionDiagnosticsVariableType_EndpointUrl":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_EndpointUrl, true
	case "SessionDiagnosticsVariableType_LocaleIds":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_LocaleIds, true
	case "SessionDiagnosticsVariableType_ActualSessionTimeout":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ActualSessionTimeout, true
	case "SessionDiagnosticsVariableType_ClientConnectionTime":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ClientConnectionTime, true
	case "SessionDiagnosticsVariableType_ClientLastContactTime":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ClientLastContactTime, true
	case "SessionDiagnosticsVariableType_CurrentSubscriptionsCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_CurrentSubscriptionsCount, true
	case "SessionDiagnosticsVariableType_CurrentMonitoredItemsCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_CurrentMonitoredItemsCount, true
	case "SessionDiagnosticsVariableType_CurrentPublishRequestsInQueue":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_CurrentPublishRequestsInQueue, true
	case "SessionDiagnosticsVariableType_ReadCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ReadCount, true
	case "SessionDiagnosticsVariableType_HistoryReadCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_HistoryReadCount, true
	case "SessionDiagnosticsVariableType_WriteCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_WriteCount, true
	case "SessionDiagnosticsVariableType_HistoryUpdateCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_HistoryUpdateCount, true
	case "SessionDiagnosticsVariableType_CallCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_CallCount, true
	case "SessionDiagnosticsVariableType_CreateMonitoredItemsCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_CreateMonitoredItemsCount, true
	case "SessionDiagnosticsVariableType_ModifyMonitoredItemsCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ModifyMonitoredItemsCount, true
	case "SessionDiagnosticsVariableType_SetMonitoringModeCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_SetMonitoringModeCount, true
	case "SessionDiagnosticsVariableType_SetTriggeringCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_SetTriggeringCount, true
	case "SessionDiagnosticsVariableType_DeleteMonitoredItemsCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_DeleteMonitoredItemsCount, true
	case "SessionDiagnosticsVariableType_CreateSubscriptionCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_CreateSubscriptionCount, true
	case "SessionDiagnosticsVariableType_ModifySubscriptionCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ModifySubscriptionCount, true
	case "SessionDiagnosticsVariableType_SetPublishingModeCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_SetPublishingModeCount, true
	case "SessionDiagnosticsVariableType_PublishCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_PublishCount, true
	case "SessionDiagnosticsVariableType_RepublishCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_RepublishCount, true
	case "SessionDiagnosticsVariableType_TransferSubscriptionsCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_TransferSubscriptionsCount, true
	case "SessionDiagnosticsVariableType_DeleteSubscriptionsCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_DeleteSubscriptionsCount, true
	case "SessionDiagnosticsVariableType_AddNodesCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_AddNodesCount, true
	case "SessionDiagnosticsVariableType_AddReferencesCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_AddReferencesCount, true
	case "SessionDiagnosticsVariableType_DeleteNodesCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_DeleteNodesCount, true
	case "SessionDiagnosticsVariableType_DeleteReferencesCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_DeleteReferencesCount, true
	case "SessionDiagnosticsVariableType_BrowseCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_BrowseCount, true
	case "SessionDiagnosticsVariableType_BrowseNextCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_BrowseNextCount, true
	case "SessionDiagnosticsVariableType_TranslateBrowsePathsToNodeIdsCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_TranslateBrowsePathsToNodeIdsCount, true
	case "SessionDiagnosticsVariableType_QueryFirstCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_QueryFirstCount, true
	case "SessionDiagnosticsVariableType_QueryNextCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_QueryNextCount, true
	case "SessionSecurityDiagnosticsType_SessionId":
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_SessionId, true
	case "SessionSecurityDiagnosticsType_ClientUserIdOfSession":
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_ClientUserIdOfSession, true
	case "SessionSecurityDiagnosticsType_ClientUserIdHistory":
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_ClientUserIdHistory, true
	case "SessionSecurityDiagnosticsType_AuthenticationMechanism":
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_AuthenticationMechanism, true
	case "SessionSecurityDiagnosticsType_Encoding":
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_Encoding, true
	case "SessionSecurityDiagnosticsType_TransportProtocol":
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_TransportProtocol, true
	case "SessionSecurityDiagnosticsType_SecurityMode":
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_SecurityMode, true
	case "SessionSecurityDiagnosticsType_SecurityPolicyUri":
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_SecurityPolicyUri, true
	case "SessionDiagnosticsVariableType_RegisterNodesCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_RegisterNodesCount, true
	case "SessionDiagnosticsVariableType_UnregisterNodesCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_UnregisterNodesCount, true
	case "SessionDiagnosticsVariableType_MaxResponseMessageSize":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_MaxResponseMessageSize, true
	case "SessionSecurityDiagnosticsType_ClientCertificate":
		return OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_ClientCertificate, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_SessionId":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_SessionId, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_SessionName":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_SessionName, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_ClientDescription":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ClientDescription, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_ServerUri":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ServerUri, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_EndpointUrl":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_EndpointUrl, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_LocaleIds":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_LocaleIds, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_ActualSessionTimeout":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ActualSessionTimeout, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_MaxResponseMessageSize":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_MaxResponseMessageSize, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_ClientConnectionTime":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ClientConnectionTime, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_ClientLastContactTime":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ClientLastContactTime, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_CurrentSubscriptionsCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_CurrentSubscriptionsCount, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_CurrentMonitoredItemsCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_CurrentMonitoredItemsCount, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_CurrentPublishRequestsInQueue":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_CurrentPublishRequestsInQueue, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_ReadCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ReadCount, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_HistoryReadCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_HistoryReadCount, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_WriteCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_WriteCount, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_HistoryUpdateCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_HistoryUpdateCount, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_CallCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_CallCount, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_CreateMonitoredItemsCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_CreateMonitoredItemsCount, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_ModifyMonitoredItemsCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ModifyMonitoredItemsCount, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_SetMonitoringModeCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_SetMonitoringModeCount, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_SetTriggeringCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_SetTriggeringCount, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_DeleteMonitoredItemsCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_DeleteMonitoredItemsCount, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_CreateSubscriptionCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_CreateSubscriptionCount, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_ModifySubscriptionCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ModifySubscriptionCount, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_SetPublishingModeCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_SetPublishingModeCount, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_PublishCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_PublishCount, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_RepublishCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_RepublishCount, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_TransferSubscriptionsCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_TransferSubscriptionsCount, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_DeleteSubscriptionsCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_DeleteSubscriptionsCount, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_AddNodesCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_AddNodesCount, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_AddReferencesCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_AddReferencesCount, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_DeleteNodesCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_DeleteNodesCount, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_DeleteReferencesCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_DeleteReferencesCount, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_BrowseCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_BrowseCount, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_BrowseNextCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_BrowseNextCount, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_QueryFirstCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_QueryFirstCount, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_QueryNextCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_QueryNextCount, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_RegisterNodesCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_RegisterNodesCount, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_UnregisterNodesCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_UnregisterNodesCount, true
	case "SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SessionId":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SessionId, true
	case "SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientUserIdOfSession":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientUserIdOfSession, true
	case "SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientUserIdHistory":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientUserIdHistory, true
	case "SessionDiagnosticsObjectType_SessionSecurityDiagnostics_AuthenticationMechanism":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_AuthenticationMechanism, true
	case "SessionDiagnosticsObjectType_SessionSecurityDiagnostics_Encoding":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_Encoding, true
	case "SessionDiagnosticsObjectType_SessionSecurityDiagnostics_TransportProtocol":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_TransportProtocol, true
	case "SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SecurityMode":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SecurityMode, true
	case "SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SecurityPolicyUri":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SecurityPolicyUri, true
	case "SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientCertificate":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientCertificate, true
	case "SessionDiagnosticsObjectType_SessionDiagnostics_TotalRequestCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_TotalRequestCount, true
	case "SessionDiagnosticsVariableType_TotalRequestCount":
		return OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_TotalRequestCount, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableSessionKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableSessionValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableSession(structType any) OpcuaNodeIdServicesVariableSession {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableSession {
		if sOpcuaNodeIdServicesVariableSession, ok := typ.(OpcuaNodeIdServicesVariableSession); ok {
			return sOpcuaNodeIdServicesVariableSession
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableSession) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableSession) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableSessionParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableSession, error) {
	return OpcuaNodeIdServicesVariableSessionParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableSessionParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableSession, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableSession", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableSession")
	}
	if enum, ok := OpcuaNodeIdServicesVariableSessionByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableSession")
		return OpcuaNodeIdServicesVariableSession(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableSession) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableSession) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableSession", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableSession) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_UnauthorizedRequestCount:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_UnauthorizedRequestCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_UnauthorizedRequestCount:
		return "SessionDiagnosticsVariableType_UnauthorizedRequestCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics:
		return "SessionDiagnosticsArrayType_SessionDiagnostics"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_SessionId:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_SessionId"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_SessionName:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_SessionName"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ClientDescription:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_ClientDescription"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ServerUri:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_ServerUri"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_EndpointUrl:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_EndpointUrl"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_LocaleIds:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_LocaleIds"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ActualSessionTimeout:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_ActualSessionTimeout"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_MaxResponseMessageSize:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_MaxResponseMessageSize"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ClientConnectionTime:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_ClientConnectionTime"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ClientLastContactTime:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_ClientLastContactTime"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_CurrentSubscriptionsCount:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_CurrentSubscriptionsCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_CurrentMonitoredItemsCount:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_CurrentMonitoredItemsCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_CurrentPublishRequestsInQueue:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_CurrentPublishRequestsInQueue"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_TotalRequestCount:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_TotalRequestCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_UnauthorizedRequestCount:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_UnauthorizedRequestCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ReadCount:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_ReadCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_HistoryReadCount:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_HistoryReadCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_WriteCount:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_WriteCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_HistoryUpdateCount:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_HistoryUpdateCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_CallCount:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_CallCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_CreateMonitoredItemsCount:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_CreateMonitoredItemsCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ModifyMonitoredItemsCount:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_ModifyMonitoredItemsCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_SetMonitoringModeCount:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_SetMonitoringModeCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_SetTriggeringCount:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_SetTriggeringCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_DeleteMonitoredItemsCount:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_DeleteMonitoredItemsCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_CreateSubscriptionCount:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_CreateSubscriptionCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_ModifySubscriptionCount:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_ModifySubscriptionCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_SetPublishingModeCount:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_SetPublishingModeCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_PublishCount:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_PublishCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_RepublishCount:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_RepublishCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_TransferSubscriptionsCount:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_TransferSubscriptionsCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_DeleteSubscriptionsCount:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_DeleteSubscriptionsCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_AddNodesCount:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_AddNodesCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_AddReferencesCount:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_AddReferencesCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_DeleteNodesCount:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_DeleteNodesCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_DeleteReferencesCount:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_DeleteReferencesCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_BrowseCount:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_BrowseCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_BrowseNextCount:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_BrowseNextCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_QueryFirstCount:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_QueryFirstCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_QueryNextCount:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_QueryNextCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_RegisterNodesCount:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_RegisterNodesCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsArrayType_SessionDiagnostics_UnregisterNodesCount:
		return "SessionDiagnosticsArrayType_SessionDiagnostics_UnregisterNodesCount"
	case OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics:
		return "SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics"
	case OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SessionId:
		return "SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SessionId"
	case OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientUserIdOfSession:
		return "SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientUserIdOfSession"
	case OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientUserIdHistory:
		return "SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientUserIdHistory"
	case OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_AuthenticationMechanism:
		return "SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_AuthenticationMechanism"
	case OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_Encoding:
		return "SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_Encoding"
	case OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_TransportProtocol:
		return "SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_TransportProtocol"
	case OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SecurityMode:
		return "SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SecurityMode"
	case OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SecurityPolicyUri:
		return "SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SecurityPolicyUri"
	case OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientCertificate:
		return "SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientCertificate"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics:
		return "SessionDiagnosticsObjectType_SessionDiagnostics"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics:
		return "SessionDiagnosticsObjectType_SessionSecurityDiagnostics"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SubscriptionDiagnosticsArray:
		return "SessionDiagnosticsObjectType_SubscriptionDiagnosticsArray"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_SessionId:
		return "SessionDiagnosticsVariableType_SessionId"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_SessionName:
		return "SessionDiagnosticsVariableType_SessionName"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ClientDescription:
		return "SessionDiagnosticsVariableType_ClientDescription"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ServerUri:
		return "SessionDiagnosticsVariableType_ServerUri"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_EndpointUrl:
		return "SessionDiagnosticsVariableType_EndpointUrl"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_LocaleIds:
		return "SessionDiagnosticsVariableType_LocaleIds"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ActualSessionTimeout:
		return "SessionDiagnosticsVariableType_ActualSessionTimeout"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ClientConnectionTime:
		return "SessionDiagnosticsVariableType_ClientConnectionTime"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ClientLastContactTime:
		return "SessionDiagnosticsVariableType_ClientLastContactTime"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_CurrentSubscriptionsCount:
		return "SessionDiagnosticsVariableType_CurrentSubscriptionsCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_CurrentMonitoredItemsCount:
		return "SessionDiagnosticsVariableType_CurrentMonitoredItemsCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_CurrentPublishRequestsInQueue:
		return "SessionDiagnosticsVariableType_CurrentPublishRequestsInQueue"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ReadCount:
		return "SessionDiagnosticsVariableType_ReadCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_HistoryReadCount:
		return "SessionDiagnosticsVariableType_HistoryReadCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_WriteCount:
		return "SessionDiagnosticsVariableType_WriteCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_HistoryUpdateCount:
		return "SessionDiagnosticsVariableType_HistoryUpdateCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_CallCount:
		return "SessionDiagnosticsVariableType_CallCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_CreateMonitoredItemsCount:
		return "SessionDiagnosticsVariableType_CreateMonitoredItemsCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ModifyMonitoredItemsCount:
		return "SessionDiagnosticsVariableType_ModifyMonitoredItemsCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_SetMonitoringModeCount:
		return "SessionDiagnosticsVariableType_SetMonitoringModeCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_SetTriggeringCount:
		return "SessionDiagnosticsVariableType_SetTriggeringCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_DeleteMonitoredItemsCount:
		return "SessionDiagnosticsVariableType_DeleteMonitoredItemsCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_CreateSubscriptionCount:
		return "SessionDiagnosticsVariableType_CreateSubscriptionCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_ModifySubscriptionCount:
		return "SessionDiagnosticsVariableType_ModifySubscriptionCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_SetPublishingModeCount:
		return "SessionDiagnosticsVariableType_SetPublishingModeCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_PublishCount:
		return "SessionDiagnosticsVariableType_PublishCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_RepublishCount:
		return "SessionDiagnosticsVariableType_RepublishCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_TransferSubscriptionsCount:
		return "SessionDiagnosticsVariableType_TransferSubscriptionsCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_DeleteSubscriptionsCount:
		return "SessionDiagnosticsVariableType_DeleteSubscriptionsCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_AddNodesCount:
		return "SessionDiagnosticsVariableType_AddNodesCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_AddReferencesCount:
		return "SessionDiagnosticsVariableType_AddReferencesCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_DeleteNodesCount:
		return "SessionDiagnosticsVariableType_DeleteNodesCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_DeleteReferencesCount:
		return "SessionDiagnosticsVariableType_DeleteReferencesCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_BrowseCount:
		return "SessionDiagnosticsVariableType_BrowseCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_BrowseNextCount:
		return "SessionDiagnosticsVariableType_BrowseNextCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_TranslateBrowsePathsToNodeIdsCount:
		return "SessionDiagnosticsVariableType_TranslateBrowsePathsToNodeIdsCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_QueryFirstCount:
		return "SessionDiagnosticsVariableType_QueryFirstCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_QueryNextCount:
		return "SessionDiagnosticsVariableType_QueryNextCount"
	case OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_SessionId:
		return "SessionSecurityDiagnosticsType_SessionId"
	case OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_ClientUserIdOfSession:
		return "SessionSecurityDiagnosticsType_ClientUserIdOfSession"
	case OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_ClientUserIdHistory:
		return "SessionSecurityDiagnosticsType_ClientUserIdHistory"
	case OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_AuthenticationMechanism:
		return "SessionSecurityDiagnosticsType_AuthenticationMechanism"
	case OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_Encoding:
		return "SessionSecurityDiagnosticsType_Encoding"
	case OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_TransportProtocol:
		return "SessionSecurityDiagnosticsType_TransportProtocol"
	case OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_SecurityMode:
		return "SessionSecurityDiagnosticsType_SecurityMode"
	case OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_SecurityPolicyUri:
		return "SessionSecurityDiagnosticsType_SecurityPolicyUri"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_RegisterNodesCount:
		return "SessionDiagnosticsVariableType_RegisterNodesCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_UnregisterNodesCount:
		return "SessionDiagnosticsVariableType_UnregisterNodesCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_MaxResponseMessageSize:
		return "SessionDiagnosticsVariableType_MaxResponseMessageSize"
	case OpcuaNodeIdServicesVariableSession_SessionSecurityDiagnosticsType_ClientCertificate:
		return "SessionSecurityDiagnosticsType_ClientCertificate"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_SessionId:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_SessionId"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_SessionName:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_SessionName"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ClientDescription:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_ClientDescription"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ServerUri:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_ServerUri"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_EndpointUrl:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_EndpointUrl"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_LocaleIds:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_LocaleIds"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ActualSessionTimeout:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_ActualSessionTimeout"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_MaxResponseMessageSize:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_MaxResponseMessageSize"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ClientConnectionTime:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_ClientConnectionTime"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ClientLastContactTime:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_ClientLastContactTime"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_CurrentSubscriptionsCount:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_CurrentSubscriptionsCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_CurrentMonitoredItemsCount:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_CurrentMonitoredItemsCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_CurrentPublishRequestsInQueue:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_CurrentPublishRequestsInQueue"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ReadCount:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_ReadCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_HistoryReadCount:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_HistoryReadCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_WriteCount:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_WriteCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_HistoryUpdateCount:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_HistoryUpdateCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_CallCount:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_CallCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_CreateMonitoredItemsCount:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_CreateMonitoredItemsCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ModifyMonitoredItemsCount:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_ModifyMonitoredItemsCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_SetMonitoringModeCount:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_SetMonitoringModeCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_SetTriggeringCount:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_SetTriggeringCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_DeleteMonitoredItemsCount:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_DeleteMonitoredItemsCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_CreateSubscriptionCount:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_CreateSubscriptionCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_ModifySubscriptionCount:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_ModifySubscriptionCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_SetPublishingModeCount:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_SetPublishingModeCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_PublishCount:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_PublishCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_RepublishCount:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_RepublishCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_TransferSubscriptionsCount:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_TransferSubscriptionsCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_DeleteSubscriptionsCount:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_DeleteSubscriptionsCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_AddNodesCount:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_AddNodesCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_AddReferencesCount:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_AddReferencesCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_DeleteNodesCount:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_DeleteNodesCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_DeleteReferencesCount:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_DeleteReferencesCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_BrowseCount:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_BrowseCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_BrowseNextCount:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_BrowseNextCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_QueryFirstCount:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_QueryFirstCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_QueryNextCount:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_QueryNextCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_RegisterNodesCount:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_RegisterNodesCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_UnregisterNodesCount:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_UnregisterNodesCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SessionId:
		return "SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SessionId"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientUserIdOfSession:
		return "SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientUserIdOfSession"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientUserIdHistory:
		return "SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientUserIdHistory"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_AuthenticationMechanism:
		return "SessionDiagnosticsObjectType_SessionSecurityDiagnostics_AuthenticationMechanism"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_Encoding:
		return "SessionDiagnosticsObjectType_SessionSecurityDiagnostics_Encoding"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_TransportProtocol:
		return "SessionDiagnosticsObjectType_SessionSecurityDiagnostics_TransportProtocol"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SecurityMode:
		return "SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SecurityMode"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SecurityPolicyUri:
		return "SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SecurityPolicyUri"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientCertificate:
		return "SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientCertificate"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsObjectType_SessionDiagnostics_TotalRequestCount:
		return "SessionDiagnosticsObjectType_SessionDiagnostics_TotalRequestCount"
	case OpcuaNodeIdServicesVariableSession_SessionDiagnosticsVariableType_TotalRequestCount:
		return "SessionDiagnosticsVariableType_TotalRequestCount"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableSession) String() string {
	return e.PLC4XEnumName()
}
