/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariablePub is an enum
type OpcuaNodeIdServicesVariablePub int32

type IOpcuaNodeIdServicesVariablePub interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_RemoveGroup_InputArguments                                                                       OpcuaNodeIdServicesVariablePub = 14226
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_PublisherId                                                                                      OpcuaNodeIdServicesVariablePub = 14595
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Status_State                                                                                     OpcuaNodeIdServicesVariablePub = 14601
	OpcuaNodeIdServicesVariablePub_PubSubConnectionTypeRemoveGroupMethodType_InputArguments                                                              OpcuaNodeIdServicesVariablePub = 14605
	OpcuaNodeIdServicesVariablePub_PubSubGroupTypeRemoveWriterMethodType_InputArguments                                                                  OpcuaNodeIdServicesVariablePub = 14624
	OpcuaNodeIdServicesVariablePub_PubSubGroupTypeRemoveReaderMethodType_InputArguments                                                                  OpcuaNodeIdServicesVariablePub = 14626
	OpcuaNodeIdServicesVariablePub_PubSubStatusType_State                                                                                                OpcuaNodeIdServicesVariablePub = 14644
	OpcuaNodeIdServicesVariablePub_PubSubState_EnumStrings                                                                                               OpcuaNodeIdServicesVariablePub = 14648
	OpcuaNodeIdServicesVariablePub_PubSubGroupType_Status_State                                                                                          OpcuaNodeIdServicesVariablePub = 15266
	OpcuaNodeIdServicesVariablePub_PubSubStatusEventType_ConnectionId                                                                                    OpcuaNodeIdServicesVariablePub = 15545
	OpcuaNodeIdServicesVariablePub_PubSubStatusEventType_GroupId                                                                                         OpcuaNodeIdServicesVariablePub = 15546
	OpcuaNodeIdServicesVariablePub_PubSubStatusEventType_State                                                                                           OpcuaNodeIdServicesVariablePub = 15547
	OpcuaNodeIdServicesVariablePub_PubSubTransportLimitsExceedEventType_Actual                                                                           OpcuaNodeIdServicesVariablePub = 15561
	OpcuaNodeIdServicesVariablePub_PubSubTransportLimitsExceedEventType_Maximum                                                                          OpcuaNodeIdServicesVariablePub = 15562
	OpcuaNodeIdServicesVariablePub_PubSubCommunicationFailureEventType_Error                                                                             OpcuaNodeIdServicesVariablePub = 15576
	OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_GetSecurityKeys_InputArguments                                                                   OpcuaNodeIdServicesVariablePub = 15908
	OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_GetSecurityKeys_OutputArguments                                                                  OpcuaNodeIdServicesVariablePub = 15909
	OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_GetSecurityGroup_InputArguments                                                                  OpcuaNodeIdServicesVariablePub = 15911
	OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_GetSecurityGroup_OutputArguments                                                                 OpcuaNodeIdServicesVariablePub = 15912
	OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_SecurityGroups_AddSecurityGroup_InputArguments                                                   OpcuaNodeIdServicesVariablePub = 15915
	OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_SecurityGroups_AddSecurityGroup_OutputArguments                                                  OpcuaNodeIdServicesVariablePub = 15916
	OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroup_InputArguments                                                OpcuaNodeIdServicesVariablePub = 15918
	OpcuaNodeIdServicesVariablePub_PubSubGroupType_SecurityMode                                                                                          OpcuaNodeIdServicesVariablePub = 15926
	OpcuaNodeIdServicesVariablePub_PubSubGroupType_SecurityGroupId                                                                                       OpcuaNodeIdServicesVariablePub = 15927
	OpcuaNodeIdServicesVariablePub_PubSubGroupType_SecurityKeyServices                                                                                   OpcuaNodeIdServicesVariablePub = 15928
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Address_NetworkInterface                                                                         OpcuaNodeIdServicesVariablePub = 17202
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_MaxNetworkMessageSize                                                OpcuaNodeIdServicesVariablePub = 17204
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_WriterGroupId                                                        OpcuaNodeIdServicesVariablePub = 17214
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_AddDataSetWriter_InputArguments                                      OpcuaNodeIdServicesVariablePub = 17294
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_AddDataSetWriter_OutputArguments                                     OpcuaNodeIdServicesVariablePub = 17301
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_MaxNetworkMessageSize                                                OpcuaNodeIdServicesVariablePub = 17302
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_TransportProfileUri                                                                              OpcuaNodeIdServicesVariablePub = 17306
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_TransportProfileUri_RestrictToList                                                               OpcuaNodeIdServicesVariablePub = 17309
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_SecurityMode                                                         OpcuaNodeIdServicesVariablePub = 17311
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_SecurityGroupId                                                      OpcuaNodeIdServicesVariablePub = 17312
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_SecurityKeyServices                                                  OpcuaNodeIdServicesVariablePub = 17313
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Status_State                                                         OpcuaNodeIdServicesVariablePub = 17315
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_PublishingInterval                                                   OpcuaNodeIdServicesVariablePub = 17318
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_KeepAliveTime                                                        OpcuaNodeIdServicesVariablePub = 17319
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Priority                                                             OpcuaNodeIdServicesVariablePub = 17321
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_LocaleIds                                                            OpcuaNodeIdServicesVariablePub = 17322
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_RemoveDataSetWriter_InputArguments                                   OpcuaNodeIdServicesVariablePub = 17324
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_SecurityMode                                                         OpcuaNodeIdServicesVariablePub = 17326
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_SecurityGroupId                                                      OpcuaNodeIdServicesVariablePub = 17327
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_SecurityKeyServices                                                  OpcuaNodeIdServicesVariablePub = 17328
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Status_State                                                         OpcuaNodeIdServicesVariablePub = 17330
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_RemoveDataSetReader_InputArguments                                   OpcuaNodeIdServicesVariablePub = 17334
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_AddDataSetReader_InputArguments                                      OpcuaNodeIdServicesVariablePub = 17399
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_AddDataSetReader_OutputArguments                                     OpcuaNodeIdServicesVariablePub = 17400
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_AddWriterGroup_InputArguments                                                                    OpcuaNodeIdServicesVariablePub = 17428
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_AddWriterGroup_OutputArguments                                                                   OpcuaNodeIdServicesVariablePub = 17456
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ConnectionProperties                                                                             OpcuaNodeIdServicesVariablePub = 17485
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_GroupProperties                                                      OpcuaNodeIdServicesVariablePub = 17486
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_GroupProperties                                                      OpcuaNodeIdServicesVariablePub = 17487
	OpcuaNodeIdServicesVariablePub_PubSubGroupType_GroupProperties                                                                                       OpcuaNodeIdServicesVariablePub = 17488
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_AddReaderGroup_InputArguments                                                                    OpcuaNodeIdServicesVariablePub = 17507
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_AddReaderGroup_OutputArguments                                                                   OpcuaNodeIdServicesVariablePub = 17508
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_HeaderLayoutUri                                                      OpcuaNodeIdServicesVariablePub = 17558
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Address_NetworkInterface_Selections                                                              OpcuaNodeIdServicesVariablePub = 17576
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Address_NetworkInterface_SelectionDescriptions                                                   OpcuaNodeIdServicesVariablePub = 17577
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Address_NetworkInterface_RestrictToList                                                          OpcuaNodeIdServicesVariablePub = 17578
	OpcuaNodeIdServicesVariablePub_PubSubConnectionTypeAddWriterGroupMethodType_InputArguments                                                           OpcuaNodeIdServicesVariablePub = 17613
	OpcuaNodeIdServicesVariablePub_PubSubConnectionTypeAddWriterGroupMethodType_OutputArguments                                                          OpcuaNodeIdServicesVariablePub = 17614
	OpcuaNodeIdServicesVariablePub_PubSubConnectionAddReaderGroupGroupMethodType_InputArguments                                                          OpcuaNodeIdServicesVariablePub = 17631
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_TransportProfileUri_Selections                                                                   OpcuaNodeIdServicesVariablePub = 17710
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_TransportProfileUri_SelectionDescriptions                                                        OpcuaNodeIdServicesVariablePub = 17711
	OpcuaNodeIdServicesVariablePub_PubSubConnectionAddReaderGroupGroupMethodType_OutputArguments                                                         OpcuaNodeIdServicesVariablePub = 17720
	OpcuaNodeIdServicesVariablePub_PubSubGroupType_MaxNetworkMessageSize                                                                                 OpcuaNodeIdServicesVariablePub = 17724
	OpcuaNodeIdServicesVariablePub_PubSubGroupTypeAddWriterMethodType_InputArguments                                                                     OpcuaNodeIdServicesVariablePub = 17995
	OpcuaNodeIdServicesVariablePub_PubSubGroupTypeAddWriterMethodType_OutputArguments                                                                    OpcuaNodeIdServicesVariablePub = 17996
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_DiagnosticsLevel                                         OpcuaNodeIdServicesVariablePub = 19108
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation                                         OpcuaNodeIdServicesVariablePub = 19109
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_Active                                  OpcuaNodeIdServicesVariablePub = 19110
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_Classification                          OpcuaNodeIdServicesVariablePub = 19111
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel                        OpcuaNodeIdServicesVariablePub = 19112
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange                         OpcuaNodeIdServicesVariablePub = 19113
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError                                               OpcuaNodeIdServicesVariablePub = 19114
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_Active                                        OpcuaNodeIdServicesVariablePub = 19115
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_Classification                                OpcuaNodeIdServicesVariablePub = 19116
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel                              OpcuaNodeIdServicesVariablePub = 19117
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_TimeFirstChange                               OpcuaNodeIdServicesVariablePub = 19118
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_SubError                                                 OpcuaNodeIdServicesVariablePub = 19120
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError                                      OpcuaNodeIdServicesVariablePub = 19122
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_Active                               OpcuaNodeIdServicesVariablePub = 19123
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_Classification                       OpcuaNodeIdServicesVariablePub = 19124
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel                     OpcuaNodeIdServicesVariablePub = 19125
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange                      OpcuaNodeIdServicesVariablePub = 19126
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod                        OpcuaNodeIdServicesVariablePub = 19127
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active                 OpcuaNodeIdServicesVariablePub = 19128
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification         OpcuaNodeIdServicesVariablePub = 19129
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel       OpcuaNodeIdServicesVariablePub = 19130
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange        OpcuaNodeIdServicesVariablePub = 19131
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent                        OpcuaNodeIdServicesVariablePub = 19132
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active                 OpcuaNodeIdServicesVariablePub = 19133
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification         OpcuaNodeIdServicesVariablePub = 19134
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel       OpcuaNodeIdServicesVariablePub = 19135
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange        OpcuaNodeIdServicesVariablePub = 19136
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError                       OpcuaNodeIdServicesVariablePub = 19137
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active                OpcuaNodeIdServicesVariablePub = 19138
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification        OpcuaNodeIdServicesVariablePub = 19139
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel      OpcuaNodeIdServicesVariablePub = 19140
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange       OpcuaNodeIdServicesVariablePub = 19141
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent                             OpcuaNodeIdServicesVariablePub = 19142
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active                      OpcuaNodeIdServicesVariablePub = 19143
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification              OpcuaNodeIdServicesVariablePub = 19144
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel            OpcuaNodeIdServicesVariablePub = 19145
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange             OpcuaNodeIdServicesVariablePub = 19146
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod                           OpcuaNodeIdServicesVariablePub = 19147
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active                    OpcuaNodeIdServicesVariablePub = 19148
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification            OpcuaNodeIdServicesVariablePub = 19149
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel          OpcuaNodeIdServicesVariablePub = 19150
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange           OpcuaNodeIdServicesVariablePub = 19151
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages                             OpcuaNodeIdServicesVariablePub = 19153
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_Active                      OpcuaNodeIdServicesVariablePub = 19154
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_Classification              OpcuaNodeIdServicesVariablePub = 19155
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_DiagnosticsLevel            OpcuaNodeIdServicesVariablePub = 19156
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_TimeFirstChange             OpcuaNodeIdServicesVariablePub = 19157
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions                             OpcuaNodeIdServicesVariablePub = 19158
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_Active                      OpcuaNodeIdServicesVariablePub = 19159
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_Classification              OpcuaNodeIdServicesVariablePub = 19160
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_DiagnosticsLevel            OpcuaNodeIdServicesVariablePub = 19161
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_TimeFirstChange             OpcuaNodeIdServicesVariablePub = 19162
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors                                OpcuaNodeIdServicesVariablePub = 19163
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_Active                         OpcuaNodeIdServicesVariablePub = 19164
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_Classification                 OpcuaNodeIdServicesVariablePub = 19165
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_DiagnosticsLevel               OpcuaNodeIdServicesVariablePub = 19166
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_TimeFirstChange                OpcuaNodeIdServicesVariablePub = 19167
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetWriters                      OpcuaNodeIdServicesVariablePub = 19168
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel     OpcuaNodeIdServicesVariablePub = 19169
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetWriters                     OpcuaNodeIdServicesVariablePub = 19170
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel    OpcuaNodeIdServicesVariablePub = 19171
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_SecurityTokenID                               OpcuaNodeIdServicesVariablePub = 19172
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_SecurityTokenID_DiagnosticsLevel              OpcuaNodeIdServicesVariablePub = 19173
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID                             OpcuaNodeIdServicesVariablePub = 19174
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID_DiagnosticsLevel            OpcuaNodeIdServicesVariablePub = 19175
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_DiagnosticsLevel                                         OpcuaNodeIdServicesVariablePub = 19177
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation                                         OpcuaNodeIdServicesVariablePub = 19178
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_Active                                  OpcuaNodeIdServicesVariablePub = 19179
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_Classification                          OpcuaNodeIdServicesVariablePub = 19180
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel                        OpcuaNodeIdServicesVariablePub = 19181
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange                         OpcuaNodeIdServicesVariablePub = 19182
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError                                               OpcuaNodeIdServicesVariablePub = 19183
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_Active                                        OpcuaNodeIdServicesVariablePub = 19184
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_Classification                                OpcuaNodeIdServicesVariablePub = 19185
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel                              OpcuaNodeIdServicesVariablePub = 19186
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_TimeFirstChange                               OpcuaNodeIdServicesVariablePub = 19187
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_SubError                                                 OpcuaNodeIdServicesVariablePub = 19189
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError                                      OpcuaNodeIdServicesVariablePub = 19191
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_Active                               OpcuaNodeIdServicesVariablePub = 19192
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_Classification                       OpcuaNodeIdServicesVariablePub = 19193
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel                     OpcuaNodeIdServicesVariablePub = 19194
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange                      OpcuaNodeIdServicesVariablePub = 19195
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod                        OpcuaNodeIdServicesVariablePub = 19196
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active                 OpcuaNodeIdServicesVariablePub = 19197
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification         OpcuaNodeIdServicesVariablePub = 19198
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel       OpcuaNodeIdServicesVariablePub = 19199
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange        OpcuaNodeIdServicesVariablePub = 19200
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent                        OpcuaNodeIdServicesVariablePub = 19201
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active                 OpcuaNodeIdServicesVariablePub = 19202
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification         OpcuaNodeIdServicesVariablePub = 19203
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel       OpcuaNodeIdServicesVariablePub = 19204
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange        OpcuaNodeIdServicesVariablePub = 19205
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError                       OpcuaNodeIdServicesVariablePub = 19206
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active                OpcuaNodeIdServicesVariablePub = 19207
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification        OpcuaNodeIdServicesVariablePub = 19208
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel      OpcuaNodeIdServicesVariablePub = 19209
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange       OpcuaNodeIdServicesVariablePub = 19210
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent                             OpcuaNodeIdServicesVariablePub = 19211
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active                      OpcuaNodeIdServicesVariablePub = 19212
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification              OpcuaNodeIdServicesVariablePub = 19213
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel            OpcuaNodeIdServicesVariablePub = 19214
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange             OpcuaNodeIdServicesVariablePub = 19215
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod                           OpcuaNodeIdServicesVariablePub = 19216
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active                    OpcuaNodeIdServicesVariablePub = 19217
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification            OpcuaNodeIdServicesVariablePub = 19218
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel          OpcuaNodeIdServicesVariablePub = 19219
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange           OpcuaNodeIdServicesVariablePub = 19220
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages                         OpcuaNodeIdServicesVariablePub = 19222
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_Active                  OpcuaNodeIdServicesVariablePub = 19223
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_Classification          OpcuaNodeIdServicesVariablePub = 19224
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_DiagnosticsLevel        OpcuaNodeIdServicesVariablePub = 19225
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_TimeFirstChange         OpcuaNodeIdServicesVariablePub = 19226
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages                  OpcuaNodeIdServicesVariablePub = 19227
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Active           OpcuaNodeIdServicesVariablePub = 19228
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Classification   OpcuaNodeIdServicesVariablePub = 19229
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_DiagnosticsLevel OpcuaNodeIdServicesVariablePub = 19230
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_TimeFirstChange  OpcuaNodeIdServicesVariablePub = 19231
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors                                OpcuaNodeIdServicesVariablePub = 19232
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_Active                         OpcuaNodeIdServicesVariablePub = 19233
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_Classification                 OpcuaNodeIdServicesVariablePub = 19234
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_DiagnosticsLevel               OpcuaNodeIdServicesVariablePub = 19235
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_TimeFirstChange                OpcuaNodeIdServicesVariablePub = 19236
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetReaders                      OpcuaNodeIdServicesVariablePub = 19237
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel     OpcuaNodeIdServicesVariablePub = 19238
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetReaders                     OpcuaNodeIdServicesVariablePub = 19239
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel    OpcuaNodeIdServicesVariablePub = 19240
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_DiagnosticsLevel                                                                     OpcuaNodeIdServicesVariablePub = 19242
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalInformation                                                                     OpcuaNodeIdServicesVariablePub = 19243
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalInformation_Active                                                              OpcuaNodeIdServicesVariablePub = 19244
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalInformation_Classification                                                      OpcuaNodeIdServicesVariablePub = 19245
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalInformation_DiagnosticsLevel                                                    OpcuaNodeIdServicesVariablePub = 19246
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalInformation_TimeFirstChange                                                     OpcuaNodeIdServicesVariablePub = 19247
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalError                                                                           OpcuaNodeIdServicesVariablePub = 19248
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalError_Active                                                                    OpcuaNodeIdServicesVariablePub = 19249
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalError_Classification                                                            OpcuaNodeIdServicesVariablePub = 19250
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalError_DiagnosticsLevel                                                          OpcuaNodeIdServicesVariablePub = 19251
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalError_TimeFirstChange                                                           OpcuaNodeIdServicesVariablePub = 19252
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_SubError                                                                             OpcuaNodeIdServicesVariablePub = 19254
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateError                                                                  OpcuaNodeIdServicesVariablePub = 19256
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateError_Active                                                           OpcuaNodeIdServicesVariablePub = 19257
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateError_Classification                                                   OpcuaNodeIdServicesVariablePub = 19258
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateError_DiagnosticsLevel                                                 OpcuaNodeIdServicesVariablePub = 19259
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateError_TimeFirstChange                                                  OpcuaNodeIdServicesVariablePub = 19260
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod                                                    OpcuaNodeIdServicesVariablePub = 19261
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_Active                                             OpcuaNodeIdServicesVariablePub = 19262
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_Classification                                     OpcuaNodeIdServicesVariablePub = 19263
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel                                   OpcuaNodeIdServicesVariablePub = 19264
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange                                    OpcuaNodeIdServicesVariablePub = 19265
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent                                                    OpcuaNodeIdServicesVariablePub = 19266
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_Active                                             OpcuaNodeIdServicesVariablePub = 19267
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_Classification                                     OpcuaNodeIdServicesVariablePub = 19268
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel                                   OpcuaNodeIdServicesVariablePub = 19269
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange                                    OpcuaNodeIdServicesVariablePub = 19270
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError                                                   OpcuaNodeIdServicesVariablePub = 19271
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_Active                                            OpcuaNodeIdServicesVariablePub = 19272
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_Classification                                    OpcuaNodeIdServicesVariablePub = 19273
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel                                  OpcuaNodeIdServicesVariablePub = 19274
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange                                   OpcuaNodeIdServicesVariablePub = 19275
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StatePausedByParent                                                         OpcuaNodeIdServicesVariablePub = 19276
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_Active                                                  OpcuaNodeIdServicesVariablePub = 19277
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_Classification                                          OpcuaNodeIdServicesVariablePub = 19278
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel                                        OpcuaNodeIdServicesVariablePub = 19279
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_TimeFirstChange                                         OpcuaNodeIdServicesVariablePub = 19280
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod                                                       OpcuaNodeIdServicesVariablePub = 19281
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_Active                                                OpcuaNodeIdServicesVariablePub = 19282
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_Classification                                        OpcuaNodeIdServicesVariablePub = 19283
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel                                      OpcuaNodeIdServicesVariablePub = 19284
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange                                       OpcuaNodeIdServicesVariablePub = 19285
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_LiveValues_ResolvedAddress                                                           OpcuaNodeIdServicesVariablePub = 19287
	OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_LiveValues_ResolvedAddress_DiagnosticsLevel                                          OpcuaNodeIdServicesVariablePub = 19288
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_DiagnosticsLevel                                                                                OpcuaNodeIdServicesVariablePub = 19678
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalInformation                                                                                OpcuaNodeIdServicesVariablePub = 19679
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalInformation_Active                                                                         OpcuaNodeIdServicesVariablePub = 19680
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalInformation_Classification                                                                 OpcuaNodeIdServicesVariablePub = 19681
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalInformation_DiagnosticsLevel                                                               OpcuaNodeIdServicesVariablePub = 19682
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalInformation_TimeFirstChange                                                                OpcuaNodeIdServicesVariablePub = 19683
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalError                                                                                      OpcuaNodeIdServicesVariablePub = 19684
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalError_Active                                                                               OpcuaNodeIdServicesVariablePub = 19685
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalError_Classification                                                                       OpcuaNodeIdServicesVariablePub = 19686
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalError_DiagnosticsLevel                                                                     OpcuaNodeIdServicesVariablePub = 19687
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalError_TimeFirstChange                                                                      OpcuaNodeIdServicesVariablePub = 19688
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_SubError                                                                                        OpcuaNodeIdServicesVariablePub = 19690
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateError                                                                             OpcuaNodeIdServicesVariablePub = 19692
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateError_Active                                                                      OpcuaNodeIdServicesVariablePub = 19693
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateError_Classification                                                              OpcuaNodeIdServicesVariablePub = 19694
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateError_DiagnosticsLevel                                                            OpcuaNodeIdServicesVariablePub = 19695
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateError_TimeFirstChange                                                             OpcuaNodeIdServicesVariablePub = 19696
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByMethod                                                               OpcuaNodeIdServicesVariablePub = 19697
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByMethod_Active                                                        OpcuaNodeIdServicesVariablePub = 19698
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByMethod_Classification                                                OpcuaNodeIdServicesVariablePub = 19699
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByMethod_DiagnosticsLevel                                              OpcuaNodeIdServicesVariablePub = 19700
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByMethod_TimeFirstChange                                               OpcuaNodeIdServicesVariablePub = 19701
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByParent                                                               OpcuaNodeIdServicesVariablePub = 19702
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByParent_Active                                                        OpcuaNodeIdServicesVariablePub = 19703
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByParent_Classification                                                OpcuaNodeIdServicesVariablePub = 19704
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByParent_DiagnosticsLevel                                              OpcuaNodeIdServicesVariablePub = 19705
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByParent_TimeFirstChange                                               OpcuaNodeIdServicesVariablePub = 19706
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalFromError                                                              OpcuaNodeIdServicesVariablePub = 19707
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalFromError_Active                                                       OpcuaNodeIdServicesVariablePub = 19708
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalFromError_Classification                                               OpcuaNodeIdServicesVariablePub = 19709
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalFromError_DiagnosticsLevel                                             OpcuaNodeIdServicesVariablePub = 19710
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalFromError_TimeFirstChange                                              OpcuaNodeIdServicesVariablePub = 19711
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StatePausedByParent                                                                    OpcuaNodeIdServicesVariablePub = 19712
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StatePausedByParent_Active                                                             OpcuaNodeIdServicesVariablePub = 19713
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StatePausedByParent_Classification                                                     OpcuaNodeIdServicesVariablePub = 19714
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StatePausedByParent_DiagnosticsLevel                                                   OpcuaNodeIdServicesVariablePub = 19715
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StatePausedByParent_TimeFirstChange                                                    OpcuaNodeIdServicesVariablePub = 19716
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateDisabledByMethod                                                                  OpcuaNodeIdServicesVariablePub = 19717
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateDisabledByMethod_Active                                                           OpcuaNodeIdServicesVariablePub = 19718
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateDisabledByMethod_Classification                                                   OpcuaNodeIdServicesVariablePub = 19719
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateDisabledByMethod_DiagnosticsLevel                                                 OpcuaNodeIdServicesVariablePub = 19720
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateDisabledByMethod_TimeFirstChange                                                  OpcuaNodeIdServicesVariablePub = 19721
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsCounterType_Active                                                                                   OpcuaNodeIdServicesVariablePub = 19726
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsCounterType_Classification                                                                           OpcuaNodeIdServicesVariablePub = 19727
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsCounterType_DiagnosticsLevel                                                                         OpcuaNodeIdServicesVariablePub = 19728
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsCounterType_TimeFirstChange                                                                          OpcuaNodeIdServicesVariablePub = 19729
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsCounterClassification_EnumStrings                                                                    OpcuaNodeIdServicesVariablePub = 19731
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetWriters                                                         OpcuaNodeIdServicesVariablePub = 19778
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel                                        OpcuaNodeIdServicesVariablePub = 19779
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetReaders                                                         OpcuaNodeIdServicesVariablePub = 19780
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel                                        OpcuaNodeIdServicesVariablePub = 19781
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_OperationalDataSetWriters                                                        OpcuaNodeIdServicesVariablePub = 19782
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_OperationalDataSetWriters_DiagnosticsLevel                                       OpcuaNodeIdServicesVariablePub = 19783
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_OperationalDataSetReaders                                                        OpcuaNodeIdServicesVariablePub = 19784
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_OperationalDataSetReaders_DiagnosticsLevel                                       OpcuaNodeIdServicesVariablePub = 19785
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsConnectionType_LiveValues_ResolvedAddress                                                            OpcuaNodeIdServicesVariablePub = 19832
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsConnectionType_LiveValues_ResolvedAddress_DiagnosticsLevel                                           OpcuaNodeIdServicesVariablePub = 19833
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateError                                                                  OpcuaNodeIdServicesVariablePub = 19849
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateError_Active                                                           OpcuaNodeIdServicesVariablePub = 19850
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateError_Classification                                                   OpcuaNodeIdServicesVariablePub = 19851
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateError_DiagnosticsLevel                                                 OpcuaNodeIdServicesVariablePub = 19852
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateError_TimeFirstChange                                                  OpcuaNodeIdServicesVariablePub = 19853
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod                                                    OpcuaNodeIdServicesVariablePub = 19854
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_Active                                             OpcuaNodeIdServicesVariablePub = 19855
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_Classification                                     OpcuaNodeIdServicesVariablePub = 19856
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_DiagnosticsLevel                                   OpcuaNodeIdServicesVariablePub = 19857
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_TimeFirstChange                                    OpcuaNodeIdServicesVariablePub = 19858
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent                                                    OpcuaNodeIdServicesVariablePub = 19859
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_Active                                             OpcuaNodeIdServicesVariablePub = 19860
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_Classification                                     OpcuaNodeIdServicesVariablePub = 19861
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_DiagnosticsLevel                                   OpcuaNodeIdServicesVariablePub = 19862
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_TimeFirstChange                                    OpcuaNodeIdServicesVariablePub = 19863
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError                                                   OpcuaNodeIdServicesVariablePub = 19864
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_Active                                            OpcuaNodeIdServicesVariablePub = 19865
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_Classification                                    OpcuaNodeIdServicesVariablePub = 19866
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_DiagnosticsLevel                                  OpcuaNodeIdServicesVariablePub = 19867
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_TimeFirstChange                                   OpcuaNodeIdServicesVariablePub = 19868
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent                                                         OpcuaNodeIdServicesVariablePub = 19869
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_Active                                                  OpcuaNodeIdServicesVariablePub = 19870
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_Classification                                          OpcuaNodeIdServicesVariablePub = 19871
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_DiagnosticsLevel                                        OpcuaNodeIdServicesVariablePub = 19872
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_TimeFirstChange                                         OpcuaNodeIdServicesVariablePub = 19873
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod                                                       OpcuaNodeIdServicesVariablePub = 19874
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_Active                                                OpcuaNodeIdServicesVariablePub = 19875
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_Classification                                        OpcuaNodeIdServicesVariablePub = 19876
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_DiagnosticsLevel                                      OpcuaNodeIdServicesVariablePub = 19877
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_TimeFirstChange                                       OpcuaNodeIdServicesVariablePub = 19878
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages                                                         OpcuaNodeIdServicesVariablePub = 19880
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_Active                                                  OpcuaNodeIdServicesVariablePub = 19881
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_Classification                                          OpcuaNodeIdServicesVariablePub = 19882
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_DiagnosticsLevel                                        OpcuaNodeIdServicesVariablePub = 19883
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_TimeFirstChange                                         OpcuaNodeIdServicesVariablePub = 19884
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions                                                         OpcuaNodeIdServicesVariablePub = 19885
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_Active                                                  OpcuaNodeIdServicesVariablePub = 19886
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_Classification                                          OpcuaNodeIdServicesVariablePub = 19887
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_DiagnosticsLevel                                        OpcuaNodeIdServicesVariablePub = 19888
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_TimeFirstChange                                         OpcuaNodeIdServicesVariablePub = 19889
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors                                                            OpcuaNodeIdServicesVariablePub = 19890
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_Active                                                     OpcuaNodeIdServicesVariablePub = 19891
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_Classification                                             OpcuaNodeIdServicesVariablePub = 19892
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_DiagnosticsLevel                                           OpcuaNodeIdServicesVariablePub = 19893
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_TimeFirstChange                                            OpcuaNodeIdServicesVariablePub = 19894
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_ConfiguredDataSetWriters                                                  OpcuaNodeIdServicesVariablePub = 19895
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel                                 OpcuaNodeIdServicesVariablePub = 19896
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_OperationalDataSetWriters                                                 OpcuaNodeIdServicesVariablePub = 19897
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_OperationalDataSetWriters_DiagnosticsLevel                                OpcuaNodeIdServicesVariablePub = 19898
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_SecurityTokenID                                                           OpcuaNodeIdServicesVariablePub = 19899
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_SecurityTokenID_DiagnosticsLevel                                          OpcuaNodeIdServicesVariablePub = 19900
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_TimeToNextTokenID                                                         OpcuaNodeIdServicesVariablePub = 19901
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_TimeToNextTokenID_DiagnosticsLevel                                        OpcuaNodeIdServicesVariablePub = 19902
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateError                                                                  OpcuaNodeIdServicesVariablePub = 19918
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateError_Active                                                           OpcuaNodeIdServicesVariablePub = 19919
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateError_Classification                                                   OpcuaNodeIdServicesVariablePub = 19920
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateError_DiagnosticsLevel                                                 OpcuaNodeIdServicesVariablePub = 19921
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateError_TimeFirstChange                                                  OpcuaNodeIdServicesVariablePub = 19922
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod                                                    OpcuaNodeIdServicesVariablePub = 19923
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_Active                                             OpcuaNodeIdServicesVariablePub = 19924
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_Classification                                     OpcuaNodeIdServicesVariablePub = 19925
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_DiagnosticsLevel                                   OpcuaNodeIdServicesVariablePub = 19926
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_TimeFirstChange                                    OpcuaNodeIdServicesVariablePub = 19927
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent                                                    OpcuaNodeIdServicesVariablePub = 19928
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_Active                                             OpcuaNodeIdServicesVariablePub = 19929
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_Classification                                     OpcuaNodeIdServicesVariablePub = 19930
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_DiagnosticsLevel                                   OpcuaNodeIdServicesVariablePub = 19931
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_TimeFirstChange                                    OpcuaNodeIdServicesVariablePub = 19932
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError                                                   OpcuaNodeIdServicesVariablePub = 19933
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_Active                                            OpcuaNodeIdServicesVariablePub = 19934
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_Classification                                    OpcuaNodeIdServicesVariablePub = 19935
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_DiagnosticsLevel                                  OpcuaNodeIdServicesVariablePub = 19936
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_TimeFirstChange                                   OpcuaNodeIdServicesVariablePub = 19937
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent                                                         OpcuaNodeIdServicesVariablePub = 19938
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_Active                                                  OpcuaNodeIdServicesVariablePub = 19939
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_Classification                                          OpcuaNodeIdServicesVariablePub = 19940
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_DiagnosticsLevel                                        OpcuaNodeIdServicesVariablePub = 19941
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_TimeFirstChange                                         OpcuaNodeIdServicesVariablePub = 19942
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod                                                       OpcuaNodeIdServicesVariablePub = 19943
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_Active                                                OpcuaNodeIdServicesVariablePub = 19944
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_Classification                                        OpcuaNodeIdServicesVariablePub = 19945
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_DiagnosticsLevel                                      OpcuaNodeIdServicesVariablePub = 19946
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_TimeFirstChange                                       OpcuaNodeIdServicesVariablePub = 19947
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages                                                     OpcuaNodeIdServicesVariablePub = 19949
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_Active                                              OpcuaNodeIdServicesVariablePub = 19950
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_Classification                                      OpcuaNodeIdServicesVariablePub = 19951
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_DiagnosticsLevel                                    OpcuaNodeIdServicesVariablePub = 19952
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_TimeFirstChange                                     OpcuaNodeIdServicesVariablePub = 19953
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages                                              OpcuaNodeIdServicesVariablePub = 19954
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_Active                                       OpcuaNodeIdServicesVariablePub = 19955
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_Classification                               OpcuaNodeIdServicesVariablePub = 19956
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_DiagnosticsLevel                             OpcuaNodeIdServicesVariablePub = 19957
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_TimeFirstChange                              OpcuaNodeIdServicesVariablePub = 19958
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors                                                            OpcuaNodeIdServicesVariablePub = 19959
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_Active                                                     OpcuaNodeIdServicesVariablePub = 19960
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_Classification                                             OpcuaNodeIdServicesVariablePub = 19961
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_DiagnosticsLevel                                           OpcuaNodeIdServicesVariablePub = 19962
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_TimeFirstChange                                            OpcuaNodeIdServicesVariablePub = 19963
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_LiveValues_ConfiguredDataSetReaders                                                  OpcuaNodeIdServicesVariablePub = 19964
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel                                 OpcuaNodeIdServicesVariablePub = 19965
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_LiveValues_OperationalDataSetReaders                                                 OpcuaNodeIdServicesVariablePub = 19966
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_LiveValues_OperationalDataSetReaders_DiagnosticsLevel                                OpcuaNodeIdServicesVariablePub = 19967
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateError                                                                OpcuaNodeIdServicesVariablePub = 19983
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateError_Active                                                         OpcuaNodeIdServicesVariablePub = 19984
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateError_Classification                                                 OpcuaNodeIdServicesVariablePub = 19985
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateError_DiagnosticsLevel                                               OpcuaNodeIdServicesVariablePub = 19986
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateError_TimeFirstChange                                                OpcuaNodeIdServicesVariablePub = 19987
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod                                                  OpcuaNodeIdServicesVariablePub = 19988
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_Active                                           OpcuaNodeIdServicesVariablePub = 19989
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_Classification                                   OpcuaNodeIdServicesVariablePub = 19990
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_DiagnosticsLevel                                 OpcuaNodeIdServicesVariablePub = 19991
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_TimeFirstChange                                  OpcuaNodeIdServicesVariablePub = 19992
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent                                                  OpcuaNodeIdServicesVariablePub = 19993
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_Active                                           OpcuaNodeIdServicesVariablePub = 19994
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_Classification                                   OpcuaNodeIdServicesVariablePub = 19995
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_DiagnosticsLevel                                 OpcuaNodeIdServicesVariablePub = 19996
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_TimeFirstChange                                  OpcuaNodeIdServicesVariablePub = 19997
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError                                                 OpcuaNodeIdServicesVariablePub = 19998
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_Active                                          OpcuaNodeIdServicesVariablePub = 19999
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_Classification                                  OpcuaNodeIdServicesVariablePub = 20000
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_DiagnosticsLevel                                OpcuaNodeIdServicesVariablePub = 20001
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_TimeFirstChange                                 OpcuaNodeIdServicesVariablePub = 20002
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent                                                       OpcuaNodeIdServicesVariablePub = 20003
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_Active                                                OpcuaNodeIdServicesVariablePub = 20004
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_Classification                                        OpcuaNodeIdServicesVariablePub = 20005
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_DiagnosticsLevel                                      OpcuaNodeIdServicesVariablePub = 20006
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_TimeFirstChange                                       OpcuaNodeIdServicesVariablePub = 20007
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod                                                     OpcuaNodeIdServicesVariablePub = 20008
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_Active                                              OpcuaNodeIdServicesVariablePub = 20009
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_Classification                                      OpcuaNodeIdServicesVariablePub = 20010
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_DiagnosticsLevel                                    OpcuaNodeIdServicesVariablePub = 20011
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_TimeFirstChange                                     OpcuaNodeIdServicesVariablePub = 20012
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages                                                     OpcuaNodeIdServicesVariablePub = 20014
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_Active                                              OpcuaNodeIdServicesVariablePub = 20015
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_Classification                                      OpcuaNodeIdServicesVariablePub = 20016
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_DiagnosticsLevel                                    OpcuaNodeIdServicesVariablePub = 20017
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_TimeFirstChange                                     OpcuaNodeIdServicesVariablePub = 20018
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_MessageSequenceNumber                                                   OpcuaNodeIdServicesVariablePub = 20019
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_MessageSequenceNumber_DiagnosticsLevel                                  OpcuaNodeIdServicesVariablePub = 20020
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_StatusCode                                                              OpcuaNodeIdServicesVariablePub = 20021
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_StatusCode_DiagnosticsLevel                                             OpcuaNodeIdServicesVariablePub = 20022
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_MajorVersion                                                            OpcuaNodeIdServicesVariablePub = 20023
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_MajorVersion_DiagnosticsLevel                                           OpcuaNodeIdServicesVariablePub = 20024
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_MinorVersion                                                            OpcuaNodeIdServicesVariablePub = 20025
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_MinorVersion_DiagnosticsLevel                                           OpcuaNodeIdServicesVariablePub = 20026
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateError                                                                OpcuaNodeIdServicesVariablePub = 20042
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateError_Active                                                         OpcuaNodeIdServicesVariablePub = 20043
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateError_Classification                                                 OpcuaNodeIdServicesVariablePub = 20044
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateError_DiagnosticsLevel                                               OpcuaNodeIdServicesVariablePub = 20045
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateError_TimeFirstChange                                                OpcuaNodeIdServicesVariablePub = 20046
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod                                                  OpcuaNodeIdServicesVariablePub = 20047
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_Active                                           OpcuaNodeIdServicesVariablePub = 20048
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_Classification                                   OpcuaNodeIdServicesVariablePub = 20049
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_DiagnosticsLevel                                 OpcuaNodeIdServicesVariablePub = 20050
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_TimeFirstChange                                  OpcuaNodeIdServicesVariablePub = 20051
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent                                                  OpcuaNodeIdServicesVariablePub = 20052
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_Active                                           OpcuaNodeIdServicesVariablePub = 20053
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_Classification                                   OpcuaNodeIdServicesVariablePub = 20054
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_DiagnosticsLevel                                 OpcuaNodeIdServicesVariablePub = 20055
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_TimeFirstChange                                  OpcuaNodeIdServicesVariablePub = 20056
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError                                                 OpcuaNodeIdServicesVariablePub = 20057
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_Active                                          OpcuaNodeIdServicesVariablePub = 20058
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_Classification                                  OpcuaNodeIdServicesVariablePub = 20059
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_DiagnosticsLevel                                OpcuaNodeIdServicesVariablePub = 20060
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_TimeFirstChange                                 OpcuaNodeIdServicesVariablePub = 20061
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent                                                       OpcuaNodeIdServicesVariablePub = 20062
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_Active                                                OpcuaNodeIdServicesVariablePub = 20063
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_Classification                                        OpcuaNodeIdServicesVariablePub = 20064
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_DiagnosticsLevel                                      OpcuaNodeIdServicesVariablePub = 20065
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_TimeFirstChange                                       OpcuaNodeIdServicesVariablePub = 20066
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod                                                     OpcuaNodeIdServicesVariablePub = 20067
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_Active                                              OpcuaNodeIdServicesVariablePub = 20068
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_Classification                                      OpcuaNodeIdServicesVariablePub = 20069
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_DiagnosticsLevel                                    OpcuaNodeIdServicesVariablePub = 20070
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_TimeFirstChange                                     OpcuaNodeIdServicesVariablePub = 20071
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages                                                     OpcuaNodeIdServicesVariablePub = 20073
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_Active                                              OpcuaNodeIdServicesVariablePub = 20074
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_Classification                                      OpcuaNodeIdServicesVariablePub = 20075
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_DiagnosticsLevel                                    OpcuaNodeIdServicesVariablePub = 20076
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_TimeFirstChange                                     OpcuaNodeIdServicesVariablePub = 20077
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors                                                          OpcuaNodeIdServicesVariablePub = 20078
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_Active                                                   OpcuaNodeIdServicesVariablePub = 20079
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_Classification                                           OpcuaNodeIdServicesVariablePub = 20080
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_DiagnosticsLevel                                         OpcuaNodeIdServicesVariablePub = 20081
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_TimeFirstChange                                          OpcuaNodeIdServicesVariablePub = 20082
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_MessageSequenceNumber                                                   OpcuaNodeIdServicesVariablePub = 20083
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_MessageSequenceNumber_DiagnosticsLevel                                  OpcuaNodeIdServicesVariablePub = 20084
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_StatusCode                                                              OpcuaNodeIdServicesVariablePub = 20085
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_StatusCode_DiagnosticsLevel                                             OpcuaNodeIdServicesVariablePub = 20086
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_MajorVersion                                                            OpcuaNodeIdServicesVariablePub = 20087
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_MajorVersion_DiagnosticsLevel                                           OpcuaNodeIdServicesVariablePub = 20088
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_MinorVersion                                                            OpcuaNodeIdServicesVariablePub = 20089
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_MinorVersion_DiagnosticsLevel                                           OpcuaNodeIdServicesVariablePub = 20090
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_SecurityTokenID                                                         OpcuaNodeIdServicesVariablePub = 20091
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_SecurityTokenID_DiagnosticsLevel                                        OpcuaNodeIdServicesVariablePub = 20092
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_TimeToNextTokenID                                                       OpcuaNodeIdServicesVariablePub = 20093
	OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_TimeToNextTokenID_DiagnosticsLevel                                      OpcuaNodeIdServicesVariablePub = 20094
	OpcuaNodeIdServicesVariablePub_PubSubGroupTypeAddReaderMethodType_InputArguments                                                                     OpcuaNodeIdServicesVariablePub = 21088
	OpcuaNodeIdServicesVariablePub_PubSubGroupTypeAddReaderMethodType_OutputArguments                                                                    OpcuaNodeIdServicesVariablePub = 21089
	OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxPubSubConnections                                                                           OpcuaNodeIdServicesVariablePub = 23833
	OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxWriterGroups                                                                                OpcuaNodeIdServicesVariablePub = 23834
	OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxReaderGroups                                                                                OpcuaNodeIdServicesVariablePub = 23835
	OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxDataSetWriters                                                                              OpcuaNodeIdServicesVariablePub = 23836
	OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxDataSetReaders                                                                              OpcuaNodeIdServicesVariablePub = 23837
	OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxFieldsPerDataSet                                                                            OpcuaNodeIdServicesVariablePub = 23838
	OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_SecurityGroups_AddSecurityGroupFolder_InputArguments                                             OpcuaNodeIdServicesVariablePub = 25272
	OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_SecurityGroups_AddSecurityGroupFolder_OutputArguments                                            OpcuaNodeIdServicesVariablePub = 25273
	OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroupFolder_InputArguments                                          OpcuaNodeIdServicesVariablePub = 25275
	OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_SecurityGroups_SupportedSecurityPolicyUris                                                       OpcuaNodeIdServicesVariablePub = 25276
	OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_KeyPushTargets_AddPushTarget_InputArguments                                                      OpcuaNodeIdServicesVariablePub = 25279
	OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_KeyPushTargets_AddPushTarget_OutputArguments                                                     OpcuaNodeIdServicesVariablePub = 25280
	OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_KeyPushTargets_RemovePushTarget_InputArguments                                                   OpcuaNodeIdServicesVariablePub = 25282
	OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_KeyPushTargets_AddPushTargetFolder_InputArguments                                                OpcuaNodeIdServicesVariablePub = 25284
	OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_KeyPushTargets_AddPushTargetFolder_OutputArguments                                               OpcuaNodeIdServicesVariablePub = 25285
	OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_KeyPushTargets_RemovePushTargetFolder_InputArguments                                             OpcuaNodeIdServicesVariablePub = 25287
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_SecurityPolicyUri                                                                             OpcuaNodeIdServicesVariablePub = 25340
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTarget_InputArguments                           OpcuaNodeIdServicesVariablePub = 25349
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTarget_OutputArguments                          OpcuaNodeIdServicesVariablePub = 25350
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTarget_InputArguments                        OpcuaNodeIdServicesVariablePub = 25352
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTargetFolder_InputArguments                     OpcuaNodeIdServicesVariablePub = 25354
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTargetFolder_OutputArguments                    OpcuaNodeIdServicesVariablePub = 25355
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTargetFolder_InputArguments                  OpcuaNodeIdServicesVariablePub = 25357
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_SecurityPolicyUri                                            OpcuaNodeIdServicesVariablePub = 25361
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_AddPushTarget_InputArguments                                                            OpcuaNodeIdServicesVariablePub = 25367
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_AddPushTarget_OutputArguments                                                           OpcuaNodeIdServicesVariablePub = 25368
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_RemovePushTarget_InputArguments                                                         OpcuaNodeIdServicesVariablePub = 25370
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_AddPushTargetFolder_InputArguments                                                      OpcuaNodeIdServicesVariablePub = 25372
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_AddPushTargetFolder_OutputArguments                                                     OpcuaNodeIdServicesVariablePub = 25373
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_RemovePushTargetFolder_InputArguments                                                   OpcuaNodeIdServicesVariablePub = 25375
	OpcuaNodeIdServicesVariablePub_PubSubConfigurationType_ReserveIds_InputArguments                                                                     OpcuaNodeIdServicesVariablePub = 25506
	OpcuaNodeIdServicesVariablePub_PubSubConfigurationType_ReserveIds_OutputArguments                                                                    OpcuaNodeIdServicesVariablePub = 25507
	OpcuaNodeIdServicesVariablePub_PubSubConfigurationType_CloseAndUpdate_InputArguments                                                                 OpcuaNodeIdServicesVariablePub = 25509
	OpcuaNodeIdServicesVariablePub_PubSubConfigurationType_CloseAndUpdate_OutputArguments                                                                OpcuaNodeIdServicesVariablePub = 25510
	OpcuaNodeIdServicesVariablePub_PubSubConfigurationTypeReserveIdsMethodType_InputArguments                                                            OpcuaNodeIdServicesVariablePub = 25512
	OpcuaNodeIdServicesVariablePub_PubSubConfigurationTypeReserveIdsMethodType_OutputArguments                                                           OpcuaNodeIdServicesVariablePub = 25513
	OpcuaNodeIdServicesVariablePub_PubSubConfigurationTypeCloseAndUpdateMethodType_InputArguments                                                        OpcuaNodeIdServicesVariablePub = 25515
	OpcuaNodeIdServicesVariablePub_PubSubConfigurationTypeCloseAndUpdateMethodType_OutputArguments                                                       OpcuaNodeIdServicesVariablePub = 25516
	OpcuaNodeIdServicesVariablePub_PubSubConfigurationRefMask_OptionSetValues                                                                            OpcuaNodeIdServicesVariablePub = 25518
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_SecurityGroupId                                                 OpcuaNodeIdServicesVariablePub = 25627
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_KeyLifetime                                                     OpcuaNodeIdServicesVariablePub = 25628
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_SecurityPolicyUri                                               OpcuaNodeIdServicesVariablePub = 25629
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_MaxFutureKeyCount                                               OpcuaNodeIdServicesVariablePub = 25630
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_MaxPastKeyCount                                                 OpcuaNodeIdServicesVariablePub = 25631
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_ApplicationUri                                                                                OpcuaNodeIdServicesVariablePub = 25634
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_EndpointUrl                                                                                   OpcuaNodeIdServicesVariablePub = 25635
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_UserTokenType                                                                                 OpcuaNodeIdServicesVariablePub = 25636
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_RequestedKeyCount                                                                             OpcuaNodeIdServicesVariablePub = 25637
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_RetryInterval                                                                                 OpcuaNodeIdServicesVariablePub = 25638
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_LastPushExecutionTime                                                                         OpcuaNodeIdServicesVariablePub = 25639
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_LastPushErrorTime                                                                             OpcuaNodeIdServicesVariablePub = 25640
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_ConnectSecurityGroups_InputArguments                                                          OpcuaNodeIdServicesVariablePub = 25642
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_ConnectSecurityGroups_OutputArguments                                                         OpcuaNodeIdServicesVariablePub = 25643
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_DisconnectSecurityGroups_InputArguments                                                       OpcuaNodeIdServicesVariablePub = 25645
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_DisconnectSecurityGroups_OutputArguments                                                      OpcuaNodeIdServicesVariablePub = 25646
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ApplicationUri                                               OpcuaNodeIdServicesVariablePub = 25648
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_EndpointUrl                                                  OpcuaNodeIdServicesVariablePub = 25649
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_UserTokenType                                                OpcuaNodeIdServicesVariablePub = 25650
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_RequestedKeyCount                                            OpcuaNodeIdServicesVariablePub = 25651
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_RetryInterval                                                OpcuaNodeIdServicesVariablePub = 25652
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_LastPushExecutionTime                                        OpcuaNodeIdServicesVariablePub = 25653
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_LastPushErrorTime                                            OpcuaNodeIdServicesVariablePub = 25654
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ConnectSecurityGroups_InputArguments                         OpcuaNodeIdServicesVariablePub = 25656
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ConnectSecurityGroups_OutputArguments                        OpcuaNodeIdServicesVariablePub = 25657
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_DisconnectSecurityGroups_InputArguments                      OpcuaNodeIdServicesVariablePub = 25659
	OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_DisconnectSecurityGroups_OutputArguments                     OpcuaNodeIdServicesVariablePub = 25660
	OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxDataSetWritersPerGroup                                                                      OpcuaNodeIdServicesVariablePub = 32651
	OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxNetworkMessageSizeDatagram                                                                  OpcuaNodeIdServicesVariablePub = 32652
	OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxNetworkMessageSizeBroker                                                                    OpcuaNodeIdServicesVariablePub = 32653
	OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_SupportSecurityKeyPull                                                                         OpcuaNodeIdServicesVariablePub = 32654
	OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_SupportSecurityKeyPush                                                                         OpcuaNodeIdServicesVariablePub = 32655
	OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxSecurityGroups                                                                              OpcuaNodeIdServicesVariablePub = 32844
	OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxPushTargets                                                                                 OpcuaNodeIdServicesVariablePub = 32845
	OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxPublishedDataSets                                                                           OpcuaNodeIdServicesVariablePub = 32846
	OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxStandaloneSubscribedDataSets                                                                OpcuaNodeIdServicesVariablePub = 32847
	OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_SupportSecurityKeyServer                                                                       OpcuaNodeIdServicesVariablePub = 32848
)

var OpcuaNodeIdServicesVariablePubValues []OpcuaNodeIdServicesVariablePub

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariablePubValues = []OpcuaNodeIdServicesVariablePub{
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_RemoveGroup_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_PublisherId,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Status_State,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionTypeRemoveGroupMethodType_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubGroupTypeRemoveWriterMethodType_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubGroupTypeRemoveReaderMethodType_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubStatusType_State,
		OpcuaNodeIdServicesVariablePub_PubSubState_EnumStrings,
		OpcuaNodeIdServicesVariablePub_PubSubGroupType_Status_State,
		OpcuaNodeIdServicesVariablePub_PubSubStatusEventType_ConnectionId,
		OpcuaNodeIdServicesVariablePub_PubSubStatusEventType_GroupId,
		OpcuaNodeIdServicesVariablePub_PubSubStatusEventType_State,
		OpcuaNodeIdServicesVariablePub_PubSubTransportLimitsExceedEventType_Actual,
		OpcuaNodeIdServicesVariablePub_PubSubTransportLimitsExceedEventType_Maximum,
		OpcuaNodeIdServicesVariablePub_PubSubCommunicationFailureEventType_Error,
		OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_GetSecurityKeys_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_GetSecurityKeys_OutputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_GetSecurityGroup_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_GetSecurityGroup_OutputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_SecurityGroups_AddSecurityGroup_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_SecurityGroups_AddSecurityGroup_OutputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroup_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubGroupType_SecurityMode,
		OpcuaNodeIdServicesVariablePub_PubSubGroupType_SecurityGroupId,
		OpcuaNodeIdServicesVariablePub_PubSubGroupType_SecurityKeyServices,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Address_NetworkInterface,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_MaxNetworkMessageSize,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_WriterGroupId,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_AddDataSetWriter_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_AddDataSetWriter_OutputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_MaxNetworkMessageSize,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_TransportProfileUri,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_TransportProfileUri_RestrictToList,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_SecurityMode,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_SecurityGroupId,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_SecurityKeyServices,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Status_State,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_PublishingInterval,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_KeepAliveTime,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Priority,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_LocaleIds,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_RemoveDataSetWriter_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_SecurityMode,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_SecurityGroupId,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_SecurityKeyServices,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Status_State,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_RemoveDataSetReader_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_AddDataSetReader_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_AddDataSetReader_OutputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_AddWriterGroup_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_AddWriterGroup_OutputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ConnectionProperties,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_GroupProperties,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_GroupProperties,
		OpcuaNodeIdServicesVariablePub_PubSubGroupType_GroupProperties,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_AddReaderGroup_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_AddReaderGroup_OutputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_HeaderLayoutUri,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Address_NetworkInterface_Selections,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Address_NetworkInterface_SelectionDescriptions,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Address_NetworkInterface_RestrictToList,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionTypeAddWriterGroupMethodType_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionTypeAddWriterGroupMethodType_OutputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionAddReaderGroupGroupMethodType_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_TransportProfileUri_Selections,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_TransportProfileUri_SelectionDescriptions,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionAddReaderGroupGroupMethodType_OutputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubGroupType_MaxNetworkMessageSize,
		OpcuaNodeIdServicesVariablePub_PubSubGroupTypeAddWriterMethodType_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubGroupTypeAddWriterMethodType_OutputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_Active,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_Active,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_SubError,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_Active,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_Active,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_Active,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_Active,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetWriters,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetWriters,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_SecurityTokenID,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_SecurityTokenID_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_Active,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_Active,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_SubError,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_Active,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_Active,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Active,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_Active,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetReaders,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetReaders,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalInformation,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalInformation_Active,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalInformation_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalInformation_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalInformation_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalError,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalError_Active,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalError_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_SubError,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateError,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateError_Active,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateError_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_Active,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_Active,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_Active,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StatePausedByParent,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_Active,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_Active,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_LiveValues_ResolvedAddress,
		OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_LiveValues_ResolvedAddress_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalInformation,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalInformation_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalInformation_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalInformation_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalInformation_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalError,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalError_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalError_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_SubError,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateError,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateError_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateError_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByMethod,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByMethod_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByMethod_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByParent,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByParent_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByParent_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalFromError,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalFromError_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalFromError_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalFromError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalFromError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StatePausedByParent,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StatePausedByParent_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StatePausedByParent_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StatePausedByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StatePausedByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateDisabledByMethod,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateDisabledByMethod_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateDisabledByMethod_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateDisabledByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateDisabledByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsCounterType_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsCounterType_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsCounterType_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsCounterType_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsCounterClassification_EnumStrings,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetWriters,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetReaders,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_OperationalDataSetWriters,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_OperationalDataSetWriters_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_OperationalDataSetReaders,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_OperationalDataSetReaders_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsConnectionType_LiveValues_ResolvedAddress,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsConnectionType_LiveValues_ResolvedAddress_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateError,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateError_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateError_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_ConfiguredDataSetWriters,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_OperationalDataSetWriters,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_OperationalDataSetWriters_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_SecurityTokenID,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_SecurityTokenID_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_TimeToNextTokenID,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_TimeToNextTokenID_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateError,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateError_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateError_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_LiveValues_ConfiguredDataSetReaders,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_LiveValues_OperationalDataSetReaders,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_LiveValues_OperationalDataSetReaders_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateError,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateError_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateError_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_MessageSequenceNumber,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_MessageSequenceNumber_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_StatusCode,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_StatusCode_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_MajorVersion,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_MajorVersion_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_MinorVersion,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_MinorVersion_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateError,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateError_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateError_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_Active,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_Classification,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_TimeFirstChange,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_MessageSequenceNumber,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_MessageSequenceNumber_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_StatusCode,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_StatusCode_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_MajorVersion,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_MajorVersion_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_MinorVersion,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_MinorVersion_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_SecurityTokenID,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_SecurityTokenID_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_TimeToNextTokenID,
		OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_TimeToNextTokenID_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePub_PubSubGroupTypeAddReaderMethodType_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubGroupTypeAddReaderMethodType_OutputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxPubSubConnections,
		OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxWriterGroups,
		OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxReaderGroups,
		OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxDataSetWriters,
		OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxDataSetReaders,
		OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxFieldsPerDataSet,
		OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_SecurityGroups_AddSecurityGroupFolder_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_SecurityGroups_AddSecurityGroupFolder_OutputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroupFolder_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_SecurityGroups_SupportedSecurityPolicyUris,
		OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_KeyPushTargets_AddPushTarget_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_KeyPushTargets_AddPushTarget_OutputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_KeyPushTargets_RemovePushTarget_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_KeyPushTargets_AddPushTargetFolder_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_KeyPushTargets_AddPushTargetFolder_OutputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_KeyPushTargets_RemovePushTargetFolder_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_SecurityPolicyUri,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTarget_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTarget_OutputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTarget_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTargetFolder_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTargetFolder_OutputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTargetFolder_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_SecurityPolicyUri,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_AddPushTarget_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_AddPushTarget_OutputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_RemovePushTarget_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_AddPushTargetFolder_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_AddPushTargetFolder_OutputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_RemovePushTargetFolder_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubConfigurationType_ReserveIds_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubConfigurationType_ReserveIds_OutputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubConfigurationType_CloseAndUpdate_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubConfigurationType_CloseAndUpdate_OutputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubConfigurationTypeReserveIdsMethodType_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubConfigurationTypeReserveIdsMethodType_OutputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubConfigurationTypeCloseAndUpdateMethodType_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubConfigurationTypeCloseAndUpdateMethodType_OutputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubConfigurationRefMask_OptionSetValues,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_SecurityGroupId,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_KeyLifetime,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_SecurityPolicyUri,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_MaxFutureKeyCount,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_MaxPastKeyCount,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_ApplicationUri,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_EndpointUrl,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_UserTokenType,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_RequestedKeyCount,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_RetryInterval,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_LastPushExecutionTime,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_LastPushErrorTime,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_ConnectSecurityGroups_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_ConnectSecurityGroups_OutputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_DisconnectSecurityGroups_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_DisconnectSecurityGroups_OutputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ApplicationUri,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_EndpointUrl,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_UserTokenType,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_RequestedKeyCount,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_RetryInterval,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_LastPushExecutionTime,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_LastPushErrorTime,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ConnectSecurityGroups_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ConnectSecurityGroups_OutputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_DisconnectSecurityGroups_InputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_DisconnectSecurityGroups_OutputArguments,
		OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxDataSetWritersPerGroup,
		OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxNetworkMessageSizeDatagram,
		OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxNetworkMessageSizeBroker,
		OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_SupportSecurityKeyPull,
		OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_SupportSecurityKeyPush,
		OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxSecurityGroups,
		OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxPushTargets,
		OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxPublishedDataSets,
		OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxStandaloneSubscribedDataSets,
		OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_SupportSecurityKeyServer,
	}
}

func OpcuaNodeIdServicesVariablePubByValue(value int32) (enum OpcuaNodeIdServicesVariablePub, ok bool) {
	switch value {
	case 14226:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_RemoveGroup_InputArguments, true
	case 14595:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_PublisherId, true
	case 14601:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Status_State, true
	case 14605:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionTypeRemoveGroupMethodType_InputArguments, true
	case 14624:
		return OpcuaNodeIdServicesVariablePub_PubSubGroupTypeRemoveWriterMethodType_InputArguments, true
	case 14626:
		return OpcuaNodeIdServicesVariablePub_PubSubGroupTypeRemoveReaderMethodType_InputArguments, true
	case 14644:
		return OpcuaNodeIdServicesVariablePub_PubSubStatusType_State, true
	case 14648:
		return OpcuaNodeIdServicesVariablePub_PubSubState_EnumStrings, true
	case 15266:
		return OpcuaNodeIdServicesVariablePub_PubSubGroupType_Status_State, true
	case 15545:
		return OpcuaNodeIdServicesVariablePub_PubSubStatusEventType_ConnectionId, true
	case 15546:
		return OpcuaNodeIdServicesVariablePub_PubSubStatusEventType_GroupId, true
	case 15547:
		return OpcuaNodeIdServicesVariablePub_PubSubStatusEventType_State, true
	case 15561:
		return OpcuaNodeIdServicesVariablePub_PubSubTransportLimitsExceedEventType_Actual, true
	case 15562:
		return OpcuaNodeIdServicesVariablePub_PubSubTransportLimitsExceedEventType_Maximum, true
	case 15576:
		return OpcuaNodeIdServicesVariablePub_PubSubCommunicationFailureEventType_Error, true
	case 15908:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_GetSecurityKeys_InputArguments, true
	case 15909:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_GetSecurityKeys_OutputArguments, true
	case 15911:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_GetSecurityGroup_InputArguments, true
	case 15912:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_GetSecurityGroup_OutputArguments, true
	case 15915:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_SecurityGroups_AddSecurityGroup_InputArguments, true
	case 15916:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_SecurityGroups_AddSecurityGroup_OutputArguments, true
	case 15918:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroup_InputArguments, true
	case 15926:
		return OpcuaNodeIdServicesVariablePub_PubSubGroupType_SecurityMode, true
	case 15927:
		return OpcuaNodeIdServicesVariablePub_PubSubGroupType_SecurityGroupId, true
	case 15928:
		return OpcuaNodeIdServicesVariablePub_PubSubGroupType_SecurityKeyServices, true
	case 17202:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Address_NetworkInterface, true
	case 17204:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_MaxNetworkMessageSize, true
	case 17214:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_WriterGroupId, true
	case 17294:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_AddDataSetWriter_InputArguments, true
	case 17301:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_AddDataSetWriter_OutputArguments, true
	case 17302:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_MaxNetworkMessageSize, true
	case 17306:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_TransportProfileUri, true
	case 17309:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_TransportProfileUri_RestrictToList, true
	case 17311:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_SecurityMode, true
	case 17312:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_SecurityGroupId, true
	case 17313:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_SecurityKeyServices, true
	case 17315:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Status_State, true
	case 17318:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_PublishingInterval, true
	case 17319:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_KeepAliveTime, true
	case 17321:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Priority, true
	case 17322:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_LocaleIds, true
	case 17324:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_RemoveDataSetWriter_InputArguments, true
	case 17326:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_SecurityMode, true
	case 17327:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_SecurityGroupId, true
	case 17328:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_SecurityKeyServices, true
	case 17330:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Status_State, true
	case 17334:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_RemoveDataSetReader_InputArguments, true
	case 17399:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_AddDataSetReader_InputArguments, true
	case 17400:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_AddDataSetReader_OutputArguments, true
	case 17428:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_AddWriterGroup_InputArguments, true
	case 17456:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_AddWriterGroup_OutputArguments, true
	case 17485:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ConnectionProperties, true
	case 17486:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_GroupProperties, true
	case 17487:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_GroupProperties, true
	case 17488:
		return OpcuaNodeIdServicesVariablePub_PubSubGroupType_GroupProperties, true
	case 17507:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_AddReaderGroup_InputArguments, true
	case 17508:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_AddReaderGroup_OutputArguments, true
	case 17558:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_HeaderLayoutUri, true
	case 17576:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Address_NetworkInterface_Selections, true
	case 17577:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Address_NetworkInterface_SelectionDescriptions, true
	case 17578:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Address_NetworkInterface_RestrictToList, true
	case 17613:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionTypeAddWriterGroupMethodType_InputArguments, true
	case 17614:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionTypeAddWriterGroupMethodType_OutputArguments, true
	case 17631:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionAddReaderGroupGroupMethodType_InputArguments, true
	case 17710:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_TransportProfileUri_Selections, true
	case 17711:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_TransportProfileUri_SelectionDescriptions, true
	case 17720:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionAddReaderGroupGroupMethodType_OutputArguments, true
	case 17724:
		return OpcuaNodeIdServicesVariablePub_PubSubGroupType_MaxNetworkMessageSize, true
	case 17995:
		return OpcuaNodeIdServicesVariablePub_PubSubGroupTypeAddWriterMethodType_InputArguments, true
	case 17996:
		return OpcuaNodeIdServicesVariablePub_PubSubGroupTypeAddWriterMethodType_OutputArguments, true
	case 19108:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_DiagnosticsLevel, true
	case 19109:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation, true
	case 19110:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_Active, true
	case 19111:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_Classification, true
	case 19112:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel, true
	case 19113:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange, true
	case 19114:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError, true
	case 19115:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_Active, true
	case 19116:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_Classification, true
	case 19117:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel, true
	case 19118:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_TimeFirstChange, true
	case 19120:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_SubError, true
	case 19122:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError, true
	case 19123:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_Active, true
	case 19124:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_Classification, true
	case 19125:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel, true
	case 19126:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange, true
	case 19127:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod, true
	case 19128:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active, true
	case 19129:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification, true
	case 19130:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case 19131:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange, true
	case 19132:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent, true
	case 19133:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active, true
	case 19134:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification, true
	case 19135:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case 19136:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange, true
	case 19137:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError, true
	case 19138:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active, true
	case 19139:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification, true
	case 19140:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case 19141:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange, true
	case 19142:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent, true
	case 19143:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active, true
	case 19144:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification, true
	case 19145:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel, true
	case 19146:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange, true
	case 19147:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod, true
	case 19148:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active, true
	case 19149:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification, true
	case 19150:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case 19151:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange, true
	case 19153:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages, true
	case 19154:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_Active, true
	case 19155:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_Classification, true
	case 19156:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_DiagnosticsLevel, true
	case 19157:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_TimeFirstChange, true
	case 19158:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions, true
	case 19159:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_Active, true
	case 19160:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_Classification, true
	case 19161:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_DiagnosticsLevel, true
	case 19162:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_TimeFirstChange, true
	case 19163:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors, true
	case 19164:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_Active, true
	case 19165:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_Classification, true
	case 19166:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_DiagnosticsLevel, true
	case 19167:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_TimeFirstChange, true
	case 19168:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetWriters, true
	case 19169:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel, true
	case 19170:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetWriters, true
	case 19171:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel, true
	case 19172:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_SecurityTokenID, true
	case 19173:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_SecurityTokenID_DiagnosticsLevel, true
	case 19174:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID, true
	case 19175:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID_DiagnosticsLevel, true
	case 19177:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_DiagnosticsLevel, true
	case 19178:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation, true
	case 19179:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_Active, true
	case 19180:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_Classification, true
	case 19181:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel, true
	case 19182:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange, true
	case 19183:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError, true
	case 19184:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_Active, true
	case 19185:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_Classification, true
	case 19186:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel, true
	case 19187:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_TimeFirstChange, true
	case 19189:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_SubError, true
	case 19191:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError, true
	case 19192:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_Active, true
	case 19193:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_Classification, true
	case 19194:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel, true
	case 19195:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange, true
	case 19196:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod, true
	case 19197:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active, true
	case 19198:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification, true
	case 19199:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case 19200:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange, true
	case 19201:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent, true
	case 19202:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active, true
	case 19203:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification, true
	case 19204:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case 19205:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange, true
	case 19206:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError, true
	case 19207:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active, true
	case 19208:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification, true
	case 19209:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case 19210:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange, true
	case 19211:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent, true
	case 19212:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active, true
	case 19213:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification, true
	case 19214:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel, true
	case 19215:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange, true
	case 19216:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod, true
	case 19217:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active, true
	case 19218:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification, true
	case 19219:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case 19220:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange, true
	case 19222:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages, true
	case 19223:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_Active, true
	case 19224:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_Classification, true
	case 19225:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_DiagnosticsLevel, true
	case 19226:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_TimeFirstChange, true
	case 19227:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages, true
	case 19228:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Active, true
	case 19229:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Classification, true
	case 19230:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_DiagnosticsLevel, true
	case 19231:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_TimeFirstChange, true
	case 19232:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors, true
	case 19233:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_Active, true
	case 19234:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_Classification, true
	case 19235:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_DiagnosticsLevel, true
	case 19236:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_TimeFirstChange, true
	case 19237:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetReaders, true
	case 19238:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel, true
	case 19239:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetReaders, true
	case 19240:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel, true
	case 19242:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_DiagnosticsLevel, true
	case 19243:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalInformation, true
	case 19244:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalInformation_Active, true
	case 19245:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalInformation_Classification, true
	case 19246:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalInformation_DiagnosticsLevel, true
	case 19247:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalInformation_TimeFirstChange, true
	case 19248:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalError, true
	case 19249:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalError_Active, true
	case 19250:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalError_Classification, true
	case 19251:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalError_DiagnosticsLevel, true
	case 19252:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalError_TimeFirstChange, true
	case 19254:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_SubError, true
	case 19256:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateError, true
	case 19257:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateError_Active, true
	case 19258:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateError_Classification, true
	case 19259:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateError_DiagnosticsLevel, true
	case 19260:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateError_TimeFirstChange, true
	case 19261:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod, true
	case 19262:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_Active, true
	case 19263:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_Classification, true
	case 19264:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case 19265:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange, true
	case 19266:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent, true
	case 19267:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_Active, true
	case 19268:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_Classification, true
	case 19269:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case 19270:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange, true
	case 19271:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError, true
	case 19272:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_Active, true
	case 19273:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_Classification, true
	case 19274:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case 19275:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange, true
	case 19276:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StatePausedByParent, true
	case 19277:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_Active, true
	case 19278:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_Classification, true
	case 19279:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel, true
	case 19280:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_TimeFirstChange, true
	case 19281:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod, true
	case 19282:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_Active, true
	case 19283:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_Classification, true
	case 19284:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case 19285:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange, true
	case 19287:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_LiveValues_ResolvedAddress, true
	case 19288:
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_LiveValues_ResolvedAddress_DiagnosticsLevel, true
	case 19678:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_DiagnosticsLevel, true
	case 19679:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalInformation, true
	case 19680:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalInformation_Active, true
	case 19681:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalInformation_Classification, true
	case 19682:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalInformation_DiagnosticsLevel, true
	case 19683:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalInformation_TimeFirstChange, true
	case 19684:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalError, true
	case 19685:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalError_Active, true
	case 19686:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalError_Classification, true
	case 19687:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalError_DiagnosticsLevel, true
	case 19688:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalError_TimeFirstChange, true
	case 19690:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_SubError, true
	case 19692:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateError, true
	case 19693:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateError_Active, true
	case 19694:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateError_Classification, true
	case 19695:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateError_DiagnosticsLevel, true
	case 19696:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateError_TimeFirstChange, true
	case 19697:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByMethod, true
	case 19698:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByMethod_Active, true
	case 19699:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByMethod_Classification, true
	case 19700:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case 19701:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByMethod_TimeFirstChange, true
	case 19702:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByParent, true
	case 19703:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByParent_Active, true
	case 19704:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByParent_Classification, true
	case 19705:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case 19706:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByParent_TimeFirstChange, true
	case 19707:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalFromError, true
	case 19708:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalFromError_Active, true
	case 19709:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalFromError_Classification, true
	case 19710:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case 19711:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalFromError_TimeFirstChange, true
	case 19712:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StatePausedByParent, true
	case 19713:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StatePausedByParent_Active, true
	case 19714:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StatePausedByParent_Classification, true
	case 19715:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StatePausedByParent_DiagnosticsLevel, true
	case 19716:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StatePausedByParent_TimeFirstChange, true
	case 19717:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateDisabledByMethod, true
	case 19718:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateDisabledByMethod_Active, true
	case 19719:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateDisabledByMethod_Classification, true
	case 19720:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case 19721:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateDisabledByMethod_TimeFirstChange, true
	case 19726:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsCounterType_Active, true
	case 19727:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsCounterType_Classification, true
	case 19728:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsCounterType_DiagnosticsLevel, true
	case 19729:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsCounterType_TimeFirstChange, true
	case 19731:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsCounterClassification_EnumStrings, true
	case 19778:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetWriters, true
	case 19779:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel, true
	case 19780:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetReaders, true
	case 19781:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel, true
	case 19782:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_OperationalDataSetWriters, true
	case 19783:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_OperationalDataSetWriters_DiagnosticsLevel, true
	case 19784:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_OperationalDataSetReaders, true
	case 19785:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_OperationalDataSetReaders_DiagnosticsLevel, true
	case 19832:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsConnectionType_LiveValues_ResolvedAddress, true
	case 19833:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsConnectionType_LiveValues_ResolvedAddress_DiagnosticsLevel, true
	case 19849:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateError, true
	case 19850:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateError_Active, true
	case 19851:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateError_Classification, true
	case 19852:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateError_DiagnosticsLevel, true
	case 19853:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateError_TimeFirstChange, true
	case 19854:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod, true
	case 19855:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_Active, true
	case 19856:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_Classification, true
	case 19857:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case 19858:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_TimeFirstChange, true
	case 19859:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent, true
	case 19860:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_Active, true
	case 19861:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_Classification, true
	case 19862:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case 19863:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_TimeFirstChange, true
	case 19864:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError, true
	case 19865:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_Active, true
	case 19866:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_Classification, true
	case 19867:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case 19868:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_TimeFirstChange, true
	case 19869:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent, true
	case 19870:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_Active, true
	case 19871:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_Classification, true
	case 19872:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_DiagnosticsLevel, true
	case 19873:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_TimeFirstChange, true
	case 19874:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod, true
	case 19875:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_Active, true
	case 19876:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_Classification, true
	case 19877:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case 19878:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_TimeFirstChange, true
	case 19880:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages, true
	case 19881:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_Active, true
	case 19882:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_Classification, true
	case 19883:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_DiagnosticsLevel, true
	case 19884:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_TimeFirstChange, true
	case 19885:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions, true
	case 19886:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_Active, true
	case 19887:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_Classification, true
	case 19888:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_DiagnosticsLevel, true
	case 19889:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_TimeFirstChange, true
	case 19890:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors, true
	case 19891:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_Active, true
	case 19892:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_Classification, true
	case 19893:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_DiagnosticsLevel, true
	case 19894:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_TimeFirstChange, true
	case 19895:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_ConfiguredDataSetWriters, true
	case 19896:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel, true
	case 19897:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_OperationalDataSetWriters, true
	case 19898:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_OperationalDataSetWriters_DiagnosticsLevel, true
	case 19899:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_SecurityTokenID, true
	case 19900:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_SecurityTokenID_DiagnosticsLevel, true
	case 19901:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_TimeToNextTokenID, true
	case 19902:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_TimeToNextTokenID_DiagnosticsLevel, true
	case 19918:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateError, true
	case 19919:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateError_Active, true
	case 19920:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateError_Classification, true
	case 19921:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateError_DiagnosticsLevel, true
	case 19922:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateError_TimeFirstChange, true
	case 19923:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod, true
	case 19924:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_Active, true
	case 19925:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_Classification, true
	case 19926:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case 19927:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_TimeFirstChange, true
	case 19928:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent, true
	case 19929:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_Active, true
	case 19930:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_Classification, true
	case 19931:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case 19932:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_TimeFirstChange, true
	case 19933:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError, true
	case 19934:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_Active, true
	case 19935:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_Classification, true
	case 19936:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case 19937:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_TimeFirstChange, true
	case 19938:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent, true
	case 19939:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_Active, true
	case 19940:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_Classification, true
	case 19941:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_DiagnosticsLevel, true
	case 19942:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_TimeFirstChange, true
	case 19943:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod, true
	case 19944:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_Active, true
	case 19945:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_Classification, true
	case 19946:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case 19947:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_TimeFirstChange, true
	case 19949:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages, true
	case 19950:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_Active, true
	case 19951:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_Classification, true
	case 19952:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_DiagnosticsLevel, true
	case 19953:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_TimeFirstChange, true
	case 19954:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages, true
	case 19955:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_Active, true
	case 19956:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_Classification, true
	case 19957:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_DiagnosticsLevel, true
	case 19958:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_TimeFirstChange, true
	case 19959:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors, true
	case 19960:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_Active, true
	case 19961:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_Classification, true
	case 19962:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_DiagnosticsLevel, true
	case 19963:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_TimeFirstChange, true
	case 19964:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_LiveValues_ConfiguredDataSetReaders, true
	case 19965:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel, true
	case 19966:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_LiveValues_OperationalDataSetReaders, true
	case 19967:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_LiveValues_OperationalDataSetReaders_DiagnosticsLevel, true
	case 19983:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateError, true
	case 19984:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateError_Active, true
	case 19985:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateError_Classification, true
	case 19986:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateError_DiagnosticsLevel, true
	case 19987:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateError_TimeFirstChange, true
	case 19988:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod, true
	case 19989:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_Active, true
	case 19990:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_Classification, true
	case 19991:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case 19992:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_TimeFirstChange, true
	case 19993:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent, true
	case 19994:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_Active, true
	case 19995:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_Classification, true
	case 19996:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case 19997:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_TimeFirstChange, true
	case 19998:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError, true
	case 19999:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_Active, true
	case 20000:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_Classification, true
	case 20001:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case 20002:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_TimeFirstChange, true
	case 20003:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent, true
	case 20004:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_Active, true
	case 20005:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_Classification, true
	case 20006:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_DiagnosticsLevel, true
	case 20007:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_TimeFirstChange, true
	case 20008:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod, true
	case 20009:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_Active, true
	case 20010:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_Classification, true
	case 20011:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case 20012:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_TimeFirstChange, true
	case 20014:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages, true
	case 20015:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_Active, true
	case 20016:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_Classification, true
	case 20017:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_DiagnosticsLevel, true
	case 20018:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_TimeFirstChange, true
	case 20019:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_MessageSequenceNumber, true
	case 20020:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_MessageSequenceNumber_DiagnosticsLevel, true
	case 20021:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_StatusCode, true
	case 20022:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_StatusCode_DiagnosticsLevel, true
	case 20023:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_MajorVersion, true
	case 20024:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_MajorVersion_DiagnosticsLevel, true
	case 20025:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_MinorVersion, true
	case 20026:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_MinorVersion_DiagnosticsLevel, true
	case 20042:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateError, true
	case 20043:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateError_Active, true
	case 20044:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateError_Classification, true
	case 20045:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateError_DiagnosticsLevel, true
	case 20046:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateError_TimeFirstChange, true
	case 20047:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod, true
	case 20048:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_Active, true
	case 20049:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_Classification, true
	case 20050:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case 20051:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_TimeFirstChange, true
	case 20052:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent, true
	case 20053:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_Active, true
	case 20054:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_Classification, true
	case 20055:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case 20056:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_TimeFirstChange, true
	case 20057:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError, true
	case 20058:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_Active, true
	case 20059:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_Classification, true
	case 20060:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case 20061:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_TimeFirstChange, true
	case 20062:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent, true
	case 20063:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_Active, true
	case 20064:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_Classification, true
	case 20065:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_DiagnosticsLevel, true
	case 20066:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_TimeFirstChange, true
	case 20067:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod, true
	case 20068:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_Active, true
	case 20069:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_Classification, true
	case 20070:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case 20071:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_TimeFirstChange, true
	case 20073:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages, true
	case 20074:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_Active, true
	case 20075:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_Classification, true
	case 20076:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_DiagnosticsLevel, true
	case 20077:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_TimeFirstChange, true
	case 20078:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors, true
	case 20079:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_Active, true
	case 20080:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_Classification, true
	case 20081:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_DiagnosticsLevel, true
	case 20082:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_TimeFirstChange, true
	case 20083:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_MessageSequenceNumber, true
	case 20084:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_MessageSequenceNumber_DiagnosticsLevel, true
	case 20085:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_StatusCode, true
	case 20086:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_StatusCode_DiagnosticsLevel, true
	case 20087:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_MajorVersion, true
	case 20088:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_MajorVersion_DiagnosticsLevel, true
	case 20089:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_MinorVersion, true
	case 20090:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_MinorVersion_DiagnosticsLevel, true
	case 20091:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_SecurityTokenID, true
	case 20092:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_SecurityTokenID_DiagnosticsLevel, true
	case 20093:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_TimeToNextTokenID, true
	case 20094:
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_TimeToNextTokenID_DiagnosticsLevel, true
	case 21088:
		return OpcuaNodeIdServicesVariablePub_PubSubGroupTypeAddReaderMethodType_InputArguments, true
	case 21089:
		return OpcuaNodeIdServicesVariablePub_PubSubGroupTypeAddReaderMethodType_OutputArguments, true
	case 23833:
		return OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxPubSubConnections, true
	case 23834:
		return OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxWriterGroups, true
	case 23835:
		return OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxReaderGroups, true
	case 23836:
		return OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxDataSetWriters, true
	case 23837:
		return OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxDataSetReaders, true
	case 23838:
		return OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxFieldsPerDataSet, true
	case 25272:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_SecurityGroups_AddSecurityGroupFolder_InputArguments, true
	case 25273:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_SecurityGroups_AddSecurityGroupFolder_OutputArguments, true
	case 25275:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroupFolder_InputArguments, true
	case 25276:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_SecurityGroups_SupportedSecurityPolicyUris, true
	case 25279:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_KeyPushTargets_AddPushTarget_InputArguments, true
	case 25280:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_KeyPushTargets_AddPushTarget_OutputArguments, true
	case 25282:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_KeyPushTargets_RemovePushTarget_InputArguments, true
	case 25284:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_KeyPushTargets_AddPushTargetFolder_InputArguments, true
	case 25285:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_KeyPushTargets_AddPushTargetFolder_OutputArguments, true
	case 25287:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_KeyPushTargets_RemovePushTargetFolder_InputArguments, true
	case 25340:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_SecurityPolicyUri, true
	case 25349:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTarget_InputArguments, true
	case 25350:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTarget_OutputArguments, true
	case 25352:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTarget_InputArguments, true
	case 25354:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTargetFolder_InputArguments, true
	case 25355:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTargetFolder_OutputArguments, true
	case 25357:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTargetFolder_InputArguments, true
	case 25361:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_SecurityPolicyUri, true
	case 25367:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_AddPushTarget_InputArguments, true
	case 25368:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_AddPushTarget_OutputArguments, true
	case 25370:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_RemovePushTarget_InputArguments, true
	case 25372:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_AddPushTargetFolder_InputArguments, true
	case 25373:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_AddPushTargetFolder_OutputArguments, true
	case 25375:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_RemovePushTargetFolder_InputArguments, true
	case 25506:
		return OpcuaNodeIdServicesVariablePub_PubSubConfigurationType_ReserveIds_InputArguments, true
	case 25507:
		return OpcuaNodeIdServicesVariablePub_PubSubConfigurationType_ReserveIds_OutputArguments, true
	case 25509:
		return OpcuaNodeIdServicesVariablePub_PubSubConfigurationType_CloseAndUpdate_InputArguments, true
	case 25510:
		return OpcuaNodeIdServicesVariablePub_PubSubConfigurationType_CloseAndUpdate_OutputArguments, true
	case 25512:
		return OpcuaNodeIdServicesVariablePub_PubSubConfigurationTypeReserveIdsMethodType_InputArguments, true
	case 25513:
		return OpcuaNodeIdServicesVariablePub_PubSubConfigurationTypeReserveIdsMethodType_OutputArguments, true
	case 25515:
		return OpcuaNodeIdServicesVariablePub_PubSubConfigurationTypeCloseAndUpdateMethodType_InputArguments, true
	case 25516:
		return OpcuaNodeIdServicesVariablePub_PubSubConfigurationTypeCloseAndUpdateMethodType_OutputArguments, true
	case 25518:
		return OpcuaNodeIdServicesVariablePub_PubSubConfigurationRefMask_OptionSetValues, true
	case 25627:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_SecurityGroupId, true
	case 25628:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_KeyLifetime, true
	case 25629:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_SecurityPolicyUri, true
	case 25630:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_MaxFutureKeyCount, true
	case 25631:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_MaxPastKeyCount, true
	case 25634:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_ApplicationUri, true
	case 25635:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_EndpointUrl, true
	case 25636:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_UserTokenType, true
	case 25637:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_RequestedKeyCount, true
	case 25638:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_RetryInterval, true
	case 25639:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_LastPushExecutionTime, true
	case 25640:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_LastPushErrorTime, true
	case 25642:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_ConnectSecurityGroups_InputArguments, true
	case 25643:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_ConnectSecurityGroups_OutputArguments, true
	case 25645:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_DisconnectSecurityGroups_InputArguments, true
	case 25646:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_DisconnectSecurityGroups_OutputArguments, true
	case 25648:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ApplicationUri, true
	case 25649:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_EndpointUrl, true
	case 25650:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_UserTokenType, true
	case 25651:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_RequestedKeyCount, true
	case 25652:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_RetryInterval, true
	case 25653:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_LastPushExecutionTime, true
	case 25654:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_LastPushErrorTime, true
	case 25656:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ConnectSecurityGroups_InputArguments, true
	case 25657:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ConnectSecurityGroups_OutputArguments, true
	case 25659:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_DisconnectSecurityGroups_InputArguments, true
	case 25660:
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_DisconnectSecurityGroups_OutputArguments, true
	case 32651:
		return OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxDataSetWritersPerGroup, true
	case 32652:
		return OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxNetworkMessageSizeDatagram, true
	case 32653:
		return OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxNetworkMessageSizeBroker, true
	case 32654:
		return OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_SupportSecurityKeyPull, true
	case 32655:
		return OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_SupportSecurityKeyPush, true
	case 32844:
		return OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxSecurityGroups, true
	case 32845:
		return OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxPushTargets, true
	case 32846:
		return OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxPublishedDataSets, true
	case 32847:
		return OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxStandaloneSubscribedDataSets, true
	case 32848:
		return OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_SupportSecurityKeyServer, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariablePubByName(value string) (enum OpcuaNodeIdServicesVariablePub, ok bool) {
	switch value {
	case "PubSubConnectionType_RemoveGroup_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_RemoveGroup_InputArguments, true
	case "PubSubConnectionType_PublisherId":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_PublisherId, true
	case "PubSubConnectionType_Status_State":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Status_State, true
	case "PubSubConnectionTypeRemoveGroupMethodType_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionTypeRemoveGroupMethodType_InputArguments, true
	case "PubSubGroupTypeRemoveWriterMethodType_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubGroupTypeRemoveWriterMethodType_InputArguments, true
	case "PubSubGroupTypeRemoveReaderMethodType_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubGroupTypeRemoveReaderMethodType_InputArguments, true
	case "PubSubStatusType_State":
		return OpcuaNodeIdServicesVariablePub_PubSubStatusType_State, true
	case "PubSubState_EnumStrings":
		return OpcuaNodeIdServicesVariablePub_PubSubState_EnumStrings, true
	case "PubSubGroupType_Status_State":
		return OpcuaNodeIdServicesVariablePub_PubSubGroupType_Status_State, true
	case "PubSubStatusEventType_ConnectionId":
		return OpcuaNodeIdServicesVariablePub_PubSubStatusEventType_ConnectionId, true
	case "PubSubStatusEventType_GroupId":
		return OpcuaNodeIdServicesVariablePub_PubSubStatusEventType_GroupId, true
	case "PubSubStatusEventType_State":
		return OpcuaNodeIdServicesVariablePub_PubSubStatusEventType_State, true
	case "PubSubTransportLimitsExceedEventType_Actual":
		return OpcuaNodeIdServicesVariablePub_PubSubTransportLimitsExceedEventType_Actual, true
	case "PubSubTransportLimitsExceedEventType_Maximum":
		return OpcuaNodeIdServicesVariablePub_PubSubTransportLimitsExceedEventType_Maximum, true
	case "PubSubCommunicationFailureEventType_Error":
		return OpcuaNodeIdServicesVariablePub_PubSubCommunicationFailureEventType_Error, true
	case "PubSubKeyServiceType_GetSecurityKeys_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_GetSecurityKeys_InputArguments, true
	case "PubSubKeyServiceType_GetSecurityKeys_OutputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_GetSecurityKeys_OutputArguments, true
	case "PubSubKeyServiceType_GetSecurityGroup_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_GetSecurityGroup_InputArguments, true
	case "PubSubKeyServiceType_GetSecurityGroup_OutputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_GetSecurityGroup_OutputArguments, true
	case "PubSubKeyServiceType_SecurityGroups_AddSecurityGroup_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_SecurityGroups_AddSecurityGroup_InputArguments, true
	case "PubSubKeyServiceType_SecurityGroups_AddSecurityGroup_OutputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_SecurityGroups_AddSecurityGroup_OutputArguments, true
	case "PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroup_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroup_InputArguments, true
	case "PubSubGroupType_SecurityMode":
		return OpcuaNodeIdServicesVariablePub_PubSubGroupType_SecurityMode, true
	case "PubSubGroupType_SecurityGroupId":
		return OpcuaNodeIdServicesVariablePub_PubSubGroupType_SecurityGroupId, true
	case "PubSubGroupType_SecurityKeyServices":
		return OpcuaNodeIdServicesVariablePub_PubSubGroupType_SecurityKeyServices, true
	case "PubSubConnectionType_Address_NetworkInterface":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Address_NetworkInterface, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_MaxNetworkMessageSize":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_MaxNetworkMessageSize, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_WriterGroupId":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_WriterGroupId, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_AddDataSetWriter_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_AddDataSetWriter_InputArguments, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_AddDataSetWriter_OutputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_AddDataSetWriter_OutputArguments, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_MaxNetworkMessageSize":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_MaxNetworkMessageSize, true
	case "PubSubConnectionType_TransportProfileUri":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_TransportProfileUri, true
	case "PubSubConnectionType_TransportProfileUri_RestrictToList":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_TransportProfileUri_RestrictToList, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_SecurityMode":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_SecurityMode, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_SecurityGroupId":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_SecurityGroupId, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_SecurityKeyServices":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_SecurityKeyServices, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Status_State":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Status_State, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_PublishingInterval":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_PublishingInterval, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_KeepAliveTime":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_KeepAliveTime, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Priority":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Priority, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_LocaleIds":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_LocaleIds, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_RemoveDataSetWriter_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_RemoveDataSetWriter_InputArguments, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_SecurityMode":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_SecurityMode, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_SecurityGroupId":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_SecurityGroupId, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_SecurityKeyServices":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_SecurityKeyServices, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Status_State":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Status_State, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_RemoveDataSetReader_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_RemoveDataSetReader_InputArguments, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_AddDataSetReader_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_AddDataSetReader_InputArguments, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_AddDataSetReader_OutputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_AddDataSetReader_OutputArguments, true
	case "PubSubConnectionType_AddWriterGroup_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_AddWriterGroup_InputArguments, true
	case "PubSubConnectionType_AddWriterGroup_OutputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_AddWriterGroup_OutputArguments, true
	case "PubSubConnectionType_ConnectionProperties":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ConnectionProperties, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_GroupProperties":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_GroupProperties, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_GroupProperties":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_GroupProperties, true
	case "PubSubGroupType_GroupProperties":
		return OpcuaNodeIdServicesVariablePub_PubSubGroupType_GroupProperties, true
	case "PubSubConnectionType_AddReaderGroup_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_AddReaderGroup_InputArguments, true
	case "PubSubConnectionType_AddReaderGroup_OutputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_AddReaderGroup_OutputArguments, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_HeaderLayoutUri":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_HeaderLayoutUri, true
	case "PubSubConnectionType_Address_NetworkInterface_Selections":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Address_NetworkInterface_Selections, true
	case "PubSubConnectionType_Address_NetworkInterface_SelectionDescriptions":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Address_NetworkInterface_SelectionDescriptions, true
	case "PubSubConnectionType_Address_NetworkInterface_RestrictToList":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Address_NetworkInterface_RestrictToList, true
	case "PubSubConnectionTypeAddWriterGroupMethodType_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionTypeAddWriterGroupMethodType_InputArguments, true
	case "PubSubConnectionTypeAddWriterGroupMethodType_OutputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionTypeAddWriterGroupMethodType_OutputArguments, true
	case "PubSubConnectionAddReaderGroupGroupMethodType_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionAddReaderGroupGroupMethodType_InputArguments, true
	case "PubSubConnectionType_TransportProfileUri_Selections":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_TransportProfileUri_Selections, true
	case "PubSubConnectionType_TransportProfileUri_SelectionDescriptions":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_TransportProfileUri_SelectionDescriptions, true
	case "PubSubConnectionAddReaderGroupGroupMethodType_OutputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionAddReaderGroupGroupMethodType_OutputArguments, true
	case "PubSubGroupType_MaxNetworkMessageSize":
		return OpcuaNodeIdServicesVariablePub_PubSubGroupType_MaxNetworkMessageSize, true
	case "PubSubGroupTypeAddWriterMethodType_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubGroupTypeAddWriterMethodType_InputArguments, true
	case "PubSubGroupTypeAddWriterMethodType_OutputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubGroupTypeAddWriterMethodType_OutputArguments, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_DiagnosticsLevel, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_Active, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_Classification, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_Active, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_Classification, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_TimeFirstChange, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_SubError":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_SubError, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_Active, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_Classification, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_Active, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_Classification, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_DiagnosticsLevel, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_TimeFirstChange, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_Active, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_Classification, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_DiagnosticsLevel, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_TimeFirstChange, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_Active, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_Classification, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_DiagnosticsLevel, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_TimeFirstChange, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetWriters":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetWriters, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetWriters":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetWriters, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_SecurityTokenID":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_SecurityTokenID, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_SecurityTokenID_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_SecurityTokenID_DiagnosticsLevel, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID_DiagnosticsLevel, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_DiagnosticsLevel, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_Active, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_Classification, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_Active, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_Classification, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_TimeFirstChange, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_SubError":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_SubError, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_Active, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_Classification, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_Active, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_Classification, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_DiagnosticsLevel, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_TimeFirstChange, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Active, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Classification, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_DiagnosticsLevel, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_TimeFirstChange, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_Active, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_Classification, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_DiagnosticsLevel, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_TimeFirstChange, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetReaders":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetReaders, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetReaders":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetReaders, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel, true
	case "PubSubConnectionType_Diagnostics_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_DiagnosticsLevel, true
	case "PubSubConnectionType_Diagnostics_TotalInformation":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalInformation, true
	case "PubSubConnectionType_Diagnostics_TotalInformation_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalInformation_Active, true
	case "PubSubConnectionType_Diagnostics_TotalInformation_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalInformation_Classification, true
	case "PubSubConnectionType_Diagnostics_TotalInformation_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalInformation_DiagnosticsLevel, true
	case "PubSubConnectionType_Diagnostics_TotalInformation_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalInformation_TimeFirstChange, true
	case "PubSubConnectionType_Diagnostics_TotalError":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalError, true
	case "PubSubConnectionType_Diagnostics_TotalError_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalError_Active, true
	case "PubSubConnectionType_Diagnostics_TotalError_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalError_Classification, true
	case "PubSubConnectionType_Diagnostics_TotalError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalError_DiagnosticsLevel, true
	case "PubSubConnectionType_Diagnostics_TotalError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalError_TimeFirstChange, true
	case "PubSubConnectionType_Diagnostics_SubError":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_SubError, true
	case "PubSubConnectionType_Diagnostics_Counters_StateError":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateError, true
	case "PubSubConnectionType_Diagnostics_Counters_StateError_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateError_Active, true
	case "PubSubConnectionType_Diagnostics_Counters_StateError_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateError_Classification, true
	case "PubSubConnectionType_Diagnostics_Counters_StateError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateError_DiagnosticsLevel, true
	case "PubSubConnectionType_Diagnostics_Counters_StateError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateError_TimeFirstChange, true
	case "PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod, true
	case "PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_Active, true
	case "PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_Classification, true
	case "PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case "PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange, true
	case "PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent, true
	case "PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_Active, true
	case "PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_Classification, true
	case "PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case "PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange, true
	case "PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError, true
	case "PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_Active, true
	case "PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_Classification, true
	case "PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case "PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange, true
	case "PubSubConnectionType_Diagnostics_Counters_StatePausedByParent":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StatePausedByParent, true
	case "PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_Active, true
	case "PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_Classification, true
	case "PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel, true
	case "PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_TimeFirstChange, true
	case "PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod, true
	case "PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_Active, true
	case "PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_Classification, true
	case "PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case "PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange, true
	case "PubSubConnectionType_Diagnostics_LiveValues_ResolvedAddress":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_LiveValues_ResolvedAddress, true
	case "PubSubConnectionType_Diagnostics_LiveValues_ResolvedAddress_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_LiveValues_ResolvedAddress_DiagnosticsLevel, true
	case "PubSubDiagnosticsType_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_DiagnosticsLevel, true
	case "PubSubDiagnosticsType_TotalInformation":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalInformation, true
	case "PubSubDiagnosticsType_TotalInformation_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalInformation_Active, true
	case "PubSubDiagnosticsType_TotalInformation_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalInformation_Classification, true
	case "PubSubDiagnosticsType_TotalInformation_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalInformation_DiagnosticsLevel, true
	case "PubSubDiagnosticsType_TotalInformation_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalInformation_TimeFirstChange, true
	case "PubSubDiagnosticsType_TotalError":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalError, true
	case "PubSubDiagnosticsType_TotalError_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalError_Active, true
	case "PubSubDiagnosticsType_TotalError_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalError_Classification, true
	case "PubSubDiagnosticsType_TotalError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalError_DiagnosticsLevel, true
	case "PubSubDiagnosticsType_TotalError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalError_TimeFirstChange, true
	case "PubSubDiagnosticsType_SubError":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_SubError, true
	case "PubSubDiagnosticsType_Counters_StateError":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateError, true
	case "PubSubDiagnosticsType_Counters_StateError_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateError_Active, true
	case "PubSubDiagnosticsType_Counters_StateError_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateError_Classification, true
	case "PubSubDiagnosticsType_Counters_StateError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateError_DiagnosticsLevel, true
	case "PubSubDiagnosticsType_Counters_StateError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateError_TimeFirstChange, true
	case "PubSubDiagnosticsType_Counters_StateOperationalByMethod":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByMethod, true
	case "PubSubDiagnosticsType_Counters_StateOperationalByMethod_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByMethod_Active, true
	case "PubSubDiagnosticsType_Counters_StateOperationalByMethod_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByMethod_Classification, true
	case "PubSubDiagnosticsType_Counters_StateOperationalByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case "PubSubDiagnosticsType_Counters_StateOperationalByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByMethod_TimeFirstChange, true
	case "PubSubDiagnosticsType_Counters_StateOperationalByParent":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByParent, true
	case "PubSubDiagnosticsType_Counters_StateOperationalByParent_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByParent_Active, true
	case "PubSubDiagnosticsType_Counters_StateOperationalByParent_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByParent_Classification, true
	case "PubSubDiagnosticsType_Counters_StateOperationalByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case "PubSubDiagnosticsType_Counters_StateOperationalByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByParent_TimeFirstChange, true
	case "PubSubDiagnosticsType_Counters_StateOperationalFromError":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalFromError, true
	case "PubSubDiagnosticsType_Counters_StateOperationalFromError_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalFromError_Active, true
	case "PubSubDiagnosticsType_Counters_StateOperationalFromError_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalFromError_Classification, true
	case "PubSubDiagnosticsType_Counters_StateOperationalFromError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case "PubSubDiagnosticsType_Counters_StateOperationalFromError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalFromError_TimeFirstChange, true
	case "PubSubDiagnosticsType_Counters_StatePausedByParent":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StatePausedByParent, true
	case "PubSubDiagnosticsType_Counters_StatePausedByParent_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StatePausedByParent_Active, true
	case "PubSubDiagnosticsType_Counters_StatePausedByParent_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StatePausedByParent_Classification, true
	case "PubSubDiagnosticsType_Counters_StatePausedByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StatePausedByParent_DiagnosticsLevel, true
	case "PubSubDiagnosticsType_Counters_StatePausedByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StatePausedByParent_TimeFirstChange, true
	case "PubSubDiagnosticsType_Counters_StateDisabledByMethod":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateDisabledByMethod, true
	case "PubSubDiagnosticsType_Counters_StateDisabledByMethod_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateDisabledByMethod_Active, true
	case "PubSubDiagnosticsType_Counters_StateDisabledByMethod_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateDisabledByMethod_Classification, true
	case "PubSubDiagnosticsType_Counters_StateDisabledByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case "PubSubDiagnosticsType_Counters_StateDisabledByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateDisabledByMethod_TimeFirstChange, true
	case "PubSubDiagnosticsCounterType_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsCounterType_Active, true
	case "PubSubDiagnosticsCounterType_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsCounterType_Classification, true
	case "PubSubDiagnosticsCounterType_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsCounterType_DiagnosticsLevel, true
	case "PubSubDiagnosticsCounterType_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsCounterType_TimeFirstChange, true
	case "PubSubDiagnosticsCounterClassification_EnumStrings":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsCounterClassification_EnumStrings, true
	case "PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetWriters":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetWriters, true
	case "PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel, true
	case "PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetReaders":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetReaders, true
	case "PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel, true
	case "PubSubDiagnosticsRootType_LiveValues_OperationalDataSetWriters":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_OperationalDataSetWriters, true
	case "PubSubDiagnosticsRootType_LiveValues_OperationalDataSetWriters_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_OperationalDataSetWriters_DiagnosticsLevel, true
	case "PubSubDiagnosticsRootType_LiveValues_OperationalDataSetReaders":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_OperationalDataSetReaders, true
	case "PubSubDiagnosticsRootType_LiveValues_OperationalDataSetReaders_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_OperationalDataSetReaders_DiagnosticsLevel, true
	case "PubSubDiagnosticsConnectionType_LiveValues_ResolvedAddress":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsConnectionType_LiveValues_ResolvedAddress, true
	case "PubSubDiagnosticsConnectionType_LiveValues_ResolvedAddress_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsConnectionType_LiveValues_ResolvedAddress_DiagnosticsLevel, true
	case "PubSubDiagnosticsWriterGroupType_Counters_StateError":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateError, true
	case "PubSubDiagnosticsWriterGroupType_Counters_StateError_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateError_Active, true
	case "PubSubDiagnosticsWriterGroupType_Counters_StateError_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateError_Classification, true
	case "PubSubDiagnosticsWriterGroupType_Counters_StateError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateError_DiagnosticsLevel, true
	case "PubSubDiagnosticsWriterGroupType_Counters_StateError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateError_TimeFirstChange, true
	case "PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod, true
	case "PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_Active, true
	case "PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_Classification, true
	case "PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case "PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_TimeFirstChange, true
	case "PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent, true
	case "PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_Active, true
	case "PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_Classification, true
	case "PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case "PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_TimeFirstChange, true
	case "PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError, true
	case "PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_Active, true
	case "PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_Classification, true
	case "PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case "PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_TimeFirstChange, true
	case "PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent, true
	case "PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_Active, true
	case "PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_Classification, true
	case "PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_DiagnosticsLevel, true
	case "PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_TimeFirstChange, true
	case "PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod, true
	case "PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_Active, true
	case "PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_Classification, true
	case "PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case "PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_TimeFirstChange, true
	case "PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages, true
	case "PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_Active, true
	case "PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_Classification, true
	case "PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_DiagnosticsLevel, true
	case "PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_TimeFirstChange, true
	case "PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions, true
	case "PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_Active, true
	case "PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_Classification, true
	case "PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_DiagnosticsLevel, true
	case "PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_TimeFirstChange, true
	case "PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors, true
	case "PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_Active, true
	case "PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_Classification, true
	case "PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_DiagnosticsLevel, true
	case "PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_TimeFirstChange, true
	case "PubSubDiagnosticsWriterGroupType_LiveValues_ConfiguredDataSetWriters":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_ConfiguredDataSetWriters, true
	case "PubSubDiagnosticsWriterGroupType_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel, true
	case "PubSubDiagnosticsWriterGroupType_LiveValues_OperationalDataSetWriters":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_OperationalDataSetWriters, true
	case "PubSubDiagnosticsWriterGroupType_LiveValues_OperationalDataSetWriters_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_OperationalDataSetWriters_DiagnosticsLevel, true
	case "PubSubDiagnosticsWriterGroupType_LiveValues_SecurityTokenID":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_SecurityTokenID, true
	case "PubSubDiagnosticsWriterGroupType_LiveValues_SecurityTokenID_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_SecurityTokenID_DiagnosticsLevel, true
	case "PubSubDiagnosticsWriterGroupType_LiveValues_TimeToNextTokenID":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_TimeToNextTokenID, true
	case "PubSubDiagnosticsWriterGroupType_LiveValues_TimeToNextTokenID_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_TimeToNextTokenID_DiagnosticsLevel, true
	case "PubSubDiagnosticsReaderGroupType_Counters_StateError":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateError, true
	case "PubSubDiagnosticsReaderGroupType_Counters_StateError_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateError_Active, true
	case "PubSubDiagnosticsReaderGroupType_Counters_StateError_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateError_Classification, true
	case "PubSubDiagnosticsReaderGroupType_Counters_StateError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateError_DiagnosticsLevel, true
	case "PubSubDiagnosticsReaderGroupType_Counters_StateError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateError_TimeFirstChange, true
	case "PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod, true
	case "PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_Active, true
	case "PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_Classification, true
	case "PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case "PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_TimeFirstChange, true
	case "PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent, true
	case "PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_Active, true
	case "PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_Classification, true
	case "PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case "PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_TimeFirstChange, true
	case "PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError, true
	case "PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_Active, true
	case "PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_Classification, true
	case "PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case "PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_TimeFirstChange, true
	case "PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent, true
	case "PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_Active, true
	case "PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_Classification, true
	case "PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_DiagnosticsLevel, true
	case "PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_TimeFirstChange, true
	case "PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod, true
	case "PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_Active, true
	case "PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_Classification, true
	case "PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case "PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_TimeFirstChange, true
	case "PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages, true
	case "PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_Active, true
	case "PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_Classification, true
	case "PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_DiagnosticsLevel, true
	case "PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_TimeFirstChange, true
	case "PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages, true
	case "PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_Active, true
	case "PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_Classification, true
	case "PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_DiagnosticsLevel, true
	case "PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_TimeFirstChange, true
	case "PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors, true
	case "PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_Active, true
	case "PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_Classification, true
	case "PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_DiagnosticsLevel, true
	case "PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_TimeFirstChange, true
	case "PubSubDiagnosticsReaderGroupType_LiveValues_ConfiguredDataSetReaders":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_LiveValues_ConfiguredDataSetReaders, true
	case "PubSubDiagnosticsReaderGroupType_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel, true
	case "PubSubDiagnosticsReaderGroupType_LiveValues_OperationalDataSetReaders":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_LiveValues_OperationalDataSetReaders, true
	case "PubSubDiagnosticsReaderGroupType_LiveValues_OperationalDataSetReaders_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_LiveValues_OperationalDataSetReaders_DiagnosticsLevel, true
	case "PubSubDiagnosticsDataSetWriterType_Counters_StateError":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateError, true
	case "PubSubDiagnosticsDataSetWriterType_Counters_StateError_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateError_Active, true
	case "PubSubDiagnosticsDataSetWriterType_Counters_StateError_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateError_Classification, true
	case "PubSubDiagnosticsDataSetWriterType_Counters_StateError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateError_DiagnosticsLevel, true
	case "PubSubDiagnosticsDataSetWriterType_Counters_StateError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateError_TimeFirstChange, true
	case "PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod, true
	case "PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_Active, true
	case "PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_Classification, true
	case "PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case "PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_TimeFirstChange, true
	case "PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent, true
	case "PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_Active, true
	case "PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_Classification, true
	case "PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case "PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_TimeFirstChange, true
	case "PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError, true
	case "PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_Active, true
	case "PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_Classification, true
	case "PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case "PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_TimeFirstChange, true
	case "PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent, true
	case "PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_Active, true
	case "PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_Classification, true
	case "PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_DiagnosticsLevel, true
	case "PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_TimeFirstChange, true
	case "PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod, true
	case "PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_Active, true
	case "PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_Classification, true
	case "PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case "PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_TimeFirstChange, true
	case "PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages, true
	case "PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_Active, true
	case "PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_Classification, true
	case "PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_DiagnosticsLevel, true
	case "PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_TimeFirstChange, true
	case "PubSubDiagnosticsDataSetWriterType_LiveValues_MessageSequenceNumber":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_MessageSequenceNumber, true
	case "PubSubDiagnosticsDataSetWriterType_LiveValues_MessageSequenceNumber_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_MessageSequenceNumber_DiagnosticsLevel, true
	case "PubSubDiagnosticsDataSetWriterType_LiveValues_StatusCode":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_StatusCode, true
	case "PubSubDiagnosticsDataSetWriterType_LiveValues_StatusCode_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_StatusCode_DiagnosticsLevel, true
	case "PubSubDiagnosticsDataSetWriterType_LiveValues_MajorVersion":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_MajorVersion, true
	case "PubSubDiagnosticsDataSetWriterType_LiveValues_MajorVersion_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_MajorVersion_DiagnosticsLevel, true
	case "PubSubDiagnosticsDataSetWriterType_LiveValues_MinorVersion":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_MinorVersion, true
	case "PubSubDiagnosticsDataSetWriterType_LiveValues_MinorVersion_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_MinorVersion_DiagnosticsLevel, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_StateError":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateError, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_StateError_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateError_Active, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_StateError_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateError_Classification, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_StateError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateError_DiagnosticsLevel, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_StateError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateError_TimeFirstChange, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_Active, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_Classification, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_TimeFirstChange, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_Active, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_Classification, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_TimeFirstChange, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_Active, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_Classification, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_TimeFirstChange, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_Active, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_Classification, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_DiagnosticsLevel, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_TimeFirstChange, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_Active, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_Classification, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_TimeFirstChange, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_Active, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_Classification, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_DiagnosticsLevel, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_TimeFirstChange, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_Active":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_Active, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_Classification":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_Classification, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_DiagnosticsLevel, true
	case "PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_TimeFirstChange, true
	case "PubSubDiagnosticsDataSetReaderType_LiveValues_MessageSequenceNumber":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_MessageSequenceNumber, true
	case "PubSubDiagnosticsDataSetReaderType_LiveValues_MessageSequenceNumber_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_MessageSequenceNumber_DiagnosticsLevel, true
	case "PubSubDiagnosticsDataSetReaderType_LiveValues_StatusCode":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_StatusCode, true
	case "PubSubDiagnosticsDataSetReaderType_LiveValues_StatusCode_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_StatusCode_DiagnosticsLevel, true
	case "PubSubDiagnosticsDataSetReaderType_LiveValues_MajorVersion":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_MajorVersion, true
	case "PubSubDiagnosticsDataSetReaderType_LiveValues_MajorVersion_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_MajorVersion_DiagnosticsLevel, true
	case "PubSubDiagnosticsDataSetReaderType_LiveValues_MinorVersion":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_MinorVersion, true
	case "PubSubDiagnosticsDataSetReaderType_LiveValues_MinorVersion_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_MinorVersion_DiagnosticsLevel, true
	case "PubSubDiagnosticsDataSetReaderType_LiveValues_SecurityTokenID":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_SecurityTokenID, true
	case "PubSubDiagnosticsDataSetReaderType_LiveValues_SecurityTokenID_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_SecurityTokenID_DiagnosticsLevel, true
	case "PubSubDiagnosticsDataSetReaderType_LiveValues_TimeToNextTokenID":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_TimeToNextTokenID, true
	case "PubSubDiagnosticsDataSetReaderType_LiveValues_TimeToNextTokenID_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_TimeToNextTokenID_DiagnosticsLevel, true
	case "PubSubGroupTypeAddReaderMethodType_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubGroupTypeAddReaderMethodType_InputArguments, true
	case "PubSubGroupTypeAddReaderMethodType_OutputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubGroupTypeAddReaderMethodType_OutputArguments, true
	case "PubSubCapabilitiesType_MaxPubSubConnections":
		return OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxPubSubConnections, true
	case "PubSubCapabilitiesType_MaxWriterGroups":
		return OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxWriterGroups, true
	case "PubSubCapabilitiesType_MaxReaderGroups":
		return OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxReaderGroups, true
	case "PubSubCapabilitiesType_MaxDataSetWriters":
		return OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxDataSetWriters, true
	case "PubSubCapabilitiesType_MaxDataSetReaders":
		return OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxDataSetReaders, true
	case "PubSubCapabilitiesType_MaxFieldsPerDataSet":
		return OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxFieldsPerDataSet, true
	case "PubSubKeyServiceType_SecurityGroups_AddSecurityGroupFolder_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_SecurityGroups_AddSecurityGroupFolder_InputArguments, true
	case "PubSubKeyServiceType_SecurityGroups_AddSecurityGroupFolder_OutputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_SecurityGroups_AddSecurityGroupFolder_OutputArguments, true
	case "PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroupFolder_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroupFolder_InputArguments, true
	case "PubSubKeyServiceType_SecurityGroups_SupportedSecurityPolicyUris":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_SecurityGroups_SupportedSecurityPolicyUris, true
	case "PubSubKeyServiceType_KeyPushTargets_AddPushTarget_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_KeyPushTargets_AddPushTarget_InputArguments, true
	case "PubSubKeyServiceType_KeyPushTargets_AddPushTarget_OutputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_KeyPushTargets_AddPushTarget_OutputArguments, true
	case "PubSubKeyServiceType_KeyPushTargets_RemovePushTarget_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_KeyPushTargets_RemovePushTarget_InputArguments, true
	case "PubSubKeyServiceType_KeyPushTargets_AddPushTargetFolder_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_KeyPushTargets_AddPushTargetFolder_InputArguments, true
	case "PubSubKeyServiceType_KeyPushTargets_AddPushTargetFolder_OutputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_KeyPushTargets_AddPushTargetFolder_OutputArguments, true
	case "PubSubKeyServiceType_KeyPushTargets_RemovePushTargetFolder_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_KeyPushTargets_RemovePushTargetFolder_InputArguments, true
	case "PubSubKeyPushTargetType_SecurityPolicyUri":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_SecurityPolicyUri, true
	case "PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTarget_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTarget_InputArguments, true
	case "PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTarget_OutputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTarget_OutputArguments, true
	case "PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTarget_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTarget_InputArguments, true
	case "PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTargetFolder_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTargetFolder_InputArguments, true
	case "PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTargetFolder_OutputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTargetFolder_OutputArguments, true
	case "PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTargetFolder_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTargetFolder_InputArguments, true
	case "PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_SecurityPolicyUri":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_SecurityPolicyUri, true
	case "PubSubKeyPushTargetFolderType_AddPushTarget_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_AddPushTarget_InputArguments, true
	case "PubSubKeyPushTargetFolderType_AddPushTarget_OutputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_AddPushTarget_OutputArguments, true
	case "PubSubKeyPushTargetFolderType_RemovePushTarget_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_RemovePushTarget_InputArguments, true
	case "PubSubKeyPushTargetFolderType_AddPushTargetFolder_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_AddPushTargetFolder_InputArguments, true
	case "PubSubKeyPushTargetFolderType_AddPushTargetFolder_OutputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_AddPushTargetFolder_OutputArguments, true
	case "PubSubKeyPushTargetFolderType_RemovePushTargetFolder_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_RemovePushTargetFolder_InputArguments, true
	case "PubSubConfigurationType_ReserveIds_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubConfigurationType_ReserveIds_InputArguments, true
	case "PubSubConfigurationType_ReserveIds_OutputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubConfigurationType_ReserveIds_OutputArguments, true
	case "PubSubConfigurationType_CloseAndUpdate_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubConfigurationType_CloseAndUpdate_InputArguments, true
	case "PubSubConfigurationType_CloseAndUpdate_OutputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubConfigurationType_CloseAndUpdate_OutputArguments, true
	case "PubSubConfigurationTypeReserveIdsMethodType_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubConfigurationTypeReserveIdsMethodType_InputArguments, true
	case "PubSubConfigurationTypeReserveIdsMethodType_OutputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubConfigurationTypeReserveIdsMethodType_OutputArguments, true
	case "PubSubConfigurationTypeCloseAndUpdateMethodType_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubConfigurationTypeCloseAndUpdateMethodType_InputArguments, true
	case "PubSubConfigurationTypeCloseAndUpdateMethodType_OutputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubConfigurationTypeCloseAndUpdateMethodType_OutputArguments, true
	case "PubSubConfigurationRefMask_OptionSetValues":
		return OpcuaNodeIdServicesVariablePub_PubSubConfigurationRefMask_OptionSetValues, true
	case "PubSubKeyPushTargetType_SecurityGroupName_Placeholder_SecurityGroupId":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_SecurityGroupId, true
	case "PubSubKeyPushTargetType_SecurityGroupName_Placeholder_KeyLifetime":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_KeyLifetime, true
	case "PubSubKeyPushTargetType_SecurityGroupName_Placeholder_SecurityPolicyUri":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_SecurityPolicyUri, true
	case "PubSubKeyPushTargetType_SecurityGroupName_Placeholder_MaxFutureKeyCount":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_MaxFutureKeyCount, true
	case "PubSubKeyPushTargetType_SecurityGroupName_Placeholder_MaxPastKeyCount":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_MaxPastKeyCount, true
	case "PubSubKeyPushTargetType_ApplicationUri":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_ApplicationUri, true
	case "PubSubKeyPushTargetType_EndpointUrl":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_EndpointUrl, true
	case "PubSubKeyPushTargetType_UserTokenType":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_UserTokenType, true
	case "PubSubKeyPushTargetType_RequestedKeyCount":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_RequestedKeyCount, true
	case "PubSubKeyPushTargetType_RetryInterval":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_RetryInterval, true
	case "PubSubKeyPushTargetType_LastPushExecutionTime":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_LastPushExecutionTime, true
	case "PubSubKeyPushTargetType_LastPushErrorTime":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_LastPushErrorTime, true
	case "PubSubKeyPushTargetType_ConnectSecurityGroups_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_ConnectSecurityGroups_InputArguments, true
	case "PubSubKeyPushTargetType_ConnectSecurityGroups_OutputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_ConnectSecurityGroups_OutputArguments, true
	case "PubSubKeyPushTargetType_DisconnectSecurityGroups_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_DisconnectSecurityGroups_InputArguments, true
	case "PubSubKeyPushTargetType_DisconnectSecurityGroups_OutputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_DisconnectSecurityGroups_OutputArguments, true
	case "PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ApplicationUri":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ApplicationUri, true
	case "PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_EndpointUrl":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_EndpointUrl, true
	case "PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_UserTokenType":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_UserTokenType, true
	case "PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_RequestedKeyCount":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_RequestedKeyCount, true
	case "PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_RetryInterval":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_RetryInterval, true
	case "PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_LastPushExecutionTime":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_LastPushExecutionTime, true
	case "PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_LastPushErrorTime":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_LastPushErrorTime, true
	case "PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ConnectSecurityGroups_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ConnectSecurityGroups_InputArguments, true
	case "PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ConnectSecurityGroups_OutputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ConnectSecurityGroups_OutputArguments, true
	case "PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_DisconnectSecurityGroups_InputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_DisconnectSecurityGroups_InputArguments, true
	case "PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_DisconnectSecurityGroups_OutputArguments":
		return OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_DisconnectSecurityGroups_OutputArguments, true
	case "PubSubCapabilitiesType_MaxDataSetWritersPerGroup":
		return OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxDataSetWritersPerGroup, true
	case "PubSubCapabilitiesType_MaxNetworkMessageSizeDatagram":
		return OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxNetworkMessageSizeDatagram, true
	case "PubSubCapabilitiesType_MaxNetworkMessageSizeBroker":
		return OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxNetworkMessageSizeBroker, true
	case "PubSubCapabilitiesType_SupportSecurityKeyPull":
		return OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_SupportSecurityKeyPull, true
	case "PubSubCapabilitiesType_SupportSecurityKeyPush":
		return OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_SupportSecurityKeyPush, true
	case "PubSubCapabilitiesType_MaxSecurityGroups":
		return OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxSecurityGroups, true
	case "PubSubCapabilitiesType_MaxPushTargets":
		return OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxPushTargets, true
	case "PubSubCapabilitiesType_MaxPublishedDataSets":
		return OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxPublishedDataSets, true
	case "PubSubCapabilitiesType_MaxStandaloneSubscribedDataSets":
		return OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxStandaloneSubscribedDataSets, true
	case "PubSubCapabilitiesType_SupportSecurityKeyServer":
		return OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_SupportSecurityKeyServer, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariablePubKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariablePubValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariablePub(structType any) OpcuaNodeIdServicesVariablePub {
	castFunc := func(typ any) OpcuaNodeIdServicesVariablePub {
		if sOpcuaNodeIdServicesVariablePub, ok := typ.(OpcuaNodeIdServicesVariablePub); ok {
			return sOpcuaNodeIdServicesVariablePub
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariablePub) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariablePub) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariablePubParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariablePub, error) {
	return OpcuaNodeIdServicesVariablePubParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariablePubParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariablePub, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariablePub", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariablePub")
	}
	if enum, ok := OpcuaNodeIdServicesVariablePubByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariablePub")
		return OpcuaNodeIdServicesVariablePub(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariablePub) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariablePub) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariablePub", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariablePub) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_RemoveGroup_InputArguments:
		return "PubSubConnectionType_RemoveGroup_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_PublisherId:
		return "PubSubConnectionType_PublisherId"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Status_State:
		return "PubSubConnectionType_Status_State"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionTypeRemoveGroupMethodType_InputArguments:
		return "PubSubConnectionTypeRemoveGroupMethodType_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubGroupTypeRemoveWriterMethodType_InputArguments:
		return "PubSubGroupTypeRemoveWriterMethodType_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubGroupTypeRemoveReaderMethodType_InputArguments:
		return "PubSubGroupTypeRemoveReaderMethodType_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubStatusType_State:
		return "PubSubStatusType_State"
	case OpcuaNodeIdServicesVariablePub_PubSubState_EnumStrings:
		return "PubSubState_EnumStrings"
	case OpcuaNodeIdServicesVariablePub_PubSubGroupType_Status_State:
		return "PubSubGroupType_Status_State"
	case OpcuaNodeIdServicesVariablePub_PubSubStatusEventType_ConnectionId:
		return "PubSubStatusEventType_ConnectionId"
	case OpcuaNodeIdServicesVariablePub_PubSubStatusEventType_GroupId:
		return "PubSubStatusEventType_GroupId"
	case OpcuaNodeIdServicesVariablePub_PubSubStatusEventType_State:
		return "PubSubStatusEventType_State"
	case OpcuaNodeIdServicesVariablePub_PubSubTransportLimitsExceedEventType_Actual:
		return "PubSubTransportLimitsExceedEventType_Actual"
	case OpcuaNodeIdServicesVariablePub_PubSubTransportLimitsExceedEventType_Maximum:
		return "PubSubTransportLimitsExceedEventType_Maximum"
	case OpcuaNodeIdServicesVariablePub_PubSubCommunicationFailureEventType_Error:
		return "PubSubCommunicationFailureEventType_Error"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_GetSecurityKeys_InputArguments:
		return "PubSubKeyServiceType_GetSecurityKeys_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_GetSecurityKeys_OutputArguments:
		return "PubSubKeyServiceType_GetSecurityKeys_OutputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_GetSecurityGroup_InputArguments:
		return "PubSubKeyServiceType_GetSecurityGroup_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_GetSecurityGroup_OutputArguments:
		return "PubSubKeyServiceType_GetSecurityGroup_OutputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_SecurityGroups_AddSecurityGroup_InputArguments:
		return "PubSubKeyServiceType_SecurityGroups_AddSecurityGroup_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_SecurityGroups_AddSecurityGroup_OutputArguments:
		return "PubSubKeyServiceType_SecurityGroups_AddSecurityGroup_OutputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroup_InputArguments:
		return "PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroup_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubGroupType_SecurityMode:
		return "PubSubGroupType_SecurityMode"
	case OpcuaNodeIdServicesVariablePub_PubSubGroupType_SecurityGroupId:
		return "PubSubGroupType_SecurityGroupId"
	case OpcuaNodeIdServicesVariablePub_PubSubGroupType_SecurityKeyServices:
		return "PubSubGroupType_SecurityKeyServices"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Address_NetworkInterface:
		return "PubSubConnectionType_Address_NetworkInterface"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_MaxNetworkMessageSize:
		return "PubSubConnectionType_WriterGroupName_Placeholder_MaxNetworkMessageSize"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_WriterGroupId:
		return "PubSubConnectionType_WriterGroupName_Placeholder_WriterGroupId"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_AddDataSetWriter_InputArguments:
		return "PubSubConnectionType_WriterGroupName_Placeholder_AddDataSetWriter_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_AddDataSetWriter_OutputArguments:
		return "PubSubConnectionType_WriterGroupName_Placeholder_AddDataSetWriter_OutputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_MaxNetworkMessageSize:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_MaxNetworkMessageSize"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_TransportProfileUri:
		return "PubSubConnectionType_TransportProfileUri"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_TransportProfileUri_RestrictToList:
		return "PubSubConnectionType_TransportProfileUri_RestrictToList"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_SecurityMode:
		return "PubSubConnectionType_WriterGroupName_Placeholder_SecurityMode"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_SecurityGroupId:
		return "PubSubConnectionType_WriterGroupName_Placeholder_SecurityGroupId"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_SecurityKeyServices:
		return "PubSubConnectionType_WriterGroupName_Placeholder_SecurityKeyServices"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Status_State:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Status_State"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_PublishingInterval:
		return "PubSubConnectionType_WriterGroupName_Placeholder_PublishingInterval"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_KeepAliveTime:
		return "PubSubConnectionType_WriterGroupName_Placeholder_KeepAliveTime"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Priority:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Priority"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_LocaleIds:
		return "PubSubConnectionType_WriterGroupName_Placeholder_LocaleIds"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_RemoveDataSetWriter_InputArguments:
		return "PubSubConnectionType_WriterGroupName_Placeholder_RemoveDataSetWriter_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_SecurityMode:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_SecurityMode"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_SecurityGroupId:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_SecurityGroupId"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_SecurityKeyServices:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_SecurityKeyServices"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Status_State:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Status_State"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_RemoveDataSetReader_InputArguments:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_RemoveDataSetReader_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_AddDataSetReader_InputArguments:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_AddDataSetReader_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_AddDataSetReader_OutputArguments:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_AddDataSetReader_OutputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_AddWriterGroup_InputArguments:
		return "PubSubConnectionType_AddWriterGroup_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_AddWriterGroup_OutputArguments:
		return "PubSubConnectionType_AddWriterGroup_OutputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ConnectionProperties:
		return "PubSubConnectionType_ConnectionProperties"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_GroupProperties:
		return "PubSubConnectionType_WriterGroupName_Placeholder_GroupProperties"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_GroupProperties:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_GroupProperties"
	case OpcuaNodeIdServicesVariablePub_PubSubGroupType_GroupProperties:
		return "PubSubGroupType_GroupProperties"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_AddReaderGroup_InputArguments:
		return "PubSubConnectionType_AddReaderGroup_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_AddReaderGroup_OutputArguments:
		return "PubSubConnectionType_AddReaderGroup_OutputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_HeaderLayoutUri:
		return "PubSubConnectionType_WriterGroupName_Placeholder_HeaderLayoutUri"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Address_NetworkInterface_Selections:
		return "PubSubConnectionType_Address_NetworkInterface_Selections"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Address_NetworkInterface_SelectionDescriptions:
		return "PubSubConnectionType_Address_NetworkInterface_SelectionDescriptions"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Address_NetworkInterface_RestrictToList:
		return "PubSubConnectionType_Address_NetworkInterface_RestrictToList"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionTypeAddWriterGroupMethodType_InputArguments:
		return "PubSubConnectionTypeAddWriterGroupMethodType_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionTypeAddWriterGroupMethodType_OutputArguments:
		return "PubSubConnectionTypeAddWriterGroupMethodType_OutputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionAddReaderGroupGroupMethodType_InputArguments:
		return "PubSubConnectionAddReaderGroupGroupMethodType_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_TransportProfileUri_Selections:
		return "PubSubConnectionType_TransportProfileUri_Selections"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_TransportProfileUri_SelectionDescriptions:
		return "PubSubConnectionType_TransportProfileUri_SelectionDescriptions"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionAddReaderGroupGroupMethodType_OutputArguments:
		return "PubSubConnectionAddReaderGroupGroupMethodType_OutputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubGroupType_MaxNetworkMessageSize:
		return "PubSubGroupType_MaxNetworkMessageSize"
	case OpcuaNodeIdServicesVariablePub_PubSubGroupTypeAddWriterMethodType_InputArguments:
		return "PubSubGroupTypeAddWriterMethodType_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubGroupTypeAddWriterMethodType_OutputArguments:
		return "PubSubGroupTypeAddWriterMethodType_OutputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_DiagnosticsLevel:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_Active:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_Classification:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_Active:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_Classification:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_TimeFirstChange:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_SubError:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_SubError"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_Active:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_Classification:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_Active:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_Classification:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_DiagnosticsLevel:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_TimeFirstChange:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_Active:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_Classification:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_DiagnosticsLevel:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_TimeFirstChange:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_Active:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_Classification:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_DiagnosticsLevel:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_TimeFirstChange:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetWriters:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetWriters"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetWriters:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetWriters"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_SecurityTokenID:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_SecurityTokenID"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_SecurityTokenID_DiagnosticsLevel:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_SecurityTokenID_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID_DiagnosticsLevel:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_DiagnosticsLevel:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_Active:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_Classification:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_Active:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_Classification:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_TimeFirstChange:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_SubError:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_SubError"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_Active:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_Classification:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_Active:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_Classification:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_DiagnosticsLevel:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_TimeFirstChange:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Active:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Classification:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_DiagnosticsLevel:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_TimeFirstChange:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_Active:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_Classification:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_DiagnosticsLevel:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_TimeFirstChange:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetReaders:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetReaders"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetReaders:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetReaders"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_DiagnosticsLevel:
		return "PubSubConnectionType_Diagnostics_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalInformation:
		return "PubSubConnectionType_Diagnostics_TotalInformation"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalInformation_Active:
		return "PubSubConnectionType_Diagnostics_TotalInformation_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalInformation_Classification:
		return "PubSubConnectionType_Diagnostics_TotalInformation_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalInformation_DiagnosticsLevel:
		return "PubSubConnectionType_Diagnostics_TotalInformation_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalInformation_TimeFirstChange:
		return "PubSubConnectionType_Diagnostics_TotalInformation_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalError:
		return "PubSubConnectionType_Diagnostics_TotalError"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalError_Active:
		return "PubSubConnectionType_Diagnostics_TotalError_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalError_Classification:
		return "PubSubConnectionType_Diagnostics_TotalError_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalError_DiagnosticsLevel:
		return "PubSubConnectionType_Diagnostics_TotalError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_TotalError_TimeFirstChange:
		return "PubSubConnectionType_Diagnostics_TotalError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_SubError:
		return "PubSubConnectionType_Diagnostics_SubError"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateError:
		return "PubSubConnectionType_Diagnostics_Counters_StateError"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateError_Active:
		return "PubSubConnectionType_Diagnostics_Counters_StateError_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateError_Classification:
		return "PubSubConnectionType_Diagnostics_Counters_StateError_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateError_DiagnosticsLevel:
		return "PubSubConnectionType_Diagnostics_Counters_StateError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateError_TimeFirstChange:
		return "PubSubConnectionType_Diagnostics_Counters_StateError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod:
		return "PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_Active:
		return "PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_Classification:
		return "PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel:
		return "PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange:
		return "PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent:
		return "PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_Active:
		return "PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_Classification:
		return "PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel:
		return "PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange:
		return "PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError:
		return "PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_Active:
		return "PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_Classification:
		return "PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel:
		return "PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange:
		return "PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StatePausedByParent:
		return "PubSubConnectionType_Diagnostics_Counters_StatePausedByParent"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_Active:
		return "PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_Classification:
		return "PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel:
		return "PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_TimeFirstChange:
		return "PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod:
		return "PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_Active:
		return "PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_Classification:
		return "PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel:
		return "PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange:
		return "PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_LiveValues_ResolvedAddress:
		return "PubSubConnectionType_Diagnostics_LiveValues_ResolvedAddress"
	case OpcuaNodeIdServicesVariablePub_PubSubConnectionType_Diagnostics_LiveValues_ResolvedAddress_DiagnosticsLevel:
		return "PubSubConnectionType_Diagnostics_LiveValues_ResolvedAddress_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_DiagnosticsLevel:
		return "PubSubDiagnosticsType_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalInformation:
		return "PubSubDiagnosticsType_TotalInformation"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalInformation_Active:
		return "PubSubDiagnosticsType_TotalInformation_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalInformation_Classification:
		return "PubSubDiagnosticsType_TotalInformation_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalInformation_DiagnosticsLevel:
		return "PubSubDiagnosticsType_TotalInformation_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalInformation_TimeFirstChange:
		return "PubSubDiagnosticsType_TotalInformation_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalError:
		return "PubSubDiagnosticsType_TotalError"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalError_Active:
		return "PubSubDiagnosticsType_TotalError_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalError_Classification:
		return "PubSubDiagnosticsType_TotalError_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalError_DiagnosticsLevel:
		return "PubSubDiagnosticsType_TotalError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_TotalError_TimeFirstChange:
		return "PubSubDiagnosticsType_TotalError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_SubError:
		return "PubSubDiagnosticsType_SubError"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateError:
		return "PubSubDiagnosticsType_Counters_StateError"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateError_Active:
		return "PubSubDiagnosticsType_Counters_StateError_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateError_Classification:
		return "PubSubDiagnosticsType_Counters_StateError_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateError_DiagnosticsLevel:
		return "PubSubDiagnosticsType_Counters_StateError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateError_TimeFirstChange:
		return "PubSubDiagnosticsType_Counters_StateError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByMethod:
		return "PubSubDiagnosticsType_Counters_StateOperationalByMethod"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByMethod_Active:
		return "PubSubDiagnosticsType_Counters_StateOperationalByMethod_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByMethod_Classification:
		return "PubSubDiagnosticsType_Counters_StateOperationalByMethod_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByMethod_DiagnosticsLevel:
		return "PubSubDiagnosticsType_Counters_StateOperationalByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByMethod_TimeFirstChange:
		return "PubSubDiagnosticsType_Counters_StateOperationalByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByParent:
		return "PubSubDiagnosticsType_Counters_StateOperationalByParent"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByParent_Active:
		return "PubSubDiagnosticsType_Counters_StateOperationalByParent_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByParent_Classification:
		return "PubSubDiagnosticsType_Counters_StateOperationalByParent_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByParent_DiagnosticsLevel:
		return "PubSubDiagnosticsType_Counters_StateOperationalByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalByParent_TimeFirstChange:
		return "PubSubDiagnosticsType_Counters_StateOperationalByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalFromError:
		return "PubSubDiagnosticsType_Counters_StateOperationalFromError"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalFromError_Active:
		return "PubSubDiagnosticsType_Counters_StateOperationalFromError_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalFromError_Classification:
		return "PubSubDiagnosticsType_Counters_StateOperationalFromError_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalFromError_DiagnosticsLevel:
		return "PubSubDiagnosticsType_Counters_StateOperationalFromError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateOperationalFromError_TimeFirstChange:
		return "PubSubDiagnosticsType_Counters_StateOperationalFromError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StatePausedByParent:
		return "PubSubDiagnosticsType_Counters_StatePausedByParent"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StatePausedByParent_Active:
		return "PubSubDiagnosticsType_Counters_StatePausedByParent_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StatePausedByParent_Classification:
		return "PubSubDiagnosticsType_Counters_StatePausedByParent_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StatePausedByParent_DiagnosticsLevel:
		return "PubSubDiagnosticsType_Counters_StatePausedByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StatePausedByParent_TimeFirstChange:
		return "PubSubDiagnosticsType_Counters_StatePausedByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateDisabledByMethod:
		return "PubSubDiagnosticsType_Counters_StateDisabledByMethod"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateDisabledByMethod_Active:
		return "PubSubDiagnosticsType_Counters_StateDisabledByMethod_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateDisabledByMethod_Classification:
		return "PubSubDiagnosticsType_Counters_StateDisabledByMethod_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateDisabledByMethod_DiagnosticsLevel:
		return "PubSubDiagnosticsType_Counters_StateDisabledByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsType_Counters_StateDisabledByMethod_TimeFirstChange:
		return "PubSubDiagnosticsType_Counters_StateDisabledByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsCounterType_Active:
		return "PubSubDiagnosticsCounterType_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsCounterType_Classification:
		return "PubSubDiagnosticsCounterType_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsCounterType_DiagnosticsLevel:
		return "PubSubDiagnosticsCounterType_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsCounterType_TimeFirstChange:
		return "PubSubDiagnosticsCounterType_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsCounterClassification_EnumStrings:
		return "PubSubDiagnosticsCounterClassification_EnumStrings"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetWriters:
		return "PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetWriters"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel:
		return "PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetReaders:
		return "PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetReaders"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel:
		return "PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_OperationalDataSetWriters:
		return "PubSubDiagnosticsRootType_LiveValues_OperationalDataSetWriters"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_OperationalDataSetWriters_DiagnosticsLevel:
		return "PubSubDiagnosticsRootType_LiveValues_OperationalDataSetWriters_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_OperationalDataSetReaders:
		return "PubSubDiagnosticsRootType_LiveValues_OperationalDataSetReaders"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsRootType_LiveValues_OperationalDataSetReaders_DiagnosticsLevel:
		return "PubSubDiagnosticsRootType_LiveValues_OperationalDataSetReaders_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsConnectionType_LiveValues_ResolvedAddress:
		return "PubSubDiagnosticsConnectionType_LiveValues_ResolvedAddress"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsConnectionType_LiveValues_ResolvedAddress_DiagnosticsLevel:
		return "PubSubDiagnosticsConnectionType_LiveValues_ResolvedAddress_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateError:
		return "PubSubDiagnosticsWriterGroupType_Counters_StateError"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateError_Active:
		return "PubSubDiagnosticsWriterGroupType_Counters_StateError_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateError_Classification:
		return "PubSubDiagnosticsWriterGroupType_Counters_StateError_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateError_DiagnosticsLevel:
		return "PubSubDiagnosticsWriterGroupType_Counters_StateError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateError_TimeFirstChange:
		return "PubSubDiagnosticsWriterGroupType_Counters_StateError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod:
		return "PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_Active:
		return "PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_Classification:
		return "PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_DiagnosticsLevel:
		return "PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_TimeFirstChange:
		return "PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent:
		return "PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_Active:
		return "PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_Classification:
		return "PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_DiagnosticsLevel:
		return "PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_TimeFirstChange:
		return "PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError:
		return "PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_Active:
		return "PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_Classification:
		return "PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_DiagnosticsLevel:
		return "PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_TimeFirstChange:
		return "PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent:
		return "PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_Active:
		return "PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_Classification:
		return "PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_DiagnosticsLevel:
		return "PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_TimeFirstChange:
		return "PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod:
		return "PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_Active:
		return "PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_Classification:
		return "PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_DiagnosticsLevel:
		return "PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_TimeFirstChange:
		return "PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages:
		return "PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_Active:
		return "PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_Classification:
		return "PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_DiagnosticsLevel:
		return "PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_TimeFirstChange:
		return "PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions:
		return "PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_Active:
		return "PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_Classification:
		return "PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_DiagnosticsLevel:
		return "PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_TimeFirstChange:
		return "PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors:
		return "PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_Active:
		return "PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_Classification:
		return "PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_DiagnosticsLevel:
		return "PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_TimeFirstChange:
		return "PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_ConfiguredDataSetWriters:
		return "PubSubDiagnosticsWriterGroupType_LiveValues_ConfiguredDataSetWriters"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel:
		return "PubSubDiagnosticsWriterGroupType_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_OperationalDataSetWriters:
		return "PubSubDiagnosticsWriterGroupType_LiveValues_OperationalDataSetWriters"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_OperationalDataSetWriters_DiagnosticsLevel:
		return "PubSubDiagnosticsWriterGroupType_LiveValues_OperationalDataSetWriters_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_SecurityTokenID:
		return "PubSubDiagnosticsWriterGroupType_LiveValues_SecurityTokenID"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_SecurityTokenID_DiagnosticsLevel:
		return "PubSubDiagnosticsWriterGroupType_LiveValues_SecurityTokenID_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_TimeToNextTokenID:
		return "PubSubDiagnosticsWriterGroupType_LiveValues_TimeToNextTokenID"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsWriterGroupType_LiveValues_TimeToNextTokenID_DiagnosticsLevel:
		return "PubSubDiagnosticsWriterGroupType_LiveValues_TimeToNextTokenID_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateError:
		return "PubSubDiagnosticsReaderGroupType_Counters_StateError"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateError_Active:
		return "PubSubDiagnosticsReaderGroupType_Counters_StateError_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateError_Classification:
		return "PubSubDiagnosticsReaderGroupType_Counters_StateError_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateError_DiagnosticsLevel:
		return "PubSubDiagnosticsReaderGroupType_Counters_StateError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateError_TimeFirstChange:
		return "PubSubDiagnosticsReaderGroupType_Counters_StateError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod:
		return "PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_Active:
		return "PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_Classification:
		return "PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_DiagnosticsLevel:
		return "PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_TimeFirstChange:
		return "PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent:
		return "PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_Active:
		return "PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_Classification:
		return "PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_DiagnosticsLevel:
		return "PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_TimeFirstChange:
		return "PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError:
		return "PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_Active:
		return "PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_Classification:
		return "PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_DiagnosticsLevel:
		return "PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_TimeFirstChange:
		return "PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent:
		return "PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_Active:
		return "PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_Classification:
		return "PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_DiagnosticsLevel:
		return "PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_TimeFirstChange:
		return "PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod:
		return "PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_Active:
		return "PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_Classification:
		return "PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_DiagnosticsLevel:
		return "PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_TimeFirstChange:
		return "PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages:
		return "PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_Active:
		return "PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_Classification:
		return "PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_DiagnosticsLevel:
		return "PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_TimeFirstChange:
		return "PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages:
		return "PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_Active:
		return "PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_Classification:
		return "PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_DiagnosticsLevel:
		return "PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_TimeFirstChange:
		return "PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors:
		return "PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_Active:
		return "PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_Classification:
		return "PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_DiagnosticsLevel:
		return "PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_TimeFirstChange:
		return "PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_LiveValues_ConfiguredDataSetReaders:
		return "PubSubDiagnosticsReaderGroupType_LiveValues_ConfiguredDataSetReaders"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel:
		return "PubSubDiagnosticsReaderGroupType_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_LiveValues_OperationalDataSetReaders:
		return "PubSubDiagnosticsReaderGroupType_LiveValues_OperationalDataSetReaders"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsReaderGroupType_LiveValues_OperationalDataSetReaders_DiagnosticsLevel:
		return "PubSubDiagnosticsReaderGroupType_LiveValues_OperationalDataSetReaders_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateError:
		return "PubSubDiagnosticsDataSetWriterType_Counters_StateError"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateError_Active:
		return "PubSubDiagnosticsDataSetWriterType_Counters_StateError_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateError_Classification:
		return "PubSubDiagnosticsDataSetWriterType_Counters_StateError_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateError_DiagnosticsLevel:
		return "PubSubDiagnosticsDataSetWriterType_Counters_StateError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateError_TimeFirstChange:
		return "PubSubDiagnosticsDataSetWriterType_Counters_StateError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod:
		return "PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_Active:
		return "PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_Classification:
		return "PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_DiagnosticsLevel:
		return "PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_TimeFirstChange:
		return "PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent:
		return "PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_Active:
		return "PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_Classification:
		return "PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_DiagnosticsLevel:
		return "PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_TimeFirstChange:
		return "PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError:
		return "PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_Active:
		return "PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_Classification:
		return "PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_DiagnosticsLevel:
		return "PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_TimeFirstChange:
		return "PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent:
		return "PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_Active:
		return "PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_Classification:
		return "PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_DiagnosticsLevel:
		return "PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_TimeFirstChange:
		return "PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod:
		return "PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_Active:
		return "PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_Classification:
		return "PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_DiagnosticsLevel:
		return "PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_TimeFirstChange:
		return "PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages:
		return "PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_Active:
		return "PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_Classification:
		return "PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_DiagnosticsLevel:
		return "PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_TimeFirstChange:
		return "PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_MessageSequenceNumber:
		return "PubSubDiagnosticsDataSetWriterType_LiveValues_MessageSequenceNumber"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_MessageSequenceNumber_DiagnosticsLevel:
		return "PubSubDiagnosticsDataSetWriterType_LiveValues_MessageSequenceNumber_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_StatusCode:
		return "PubSubDiagnosticsDataSetWriterType_LiveValues_StatusCode"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_StatusCode_DiagnosticsLevel:
		return "PubSubDiagnosticsDataSetWriterType_LiveValues_StatusCode_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_MajorVersion:
		return "PubSubDiagnosticsDataSetWriterType_LiveValues_MajorVersion"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_MajorVersion_DiagnosticsLevel:
		return "PubSubDiagnosticsDataSetWriterType_LiveValues_MajorVersion_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_MinorVersion:
		return "PubSubDiagnosticsDataSetWriterType_LiveValues_MinorVersion"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetWriterType_LiveValues_MinorVersion_DiagnosticsLevel:
		return "PubSubDiagnosticsDataSetWriterType_LiveValues_MinorVersion_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateError:
		return "PubSubDiagnosticsDataSetReaderType_Counters_StateError"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateError_Active:
		return "PubSubDiagnosticsDataSetReaderType_Counters_StateError_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateError_Classification:
		return "PubSubDiagnosticsDataSetReaderType_Counters_StateError_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateError_DiagnosticsLevel:
		return "PubSubDiagnosticsDataSetReaderType_Counters_StateError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateError_TimeFirstChange:
		return "PubSubDiagnosticsDataSetReaderType_Counters_StateError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod:
		return "PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_Active:
		return "PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_Classification:
		return "PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_DiagnosticsLevel:
		return "PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_TimeFirstChange:
		return "PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent:
		return "PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_Active:
		return "PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_Classification:
		return "PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_DiagnosticsLevel:
		return "PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_TimeFirstChange:
		return "PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError:
		return "PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_Active:
		return "PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_Classification:
		return "PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_DiagnosticsLevel:
		return "PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_TimeFirstChange:
		return "PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent:
		return "PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_Active:
		return "PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_Classification:
		return "PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_DiagnosticsLevel:
		return "PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_TimeFirstChange:
		return "PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod:
		return "PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_Active:
		return "PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_Classification:
		return "PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_DiagnosticsLevel:
		return "PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_TimeFirstChange:
		return "PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages:
		return "PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_Active:
		return "PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_Classification:
		return "PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_DiagnosticsLevel:
		return "PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_TimeFirstChange:
		return "PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors:
		return "PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_Active:
		return "PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_Active"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_Classification:
		return "PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_Classification"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_DiagnosticsLevel:
		return "PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_TimeFirstChange:
		return "PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_MessageSequenceNumber:
		return "PubSubDiagnosticsDataSetReaderType_LiveValues_MessageSequenceNumber"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_MessageSequenceNumber_DiagnosticsLevel:
		return "PubSubDiagnosticsDataSetReaderType_LiveValues_MessageSequenceNumber_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_StatusCode:
		return "PubSubDiagnosticsDataSetReaderType_LiveValues_StatusCode"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_StatusCode_DiagnosticsLevel:
		return "PubSubDiagnosticsDataSetReaderType_LiveValues_StatusCode_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_MajorVersion:
		return "PubSubDiagnosticsDataSetReaderType_LiveValues_MajorVersion"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_MajorVersion_DiagnosticsLevel:
		return "PubSubDiagnosticsDataSetReaderType_LiveValues_MajorVersion_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_MinorVersion:
		return "PubSubDiagnosticsDataSetReaderType_LiveValues_MinorVersion"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_MinorVersion_DiagnosticsLevel:
		return "PubSubDiagnosticsDataSetReaderType_LiveValues_MinorVersion_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_SecurityTokenID:
		return "PubSubDiagnosticsDataSetReaderType_LiveValues_SecurityTokenID"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_SecurityTokenID_DiagnosticsLevel:
		return "PubSubDiagnosticsDataSetReaderType_LiveValues_SecurityTokenID_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_TimeToNextTokenID:
		return "PubSubDiagnosticsDataSetReaderType_LiveValues_TimeToNextTokenID"
	case OpcuaNodeIdServicesVariablePub_PubSubDiagnosticsDataSetReaderType_LiveValues_TimeToNextTokenID_DiagnosticsLevel:
		return "PubSubDiagnosticsDataSetReaderType_LiveValues_TimeToNextTokenID_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePub_PubSubGroupTypeAddReaderMethodType_InputArguments:
		return "PubSubGroupTypeAddReaderMethodType_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubGroupTypeAddReaderMethodType_OutputArguments:
		return "PubSubGroupTypeAddReaderMethodType_OutputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxPubSubConnections:
		return "PubSubCapabilitiesType_MaxPubSubConnections"
	case OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxWriterGroups:
		return "PubSubCapabilitiesType_MaxWriterGroups"
	case OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxReaderGroups:
		return "PubSubCapabilitiesType_MaxReaderGroups"
	case OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxDataSetWriters:
		return "PubSubCapabilitiesType_MaxDataSetWriters"
	case OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxDataSetReaders:
		return "PubSubCapabilitiesType_MaxDataSetReaders"
	case OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxFieldsPerDataSet:
		return "PubSubCapabilitiesType_MaxFieldsPerDataSet"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_SecurityGroups_AddSecurityGroupFolder_InputArguments:
		return "PubSubKeyServiceType_SecurityGroups_AddSecurityGroupFolder_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_SecurityGroups_AddSecurityGroupFolder_OutputArguments:
		return "PubSubKeyServiceType_SecurityGroups_AddSecurityGroupFolder_OutputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroupFolder_InputArguments:
		return "PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroupFolder_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_SecurityGroups_SupportedSecurityPolicyUris:
		return "PubSubKeyServiceType_SecurityGroups_SupportedSecurityPolicyUris"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_KeyPushTargets_AddPushTarget_InputArguments:
		return "PubSubKeyServiceType_KeyPushTargets_AddPushTarget_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_KeyPushTargets_AddPushTarget_OutputArguments:
		return "PubSubKeyServiceType_KeyPushTargets_AddPushTarget_OutputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_KeyPushTargets_RemovePushTarget_InputArguments:
		return "PubSubKeyServiceType_KeyPushTargets_RemovePushTarget_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_KeyPushTargets_AddPushTargetFolder_InputArguments:
		return "PubSubKeyServiceType_KeyPushTargets_AddPushTargetFolder_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_KeyPushTargets_AddPushTargetFolder_OutputArguments:
		return "PubSubKeyServiceType_KeyPushTargets_AddPushTargetFolder_OutputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyServiceType_KeyPushTargets_RemovePushTargetFolder_InputArguments:
		return "PubSubKeyServiceType_KeyPushTargets_RemovePushTargetFolder_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_SecurityPolicyUri:
		return "PubSubKeyPushTargetType_SecurityPolicyUri"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTarget_InputArguments:
		return "PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTarget_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTarget_OutputArguments:
		return "PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTarget_OutputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTarget_InputArguments:
		return "PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTarget_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTargetFolder_InputArguments:
		return "PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTargetFolder_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTargetFolder_OutputArguments:
		return "PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTargetFolder_OutputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTargetFolder_InputArguments:
		return "PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTargetFolder_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_SecurityPolicyUri:
		return "PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_SecurityPolicyUri"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_AddPushTarget_InputArguments:
		return "PubSubKeyPushTargetFolderType_AddPushTarget_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_AddPushTarget_OutputArguments:
		return "PubSubKeyPushTargetFolderType_AddPushTarget_OutputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_RemovePushTarget_InputArguments:
		return "PubSubKeyPushTargetFolderType_RemovePushTarget_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_AddPushTargetFolder_InputArguments:
		return "PubSubKeyPushTargetFolderType_AddPushTargetFolder_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_AddPushTargetFolder_OutputArguments:
		return "PubSubKeyPushTargetFolderType_AddPushTargetFolder_OutputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_RemovePushTargetFolder_InputArguments:
		return "PubSubKeyPushTargetFolderType_RemovePushTargetFolder_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubConfigurationType_ReserveIds_InputArguments:
		return "PubSubConfigurationType_ReserveIds_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubConfigurationType_ReserveIds_OutputArguments:
		return "PubSubConfigurationType_ReserveIds_OutputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubConfigurationType_CloseAndUpdate_InputArguments:
		return "PubSubConfigurationType_CloseAndUpdate_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubConfigurationType_CloseAndUpdate_OutputArguments:
		return "PubSubConfigurationType_CloseAndUpdate_OutputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubConfigurationTypeReserveIdsMethodType_InputArguments:
		return "PubSubConfigurationTypeReserveIdsMethodType_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubConfigurationTypeReserveIdsMethodType_OutputArguments:
		return "PubSubConfigurationTypeReserveIdsMethodType_OutputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubConfigurationTypeCloseAndUpdateMethodType_InputArguments:
		return "PubSubConfigurationTypeCloseAndUpdateMethodType_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubConfigurationTypeCloseAndUpdateMethodType_OutputArguments:
		return "PubSubConfigurationTypeCloseAndUpdateMethodType_OutputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubConfigurationRefMask_OptionSetValues:
		return "PubSubConfigurationRefMask_OptionSetValues"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_SecurityGroupId:
		return "PubSubKeyPushTargetType_SecurityGroupName_Placeholder_SecurityGroupId"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_KeyLifetime:
		return "PubSubKeyPushTargetType_SecurityGroupName_Placeholder_KeyLifetime"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_SecurityPolicyUri:
		return "PubSubKeyPushTargetType_SecurityGroupName_Placeholder_SecurityPolicyUri"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_MaxFutureKeyCount:
		return "PubSubKeyPushTargetType_SecurityGroupName_Placeholder_MaxFutureKeyCount"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_MaxPastKeyCount:
		return "PubSubKeyPushTargetType_SecurityGroupName_Placeholder_MaxPastKeyCount"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_ApplicationUri:
		return "PubSubKeyPushTargetType_ApplicationUri"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_EndpointUrl:
		return "PubSubKeyPushTargetType_EndpointUrl"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_UserTokenType:
		return "PubSubKeyPushTargetType_UserTokenType"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_RequestedKeyCount:
		return "PubSubKeyPushTargetType_RequestedKeyCount"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_RetryInterval:
		return "PubSubKeyPushTargetType_RetryInterval"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_LastPushExecutionTime:
		return "PubSubKeyPushTargetType_LastPushExecutionTime"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_LastPushErrorTime:
		return "PubSubKeyPushTargetType_LastPushErrorTime"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_ConnectSecurityGroups_InputArguments:
		return "PubSubKeyPushTargetType_ConnectSecurityGroups_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_ConnectSecurityGroups_OutputArguments:
		return "PubSubKeyPushTargetType_ConnectSecurityGroups_OutputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_DisconnectSecurityGroups_InputArguments:
		return "PubSubKeyPushTargetType_DisconnectSecurityGroups_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetType_DisconnectSecurityGroups_OutputArguments:
		return "PubSubKeyPushTargetType_DisconnectSecurityGroups_OutputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ApplicationUri:
		return "PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ApplicationUri"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_EndpointUrl:
		return "PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_EndpointUrl"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_UserTokenType:
		return "PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_UserTokenType"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_RequestedKeyCount:
		return "PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_RequestedKeyCount"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_RetryInterval:
		return "PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_RetryInterval"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_LastPushExecutionTime:
		return "PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_LastPushExecutionTime"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_LastPushErrorTime:
		return "PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_LastPushErrorTime"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ConnectSecurityGroups_InputArguments:
		return "PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ConnectSecurityGroups_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ConnectSecurityGroups_OutputArguments:
		return "PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ConnectSecurityGroups_OutputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_DisconnectSecurityGroups_InputArguments:
		return "PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_DisconnectSecurityGroups_InputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_DisconnectSecurityGroups_OutputArguments:
		return "PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_DisconnectSecurityGroups_OutputArguments"
	case OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxDataSetWritersPerGroup:
		return "PubSubCapabilitiesType_MaxDataSetWritersPerGroup"
	case OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxNetworkMessageSizeDatagram:
		return "PubSubCapabilitiesType_MaxNetworkMessageSizeDatagram"
	case OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxNetworkMessageSizeBroker:
		return "PubSubCapabilitiesType_MaxNetworkMessageSizeBroker"
	case OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_SupportSecurityKeyPull:
		return "PubSubCapabilitiesType_SupportSecurityKeyPull"
	case OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_SupportSecurityKeyPush:
		return "PubSubCapabilitiesType_SupportSecurityKeyPush"
	case OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxSecurityGroups:
		return "PubSubCapabilitiesType_MaxSecurityGroups"
	case OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxPushTargets:
		return "PubSubCapabilitiesType_MaxPushTargets"
	case OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxPublishedDataSets:
		return "PubSubCapabilitiesType_MaxPublishedDataSets"
	case OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_MaxStandaloneSubscribedDataSets:
		return "PubSubCapabilitiesType_MaxStandaloneSubscribedDataSets"
	case OpcuaNodeIdServicesVariablePub_PubSubCapabilitiesType_SupportSecurityKeyServer:
		return "PubSubCapabilitiesType_SupportSecurityKeyServer"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariablePub) String() string {
	return e.PLC4XEnumName()
}
