/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableOpc is an enum
type OpcuaNodeIdServicesVariableOpc int32

type IOpcuaNodeIdServicesVariableOpc interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema                                                           OpcuaNodeIdServicesVariableOpc = 7617
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeVersion                                           OpcuaNodeIdServicesVariableOpc = 7618
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NamespaceUri                                              OpcuaNodeIdServicesVariableOpc = 7619
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Argument                                                  OpcuaNodeIdServicesVariableOpc = 7650
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Argument_DataTypeVersion                                  OpcuaNodeIdServicesVariableOpc = 7651
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Argument_DictionaryFragment                               OpcuaNodeIdServicesVariableOpc = 7652
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumValueType                                             OpcuaNodeIdServicesVariableOpc = 7656
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumValueType_DataTypeVersion                             OpcuaNodeIdServicesVariableOpc = 7657
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumValueType_DictionaryFragment                          OpcuaNodeIdServicesVariableOpc = 7658
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StatusResult                                              OpcuaNodeIdServicesVariableOpc = 7659
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StatusResult_DataTypeVersion                              OpcuaNodeIdServicesVariableOpc = 7660
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StatusResult_DictionaryFragment                           OpcuaNodeIdServicesVariableOpc = 7661
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserTokenPolicy                                           OpcuaNodeIdServicesVariableOpc = 7662
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserTokenPolicy_DataTypeVersion                           OpcuaNodeIdServicesVariableOpc = 7663
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserTokenPolicy_DictionaryFragment                        OpcuaNodeIdServicesVariableOpc = 7664
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ApplicationDescription                                    OpcuaNodeIdServicesVariableOpc = 7665
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ApplicationDescription_DataTypeVersion                    OpcuaNodeIdServicesVariableOpc = 7666
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ApplicationDescription_DictionaryFragment                 OpcuaNodeIdServicesVariableOpc = 7667
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointDescription                                       OpcuaNodeIdServicesVariableOpc = 7668
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointDescription_DataTypeVersion                       OpcuaNodeIdServicesVariableOpc = 7669
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointDescription_DictionaryFragment                    OpcuaNodeIdServicesVariableOpc = 7670
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserIdentityToken                                         OpcuaNodeIdServicesVariableOpc = 7671
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserIdentityToken_DataTypeVersion                         OpcuaNodeIdServicesVariableOpc = 7672
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserIdentityToken_DictionaryFragment                      OpcuaNodeIdServicesVariableOpc = 7673
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AnonymousIdentityToken                                    OpcuaNodeIdServicesVariableOpc = 7674
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AnonymousIdentityToken_DataTypeVersion                    OpcuaNodeIdServicesVariableOpc = 7675
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AnonymousIdentityToken_DictionaryFragment                 OpcuaNodeIdServicesVariableOpc = 7676
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserNameIdentityToken                                     OpcuaNodeIdServicesVariableOpc = 7677
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserNameIdentityToken_DataTypeVersion                     OpcuaNodeIdServicesVariableOpc = 7678
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserNameIdentityToken_DictionaryFragment                  OpcuaNodeIdServicesVariableOpc = 7679
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_X509IdentityToken                                         OpcuaNodeIdServicesVariableOpc = 7680
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_X509IdentityToken_DataTypeVersion                         OpcuaNodeIdServicesVariableOpc = 7681
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_X509IdentityToken_DictionaryFragment                      OpcuaNodeIdServicesVariableOpc = 7682
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_IssuedIdentityToken                                       OpcuaNodeIdServicesVariableOpc = 7683
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_IssuedIdentityToken_DataTypeVersion                       OpcuaNodeIdServicesVariableOpc = 7684
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_IssuedIdentityToken_DictionaryFragment                    OpcuaNodeIdServicesVariableOpc = 7685
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointConfiguration                                     OpcuaNodeIdServicesVariableOpc = 7686
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointConfiguration_DataTypeVersion                     OpcuaNodeIdServicesVariableOpc = 7687
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointConfiguration_DictionaryFragment                  OpcuaNodeIdServicesVariableOpc = 7688
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BuildInfo                                                 OpcuaNodeIdServicesVariableOpc = 7692
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BuildInfo_DataTypeVersion                                 OpcuaNodeIdServicesVariableOpc = 7693
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BuildInfo_DictionaryFragment                              OpcuaNodeIdServicesVariableOpc = 7694
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SignedSoftwareCertificate                                 OpcuaNodeIdServicesVariableOpc = 7698
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SignedSoftwareCertificate_DataTypeVersion                 OpcuaNodeIdServicesVariableOpc = 7699
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SignedSoftwareCertificate_DictionaryFragment              OpcuaNodeIdServicesVariableOpc = 7700
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AddNodesItem                                              OpcuaNodeIdServicesVariableOpc = 7728
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AddNodesItem_DataTypeVersion                              OpcuaNodeIdServicesVariableOpc = 7729
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AddNodesItem_DictionaryFragment                           OpcuaNodeIdServicesVariableOpc = 7730
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AddReferencesItem                                         OpcuaNodeIdServicesVariableOpc = 7731
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AddReferencesItem_DataTypeVersion                         OpcuaNodeIdServicesVariableOpc = 7732
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AddReferencesItem_DictionaryFragment                      OpcuaNodeIdServicesVariableOpc = 7733
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DeleteNodesItem                                           OpcuaNodeIdServicesVariableOpc = 7734
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DeleteNodesItem_DataTypeVersion                           OpcuaNodeIdServicesVariableOpc = 7735
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DeleteNodesItem_DictionaryFragment                        OpcuaNodeIdServicesVariableOpc = 7736
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DeleteReferencesItem                                      OpcuaNodeIdServicesVariableOpc = 7737
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DeleteReferencesItem_DataTypeVersion                      OpcuaNodeIdServicesVariableOpc = 7738
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DeleteReferencesItem_DictionaryFragment                   OpcuaNodeIdServicesVariableOpc = 7739
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RegisteredServer                                          OpcuaNodeIdServicesVariableOpc = 7782
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RegisteredServer_DataTypeVersion                          OpcuaNodeIdServicesVariableOpc = 7783
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RegisteredServer_DictionaryFragment                       OpcuaNodeIdServicesVariableOpc = 7784
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ContentFilterElement                                      OpcuaNodeIdServicesVariableOpc = 7929
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ContentFilterElement_DataTypeVersion                      OpcuaNodeIdServicesVariableOpc = 7930
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ContentFilterElement_DictionaryFragment                   OpcuaNodeIdServicesVariableOpc = 7931
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ContentFilter                                             OpcuaNodeIdServicesVariableOpc = 7932
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ContentFilter_DataTypeVersion                             OpcuaNodeIdServicesVariableOpc = 7933
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ContentFilter_DictionaryFragment                          OpcuaNodeIdServicesVariableOpc = 7934
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FilterOperand                                             OpcuaNodeIdServicesVariableOpc = 7935
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FilterOperand_DataTypeVersion                             OpcuaNodeIdServicesVariableOpc = 7936
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FilterOperand_DictionaryFragment                          OpcuaNodeIdServicesVariableOpc = 7937
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ElementOperand                                            OpcuaNodeIdServicesVariableOpc = 7938
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ElementOperand_DataTypeVersion                            OpcuaNodeIdServicesVariableOpc = 7939
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ElementOperand_DictionaryFragment                         OpcuaNodeIdServicesVariableOpc = 7940
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_LiteralOperand                                            OpcuaNodeIdServicesVariableOpc = 7941
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_LiteralOperand_DataTypeVersion                            OpcuaNodeIdServicesVariableOpc = 7942
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_LiteralOperand_DictionaryFragment                         OpcuaNodeIdServicesVariableOpc = 7943
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AttributeOperand                                          OpcuaNodeIdServicesVariableOpc = 7944
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AttributeOperand_DataTypeVersion                          OpcuaNodeIdServicesVariableOpc = 7945
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AttributeOperand_DictionaryFragment                       OpcuaNodeIdServicesVariableOpc = 7946
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SimpleAttributeOperand                                    OpcuaNodeIdServicesVariableOpc = 7947
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SimpleAttributeOperand_DataTypeVersion                    OpcuaNodeIdServicesVariableOpc = 7948
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SimpleAttributeOperand_DictionaryFragment                 OpcuaNodeIdServicesVariableOpc = 7949
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryEvent                                              OpcuaNodeIdServicesVariableOpc = 8004
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryEvent_DataTypeVersion                              OpcuaNodeIdServicesVariableOpc = 8005
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryEvent_DictionaryFragment                           OpcuaNodeIdServicesVariableOpc = 8006
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_MonitoringFilter                                          OpcuaNodeIdServicesVariableOpc = 8067
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_MonitoringFilter_DataTypeVersion                          OpcuaNodeIdServicesVariableOpc = 8068
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_MonitoringFilter_DictionaryFragment                       OpcuaNodeIdServicesVariableOpc = 8069
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EventFilter                                               OpcuaNodeIdServicesVariableOpc = 8073
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EventFilter_DataTypeVersion                               OpcuaNodeIdServicesVariableOpc = 8074
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EventFilter_DictionaryFragment                            OpcuaNodeIdServicesVariableOpc = 8075
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AggregateConfiguration                                    OpcuaNodeIdServicesVariableOpc = 8076
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AggregateConfiguration_DataTypeVersion                    OpcuaNodeIdServicesVariableOpc = 8077
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AggregateConfiguration_DictionaryFragment                 OpcuaNodeIdServicesVariableOpc = 8078
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryEventFieldList                                     OpcuaNodeIdServicesVariableOpc = 8172
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryEventFieldList_DataTypeVersion                     OpcuaNodeIdServicesVariableOpc = 8173
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryEventFieldList_DictionaryFragment                  OpcuaNodeIdServicesVariableOpc = 8174
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RedundantServerDataType                                   OpcuaNodeIdServicesVariableOpc = 8208
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RedundantServerDataType_DataTypeVersion                   OpcuaNodeIdServicesVariableOpc = 8209
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RedundantServerDataType_DictionaryFragment                OpcuaNodeIdServicesVariableOpc = 8210
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SamplingIntervalDiagnosticsDataType                       OpcuaNodeIdServicesVariableOpc = 8211
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SamplingIntervalDiagnosticsDataType_DataTypeVersion       OpcuaNodeIdServicesVariableOpc = 8212
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SamplingIntervalDiagnosticsDataType_DictionaryFragment    OpcuaNodeIdServicesVariableOpc = 8213
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerDiagnosticsSummaryDataType                          OpcuaNodeIdServicesVariableOpc = 8214
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerDiagnosticsSummaryDataType_DataTypeVersion          OpcuaNodeIdServicesVariableOpc = 8215
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerDiagnosticsSummaryDataType_DictionaryFragment       OpcuaNodeIdServicesVariableOpc = 8216
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerStatusDataType                                      OpcuaNodeIdServicesVariableOpc = 8217
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerStatusDataType_DataTypeVersion                      OpcuaNodeIdServicesVariableOpc = 8218
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerStatusDataType_DictionaryFragment                   OpcuaNodeIdServicesVariableOpc = 8219
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SessionDiagnosticsDataType                                OpcuaNodeIdServicesVariableOpc = 8220
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SessionDiagnosticsDataType_DataTypeVersion                OpcuaNodeIdServicesVariableOpc = 8221
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SessionDiagnosticsDataType_DictionaryFragment             OpcuaNodeIdServicesVariableOpc = 8222
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SessionSecurityDiagnosticsDataType                        OpcuaNodeIdServicesVariableOpc = 8223
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SessionSecurityDiagnosticsDataType_DataTypeVersion        OpcuaNodeIdServicesVariableOpc = 8224
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SessionSecurityDiagnosticsDataType_DictionaryFragment     OpcuaNodeIdServicesVariableOpc = 8225
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServiceCounterDataType                                    OpcuaNodeIdServicesVariableOpc = 8226
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServiceCounterDataType_DataTypeVersion                    OpcuaNodeIdServicesVariableOpc = 8227
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServiceCounterDataType_DictionaryFragment                 OpcuaNodeIdServicesVariableOpc = 8228
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscriptionDiagnosticsDataType                           OpcuaNodeIdServicesVariableOpc = 8229
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscriptionDiagnosticsDataType_DataTypeVersion           OpcuaNodeIdServicesVariableOpc = 8230
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscriptionDiagnosticsDataType_DictionaryFragment        OpcuaNodeIdServicesVariableOpc = 8231
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ModelChangeStructureDataType                              OpcuaNodeIdServicesVariableOpc = 8232
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ModelChangeStructureDataType_DataTypeVersion              OpcuaNodeIdServicesVariableOpc = 8233
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ModelChangeStructureDataType_DictionaryFragment           OpcuaNodeIdServicesVariableOpc = 8234
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SemanticChangeStructureDataType                           OpcuaNodeIdServicesVariableOpc = 8235
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SemanticChangeStructureDataType_DataTypeVersion           OpcuaNodeIdServicesVariableOpc = 8236
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SemanticChangeStructureDataType_DictionaryFragment        OpcuaNodeIdServicesVariableOpc = 8237
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Range                                                     OpcuaNodeIdServicesVariableOpc = 8238
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Range_DataTypeVersion                                     OpcuaNodeIdServicesVariableOpc = 8239
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Range_DictionaryFragment                                  OpcuaNodeIdServicesVariableOpc = 8240
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EUInformation                                             OpcuaNodeIdServicesVariableOpc = 8241
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EUInformation_DataTypeVersion                             OpcuaNodeIdServicesVariableOpc = 8242
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EUInformation_DictionaryFragment                          OpcuaNodeIdServicesVariableOpc = 8243
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Annotation                                                OpcuaNodeIdServicesVariableOpc = 8244
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Annotation_DataTypeVersion                                OpcuaNodeIdServicesVariableOpc = 8245
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Annotation_DictionaryFragment                             OpcuaNodeIdServicesVariableOpc = 8246
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ProgramDiagnosticDataType                                 OpcuaNodeIdServicesVariableOpc = 8247
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ProgramDiagnosticDataType_DataTypeVersion                 OpcuaNodeIdServicesVariableOpc = 8248
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ProgramDiagnosticDataType_DictionaryFragment              OpcuaNodeIdServicesVariableOpc = 8249
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema                                                              OpcuaNodeIdServicesVariableOpc = 8252
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeVersion                                              OpcuaNodeIdServicesVariableOpc = 8253
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NamespaceUri                                                 OpcuaNodeIdServicesVariableOpc = 8254
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Argument                                                     OpcuaNodeIdServicesVariableOpc = 8285
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Argument_DataTypeVersion                                     OpcuaNodeIdServicesVariableOpc = 8286
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Argument_DictionaryFragment                                  OpcuaNodeIdServicesVariableOpc = 8287
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumValueType                                                OpcuaNodeIdServicesVariableOpc = 8291
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumValueType_DataTypeVersion                                OpcuaNodeIdServicesVariableOpc = 8292
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumValueType_DictionaryFragment                             OpcuaNodeIdServicesVariableOpc = 8293
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StatusResult                                                 OpcuaNodeIdServicesVariableOpc = 8294
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StatusResult_DataTypeVersion                                 OpcuaNodeIdServicesVariableOpc = 8295
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StatusResult_DictionaryFragment                              OpcuaNodeIdServicesVariableOpc = 8296
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserTokenPolicy                                              OpcuaNodeIdServicesVariableOpc = 8297
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserTokenPolicy_DataTypeVersion                              OpcuaNodeIdServicesVariableOpc = 8298
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserTokenPolicy_DictionaryFragment                           OpcuaNodeIdServicesVariableOpc = 8299
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ApplicationDescription                                       OpcuaNodeIdServicesVariableOpc = 8300
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ApplicationDescription_DataTypeVersion                       OpcuaNodeIdServicesVariableOpc = 8301
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ApplicationDescription_DictionaryFragment                    OpcuaNodeIdServicesVariableOpc = 8302
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointDescription                                          OpcuaNodeIdServicesVariableOpc = 8303
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointDescription_DataTypeVersion                          OpcuaNodeIdServicesVariableOpc = 8304
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointDescription_DictionaryFragment                       OpcuaNodeIdServicesVariableOpc = 8305
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserIdentityToken                                            OpcuaNodeIdServicesVariableOpc = 8306
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserIdentityToken_DataTypeVersion                            OpcuaNodeIdServicesVariableOpc = 8307
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserIdentityToken_DictionaryFragment                         OpcuaNodeIdServicesVariableOpc = 8308
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AnonymousIdentityToken                                       OpcuaNodeIdServicesVariableOpc = 8309
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AnonymousIdentityToken_DataTypeVersion                       OpcuaNodeIdServicesVariableOpc = 8310
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AnonymousIdentityToken_DictionaryFragment                    OpcuaNodeIdServicesVariableOpc = 8311
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserNameIdentityToken                                        OpcuaNodeIdServicesVariableOpc = 8312
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserNameIdentityToken_DataTypeVersion                        OpcuaNodeIdServicesVariableOpc = 8313
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserNameIdentityToken_DictionaryFragment                     OpcuaNodeIdServicesVariableOpc = 8314
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_X509IdentityToken                                            OpcuaNodeIdServicesVariableOpc = 8315
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_X509IdentityToken_DataTypeVersion                            OpcuaNodeIdServicesVariableOpc = 8316
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_X509IdentityToken_DictionaryFragment                         OpcuaNodeIdServicesVariableOpc = 8317
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_IssuedIdentityToken                                          OpcuaNodeIdServicesVariableOpc = 8318
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_IssuedIdentityToken_DataTypeVersion                          OpcuaNodeIdServicesVariableOpc = 8319
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_IssuedIdentityToken_DictionaryFragment                       OpcuaNodeIdServicesVariableOpc = 8320
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointConfiguration                                        OpcuaNodeIdServicesVariableOpc = 8321
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointConfiguration_DataTypeVersion                        OpcuaNodeIdServicesVariableOpc = 8322
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointConfiguration_DictionaryFragment                     OpcuaNodeIdServicesVariableOpc = 8323
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BuildInfo                                                    OpcuaNodeIdServicesVariableOpc = 8327
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BuildInfo_DataTypeVersion                                    OpcuaNodeIdServicesVariableOpc = 8328
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BuildInfo_DictionaryFragment                                 OpcuaNodeIdServicesVariableOpc = 8329
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SignedSoftwareCertificate                                    OpcuaNodeIdServicesVariableOpc = 8333
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SignedSoftwareCertificate_DataTypeVersion                    OpcuaNodeIdServicesVariableOpc = 8334
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SignedSoftwareCertificate_DictionaryFragment                 OpcuaNodeIdServicesVariableOpc = 8335
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AddNodesItem                                                 OpcuaNodeIdServicesVariableOpc = 8363
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AddNodesItem_DataTypeVersion                                 OpcuaNodeIdServicesVariableOpc = 8364
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AddNodesItem_DictionaryFragment                              OpcuaNodeIdServicesVariableOpc = 8365
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AddReferencesItem                                            OpcuaNodeIdServicesVariableOpc = 8366
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AddReferencesItem_DataTypeVersion                            OpcuaNodeIdServicesVariableOpc = 8367
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AddReferencesItem_DictionaryFragment                         OpcuaNodeIdServicesVariableOpc = 8368
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DeleteNodesItem                                              OpcuaNodeIdServicesVariableOpc = 8369
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DeleteNodesItem_DataTypeVersion                              OpcuaNodeIdServicesVariableOpc = 8370
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DeleteNodesItem_DictionaryFragment                           OpcuaNodeIdServicesVariableOpc = 8371
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DeleteReferencesItem                                         OpcuaNodeIdServicesVariableOpc = 8372
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DeleteReferencesItem_DataTypeVersion                         OpcuaNodeIdServicesVariableOpc = 8373
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DeleteReferencesItem_DictionaryFragment                      OpcuaNodeIdServicesVariableOpc = 8374
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RegisteredServer                                             OpcuaNodeIdServicesVariableOpc = 8417
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RegisteredServer_DataTypeVersion                             OpcuaNodeIdServicesVariableOpc = 8418
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RegisteredServer_DictionaryFragment                          OpcuaNodeIdServicesVariableOpc = 8419
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ContentFilterElement                                         OpcuaNodeIdServicesVariableOpc = 8564
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ContentFilterElement_DataTypeVersion                         OpcuaNodeIdServicesVariableOpc = 8565
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ContentFilterElement_DictionaryFragment                      OpcuaNodeIdServicesVariableOpc = 8566
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ContentFilter                                                OpcuaNodeIdServicesVariableOpc = 8567
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ContentFilter_DataTypeVersion                                OpcuaNodeIdServicesVariableOpc = 8568
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ContentFilter_DictionaryFragment                             OpcuaNodeIdServicesVariableOpc = 8569
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FilterOperand                                                OpcuaNodeIdServicesVariableOpc = 8570
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FilterOperand_DataTypeVersion                                OpcuaNodeIdServicesVariableOpc = 8571
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FilterOperand_DictionaryFragment                             OpcuaNodeIdServicesVariableOpc = 8572
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ElementOperand                                               OpcuaNodeIdServicesVariableOpc = 8573
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ElementOperand_DataTypeVersion                               OpcuaNodeIdServicesVariableOpc = 8574
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ElementOperand_DictionaryFragment                            OpcuaNodeIdServicesVariableOpc = 8575
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_LiteralOperand                                               OpcuaNodeIdServicesVariableOpc = 8576
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_LiteralOperand_DataTypeVersion                               OpcuaNodeIdServicesVariableOpc = 8577
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_LiteralOperand_DictionaryFragment                            OpcuaNodeIdServicesVariableOpc = 8578
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AttributeOperand                                             OpcuaNodeIdServicesVariableOpc = 8579
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AttributeOperand_DataTypeVersion                             OpcuaNodeIdServicesVariableOpc = 8580
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AttributeOperand_DictionaryFragment                          OpcuaNodeIdServicesVariableOpc = 8581
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SimpleAttributeOperand                                       OpcuaNodeIdServicesVariableOpc = 8582
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SimpleAttributeOperand_DataTypeVersion                       OpcuaNodeIdServicesVariableOpc = 8583
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SimpleAttributeOperand_DictionaryFragment                    OpcuaNodeIdServicesVariableOpc = 8584
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryEvent                                                 OpcuaNodeIdServicesVariableOpc = 8639
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryEvent_DataTypeVersion                                 OpcuaNodeIdServicesVariableOpc = 8640
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryEvent_DictionaryFragment                              OpcuaNodeIdServicesVariableOpc = 8641
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_MonitoringFilter                                             OpcuaNodeIdServicesVariableOpc = 8702
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_MonitoringFilter_DataTypeVersion                             OpcuaNodeIdServicesVariableOpc = 8703
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_MonitoringFilter_DictionaryFragment                          OpcuaNodeIdServicesVariableOpc = 8704
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EventFilter                                                  OpcuaNodeIdServicesVariableOpc = 8708
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EventFilter_DataTypeVersion                                  OpcuaNodeIdServicesVariableOpc = 8709
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EventFilter_DictionaryFragment                               OpcuaNodeIdServicesVariableOpc = 8710
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AggregateConfiguration                                       OpcuaNodeIdServicesVariableOpc = 8711
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AggregateConfiguration_DataTypeVersion                       OpcuaNodeIdServicesVariableOpc = 8712
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AggregateConfiguration_DictionaryFragment                    OpcuaNodeIdServicesVariableOpc = 8713
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryEventFieldList                                        OpcuaNodeIdServicesVariableOpc = 8807
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryEventFieldList_DataTypeVersion                        OpcuaNodeIdServicesVariableOpc = 8808
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryEventFieldList_DictionaryFragment                     OpcuaNodeIdServicesVariableOpc = 8809
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RedundantServerDataType                                      OpcuaNodeIdServicesVariableOpc = 8843
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RedundantServerDataType_DataTypeVersion                      OpcuaNodeIdServicesVariableOpc = 8844
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RedundantServerDataType_DictionaryFragment                   OpcuaNodeIdServicesVariableOpc = 8845
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SamplingIntervalDiagnosticsDataType                          OpcuaNodeIdServicesVariableOpc = 8846
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SamplingIntervalDiagnosticsDataType_DataTypeVersion          OpcuaNodeIdServicesVariableOpc = 8847
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SamplingIntervalDiagnosticsDataType_DictionaryFragment       OpcuaNodeIdServicesVariableOpc = 8848
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerDiagnosticsSummaryDataType                             OpcuaNodeIdServicesVariableOpc = 8849
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerDiagnosticsSummaryDataType_DataTypeVersion             OpcuaNodeIdServicesVariableOpc = 8850
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerDiagnosticsSummaryDataType_DictionaryFragment          OpcuaNodeIdServicesVariableOpc = 8851
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerStatusDataType                                         OpcuaNodeIdServicesVariableOpc = 8852
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerStatusDataType_DataTypeVersion                         OpcuaNodeIdServicesVariableOpc = 8853
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerStatusDataType_DictionaryFragment                      OpcuaNodeIdServicesVariableOpc = 8854
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SessionDiagnosticsDataType                                   OpcuaNodeIdServicesVariableOpc = 8855
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SessionDiagnosticsDataType_DataTypeVersion                   OpcuaNodeIdServicesVariableOpc = 8856
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SessionDiagnosticsDataType_DictionaryFragment                OpcuaNodeIdServicesVariableOpc = 8857
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SessionSecurityDiagnosticsDataType                           OpcuaNodeIdServicesVariableOpc = 8858
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SessionSecurityDiagnosticsDataType_DataTypeVersion           OpcuaNodeIdServicesVariableOpc = 8859
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SessionSecurityDiagnosticsDataType_DictionaryFragment        OpcuaNodeIdServicesVariableOpc = 8860
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServiceCounterDataType                                       OpcuaNodeIdServicesVariableOpc = 8861
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServiceCounterDataType_DataTypeVersion                       OpcuaNodeIdServicesVariableOpc = 8862
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServiceCounterDataType_DictionaryFragment                    OpcuaNodeIdServicesVariableOpc = 8863
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscriptionDiagnosticsDataType                              OpcuaNodeIdServicesVariableOpc = 8864
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscriptionDiagnosticsDataType_DataTypeVersion              OpcuaNodeIdServicesVariableOpc = 8865
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscriptionDiagnosticsDataType_DictionaryFragment           OpcuaNodeIdServicesVariableOpc = 8866
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ModelChangeStructureDataType                                 OpcuaNodeIdServicesVariableOpc = 8867
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ModelChangeStructureDataType_DataTypeVersion                 OpcuaNodeIdServicesVariableOpc = 8868
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ModelChangeStructureDataType_DictionaryFragment              OpcuaNodeIdServicesVariableOpc = 8869
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SemanticChangeStructureDataType                              OpcuaNodeIdServicesVariableOpc = 8870
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SemanticChangeStructureDataType_DataTypeVersion              OpcuaNodeIdServicesVariableOpc = 8871
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SemanticChangeStructureDataType_DictionaryFragment           OpcuaNodeIdServicesVariableOpc = 8872
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Range                                                        OpcuaNodeIdServicesVariableOpc = 8873
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Range_DataTypeVersion                                        OpcuaNodeIdServicesVariableOpc = 8874
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Range_DictionaryFragment                                     OpcuaNodeIdServicesVariableOpc = 8875
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EUInformation                                                OpcuaNodeIdServicesVariableOpc = 8876
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EUInformation_DataTypeVersion                                OpcuaNodeIdServicesVariableOpc = 8877
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EUInformation_DictionaryFragment                             OpcuaNodeIdServicesVariableOpc = 8878
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Annotation                                                   OpcuaNodeIdServicesVariableOpc = 8879
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Annotation_DataTypeVersion                                   OpcuaNodeIdServicesVariableOpc = 8880
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Annotation_DictionaryFragment                                OpcuaNodeIdServicesVariableOpc = 8881
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ProgramDiagnosticDataType                                    OpcuaNodeIdServicesVariableOpc = 8882
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ProgramDiagnosticDataType_DataTypeVersion                    OpcuaNodeIdServicesVariableOpc = 8883
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ProgramDiagnosticDataType_DictionaryFragment                 OpcuaNodeIdServicesVariableOpc = 8884
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TimeZoneDataType                                          OpcuaNodeIdServicesVariableOpc = 8914
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TimeZoneDataType_DataTypeVersion                          OpcuaNodeIdServicesVariableOpc = 8915
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TimeZoneDataType_DictionaryFragment                       OpcuaNodeIdServicesVariableOpc = 8916
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TimeZoneDataType                                             OpcuaNodeIdServicesVariableOpc = 8918
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TimeZoneDataType_DataTypeVersion                             OpcuaNodeIdServicesVariableOpc = 8919
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TimeZoneDataType_DictionaryFragment                          OpcuaNodeIdServicesVariableOpc = 8920
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointUrlListDataType                                      OpcuaNodeIdServicesVariableOpc = 11951
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointUrlListDataType_DataTypeVersion                      OpcuaNodeIdServicesVariableOpc = 11952
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointUrlListDataType_DictionaryFragment                   OpcuaNodeIdServicesVariableOpc = 11953
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkGroupDataType                                         OpcuaNodeIdServicesVariableOpc = 11954
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkGroupDataType_DataTypeVersion                         OpcuaNodeIdServicesVariableOpc = 11955
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkGroupDataType_DictionaryFragment                      OpcuaNodeIdServicesVariableOpc = 11956
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointUrlListDataType                                   OpcuaNodeIdServicesVariableOpc = 11959
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointUrlListDataType_DataTypeVersion                   OpcuaNodeIdServicesVariableOpc = 11960
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointUrlListDataType_DictionaryFragment                OpcuaNodeIdServicesVariableOpc = 11961
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkGroupDataType                                      OpcuaNodeIdServicesVariableOpc = 11962
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkGroupDataType_DataTypeVersion                      OpcuaNodeIdServicesVariableOpc = 11963
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkGroupDataType_DictionaryFragment                   OpcuaNodeIdServicesVariableOpc = 11964
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AxisInformation                                              OpcuaNodeIdServicesVariableOpc = 12083
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AxisInformation_DataTypeVersion                              OpcuaNodeIdServicesVariableOpc = 12084
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AxisInformation_DictionaryFragment                           OpcuaNodeIdServicesVariableOpc = 12085
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_XVType                                                       OpcuaNodeIdServicesVariableOpc = 12086
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_XVType_DataTypeVersion                                       OpcuaNodeIdServicesVariableOpc = 12087
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_XVType_DictionaryFragment                                    OpcuaNodeIdServicesVariableOpc = 12088
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AxisInformation                                           OpcuaNodeIdServicesVariableOpc = 12091
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AxisInformation_DataTypeVersion                           OpcuaNodeIdServicesVariableOpc = 12092
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AxisInformation_DictionaryFragment                        OpcuaNodeIdServicesVariableOpc = 12093
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_XVType                                                    OpcuaNodeIdServicesVariableOpc = 12094
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_XVType_DataTypeVersion                                    OpcuaNodeIdServicesVariableOpc = 12095
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_XVType_DictionaryFragment                                 OpcuaNodeIdServicesVariableOpc = 12096
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ComplexNumberType                                            OpcuaNodeIdServicesVariableOpc = 12175
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ComplexNumberType_DataTypeVersion                            OpcuaNodeIdServicesVariableOpc = 12176
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ComplexNumberType_DictionaryFragment                         OpcuaNodeIdServicesVariableOpc = 12177
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DoubleComplexNumberType                                      OpcuaNodeIdServicesVariableOpc = 12178
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DoubleComplexNumberType_DataTypeVersion                      OpcuaNodeIdServicesVariableOpc = 12179
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DoubleComplexNumberType_DictionaryFragment                   OpcuaNodeIdServicesVariableOpc = 12180
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ComplexNumberType                                         OpcuaNodeIdServicesVariableOpc = 12183
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ComplexNumberType_DataTypeVersion                         OpcuaNodeIdServicesVariableOpc = 12184
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ComplexNumberType_DictionaryFragment                      OpcuaNodeIdServicesVariableOpc = 12185
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DoubleComplexNumberType                                   OpcuaNodeIdServicesVariableOpc = 12186
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DoubleComplexNumberType_DataTypeVersion                   OpcuaNodeIdServicesVariableOpc = 12187
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DoubleComplexNumberType_DictionaryFragment                OpcuaNodeIdServicesVariableOpc = 12188
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerOnNetwork                                              OpcuaNodeIdServicesVariableOpc = 12201
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerOnNetwork_DataTypeVersion                              OpcuaNodeIdServicesVariableOpc = 12202
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerOnNetwork_DictionaryFragment                           OpcuaNodeIdServicesVariableOpc = 12203
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerOnNetwork                                           OpcuaNodeIdServicesVariableOpc = 12213
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerOnNetwork_DataTypeVersion                           OpcuaNodeIdServicesVariableOpc = 12214
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerOnNetwork_DictionaryFragment                        OpcuaNodeIdServicesVariableOpc = 12215
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TrustListDataType                                            OpcuaNodeIdServicesVariableOpc = 12677
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TrustListDataType_DataTypeVersion                            OpcuaNodeIdServicesVariableOpc = 12678
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TrustListDataType_DictionaryFragment                         OpcuaNodeIdServicesVariableOpc = 12679
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TrustListDataType                                         OpcuaNodeIdServicesVariableOpc = 12681
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TrustListDataType_DataTypeVersion                         OpcuaNodeIdServicesVariableOpc = 12682
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TrustListDataType_DictionaryFragment                      OpcuaNodeIdServicesVariableOpc = 12683
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RelativePathElement                                          OpcuaNodeIdServicesVariableOpc = 12712
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RelativePathElement_DataTypeVersion                          OpcuaNodeIdServicesVariableOpc = 12713
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RelativePathElement_DictionaryFragment                       OpcuaNodeIdServicesVariableOpc = 12714
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RelativePath                                                 OpcuaNodeIdServicesVariableOpc = 12715
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RelativePath_DataTypeVersion                                 OpcuaNodeIdServicesVariableOpc = 12716
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RelativePath_DictionaryFragment                              OpcuaNodeIdServicesVariableOpc = 12717
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RelativePathElement                                       OpcuaNodeIdServicesVariableOpc = 12718
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RelativePathElement_DataTypeVersion                       OpcuaNodeIdServicesVariableOpc = 12719
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RelativePathElement_DictionaryFragment                    OpcuaNodeIdServicesVariableOpc = 12720
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RelativePath                                              OpcuaNodeIdServicesVariableOpc = 12721
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RelativePath_DataTypeVersion                              OpcuaNodeIdServicesVariableOpc = 12722
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RelativePath_DictionaryFragment                           OpcuaNodeIdServicesVariableOpc = 12723
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_OptionSet                                                    OpcuaNodeIdServicesVariableOpc = 12759
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_OptionSet_DataTypeVersion                                    OpcuaNodeIdServicesVariableOpc = 12760
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_OptionSet_DictionaryFragment                                 OpcuaNodeIdServicesVariableOpc = 12761
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Union                                                        OpcuaNodeIdServicesVariableOpc = 12762
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Union_DataTypeVersion                                        OpcuaNodeIdServicesVariableOpc = 12763
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Union_DictionaryFragment                                     OpcuaNodeIdServicesVariableOpc = 12764
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_OptionSet                                                 OpcuaNodeIdServicesVariableOpc = 12767
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_OptionSet_DataTypeVersion                                 OpcuaNodeIdServicesVariableOpc = 12768
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_OptionSet_DictionaryFragment                              OpcuaNodeIdServicesVariableOpc = 12769
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Union                                                     OpcuaNodeIdServicesVariableOpc = 12770
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Union_DataTypeVersion                                     OpcuaNodeIdServicesVariableOpc = 12771
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Union_DictionaryFragment                                  OpcuaNodeIdServicesVariableOpc = 12772
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DiscoveryConfiguration                                       OpcuaNodeIdServicesVariableOpc = 12894
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DiscoveryConfiguration_DataTypeVersion                       OpcuaNodeIdServicesVariableOpc = 12895
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DiscoveryConfiguration_DictionaryFragment                    OpcuaNodeIdServicesVariableOpc = 12896
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_MdnsDiscoveryConfiguration                                   OpcuaNodeIdServicesVariableOpc = 12897
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_MdnsDiscoveryConfiguration_DataTypeVersion                   OpcuaNodeIdServicesVariableOpc = 12898
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_MdnsDiscoveryConfiguration_DictionaryFragment                OpcuaNodeIdServicesVariableOpc = 12899
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DiscoveryConfiguration                                    OpcuaNodeIdServicesVariableOpc = 12902
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DiscoveryConfiguration_DataTypeVersion                    OpcuaNodeIdServicesVariableOpc = 12903
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DiscoveryConfiguration_DictionaryFragment                 OpcuaNodeIdServicesVariableOpc = 12904
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_MdnsDiscoveryConfiguration                                OpcuaNodeIdServicesVariableOpc = 12905
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_MdnsDiscoveryConfiguration_DataTypeVersion                OpcuaNodeIdServicesVariableOpc = 12906
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_MdnsDiscoveryConfiguration_DictionaryFragment             OpcuaNodeIdServicesVariableOpc = 12907
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedVariableDataType                                    OpcuaNodeIdServicesVariableOpc = 14320
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedVariableDataType_DataTypeVersion                    OpcuaNodeIdServicesVariableOpc = 14321
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedVariableDataType_DictionaryFragment                 OpcuaNodeIdServicesVariableOpc = 14322
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedVariableDataType                                 OpcuaNodeIdServicesVariableOpc = 14324
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedVariableDataType_DataTypeVersion                 OpcuaNodeIdServicesVariableOpc = 14325
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedVariableDataType_DictionaryFragment              OpcuaNodeIdServicesVariableOpc = 14326
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetMetaDataType                                          OpcuaNodeIdServicesVariableOpc = 14805
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetMetaDataType_DataTypeVersion                          OpcuaNodeIdServicesVariableOpc = 14806
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetMetaDataType_DictionaryFragment                       OpcuaNodeIdServicesVariableOpc = 14807
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FieldMetaData                                                OpcuaNodeIdServicesVariableOpc = 14808
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FieldMetaData_DataTypeVersion                                OpcuaNodeIdServicesVariableOpc = 14809
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FieldMetaData_DictionaryFragment                             OpcuaNodeIdServicesVariableOpc = 14810
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeDescription                                          OpcuaNodeIdServicesVariableOpc = 14811
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeDescription_DataTypeVersion                          OpcuaNodeIdServicesVariableOpc = 14812
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeDescription_DictionaryFragment                       OpcuaNodeIdServicesVariableOpc = 14813
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumField                                                    OpcuaNodeIdServicesVariableOpc = 14826
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumField_DataTypeVersion                                    OpcuaNodeIdServicesVariableOpc = 14827
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumField_DictionaryFragment                                 OpcuaNodeIdServicesVariableOpc = 14828
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_KeyValuePair                                                 OpcuaNodeIdServicesVariableOpc = 14829
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_KeyValuePair_DataTypeVersion                                 OpcuaNodeIdServicesVariableOpc = 14830
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_KeyValuePair_DictionaryFragment                              OpcuaNodeIdServicesVariableOpc = 14831
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ConfigurationVersionDataType                                 OpcuaNodeIdServicesVariableOpc = 14832
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ConfigurationVersionDataType_DataTypeVersion                 OpcuaNodeIdServicesVariableOpc = 14833
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ConfigurationVersionDataType_DictionaryFragment              OpcuaNodeIdServicesVariableOpc = 14834
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FieldTargetDataType                                          OpcuaNodeIdServicesVariableOpc = 14835
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FieldTargetDataType_DataTypeVersion                          OpcuaNodeIdServicesVariableOpc = 14836
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FieldTargetDataType_DictionaryFragment                       OpcuaNodeIdServicesVariableOpc = 14837
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetMetaDataType                                       OpcuaNodeIdServicesVariableOpc = 14849
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetMetaDataType_DataTypeVersion                       OpcuaNodeIdServicesVariableOpc = 14850
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetMetaDataType_DictionaryFragment                    OpcuaNodeIdServicesVariableOpc = 14851
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FieldMetaData                                             OpcuaNodeIdServicesVariableOpc = 14852
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FieldMetaData_DataTypeVersion                             OpcuaNodeIdServicesVariableOpc = 14853
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FieldMetaData_DictionaryFragment                          OpcuaNodeIdServicesVariableOpc = 14854
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeDescription                                       OpcuaNodeIdServicesVariableOpc = 14855
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeDescription_DataTypeVersion                       OpcuaNodeIdServicesVariableOpc = 14856
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeDescription_DictionaryFragment                    OpcuaNodeIdServicesVariableOpc = 14857
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumField                                                 OpcuaNodeIdServicesVariableOpc = 14870
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumField_DataTypeVersion                                 OpcuaNodeIdServicesVariableOpc = 14871
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumField_DictionaryFragment                              OpcuaNodeIdServicesVariableOpc = 14872
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_KeyValuePair                                              OpcuaNodeIdServicesVariableOpc = 14873
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_KeyValuePair_DataTypeVersion                              OpcuaNodeIdServicesVariableOpc = 14874
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_KeyValuePair_DictionaryFragment                           OpcuaNodeIdServicesVariableOpc = 14875
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ConfigurationVersionDataType                              OpcuaNodeIdServicesVariableOpc = 14876
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ConfigurationVersionDataType_DataTypeVersion              OpcuaNodeIdServicesVariableOpc = 14877
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ConfigurationVersionDataType_DictionaryFragment           OpcuaNodeIdServicesVariableOpc = 14878
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FieldTargetDataType_DataTypeVersion                       OpcuaNodeIdServicesVariableOpc = 14880
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FieldTargetDataType_DictionaryFragment                    OpcuaNodeIdServicesVariableOpc = 14881
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ModificationInfo                                          OpcuaNodeIdServicesVariableOpc = 15018
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ModificationInfo_DataTypeVersion                          OpcuaNodeIdServicesVariableOpc = 15019
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ModificationInfo_DictionaryFragment                       OpcuaNodeIdServicesVariableOpc = 15020
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ModificationInfo                                             OpcuaNodeIdServicesVariableOpc = 15021
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ModificationInfo_DataTypeVersion                             OpcuaNodeIdServicesVariableOpc = 15022
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ModificationInfo_DictionaryFragment                          OpcuaNodeIdServicesVariableOpc = 15023
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Deprecated                                                OpcuaNodeIdServicesVariableOpc = 15037
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Deprecated                                                   OpcuaNodeIdServicesVariableOpc = 15039
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SimpleTypeDescription                                     OpcuaNodeIdServicesVariableOpc = 15501
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SimpleTypeDescription_DataTypeVersion                     OpcuaNodeIdServicesVariableOpc = 15509
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SimpleTypeDescription_DictionaryFragment                  OpcuaNodeIdServicesVariableOpc = 15519
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UABinaryFileDataType                                      OpcuaNodeIdServicesVariableOpc = 15521
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UABinaryFileDataType_DataTypeVersion                      OpcuaNodeIdServicesVariableOpc = 15522
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UABinaryFileDataType_DictionaryFragment                   OpcuaNodeIdServicesVariableOpc = 15523
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerConnectionTransportDataType                         OpcuaNodeIdServicesVariableOpc = 15524
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerConnectionTransportDataType_DataTypeVersion         OpcuaNodeIdServicesVariableOpc = 15525
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerConnectionTransportDataType_DictionaryFragment      OpcuaNodeIdServicesVariableOpc = 15526
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SimpleTypeDescription                                        OpcuaNodeIdServicesVariableOpc = 15585
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SimpleTypeDescription_DataTypeVersion                        OpcuaNodeIdServicesVariableOpc = 15586
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SimpleTypeDescription_DictionaryFragment                     OpcuaNodeIdServicesVariableOpc = 15587
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UABinaryFileDataType                                         OpcuaNodeIdServicesVariableOpc = 15588
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureDescription                                         OpcuaNodeIdServicesVariableOpc = 15591
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureDescription_DataTypeVersion                         OpcuaNodeIdServicesVariableOpc = 15592
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureDescription_DictionaryFragment                      OpcuaNodeIdServicesVariableOpc = 15593
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumDescription                                              OpcuaNodeIdServicesVariableOpc = 15594
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumDescription_DataTypeVersion                              OpcuaNodeIdServicesVariableOpc = 15595
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumDescription_DictionaryFragment                           OpcuaNodeIdServicesVariableOpc = 15596
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureDescription                                      OpcuaNodeIdServicesVariableOpc = 15599
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureDescription_DataTypeVersion                      OpcuaNodeIdServicesVariableOpc = 15600
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureDescription_DictionaryFragment                   OpcuaNodeIdServicesVariableOpc = 15601
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumDescription                                           OpcuaNodeIdServicesVariableOpc = 15602
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumDescription_DataTypeVersion                           OpcuaNodeIdServicesVariableOpc = 15603
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumDescription_DictionaryFragment                        OpcuaNodeIdServicesVariableOpc = 15604
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UABinaryFileDataType_DataTypeVersion                         OpcuaNodeIdServicesVariableOpc = 15610
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UABinaryFileDataType_DictionaryFragment                      OpcuaNodeIdServicesVariableOpc = 15619
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerConnectionTransportDataType                            OpcuaNodeIdServicesVariableOpc = 15640
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerConnectionTransportDataType_DataTypeVersion            OpcuaNodeIdServicesVariableOpc = 15666
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerConnectionTransportDataType_DictionaryFragment         OpcuaNodeIdServicesVariableOpc = 15690
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_IdentityMappingRuleType                                      OpcuaNodeIdServicesVariableOpc = 15730
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_IdentityMappingRuleType_DataTypeVersion                      OpcuaNodeIdServicesVariableOpc = 15731
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_IdentityMappingRuleType_DictionaryFragment                   OpcuaNodeIdServicesVariableOpc = 15732
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointType                                              OpcuaNodeIdServicesVariableOpc = 15734
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointType_DataTypeVersion                              OpcuaNodeIdServicesVariableOpc = 15735
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointType_DictionaryFragment                           OpcuaNodeIdServicesVariableOpc = 15737
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_IdentityMappingRuleType                                   OpcuaNodeIdServicesVariableOpc = 15738
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_IdentityMappingRuleType_DataTypeVersion                   OpcuaNodeIdServicesVariableOpc = 15739
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_IdentityMappingRuleType_DictionaryFragment                OpcuaNodeIdServicesVariableOpc = 15740
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeSchemaHeader                                      OpcuaNodeIdServicesVariableOpc = 15741
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeSchemaHeader_DataTypeVersion                      OpcuaNodeIdServicesVariableOpc = 15742
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeSchemaHeader_DictionaryFragment                   OpcuaNodeIdServicesVariableOpc = 15743
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetDataType                                  OpcuaNodeIdServicesVariableOpc = 15766
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetDataType_DataTypeVersion                  OpcuaNodeIdServicesVariableOpc = 15767
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetDataType_DictionaryFragment               OpcuaNodeIdServicesVariableOpc = 15768
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetSourceDataType                            OpcuaNodeIdServicesVariableOpc = 15769
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetSourceDataType_DataTypeVersion            OpcuaNodeIdServicesVariableOpc = 15770
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetSourceDataType_DictionaryFragment         OpcuaNodeIdServicesVariableOpc = 15771
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataItemsDataType                                OpcuaNodeIdServicesVariableOpc = 15772
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataItemsDataType_DataTypeVersion                OpcuaNodeIdServicesVariableOpc = 15773
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataItemsDataType_DictionaryFragment             OpcuaNodeIdServicesVariableOpc = 15774
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedEventsDataType                                   OpcuaNodeIdServicesVariableOpc = 15775
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedEventsDataType_DataTypeVersion                   OpcuaNodeIdServicesVariableOpc = 15776
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedEventsDataType_DictionaryFragment                OpcuaNodeIdServicesVariableOpc = 15777
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterDataType                                     OpcuaNodeIdServicesVariableOpc = 15778
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterDataType_DataTypeVersion                     OpcuaNodeIdServicesVariableOpc = 15779
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterDataType_DictionaryFragment                  OpcuaNodeIdServicesVariableOpc = 15780
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterTransportDataType                            OpcuaNodeIdServicesVariableOpc = 15781
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterTransportDataType_DataTypeVersion            OpcuaNodeIdServicesVariableOpc = 15782
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterTransportDataType_DictionaryFragment         OpcuaNodeIdServicesVariableOpc = 15783
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterMessageDataType                              OpcuaNodeIdServicesVariableOpc = 15784
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterMessageDataType_DataTypeVersion              OpcuaNodeIdServicesVariableOpc = 15785
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterMessageDataType_DictionaryFragment           OpcuaNodeIdServicesVariableOpc = 15786
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubGroupDataType                                       OpcuaNodeIdServicesVariableOpc = 15787
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubGroupDataType_DataTypeVersion                       OpcuaNodeIdServicesVariableOpc = 15788
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubGroupDataType_DictionaryFragment                    OpcuaNodeIdServicesVariableOpc = 15789
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupTransportDataType                              OpcuaNodeIdServicesVariableOpc = 15793
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupTransportDataType_DataTypeVersion              OpcuaNodeIdServicesVariableOpc = 15852
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupTransportDataType_DictionaryFragment           OpcuaNodeIdServicesVariableOpc = 15853
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupMessageDataType                                OpcuaNodeIdServicesVariableOpc = 15854
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupMessageDataType_DataTypeVersion                OpcuaNodeIdServicesVariableOpc = 15855
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupMessageDataType_DictionaryFragment             OpcuaNodeIdServicesVariableOpc = 15856
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConnectionDataType                                  OpcuaNodeIdServicesVariableOpc = 15857
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConnectionDataType_DataTypeVersion                  OpcuaNodeIdServicesVariableOpc = 15858
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConnectionDataType_DictionaryFragment               OpcuaNodeIdServicesVariableOpc = 15859
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ConnectionTransportDataType                               OpcuaNodeIdServicesVariableOpc = 15860
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ConnectionTransportDataType_DataTypeVersion               OpcuaNodeIdServicesVariableOpc = 15861
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ConnectionTransportDataType_DictionaryFragment            OpcuaNodeIdServicesVariableOpc = 15862
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupTransportDataType                              OpcuaNodeIdServicesVariableOpc = 15866
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupTransportDataType_DataTypeVersion              OpcuaNodeIdServicesVariableOpc = 15867
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupTransportDataType_DictionaryFragment           OpcuaNodeIdServicesVariableOpc = 15868
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupMessageDataType                                OpcuaNodeIdServicesVariableOpc = 15869
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupMessageDataType_DataTypeVersion                OpcuaNodeIdServicesVariableOpc = 15870
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupMessageDataType_DictionaryFragment             OpcuaNodeIdServicesVariableOpc = 15871
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderDataType                                     OpcuaNodeIdServicesVariableOpc = 15872
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderDataType_DataTypeVersion                     OpcuaNodeIdServicesVariableOpc = 15873
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderDataType_DictionaryFragment                  OpcuaNodeIdServicesVariableOpc = 15876
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderTransportDataType                            OpcuaNodeIdServicesVariableOpc = 15877
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderTransportDataType_DataTypeVersion            OpcuaNodeIdServicesVariableOpc = 15878
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderTransportDataType_DictionaryFragment         OpcuaNodeIdServicesVariableOpc = 15879
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderMessageDataType                              OpcuaNodeIdServicesVariableOpc = 15880
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderMessageDataType_DataTypeVersion              OpcuaNodeIdServicesVariableOpc = 15881
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderMessageDataType_DictionaryFragment           OpcuaNodeIdServicesVariableOpc = 15882
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscribedDataSetDataType                                 OpcuaNodeIdServicesVariableOpc = 15883
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscribedDataSetDataType_DataTypeVersion                 OpcuaNodeIdServicesVariableOpc = 15884
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscribedDataSetDataType_DictionaryFragment              OpcuaNodeIdServicesVariableOpc = 15885
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TargetVariablesDataType                                   OpcuaNodeIdServicesVariableOpc = 15886
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TargetVariablesDataType_DataTypeVersion                   OpcuaNodeIdServicesVariableOpc = 15887
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TargetVariablesDataType_DictionaryFragment                OpcuaNodeIdServicesVariableOpc = 15888
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscribedDataSetMirrorDataType                           OpcuaNodeIdServicesVariableOpc = 15889
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscribedDataSetMirrorDataType_DataTypeVersion           OpcuaNodeIdServicesVariableOpc = 15890
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscribedDataSetMirrorDataType_DictionaryFragment        OpcuaNodeIdServicesVariableOpc = 15891
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpWriterGroupMessageDataType                            OpcuaNodeIdServicesVariableOpc = 15895
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpWriterGroupMessageDataType_DataTypeVersion            OpcuaNodeIdServicesVariableOpc = 15896
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpWriterGroupMessageDataType_DictionaryFragment         OpcuaNodeIdServicesVariableOpc = 15897
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpDataSetWriterMessageDataType                          OpcuaNodeIdServicesVariableOpc = 15898
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpDataSetWriterMessageDataType_DataTypeVersion          OpcuaNodeIdServicesVariableOpc = 15899
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpDataSetWriterMessageDataType_DictionaryFragment       OpcuaNodeIdServicesVariableOpc = 15900
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpDataSetReaderMessageDataType                          OpcuaNodeIdServicesVariableOpc = 15919
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpDataSetReaderMessageDataType_DataTypeVersion          OpcuaNodeIdServicesVariableOpc = 15920
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpDataSetReaderMessageDataType_DictionaryFragment       OpcuaNodeIdServicesVariableOpc = 15921
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonWriterGroupMessageDataType                            OpcuaNodeIdServicesVariableOpc = 15922
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonWriterGroupMessageDataType_DataTypeVersion            OpcuaNodeIdServicesVariableOpc = 15923
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonWriterGroupMessageDataType_DictionaryFragment         OpcuaNodeIdServicesVariableOpc = 15924
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonDataSetWriterMessageDataType                          OpcuaNodeIdServicesVariableOpc = 15925
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonDataSetWriterMessageDataType_DataTypeVersion          OpcuaNodeIdServicesVariableOpc = 15929
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonDataSetWriterMessageDataType_DictionaryFragment       OpcuaNodeIdServicesVariableOpc = 15930
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonDataSetReaderMessageDataType                          OpcuaNodeIdServicesVariableOpc = 15931
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonDataSetReaderMessageDataType_DataTypeVersion          OpcuaNodeIdServicesVariableOpc = 15935
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonDataSetReaderMessageDataType_DictionaryFragment       OpcuaNodeIdServicesVariableOpc = 15936
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerWriterGroupTransportDataType                        OpcuaNodeIdServicesVariableOpc = 15940
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerWriterGroupTransportDataType_DataTypeVersion        OpcuaNodeIdServicesVariableOpc = 15941
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerWriterGroupTransportDataType_DictionaryFragment     OpcuaNodeIdServicesVariableOpc = 15942
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerDataSetWriterTransportDataType                      OpcuaNodeIdServicesVariableOpc = 15943
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerDataSetWriterTransportDataType_DataTypeVersion      OpcuaNodeIdServicesVariableOpc = 15944
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerDataSetWriterTransportDataType_DictionaryFragment   OpcuaNodeIdServicesVariableOpc = 15945
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerDataSetReaderTransportDataType                      OpcuaNodeIdServicesVariableOpc = 15946
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerDataSetReaderTransportDataType_DataTypeVersion      OpcuaNodeIdServicesVariableOpc = 15947
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerDataSetReaderTransportDataType_DictionaryFragment   OpcuaNodeIdServicesVariableOpc = 15948
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointType                                                 OpcuaNodeIdServicesVariableOpc = 16024
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointType_DataTypeVersion                                 OpcuaNodeIdServicesVariableOpc = 16025
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointType_DictionaryFragment                              OpcuaNodeIdServicesVariableOpc = 16026
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeSchemaHeader                                         OpcuaNodeIdServicesVariableOpc = 16027
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeSchemaHeader_DataTypeVersion                         OpcuaNodeIdServicesVariableOpc = 16028
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeSchemaHeader_DictionaryFragment                      OpcuaNodeIdServicesVariableOpc = 16029
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetDataType                                     OpcuaNodeIdServicesVariableOpc = 16030
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetDataType_DataTypeVersion                     OpcuaNodeIdServicesVariableOpc = 16031
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetDataType_DictionaryFragment                  OpcuaNodeIdServicesVariableOpc = 16032
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetSourceDataType                               OpcuaNodeIdServicesVariableOpc = 16033
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetSourceDataType_DataTypeVersion               OpcuaNodeIdServicesVariableOpc = 16034
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetSourceDataType_DictionaryFragment            OpcuaNodeIdServicesVariableOpc = 16035
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataItemsDataType                                   OpcuaNodeIdServicesVariableOpc = 16037
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataItemsDataType_DataTypeVersion                   OpcuaNodeIdServicesVariableOpc = 16038
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataItemsDataType_DictionaryFragment                OpcuaNodeIdServicesVariableOpc = 16039
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedEventsDataType                                      OpcuaNodeIdServicesVariableOpc = 16040
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedEventsDataType_DataTypeVersion                      OpcuaNodeIdServicesVariableOpc = 16045
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedEventsDataType_DictionaryFragment                   OpcuaNodeIdServicesVariableOpc = 16046
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterDataType                                        OpcuaNodeIdServicesVariableOpc = 16047
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterDataType_DataTypeVersion                        OpcuaNodeIdServicesVariableOpc = 16048
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterDataType_DictionaryFragment                     OpcuaNodeIdServicesVariableOpc = 16049
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterTransportDataType                               OpcuaNodeIdServicesVariableOpc = 16050
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterTransportDataType_DataTypeVersion               OpcuaNodeIdServicesVariableOpc = 16051
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterTransportDataType_DictionaryFragment            OpcuaNodeIdServicesVariableOpc = 16052
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterMessageDataType                                 OpcuaNodeIdServicesVariableOpc = 16053
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterMessageDataType_DataTypeVersion                 OpcuaNodeIdServicesVariableOpc = 16054
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterMessageDataType_DictionaryFragment              OpcuaNodeIdServicesVariableOpc = 16055
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubGroupDataType                                          OpcuaNodeIdServicesVariableOpc = 16056
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubGroupDataType_DataTypeVersion                          OpcuaNodeIdServicesVariableOpc = 16057
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubGroupDataType_DictionaryFragment                       OpcuaNodeIdServicesVariableOpc = 16058
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupTransportDataType                                 OpcuaNodeIdServicesVariableOpc = 16062
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupTransportDataType_DataTypeVersion                 OpcuaNodeIdServicesVariableOpc = 16063
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupTransportDataType_DictionaryFragment              OpcuaNodeIdServicesVariableOpc = 16064
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupMessageDataType                                   OpcuaNodeIdServicesVariableOpc = 16065
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupMessageDataType_DataTypeVersion                   OpcuaNodeIdServicesVariableOpc = 16066
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupMessageDataType_DictionaryFragment                OpcuaNodeIdServicesVariableOpc = 16067
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConnectionDataType                                     OpcuaNodeIdServicesVariableOpc = 16068
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConnectionDataType_DataTypeVersion                     OpcuaNodeIdServicesVariableOpc = 16069
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConnectionDataType_DictionaryFragment                  OpcuaNodeIdServicesVariableOpc = 16070
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ConnectionTransportDataType                                  OpcuaNodeIdServicesVariableOpc = 16071
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ConnectionTransportDataType_DataTypeVersion                  OpcuaNodeIdServicesVariableOpc = 16072
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ConnectionTransportDataType_DictionaryFragment               OpcuaNodeIdServicesVariableOpc = 16073
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupTransportDataType                                 OpcuaNodeIdServicesVariableOpc = 16077
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupTransportDataType_DataTypeVersion                 OpcuaNodeIdServicesVariableOpc = 16078
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupTransportDataType_DictionaryFragment              OpcuaNodeIdServicesVariableOpc = 16079
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupMessageDataType                                   OpcuaNodeIdServicesVariableOpc = 16080
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupMessageDataType_DataTypeVersion                   OpcuaNodeIdServicesVariableOpc = 16081
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupMessageDataType_DictionaryFragment                OpcuaNodeIdServicesVariableOpc = 16082
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderDataType                                        OpcuaNodeIdServicesVariableOpc = 16083
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderDataType_DataTypeVersion                        OpcuaNodeIdServicesVariableOpc = 16084
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderDataType_DictionaryFragment                     OpcuaNodeIdServicesVariableOpc = 16085
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderTransportDataType                               OpcuaNodeIdServicesVariableOpc = 16086
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderTransportDataType_DataTypeVersion               OpcuaNodeIdServicesVariableOpc = 16087
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderTransportDataType_DictionaryFragment            OpcuaNodeIdServicesVariableOpc = 16088
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderMessageDataType                                 OpcuaNodeIdServicesVariableOpc = 16089
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderMessageDataType_DataTypeVersion                 OpcuaNodeIdServicesVariableOpc = 16090
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderMessageDataType_DictionaryFragment              OpcuaNodeIdServicesVariableOpc = 16091
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscribedDataSetDataType                                    OpcuaNodeIdServicesVariableOpc = 16092
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscribedDataSetDataType_DataTypeVersion                    OpcuaNodeIdServicesVariableOpc = 16093
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscribedDataSetDataType_DictionaryFragment                 OpcuaNodeIdServicesVariableOpc = 16094
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TargetVariablesDataType                                      OpcuaNodeIdServicesVariableOpc = 16095
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TargetVariablesDataType_DataTypeVersion                      OpcuaNodeIdServicesVariableOpc = 16096
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TargetVariablesDataType_DictionaryFragment                   OpcuaNodeIdServicesVariableOpc = 16097
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscribedDataSetMirrorDataType                              OpcuaNodeIdServicesVariableOpc = 16098
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscribedDataSetMirrorDataType_DataTypeVersion              OpcuaNodeIdServicesVariableOpc = 16099
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscribedDataSetMirrorDataType_DictionaryFragment           OpcuaNodeIdServicesVariableOpc = 16100
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpWriterGroupMessageDataType                               OpcuaNodeIdServicesVariableOpc = 16104
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpWriterGroupMessageDataType_DataTypeVersion               OpcuaNodeIdServicesVariableOpc = 16105
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpWriterGroupMessageDataType_DictionaryFragment            OpcuaNodeIdServicesVariableOpc = 16106
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpDataSetWriterMessageDataType                             OpcuaNodeIdServicesVariableOpc = 16107
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpDataSetWriterMessageDataType_DataTypeVersion             OpcuaNodeIdServicesVariableOpc = 16108
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpDataSetWriterMessageDataType_DictionaryFragment          OpcuaNodeIdServicesVariableOpc = 16109
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpDataSetReaderMessageDataType                             OpcuaNodeIdServicesVariableOpc = 16110
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpDataSetReaderMessageDataType_DataTypeVersion             OpcuaNodeIdServicesVariableOpc = 16111
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpDataSetReaderMessageDataType_DictionaryFragment          OpcuaNodeIdServicesVariableOpc = 16112
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonWriterGroupMessageDataType                               OpcuaNodeIdServicesVariableOpc = 16113
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonWriterGroupMessageDataType_DataTypeVersion               OpcuaNodeIdServicesVariableOpc = 16114
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonWriterGroupMessageDataType_DictionaryFragment            OpcuaNodeIdServicesVariableOpc = 16115
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonDataSetWriterMessageDataType                             OpcuaNodeIdServicesVariableOpc = 16116
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonDataSetWriterMessageDataType_DataTypeVersion             OpcuaNodeIdServicesVariableOpc = 16117
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonDataSetWriterMessageDataType_DictionaryFragment          OpcuaNodeIdServicesVariableOpc = 16118
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonDataSetReaderMessageDataType                             OpcuaNodeIdServicesVariableOpc = 16119
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonDataSetReaderMessageDataType_DataTypeVersion             OpcuaNodeIdServicesVariableOpc = 16120
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonDataSetReaderMessageDataType_DictionaryFragment          OpcuaNodeIdServicesVariableOpc = 16121
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerWriterGroupTransportDataType                           OpcuaNodeIdServicesVariableOpc = 16125
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RolePermissionType                                           OpcuaNodeIdServicesVariableOpc = 16127
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RolePermissionType_DataTypeVersion                           OpcuaNodeIdServicesVariableOpc = 16128
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RolePermissionType_DictionaryFragment                        OpcuaNodeIdServicesVariableOpc = 16129
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerWriterGroupTransportDataType_DataTypeVersion           OpcuaNodeIdServicesVariableOpc = 16130
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RolePermissionType                                        OpcuaNodeIdServicesVariableOpc = 16131
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RolePermissionType_DataTypeVersion                        OpcuaNodeIdServicesVariableOpc = 16132
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RolePermissionType_DictionaryFragment                     OpcuaNodeIdServicesVariableOpc = 16133
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerWriterGroupTransportDataType_DictionaryFragment        OpcuaNodeIdServicesVariableOpc = 16143
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerDataSetWriterTransportDataType                         OpcuaNodeIdServicesVariableOpc = 16144
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerDataSetWriterTransportDataType_DataTypeVersion         OpcuaNodeIdServicesVariableOpc = 16145
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerDataSetWriterTransportDataType_DictionaryFragment      OpcuaNodeIdServicesVariableOpc = 16146
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerDataSetReaderTransportDataType                         OpcuaNodeIdServicesVariableOpc = 16147
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerDataSetReaderTransportDataType_DataTypeVersion         OpcuaNodeIdServicesVariableOpc = 16148
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerDataSetReaderTransportDataType_DictionaryFragment      OpcuaNodeIdServicesVariableOpc = 16149
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramConnectionTransportDataType                       OpcuaNodeIdServicesVariableOpc = 17469
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramConnectionTransportDataType_DataTypeVersion       OpcuaNodeIdServicesVariableOpc = 17470
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramConnectionTransportDataType_DictionaryFragment    OpcuaNodeIdServicesVariableOpc = 17471
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramConnectionTransportDataType                          OpcuaNodeIdServicesVariableOpc = 17473
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramConnectionTransportDataType_DataTypeVersion          OpcuaNodeIdServicesVariableOpc = 17474
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramConnectionTransportDataType_DictionaryFragment       OpcuaNodeIdServicesVariableOpc = 17475
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AdditionalParametersType                                  OpcuaNodeIdServicesVariableOpc = 17538
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AdditionalParametersType_DataTypeVersion                  OpcuaNodeIdServicesVariableOpc = 17539
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AdditionalParametersType_DictionaryFragment               OpcuaNodeIdServicesVariableOpc = 17540
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AdditionalParametersType                                     OpcuaNodeIdServicesVariableOpc = 17542
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AdditionalParametersType_DataTypeVersion                     OpcuaNodeIdServicesVariableOpc = 17543
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AdditionalParametersType_DictionaryFragment                  OpcuaNodeIdServicesVariableOpc = 17544
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EphemeralKeyType                                          OpcuaNodeIdServicesVariableOpc = 17550
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EphemeralKeyType_DataTypeVersion                          OpcuaNodeIdServicesVariableOpc = 17551
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EphemeralKeyType_DictionaryFragment                       OpcuaNodeIdServicesVariableOpc = 17552
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EphemeralKeyType                                             OpcuaNodeIdServicesVariableOpc = 17554
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EphemeralKeyType_DataTypeVersion                             OpcuaNodeIdServicesVariableOpc = 17555
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EphemeralKeyType_DictionaryFragment                          OpcuaNodeIdServicesVariableOpc = 17556
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeDefinition                                           OpcuaNodeIdServicesVariableOpc = 18166
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeDefinition_DataTypeVersion                           OpcuaNodeIdServicesVariableOpc = 18167
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeDefinition_DictionaryFragment                        OpcuaNodeIdServicesVariableOpc = 18168
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureField                                               OpcuaNodeIdServicesVariableOpc = 18169
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureField_DataTypeVersion                               OpcuaNodeIdServicesVariableOpc = 18170
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureField_DictionaryFragment                            OpcuaNodeIdServicesVariableOpc = 18171
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureDefinition                                          OpcuaNodeIdServicesVariableOpc = 18172
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureDefinition_DataTypeVersion                          OpcuaNodeIdServicesVariableOpc = 18173
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureDefinition_DictionaryFragment                       OpcuaNodeIdServicesVariableOpc = 18174
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumDefinition                                               OpcuaNodeIdServicesVariableOpc = 18175
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumDefinition_DataTypeVersion                               OpcuaNodeIdServicesVariableOpc = 18176
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumDefinition_DictionaryFragment                            OpcuaNodeIdServicesVariableOpc = 18177
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeDefinition                                        OpcuaNodeIdServicesVariableOpc = 18178
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeDefinition_DataTypeVersion                        OpcuaNodeIdServicesVariableOpc = 18179
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeDefinition_DictionaryFragment                     OpcuaNodeIdServicesVariableOpc = 18180
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureField                                            OpcuaNodeIdServicesVariableOpc = 18181
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureField_DataTypeVersion                            OpcuaNodeIdServicesVariableOpc = 18182
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureField_DictionaryFragment                         OpcuaNodeIdServicesVariableOpc = 18183
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureDefinition                                       OpcuaNodeIdServicesVariableOpc = 18184
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureDefinition_DataTypeVersion                       OpcuaNodeIdServicesVariableOpc = 18185
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureDefinition_DictionaryFragment                    OpcuaNodeIdServicesVariableOpc = 18186
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumDefinition                                            OpcuaNodeIdServicesVariableOpc = 18187
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumDefinition_DataTypeVersion                            OpcuaNodeIdServicesVariableOpc = 18188
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumDefinition_DictionaryFragment                         OpcuaNodeIdServicesVariableOpc = 18189
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RationalNumber                                            OpcuaNodeIdServicesVariableOpc = 18824
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RationalNumber_DataTypeVersion                            OpcuaNodeIdServicesVariableOpc = 18825
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RationalNumber_DictionaryFragment                         OpcuaNodeIdServicesVariableOpc = 18826
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Vector                                                    OpcuaNodeIdServicesVariableOpc = 18827
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Vector_DataTypeVersion                                    OpcuaNodeIdServicesVariableOpc = 18828
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Vector_DictionaryFragment                                 OpcuaNodeIdServicesVariableOpc = 18829
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDVector                                              OpcuaNodeIdServicesVariableOpc = 18830
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDVector_DataTypeVersion                              OpcuaNodeIdServicesVariableOpc = 18831
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDVector_DictionaryFragment                           OpcuaNodeIdServicesVariableOpc = 18832
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_CartesianCoordinates                                      OpcuaNodeIdServicesVariableOpc = 18833
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_CartesianCoordinates_DataTypeVersion                      OpcuaNodeIdServicesVariableOpc = 18834
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_CartesianCoordinates_DictionaryFragment                   OpcuaNodeIdServicesVariableOpc = 18835
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDCartesianCoordinates                                OpcuaNodeIdServicesVariableOpc = 18836
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDCartesianCoordinates_DataTypeVersion                OpcuaNodeIdServicesVariableOpc = 18837
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDCartesianCoordinates_DictionaryFragment             OpcuaNodeIdServicesVariableOpc = 18838
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Orientation                                               OpcuaNodeIdServicesVariableOpc = 18839
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Orientation_DataTypeVersion                               OpcuaNodeIdServicesVariableOpc = 18840
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Orientation_DictionaryFragment                            OpcuaNodeIdServicesVariableOpc = 18841
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDOrientation                                         OpcuaNodeIdServicesVariableOpc = 18842
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDOrientation_DataTypeVersion                         OpcuaNodeIdServicesVariableOpc = 18843
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDOrientation_DictionaryFragment                      OpcuaNodeIdServicesVariableOpc = 18844
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Frame                                                     OpcuaNodeIdServicesVariableOpc = 18845
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Frame_DataTypeVersion                                     OpcuaNodeIdServicesVariableOpc = 18846
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Frame_DictionaryFragment                                  OpcuaNodeIdServicesVariableOpc = 18847
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDFrame                                               OpcuaNodeIdServicesVariableOpc = 18848
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDFrame_DataTypeVersion                               OpcuaNodeIdServicesVariableOpc = 18849
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDFrame_DictionaryFragment                            OpcuaNodeIdServicesVariableOpc = 18850
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RationalNumber                                               OpcuaNodeIdServicesVariableOpc = 18860
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RationalNumber_DataTypeVersion                               OpcuaNodeIdServicesVariableOpc = 18861
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RationalNumber_DictionaryFragment                            OpcuaNodeIdServicesVariableOpc = 18862
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Vector                                                       OpcuaNodeIdServicesVariableOpc = 18863
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Vector_DataTypeVersion                                       OpcuaNodeIdServicesVariableOpc = 18864
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Vector_DictionaryFragment                                    OpcuaNodeIdServicesVariableOpc = 18865
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDVector                                                 OpcuaNodeIdServicesVariableOpc = 18866
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDVector_DataTypeVersion                                 OpcuaNodeIdServicesVariableOpc = 18867
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDVector_DictionaryFragment                              OpcuaNodeIdServicesVariableOpc = 18868
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_CartesianCoordinates                                         OpcuaNodeIdServicesVariableOpc = 18869
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_CartesianCoordinates_DataTypeVersion                         OpcuaNodeIdServicesVariableOpc = 18870
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_CartesianCoordinates_DictionaryFragment                      OpcuaNodeIdServicesVariableOpc = 19048
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDCartesianCoordinates                                   OpcuaNodeIdServicesVariableOpc = 19049
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDCartesianCoordinates_DataTypeVersion                   OpcuaNodeIdServicesVariableOpc = 19050
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDCartesianCoordinates_DictionaryFragment                OpcuaNodeIdServicesVariableOpc = 19051
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Orientation                                                  OpcuaNodeIdServicesVariableOpc = 19052
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Orientation_DataTypeVersion                                  OpcuaNodeIdServicesVariableOpc = 19053
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Orientation_DictionaryFragment                               OpcuaNodeIdServicesVariableOpc = 19054
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDOrientation                                            OpcuaNodeIdServicesVariableOpc = 19055
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDOrientation_DataTypeVersion                            OpcuaNodeIdServicesVariableOpc = 19056
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDOrientation_DictionaryFragment                         OpcuaNodeIdServicesVariableOpc = 19057
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Frame                                                        OpcuaNodeIdServicesVariableOpc = 19058
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Frame_DataTypeVersion                                        OpcuaNodeIdServicesVariableOpc = 19059
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Frame_DictionaryFragment                                     OpcuaNodeIdServicesVariableOpc = 19060
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDFrame                                                  OpcuaNodeIdServicesVariableOpc = 19061
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDFrame_DataTypeVersion                                  OpcuaNodeIdServicesVariableOpc = 19062
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDFrame_DictionaryFragment                               OpcuaNodeIdServicesVariableOpc = 19063
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FieldTargetDataType                                       OpcuaNodeIdServicesVariableOpc = 21002
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupDataType                                       OpcuaNodeIdServicesVariableOpc = 21156
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupDataType_DataTypeVersion                       OpcuaNodeIdServicesVariableOpc = 21157
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupDataType_DictionaryFragment                    OpcuaNodeIdServicesVariableOpc = 21158
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkAddressDataType                                    OpcuaNodeIdServicesVariableOpc = 21159
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkAddressDataType_DataTypeVersion                    OpcuaNodeIdServicesVariableOpc = 21160
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkAddressDataType_DictionaryFragment                 OpcuaNodeIdServicesVariableOpc = 21161
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkAddressUrlDataType                                 OpcuaNodeIdServicesVariableOpc = 21162
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkAddressUrlDataType_DataTypeVersion                 OpcuaNodeIdServicesVariableOpc = 21163
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkAddressUrlDataType_DictionaryFragment              OpcuaNodeIdServicesVariableOpc = 21164
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupDataType                                       OpcuaNodeIdServicesVariableOpc = 21165
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupDataType_DataTypeVersion                       OpcuaNodeIdServicesVariableOpc = 21166
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupDataType_DictionaryFragment                    OpcuaNodeIdServicesVariableOpc = 21167
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationDataType                               OpcuaNodeIdServicesVariableOpc = 21168
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationDataType_DataTypeVersion               OpcuaNodeIdServicesVariableOpc = 21169
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationDataType_DictionaryFragment            OpcuaNodeIdServicesVariableOpc = 21170
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramWriterGroupTransportDataType                      OpcuaNodeIdServicesVariableOpc = 21171
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramWriterGroupTransportDataType_DataTypeVersion      OpcuaNodeIdServicesVariableOpc = 21172
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramWriterGroupTransportDataType_DictionaryFragment   OpcuaNodeIdServicesVariableOpc = 21173
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupDataType                                          OpcuaNodeIdServicesVariableOpc = 21180
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupDataType_DataTypeVersion                          OpcuaNodeIdServicesVariableOpc = 21181
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupDataType_DictionaryFragment                       OpcuaNodeIdServicesVariableOpc = 21182
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkAddressDataType                                       OpcuaNodeIdServicesVariableOpc = 21183
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkAddressDataType_DataTypeVersion                       OpcuaNodeIdServicesVariableOpc = 21184
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkAddressDataType_DictionaryFragment                    OpcuaNodeIdServicesVariableOpc = 21185
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkAddressUrlDataType                                    OpcuaNodeIdServicesVariableOpc = 21186
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkAddressUrlDataType_DataTypeVersion                    OpcuaNodeIdServicesVariableOpc = 21187
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkAddressUrlDataType_DictionaryFragment                 OpcuaNodeIdServicesVariableOpc = 21188
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupDataType                                          OpcuaNodeIdServicesVariableOpc = 21189
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupDataType_DataTypeVersion                          OpcuaNodeIdServicesVariableOpc = 21190
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupDataType_DictionaryFragment                       OpcuaNodeIdServicesVariableOpc = 21191
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationDataType                                  OpcuaNodeIdServicesVariableOpc = 21192
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationDataType_DataTypeVersion                  OpcuaNodeIdServicesVariableOpc = 21193
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationDataType_DictionaryFragment               OpcuaNodeIdServicesVariableOpc = 21194
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramWriterGroupTransportDataType                         OpcuaNodeIdServicesVariableOpc = 21195
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramWriterGroupTransportDataType_DataTypeVersion         OpcuaNodeIdServicesVariableOpc = 21196
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramWriterGroupTransportDataType_DictionaryFragment      OpcuaNodeIdServicesVariableOpc = 21197
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AliasNameDataType                                         OpcuaNodeIdServicesVariableOpc = 23502
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AliasNameDataType_DataTypeVersion                         OpcuaNodeIdServicesVariableOpc = 23503
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AliasNameDataType_DictionaryFragment                      OpcuaNodeIdServicesVariableOpc = 23504
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AliasNameDataType                                            OpcuaNodeIdServicesVariableOpc = 23508
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AliasNameDataType_DataTypeVersion                            OpcuaNodeIdServicesVariableOpc = 23509
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AliasNameDataType_DictionaryFragment                         OpcuaNodeIdServicesVariableOpc = 23510
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_CurrencyUnitType                                          OpcuaNodeIdServicesVariableOpc = 23514
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_CurrencyUnitType_DataTypeVersion                          OpcuaNodeIdServicesVariableOpc = 23515
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_CurrencyUnitType_DictionaryFragment                       OpcuaNodeIdServicesVariableOpc = 23516
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_CurrencyUnitType                                             OpcuaNodeIdServicesVariableOpc = 23522
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_CurrencyUnitType_DataTypeVersion                             OpcuaNodeIdServicesVariableOpc = 23523
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_CurrencyUnitType_DictionaryFragment                          OpcuaNodeIdServicesVariableOpc = 23524
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StandaloneSubscribedDataSetRefDataType                    OpcuaNodeIdServicesVariableOpc = 23870
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StandaloneSubscribedDataSetRefDataType_DataTypeVersion    OpcuaNodeIdServicesVariableOpc = 23871
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StandaloneSubscribedDataSetRefDataType_DictionaryFragment OpcuaNodeIdServicesVariableOpc = 23872
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StandaloneSubscribedDataSetDataType                       OpcuaNodeIdServicesVariableOpc = 23873
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StandaloneSubscribedDataSetDataType_DataTypeVersion       OpcuaNodeIdServicesVariableOpc = 23874
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StandaloneSubscribedDataSetDataType_DictionaryFragment    OpcuaNodeIdServicesVariableOpc = 23875
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SecurityGroupDataType                                     OpcuaNodeIdServicesVariableOpc = 23876
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SecurityGroupDataType_DataTypeVersion                     OpcuaNodeIdServicesVariableOpc = 23877
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SecurityGroupDataType_DictionaryFragment                  OpcuaNodeIdServicesVariableOpc = 23878
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfiguration2DataType                              OpcuaNodeIdServicesVariableOpc = 23879
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfiguration2DataType_DataTypeVersion              OpcuaNodeIdServicesVariableOpc = 23880
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfiguration2DataType_DictionaryFragment           OpcuaNodeIdServicesVariableOpc = 23881
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_QosDataType                                               OpcuaNodeIdServicesVariableOpc = 23882
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_QosDataType_DataTypeVersion                               OpcuaNodeIdServicesVariableOpc = 23883
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_QosDataType_DictionaryFragment                            OpcuaNodeIdServicesVariableOpc = 23884
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransmitQosDataType                                       OpcuaNodeIdServicesVariableOpc = 23885
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransmitQosDataType_DataTypeVersion                       OpcuaNodeIdServicesVariableOpc = 23886
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransmitQosDataType_DictionaryFragment                    OpcuaNodeIdServicesVariableOpc = 23887
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransmitQosPriorityDataType                               OpcuaNodeIdServicesVariableOpc = 23888
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransmitQosPriorityDataType_DataTypeVersion               OpcuaNodeIdServicesVariableOpc = 23889
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransmitQosPriorityDataType_DictionaryFragment            OpcuaNodeIdServicesVariableOpc = 23890
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReceiveQosDataType                                        OpcuaNodeIdServicesVariableOpc = 23897
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReceiveQosDataType_DataTypeVersion                        OpcuaNodeIdServicesVariableOpc = 23898
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReceiveQosDataType_DictionaryFragment                     OpcuaNodeIdServicesVariableOpc = 23899
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReceiveQosPriorityDataType                                OpcuaNodeIdServicesVariableOpc = 23900
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReceiveQosPriorityDataType_DataTypeVersion                OpcuaNodeIdServicesVariableOpc = 23901
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReceiveQosPriorityDataType_DictionaryFragment             OpcuaNodeIdServicesVariableOpc = 23902
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramConnectionTransport2DataType                      OpcuaNodeIdServicesVariableOpc = 23909
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramConnectionTransport2DataType_DataTypeVersion      OpcuaNodeIdServicesVariableOpc = 23910
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramConnectionTransport2DataType_DictionaryFragment   OpcuaNodeIdServicesVariableOpc = 23911
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramWriterGroupTransport2DataType                     OpcuaNodeIdServicesVariableOpc = 23912
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramWriterGroupTransport2DataType_DataTypeVersion     OpcuaNodeIdServicesVariableOpc = 23913
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramWriterGroupTransport2DataType_DictionaryFragment  OpcuaNodeIdServicesVariableOpc = 23914
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramDataSetReaderTransportDataType                    OpcuaNodeIdServicesVariableOpc = 23915
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramDataSetReaderTransportDataType_DataTypeVersion    OpcuaNodeIdServicesVariableOpc = 23916
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramDataSetReaderTransportDataType_DictionaryFragment OpcuaNodeIdServicesVariableOpc = 23917
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StandaloneSubscribedDataSetRefDataType                       OpcuaNodeIdServicesVariableOpc = 23938
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StandaloneSubscribedDataSetRefDataType_DataTypeVersion       OpcuaNodeIdServicesVariableOpc = 23939
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StandaloneSubscribedDataSetRefDataType_DictionaryFragment    OpcuaNodeIdServicesVariableOpc = 23940
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StandaloneSubscribedDataSetDataType                          OpcuaNodeIdServicesVariableOpc = 23941
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StandaloneSubscribedDataSetDataType_DataTypeVersion          OpcuaNodeIdServicesVariableOpc = 23942
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StandaloneSubscribedDataSetDataType_DictionaryFragment       OpcuaNodeIdServicesVariableOpc = 23943
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SecurityGroupDataType                                        OpcuaNodeIdServicesVariableOpc = 23944
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SecurityGroupDataType_DataTypeVersion                        OpcuaNodeIdServicesVariableOpc = 23945
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SecurityGroupDataType_DictionaryFragment                     OpcuaNodeIdServicesVariableOpc = 23946
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfiguration2DataType                                 OpcuaNodeIdServicesVariableOpc = 23947
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfiguration2DataType_DataTypeVersion                 OpcuaNodeIdServicesVariableOpc = 23948
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfiguration2DataType_DictionaryFragment              OpcuaNodeIdServicesVariableOpc = 23949
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_QosDataType                                                  OpcuaNodeIdServicesVariableOpc = 23950
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_QosDataType_DataTypeVersion                                  OpcuaNodeIdServicesVariableOpc = 23951
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_QosDataType_DictionaryFragment                               OpcuaNodeIdServicesVariableOpc = 23952
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransmitQosDataType                                          OpcuaNodeIdServicesVariableOpc = 23953
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransmitQosDataType_DataTypeVersion                          OpcuaNodeIdServicesVariableOpc = 23954
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransmitQosDataType_DictionaryFragment                       OpcuaNodeIdServicesVariableOpc = 23955
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransmitQosPriorityDataType                                  OpcuaNodeIdServicesVariableOpc = 23956
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransmitQosPriorityDataType_DataTypeVersion                  OpcuaNodeIdServicesVariableOpc = 23957
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransmitQosPriorityDataType_DictionaryFragment               OpcuaNodeIdServicesVariableOpc = 23958
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReceiveQosDataType                                           OpcuaNodeIdServicesVariableOpc = 23965
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReceiveQosDataType_DataTypeVersion                           OpcuaNodeIdServicesVariableOpc = 23966
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReceiveQosDataType_DictionaryFragment                        OpcuaNodeIdServicesVariableOpc = 23967
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReceiveQosPriorityDataType                                   OpcuaNodeIdServicesVariableOpc = 23968
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReceiveQosPriorityDataType_DataTypeVersion                   OpcuaNodeIdServicesVariableOpc = 23969
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReceiveQosPriorityDataType_DictionaryFragment                OpcuaNodeIdServicesVariableOpc = 23970
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramConnectionTransport2DataType                         OpcuaNodeIdServicesVariableOpc = 23977
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramConnectionTransport2DataType_DataTypeVersion         OpcuaNodeIdServicesVariableOpc = 23978
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramConnectionTransport2DataType_DictionaryFragment      OpcuaNodeIdServicesVariableOpc = 23979
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramWriterGroupTransport2DataType                        OpcuaNodeIdServicesVariableOpc = 23980
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramWriterGroupTransport2DataType_DataTypeVersion        OpcuaNodeIdServicesVariableOpc = 23981
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramWriterGroupTransport2DataType_DictionaryFragment     OpcuaNodeIdServicesVariableOpc = 23982
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramDataSetReaderTransportDataType                       OpcuaNodeIdServicesVariableOpc = 23983
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramDataSetReaderTransportDataType_DataTypeVersion       OpcuaNodeIdServicesVariableOpc = 23984
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramDataSetReaderTransportDataType_DictionaryFragment    OpcuaNodeIdServicesVariableOpc = 23985
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ProgramDiagnostic2DataType                                OpcuaNodeIdServicesVariableOpc = 24035
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ProgramDiagnostic2DataType_DataTypeVersion                OpcuaNodeIdServicesVariableOpc = 24036
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ProgramDiagnostic2DataType_DictionaryFragment             OpcuaNodeIdServicesVariableOpc = 24037
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ProgramDiagnostic2DataType                                   OpcuaNodeIdServicesVariableOpc = 24039
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ProgramDiagnostic2DataType_DataTypeVersion                   OpcuaNodeIdServicesVariableOpc = 24040
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ProgramDiagnostic2DataType_DictionaryFragment                OpcuaNodeIdServicesVariableOpc = 24041
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PortableQualifiedName                                     OpcuaNodeIdServicesVariableOpc = 24111
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PortableQualifiedName_DataTypeVersion                     OpcuaNodeIdServicesVariableOpc = 24112
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PortableQualifiedName_DictionaryFragment                  OpcuaNodeIdServicesVariableOpc = 24113
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PortableNodeId                                            OpcuaNodeIdServicesVariableOpc = 24114
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PortableNodeId_DataTypeVersion                            OpcuaNodeIdServicesVariableOpc = 24115
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PortableNodeId_DictionaryFragment                         OpcuaNodeIdServicesVariableOpc = 24116
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UnsignedRationalNumber                                    OpcuaNodeIdServicesVariableOpc = 24117
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UnsignedRationalNumber_DataTypeVersion                    OpcuaNodeIdServicesVariableOpc = 24118
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UnsignedRationalNumber_DictionaryFragment                 OpcuaNodeIdServicesVariableOpc = 24119
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PortableQualifiedName                                        OpcuaNodeIdServicesVariableOpc = 24123
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PortableQualifiedName_DataTypeVersion                        OpcuaNodeIdServicesVariableOpc = 24124
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PortableQualifiedName_DictionaryFragment                     OpcuaNodeIdServicesVariableOpc = 24125
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PortableNodeId                                               OpcuaNodeIdServicesVariableOpc = 24126
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PortableNodeId_DataTypeVersion                               OpcuaNodeIdServicesVariableOpc = 24127
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PortableNodeId_DictionaryFragment                            OpcuaNodeIdServicesVariableOpc = 24128
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UnsignedRationalNumber                                       OpcuaNodeIdServicesVariableOpc = 24129
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UnsignedRationalNumber_DataTypeVersion                       OpcuaNodeIdServicesVariableOpc = 24130
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UnsignedRationalNumber_DictionaryFragment                    OpcuaNodeIdServicesVariableOpc = 24131
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserManagementDataType                                    OpcuaNodeIdServicesVariableOpc = 24293
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserManagementDataType_DataTypeVersion                    OpcuaNodeIdServicesVariableOpc = 24294
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserManagementDataType_DictionaryFragment                 OpcuaNodeIdServicesVariableOpc = 24295
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserManagementDataType                                       OpcuaNodeIdServicesVariableOpc = 24297
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserManagementDataType_DataTypeVersion                       OpcuaNodeIdServicesVariableOpc = 24298
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserManagementDataType_DictionaryFragment                    OpcuaNodeIdServicesVariableOpc = 24299
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PriorityMappingEntryType                                  OpcuaNodeIdServicesVariableOpc = 25240
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PriorityMappingEntryType_DataTypeVersion                  OpcuaNodeIdServicesVariableOpc = 25241
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PriorityMappingEntryType_DictionaryFragment               OpcuaNodeIdServicesVariableOpc = 25242
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PriorityMappingEntryType                                     OpcuaNodeIdServicesVariableOpc = 25244
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PriorityMappingEntryType_DataTypeVersion                     OpcuaNodeIdServicesVariableOpc = 25245
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PriorityMappingEntryType_DictionaryFragment                  OpcuaNodeIdServicesVariableOpc = 25246
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetCustomSourceDataType                      OpcuaNodeIdServicesVariableOpc = 25533
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetCustomSourceDataType_DataTypeVersion      OpcuaNodeIdServicesVariableOpc = 25534
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetCustomSourceDataType_DictionaryFragment   OpcuaNodeIdServicesVariableOpc = 25535
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubKeyPushTargetDataType                               OpcuaNodeIdServicesVariableOpc = 25536
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubKeyPushTargetDataType_DataTypeVersion               OpcuaNodeIdServicesVariableOpc = 25537
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubKeyPushTargetDataType_DictionaryFragment            OpcuaNodeIdServicesVariableOpc = 25538
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationRefDataType                            OpcuaNodeIdServicesVariableOpc = 25539
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationRefDataType_DataTypeVersion            OpcuaNodeIdServicesVariableOpc = 25540
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationRefDataType_DictionaryFragment         OpcuaNodeIdServicesVariableOpc = 25541
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationValueDataType                          OpcuaNodeIdServicesVariableOpc = 25542
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationValueDataType_DataTypeVersion          OpcuaNodeIdServicesVariableOpc = 25543
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationValueDataType_DictionaryFragment       OpcuaNodeIdServicesVariableOpc = 25544
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetCustomSourceDataType                         OpcuaNodeIdServicesVariableOpc = 25549
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetCustomSourceDataType_DataTypeVersion         OpcuaNodeIdServicesVariableOpc = 25550
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetCustomSourceDataType_DictionaryFragment      OpcuaNodeIdServicesVariableOpc = 25551
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubKeyPushTargetDataType                                  OpcuaNodeIdServicesVariableOpc = 25552
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubKeyPushTargetDataType_DataTypeVersion                  OpcuaNodeIdServicesVariableOpc = 25553
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubKeyPushTargetDataType_DictionaryFragment               OpcuaNodeIdServicesVariableOpc = 25554
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationRefDataType                               OpcuaNodeIdServicesVariableOpc = 25555
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationRefDataType_DataTypeVersion               OpcuaNodeIdServicesVariableOpc = 25556
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationRefDataType_DictionaryFragment            OpcuaNodeIdServicesVariableOpc = 25557
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationValueDataType                             OpcuaNodeIdServicesVariableOpc = 25558
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationValueDataType_DataTypeVersion             OpcuaNodeIdServicesVariableOpc = 25559
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationValueDataType_DictionaryFragment          OpcuaNodeIdServicesVariableOpc = 25560
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransactionErrorType                                      OpcuaNodeIdServicesVariableOpc = 32383
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransactionErrorType_DataTypeVersion                      OpcuaNodeIdServicesVariableOpc = 32384
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransactionErrorType_DictionaryFragment                   OpcuaNodeIdServicesVariableOpc = 32385
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransactionErrorType                                         OpcuaNodeIdServicesVariableOpc = 32387
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransactionErrorType_DataTypeVersion                         OpcuaNodeIdServicesVariableOpc = 32388
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransactionErrorType_DictionaryFragment                      OpcuaNodeIdServicesVariableOpc = 32389
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BitFieldDefinition                                        OpcuaNodeIdServicesVariableOpc = 32423
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BitFieldDefinition_DataTypeVersion                        OpcuaNodeIdServicesVariableOpc = 32424
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BitFieldDefinition_DictionaryFragment                     OpcuaNodeIdServicesVariableOpc = 32425
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BitFieldDefinition                                           OpcuaNodeIdServicesVariableOpc = 32427
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BitFieldDefinition_DataTypeVersion                           OpcuaNodeIdServicesVariableOpc = 32428
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BitFieldDefinition_DictionaryFragment                        OpcuaNodeIdServicesVariableOpc = 32429
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AnnotationDataType                                        OpcuaNodeIdServicesVariableOpc = 32563
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AnnotationDataType_DataTypeVersion                        OpcuaNodeIdServicesVariableOpc = 32564
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AnnotationDataType_DictionaryFragment                     OpcuaNodeIdServicesVariableOpc = 32565
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_LinearConversionDataType                                  OpcuaNodeIdServicesVariableOpc = 32566
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_LinearConversionDataType_DataTypeVersion                  OpcuaNodeIdServicesVariableOpc = 32567
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_LinearConversionDataType_DictionaryFragment               OpcuaNodeIdServicesVariableOpc = 32568
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_QuantityDimension                                         OpcuaNodeIdServicesVariableOpc = 32569
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_QuantityDimension_DataTypeVersion                         OpcuaNodeIdServicesVariableOpc = 32570
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_QuantityDimension_DictionaryFragment                      OpcuaNodeIdServicesVariableOpc = 32571
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AnnotationDataType                                           OpcuaNodeIdServicesVariableOpc = 32575
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AnnotationDataType_DataTypeVersion                           OpcuaNodeIdServicesVariableOpc = 32576
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AnnotationDataType_DictionaryFragment                        OpcuaNodeIdServicesVariableOpc = 32577
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_LinearConversionDataType                                     OpcuaNodeIdServicesVariableOpc = 32578
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_LinearConversionDataType_DataTypeVersion                     OpcuaNodeIdServicesVariableOpc = 32579
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_LinearConversionDataType_DictionaryFragment                  OpcuaNodeIdServicesVariableOpc = 32580
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_QuantityDimension                                            OpcuaNodeIdServicesVariableOpc = 32581
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_QuantityDimension_DataTypeVersion                            OpcuaNodeIdServicesVariableOpc = 32582
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_QuantityDimension_DictionaryFragment                         OpcuaNodeIdServicesVariableOpc = 32583
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReferenceDescriptionDataType                              OpcuaNodeIdServicesVariableOpc = 32663
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReferenceDescriptionDataType_DataTypeVersion              OpcuaNodeIdServicesVariableOpc = 32664
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReferenceDescriptionDataType_DictionaryFragment           OpcuaNodeIdServicesVariableOpc = 32665
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReferenceListEntryDataType                                OpcuaNodeIdServicesVariableOpc = 32666
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReferenceListEntryDataType_DataTypeVersion                OpcuaNodeIdServicesVariableOpc = 32667
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReferenceListEntryDataType_DictionaryFragment             OpcuaNodeIdServicesVariableOpc = 32668
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReferenceDescriptionDataType                                 OpcuaNodeIdServicesVariableOpc = 32671
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReferenceDescriptionDataType_DataTypeVersion                 OpcuaNodeIdServicesVariableOpc = 32672
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReferenceDescriptionDataType_DictionaryFragment              OpcuaNodeIdServicesVariableOpc = 32673
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReferenceListEntryDataType                                   OpcuaNodeIdServicesVariableOpc = 32674
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReferenceListEntryDataType_DataTypeVersion                   OpcuaNodeIdServicesVariableOpc = 32675
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReferenceListEntryDataType_DictionaryFragment                OpcuaNodeIdServicesVariableOpc = 32676
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryModifiedEvent                                      OpcuaNodeIdServicesVariableOpc = 32826
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryModifiedEvent_DataTypeVersion                      OpcuaNodeIdServicesVariableOpc = 32827
	OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryModifiedEvent_DictionaryFragment                   OpcuaNodeIdServicesVariableOpc = 32828
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryModifiedEvent                                         OpcuaNodeIdServicesVariableOpc = 32830
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryModifiedEvent_DataTypeVersion                         OpcuaNodeIdServicesVariableOpc = 32831
	OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryModifiedEvent_DictionaryFragment                      OpcuaNodeIdServicesVariableOpc = 32832
)

var OpcuaNodeIdServicesVariableOpcValues []OpcuaNodeIdServicesVariableOpc

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableOpcValues = []OpcuaNodeIdServicesVariableOpc{
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NamespaceUri,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Argument,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Argument_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Argument_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumValueType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumValueType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumValueType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StatusResult,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StatusResult_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StatusResult_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserTokenPolicy,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserTokenPolicy_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserTokenPolicy_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ApplicationDescription,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ApplicationDescription_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ApplicationDescription_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointDescription,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointDescription_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointDescription_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserIdentityToken,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserIdentityToken_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserIdentityToken_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AnonymousIdentityToken,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AnonymousIdentityToken_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AnonymousIdentityToken_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserNameIdentityToken,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserNameIdentityToken_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserNameIdentityToken_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_X509IdentityToken,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_X509IdentityToken_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_X509IdentityToken_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_IssuedIdentityToken,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_IssuedIdentityToken_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_IssuedIdentityToken_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointConfiguration,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointConfiguration_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointConfiguration_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BuildInfo,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BuildInfo_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BuildInfo_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SignedSoftwareCertificate,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SignedSoftwareCertificate_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SignedSoftwareCertificate_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AddNodesItem,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AddNodesItem_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AddNodesItem_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AddReferencesItem,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AddReferencesItem_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AddReferencesItem_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DeleteNodesItem,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DeleteNodesItem_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DeleteNodesItem_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DeleteReferencesItem,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DeleteReferencesItem_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DeleteReferencesItem_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RegisteredServer,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RegisteredServer_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RegisteredServer_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ContentFilterElement,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ContentFilterElement_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ContentFilterElement_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ContentFilter,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ContentFilter_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ContentFilter_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FilterOperand,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FilterOperand_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FilterOperand_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ElementOperand,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ElementOperand_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ElementOperand_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_LiteralOperand,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_LiteralOperand_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_LiteralOperand_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AttributeOperand,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AttributeOperand_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AttributeOperand_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SimpleAttributeOperand,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SimpleAttributeOperand_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SimpleAttributeOperand_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryEvent,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryEvent_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryEvent_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_MonitoringFilter,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_MonitoringFilter_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_MonitoringFilter_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EventFilter,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EventFilter_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EventFilter_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AggregateConfiguration,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AggregateConfiguration_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AggregateConfiguration_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryEventFieldList,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryEventFieldList_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryEventFieldList_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RedundantServerDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RedundantServerDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RedundantServerDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SamplingIntervalDiagnosticsDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SamplingIntervalDiagnosticsDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SamplingIntervalDiagnosticsDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerDiagnosticsSummaryDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerDiagnosticsSummaryDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerDiagnosticsSummaryDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerStatusDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerStatusDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerStatusDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SessionDiagnosticsDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SessionDiagnosticsDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SessionDiagnosticsDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SessionSecurityDiagnosticsDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SessionSecurityDiagnosticsDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SessionSecurityDiagnosticsDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServiceCounterDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServiceCounterDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServiceCounterDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscriptionDiagnosticsDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscriptionDiagnosticsDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscriptionDiagnosticsDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ModelChangeStructureDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ModelChangeStructureDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ModelChangeStructureDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SemanticChangeStructureDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SemanticChangeStructureDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SemanticChangeStructureDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Range,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Range_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Range_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EUInformation,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EUInformation_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EUInformation_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Annotation,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Annotation_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Annotation_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ProgramDiagnosticDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ProgramDiagnosticDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ProgramDiagnosticDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NamespaceUri,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Argument,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Argument_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Argument_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumValueType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumValueType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumValueType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StatusResult,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StatusResult_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StatusResult_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserTokenPolicy,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserTokenPolicy_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserTokenPolicy_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ApplicationDescription,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ApplicationDescription_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ApplicationDescription_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointDescription,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointDescription_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointDescription_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserIdentityToken,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserIdentityToken_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserIdentityToken_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AnonymousIdentityToken,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AnonymousIdentityToken_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AnonymousIdentityToken_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserNameIdentityToken,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserNameIdentityToken_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserNameIdentityToken_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_X509IdentityToken,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_X509IdentityToken_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_X509IdentityToken_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_IssuedIdentityToken,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_IssuedIdentityToken_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_IssuedIdentityToken_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointConfiguration,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointConfiguration_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointConfiguration_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BuildInfo,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BuildInfo_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BuildInfo_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SignedSoftwareCertificate,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SignedSoftwareCertificate_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SignedSoftwareCertificate_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AddNodesItem,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AddNodesItem_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AddNodesItem_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AddReferencesItem,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AddReferencesItem_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AddReferencesItem_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DeleteNodesItem,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DeleteNodesItem_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DeleteNodesItem_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DeleteReferencesItem,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DeleteReferencesItem_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DeleteReferencesItem_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RegisteredServer,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RegisteredServer_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RegisteredServer_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ContentFilterElement,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ContentFilterElement_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ContentFilterElement_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ContentFilter,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ContentFilter_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ContentFilter_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FilterOperand,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FilterOperand_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FilterOperand_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ElementOperand,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ElementOperand_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ElementOperand_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_LiteralOperand,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_LiteralOperand_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_LiteralOperand_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AttributeOperand,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AttributeOperand_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AttributeOperand_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SimpleAttributeOperand,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SimpleAttributeOperand_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SimpleAttributeOperand_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryEvent,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryEvent_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryEvent_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_MonitoringFilter,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_MonitoringFilter_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_MonitoringFilter_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EventFilter,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EventFilter_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EventFilter_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AggregateConfiguration,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AggregateConfiguration_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AggregateConfiguration_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryEventFieldList,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryEventFieldList_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryEventFieldList_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RedundantServerDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RedundantServerDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RedundantServerDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SamplingIntervalDiagnosticsDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SamplingIntervalDiagnosticsDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SamplingIntervalDiagnosticsDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerDiagnosticsSummaryDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerDiagnosticsSummaryDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerDiagnosticsSummaryDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerStatusDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerStatusDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerStatusDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SessionDiagnosticsDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SessionDiagnosticsDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SessionDiagnosticsDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SessionSecurityDiagnosticsDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SessionSecurityDiagnosticsDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SessionSecurityDiagnosticsDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServiceCounterDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServiceCounterDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServiceCounterDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscriptionDiagnosticsDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscriptionDiagnosticsDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscriptionDiagnosticsDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ModelChangeStructureDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ModelChangeStructureDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ModelChangeStructureDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SemanticChangeStructureDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SemanticChangeStructureDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SemanticChangeStructureDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Range,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Range_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Range_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EUInformation,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EUInformation_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EUInformation_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Annotation,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Annotation_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Annotation_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ProgramDiagnosticDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ProgramDiagnosticDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ProgramDiagnosticDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TimeZoneDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TimeZoneDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TimeZoneDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TimeZoneDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TimeZoneDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TimeZoneDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointUrlListDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointUrlListDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointUrlListDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkGroupDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkGroupDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkGroupDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointUrlListDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointUrlListDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointUrlListDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkGroupDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkGroupDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkGroupDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AxisInformation,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AxisInformation_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AxisInformation_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_XVType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_XVType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_XVType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AxisInformation,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AxisInformation_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AxisInformation_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_XVType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_XVType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_XVType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ComplexNumberType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ComplexNumberType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ComplexNumberType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DoubleComplexNumberType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DoubleComplexNumberType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DoubleComplexNumberType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ComplexNumberType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ComplexNumberType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ComplexNumberType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DoubleComplexNumberType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DoubleComplexNumberType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DoubleComplexNumberType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerOnNetwork,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerOnNetwork_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerOnNetwork_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerOnNetwork,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerOnNetwork_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerOnNetwork_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TrustListDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TrustListDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TrustListDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TrustListDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TrustListDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TrustListDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RelativePathElement,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RelativePathElement_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RelativePathElement_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RelativePath,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RelativePath_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RelativePath_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RelativePathElement,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RelativePathElement_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RelativePathElement_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RelativePath,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RelativePath_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RelativePath_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_OptionSet,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_OptionSet_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_OptionSet_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Union,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Union_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Union_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_OptionSet,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_OptionSet_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_OptionSet_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Union,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Union_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Union_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DiscoveryConfiguration,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DiscoveryConfiguration_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DiscoveryConfiguration_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_MdnsDiscoveryConfiguration,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_MdnsDiscoveryConfiguration_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_MdnsDiscoveryConfiguration_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DiscoveryConfiguration,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DiscoveryConfiguration_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DiscoveryConfiguration_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_MdnsDiscoveryConfiguration,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_MdnsDiscoveryConfiguration_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_MdnsDiscoveryConfiguration_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedVariableDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedVariableDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedVariableDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedVariableDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedVariableDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedVariableDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetMetaDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetMetaDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetMetaDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FieldMetaData,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FieldMetaData_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FieldMetaData_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeDescription,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeDescription_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeDescription_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumField,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumField_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumField_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_KeyValuePair,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_KeyValuePair_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_KeyValuePair_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ConfigurationVersionDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ConfigurationVersionDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ConfigurationVersionDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FieldTargetDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FieldTargetDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FieldTargetDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetMetaDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetMetaDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetMetaDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FieldMetaData,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FieldMetaData_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FieldMetaData_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeDescription,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeDescription_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeDescription_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumField,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumField_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumField_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_KeyValuePair,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_KeyValuePair_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_KeyValuePair_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ConfigurationVersionDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ConfigurationVersionDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ConfigurationVersionDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FieldTargetDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FieldTargetDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ModificationInfo,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ModificationInfo_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ModificationInfo_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ModificationInfo,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ModificationInfo_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ModificationInfo_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Deprecated,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Deprecated,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SimpleTypeDescription,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SimpleTypeDescription_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SimpleTypeDescription_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UABinaryFileDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UABinaryFileDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UABinaryFileDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerConnectionTransportDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerConnectionTransportDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerConnectionTransportDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SimpleTypeDescription,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SimpleTypeDescription_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SimpleTypeDescription_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UABinaryFileDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureDescription,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureDescription_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureDescription_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumDescription,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumDescription_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumDescription_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureDescription,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureDescription_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureDescription_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumDescription,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumDescription_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumDescription_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UABinaryFileDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UABinaryFileDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerConnectionTransportDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerConnectionTransportDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerConnectionTransportDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_IdentityMappingRuleType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_IdentityMappingRuleType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_IdentityMappingRuleType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_IdentityMappingRuleType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_IdentityMappingRuleType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_IdentityMappingRuleType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeSchemaHeader,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeSchemaHeader_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeSchemaHeader_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetSourceDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetSourceDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetSourceDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataItemsDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataItemsDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataItemsDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedEventsDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedEventsDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedEventsDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterTransportDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterTransportDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterTransportDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterMessageDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterMessageDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterMessageDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubGroupDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubGroupDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubGroupDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupTransportDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupTransportDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupTransportDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupMessageDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupMessageDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupMessageDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConnectionDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConnectionDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConnectionDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ConnectionTransportDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ConnectionTransportDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ConnectionTransportDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupTransportDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupTransportDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupTransportDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupMessageDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupMessageDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupMessageDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderTransportDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderTransportDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderTransportDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderMessageDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderMessageDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderMessageDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscribedDataSetDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscribedDataSetDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscribedDataSetDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TargetVariablesDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TargetVariablesDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TargetVariablesDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscribedDataSetMirrorDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscribedDataSetMirrorDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscribedDataSetMirrorDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpWriterGroupMessageDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpWriterGroupMessageDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpWriterGroupMessageDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpDataSetWriterMessageDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpDataSetWriterMessageDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpDataSetWriterMessageDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpDataSetReaderMessageDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpDataSetReaderMessageDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpDataSetReaderMessageDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonWriterGroupMessageDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonWriterGroupMessageDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonWriterGroupMessageDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonDataSetWriterMessageDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonDataSetWriterMessageDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonDataSetWriterMessageDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonDataSetReaderMessageDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonDataSetReaderMessageDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonDataSetReaderMessageDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerWriterGroupTransportDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerWriterGroupTransportDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerWriterGroupTransportDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerDataSetWriterTransportDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerDataSetWriterTransportDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerDataSetWriterTransportDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerDataSetReaderTransportDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerDataSetReaderTransportDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerDataSetReaderTransportDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeSchemaHeader,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeSchemaHeader_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeSchemaHeader_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetSourceDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetSourceDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetSourceDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataItemsDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataItemsDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataItemsDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedEventsDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedEventsDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedEventsDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterTransportDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterTransportDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterTransportDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterMessageDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterMessageDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterMessageDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubGroupDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubGroupDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubGroupDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupTransportDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupTransportDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupTransportDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupMessageDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupMessageDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupMessageDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConnectionDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConnectionDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConnectionDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ConnectionTransportDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ConnectionTransportDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ConnectionTransportDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupTransportDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupTransportDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupTransportDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupMessageDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupMessageDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupMessageDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderTransportDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderTransportDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderTransportDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderMessageDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderMessageDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderMessageDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscribedDataSetDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscribedDataSetDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscribedDataSetDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TargetVariablesDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TargetVariablesDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TargetVariablesDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscribedDataSetMirrorDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscribedDataSetMirrorDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscribedDataSetMirrorDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpWriterGroupMessageDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpWriterGroupMessageDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpWriterGroupMessageDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpDataSetWriterMessageDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpDataSetWriterMessageDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpDataSetWriterMessageDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpDataSetReaderMessageDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpDataSetReaderMessageDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpDataSetReaderMessageDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonWriterGroupMessageDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonWriterGroupMessageDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonWriterGroupMessageDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonDataSetWriterMessageDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonDataSetWriterMessageDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonDataSetWriterMessageDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonDataSetReaderMessageDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonDataSetReaderMessageDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonDataSetReaderMessageDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerWriterGroupTransportDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RolePermissionType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RolePermissionType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RolePermissionType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerWriterGroupTransportDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RolePermissionType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RolePermissionType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RolePermissionType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerWriterGroupTransportDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerDataSetWriterTransportDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerDataSetWriterTransportDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerDataSetWriterTransportDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerDataSetReaderTransportDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerDataSetReaderTransportDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerDataSetReaderTransportDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramConnectionTransportDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramConnectionTransportDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramConnectionTransportDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramConnectionTransportDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramConnectionTransportDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramConnectionTransportDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AdditionalParametersType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AdditionalParametersType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AdditionalParametersType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AdditionalParametersType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AdditionalParametersType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AdditionalParametersType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EphemeralKeyType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EphemeralKeyType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EphemeralKeyType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EphemeralKeyType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EphemeralKeyType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EphemeralKeyType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeDefinition,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeDefinition_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeDefinition_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureField,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureField_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureField_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureDefinition,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureDefinition_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureDefinition_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumDefinition,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumDefinition_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumDefinition_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeDefinition,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeDefinition_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeDefinition_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureField,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureField_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureField_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureDefinition,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureDefinition_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureDefinition_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumDefinition,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumDefinition_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumDefinition_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RationalNumber,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RationalNumber_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RationalNumber_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Vector,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Vector_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Vector_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDVector,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDVector_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDVector_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_CartesianCoordinates,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_CartesianCoordinates_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_CartesianCoordinates_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDCartesianCoordinates,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDCartesianCoordinates_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDCartesianCoordinates_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Orientation,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Orientation_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Orientation_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDOrientation,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDOrientation_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDOrientation_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Frame,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Frame_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Frame_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDFrame,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDFrame_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDFrame_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RationalNumber,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RationalNumber_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RationalNumber_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Vector,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Vector_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Vector_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDVector,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDVector_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDVector_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_CartesianCoordinates,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_CartesianCoordinates_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_CartesianCoordinates_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDCartesianCoordinates,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDCartesianCoordinates_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDCartesianCoordinates_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Orientation,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Orientation_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Orientation_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDOrientation,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDOrientation_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDOrientation_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Frame,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Frame_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Frame_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDFrame,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDFrame_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDFrame_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FieldTargetDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkAddressDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkAddressDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkAddressDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkAddressUrlDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkAddressUrlDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkAddressUrlDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramWriterGroupTransportDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramWriterGroupTransportDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramWriterGroupTransportDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkAddressDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkAddressDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkAddressDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkAddressUrlDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkAddressUrlDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkAddressUrlDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramWriterGroupTransportDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramWriterGroupTransportDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramWriterGroupTransportDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AliasNameDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AliasNameDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AliasNameDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AliasNameDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AliasNameDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AliasNameDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_CurrencyUnitType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_CurrencyUnitType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_CurrencyUnitType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_CurrencyUnitType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_CurrencyUnitType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_CurrencyUnitType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StandaloneSubscribedDataSetRefDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StandaloneSubscribedDataSetRefDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StandaloneSubscribedDataSetRefDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StandaloneSubscribedDataSetDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StandaloneSubscribedDataSetDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StandaloneSubscribedDataSetDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SecurityGroupDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SecurityGroupDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SecurityGroupDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfiguration2DataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfiguration2DataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfiguration2DataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_QosDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_QosDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_QosDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransmitQosDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransmitQosDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransmitQosDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransmitQosPriorityDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransmitQosPriorityDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransmitQosPriorityDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReceiveQosDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReceiveQosDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReceiveQosDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReceiveQosPriorityDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReceiveQosPriorityDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReceiveQosPriorityDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramConnectionTransport2DataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramConnectionTransport2DataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramConnectionTransport2DataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramWriterGroupTransport2DataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramWriterGroupTransport2DataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramWriterGroupTransport2DataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramDataSetReaderTransportDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramDataSetReaderTransportDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramDataSetReaderTransportDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StandaloneSubscribedDataSetRefDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StandaloneSubscribedDataSetRefDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StandaloneSubscribedDataSetRefDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StandaloneSubscribedDataSetDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StandaloneSubscribedDataSetDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StandaloneSubscribedDataSetDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SecurityGroupDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SecurityGroupDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SecurityGroupDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfiguration2DataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfiguration2DataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfiguration2DataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_QosDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_QosDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_QosDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransmitQosDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransmitQosDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransmitQosDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransmitQosPriorityDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransmitQosPriorityDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransmitQosPriorityDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReceiveQosDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReceiveQosDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReceiveQosDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReceiveQosPriorityDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReceiveQosPriorityDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReceiveQosPriorityDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramConnectionTransport2DataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramConnectionTransport2DataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramConnectionTransport2DataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramWriterGroupTransport2DataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramWriterGroupTransport2DataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramWriterGroupTransport2DataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramDataSetReaderTransportDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramDataSetReaderTransportDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramDataSetReaderTransportDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ProgramDiagnostic2DataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ProgramDiagnostic2DataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ProgramDiagnostic2DataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ProgramDiagnostic2DataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ProgramDiagnostic2DataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ProgramDiagnostic2DataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PortableQualifiedName,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PortableQualifiedName_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PortableQualifiedName_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PortableNodeId,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PortableNodeId_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PortableNodeId_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UnsignedRationalNumber,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UnsignedRationalNumber_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UnsignedRationalNumber_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PortableQualifiedName,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PortableQualifiedName_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PortableQualifiedName_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PortableNodeId,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PortableNodeId_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PortableNodeId_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UnsignedRationalNumber,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UnsignedRationalNumber_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UnsignedRationalNumber_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserManagementDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserManagementDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserManagementDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserManagementDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserManagementDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserManagementDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PriorityMappingEntryType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PriorityMappingEntryType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PriorityMappingEntryType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PriorityMappingEntryType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PriorityMappingEntryType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PriorityMappingEntryType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetCustomSourceDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetCustomSourceDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetCustomSourceDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubKeyPushTargetDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubKeyPushTargetDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubKeyPushTargetDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationRefDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationRefDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationRefDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationValueDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationValueDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationValueDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetCustomSourceDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetCustomSourceDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetCustomSourceDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubKeyPushTargetDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubKeyPushTargetDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubKeyPushTargetDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationRefDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationRefDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationRefDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationValueDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationValueDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationValueDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransactionErrorType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransactionErrorType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransactionErrorType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransactionErrorType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransactionErrorType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransactionErrorType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BitFieldDefinition,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BitFieldDefinition_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BitFieldDefinition_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BitFieldDefinition,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BitFieldDefinition_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BitFieldDefinition_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AnnotationDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AnnotationDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AnnotationDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_LinearConversionDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_LinearConversionDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_LinearConversionDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_QuantityDimension,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_QuantityDimension_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_QuantityDimension_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AnnotationDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AnnotationDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AnnotationDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_LinearConversionDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_LinearConversionDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_LinearConversionDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_QuantityDimension,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_QuantityDimension_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_QuantityDimension_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReferenceDescriptionDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReferenceDescriptionDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReferenceDescriptionDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReferenceListEntryDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReferenceListEntryDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReferenceListEntryDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReferenceDescriptionDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReferenceDescriptionDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReferenceDescriptionDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReferenceListEntryDataType,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReferenceListEntryDataType_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReferenceListEntryDataType_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryModifiedEvent,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryModifiedEvent_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryModifiedEvent_DictionaryFragment,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryModifiedEvent,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryModifiedEvent_DataTypeVersion,
		OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryModifiedEvent_DictionaryFragment,
	}
}

func OpcuaNodeIdServicesVariableOpcByValue(value int32) (enum OpcuaNodeIdServicesVariableOpc, ok bool) {
	switch value {
	case 11951:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointUrlListDataType, true
	case 11952:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointUrlListDataType_DataTypeVersion, true
	case 11953:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointUrlListDataType_DictionaryFragment, true
	case 11954:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkGroupDataType, true
	case 11955:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkGroupDataType_DataTypeVersion, true
	case 11956:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkGroupDataType_DictionaryFragment, true
	case 11959:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointUrlListDataType, true
	case 11960:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointUrlListDataType_DataTypeVersion, true
	case 11961:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointUrlListDataType_DictionaryFragment, true
	case 11962:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkGroupDataType, true
	case 11963:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkGroupDataType_DataTypeVersion, true
	case 11964:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkGroupDataType_DictionaryFragment, true
	case 12083:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AxisInformation, true
	case 12084:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AxisInformation_DataTypeVersion, true
	case 12085:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AxisInformation_DictionaryFragment, true
	case 12086:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_XVType, true
	case 12087:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_XVType_DataTypeVersion, true
	case 12088:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_XVType_DictionaryFragment, true
	case 12091:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AxisInformation, true
	case 12092:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AxisInformation_DataTypeVersion, true
	case 12093:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AxisInformation_DictionaryFragment, true
	case 12094:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_XVType, true
	case 12095:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_XVType_DataTypeVersion, true
	case 12096:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_XVType_DictionaryFragment, true
	case 12175:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ComplexNumberType, true
	case 12176:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ComplexNumberType_DataTypeVersion, true
	case 12177:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ComplexNumberType_DictionaryFragment, true
	case 12178:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DoubleComplexNumberType, true
	case 12179:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DoubleComplexNumberType_DataTypeVersion, true
	case 12180:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DoubleComplexNumberType_DictionaryFragment, true
	case 12183:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ComplexNumberType, true
	case 12184:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ComplexNumberType_DataTypeVersion, true
	case 12185:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ComplexNumberType_DictionaryFragment, true
	case 12186:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DoubleComplexNumberType, true
	case 12187:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DoubleComplexNumberType_DataTypeVersion, true
	case 12188:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DoubleComplexNumberType_DictionaryFragment, true
	case 12201:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerOnNetwork, true
	case 12202:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerOnNetwork_DataTypeVersion, true
	case 12203:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerOnNetwork_DictionaryFragment, true
	case 12213:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerOnNetwork, true
	case 12214:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerOnNetwork_DataTypeVersion, true
	case 12215:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerOnNetwork_DictionaryFragment, true
	case 12677:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TrustListDataType, true
	case 12678:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TrustListDataType_DataTypeVersion, true
	case 12679:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TrustListDataType_DictionaryFragment, true
	case 12681:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TrustListDataType, true
	case 12682:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TrustListDataType_DataTypeVersion, true
	case 12683:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TrustListDataType_DictionaryFragment, true
	case 12712:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RelativePathElement, true
	case 12713:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RelativePathElement_DataTypeVersion, true
	case 12714:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RelativePathElement_DictionaryFragment, true
	case 12715:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RelativePath, true
	case 12716:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RelativePath_DataTypeVersion, true
	case 12717:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RelativePath_DictionaryFragment, true
	case 12718:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RelativePathElement, true
	case 12719:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RelativePathElement_DataTypeVersion, true
	case 12720:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RelativePathElement_DictionaryFragment, true
	case 12721:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RelativePath, true
	case 12722:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RelativePath_DataTypeVersion, true
	case 12723:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RelativePath_DictionaryFragment, true
	case 12759:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_OptionSet, true
	case 12760:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_OptionSet_DataTypeVersion, true
	case 12761:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_OptionSet_DictionaryFragment, true
	case 12762:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Union, true
	case 12763:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Union_DataTypeVersion, true
	case 12764:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Union_DictionaryFragment, true
	case 12767:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_OptionSet, true
	case 12768:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_OptionSet_DataTypeVersion, true
	case 12769:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_OptionSet_DictionaryFragment, true
	case 12770:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Union, true
	case 12771:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Union_DataTypeVersion, true
	case 12772:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Union_DictionaryFragment, true
	case 12894:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DiscoveryConfiguration, true
	case 12895:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DiscoveryConfiguration_DataTypeVersion, true
	case 12896:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DiscoveryConfiguration_DictionaryFragment, true
	case 12897:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_MdnsDiscoveryConfiguration, true
	case 12898:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_MdnsDiscoveryConfiguration_DataTypeVersion, true
	case 12899:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_MdnsDiscoveryConfiguration_DictionaryFragment, true
	case 12902:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DiscoveryConfiguration, true
	case 12903:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DiscoveryConfiguration_DataTypeVersion, true
	case 12904:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DiscoveryConfiguration_DictionaryFragment, true
	case 12905:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_MdnsDiscoveryConfiguration, true
	case 12906:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_MdnsDiscoveryConfiguration_DataTypeVersion, true
	case 12907:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_MdnsDiscoveryConfiguration_DictionaryFragment, true
	case 14320:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedVariableDataType, true
	case 14321:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedVariableDataType_DataTypeVersion, true
	case 14322:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedVariableDataType_DictionaryFragment, true
	case 14324:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedVariableDataType, true
	case 14325:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedVariableDataType_DataTypeVersion, true
	case 14326:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedVariableDataType_DictionaryFragment, true
	case 14805:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetMetaDataType, true
	case 14806:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetMetaDataType_DataTypeVersion, true
	case 14807:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetMetaDataType_DictionaryFragment, true
	case 14808:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FieldMetaData, true
	case 14809:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FieldMetaData_DataTypeVersion, true
	case 14810:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FieldMetaData_DictionaryFragment, true
	case 14811:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeDescription, true
	case 14812:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeDescription_DataTypeVersion, true
	case 14813:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeDescription_DictionaryFragment, true
	case 14826:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumField, true
	case 14827:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumField_DataTypeVersion, true
	case 14828:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumField_DictionaryFragment, true
	case 14829:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_KeyValuePair, true
	case 14830:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_KeyValuePair_DataTypeVersion, true
	case 14831:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_KeyValuePair_DictionaryFragment, true
	case 14832:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ConfigurationVersionDataType, true
	case 14833:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ConfigurationVersionDataType_DataTypeVersion, true
	case 14834:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ConfigurationVersionDataType_DictionaryFragment, true
	case 14835:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FieldTargetDataType, true
	case 14836:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FieldTargetDataType_DataTypeVersion, true
	case 14837:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FieldTargetDataType_DictionaryFragment, true
	case 14849:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetMetaDataType, true
	case 14850:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetMetaDataType_DataTypeVersion, true
	case 14851:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetMetaDataType_DictionaryFragment, true
	case 14852:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FieldMetaData, true
	case 14853:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FieldMetaData_DataTypeVersion, true
	case 14854:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FieldMetaData_DictionaryFragment, true
	case 14855:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeDescription, true
	case 14856:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeDescription_DataTypeVersion, true
	case 14857:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeDescription_DictionaryFragment, true
	case 14870:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumField, true
	case 14871:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumField_DataTypeVersion, true
	case 14872:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumField_DictionaryFragment, true
	case 14873:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_KeyValuePair, true
	case 14874:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_KeyValuePair_DataTypeVersion, true
	case 14875:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_KeyValuePair_DictionaryFragment, true
	case 14876:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ConfigurationVersionDataType, true
	case 14877:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ConfigurationVersionDataType_DataTypeVersion, true
	case 14878:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ConfigurationVersionDataType_DictionaryFragment, true
	case 14880:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FieldTargetDataType_DataTypeVersion, true
	case 14881:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FieldTargetDataType_DictionaryFragment, true
	case 15018:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ModificationInfo, true
	case 15019:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ModificationInfo_DataTypeVersion, true
	case 15020:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ModificationInfo_DictionaryFragment, true
	case 15021:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ModificationInfo, true
	case 15022:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ModificationInfo_DataTypeVersion, true
	case 15023:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ModificationInfo_DictionaryFragment, true
	case 15037:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Deprecated, true
	case 15039:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Deprecated, true
	case 15501:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SimpleTypeDescription, true
	case 15509:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SimpleTypeDescription_DataTypeVersion, true
	case 15519:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SimpleTypeDescription_DictionaryFragment, true
	case 15521:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UABinaryFileDataType, true
	case 15522:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UABinaryFileDataType_DataTypeVersion, true
	case 15523:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UABinaryFileDataType_DictionaryFragment, true
	case 15524:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerConnectionTransportDataType, true
	case 15525:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerConnectionTransportDataType_DataTypeVersion, true
	case 15526:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerConnectionTransportDataType_DictionaryFragment, true
	case 15585:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SimpleTypeDescription, true
	case 15586:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SimpleTypeDescription_DataTypeVersion, true
	case 15587:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SimpleTypeDescription_DictionaryFragment, true
	case 15588:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UABinaryFileDataType, true
	case 15591:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureDescription, true
	case 15592:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureDescription_DataTypeVersion, true
	case 15593:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureDescription_DictionaryFragment, true
	case 15594:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumDescription, true
	case 15595:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumDescription_DataTypeVersion, true
	case 15596:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumDescription_DictionaryFragment, true
	case 15599:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureDescription, true
	case 15600:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureDescription_DataTypeVersion, true
	case 15601:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureDescription_DictionaryFragment, true
	case 15602:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumDescription, true
	case 15603:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumDescription_DataTypeVersion, true
	case 15604:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumDescription_DictionaryFragment, true
	case 15610:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UABinaryFileDataType_DataTypeVersion, true
	case 15619:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UABinaryFileDataType_DictionaryFragment, true
	case 15640:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerConnectionTransportDataType, true
	case 15666:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerConnectionTransportDataType_DataTypeVersion, true
	case 15690:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerConnectionTransportDataType_DictionaryFragment, true
	case 15730:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_IdentityMappingRuleType, true
	case 15731:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_IdentityMappingRuleType_DataTypeVersion, true
	case 15732:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_IdentityMappingRuleType_DictionaryFragment, true
	case 15734:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointType, true
	case 15735:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointType_DataTypeVersion, true
	case 15737:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointType_DictionaryFragment, true
	case 15738:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_IdentityMappingRuleType, true
	case 15739:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_IdentityMappingRuleType_DataTypeVersion, true
	case 15740:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_IdentityMappingRuleType_DictionaryFragment, true
	case 15741:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeSchemaHeader, true
	case 15742:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeSchemaHeader_DataTypeVersion, true
	case 15743:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeSchemaHeader_DictionaryFragment, true
	case 15766:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetDataType, true
	case 15767:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetDataType_DataTypeVersion, true
	case 15768:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetDataType_DictionaryFragment, true
	case 15769:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetSourceDataType, true
	case 15770:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetSourceDataType_DataTypeVersion, true
	case 15771:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetSourceDataType_DictionaryFragment, true
	case 15772:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataItemsDataType, true
	case 15773:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataItemsDataType_DataTypeVersion, true
	case 15774:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataItemsDataType_DictionaryFragment, true
	case 15775:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedEventsDataType, true
	case 15776:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedEventsDataType_DataTypeVersion, true
	case 15777:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedEventsDataType_DictionaryFragment, true
	case 15778:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterDataType, true
	case 15779:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterDataType_DataTypeVersion, true
	case 15780:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterDataType_DictionaryFragment, true
	case 15781:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterTransportDataType, true
	case 15782:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterTransportDataType_DataTypeVersion, true
	case 15783:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterTransportDataType_DictionaryFragment, true
	case 15784:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterMessageDataType, true
	case 15785:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterMessageDataType_DataTypeVersion, true
	case 15786:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterMessageDataType_DictionaryFragment, true
	case 15787:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubGroupDataType, true
	case 15788:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubGroupDataType_DataTypeVersion, true
	case 15789:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubGroupDataType_DictionaryFragment, true
	case 15793:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupTransportDataType, true
	case 15852:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupTransportDataType_DataTypeVersion, true
	case 15853:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupTransportDataType_DictionaryFragment, true
	case 15854:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupMessageDataType, true
	case 15855:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupMessageDataType_DataTypeVersion, true
	case 15856:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupMessageDataType_DictionaryFragment, true
	case 15857:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConnectionDataType, true
	case 15858:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConnectionDataType_DataTypeVersion, true
	case 15859:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConnectionDataType_DictionaryFragment, true
	case 15860:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ConnectionTransportDataType, true
	case 15861:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ConnectionTransportDataType_DataTypeVersion, true
	case 15862:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ConnectionTransportDataType_DictionaryFragment, true
	case 15866:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupTransportDataType, true
	case 15867:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupTransportDataType_DataTypeVersion, true
	case 15868:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupTransportDataType_DictionaryFragment, true
	case 15869:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupMessageDataType, true
	case 15870:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupMessageDataType_DataTypeVersion, true
	case 15871:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupMessageDataType_DictionaryFragment, true
	case 15872:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderDataType, true
	case 15873:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderDataType_DataTypeVersion, true
	case 15876:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderDataType_DictionaryFragment, true
	case 15877:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderTransportDataType, true
	case 15878:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderTransportDataType_DataTypeVersion, true
	case 15879:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderTransportDataType_DictionaryFragment, true
	case 15880:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderMessageDataType, true
	case 15881:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderMessageDataType_DataTypeVersion, true
	case 15882:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderMessageDataType_DictionaryFragment, true
	case 15883:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscribedDataSetDataType, true
	case 15884:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscribedDataSetDataType_DataTypeVersion, true
	case 15885:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscribedDataSetDataType_DictionaryFragment, true
	case 15886:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TargetVariablesDataType, true
	case 15887:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TargetVariablesDataType_DataTypeVersion, true
	case 15888:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TargetVariablesDataType_DictionaryFragment, true
	case 15889:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscribedDataSetMirrorDataType, true
	case 15890:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscribedDataSetMirrorDataType_DataTypeVersion, true
	case 15891:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscribedDataSetMirrorDataType_DictionaryFragment, true
	case 15895:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpWriterGroupMessageDataType, true
	case 15896:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpWriterGroupMessageDataType_DataTypeVersion, true
	case 15897:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpWriterGroupMessageDataType_DictionaryFragment, true
	case 15898:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpDataSetWriterMessageDataType, true
	case 15899:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpDataSetWriterMessageDataType_DataTypeVersion, true
	case 15900:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpDataSetWriterMessageDataType_DictionaryFragment, true
	case 15919:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpDataSetReaderMessageDataType, true
	case 15920:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpDataSetReaderMessageDataType_DataTypeVersion, true
	case 15921:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpDataSetReaderMessageDataType_DictionaryFragment, true
	case 15922:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonWriterGroupMessageDataType, true
	case 15923:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonWriterGroupMessageDataType_DataTypeVersion, true
	case 15924:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonWriterGroupMessageDataType_DictionaryFragment, true
	case 15925:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonDataSetWriterMessageDataType, true
	case 15929:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonDataSetWriterMessageDataType_DataTypeVersion, true
	case 15930:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonDataSetWriterMessageDataType_DictionaryFragment, true
	case 15931:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonDataSetReaderMessageDataType, true
	case 15935:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonDataSetReaderMessageDataType_DataTypeVersion, true
	case 15936:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonDataSetReaderMessageDataType_DictionaryFragment, true
	case 15940:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerWriterGroupTransportDataType, true
	case 15941:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerWriterGroupTransportDataType_DataTypeVersion, true
	case 15942:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerWriterGroupTransportDataType_DictionaryFragment, true
	case 15943:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerDataSetWriterTransportDataType, true
	case 15944:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerDataSetWriterTransportDataType_DataTypeVersion, true
	case 15945:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerDataSetWriterTransportDataType_DictionaryFragment, true
	case 15946:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerDataSetReaderTransportDataType, true
	case 15947:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerDataSetReaderTransportDataType_DataTypeVersion, true
	case 15948:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerDataSetReaderTransportDataType_DictionaryFragment, true
	case 16024:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointType, true
	case 16025:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointType_DataTypeVersion, true
	case 16026:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointType_DictionaryFragment, true
	case 16027:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeSchemaHeader, true
	case 16028:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeSchemaHeader_DataTypeVersion, true
	case 16029:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeSchemaHeader_DictionaryFragment, true
	case 16030:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetDataType, true
	case 16031:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetDataType_DataTypeVersion, true
	case 16032:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetDataType_DictionaryFragment, true
	case 16033:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetSourceDataType, true
	case 16034:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetSourceDataType_DataTypeVersion, true
	case 16035:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetSourceDataType_DictionaryFragment, true
	case 16037:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataItemsDataType, true
	case 16038:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataItemsDataType_DataTypeVersion, true
	case 16039:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataItemsDataType_DictionaryFragment, true
	case 16040:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedEventsDataType, true
	case 16045:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedEventsDataType_DataTypeVersion, true
	case 16046:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedEventsDataType_DictionaryFragment, true
	case 16047:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterDataType, true
	case 16048:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterDataType_DataTypeVersion, true
	case 16049:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterDataType_DictionaryFragment, true
	case 16050:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterTransportDataType, true
	case 16051:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterTransportDataType_DataTypeVersion, true
	case 16052:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterTransportDataType_DictionaryFragment, true
	case 16053:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterMessageDataType, true
	case 16054:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterMessageDataType_DataTypeVersion, true
	case 16055:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterMessageDataType_DictionaryFragment, true
	case 16056:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubGroupDataType, true
	case 16057:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubGroupDataType_DataTypeVersion, true
	case 16058:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubGroupDataType_DictionaryFragment, true
	case 16062:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupTransportDataType, true
	case 16063:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupTransportDataType_DataTypeVersion, true
	case 16064:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupTransportDataType_DictionaryFragment, true
	case 16065:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupMessageDataType, true
	case 16066:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupMessageDataType_DataTypeVersion, true
	case 16067:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupMessageDataType_DictionaryFragment, true
	case 16068:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConnectionDataType, true
	case 16069:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConnectionDataType_DataTypeVersion, true
	case 16070:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConnectionDataType_DictionaryFragment, true
	case 16071:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ConnectionTransportDataType, true
	case 16072:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ConnectionTransportDataType_DataTypeVersion, true
	case 16073:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ConnectionTransportDataType_DictionaryFragment, true
	case 16077:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupTransportDataType, true
	case 16078:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupTransportDataType_DataTypeVersion, true
	case 16079:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupTransportDataType_DictionaryFragment, true
	case 16080:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupMessageDataType, true
	case 16081:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupMessageDataType_DataTypeVersion, true
	case 16082:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupMessageDataType_DictionaryFragment, true
	case 16083:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderDataType, true
	case 16084:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderDataType_DataTypeVersion, true
	case 16085:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderDataType_DictionaryFragment, true
	case 16086:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderTransportDataType, true
	case 16087:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderTransportDataType_DataTypeVersion, true
	case 16088:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderTransportDataType_DictionaryFragment, true
	case 16089:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderMessageDataType, true
	case 16090:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderMessageDataType_DataTypeVersion, true
	case 16091:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderMessageDataType_DictionaryFragment, true
	case 16092:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscribedDataSetDataType, true
	case 16093:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscribedDataSetDataType_DataTypeVersion, true
	case 16094:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscribedDataSetDataType_DictionaryFragment, true
	case 16095:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TargetVariablesDataType, true
	case 16096:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TargetVariablesDataType_DataTypeVersion, true
	case 16097:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TargetVariablesDataType_DictionaryFragment, true
	case 16098:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscribedDataSetMirrorDataType, true
	case 16099:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscribedDataSetMirrorDataType_DataTypeVersion, true
	case 16100:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscribedDataSetMirrorDataType_DictionaryFragment, true
	case 16104:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpWriterGroupMessageDataType, true
	case 16105:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpWriterGroupMessageDataType_DataTypeVersion, true
	case 16106:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpWriterGroupMessageDataType_DictionaryFragment, true
	case 16107:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpDataSetWriterMessageDataType, true
	case 16108:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpDataSetWriterMessageDataType_DataTypeVersion, true
	case 16109:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpDataSetWriterMessageDataType_DictionaryFragment, true
	case 16110:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpDataSetReaderMessageDataType, true
	case 16111:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpDataSetReaderMessageDataType_DataTypeVersion, true
	case 16112:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpDataSetReaderMessageDataType_DictionaryFragment, true
	case 16113:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonWriterGroupMessageDataType, true
	case 16114:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonWriterGroupMessageDataType_DataTypeVersion, true
	case 16115:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonWriterGroupMessageDataType_DictionaryFragment, true
	case 16116:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonDataSetWriterMessageDataType, true
	case 16117:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonDataSetWriterMessageDataType_DataTypeVersion, true
	case 16118:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonDataSetWriterMessageDataType_DictionaryFragment, true
	case 16119:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonDataSetReaderMessageDataType, true
	case 16120:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonDataSetReaderMessageDataType_DataTypeVersion, true
	case 16121:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonDataSetReaderMessageDataType_DictionaryFragment, true
	case 16125:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerWriterGroupTransportDataType, true
	case 16127:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RolePermissionType, true
	case 16128:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RolePermissionType_DataTypeVersion, true
	case 16129:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RolePermissionType_DictionaryFragment, true
	case 16130:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerWriterGroupTransportDataType_DataTypeVersion, true
	case 16131:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RolePermissionType, true
	case 16132:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RolePermissionType_DataTypeVersion, true
	case 16133:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RolePermissionType_DictionaryFragment, true
	case 16143:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerWriterGroupTransportDataType_DictionaryFragment, true
	case 16144:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerDataSetWriterTransportDataType, true
	case 16145:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerDataSetWriterTransportDataType_DataTypeVersion, true
	case 16146:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerDataSetWriterTransportDataType_DictionaryFragment, true
	case 16147:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerDataSetReaderTransportDataType, true
	case 16148:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerDataSetReaderTransportDataType_DataTypeVersion, true
	case 16149:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerDataSetReaderTransportDataType_DictionaryFragment, true
	case 17469:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramConnectionTransportDataType, true
	case 17470:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramConnectionTransportDataType_DataTypeVersion, true
	case 17471:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramConnectionTransportDataType_DictionaryFragment, true
	case 17473:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramConnectionTransportDataType, true
	case 17474:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramConnectionTransportDataType_DataTypeVersion, true
	case 17475:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramConnectionTransportDataType_DictionaryFragment, true
	case 17538:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AdditionalParametersType, true
	case 17539:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AdditionalParametersType_DataTypeVersion, true
	case 17540:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AdditionalParametersType_DictionaryFragment, true
	case 17542:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AdditionalParametersType, true
	case 17543:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AdditionalParametersType_DataTypeVersion, true
	case 17544:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AdditionalParametersType_DictionaryFragment, true
	case 17550:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EphemeralKeyType, true
	case 17551:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EphemeralKeyType_DataTypeVersion, true
	case 17552:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EphemeralKeyType_DictionaryFragment, true
	case 17554:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EphemeralKeyType, true
	case 17555:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EphemeralKeyType_DataTypeVersion, true
	case 17556:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EphemeralKeyType_DictionaryFragment, true
	case 18166:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeDefinition, true
	case 18167:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeDefinition_DataTypeVersion, true
	case 18168:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeDefinition_DictionaryFragment, true
	case 18169:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureField, true
	case 18170:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureField_DataTypeVersion, true
	case 18171:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureField_DictionaryFragment, true
	case 18172:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureDefinition, true
	case 18173:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureDefinition_DataTypeVersion, true
	case 18174:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureDefinition_DictionaryFragment, true
	case 18175:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumDefinition, true
	case 18176:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumDefinition_DataTypeVersion, true
	case 18177:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumDefinition_DictionaryFragment, true
	case 18178:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeDefinition, true
	case 18179:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeDefinition_DataTypeVersion, true
	case 18180:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeDefinition_DictionaryFragment, true
	case 18181:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureField, true
	case 18182:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureField_DataTypeVersion, true
	case 18183:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureField_DictionaryFragment, true
	case 18184:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureDefinition, true
	case 18185:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureDefinition_DataTypeVersion, true
	case 18186:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureDefinition_DictionaryFragment, true
	case 18187:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumDefinition, true
	case 18188:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumDefinition_DataTypeVersion, true
	case 18189:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumDefinition_DictionaryFragment, true
	case 18824:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RationalNumber, true
	case 18825:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RationalNumber_DataTypeVersion, true
	case 18826:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RationalNumber_DictionaryFragment, true
	case 18827:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Vector, true
	case 18828:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Vector_DataTypeVersion, true
	case 18829:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Vector_DictionaryFragment, true
	case 18830:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDVector, true
	case 18831:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDVector_DataTypeVersion, true
	case 18832:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDVector_DictionaryFragment, true
	case 18833:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_CartesianCoordinates, true
	case 18834:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_CartesianCoordinates_DataTypeVersion, true
	case 18835:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_CartesianCoordinates_DictionaryFragment, true
	case 18836:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDCartesianCoordinates, true
	case 18837:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDCartesianCoordinates_DataTypeVersion, true
	case 18838:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDCartesianCoordinates_DictionaryFragment, true
	case 18839:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Orientation, true
	case 18840:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Orientation_DataTypeVersion, true
	case 18841:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Orientation_DictionaryFragment, true
	case 18842:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDOrientation, true
	case 18843:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDOrientation_DataTypeVersion, true
	case 18844:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDOrientation_DictionaryFragment, true
	case 18845:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Frame, true
	case 18846:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Frame_DataTypeVersion, true
	case 18847:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Frame_DictionaryFragment, true
	case 18848:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDFrame, true
	case 18849:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDFrame_DataTypeVersion, true
	case 18850:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDFrame_DictionaryFragment, true
	case 18860:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RationalNumber, true
	case 18861:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RationalNumber_DataTypeVersion, true
	case 18862:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RationalNumber_DictionaryFragment, true
	case 18863:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Vector, true
	case 18864:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Vector_DataTypeVersion, true
	case 18865:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Vector_DictionaryFragment, true
	case 18866:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDVector, true
	case 18867:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDVector_DataTypeVersion, true
	case 18868:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDVector_DictionaryFragment, true
	case 18869:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_CartesianCoordinates, true
	case 18870:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_CartesianCoordinates_DataTypeVersion, true
	case 19048:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_CartesianCoordinates_DictionaryFragment, true
	case 19049:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDCartesianCoordinates, true
	case 19050:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDCartesianCoordinates_DataTypeVersion, true
	case 19051:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDCartesianCoordinates_DictionaryFragment, true
	case 19052:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Orientation, true
	case 19053:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Orientation_DataTypeVersion, true
	case 19054:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Orientation_DictionaryFragment, true
	case 19055:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDOrientation, true
	case 19056:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDOrientation_DataTypeVersion, true
	case 19057:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDOrientation_DictionaryFragment, true
	case 19058:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Frame, true
	case 19059:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Frame_DataTypeVersion, true
	case 19060:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Frame_DictionaryFragment, true
	case 19061:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDFrame, true
	case 19062:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDFrame_DataTypeVersion, true
	case 19063:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDFrame_DictionaryFragment, true
	case 21002:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FieldTargetDataType, true
	case 21156:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupDataType, true
	case 21157:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupDataType_DataTypeVersion, true
	case 21158:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupDataType_DictionaryFragment, true
	case 21159:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkAddressDataType, true
	case 21160:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkAddressDataType_DataTypeVersion, true
	case 21161:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkAddressDataType_DictionaryFragment, true
	case 21162:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkAddressUrlDataType, true
	case 21163:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkAddressUrlDataType_DataTypeVersion, true
	case 21164:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkAddressUrlDataType_DictionaryFragment, true
	case 21165:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupDataType, true
	case 21166:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupDataType_DataTypeVersion, true
	case 21167:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupDataType_DictionaryFragment, true
	case 21168:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationDataType, true
	case 21169:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationDataType_DataTypeVersion, true
	case 21170:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationDataType_DictionaryFragment, true
	case 21171:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramWriterGroupTransportDataType, true
	case 21172:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramWriterGroupTransportDataType_DataTypeVersion, true
	case 21173:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramWriterGroupTransportDataType_DictionaryFragment, true
	case 21180:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupDataType, true
	case 21181:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupDataType_DataTypeVersion, true
	case 21182:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupDataType_DictionaryFragment, true
	case 21183:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkAddressDataType, true
	case 21184:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkAddressDataType_DataTypeVersion, true
	case 21185:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkAddressDataType_DictionaryFragment, true
	case 21186:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkAddressUrlDataType, true
	case 21187:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkAddressUrlDataType_DataTypeVersion, true
	case 21188:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkAddressUrlDataType_DictionaryFragment, true
	case 21189:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupDataType, true
	case 21190:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupDataType_DataTypeVersion, true
	case 21191:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupDataType_DictionaryFragment, true
	case 21192:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationDataType, true
	case 21193:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationDataType_DataTypeVersion, true
	case 21194:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationDataType_DictionaryFragment, true
	case 21195:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramWriterGroupTransportDataType, true
	case 21196:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramWriterGroupTransportDataType_DataTypeVersion, true
	case 21197:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramWriterGroupTransportDataType_DictionaryFragment, true
	case 23502:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AliasNameDataType, true
	case 23503:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AliasNameDataType_DataTypeVersion, true
	case 23504:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AliasNameDataType_DictionaryFragment, true
	case 23508:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AliasNameDataType, true
	case 23509:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AliasNameDataType_DataTypeVersion, true
	case 23510:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AliasNameDataType_DictionaryFragment, true
	case 23514:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_CurrencyUnitType, true
	case 23515:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_CurrencyUnitType_DataTypeVersion, true
	case 23516:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_CurrencyUnitType_DictionaryFragment, true
	case 23522:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_CurrencyUnitType, true
	case 23523:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_CurrencyUnitType_DataTypeVersion, true
	case 23524:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_CurrencyUnitType_DictionaryFragment, true
	case 23870:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StandaloneSubscribedDataSetRefDataType, true
	case 23871:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StandaloneSubscribedDataSetRefDataType_DataTypeVersion, true
	case 23872:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StandaloneSubscribedDataSetRefDataType_DictionaryFragment, true
	case 23873:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StandaloneSubscribedDataSetDataType, true
	case 23874:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StandaloneSubscribedDataSetDataType_DataTypeVersion, true
	case 23875:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StandaloneSubscribedDataSetDataType_DictionaryFragment, true
	case 23876:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SecurityGroupDataType, true
	case 23877:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SecurityGroupDataType_DataTypeVersion, true
	case 23878:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SecurityGroupDataType_DictionaryFragment, true
	case 23879:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfiguration2DataType, true
	case 23880:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfiguration2DataType_DataTypeVersion, true
	case 23881:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfiguration2DataType_DictionaryFragment, true
	case 23882:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_QosDataType, true
	case 23883:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_QosDataType_DataTypeVersion, true
	case 23884:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_QosDataType_DictionaryFragment, true
	case 23885:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransmitQosDataType, true
	case 23886:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransmitQosDataType_DataTypeVersion, true
	case 23887:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransmitQosDataType_DictionaryFragment, true
	case 23888:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransmitQosPriorityDataType, true
	case 23889:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransmitQosPriorityDataType_DataTypeVersion, true
	case 23890:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransmitQosPriorityDataType_DictionaryFragment, true
	case 23897:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReceiveQosDataType, true
	case 23898:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReceiveQosDataType_DataTypeVersion, true
	case 23899:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReceiveQosDataType_DictionaryFragment, true
	case 23900:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReceiveQosPriorityDataType, true
	case 23901:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReceiveQosPriorityDataType_DataTypeVersion, true
	case 23902:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReceiveQosPriorityDataType_DictionaryFragment, true
	case 23909:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramConnectionTransport2DataType, true
	case 23910:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramConnectionTransport2DataType_DataTypeVersion, true
	case 23911:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramConnectionTransport2DataType_DictionaryFragment, true
	case 23912:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramWriterGroupTransport2DataType, true
	case 23913:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramWriterGroupTransport2DataType_DataTypeVersion, true
	case 23914:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramWriterGroupTransport2DataType_DictionaryFragment, true
	case 23915:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramDataSetReaderTransportDataType, true
	case 23916:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramDataSetReaderTransportDataType_DataTypeVersion, true
	case 23917:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramDataSetReaderTransportDataType_DictionaryFragment, true
	case 23938:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StandaloneSubscribedDataSetRefDataType, true
	case 23939:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StandaloneSubscribedDataSetRefDataType_DataTypeVersion, true
	case 23940:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StandaloneSubscribedDataSetRefDataType_DictionaryFragment, true
	case 23941:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StandaloneSubscribedDataSetDataType, true
	case 23942:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StandaloneSubscribedDataSetDataType_DataTypeVersion, true
	case 23943:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StandaloneSubscribedDataSetDataType_DictionaryFragment, true
	case 23944:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SecurityGroupDataType, true
	case 23945:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SecurityGroupDataType_DataTypeVersion, true
	case 23946:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SecurityGroupDataType_DictionaryFragment, true
	case 23947:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfiguration2DataType, true
	case 23948:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfiguration2DataType_DataTypeVersion, true
	case 23949:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfiguration2DataType_DictionaryFragment, true
	case 23950:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_QosDataType, true
	case 23951:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_QosDataType_DataTypeVersion, true
	case 23952:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_QosDataType_DictionaryFragment, true
	case 23953:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransmitQosDataType, true
	case 23954:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransmitQosDataType_DataTypeVersion, true
	case 23955:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransmitQosDataType_DictionaryFragment, true
	case 23956:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransmitQosPriorityDataType, true
	case 23957:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransmitQosPriorityDataType_DataTypeVersion, true
	case 23958:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransmitQosPriorityDataType_DictionaryFragment, true
	case 23965:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReceiveQosDataType, true
	case 23966:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReceiveQosDataType_DataTypeVersion, true
	case 23967:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReceiveQosDataType_DictionaryFragment, true
	case 23968:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReceiveQosPriorityDataType, true
	case 23969:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReceiveQosPriorityDataType_DataTypeVersion, true
	case 23970:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReceiveQosPriorityDataType_DictionaryFragment, true
	case 23977:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramConnectionTransport2DataType, true
	case 23978:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramConnectionTransport2DataType_DataTypeVersion, true
	case 23979:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramConnectionTransport2DataType_DictionaryFragment, true
	case 23980:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramWriterGroupTransport2DataType, true
	case 23981:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramWriterGroupTransport2DataType_DataTypeVersion, true
	case 23982:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramWriterGroupTransport2DataType_DictionaryFragment, true
	case 23983:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramDataSetReaderTransportDataType, true
	case 23984:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramDataSetReaderTransportDataType_DataTypeVersion, true
	case 23985:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramDataSetReaderTransportDataType_DictionaryFragment, true
	case 24035:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ProgramDiagnostic2DataType, true
	case 24036:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ProgramDiagnostic2DataType_DataTypeVersion, true
	case 24037:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ProgramDiagnostic2DataType_DictionaryFragment, true
	case 24039:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ProgramDiagnostic2DataType, true
	case 24040:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ProgramDiagnostic2DataType_DataTypeVersion, true
	case 24041:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ProgramDiagnostic2DataType_DictionaryFragment, true
	case 24111:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PortableQualifiedName, true
	case 24112:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PortableQualifiedName_DataTypeVersion, true
	case 24113:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PortableQualifiedName_DictionaryFragment, true
	case 24114:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PortableNodeId, true
	case 24115:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PortableNodeId_DataTypeVersion, true
	case 24116:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PortableNodeId_DictionaryFragment, true
	case 24117:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UnsignedRationalNumber, true
	case 24118:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UnsignedRationalNumber_DataTypeVersion, true
	case 24119:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UnsignedRationalNumber_DictionaryFragment, true
	case 24123:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PortableQualifiedName, true
	case 24124:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PortableQualifiedName_DataTypeVersion, true
	case 24125:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PortableQualifiedName_DictionaryFragment, true
	case 24126:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PortableNodeId, true
	case 24127:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PortableNodeId_DataTypeVersion, true
	case 24128:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PortableNodeId_DictionaryFragment, true
	case 24129:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UnsignedRationalNumber, true
	case 24130:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UnsignedRationalNumber_DataTypeVersion, true
	case 24131:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UnsignedRationalNumber_DictionaryFragment, true
	case 24293:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserManagementDataType, true
	case 24294:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserManagementDataType_DataTypeVersion, true
	case 24295:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserManagementDataType_DictionaryFragment, true
	case 24297:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserManagementDataType, true
	case 24298:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserManagementDataType_DataTypeVersion, true
	case 24299:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserManagementDataType_DictionaryFragment, true
	case 25240:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PriorityMappingEntryType, true
	case 25241:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PriorityMappingEntryType_DataTypeVersion, true
	case 25242:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PriorityMappingEntryType_DictionaryFragment, true
	case 25244:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PriorityMappingEntryType, true
	case 25245:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PriorityMappingEntryType_DataTypeVersion, true
	case 25246:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PriorityMappingEntryType_DictionaryFragment, true
	case 25533:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetCustomSourceDataType, true
	case 25534:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetCustomSourceDataType_DataTypeVersion, true
	case 25535:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetCustomSourceDataType_DictionaryFragment, true
	case 25536:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubKeyPushTargetDataType, true
	case 25537:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubKeyPushTargetDataType_DataTypeVersion, true
	case 25538:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubKeyPushTargetDataType_DictionaryFragment, true
	case 25539:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationRefDataType, true
	case 25540:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationRefDataType_DataTypeVersion, true
	case 25541:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationRefDataType_DictionaryFragment, true
	case 25542:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationValueDataType, true
	case 25543:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationValueDataType_DataTypeVersion, true
	case 25544:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationValueDataType_DictionaryFragment, true
	case 25549:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetCustomSourceDataType, true
	case 25550:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetCustomSourceDataType_DataTypeVersion, true
	case 25551:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetCustomSourceDataType_DictionaryFragment, true
	case 25552:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubKeyPushTargetDataType, true
	case 25553:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubKeyPushTargetDataType_DataTypeVersion, true
	case 25554:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubKeyPushTargetDataType_DictionaryFragment, true
	case 25555:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationRefDataType, true
	case 25556:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationRefDataType_DataTypeVersion, true
	case 25557:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationRefDataType_DictionaryFragment, true
	case 25558:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationValueDataType, true
	case 25559:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationValueDataType_DataTypeVersion, true
	case 25560:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationValueDataType_DictionaryFragment, true
	case 32383:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransactionErrorType, true
	case 32384:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransactionErrorType_DataTypeVersion, true
	case 32385:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransactionErrorType_DictionaryFragment, true
	case 32387:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransactionErrorType, true
	case 32388:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransactionErrorType_DataTypeVersion, true
	case 32389:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransactionErrorType_DictionaryFragment, true
	case 32423:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BitFieldDefinition, true
	case 32424:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BitFieldDefinition_DataTypeVersion, true
	case 32425:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BitFieldDefinition_DictionaryFragment, true
	case 32427:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BitFieldDefinition, true
	case 32428:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BitFieldDefinition_DataTypeVersion, true
	case 32429:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BitFieldDefinition_DictionaryFragment, true
	case 32563:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AnnotationDataType, true
	case 32564:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AnnotationDataType_DataTypeVersion, true
	case 32565:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AnnotationDataType_DictionaryFragment, true
	case 32566:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_LinearConversionDataType, true
	case 32567:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_LinearConversionDataType_DataTypeVersion, true
	case 32568:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_LinearConversionDataType_DictionaryFragment, true
	case 32569:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_QuantityDimension, true
	case 32570:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_QuantityDimension_DataTypeVersion, true
	case 32571:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_QuantityDimension_DictionaryFragment, true
	case 32575:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AnnotationDataType, true
	case 32576:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AnnotationDataType_DataTypeVersion, true
	case 32577:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AnnotationDataType_DictionaryFragment, true
	case 32578:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_LinearConversionDataType, true
	case 32579:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_LinearConversionDataType_DataTypeVersion, true
	case 32580:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_LinearConversionDataType_DictionaryFragment, true
	case 32581:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_QuantityDimension, true
	case 32582:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_QuantityDimension_DataTypeVersion, true
	case 32583:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_QuantityDimension_DictionaryFragment, true
	case 32663:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReferenceDescriptionDataType, true
	case 32664:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReferenceDescriptionDataType_DataTypeVersion, true
	case 32665:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReferenceDescriptionDataType_DictionaryFragment, true
	case 32666:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReferenceListEntryDataType, true
	case 32667:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReferenceListEntryDataType_DataTypeVersion, true
	case 32668:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReferenceListEntryDataType_DictionaryFragment, true
	case 32671:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReferenceDescriptionDataType, true
	case 32672:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReferenceDescriptionDataType_DataTypeVersion, true
	case 32673:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReferenceDescriptionDataType_DictionaryFragment, true
	case 32674:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReferenceListEntryDataType, true
	case 32675:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReferenceListEntryDataType_DataTypeVersion, true
	case 32676:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReferenceListEntryDataType_DictionaryFragment, true
	case 32826:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryModifiedEvent, true
	case 32827:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryModifiedEvent_DataTypeVersion, true
	case 32828:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryModifiedEvent_DictionaryFragment, true
	case 32830:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryModifiedEvent, true
	case 32831:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryModifiedEvent_DataTypeVersion, true
	case 32832:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryModifiedEvent_DictionaryFragment, true
	case 7617:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema, true
	case 7618:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeVersion, true
	case 7619:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NamespaceUri, true
	case 7650:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Argument, true
	case 7651:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Argument_DataTypeVersion, true
	case 7652:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Argument_DictionaryFragment, true
	case 7656:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumValueType, true
	case 7657:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumValueType_DataTypeVersion, true
	case 7658:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumValueType_DictionaryFragment, true
	case 7659:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StatusResult, true
	case 7660:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StatusResult_DataTypeVersion, true
	case 7661:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StatusResult_DictionaryFragment, true
	case 7662:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserTokenPolicy, true
	case 7663:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserTokenPolicy_DataTypeVersion, true
	case 7664:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserTokenPolicy_DictionaryFragment, true
	case 7665:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ApplicationDescription, true
	case 7666:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ApplicationDescription_DataTypeVersion, true
	case 7667:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ApplicationDescription_DictionaryFragment, true
	case 7668:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointDescription, true
	case 7669:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointDescription_DataTypeVersion, true
	case 7670:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointDescription_DictionaryFragment, true
	case 7671:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserIdentityToken, true
	case 7672:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserIdentityToken_DataTypeVersion, true
	case 7673:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserIdentityToken_DictionaryFragment, true
	case 7674:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AnonymousIdentityToken, true
	case 7675:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AnonymousIdentityToken_DataTypeVersion, true
	case 7676:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AnonymousIdentityToken_DictionaryFragment, true
	case 7677:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserNameIdentityToken, true
	case 7678:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserNameIdentityToken_DataTypeVersion, true
	case 7679:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserNameIdentityToken_DictionaryFragment, true
	case 7680:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_X509IdentityToken, true
	case 7681:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_X509IdentityToken_DataTypeVersion, true
	case 7682:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_X509IdentityToken_DictionaryFragment, true
	case 7683:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_IssuedIdentityToken, true
	case 7684:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_IssuedIdentityToken_DataTypeVersion, true
	case 7685:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_IssuedIdentityToken_DictionaryFragment, true
	case 7686:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointConfiguration, true
	case 7687:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointConfiguration_DataTypeVersion, true
	case 7688:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointConfiguration_DictionaryFragment, true
	case 7692:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BuildInfo, true
	case 7693:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BuildInfo_DataTypeVersion, true
	case 7694:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BuildInfo_DictionaryFragment, true
	case 7698:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SignedSoftwareCertificate, true
	case 7699:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SignedSoftwareCertificate_DataTypeVersion, true
	case 7700:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SignedSoftwareCertificate_DictionaryFragment, true
	case 7728:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AddNodesItem, true
	case 7729:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AddNodesItem_DataTypeVersion, true
	case 7730:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AddNodesItem_DictionaryFragment, true
	case 7731:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AddReferencesItem, true
	case 7732:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AddReferencesItem_DataTypeVersion, true
	case 7733:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AddReferencesItem_DictionaryFragment, true
	case 7734:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DeleteNodesItem, true
	case 7735:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DeleteNodesItem_DataTypeVersion, true
	case 7736:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DeleteNodesItem_DictionaryFragment, true
	case 7737:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DeleteReferencesItem, true
	case 7738:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DeleteReferencesItem_DataTypeVersion, true
	case 7739:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DeleteReferencesItem_DictionaryFragment, true
	case 7782:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RegisteredServer, true
	case 7783:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RegisteredServer_DataTypeVersion, true
	case 7784:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RegisteredServer_DictionaryFragment, true
	case 7929:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ContentFilterElement, true
	case 7930:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ContentFilterElement_DataTypeVersion, true
	case 7931:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ContentFilterElement_DictionaryFragment, true
	case 7932:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ContentFilter, true
	case 7933:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ContentFilter_DataTypeVersion, true
	case 7934:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ContentFilter_DictionaryFragment, true
	case 7935:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FilterOperand, true
	case 7936:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FilterOperand_DataTypeVersion, true
	case 7937:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FilterOperand_DictionaryFragment, true
	case 7938:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ElementOperand, true
	case 7939:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ElementOperand_DataTypeVersion, true
	case 7940:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ElementOperand_DictionaryFragment, true
	case 7941:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_LiteralOperand, true
	case 7942:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_LiteralOperand_DataTypeVersion, true
	case 7943:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_LiteralOperand_DictionaryFragment, true
	case 7944:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AttributeOperand, true
	case 7945:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AttributeOperand_DataTypeVersion, true
	case 7946:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AttributeOperand_DictionaryFragment, true
	case 7947:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SimpleAttributeOperand, true
	case 7948:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SimpleAttributeOperand_DataTypeVersion, true
	case 7949:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SimpleAttributeOperand_DictionaryFragment, true
	case 8004:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryEvent, true
	case 8005:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryEvent_DataTypeVersion, true
	case 8006:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryEvent_DictionaryFragment, true
	case 8067:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_MonitoringFilter, true
	case 8068:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_MonitoringFilter_DataTypeVersion, true
	case 8069:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_MonitoringFilter_DictionaryFragment, true
	case 8073:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EventFilter, true
	case 8074:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EventFilter_DataTypeVersion, true
	case 8075:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EventFilter_DictionaryFragment, true
	case 8076:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AggregateConfiguration, true
	case 8077:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AggregateConfiguration_DataTypeVersion, true
	case 8078:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AggregateConfiguration_DictionaryFragment, true
	case 8172:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryEventFieldList, true
	case 8173:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryEventFieldList_DataTypeVersion, true
	case 8174:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryEventFieldList_DictionaryFragment, true
	case 8208:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RedundantServerDataType, true
	case 8209:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RedundantServerDataType_DataTypeVersion, true
	case 8210:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RedundantServerDataType_DictionaryFragment, true
	case 8211:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SamplingIntervalDiagnosticsDataType, true
	case 8212:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SamplingIntervalDiagnosticsDataType_DataTypeVersion, true
	case 8213:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SamplingIntervalDiagnosticsDataType_DictionaryFragment, true
	case 8214:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerDiagnosticsSummaryDataType, true
	case 8215:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerDiagnosticsSummaryDataType_DataTypeVersion, true
	case 8216:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerDiagnosticsSummaryDataType_DictionaryFragment, true
	case 8217:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerStatusDataType, true
	case 8218:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerStatusDataType_DataTypeVersion, true
	case 8219:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerStatusDataType_DictionaryFragment, true
	case 8220:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SessionDiagnosticsDataType, true
	case 8221:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SessionDiagnosticsDataType_DataTypeVersion, true
	case 8222:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SessionDiagnosticsDataType_DictionaryFragment, true
	case 8223:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SessionSecurityDiagnosticsDataType, true
	case 8224:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SessionSecurityDiagnosticsDataType_DataTypeVersion, true
	case 8225:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SessionSecurityDiagnosticsDataType_DictionaryFragment, true
	case 8226:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServiceCounterDataType, true
	case 8227:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServiceCounterDataType_DataTypeVersion, true
	case 8228:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServiceCounterDataType_DictionaryFragment, true
	case 8229:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscriptionDiagnosticsDataType, true
	case 8230:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscriptionDiagnosticsDataType_DataTypeVersion, true
	case 8231:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscriptionDiagnosticsDataType_DictionaryFragment, true
	case 8232:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ModelChangeStructureDataType, true
	case 8233:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ModelChangeStructureDataType_DataTypeVersion, true
	case 8234:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ModelChangeStructureDataType_DictionaryFragment, true
	case 8235:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SemanticChangeStructureDataType, true
	case 8236:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SemanticChangeStructureDataType_DataTypeVersion, true
	case 8237:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SemanticChangeStructureDataType_DictionaryFragment, true
	case 8238:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Range, true
	case 8239:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Range_DataTypeVersion, true
	case 8240:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Range_DictionaryFragment, true
	case 8241:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EUInformation, true
	case 8242:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EUInformation_DataTypeVersion, true
	case 8243:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EUInformation_DictionaryFragment, true
	case 8244:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Annotation, true
	case 8245:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Annotation_DataTypeVersion, true
	case 8246:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Annotation_DictionaryFragment, true
	case 8247:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ProgramDiagnosticDataType, true
	case 8248:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ProgramDiagnosticDataType_DataTypeVersion, true
	case 8249:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ProgramDiagnosticDataType_DictionaryFragment, true
	case 8252:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema, true
	case 8253:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeVersion, true
	case 8254:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NamespaceUri, true
	case 8285:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Argument, true
	case 8286:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Argument_DataTypeVersion, true
	case 8287:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Argument_DictionaryFragment, true
	case 8291:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumValueType, true
	case 8292:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumValueType_DataTypeVersion, true
	case 8293:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumValueType_DictionaryFragment, true
	case 8294:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StatusResult, true
	case 8295:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StatusResult_DataTypeVersion, true
	case 8296:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StatusResult_DictionaryFragment, true
	case 8297:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserTokenPolicy, true
	case 8298:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserTokenPolicy_DataTypeVersion, true
	case 8299:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserTokenPolicy_DictionaryFragment, true
	case 8300:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ApplicationDescription, true
	case 8301:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ApplicationDescription_DataTypeVersion, true
	case 8302:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ApplicationDescription_DictionaryFragment, true
	case 8303:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointDescription, true
	case 8304:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointDescription_DataTypeVersion, true
	case 8305:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointDescription_DictionaryFragment, true
	case 8306:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserIdentityToken, true
	case 8307:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserIdentityToken_DataTypeVersion, true
	case 8308:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserIdentityToken_DictionaryFragment, true
	case 8309:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AnonymousIdentityToken, true
	case 8310:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AnonymousIdentityToken_DataTypeVersion, true
	case 8311:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AnonymousIdentityToken_DictionaryFragment, true
	case 8312:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserNameIdentityToken, true
	case 8313:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserNameIdentityToken_DataTypeVersion, true
	case 8314:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserNameIdentityToken_DictionaryFragment, true
	case 8315:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_X509IdentityToken, true
	case 8316:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_X509IdentityToken_DataTypeVersion, true
	case 8317:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_X509IdentityToken_DictionaryFragment, true
	case 8318:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_IssuedIdentityToken, true
	case 8319:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_IssuedIdentityToken_DataTypeVersion, true
	case 8320:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_IssuedIdentityToken_DictionaryFragment, true
	case 8321:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointConfiguration, true
	case 8322:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointConfiguration_DataTypeVersion, true
	case 8323:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointConfiguration_DictionaryFragment, true
	case 8327:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BuildInfo, true
	case 8328:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BuildInfo_DataTypeVersion, true
	case 8329:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BuildInfo_DictionaryFragment, true
	case 8333:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SignedSoftwareCertificate, true
	case 8334:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SignedSoftwareCertificate_DataTypeVersion, true
	case 8335:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SignedSoftwareCertificate_DictionaryFragment, true
	case 8363:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AddNodesItem, true
	case 8364:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AddNodesItem_DataTypeVersion, true
	case 8365:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AddNodesItem_DictionaryFragment, true
	case 8366:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AddReferencesItem, true
	case 8367:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AddReferencesItem_DataTypeVersion, true
	case 8368:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AddReferencesItem_DictionaryFragment, true
	case 8369:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DeleteNodesItem, true
	case 8370:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DeleteNodesItem_DataTypeVersion, true
	case 8371:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DeleteNodesItem_DictionaryFragment, true
	case 8372:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DeleteReferencesItem, true
	case 8373:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DeleteReferencesItem_DataTypeVersion, true
	case 8374:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DeleteReferencesItem_DictionaryFragment, true
	case 8417:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RegisteredServer, true
	case 8418:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RegisteredServer_DataTypeVersion, true
	case 8419:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RegisteredServer_DictionaryFragment, true
	case 8564:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ContentFilterElement, true
	case 8565:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ContentFilterElement_DataTypeVersion, true
	case 8566:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ContentFilterElement_DictionaryFragment, true
	case 8567:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ContentFilter, true
	case 8568:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ContentFilter_DataTypeVersion, true
	case 8569:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ContentFilter_DictionaryFragment, true
	case 8570:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FilterOperand, true
	case 8571:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FilterOperand_DataTypeVersion, true
	case 8572:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FilterOperand_DictionaryFragment, true
	case 8573:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ElementOperand, true
	case 8574:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ElementOperand_DataTypeVersion, true
	case 8575:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ElementOperand_DictionaryFragment, true
	case 8576:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_LiteralOperand, true
	case 8577:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_LiteralOperand_DataTypeVersion, true
	case 8578:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_LiteralOperand_DictionaryFragment, true
	case 8579:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AttributeOperand, true
	case 8580:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AttributeOperand_DataTypeVersion, true
	case 8581:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AttributeOperand_DictionaryFragment, true
	case 8582:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SimpleAttributeOperand, true
	case 8583:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SimpleAttributeOperand_DataTypeVersion, true
	case 8584:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SimpleAttributeOperand_DictionaryFragment, true
	case 8639:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryEvent, true
	case 8640:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryEvent_DataTypeVersion, true
	case 8641:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryEvent_DictionaryFragment, true
	case 8702:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_MonitoringFilter, true
	case 8703:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_MonitoringFilter_DataTypeVersion, true
	case 8704:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_MonitoringFilter_DictionaryFragment, true
	case 8708:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EventFilter, true
	case 8709:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EventFilter_DataTypeVersion, true
	case 8710:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EventFilter_DictionaryFragment, true
	case 8711:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AggregateConfiguration, true
	case 8712:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AggregateConfiguration_DataTypeVersion, true
	case 8713:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AggregateConfiguration_DictionaryFragment, true
	case 8807:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryEventFieldList, true
	case 8808:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryEventFieldList_DataTypeVersion, true
	case 8809:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryEventFieldList_DictionaryFragment, true
	case 8843:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RedundantServerDataType, true
	case 8844:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RedundantServerDataType_DataTypeVersion, true
	case 8845:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RedundantServerDataType_DictionaryFragment, true
	case 8846:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SamplingIntervalDiagnosticsDataType, true
	case 8847:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SamplingIntervalDiagnosticsDataType_DataTypeVersion, true
	case 8848:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SamplingIntervalDiagnosticsDataType_DictionaryFragment, true
	case 8849:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerDiagnosticsSummaryDataType, true
	case 8850:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerDiagnosticsSummaryDataType_DataTypeVersion, true
	case 8851:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerDiagnosticsSummaryDataType_DictionaryFragment, true
	case 8852:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerStatusDataType, true
	case 8853:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerStatusDataType_DataTypeVersion, true
	case 8854:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerStatusDataType_DictionaryFragment, true
	case 8855:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SessionDiagnosticsDataType, true
	case 8856:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SessionDiagnosticsDataType_DataTypeVersion, true
	case 8857:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SessionDiagnosticsDataType_DictionaryFragment, true
	case 8858:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SessionSecurityDiagnosticsDataType, true
	case 8859:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SessionSecurityDiagnosticsDataType_DataTypeVersion, true
	case 8860:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SessionSecurityDiagnosticsDataType_DictionaryFragment, true
	case 8861:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServiceCounterDataType, true
	case 8862:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServiceCounterDataType_DataTypeVersion, true
	case 8863:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServiceCounterDataType_DictionaryFragment, true
	case 8864:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscriptionDiagnosticsDataType, true
	case 8865:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscriptionDiagnosticsDataType_DataTypeVersion, true
	case 8866:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscriptionDiagnosticsDataType_DictionaryFragment, true
	case 8867:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ModelChangeStructureDataType, true
	case 8868:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ModelChangeStructureDataType_DataTypeVersion, true
	case 8869:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ModelChangeStructureDataType_DictionaryFragment, true
	case 8870:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SemanticChangeStructureDataType, true
	case 8871:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SemanticChangeStructureDataType_DataTypeVersion, true
	case 8872:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SemanticChangeStructureDataType_DictionaryFragment, true
	case 8873:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Range, true
	case 8874:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Range_DataTypeVersion, true
	case 8875:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Range_DictionaryFragment, true
	case 8876:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EUInformation, true
	case 8877:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EUInformation_DataTypeVersion, true
	case 8878:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EUInformation_DictionaryFragment, true
	case 8879:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Annotation, true
	case 8880:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Annotation_DataTypeVersion, true
	case 8881:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Annotation_DictionaryFragment, true
	case 8882:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ProgramDiagnosticDataType, true
	case 8883:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ProgramDiagnosticDataType_DataTypeVersion, true
	case 8884:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ProgramDiagnosticDataType_DictionaryFragment, true
	case 8914:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TimeZoneDataType, true
	case 8915:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TimeZoneDataType_DataTypeVersion, true
	case 8916:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TimeZoneDataType_DictionaryFragment, true
	case 8918:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TimeZoneDataType, true
	case 8919:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TimeZoneDataType_DataTypeVersion, true
	case 8920:
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TimeZoneDataType_DictionaryFragment, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableOpcByName(value string) (enum OpcuaNodeIdServicesVariableOpc, ok bool) {
	switch value {
	case "OpcUa_XmlSchema_EndpointUrlListDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointUrlListDataType, true
	case "OpcUa_XmlSchema_EndpointUrlListDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointUrlListDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_EndpointUrlListDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointUrlListDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_NetworkGroupDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkGroupDataType, true
	case "OpcUa_XmlSchema_NetworkGroupDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkGroupDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_NetworkGroupDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkGroupDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_EndpointUrlListDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointUrlListDataType, true
	case "OpcUa_BinarySchema_EndpointUrlListDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointUrlListDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_EndpointUrlListDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointUrlListDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_NetworkGroupDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkGroupDataType, true
	case "OpcUa_BinarySchema_NetworkGroupDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkGroupDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_NetworkGroupDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkGroupDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_AxisInformation":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AxisInformation, true
	case "OpcUa_XmlSchema_AxisInformation_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AxisInformation_DataTypeVersion, true
	case "OpcUa_XmlSchema_AxisInformation_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AxisInformation_DictionaryFragment, true
	case "OpcUa_XmlSchema_XVType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_XVType, true
	case "OpcUa_XmlSchema_XVType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_XVType_DataTypeVersion, true
	case "OpcUa_XmlSchema_XVType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_XVType_DictionaryFragment, true
	case "OpcUa_BinarySchema_AxisInformation":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AxisInformation, true
	case "OpcUa_BinarySchema_AxisInformation_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AxisInformation_DataTypeVersion, true
	case "OpcUa_BinarySchema_AxisInformation_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AxisInformation_DictionaryFragment, true
	case "OpcUa_BinarySchema_XVType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_XVType, true
	case "OpcUa_BinarySchema_XVType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_XVType_DataTypeVersion, true
	case "OpcUa_BinarySchema_XVType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_XVType_DictionaryFragment, true
	case "OpcUa_XmlSchema_ComplexNumberType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ComplexNumberType, true
	case "OpcUa_XmlSchema_ComplexNumberType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ComplexNumberType_DataTypeVersion, true
	case "OpcUa_XmlSchema_ComplexNumberType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ComplexNumberType_DictionaryFragment, true
	case "OpcUa_XmlSchema_DoubleComplexNumberType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DoubleComplexNumberType, true
	case "OpcUa_XmlSchema_DoubleComplexNumberType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DoubleComplexNumberType_DataTypeVersion, true
	case "OpcUa_XmlSchema_DoubleComplexNumberType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DoubleComplexNumberType_DictionaryFragment, true
	case "OpcUa_BinarySchema_ComplexNumberType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ComplexNumberType, true
	case "OpcUa_BinarySchema_ComplexNumberType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ComplexNumberType_DataTypeVersion, true
	case "OpcUa_BinarySchema_ComplexNumberType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ComplexNumberType_DictionaryFragment, true
	case "OpcUa_BinarySchema_DoubleComplexNumberType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DoubleComplexNumberType, true
	case "OpcUa_BinarySchema_DoubleComplexNumberType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DoubleComplexNumberType_DataTypeVersion, true
	case "OpcUa_BinarySchema_DoubleComplexNumberType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DoubleComplexNumberType_DictionaryFragment, true
	case "OpcUa_XmlSchema_ServerOnNetwork":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerOnNetwork, true
	case "OpcUa_XmlSchema_ServerOnNetwork_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerOnNetwork_DataTypeVersion, true
	case "OpcUa_XmlSchema_ServerOnNetwork_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerOnNetwork_DictionaryFragment, true
	case "OpcUa_BinarySchema_ServerOnNetwork":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerOnNetwork, true
	case "OpcUa_BinarySchema_ServerOnNetwork_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerOnNetwork_DataTypeVersion, true
	case "OpcUa_BinarySchema_ServerOnNetwork_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerOnNetwork_DictionaryFragment, true
	case "OpcUa_XmlSchema_TrustListDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TrustListDataType, true
	case "OpcUa_XmlSchema_TrustListDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TrustListDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_TrustListDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TrustListDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_TrustListDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TrustListDataType, true
	case "OpcUa_BinarySchema_TrustListDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TrustListDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_TrustListDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TrustListDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_RelativePathElement":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RelativePathElement, true
	case "OpcUa_XmlSchema_RelativePathElement_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RelativePathElement_DataTypeVersion, true
	case "OpcUa_XmlSchema_RelativePathElement_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RelativePathElement_DictionaryFragment, true
	case "OpcUa_XmlSchema_RelativePath":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RelativePath, true
	case "OpcUa_XmlSchema_RelativePath_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RelativePath_DataTypeVersion, true
	case "OpcUa_XmlSchema_RelativePath_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RelativePath_DictionaryFragment, true
	case "OpcUa_BinarySchema_RelativePathElement":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RelativePathElement, true
	case "OpcUa_BinarySchema_RelativePathElement_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RelativePathElement_DataTypeVersion, true
	case "OpcUa_BinarySchema_RelativePathElement_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RelativePathElement_DictionaryFragment, true
	case "OpcUa_BinarySchema_RelativePath":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RelativePath, true
	case "OpcUa_BinarySchema_RelativePath_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RelativePath_DataTypeVersion, true
	case "OpcUa_BinarySchema_RelativePath_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RelativePath_DictionaryFragment, true
	case "OpcUa_XmlSchema_OptionSet":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_OptionSet, true
	case "OpcUa_XmlSchema_OptionSet_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_OptionSet_DataTypeVersion, true
	case "OpcUa_XmlSchema_OptionSet_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_OptionSet_DictionaryFragment, true
	case "OpcUa_XmlSchema_Union":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Union, true
	case "OpcUa_XmlSchema_Union_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Union_DataTypeVersion, true
	case "OpcUa_XmlSchema_Union_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Union_DictionaryFragment, true
	case "OpcUa_BinarySchema_OptionSet":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_OptionSet, true
	case "OpcUa_BinarySchema_OptionSet_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_OptionSet_DataTypeVersion, true
	case "OpcUa_BinarySchema_OptionSet_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_OptionSet_DictionaryFragment, true
	case "OpcUa_BinarySchema_Union":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Union, true
	case "OpcUa_BinarySchema_Union_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Union_DataTypeVersion, true
	case "OpcUa_BinarySchema_Union_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Union_DictionaryFragment, true
	case "OpcUa_XmlSchema_DiscoveryConfiguration":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DiscoveryConfiguration, true
	case "OpcUa_XmlSchema_DiscoveryConfiguration_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DiscoveryConfiguration_DataTypeVersion, true
	case "OpcUa_XmlSchema_DiscoveryConfiguration_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DiscoveryConfiguration_DictionaryFragment, true
	case "OpcUa_XmlSchema_MdnsDiscoveryConfiguration":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_MdnsDiscoveryConfiguration, true
	case "OpcUa_XmlSchema_MdnsDiscoveryConfiguration_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_MdnsDiscoveryConfiguration_DataTypeVersion, true
	case "OpcUa_XmlSchema_MdnsDiscoveryConfiguration_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_MdnsDiscoveryConfiguration_DictionaryFragment, true
	case "OpcUa_BinarySchema_DiscoveryConfiguration":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DiscoveryConfiguration, true
	case "OpcUa_BinarySchema_DiscoveryConfiguration_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DiscoveryConfiguration_DataTypeVersion, true
	case "OpcUa_BinarySchema_DiscoveryConfiguration_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DiscoveryConfiguration_DictionaryFragment, true
	case "OpcUa_BinarySchema_MdnsDiscoveryConfiguration":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_MdnsDiscoveryConfiguration, true
	case "OpcUa_BinarySchema_MdnsDiscoveryConfiguration_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_MdnsDiscoveryConfiguration_DataTypeVersion, true
	case "OpcUa_BinarySchema_MdnsDiscoveryConfiguration_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_MdnsDiscoveryConfiguration_DictionaryFragment, true
	case "OpcUa_XmlSchema_PublishedVariableDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedVariableDataType, true
	case "OpcUa_XmlSchema_PublishedVariableDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedVariableDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_PublishedVariableDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedVariableDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_PublishedVariableDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedVariableDataType, true
	case "OpcUa_BinarySchema_PublishedVariableDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedVariableDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_PublishedVariableDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedVariableDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_DataSetMetaDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetMetaDataType, true
	case "OpcUa_XmlSchema_DataSetMetaDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetMetaDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_DataSetMetaDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetMetaDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_FieldMetaData":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FieldMetaData, true
	case "OpcUa_XmlSchema_FieldMetaData_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FieldMetaData_DataTypeVersion, true
	case "OpcUa_XmlSchema_FieldMetaData_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FieldMetaData_DictionaryFragment, true
	case "OpcUa_XmlSchema_DataTypeDescription":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeDescription, true
	case "OpcUa_XmlSchema_DataTypeDescription_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeDescription_DataTypeVersion, true
	case "OpcUa_XmlSchema_DataTypeDescription_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeDescription_DictionaryFragment, true
	case "OpcUa_XmlSchema_EnumField":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumField, true
	case "OpcUa_XmlSchema_EnumField_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumField_DataTypeVersion, true
	case "OpcUa_XmlSchema_EnumField_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumField_DictionaryFragment, true
	case "OpcUa_XmlSchema_KeyValuePair":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_KeyValuePair, true
	case "OpcUa_XmlSchema_KeyValuePair_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_KeyValuePair_DataTypeVersion, true
	case "OpcUa_XmlSchema_KeyValuePair_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_KeyValuePair_DictionaryFragment, true
	case "OpcUa_XmlSchema_ConfigurationVersionDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ConfigurationVersionDataType, true
	case "OpcUa_XmlSchema_ConfigurationVersionDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ConfigurationVersionDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_ConfigurationVersionDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ConfigurationVersionDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_FieldTargetDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FieldTargetDataType, true
	case "OpcUa_XmlSchema_FieldTargetDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FieldTargetDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_FieldTargetDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FieldTargetDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_DataSetMetaDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetMetaDataType, true
	case "OpcUa_BinarySchema_DataSetMetaDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetMetaDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_DataSetMetaDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetMetaDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_FieldMetaData":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FieldMetaData, true
	case "OpcUa_BinarySchema_FieldMetaData_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FieldMetaData_DataTypeVersion, true
	case "OpcUa_BinarySchema_FieldMetaData_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FieldMetaData_DictionaryFragment, true
	case "OpcUa_BinarySchema_DataTypeDescription":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeDescription, true
	case "OpcUa_BinarySchema_DataTypeDescription_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeDescription_DataTypeVersion, true
	case "OpcUa_BinarySchema_DataTypeDescription_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeDescription_DictionaryFragment, true
	case "OpcUa_BinarySchema_EnumField":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumField, true
	case "OpcUa_BinarySchema_EnumField_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumField_DataTypeVersion, true
	case "OpcUa_BinarySchema_EnumField_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumField_DictionaryFragment, true
	case "OpcUa_BinarySchema_KeyValuePair":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_KeyValuePair, true
	case "OpcUa_BinarySchema_KeyValuePair_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_KeyValuePair_DataTypeVersion, true
	case "OpcUa_BinarySchema_KeyValuePair_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_KeyValuePair_DictionaryFragment, true
	case "OpcUa_BinarySchema_ConfigurationVersionDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ConfigurationVersionDataType, true
	case "OpcUa_BinarySchema_ConfigurationVersionDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ConfigurationVersionDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_ConfigurationVersionDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ConfigurationVersionDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_FieldTargetDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FieldTargetDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_FieldTargetDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FieldTargetDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_ModificationInfo":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ModificationInfo, true
	case "OpcUa_BinarySchema_ModificationInfo_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ModificationInfo_DataTypeVersion, true
	case "OpcUa_BinarySchema_ModificationInfo_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ModificationInfo_DictionaryFragment, true
	case "OpcUa_XmlSchema_ModificationInfo":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ModificationInfo, true
	case "OpcUa_XmlSchema_ModificationInfo_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ModificationInfo_DataTypeVersion, true
	case "OpcUa_XmlSchema_ModificationInfo_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ModificationInfo_DictionaryFragment, true
	case "OpcUa_BinarySchema_Deprecated":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Deprecated, true
	case "OpcUa_XmlSchema_Deprecated":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Deprecated, true
	case "OpcUa_BinarySchema_SimpleTypeDescription":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SimpleTypeDescription, true
	case "OpcUa_BinarySchema_SimpleTypeDescription_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SimpleTypeDescription_DataTypeVersion, true
	case "OpcUa_BinarySchema_SimpleTypeDescription_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SimpleTypeDescription_DictionaryFragment, true
	case "OpcUa_BinarySchema_UABinaryFileDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UABinaryFileDataType, true
	case "OpcUa_BinarySchema_UABinaryFileDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UABinaryFileDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_UABinaryFileDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UABinaryFileDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_BrokerConnectionTransportDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerConnectionTransportDataType, true
	case "OpcUa_BinarySchema_BrokerConnectionTransportDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerConnectionTransportDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_BrokerConnectionTransportDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerConnectionTransportDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_SimpleTypeDescription":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SimpleTypeDescription, true
	case "OpcUa_XmlSchema_SimpleTypeDescription_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SimpleTypeDescription_DataTypeVersion, true
	case "OpcUa_XmlSchema_SimpleTypeDescription_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SimpleTypeDescription_DictionaryFragment, true
	case "OpcUa_XmlSchema_UABinaryFileDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UABinaryFileDataType, true
	case "OpcUa_XmlSchema_StructureDescription":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureDescription, true
	case "OpcUa_XmlSchema_StructureDescription_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureDescription_DataTypeVersion, true
	case "OpcUa_XmlSchema_StructureDescription_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureDescription_DictionaryFragment, true
	case "OpcUa_XmlSchema_EnumDescription":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumDescription, true
	case "OpcUa_XmlSchema_EnumDescription_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumDescription_DataTypeVersion, true
	case "OpcUa_XmlSchema_EnumDescription_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumDescription_DictionaryFragment, true
	case "OpcUa_BinarySchema_StructureDescription":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureDescription, true
	case "OpcUa_BinarySchema_StructureDescription_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureDescription_DataTypeVersion, true
	case "OpcUa_BinarySchema_StructureDescription_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureDescription_DictionaryFragment, true
	case "OpcUa_BinarySchema_EnumDescription":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumDescription, true
	case "OpcUa_BinarySchema_EnumDescription_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumDescription_DataTypeVersion, true
	case "OpcUa_BinarySchema_EnumDescription_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumDescription_DictionaryFragment, true
	case "OpcUa_XmlSchema_UABinaryFileDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UABinaryFileDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_UABinaryFileDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UABinaryFileDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_BrokerConnectionTransportDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerConnectionTransportDataType, true
	case "OpcUa_XmlSchema_BrokerConnectionTransportDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerConnectionTransportDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_BrokerConnectionTransportDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerConnectionTransportDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_IdentityMappingRuleType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_IdentityMappingRuleType, true
	case "OpcUa_XmlSchema_IdentityMappingRuleType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_IdentityMappingRuleType_DataTypeVersion, true
	case "OpcUa_XmlSchema_IdentityMappingRuleType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_IdentityMappingRuleType_DictionaryFragment, true
	case "OpcUa_BinarySchema_EndpointType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointType, true
	case "OpcUa_BinarySchema_EndpointType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointType_DataTypeVersion, true
	case "OpcUa_BinarySchema_EndpointType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointType_DictionaryFragment, true
	case "OpcUa_BinarySchema_IdentityMappingRuleType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_IdentityMappingRuleType, true
	case "OpcUa_BinarySchema_IdentityMappingRuleType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_IdentityMappingRuleType_DataTypeVersion, true
	case "OpcUa_BinarySchema_IdentityMappingRuleType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_IdentityMappingRuleType_DictionaryFragment, true
	case "OpcUa_BinarySchema_DataTypeSchemaHeader":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeSchemaHeader, true
	case "OpcUa_BinarySchema_DataTypeSchemaHeader_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeSchemaHeader_DataTypeVersion, true
	case "OpcUa_BinarySchema_DataTypeSchemaHeader_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeSchemaHeader_DictionaryFragment, true
	case "OpcUa_BinarySchema_PublishedDataSetDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetDataType, true
	case "OpcUa_BinarySchema_PublishedDataSetDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_PublishedDataSetDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_PublishedDataSetSourceDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetSourceDataType, true
	case "OpcUa_BinarySchema_PublishedDataSetSourceDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetSourceDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_PublishedDataSetSourceDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetSourceDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_PublishedDataItemsDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataItemsDataType, true
	case "OpcUa_BinarySchema_PublishedDataItemsDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataItemsDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_PublishedDataItemsDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataItemsDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_PublishedEventsDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedEventsDataType, true
	case "OpcUa_BinarySchema_PublishedEventsDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedEventsDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_PublishedEventsDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedEventsDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_DataSetWriterDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterDataType, true
	case "OpcUa_BinarySchema_DataSetWriterDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_DataSetWriterDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_DataSetWriterTransportDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterTransportDataType, true
	case "OpcUa_BinarySchema_DataSetWriterTransportDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterTransportDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_DataSetWriterTransportDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterTransportDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_DataSetWriterMessageDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterMessageDataType, true
	case "OpcUa_BinarySchema_DataSetWriterMessageDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterMessageDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_DataSetWriterMessageDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterMessageDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_PubSubGroupDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubGroupDataType, true
	case "OpcUa_BinarySchema_PubSubGroupDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubGroupDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_PubSubGroupDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubGroupDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_WriterGroupTransportDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupTransportDataType, true
	case "OpcUa_BinarySchema_WriterGroupTransportDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupTransportDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_WriterGroupTransportDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupTransportDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_WriterGroupMessageDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupMessageDataType, true
	case "OpcUa_BinarySchema_WriterGroupMessageDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupMessageDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_WriterGroupMessageDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupMessageDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_PubSubConnectionDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConnectionDataType, true
	case "OpcUa_BinarySchema_PubSubConnectionDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConnectionDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_PubSubConnectionDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConnectionDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_ConnectionTransportDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ConnectionTransportDataType, true
	case "OpcUa_BinarySchema_ConnectionTransportDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ConnectionTransportDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_ConnectionTransportDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ConnectionTransportDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_ReaderGroupTransportDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupTransportDataType, true
	case "OpcUa_BinarySchema_ReaderGroupTransportDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupTransportDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_ReaderGroupTransportDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupTransportDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_ReaderGroupMessageDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupMessageDataType, true
	case "OpcUa_BinarySchema_ReaderGroupMessageDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupMessageDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_ReaderGroupMessageDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupMessageDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_DataSetReaderDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderDataType, true
	case "OpcUa_BinarySchema_DataSetReaderDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_DataSetReaderDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_DataSetReaderTransportDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderTransportDataType, true
	case "OpcUa_BinarySchema_DataSetReaderTransportDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderTransportDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_DataSetReaderTransportDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderTransportDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_DataSetReaderMessageDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderMessageDataType, true
	case "OpcUa_BinarySchema_DataSetReaderMessageDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderMessageDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_DataSetReaderMessageDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderMessageDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_SubscribedDataSetDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscribedDataSetDataType, true
	case "OpcUa_BinarySchema_SubscribedDataSetDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscribedDataSetDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_SubscribedDataSetDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscribedDataSetDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_TargetVariablesDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TargetVariablesDataType, true
	case "OpcUa_BinarySchema_TargetVariablesDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TargetVariablesDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_TargetVariablesDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TargetVariablesDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_SubscribedDataSetMirrorDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscribedDataSetMirrorDataType, true
	case "OpcUa_BinarySchema_SubscribedDataSetMirrorDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscribedDataSetMirrorDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_SubscribedDataSetMirrorDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscribedDataSetMirrorDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_UadpWriterGroupMessageDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpWriterGroupMessageDataType, true
	case "OpcUa_BinarySchema_UadpWriterGroupMessageDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpWriterGroupMessageDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_UadpWriterGroupMessageDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpWriterGroupMessageDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_UadpDataSetWriterMessageDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpDataSetWriterMessageDataType, true
	case "OpcUa_BinarySchema_UadpDataSetWriterMessageDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpDataSetWriterMessageDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_UadpDataSetWriterMessageDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpDataSetWriterMessageDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_UadpDataSetReaderMessageDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpDataSetReaderMessageDataType, true
	case "OpcUa_BinarySchema_UadpDataSetReaderMessageDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpDataSetReaderMessageDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_UadpDataSetReaderMessageDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpDataSetReaderMessageDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_JsonWriterGroupMessageDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonWriterGroupMessageDataType, true
	case "OpcUa_BinarySchema_JsonWriterGroupMessageDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonWriterGroupMessageDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_JsonWriterGroupMessageDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonWriterGroupMessageDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_JsonDataSetWriterMessageDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonDataSetWriterMessageDataType, true
	case "OpcUa_BinarySchema_JsonDataSetWriterMessageDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonDataSetWriterMessageDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_JsonDataSetWriterMessageDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonDataSetWriterMessageDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_JsonDataSetReaderMessageDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonDataSetReaderMessageDataType, true
	case "OpcUa_BinarySchema_JsonDataSetReaderMessageDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonDataSetReaderMessageDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_JsonDataSetReaderMessageDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonDataSetReaderMessageDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_BrokerWriterGroupTransportDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerWriterGroupTransportDataType, true
	case "OpcUa_BinarySchema_BrokerWriterGroupTransportDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerWriterGroupTransportDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_BrokerWriterGroupTransportDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerWriterGroupTransportDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_BrokerDataSetWriterTransportDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerDataSetWriterTransportDataType, true
	case "OpcUa_BinarySchema_BrokerDataSetWriterTransportDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerDataSetWriterTransportDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_BrokerDataSetWriterTransportDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerDataSetWriterTransportDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_BrokerDataSetReaderTransportDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerDataSetReaderTransportDataType, true
	case "OpcUa_BinarySchema_BrokerDataSetReaderTransportDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerDataSetReaderTransportDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_BrokerDataSetReaderTransportDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerDataSetReaderTransportDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_EndpointType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointType, true
	case "OpcUa_XmlSchema_EndpointType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointType_DataTypeVersion, true
	case "OpcUa_XmlSchema_EndpointType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointType_DictionaryFragment, true
	case "OpcUa_XmlSchema_DataTypeSchemaHeader":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeSchemaHeader, true
	case "OpcUa_XmlSchema_DataTypeSchemaHeader_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeSchemaHeader_DataTypeVersion, true
	case "OpcUa_XmlSchema_DataTypeSchemaHeader_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeSchemaHeader_DictionaryFragment, true
	case "OpcUa_XmlSchema_PublishedDataSetDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetDataType, true
	case "OpcUa_XmlSchema_PublishedDataSetDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_PublishedDataSetDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_PublishedDataSetSourceDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetSourceDataType, true
	case "OpcUa_XmlSchema_PublishedDataSetSourceDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetSourceDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_PublishedDataSetSourceDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetSourceDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_PublishedDataItemsDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataItemsDataType, true
	case "OpcUa_XmlSchema_PublishedDataItemsDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataItemsDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_PublishedDataItemsDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataItemsDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_PublishedEventsDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedEventsDataType, true
	case "OpcUa_XmlSchema_PublishedEventsDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedEventsDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_PublishedEventsDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedEventsDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_DataSetWriterDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterDataType, true
	case "OpcUa_XmlSchema_DataSetWriterDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_DataSetWriterDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_DataSetWriterTransportDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterTransportDataType, true
	case "OpcUa_XmlSchema_DataSetWriterTransportDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterTransportDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_DataSetWriterTransportDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterTransportDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_DataSetWriterMessageDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterMessageDataType, true
	case "OpcUa_XmlSchema_DataSetWriterMessageDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterMessageDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_DataSetWriterMessageDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterMessageDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_PubSubGroupDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubGroupDataType, true
	case "OpcUa_XmlSchema_PubSubGroupDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubGroupDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_PubSubGroupDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubGroupDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_WriterGroupTransportDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupTransportDataType, true
	case "OpcUa_XmlSchema_WriterGroupTransportDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupTransportDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_WriterGroupTransportDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupTransportDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_WriterGroupMessageDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupMessageDataType, true
	case "OpcUa_XmlSchema_WriterGroupMessageDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupMessageDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_WriterGroupMessageDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupMessageDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_PubSubConnectionDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConnectionDataType, true
	case "OpcUa_XmlSchema_PubSubConnectionDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConnectionDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_PubSubConnectionDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConnectionDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_ConnectionTransportDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ConnectionTransportDataType, true
	case "OpcUa_XmlSchema_ConnectionTransportDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ConnectionTransportDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_ConnectionTransportDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ConnectionTransportDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_ReaderGroupTransportDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupTransportDataType, true
	case "OpcUa_XmlSchema_ReaderGroupTransportDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupTransportDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_ReaderGroupTransportDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupTransportDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_ReaderGroupMessageDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupMessageDataType, true
	case "OpcUa_XmlSchema_ReaderGroupMessageDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupMessageDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_ReaderGroupMessageDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupMessageDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_DataSetReaderDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderDataType, true
	case "OpcUa_XmlSchema_DataSetReaderDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_DataSetReaderDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_DataSetReaderTransportDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderTransportDataType, true
	case "OpcUa_XmlSchema_DataSetReaderTransportDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderTransportDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_DataSetReaderTransportDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderTransportDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_DataSetReaderMessageDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderMessageDataType, true
	case "OpcUa_XmlSchema_DataSetReaderMessageDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderMessageDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_DataSetReaderMessageDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderMessageDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_SubscribedDataSetDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscribedDataSetDataType, true
	case "OpcUa_XmlSchema_SubscribedDataSetDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscribedDataSetDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_SubscribedDataSetDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscribedDataSetDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_TargetVariablesDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TargetVariablesDataType, true
	case "OpcUa_XmlSchema_TargetVariablesDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TargetVariablesDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_TargetVariablesDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TargetVariablesDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_SubscribedDataSetMirrorDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscribedDataSetMirrorDataType, true
	case "OpcUa_XmlSchema_SubscribedDataSetMirrorDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscribedDataSetMirrorDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_SubscribedDataSetMirrorDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscribedDataSetMirrorDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_UadpWriterGroupMessageDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpWriterGroupMessageDataType, true
	case "OpcUa_XmlSchema_UadpWriterGroupMessageDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpWriterGroupMessageDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_UadpWriterGroupMessageDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpWriterGroupMessageDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_UadpDataSetWriterMessageDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpDataSetWriterMessageDataType, true
	case "OpcUa_XmlSchema_UadpDataSetWriterMessageDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpDataSetWriterMessageDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_UadpDataSetWriterMessageDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpDataSetWriterMessageDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_UadpDataSetReaderMessageDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpDataSetReaderMessageDataType, true
	case "OpcUa_XmlSchema_UadpDataSetReaderMessageDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpDataSetReaderMessageDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_UadpDataSetReaderMessageDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpDataSetReaderMessageDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_JsonWriterGroupMessageDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonWriterGroupMessageDataType, true
	case "OpcUa_XmlSchema_JsonWriterGroupMessageDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonWriterGroupMessageDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_JsonWriterGroupMessageDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonWriterGroupMessageDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_JsonDataSetWriterMessageDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonDataSetWriterMessageDataType, true
	case "OpcUa_XmlSchema_JsonDataSetWriterMessageDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonDataSetWriterMessageDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_JsonDataSetWriterMessageDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonDataSetWriterMessageDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_JsonDataSetReaderMessageDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonDataSetReaderMessageDataType, true
	case "OpcUa_XmlSchema_JsonDataSetReaderMessageDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonDataSetReaderMessageDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_JsonDataSetReaderMessageDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonDataSetReaderMessageDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_BrokerWriterGroupTransportDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerWriterGroupTransportDataType, true
	case "OpcUa_XmlSchema_RolePermissionType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RolePermissionType, true
	case "OpcUa_XmlSchema_RolePermissionType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RolePermissionType_DataTypeVersion, true
	case "OpcUa_XmlSchema_RolePermissionType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RolePermissionType_DictionaryFragment, true
	case "OpcUa_XmlSchema_BrokerWriterGroupTransportDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerWriterGroupTransportDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_RolePermissionType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RolePermissionType, true
	case "OpcUa_BinarySchema_RolePermissionType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RolePermissionType_DataTypeVersion, true
	case "OpcUa_BinarySchema_RolePermissionType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RolePermissionType_DictionaryFragment, true
	case "OpcUa_XmlSchema_BrokerWriterGroupTransportDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerWriterGroupTransportDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_BrokerDataSetWriterTransportDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerDataSetWriterTransportDataType, true
	case "OpcUa_XmlSchema_BrokerDataSetWriterTransportDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerDataSetWriterTransportDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_BrokerDataSetWriterTransportDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerDataSetWriterTransportDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_BrokerDataSetReaderTransportDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerDataSetReaderTransportDataType, true
	case "OpcUa_XmlSchema_BrokerDataSetReaderTransportDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerDataSetReaderTransportDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_BrokerDataSetReaderTransportDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerDataSetReaderTransportDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_DatagramConnectionTransportDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramConnectionTransportDataType, true
	case "OpcUa_BinarySchema_DatagramConnectionTransportDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramConnectionTransportDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_DatagramConnectionTransportDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramConnectionTransportDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_DatagramConnectionTransportDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramConnectionTransportDataType, true
	case "OpcUa_XmlSchema_DatagramConnectionTransportDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramConnectionTransportDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_DatagramConnectionTransportDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramConnectionTransportDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_AdditionalParametersType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AdditionalParametersType, true
	case "OpcUa_BinarySchema_AdditionalParametersType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AdditionalParametersType_DataTypeVersion, true
	case "OpcUa_BinarySchema_AdditionalParametersType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AdditionalParametersType_DictionaryFragment, true
	case "OpcUa_XmlSchema_AdditionalParametersType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AdditionalParametersType, true
	case "OpcUa_XmlSchema_AdditionalParametersType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AdditionalParametersType_DataTypeVersion, true
	case "OpcUa_XmlSchema_AdditionalParametersType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AdditionalParametersType_DictionaryFragment, true
	case "OpcUa_BinarySchema_EphemeralKeyType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EphemeralKeyType, true
	case "OpcUa_BinarySchema_EphemeralKeyType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EphemeralKeyType_DataTypeVersion, true
	case "OpcUa_BinarySchema_EphemeralKeyType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EphemeralKeyType_DictionaryFragment, true
	case "OpcUa_XmlSchema_EphemeralKeyType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EphemeralKeyType, true
	case "OpcUa_XmlSchema_EphemeralKeyType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EphemeralKeyType_DataTypeVersion, true
	case "OpcUa_XmlSchema_EphemeralKeyType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EphemeralKeyType_DictionaryFragment, true
	case "OpcUa_XmlSchema_DataTypeDefinition":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeDefinition, true
	case "OpcUa_XmlSchema_DataTypeDefinition_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeDefinition_DataTypeVersion, true
	case "OpcUa_XmlSchema_DataTypeDefinition_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeDefinition_DictionaryFragment, true
	case "OpcUa_XmlSchema_StructureField":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureField, true
	case "OpcUa_XmlSchema_StructureField_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureField_DataTypeVersion, true
	case "OpcUa_XmlSchema_StructureField_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureField_DictionaryFragment, true
	case "OpcUa_XmlSchema_StructureDefinition":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureDefinition, true
	case "OpcUa_XmlSchema_StructureDefinition_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureDefinition_DataTypeVersion, true
	case "OpcUa_XmlSchema_StructureDefinition_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureDefinition_DictionaryFragment, true
	case "OpcUa_XmlSchema_EnumDefinition":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumDefinition, true
	case "OpcUa_XmlSchema_EnumDefinition_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumDefinition_DataTypeVersion, true
	case "OpcUa_XmlSchema_EnumDefinition_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumDefinition_DictionaryFragment, true
	case "OpcUa_BinarySchema_DataTypeDefinition":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeDefinition, true
	case "OpcUa_BinarySchema_DataTypeDefinition_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeDefinition_DataTypeVersion, true
	case "OpcUa_BinarySchema_DataTypeDefinition_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeDefinition_DictionaryFragment, true
	case "OpcUa_BinarySchema_StructureField":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureField, true
	case "OpcUa_BinarySchema_StructureField_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureField_DataTypeVersion, true
	case "OpcUa_BinarySchema_StructureField_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureField_DictionaryFragment, true
	case "OpcUa_BinarySchema_StructureDefinition":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureDefinition, true
	case "OpcUa_BinarySchema_StructureDefinition_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureDefinition_DataTypeVersion, true
	case "OpcUa_BinarySchema_StructureDefinition_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureDefinition_DictionaryFragment, true
	case "OpcUa_BinarySchema_EnumDefinition":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumDefinition, true
	case "OpcUa_BinarySchema_EnumDefinition_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumDefinition_DataTypeVersion, true
	case "OpcUa_BinarySchema_EnumDefinition_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumDefinition_DictionaryFragment, true
	case "OpcUa_BinarySchema_RationalNumber":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RationalNumber, true
	case "OpcUa_BinarySchema_RationalNumber_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RationalNumber_DataTypeVersion, true
	case "OpcUa_BinarySchema_RationalNumber_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RationalNumber_DictionaryFragment, true
	case "OpcUa_BinarySchema_Vector":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Vector, true
	case "OpcUa_BinarySchema_Vector_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Vector_DataTypeVersion, true
	case "OpcUa_BinarySchema_Vector_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Vector_DictionaryFragment, true
	case "OpcUa_BinarySchema_ThreeDVector":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDVector, true
	case "OpcUa_BinarySchema_ThreeDVector_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDVector_DataTypeVersion, true
	case "OpcUa_BinarySchema_ThreeDVector_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDVector_DictionaryFragment, true
	case "OpcUa_BinarySchema_CartesianCoordinates":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_CartesianCoordinates, true
	case "OpcUa_BinarySchema_CartesianCoordinates_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_CartesianCoordinates_DataTypeVersion, true
	case "OpcUa_BinarySchema_CartesianCoordinates_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_CartesianCoordinates_DictionaryFragment, true
	case "OpcUa_BinarySchema_ThreeDCartesianCoordinates":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDCartesianCoordinates, true
	case "OpcUa_BinarySchema_ThreeDCartesianCoordinates_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDCartesianCoordinates_DataTypeVersion, true
	case "OpcUa_BinarySchema_ThreeDCartesianCoordinates_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDCartesianCoordinates_DictionaryFragment, true
	case "OpcUa_BinarySchema_Orientation":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Orientation, true
	case "OpcUa_BinarySchema_Orientation_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Orientation_DataTypeVersion, true
	case "OpcUa_BinarySchema_Orientation_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Orientation_DictionaryFragment, true
	case "OpcUa_BinarySchema_ThreeDOrientation":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDOrientation, true
	case "OpcUa_BinarySchema_ThreeDOrientation_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDOrientation_DataTypeVersion, true
	case "OpcUa_BinarySchema_ThreeDOrientation_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDOrientation_DictionaryFragment, true
	case "OpcUa_BinarySchema_Frame":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Frame, true
	case "OpcUa_BinarySchema_Frame_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Frame_DataTypeVersion, true
	case "OpcUa_BinarySchema_Frame_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Frame_DictionaryFragment, true
	case "OpcUa_BinarySchema_ThreeDFrame":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDFrame, true
	case "OpcUa_BinarySchema_ThreeDFrame_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDFrame_DataTypeVersion, true
	case "OpcUa_BinarySchema_ThreeDFrame_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDFrame_DictionaryFragment, true
	case "OpcUa_XmlSchema_RationalNumber":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RationalNumber, true
	case "OpcUa_XmlSchema_RationalNumber_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RationalNumber_DataTypeVersion, true
	case "OpcUa_XmlSchema_RationalNumber_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RationalNumber_DictionaryFragment, true
	case "OpcUa_XmlSchema_Vector":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Vector, true
	case "OpcUa_XmlSchema_Vector_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Vector_DataTypeVersion, true
	case "OpcUa_XmlSchema_Vector_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Vector_DictionaryFragment, true
	case "OpcUa_XmlSchema_ThreeDVector":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDVector, true
	case "OpcUa_XmlSchema_ThreeDVector_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDVector_DataTypeVersion, true
	case "OpcUa_XmlSchema_ThreeDVector_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDVector_DictionaryFragment, true
	case "OpcUa_XmlSchema_CartesianCoordinates":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_CartesianCoordinates, true
	case "OpcUa_XmlSchema_CartesianCoordinates_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_CartesianCoordinates_DataTypeVersion, true
	case "OpcUa_XmlSchema_CartesianCoordinates_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_CartesianCoordinates_DictionaryFragment, true
	case "OpcUa_XmlSchema_ThreeDCartesianCoordinates":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDCartesianCoordinates, true
	case "OpcUa_XmlSchema_ThreeDCartesianCoordinates_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDCartesianCoordinates_DataTypeVersion, true
	case "OpcUa_XmlSchema_ThreeDCartesianCoordinates_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDCartesianCoordinates_DictionaryFragment, true
	case "OpcUa_XmlSchema_Orientation":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Orientation, true
	case "OpcUa_XmlSchema_Orientation_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Orientation_DataTypeVersion, true
	case "OpcUa_XmlSchema_Orientation_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Orientation_DictionaryFragment, true
	case "OpcUa_XmlSchema_ThreeDOrientation":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDOrientation, true
	case "OpcUa_XmlSchema_ThreeDOrientation_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDOrientation_DataTypeVersion, true
	case "OpcUa_XmlSchema_ThreeDOrientation_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDOrientation_DictionaryFragment, true
	case "OpcUa_XmlSchema_Frame":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Frame, true
	case "OpcUa_XmlSchema_Frame_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Frame_DataTypeVersion, true
	case "OpcUa_XmlSchema_Frame_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Frame_DictionaryFragment, true
	case "OpcUa_XmlSchema_ThreeDFrame":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDFrame, true
	case "OpcUa_XmlSchema_ThreeDFrame_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDFrame_DataTypeVersion, true
	case "OpcUa_XmlSchema_ThreeDFrame_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDFrame_DictionaryFragment, true
	case "OpcUa_BinarySchema_FieldTargetDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FieldTargetDataType, true
	case "OpcUa_BinarySchema_WriterGroupDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupDataType, true
	case "OpcUa_BinarySchema_WriterGroupDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_WriterGroupDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_NetworkAddressDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkAddressDataType, true
	case "OpcUa_BinarySchema_NetworkAddressDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkAddressDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_NetworkAddressDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkAddressDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_NetworkAddressUrlDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkAddressUrlDataType, true
	case "OpcUa_BinarySchema_NetworkAddressUrlDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkAddressUrlDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_NetworkAddressUrlDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkAddressUrlDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_ReaderGroupDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupDataType, true
	case "OpcUa_BinarySchema_ReaderGroupDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_ReaderGroupDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_PubSubConfigurationDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationDataType, true
	case "OpcUa_BinarySchema_PubSubConfigurationDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_PubSubConfigurationDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_DatagramWriterGroupTransportDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramWriterGroupTransportDataType, true
	case "OpcUa_BinarySchema_DatagramWriterGroupTransportDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramWriterGroupTransportDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_DatagramWriterGroupTransportDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramWriterGroupTransportDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_WriterGroupDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupDataType, true
	case "OpcUa_XmlSchema_WriterGroupDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_WriterGroupDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_NetworkAddressDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkAddressDataType, true
	case "OpcUa_XmlSchema_NetworkAddressDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkAddressDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_NetworkAddressDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkAddressDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_NetworkAddressUrlDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkAddressUrlDataType, true
	case "OpcUa_XmlSchema_NetworkAddressUrlDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkAddressUrlDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_NetworkAddressUrlDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkAddressUrlDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_ReaderGroupDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupDataType, true
	case "OpcUa_XmlSchema_ReaderGroupDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_ReaderGroupDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_PubSubConfigurationDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationDataType, true
	case "OpcUa_XmlSchema_PubSubConfigurationDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_PubSubConfigurationDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_DatagramWriterGroupTransportDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramWriterGroupTransportDataType, true
	case "OpcUa_XmlSchema_DatagramWriterGroupTransportDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramWriterGroupTransportDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_DatagramWriterGroupTransportDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramWriterGroupTransportDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_AliasNameDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AliasNameDataType, true
	case "OpcUa_BinarySchema_AliasNameDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AliasNameDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_AliasNameDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AliasNameDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_AliasNameDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AliasNameDataType, true
	case "OpcUa_XmlSchema_AliasNameDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AliasNameDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_AliasNameDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AliasNameDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_CurrencyUnitType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_CurrencyUnitType, true
	case "OpcUa_BinarySchema_CurrencyUnitType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_CurrencyUnitType_DataTypeVersion, true
	case "OpcUa_BinarySchema_CurrencyUnitType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_CurrencyUnitType_DictionaryFragment, true
	case "OpcUa_XmlSchema_CurrencyUnitType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_CurrencyUnitType, true
	case "OpcUa_XmlSchema_CurrencyUnitType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_CurrencyUnitType_DataTypeVersion, true
	case "OpcUa_XmlSchema_CurrencyUnitType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_CurrencyUnitType_DictionaryFragment, true
	case "OpcUa_BinarySchema_StandaloneSubscribedDataSetRefDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StandaloneSubscribedDataSetRefDataType, true
	case "OpcUa_BinarySchema_StandaloneSubscribedDataSetRefDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StandaloneSubscribedDataSetRefDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_StandaloneSubscribedDataSetRefDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StandaloneSubscribedDataSetRefDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_StandaloneSubscribedDataSetDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StandaloneSubscribedDataSetDataType, true
	case "OpcUa_BinarySchema_StandaloneSubscribedDataSetDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StandaloneSubscribedDataSetDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_StandaloneSubscribedDataSetDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StandaloneSubscribedDataSetDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_SecurityGroupDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SecurityGroupDataType, true
	case "OpcUa_BinarySchema_SecurityGroupDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SecurityGroupDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_SecurityGroupDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SecurityGroupDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_PubSubConfiguration2DataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfiguration2DataType, true
	case "OpcUa_BinarySchema_PubSubConfiguration2DataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfiguration2DataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_PubSubConfiguration2DataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfiguration2DataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_QosDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_QosDataType, true
	case "OpcUa_BinarySchema_QosDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_QosDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_QosDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_QosDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_TransmitQosDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransmitQosDataType, true
	case "OpcUa_BinarySchema_TransmitQosDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransmitQosDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_TransmitQosDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransmitQosDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_TransmitQosPriorityDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransmitQosPriorityDataType, true
	case "OpcUa_BinarySchema_TransmitQosPriorityDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransmitQosPriorityDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_TransmitQosPriorityDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransmitQosPriorityDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_ReceiveQosDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReceiveQosDataType, true
	case "OpcUa_BinarySchema_ReceiveQosDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReceiveQosDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_ReceiveQosDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReceiveQosDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_ReceiveQosPriorityDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReceiveQosPriorityDataType, true
	case "OpcUa_BinarySchema_ReceiveQosPriorityDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReceiveQosPriorityDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_ReceiveQosPriorityDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReceiveQosPriorityDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_DatagramConnectionTransport2DataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramConnectionTransport2DataType, true
	case "OpcUa_BinarySchema_DatagramConnectionTransport2DataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramConnectionTransport2DataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_DatagramConnectionTransport2DataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramConnectionTransport2DataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_DatagramWriterGroupTransport2DataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramWriterGroupTransport2DataType, true
	case "OpcUa_BinarySchema_DatagramWriterGroupTransport2DataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramWriterGroupTransport2DataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_DatagramWriterGroupTransport2DataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramWriterGroupTransport2DataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_DatagramDataSetReaderTransportDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramDataSetReaderTransportDataType, true
	case "OpcUa_BinarySchema_DatagramDataSetReaderTransportDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramDataSetReaderTransportDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_DatagramDataSetReaderTransportDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramDataSetReaderTransportDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_StandaloneSubscribedDataSetRefDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StandaloneSubscribedDataSetRefDataType, true
	case "OpcUa_XmlSchema_StandaloneSubscribedDataSetRefDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StandaloneSubscribedDataSetRefDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_StandaloneSubscribedDataSetRefDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StandaloneSubscribedDataSetRefDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_StandaloneSubscribedDataSetDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StandaloneSubscribedDataSetDataType, true
	case "OpcUa_XmlSchema_StandaloneSubscribedDataSetDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StandaloneSubscribedDataSetDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_StandaloneSubscribedDataSetDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StandaloneSubscribedDataSetDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_SecurityGroupDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SecurityGroupDataType, true
	case "OpcUa_XmlSchema_SecurityGroupDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SecurityGroupDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_SecurityGroupDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SecurityGroupDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_PubSubConfiguration2DataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfiguration2DataType, true
	case "OpcUa_XmlSchema_PubSubConfiguration2DataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfiguration2DataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_PubSubConfiguration2DataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfiguration2DataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_QosDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_QosDataType, true
	case "OpcUa_XmlSchema_QosDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_QosDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_QosDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_QosDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_TransmitQosDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransmitQosDataType, true
	case "OpcUa_XmlSchema_TransmitQosDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransmitQosDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_TransmitQosDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransmitQosDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_TransmitQosPriorityDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransmitQosPriorityDataType, true
	case "OpcUa_XmlSchema_TransmitQosPriorityDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransmitQosPriorityDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_TransmitQosPriorityDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransmitQosPriorityDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_ReceiveQosDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReceiveQosDataType, true
	case "OpcUa_XmlSchema_ReceiveQosDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReceiveQosDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_ReceiveQosDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReceiveQosDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_ReceiveQosPriorityDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReceiveQosPriorityDataType, true
	case "OpcUa_XmlSchema_ReceiveQosPriorityDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReceiveQosPriorityDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_ReceiveQosPriorityDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReceiveQosPriorityDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_DatagramConnectionTransport2DataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramConnectionTransport2DataType, true
	case "OpcUa_XmlSchema_DatagramConnectionTransport2DataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramConnectionTransport2DataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_DatagramConnectionTransport2DataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramConnectionTransport2DataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_DatagramWriterGroupTransport2DataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramWriterGroupTransport2DataType, true
	case "OpcUa_XmlSchema_DatagramWriterGroupTransport2DataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramWriterGroupTransport2DataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_DatagramWriterGroupTransport2DataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramWriterGroupTransport2DataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_DatagramDataSetReaderTransportDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramDataSetReaderTransportDataType, true
	case "OpcUa_XmlSchema_DatagramDataSetReaderTransportDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramDataSetReaderTransportDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_DatagramDataSetReaderTransportDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramDataSetReaderTransportDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_ProgramDiagnostic2DataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ProgramDiagnostic2DataType, true
	case "OpcUa_BinarySchema_ProgramDiagnostic2DataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ProgramDiagnostic2DataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_ProgramDiagnostic2DataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ProgramDiagnostic2DataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_ProgramDiagnostic2DataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ProgramDiagnostic2DataType, true
	case "OpcUa_XmlSchema_ProgramDiagnostic2DataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ProgramDiagnostic2DataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_ProgramDiagnostic2DataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ProgramDiagnostic2DataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_PortableQualifiedName":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PortableQualifiedName, true
	case "OpcUa_BinarySchema_PortableQualifiedName_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PortableQualifiedName_DataTypeVersion, true
	case "OpcUa_BinarySchema_PortableQualifiedName_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PortableQualifiedName_DictionaryFragment, true
	case "OpcUa_BinarySchema_PortableNodeId":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PortableNodeId, true
	case "OpcUa_BinarySchema_PortableNodeId_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PortableNodeId_DataTypeVersion, true
	case "OpcUa_BinarySchema_PortableNodeId_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PortableNodeId_DictionaryFragment, true
	case "OpcUa_BinarySchema_UnsignedRationalNumber":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UnsignedRationalNumber, true
	case "OpcUa_BinarySchema_UnsignedRationalNumber_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UnsignedRationalNumber_DataTypeVersion, true
	case "OpcUa_BinarySchema_UnsignedRationalNumber_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UnsignedRationalNumber_DictionaryFragment, true
	case "OpcUa_XmlSchema_PortableQualifiedName":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PortableQualifiedName, true
	case "OpcUa_XmlSchema_PortableQualifiedName_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PortableQualifiedName_DataTypeVersion, true
	case "OpcUa_XmlSchema_PortableQualifiedName_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PortableQualifiedName_DictionaryFragment, true
	case "OpcUa_XmlSchema_PortableNodeId":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PortableNodeId, true
	case "OpcUa_XmlSchema_PortableNodeId_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PortableNodeId_DataTypeVersion, true
	case "OpcUa_XmlSchema_PortableNodeId_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PortableNodeId_DictionaryFragment, true
	case "OpcUa_XmlSchema_UnsignedRationalNumber":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UnsignedRationalNumber, true
	case "OpcUa_XmlSchema_UnsignedRationalNumber_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UnsignedRationalNumber_DataTypeVersion, true
	case "OpcUa_XmlSchema_UnsignedRationalNumber_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UnsignedRationalNumber_DictionaryFragment, true
	case "OpcUa_BinarySchema_UserManagementDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserManagementDataType, true
	case "OpcUa_BinarySchema_UserManagementDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserManagementDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_UserManagementDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserManagementDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_UserManagementDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserManagementDataType, true
	case "OpcUa_XmlSchema_UserManagementDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserManagementDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_UserManagementDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserManagementDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_PriorityMappingEntryType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PriorityMappingEntryType, true
	case "OpcUa_BinarySchema_PriorityMappingEntryType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PriorityMappingEntryType_DataTypeVersion, true
	case "OpcUa_BinarySchema_PriorityMappingEntryType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PriorityMappingEntryType_DictionaryFragment, true
	case "OpcUa_XmlSchema_PriorityMappingEntryType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PriorityMappingEntryType, true
	case "OpcUa_XmlSchema_PriorityMappingEntryType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PriorityMappingEntryType_DataTypeVersion, true
	case "OpcUa_XmlSchema_PriorityMappingEntryType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PriorityMappingEntryType_DictionaryFragment, true
	case "OpcUa_BinarySchema_PublishedDataSetCustomSourceDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetCustomSourceDataType, true
	case "OpcUa_BinarySchema_PublishedDataSetCustomSourceDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetCustomSourceDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_PublishedDataSetCustomSourceDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetCustomSourceDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_PubSubKeyPushTargetDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubKeyPushTargetDataType, true
	case "OpcUa_BinarySchema_PubSubKeyPushTargetDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubKeyPushTargetDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_PubSubKeyPushTargetDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubKeyPushTargetDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_PubSubConfigurationRefDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationRefDataType, true
	case "OpcUa_BinarySchema_PubSubConfigurationRefDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationRefDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_PubSubConfigurationRefDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationRefDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_PubSubConfigurationValueDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationValueDataType, true
	case "OpcUa_BinarySchema_PubSubConfigurationValueDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationValueDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_PubSubConfigurationValueDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationValueDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_PublishedDataSetCustomSourceDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetCustomSourceDataType, true
	case "OpcUa_XmlSchema_PublishedDataSetCustomSourceDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetCustomSourceDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_PublishedDataSetCustomSourceDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetCustomSourceDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_PubSubKeyPushTargetDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubKeyPushTargetDataType, true
	case "OpcUa_XmlSchema_PubSubKeyPushTargetDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubKeyPushTargetDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_PubSubKeyPushTargetDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubKeyPushTargetDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_PubSubConfigurationRefDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationRefDataType, true
	case "OpcUa_XmlSchema_PubSubConfigurationRefDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationRefDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_PubSubConfigurationRefDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationRefDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_PubSubConfigurationValueDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationValueDataType, true
	case "OpcUa_XmlSchema_PubSubConfigurationValueDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationValueDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_PubSubConfigurationValueDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationValueDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_TransactionErrorType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransactionErrorType, true
	case "OpcUa_BinarySchema_TransactionErrorType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransactionErrorType_DataTypeVersion, true
	case "OpcUa_BinarySchema_TransactionErrorType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransactionErrorType_DictionaryFragment, true
	case "OpcUa_XmlSchema_TransactionErrorType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransactionErrorType, true
	case "OpcUa_XmlSchema_TransactionErrorType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransactionErrorType_DataTypeVersion, true
	case "OpcUa_XmlSchema_TransactionErrorType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransactionErrorType_DictionaryFragment, true
	case "OpcUa_BinarySchema_BitFieldDefinition":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BitFieldDefinition, true
	case "OpcUa_BinarySchema_BitFieldDefinition_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BitFieldDefinition_DataTypeVersion, true
	case "OpcUa_BinarySchema_BitFieldDefinition_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BitFieldDefinition_DictionaryFragment, true
	case "OpcUa_XmlSchema_BitFieldDefinition":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BitFieldDefinition, true
	case "OpcUa_XmlSchema_BitFieldDefinition_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BitFieldDefinition_DataTypeVersion, true
	case "OpcUa_XmlSchema_BitFieldDefinition_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BitFieldDefinition_DictionaryFragment, true
	case "OpcUa_BinarySchema_AnnotationDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AnnotationDataType, true
	case "OpcUa_BinarySchema_AnnotationDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AnnotationDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_AnnotationDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AnnotationDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_LinearConversionDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_LinearConversionDataType, true
	case "OpcUa_BinarySchema_LinearConversionDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_LinearConversionDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_LinearConversionDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_LinearConversionDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_QuantityDimension":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_QuantityDimension, true
	case "OpcUa_BinarySchema_QuantityDimension_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_QuantityDimension_DataTypeVersion, true
	case "OpcUa_BinarySchema_QuantityDimension_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_QuantityDimension_DictionaryFragment, true
	case "OpcUa_XmlSchema_AnnotationDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AnnotationDataType, true
	case "OpcUa_XmlSchema_AnnotationDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AnnotationDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_AnnotationDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AnnotationDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_LinearConversionDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_LinearConversionDataType, true
	case "OpcUa_XmlSchema_LinearConversionDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_LinearConversionDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_LinearConversionDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_LinearConversionDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_QuantityDimension":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_QuantityDimension, true
	case "OpcUa_XmlSchema_QuantityDimension_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_QuantityDimension_DataTypeVersion, true
	case "OpcUa_XmlSchema_QuantityDimension_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_QuantityDimension_DictionaryFragment, true
	case "OpcUa_BinarySchema_ReferenceDescriptionDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReferenceDescriptionDataType, true
	case "OpcUa_BinarySchema_ReferenceDescriptionDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReferenceDescriptionDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_ReferenceDescriptionDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReferenceDescriptionDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_ReferenceListEntryDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReferenceListEntryDataType, true
	case "OpcUa_BinarySchema_ReferenceListEntryDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReferenceListEntryDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_ReferenceListEntryDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReferenceListEntryDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_ReferenceDescriptionDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReferenceDescriptionDataType, true
	case "OpcUa_XmlSchema_ReferenceDescriptionDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReferenceDescriptionDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_ReferenceDescriptionDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReferenceDescriptionDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_ReferenceListEntryDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReferenceListEntryDataType, true
	case "OpcUa_XmlSchema_ReferenceListEntryDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReferenceListEntryDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_ReferenceListEntryDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReferenceListEntryDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_HistoryModifiedEvent":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryModifiedEvent, true
	case "OpcUa_BinarySchema_HistoryModifiedEvent_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryModifiedEvent_DataTypeVersion, true
	case "OpcUa_BinarySchema_HistoryModifiedEvent_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryModifiedEvent_DictionaryFragment, true
	case "OpcUa_XmlSchema_HistoryModifiedEvent":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryModifiedEvent, true
	case "OpcUa_XmlSchema_HistoryModifiedEvent_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryModifiedEvent_DataTypeVersion, true
	case "OpcUa_XmlSchema_HistoryModifiedEvent_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryModifiedEvent_DictionaryFragment, true
	case "OpcUa_BinarySchema":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema, true
	case "OpcUa_BinarySchema_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeVersion, true
	case "OpcUa_BinarySchema_NamespaceUri":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NamespaceUri, true
	case "OpcUa_BinarySchema_Argument":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Argument, true
	case "OpcUa_BinarySchema_Argument_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Argument_DataTypeVersion, true
	case "OpcUa_BinarySchema_Argument_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Argument_DictionaryFragment, true
	case "OpcUa_BinarySchema_EnumValueType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumValueType, true
	case "OpcUa_BinarySchema_EnumValueType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumValueType_DataTypeVersion, true
	case "OpcUa_BinarySchema_EnumValueType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumValueType_DictionaryFragment, true
	case "OpcUa_BinarySchema_StatusResult":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StatusResult, true
	case "OpcUa_BinarySchema_StatusResult_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StatusResult_DataTypeVersion, true
	case "OpcUa_BinarySchema_StatusResult_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StatusResult_DictionaryFragment, true
	case "OpcUa_BinarySchema_UserTokenPolicy":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserTokenPolicy, true
	case "OpcUa_BinarySchema_UserTokenPolicy_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserTokenPolicy_DataTypeVersion, true
	case "OpcUa_BinarySchema_UserTokenPolicy_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserTokenPolicy_DictionaryFragment, true
	case "OpcUa_BinarySchema_ApplicationDescription":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ApplicationDescription, true
	case "OpcUa_BinarySchema_ApplicationDescription_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ApplicationDescription_DataTypeVersion, true
	case "OpcUa_BinarySchema_ApplicationDescription_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ApplicationDescription_DictionaryFragment, true
	case "OpcUa_BinarySchema_EndpointDescription":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointDescription, true
	case "OpcUa_BinarySchema_EndpointDescription_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointDescription_DataTypeVersion, true
	case "OpcUa_BinarySchema_EndpointDescription_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointDescription_DictionaryFragment, true
	case "OpcUa_BinarySchema_UserIdentityToken":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserIdentityToken, true
	case "OpcUa_BinarySchema_UserIdentityToken_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserIdentityToken_DataTypeVersion, true
	case "OpcUa_BinarySchema_UserIdentityToken_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserIdentityToken_DictionaryFragment, true
	case "OpcUa_BinarySchema_AnonymousIdentityToken":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AnonymousIdentityToken, true
	case "OpcUa_BinarySchema_AnonymousIdentityToken_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AnonymousIdentityToken_DataTypeVersion, true
	case "OpcUa_BinarySchema_AnonymousIdentityToken_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AnonymousIdentityToken_DictionaryFragment, true
	case "OpcUa_BinarySchema_UserNameIdentityToken":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserNameIdentityToken, true
	case "OpcUa_BinarySchema_UserNameIdentityToken_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserNameIdentityToken_DataTypeVersion, true
	case "OpcUa_BinarySchema_UserNameIdentityToken_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserNameIdentityToken_DictionaryFragment, true
	case "OpcUa_BinarySchema_X509IdentityToken":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_X509IdentityToken, true
	case "OpcUa_BinarySchema_X509IdentityToken_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_X509IdentityToken_DataTypeVersion, true
	case "OpcUa_BinarySchema_X509IdentityToken_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_X509IdentityToken_DictionaryFragment, true
	case "OpcUa_BinarySchema_IssuedIdentityToken":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_IssuedIdentityToken, true
	case "OpcUa_BinarySchema_IssuedIdentityToken_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_IssuedIdentityToken_DataTypeVersion, true
	case "OpcUa_BinarySchema_IssuedIdentityToken_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_IssuedIdentityToken_DictionaryFragment, true
	case "OpcUa_BinarySchema_EndpointConfiguration":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointConfiguration, true
	case "OpcUa_BinarySchema_EndpointConfiguration_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointConfiguration_DataTypeVersion, true
	case "OpcUa_BinarySchema_EndpointConfiguration_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointConfiguration_DictionaryFragment, true
	case "OpcUa_BinarySchema_BuildInfo":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BuildInfo, true
	case "OpcUa_BinarySchema_BuildInfo_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BuildInfo_DataTypeVersion, true
	case "OpcUa_BinarySchema_BuildInfo_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BuildInfo_DictionaryFragment, true
	case "OpcUa_BinarySchema_SignedSoftwareCertificate":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SignedSoftwareCertificate, true
	case "OpcUa_BinarySchema_SignedSoftwareCertificate_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SignedSoftwareCertificate_DataTypeVersion, true
	case "OpcUa_BinarySchema_SignedSoftwareCertificate_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SignedSoftwareCertificate_DictionaryFragment, true
	case "OpcUa_BinarySchema_AddNodesItem":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AddNodesItem, true
	case "OpcUa_BinarySchema_AddNodesItem_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AddNodesItem_DataTypeVersion, true
	case "OpcUa_BinarySchema_AddNodesItem_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AddNodesItem_DictionaryFragment, true
	case "OpcUa_BinarySchema_AddReferencesItem":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AddReferencesItem, true
	case "OpcUa_BinarySchema_AddReferencesItem_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AddReferencesItem_DataTypeVersion, true
	case "OpcUa_BinarySchema_AddReferencesItem_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AddReferencesItem_DictionaryFragment, true
	case "OpcUa_BinarySchema_DeleteNodesItem":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DeleteNodesItem, true
	case "OpcUa_BinarySchema_DeleteNodesItem_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DeleteNodesItem_DataTypeVersion, true
	case "OpcUa_BinarySchema_DeleteNodesItem_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DeleteNodesItem_DictionaryFragment, true
	case "OpcUa_BinarySchema_DeleteReferencesItem":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DeleteReferencesItem, true
	case "OpcUa_BinarySchema_DeleteReferencesItem_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DeleteReferencesItem_DataTypeVersion, true
	case "OpcUa_BinarySchema_DeleteReferencesItem_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DeleteReferencesItem_DictionaryFragment, true
	case "OpcUa_BinarySchema_RegisteredServer":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RegisteredServer, true
	case "OpcUa_BinarySchema_RegisteredServer_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RegisteredServer_DataTypeVersion, true
	case "OpcUa_BinarySchema_RegisteredServer_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RegisteredServer_DictionaryFragment, true
	case "OpcUa_BinarySchema_ContentFilterElement":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ContentFilterElement, true
	case "OpcUa_BinarySchema_ContentFilterElement_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ContentFilterElement_DataTypeVersion, true
	case "OpcUa_BinarySchema_ContentFilterElement_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ContentFilterElement_DictionaryFragment, true
	case "OpcUa_BinarySchema_ContentFilter":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ContentFilter, true
	case "OpcUa_BinarySchema_ContentFilter_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ContentFilter_DataTypeVersion, true
	case "OpcUa_BinarySchema_ContentFilter_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ContentFilter_DictionaryFragment, true
	case "OpcUa_BinarySchema_FilterOperand":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FilterOperand, true
	case "OpcUa_BinarySchema_FilterOperand_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FilterOperand_DataTypeVersion, true
	case "OpcUa_BinarySchema_FilterOperand_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FilterOperand_DictionaryFragment, true
	case "OpcUa_BinarySchema_ElementOperand":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ElementOperand, true
	case "OpcUa_BinarySchema_ElementOperand_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ElementOperand_DataTypeVersion, true
	case "OpcUa_BinarySchema_ElementOperand_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ElementOperand_DictionaryFragment, true
	case "OpcUa_BinarySchema_LiteralOperand":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_LiteralOperand, true
	case "OpcUa_BinarySchema_LiteralOperand_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_LiteralOperand_DataTypeVersion, true
	case "OpcUa_BinarySchema_LiteralOperand_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_LiteralOperand_DictionaryFragment, true
	case "OpcUa_BinarySchema_AttributeOperand":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AttributeOperand, true
	case "OpcUa_BinarySchema_AttributeOperand_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AttributeOperand_DataTypeVersion, true
	case "OpcUa_BinarySchema_AttributeOperand_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AttributeOperand_DictionaryFragment, true
	case "OpcUa_BinarySchema_SimpleAttributeOperand":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SimpleAttributeOperand, true
	case "OpcUa_BinarySchema_SimpleAttributeOperand_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SimpleAttributeOperand_DataTypeVersion, true
	case "OpcUa_BinarySchema_SimpleAttributeOperand_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SimpleAttributeOperand_DictionaryFragment, true
	case "OpcUa_BinarySchema_HistoryEvent":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryEvent, true
	case "OpcUa_BinarySchema_HistoryEvent_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryEvent_DataTypeVersion, true
	case "OpcUa_BinarySchema_HistoryEvent_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryEvent_DictionaryFragment, true
	case "OpcUa_BinarySchema_MonitoringFilter":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_MonitoringFilter, true
	case "OpcUa_BinarySchema_MonitoringFilter_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_MonitoringFilter_DataTypeVersion, true
	case "OpcUa_BinarySchema_MonitoringFilter_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_MonitoringFilter_DictionaryFragment, true
	case "OpcUa_BinarySchema_EventFilter":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EventFilter, true
	case "OpcUa_BinarySchema_EventFilter_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EventFilter_DataTypeVersion, true
	case "OpcUa_BinarySchema_EventFilter_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EventFilter_DictionaryFragment, true
	case "OpcUa_BinarySchema_AggregateConfiguration":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AggregateConfiguration, true
	case "OpcUa_BinarySchema_AggregateConfiguration_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AggregateConfiguration_DataTypeVersion, true
	case "OpcUa_BinarySchema_AggregateConfiguration_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AggregateConfiguration_DictionaryFragment, true
	case "OpcUa_BinarySchema_HistoryEventFieldList":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryEventFieldList, true
	case "OpcUa_BinarySchema_HistoryEventFieldList_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryEventFieldList_DataTypeVersion, true
	case "OpcUa_BinarySchema_HistoryEventFieldList_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryEventFieldList_DictionaryFragment, true
	case "OpcUa_BinarySchema_RedundantServerDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RedundantServerDataType, true
	case "OpcUa_BinarySchema_RedundantServerDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RedundantServerDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_RedundantServerDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RedundantServerDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_SamplingIntervalDiagnosticsDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SamplingIntervalDiagnosticsDataType, true
	case "OpcUa_BinarySchema_SamplingIntervalDiagnosticsDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SamplingIntervalDiagnosticsDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_SamplingIntervalDiagnosticsDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SamplingIntervalDiagnosticsDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_ServerDiagnosticsSummaryDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerDiagnosticsSummaryDataType, true
	case "OpcUa_BinarySchema_ServerDiagnosticsSummaryDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerDiagnosticsSummaryDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_ServerDiagnosticsSummaryDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerDiagnosticsSummaryDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_ServerStatusDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerStatusDataType, true
	case "OpcUa_BinarySchema_ServerStatusDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerStatusDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_ServerStatusDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerStatusDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_SessionDiagnosticsDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SessionDiagnosticsDataType, true
	case "OpcUa_BinarySchema_SessionDiagnosticsDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SessionDiagnosticsDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_SessionDiagnosticsDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SessionDiagnosticsDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_SessionSecurityDiagnosticsDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SessionSecurityDiagnosticsDataType, true
	case "OpcUa_BinarySchema_SessionSecurityDiagnosticsDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SessionSecurityDiagnosticsDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_SessionSecurityDiagnosticsDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SessionSecurityDiagnosticsDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_ServiceCounterDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServiceCounterDataType, true
	case "OpcUa_BinarySchema_ServiceCounterDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServiceCounterDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_ServiceCounterDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServiceCounterDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_SubscriptionDiagnosticsDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscriptionDiagnosticsDataType, true
	case "OpcUa_BinarySchema_SubscriptionDiagnosticsDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscriptionDiagnosticsDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_SubscriptionDiagnosticsDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscriptionDiagnosticsDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_ModelChangeStructureDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ModelChangeStructureDataType, true
	case "OpcUa_BinarySchema_ModelChangeStructureDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ModelChangeStructureDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_ModelChangeStructureDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ModelChangeStructureDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_SemanticChangeStructureDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SemanticChangeStructureDataType, true
	case "OpcUa_BinarySchema_SemanticChangeStructureDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SemanticChangeStructureDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_SemanticChangeStructureDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SemanticChangeStructureDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_Range":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Range, true
	case "OpcUa_BinarySchema_Range_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Range_DataTypeVersion, true
	case "OpcUa_BinarySchema_Range_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Range_DictionaryFragment, true
	case "OpcUa_BinarySchema_EUInformation":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EUInformation, true
	case "OpcUa_BinarySchema_EUInformation_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EUInformation_DataTypeVersion, true
	case "OpcUa_BinarySchema_EUInformation_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EUInformation_DictionaryFragment, true
	case "OpcUa_BinarySchema_Annotation":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Annotation, true
	case "OpcUa_BinarySchema_Annotation_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Annotation_DataTypeVersion, true
	case "OpcUa_BinarySchema_Annotation_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Annotation_DictionaryFragment, true
	case "OpcUa_BinarySchema_ProgramDiagnosticDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ProgramDiagnosticDataType, true
	case "OpcUa_BinarySchema_ProgramDiagnosticDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ProgramDiagnosticDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_ProgramDiagnosticDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ProgramDiagnosticDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema, true
	case "OpcUa_XmlSchema_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeVersion, true
	case "OpcUa_XmlSchema_NamespaceUri":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NamespaceUri, true
	case "OpcUa_XmlSchema_Argument":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Argument, true
	case "OpcUa_XmlSchema_Argument_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Argument_DataTypeVersion, true
	case "OpcUa_XmlSchema_Argument_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Argument_DictionaryFragment, true
	case "OpcUa_XmlSchema_EnumValueType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumValueType, true
	case "OpcUa_XmlSchema_EnumValueType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumValueType_DataTypeVersion, true
	case "OpcUa_XmlSchema_EnumValueType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumValueType_DictionaryFragment, true
	case "OpcUa_XmlSchema_StatusResult":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StatusResult, true
	case "OpcUa_XmlSchema_StatusResult_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StatusResult_DataTypeVersion, true
	case "OpcUa_XmlSchema_StatusResult_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StatusResult_DictionaryFragment, true
	case "OpcUa_XmlSchema_UserTokenPolicy":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserTokenPolicy, true
	case "OpcUa_XmlSchema_UserTokenPolicy_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserTokenPolicy_DataTypeVersion, true
	case "OpcUa_XmlSchema_UserTokenPolicy_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserTokenPolicy_DictionaryFragment, true
	case "OpcUa_XmlSchema_ApplicationDescription":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ApplicationDescription, true
	case "OpcUa_XmlSchema_ApplicationDescription_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ApplicationDescription_DataTypeVersion, true
	case "OpcUa_XmlSchema_ApplicationDescription_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ApplicationDescription_DictionaryFragment, true
	case "OpcUa_XmlSchema_EndpointDescription":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointDescription, true
	case "OpcUa_XmlSchema_EndpointDescription_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointDescription_DataTypeVersion, true
	case "OpcUa_XmlSchema_EndpointDescription_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointDescription_DictionaryFragment, true
	case "OpcUa_XmlSchema_UserIdentityToken":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserIdentityToken, true
	case "OpcUa_XmlSchema_UserIdentityToken_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserIdentityToken_DataTypeVersion, true
	case "OpcUa_XmlSchema_UserIdentityToken_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserIdentityToken_DictionaryFragment, true
	case "OpcUa_XmlSchema_AnonymousIdentityToken":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AnonymousIdentityToken, true
	case "OpcUa_XmlSchema_AnonymousIdentityToken_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AnonymousIdentityToken_DataTypeVersion, true
	case "OpcUa_XmlSchema_AnonymousIdentityToken_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AnonymousIdentityToken_DictionaryFragment, true
	case "OpcUa_XmlSchema_UserNameIdentityToken":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserNameIdentityToken, true
	case "OpcUa_XmlSchema_UserNameIdentityToken_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserNameIdentityToken_DataTypeVersion, true
	case "OpcUa_XmlSchema_UserNameIdentityToken_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserNameIdentityToken_DictionaryFragment, true
	case "OpcUa_XmlSchema_X509IdentityToken":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_X509IdentityToken, true
	case "OpcUa_XmlSchema_X509IdentityToken_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_X509IdentityToken_DataTypeVersion, true
	case "OpcUa_XmlSchema_X509IdentityToken_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_X509IdentityToken_DictionaryFragment, true
	case "OpcUa_XmlSchema_IssuedIdentityToken":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_IssuedIdentityToken, true
	case "OpcUa_XmlSchema_IssuedIdentityToken_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_IssuedIdentityToken_DataTypeVersion, true
	case "OpcUa_XmlSchema_IssuedIdentityToken_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_IssuedIdentityToken_DictionaryFragment, true
	case "OpcUa_XmlSchema_EndpointConfiguration":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointConfiguration, true
	case "OpcUa_XmlSchema_EndpointConfiguration_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointConfiguration_DataTypeVersion, true
	case "OpcUa_XmlSchema_EndpointConfiguration_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointConfiguration_DictionaryFragment, true
	case "OpcUa_XmlSchema_BuildInfo":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BuildInfo, true
	case "OpcUa_XmlSchema_BuildInfo_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BuildInfo_DataTypeVersion, true
	case "OpcUa_XmlSchema_BuildInfo_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BuildInfo_DictionaryFragment, true
	case "OpcUa_XmlSchema_SignedSoftwareCertificate":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SignedSoftwareCertificate, true
	case "OpcUa_XmlSchema_SignedSoftwareCertificate_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SignedSoftwareCertificate_DataTypeVersion, true
	case "OpcUa_XmlSchema_SignedSoftwareCertificate_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SignedSoftwareCertificate_DictionaryFragment, true
	case "OpcUa_XmlSchema_AddNodesItem":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AddNodesItem, true
	case "OpcUa_XmlSchema_AddNodesItem_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AddNodesItem_DataTypeVersion, true
	case "OpcUa_XmlSchema_AddNodesItem_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AddNodesItem_DictionaryFragment, true
	case "OpcUa_XmlSchema_AddReferencesItem":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AddReferencesItem, true
	case "OpcUa_XmlSchema_AddReferencesItem_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AddReferencesItem_DataTypeVersion, true
	case "OpcUa_XmlSchema_AddReferencesItem_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AddReferencesItem_DictionaryFragment, true
	case "OpcUa_XmlSchema_DeleteNodesItem":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DeleteNodesItem, true
	case "OpcUa_XmlSchema_DeleteNodesItem_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DeleteNodesItem_DataTypeVersion, true
	case "OpcUa_XmlSchema_DeleteNodesItem_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DeleteNodesItem_DictionaryFragment, true
	case "OpcUa_XmlSchema_DeleteReferencesItem":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DeleteReferencesItem, true
	case "OpcUa_XmlSchema_DeleteReferencesItem_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DeleteReferencesItem_DataTypeVersion, true
	case "OpcUa_XmlSchema_DeleteReferencesItem_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DeleteReferencesItem_DictionaryFragment, true
	case "OpcUa_XmlSchema_RegisteredServer":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RegisteredServer, true
	case "OpcUa_XmlSchema_RegisteredServer_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RegisteredServer_DataTypeVersion, true
	case "OpcUa_XmlSchema_RegisteredServer_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RegisteredServer_DictionaryFragment, true
	case "OpcUa_XmlSchema_ContentFilterElement":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ContentFilterElement, true
	case "OpcUa_XmlSchema_ContentFilterElement_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ContentFilterElement_DataTypeVersion, true
	case "OpcUa_XmlSchema_ContentFilterElement_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ContentFilterElement_DictionaryFragment, true
	case "OpcUa_XmlSchema_ContentFilter":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ContentFilter, true
	case "OpcUa_XmlSchema_ContentFilter_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ContentFilter_DataTypeVersion, true
	case "OpcUa_XmlSchema_ContentFilter_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ContentFilter_DictionaryFragment, true
	case "OpcUa_XmlSchema_FilterOperand":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FilterOperand, true
	case "OpcUa_XmlSchema_FilterOperand_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FilterOperand_DataTypeVersion, true
	case "OpcUa_XmlSchema_FilterOperand_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FilterOperand_DictionaryFragment, true
	case "OpcUa_XmlSchema_ElementOperand":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ElementOperand, true
	case "OpcUa_XmlSchema_ElementOperand_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ElementOperand_DataTypeVersion, true
	case "OpcUa_XmlSchema_ElementOperand_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ElementOperand_DictionaryFragment, true
	case "OpcUa_XmlSchema_LiteralOperand":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_LiteralOperand, true
	case "OpcUa_XmlSchema_LiteralOperand_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_LiteralOperand_DataTypeVersion, true
	case "OpcUa_XmlSchema_LiteralOperand_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_LiteralOperand_DictionaryFragment, true
	case "OpcUa_XmlSchema_AttributeOperand":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AttributeOperand, true
	case "OpcUa_XmlSchema_AttributeOperand_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AttributeOperand_DataTypeVersion, true
	case "OpcUa_XmlSchema_AttributeOperand_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AttributeOperand_DictionaryFragment, true
	case "OpcUa_XmlSchema_SimpleAttributeOperand":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SimpleAttributeOperand, true
	case "OpcUa_XmlSchema_SimpleAttributeOperand_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SimpleAttributeOperand_DataTypeVersion, true
	case "OpcUa_XmlSchema_SimpleAttributeOperand_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SimpleAttributeOperand_DictionaryFragment, true
	case "OpcUa_XmlSchema_HistoryEvent":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryEvent, true
	case "OpcUa_XmlSchema_HistoryEvent_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryEvent_DataTypeVersion, true
	case "OpcUa_XmlSchema_HistoryEvent_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryEvent_DictionaryFragment, true
	case "OpcUa_XmlSchema_MonitoringFilter":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_MonitoringFilter, true
	case "OpcUa_XmlSchema_MonitoringFilter_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_MonitoringFilter_DataTypeVersion, true
	case "OpcUa_XmlSchema_MonitoringFilter_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_MonitoringFilter_DictionaryFragment, true
	case "OpcUa_XmlSchema_EventFilter":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EventFilter, true
	case "OpcUa_XmlSchema_EventFilter_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EventFilter_DataTypeVersion, true
	case "OpcUa_XmlSchema_EventFilter_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EventFilter_DictionaryFragment, true
	case "OpcUa_XmlSchema_AggregateConfiguration":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AggregateConfiguration, true
	case "OpcUa_XmlSchema_AggregateConfiguration_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AggregateConfiguration_DataTypeVersion, true
	case "OpcUa_XmlSchema_AggregateConfiguration_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AggregateConfiguration_DictionaryFragment, true
	case "OpcUa_XmlSchema_HistoryEventFieldList":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryEventFieldList, true
	case "OpcUa_XmlSchema_HistoryEventFieldList_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryEventFieldList_DataTypeVersion, true
	case "OpcUa_XmlSchema_HistoryEventFieldList_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryEventFieldList_DictionaryFragment, true
	case "OpcUa_XmlSchema_RedundantServerDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RedundantServerDataType, true
	case "OpcUa_XmlSchema_RedundantServerDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RedundantServerDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_RedundantServerDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RedundantServerDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_SamplingIntervalDiagnosticsDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SamplingIntervalDiagnosticsDataType, true
	case "OpcUa_XmlSchema_SamplingIntervalDiagnosticsDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SamplingIntervalDiagnosticsDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_SamplingIntervalDiagnosticsDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SamplingIntervalDiagnosticsDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_ServerDiagnosticsSummaryDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerDiagnosticsSummaryDataType, true
	case "OpcUa_XmlSchema_ServerDiagnosticsSummaryDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerDiagnosticsSummaryDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_ServerDiagnosticsSummaryDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerDiagnosticsSummaryDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_ServerStatusDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerStatusDataType, true
	case "OpcUa_XmlSchema_ServerStatusDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerStatusDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_ServerStatusDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerStatusDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_SessionDiagnosticsDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SessionDiagnosticsDataType, true
	case "OpcUa_XmlSchema_SessionDiagnosticsDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SessionDiagnosticsDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_SessionDiagnosticsDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SessionDiagnosticsDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_SessionSecurityDiagnosticsDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SessionSecurityDiagnosticsDataType, true
	case "OpcUa_XmlSchema_SessionSecurityDiagnosticsDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SessionSecurityDiagnosticsDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_SessionSecurityDiagnosticsDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SessionSecurityDiagnosticsDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_ServiceCounterDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServiceCounterDataType, true
	case "OpcUa_XmlSchema_ServiceCounterDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServiceCounterDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_ServiceCounterDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServiceCounterDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_SubscriptionDiagnosticsDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscriptionDiagnosticsDataType, true
	case "OpcUa_XmlSchema_SubscriptionDiagnosticsDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscriptionDiagnosticsDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_SubscriptionDiagnosticsDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscriptionDiagnosticsDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_ModelChangeStructureDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ModelChangeStructureDataType, true
	case "OpcUa_XmlSchema_ModelChangeStructureDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ModelChangeStructureDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_ModelChangeStructureDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ModelChangeStructureDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_SemanticChangeStructureDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SemanticChangeStructureDataType, true
	case "OpcUa_XmlSchema_SemanticChangeStructureDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SemanticChangeStructureDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_SemanticChangeStructureDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SemanticChangeStructureDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_Range":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Range, true
	case "OpcUa_XmlSchema_Range_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Range_DataTypeVersion, true
	case "OpcUa_XmlSchema_Range_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Range_DictionaryFragment, true
	case "OpcUa_XmlSchema_EUInformation":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EUInformation, true
	case "OpcUa_XmlSchema_EUInformation_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EUInformation_DataTypeVersion, true
	case "OpcUa_XmlSchema_EUInformation_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EUInformation_DictionaryFragment, true
	case "OpcUa_XmlSchema_Annotation":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Annotation, true
	case "OpcUa_XmlSchema_Annotation_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Annotation_DataTypeVersion, true
	case "OpcUa_XmlSchema_Annotation_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Annotation_DictionaryFragment, true
	case "OpcUa_XmlSchema_ProgramDiagnosticDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ProgramDiagnosticDataType, true
	case "OpcUa_XmlSchema_ProgramDiagnosticDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ProgramDiagnosticDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_ProgramDiagnosticDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ProgramDiagnosticDataType_DictionaryFragment, true
	case "OpcUa_BinarySchema_TimeZoneDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TimeZoneDataType, true
	case "OpcUa_BinarySchema_TimeZoneDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TimeZoneDataType_DataTypeVersion, true
	case "OpcUa_BinarySchema_TimeZoneDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TimeZoneDataType_DictionaryFragment, true
	case "OpcUa_XmlSchema_TimeZoneDataType":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TimeZoneDataType, true
	case "OpcUa_XmlSchema_TimeZoneDataType_DataTypeVersion":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TimeZoneDataType_DataTypeVersion, true
	case "OpcUa_XmlSchema_TimeZoneDataType_DictionaryFragment":
		return OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TimeZoneDataType_DictionaryFragment, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableOpcKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableOpcValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableOpc(structType any) OpcuaNodeIdServicesVariableOpc {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableOpc {
		if sOpcuaNodeIdServicesVariableOpc, ok := typ.(OpcuaNodeIdServicesVariableOpc); ok {
			return sOpcuaNodeIdServicesVariableOpc
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableOpc) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableOpc) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableOpcParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableOpc, error) {
	return OpcuaNodeIdServicesVariableOpcParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableOpcParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableOpc, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableOpc", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableOpc")
	}
	if enum, ok := OpcuaNodeIdServicesVariableOpcByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableOpc")
		return OpcuaNodeIdServicesVariableOpc(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableOpc) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableOpc) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableOpc", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableOpc) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointUrlListDataType:
		return "OpcUa_XmlSchema_EndpointUrlListDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointUrlListDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_EndpointUrlListDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointUrlListDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_EndpointUrlListDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkGroupDataType:
		return "OpcUa_XmlSchema_NetworkGroupDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkGroupDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_NetworkGroupDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkGroupDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_NetworkGroupDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointUrlListDataType:
		return "OpcUa_BinarySchema_EndpointUrlListDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointUrlListDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_EndpointUrlListDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointUrlListDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_EndpointUrlListDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkGroupDataType:
		return "OpcUa_BinarySchema_NetworkGroupDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkGroupDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_NetworkGroupDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkGroupDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_NetworkGroupDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AxisInformation:
		return "OpcUa_XmlSchema_AxisInformation"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AxisInformation_DataTypeVersion:
		return "OpcUa_XmlSchema_AxisInformation_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AxisInformation_DictionaryFragment:
		return "OpcUa_XmlSchema_AxisInformation_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_XVType:
		return "OpcUa_XmlSchema_XVType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_XVType_DataTypeVersion:
		return "OpcUa_XmlSchema_XVType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_XVType_DictionaryFragment:
		return "OpcUa_XmlSchema_XVType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AxisInformation:
		return "OpcUa_BinarySchema_AxisInformation"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AxisInformation_DataTypeVersion:
		return "OpcUa_BinarySchema_AxisInformation_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AxisInformation_DictionaryFragment:
		return "OpcUa_BinarySchema_AxisInformation_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_XVType:
		return "OpcUa_BinarySchema_XVType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_XVType_DataTypeVersion:
		return "OpcUa_BinarySchema_XVType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_XVType_DictionaryFragment:
		return "OpcUa_BinarySchema_XVType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ComplexNumberType:
		return "OpcUa_XmlSchema_ComplexNumberType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ComplexNumberType_DataTypeVersion:
		return "OpcUa_XmlSchema_ComplexNumberType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ComplexNumberType_DictionaryFragment:
		return "OpcUa_XmlSchema_ComplexNumberType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DoubleComplexNumberType:
		return "OpcUa_XmlSchema_DoubleComplexNumberType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DoubleComplexNumberType_DataTypeVersion:
		return "OpcUa_XmlSchema_DoubleComplexNumberType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DoubleComplexNumberType_DictionaryFragment:
		return "OpcUa_XmlSchema_DoubleComplexNumberType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ComplexNumberType:
		return "OpcUa_BinarySchema_ComplexNumberType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ComplexNumberType_DataTypeVersion:
		return "OpcUa_BinarySchema_ComplexNumberType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ComplexNumberType_DictionaryFragment:
		return "OpcUa_BinarySchema_ComplexNumberType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DoubleComplexNumberType:
		return "OpcUa_BinarySchema_DoubleComplexNumberType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DoubleComplexNumberType_DataTypeVersion:
		return "OpcUa_BinarySchema_DoubleComplexNumberType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DoubleComplexNumberType_DictionaryFragment:
		return "OpcUa_BinarySchema_DoubleComplexNumberType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerOnNetwork:
		return "OpcUa_XmlSchema_ServerOnNetwork"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerOnNetwork_DataTypeVersion:
		return "OpcUa_XmlSchema_ServerOnNetwork_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerOnNetwork_DictionaryFragment:
		return "OpcUa_XmlSchema_ServerOnNetwork_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerOnNetwork:
		return "OpcUa_BinarySchema_ServerOnNetwork"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerOnNetwork_DataTypeVersion:
		return "OpcUa_BinarySchema_ServerOnNetwork_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerOnNetwork_DictionaryFragment:
		return "OpcUa_BinarySchema_ServerOnNetwork_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TrustListDataType:
		return "OpcUa_XmlSchema_TrustListDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TrustListDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_TrustListDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TrustListDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_TrustListDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TrustListDataType:
		return "OpcUa_BinarySchema_TrustListDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TrustListDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_TrustListDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TrustListDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_TrustListDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RelativePathElement:
		return "OpcUa_XmlSchema_RelativePathElement"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RelativePathElement_DataTypeVersion:
		return "OpcUa_XmlSchema_RelativePathElement_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RelativePathElement_DictionaryFragment:
		return "OpcUa_XmlSchema_RelativePathElement_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RelativePath:
		return "OpcUa_XmlSchema_RelativePath"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RelativePath_DataTypeVersion:
		return "OpcUa_XmlSchema_RelativePath_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RelativePath_DictionaryFragment:
		return "OpcUa_XmlSchema_RelativePath_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RelativePathElement:
		return "OpcUa_BinarySchema_RelativePathElement"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RelativePathElement_DataTypeVersion:
		return "OpcUa_BinarySchema_RelativePathElement_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RelativePathElement_DictionaryFragment:
		return "OpcUa_BinarySchema_RelativePathElement_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RelativePath:
		return "OpcUa_BinarySchema_RelativePath"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RelativePath_DataTypeVersion:
		return "OpcUa_BinarySchema_RelativePath_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RelativePath_DictionaryFragment:
		return "OpcUa_BinarySchema_RelativePath_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_OptionSet:
		return "OpcUa_XmlSchema_OptionSet"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_OptionSet_DataTypeVersion:
		return "OpcUa_XmlSchema_OptionSet_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_OptionSet_DictionaryFragment:
		return "OpcUa_XmlSchema_OptionSet_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Union:
		return "OpcUa_XmlSchema_Union"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Union_DataTypeVersion:
		return "OpcUa_XmlSchema_Union_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Union_DictionaryFragment:
		return "OpcUa_XmlSchema_Union_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_OptionSet:
		return "OpcUa_BinarySchema_OptionSet"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_OptionSet_DataTypeVersion:
		return "OpcUa_BinarySchema_OptionSet_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_OptionSet_DictionaryFragment:
		return "OpcUa_BinarySchema_OptionSet_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Union:
		return "OpcUa_BinarySchema_Union"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Union_DataTypeVersion:
		return "OpcUa_BinarySchema_Union_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Union_DictionaryFragment:
		return "OpcUa_BinarySchema_Union_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DiscoveryConfiguration:
		return "OpcUa_XmlSchema_DiscoveryConfiguration"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DiscoveryConfiguration_DataTypeVersion:
		return "OpcUa_XmlSchema_DiscoveryConfiguration_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DiscoveryConfiguration_DictionaryFragment:
		return "OpcUa_XmlSchema_DiscoveryConfiguration_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_MdnsDiscoveryConfiguration:
		return "OpcUa_XmlSchema_MdnsDiscoveryConfiguration"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_MdnsDiscoveryConfiguration_DataTypeVersion:
		return "OpcUa_XmlSchema_MdnsDiscoveryConfiguration_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_MdnsDiscoveryConfiguration_DictionaryFragment:
		return "OpcUa_XmlSchema_MdnsDiscoveryConfiguration_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DiscoveryConfiguration:
		return "OpcUa_BinarySchema_DiscoveryConfiguration"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DiscoveryConfiguration_DataTypeVersion:
		return "OpcUa_BinarySchema_DiscoveryConfiguration_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DiscoveryConfiguration_DictionaryFragment:
		return "OpcUa_BinarySchema_DiscoveryConfiguration_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_MdnsDiscoveryConfiguration:
		return "OpcUa_BinarySchema_MdnsDiscoveryConfiguration"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_MdnsDiscoveryConfiguration_DataTypeVersion:
		return "OpcUa_BinarySchema_MdnsDiscoveryConfiguration_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_MdnsDiscoveryConfiguration_DictionaryFragment:
		return "OpcUa_BinarySchema_MdnsDiscoveryConfiguration_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedVariableDataType:
		return "OpcUa_XmlSchema_PublishedVariableDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedVariableDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_PublishedVariableDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedVariableDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_PublishedVariableDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedVariableDataType:
		return "OpcUa_BinarySchema_PublishedVariableDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedVariableDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_PublishedVariableDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedVariableDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_PublishedVariableDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetMetaDataType:
		return "OpcUa_XmlSchema_DataSetMetaDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetMetaDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_DataSetMetaDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetMetaDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_DataSetMetaDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FieldMetaData:
		return "OpcUa_XmlSchema_FieldMetaData"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FieldMetaData_DataTypeVersion:
		return "OpcUa_XmlSchema_FieldMetaData_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FieldMetaData_DictionaryFragment:
		return "OpcUa_XmlSchema_FieldMetaData_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeDescription:
		return "OpcUa_XmlSchema_DataTypeDescription"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeDescription_DataTypeVersion:
		return "OpcUa_XmlSchema_DataTypeDescription_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeDescription_DictionaryFragment:
		return "OpcUa_XmlSchema_DataTypeDescription_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumField:
		return "OpcUa_XmlSchema_EnumField"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumField_DataTypeVersion:
		return "OpcUa_XmlSchema_EnumField_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumField_DictionaryFragment:
		return "OpcUa_XmlSchema_EnumField_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_KeyValuePair:
		return "OpcUa_XmlSchema_KeyValuePair"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_KeyValuePair_DataTypeVersion:
		return "OpcUa_XmlSchema_KeyValuePair_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_KeyValuePair_DictionaryFragment:
		return "OpcUa_XmlSchema_KeyValuePair_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ConfigurationVersionDataType:
		return "OpcUa_XmlSchema_ConfigurationVersionDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ConfigurationVersionDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_ConfigurationVersionDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ConfigurationVersionDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_ConfigurationVersionDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FieldTargetDataType:
		return "OpcUa_XmlSchema_FieldTargetDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FieldTargetDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_FieldTargetDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FieldTargetDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_FieldTargetDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetMetaDataType:
		return "OpcUa_BinarySchema_DataSetMetaDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetMetaDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_DataSetMetaDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetMetaDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_DataSetMetaDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FieldMetaData:
		return "OpcUa_BinarySchema_FieldMetaData"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FieldMetaData_DataTypeVersion:
		return "OpcUa_BinarySchema_FieldMetaData_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FieldMetaData_DictionaryFragment:
		return "OpcUa_BinarySchema_FieldMetaData_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeDescription:
		return "OpcUa_BinarySchema_DataTypeDescription"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeDescription_DataTypeVersion:
		return "OpcUa_BinarySchema_DataTypeDescription_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeDescription_DictionaryFragment:
		return "OpcUa_BinarySchema_DataTypeDescription_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumField:
		return "OpcUa_BinarySchema_EnumField"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumField_DataTypeVersion:
		return "OpcUa_BinarySchema_EnumField_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumField_DictionaryFragment:
		return "OpcUa_BinarySchema_EnumField_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_KeyValuePair:
		return "OpcUa_BinarySchema_KeyValuePair"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_KeyValuePair_DataTypeVersion:
		return "OpcUa_BinarySchema_KeyValuePair_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_KeyValuePair_DictionaryFragment:
		return "OpcUa_BinarySchema_KeyValuePair_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ConfigurationVersionDataType:
		return "OpcUa_BinarySchema_ConfigurationVersionDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ConfigurationVersionDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_ConfigurationVersionDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ConfigurationVersionDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_ConfigurationVersionDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FieldTargetDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_FieldTargetDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FieldTargetDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_FieldTargetDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ModificationInfo:
		return "OpcUa_BinarySchema_ModificationInfo"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ModificationInfo_DataTypeVersion:
		return "OpcUa_BinarySchema_ModificationInfo_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ModificationInfo_DictionaryFragment:
		return "OpcUa_BinarySchema_ModificationInfo_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ModificationInfo:
		return "OpcUa_XmlSchema_ModificationInfo"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ModificationInfo_DataTypeVersion:
		return "OpcUa_XmlSchema_ModificationInfo_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ModificationInfo_DictionaryFragment:
		return "OpcUa_XmlSchema_ModificationInfo_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Deprecated:
		return "OpcUa_BinarySchema_Deprecated"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Deprecated:
		return "OpcUa_XmlSchema_Deprecated"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SimpleTypeDescription:
		return "OpcUa_BinarySchema_SimpleTypeDescription"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SimpleTypeDescription_DataTypeVersion:
		return "OpcUa_BinarySchema_SimpleTypeDescription_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SimpleTypeDescription_DictionaryFragment:
		return "OpcUa_BinarySchema_SimpleTypeDescription_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UABinaryFileDataType:
		return "OpcUa_BinarySchema_UABinaryFileDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UABinaryFileDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_UABinaryFileDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UABinaryFileDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_UABinaryFileDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerConnectionTransportDataType:
		return "OpcUa_BinarySchema_BrokerConnectionTransportDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerConnectionTransportDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_BrokerConnectionTransportDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerConnectionTransportDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_BrokerConnectionTransportDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SimpleTypeDescription:
		return "OpcUa_XmlSchema_SimpleTypeDescription"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SimpleTypeDescription_DataTypeVersion:
		return "OpcUa_XmlSchema_SimpleTypeDescription_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SimpleTypeDescription_DictionaryFragment:
		return "OpcUa_XmlSchema_SimpleTypeDescription_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UABinaryFileDataType:
		return "OpcUa_XmlSchema_UABinaryFileDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureDescription:
		return "OpcUa_XmlSchema_StructureDescription"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureDescription_DataTypeVersion:
		return "OpcUa_XmlSchema_StructureDescription_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureDescription_DictionaryFragment:
		return "OpcUa_XmlSchema_StructureDescription_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumDescription:
		return "OpcUa_XmlSchema_EnumDescription"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumDescription_DataTypeVersion:
		return "OpcUa_XmlSchema_EnumDescription_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumDescription_DictionaryFragment:
		return "OpcUa_XmlSchema_EnumDescription_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureDescription:
		return "OpcUa_BinarySchema_StructureDescription"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureDescription_DataTypeVersion:
		return "OpcUa_BinarySchema_StructureDescription_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureDescription_DictionaryFragment:
		return "OpcUa_BinarySchema_StructureDescription_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumDescription:
		return "OpcUa_BinarySchema_EnumDescription"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumDescription_DataTypeVersion:
		return "OpcUa_BinarySchema_EnumDescription_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumDescription_DictionaryFragment:
		return "OpcUa_BinarySchema_EnumDescription_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UABinaryFileDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_UABinaryFileDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UABinaryFileDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_UABinaryFileDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerConnectionTransportDataType:
		return "OpcUa_XmlSchema_BrokerConnectionTransportDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerConnectionTransportDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_BrokerConnectionTransportDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerConnectionTransportDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_BrokerConnectionTransportDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_IdentityMappingRuleType:
		return "OpcUa_XmlSchema_IdentityMappingRuleType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_IdentityMappingRuleType_DataTypeVersion:
		return "OpcUa_XmlSchema_IdentityMappingRuleType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_IdentityMappingRuleType_DictionaryFragment:
		return "OpcUa_XmlSchema_IdentityMappingRuleType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointType:
		return "OpcUa_BinarySchema_EndpointType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointType_DataTypeVersion:
		return "OpcUa_BinarySchema_EndpointType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointType_DictionaryFragment:
		return "OpcUa_BinarySchema_EndpointType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_IdentityMappingRuleType:
		return "OpcUa_BinarySchema_IdentityMappingRuleType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_IdentityMappingRuleType_DataTypeVersion:
		return "OpcUa_BinarySchema_IdentityMappingRuleType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_IdentityMappingRuleType_DictionaryFragment:
		return "OpcUa_BinarySchema_IdentityMappingRuleType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeSchemaHeader:
		return "OpcUa_BinarySchema_DataTypeSchemaHeader"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeSchemaHeader_DataTypeVersion:
		return "OpcUa_BinarySchema_DataTypeSchemaHeader_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeSchemaHeader_DictionaryFragment:
		return "OpcUa_BinarySchema_DataTypeSchemaHeader_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetDataType:
		return "OpcUa_BinarySchema_PublishedDataSetDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_PublishedDataSetDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_PublishedDataSetDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetSourceDataType:
		return "OpcUa_BinarySchema_PublishedDataSetSourceDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetSourceDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_PublishedDataSetSourceDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetSourceDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_PublishedDataSetSourceDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataItemsDataType:
		return "OpcUa_BinarySchema_PublishedDataItemsDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataItemsDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_PublishedDataItemsDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataItemsDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_PublishedDataItemsDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedEventsDataType:
		return "OpcUa_BinarySchema_PublishedEventsDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedEventsDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_PublishedEventsDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedEventsDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_PublishedEventsDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterDataType:
		return "OpcUa_BinarySchema_DataSetWriterDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_DataSetWriterDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_DataSetWriterDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterTransportDataType:
		return "OpcUa_BinarySchema_DataSetWriterTransportDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterTransportDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_DataSetWriterTransportDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterTransportDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_DataSetWriterTransportDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterMessageDataType:
		return "OpcUa_BinarySchema_DataSetWriterMessageDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterMessageDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_DataSetWriterMessageDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetWriterMessageDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_DataSetWriterMessageDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubGroupDataType:
		return "OpcUa_BinarySchema_PubSubGroupDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubGroupDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_PubSubGroupDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubGroupDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_PubSubGroupDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupTransportDataType:
		return "OpcUa_BinarySchema_WriterGroupTransportDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupTransportDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_WriterGroupTransportDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupTransportDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_WriterGroupTransportDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupMessageDataType:
		return "OpcUa_BinarySchema_WriterGroupMessageDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupMessageDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_WriterGroupMessageDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupMessageDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_WriterGroupMessageDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConnectionDataType:
		return "OpcUa_BinarySchema_PubSubConnectionDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConnectionDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_PubSubConnectionDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConnectionDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_PubSubConnectionDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ConnectionTransportDataType:
		return "OpcUa_BinarySchema_ConnectionTransportDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ConnectionTransportDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_ConnectionTransportDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ConnectionTransportDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_ConnectionTransportDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupTransportDataType:
		return "OpcUa_BinarySchema_ReaderGroupTransportDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupTransportDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_ReaderGroupTransportDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupTransportDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_ReaderGroupTransportDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupMessageDataType:
		return "OpcUa_BinarySchema_ReaderGroupMessageDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupMessageDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_ReaderGroupMessageDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupMessageDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_ReaderGroupMessageDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderDataType:
		return "OpcUa_BinarySchema_DataSetReaderDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_DataSetReaderDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_DataSetReaderDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderTransportDataType:
		return "OpcUa_BinarySchema_DataSetReaderTransportDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderTransportDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_DataSetReaderTransportDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderTransportDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_DataSetReaderTransportDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderMessageDataType:
		return "OpcUa_BinarySchema_DataSetReaderMessageDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderMessageDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_DataSetReaderMessageDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataSetReaderMessageDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_DataSetReaderMessageDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscribedDataSetDataType:
		return "OpcUa_BinarySchema_SubscribedDataSetDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscribedDataSetDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_SubscribedDataSetDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscribedDataSetDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_SubscribedDataSetDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TargetVariablesDataType:
		return "OpcUa_BinarySchema_TargetVariablesDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TargetVariablesDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_TargetVariablesDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TargetVariablesDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_TargetVariablesDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscribedDataSetMirrorDataType:
		return "OpcUa_BinarySchema_SubscribedDataSetMirrorDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscribedDataSetMirrorDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_SubscribedDataSetMirrorDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscribedDataSetMirrorDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_SubscribedDataSetMirrorDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpWriterGroupMessageDataType:
		return "OpcUa_BinarySchema_UadpWriterGroupMessageDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpWriterGroupMessageDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_UadpWriterGroupMessageDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpWriterGroupMessageDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_UadpWriterGroupMessageDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpDataSetWriterMessageDataType:
		return "OpcUa_BinarySchema_UadpDataSetWriterMessageDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpDataSetWriterMessageDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_UadpDataSetWriterMessageDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpDataSetWriterMessageDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_UadpDataSetWriterMessageDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpDataSetReaderMessageDataType:
		return "OpcUa_BinarySchema_UadpDataSetReaderMessageDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpDataSetReaderMessageDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_UadpDataSetReaderMessageDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UadpDataSetReaderMessageDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_UadpDataSetReaderMessageDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonWriterGroupMessageDataType:
		return "OpcUa_BinarySchema_JsonWriterGroupMessageDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonWriterGroupMessageDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_JsonWriterGroupMessageDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonWriterGroupMessageDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_JsonWriterGroupMessageDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonDataSetWriterMessageDataType:
		return "OpcUa_BinarySchema_JsonDataSetWriterMessageDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonDataSetWriterMessageDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_JsonDataSetWriterMessageDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonDataSetWriterMessageDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_JsonDataSetWriterMessageDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonDataSetReaderMessageDataType:
		return "OpcUa_BinarySchema_JsonDataSetReaderMessageDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonDataSetReaderMessageDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_JsonDataSetReaderMessageDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_JsonDataSetReaderMessageDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_JsonDataSetReaderMessageDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerWriterGroupTransportDataType:
		return "OpcUa_BinarySchema_BrokerWriterGroupTransportDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerWriterGroupTransportDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_BrokerWriterGroupTransportDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerWriterGroupTransportDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_BrokerWriterGroupTransportDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerDataSetWriterTransportDataType:
		return "OpcUa_BinarySchema_BrokerDataSetWriterTransportDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerDataSetWriterTransportDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_BrokerDataSetWriterTransportDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerDataSetWriterTransportDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_BrokerDataSetWriterTransportDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerDataSetReaderTransportDataType:
		return "OpcUa_BinarySchema_BrokerDataSetReaderTransportDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerDataSetReaderTransportDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_BrokerDataSetReaderTransportDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BrokerDataSetReaderTransportDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_BrokerDataSetReaderTransportDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointType:
		return "OpcUa_XmlSchema_EndpointType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointType_DataTypeVersion:
		return "OpcUa_XmlSchema_EndpointType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointType_DictionaryFragment:
		return "OpcUa_XmlSchema_EndpointType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeSchemaHeader:
		return "OpcUa_XmlSchema_DataTypeSchemaHeader"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeSchemaHeader_DataTypeVersion:
		return "OpcUa_XmlSchema_DataTypeSchemaHeader_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeSchemaHeader_DictionaryFragment:
		return "OpcUa_XmlSchema_DataTypeSchemaHeader_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetDataType:
		return "OpcUa_XmlSchema_PublishedDataSetDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_PublishedDataSetDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_PublishedDataSetDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetSourceDataType:
		return "OpcUa_XmlSchema_PublishedDataSetSourceDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetSourceDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_PublishedDataSetSourceDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetSourceDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_PublishedDataSetSourceDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataItemsDataType:
		return "OpcUa_XmlSchema_PublishedDataItemsDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataItemsDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_PublishedDataItemsDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataItemsDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_PublishedDataItemsDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedEventsDataType:
		return "OpcUa_XmlSchema_PublishedEventsDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedEventsDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_PublishedEventsDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedEventsDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_PublishedEventsDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterDataType:
		return "OpcUa_XmlSchema_DataSetWriterDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_DataSetWriterDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_DataSetWriterDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterTransportDataType:
		return "OpcUa_XmlSchema_DataSetWriterTransportDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterTransportDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_DataSetWriterTransportDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterTransportDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_DataSetWriterTransportDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterMessageDataType:
		return "OpcUa_XmlSchema_DataSetWriterMessageDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterMessageDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_DataSetWriterMessageDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetWriterMessageDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_DataSetWriterMessageDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubGroupDataType:
		return "OpcUa_XmlSchema_PubSubGroupDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubGroupDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_PubSubGroupDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubGroupDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_PubSubGroupDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupTransportDataType:
		return "OpcUa_XmlSchema_WriterGroupTransportDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupTransportDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_WriterGroupTransportDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupTransportDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_WriterGroupTransportDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupMessageDataType:
		return "OpcUa_XmlSchema_WriterGroupMessageDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupMessageDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_WriterGroupMessageDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupMessageDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_WriterGroupMessageDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConnectionDataType:
		return "OpcUa_XmlSchema_PubSubConnectionDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConnectionDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_PubSubConnectionDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConnectionDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_PubSubConnectionDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ConnectionTransportDataType:
		return "OpcUa_XmlSchema_ConnectionTransportDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ConnectionTransportDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_ConnectionTransportDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ConnectionTransportDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_ConnectionTransportDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupTransportDataType:
		return "OpcUa_XmlSchema_ReaderGroupTransportDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupTransportDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_ReaderGroupTransportDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupTransportDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_ReaderGroupTransportDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupMessageDataType:
		return "OpcUa_XmlSchema_ReaderGroupMessageDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupMessageDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_ReaderGroupMessageDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupMessageDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_ReaderGroupMessageDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderDataType:
		return "OpcUa_XmlSchema_DataSetReaderDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_DataSetReaderDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_DataSetReaderDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderTransportDataType:
		return "OpcUa_XmlSchema_DataSetReaderTransportDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderTransportDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_DataSetReaderTransportDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderTransportDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_DataSetReaderTransportDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderMessageDataType:
		return "OpcUa_XmlSchema_DataSetReaderMessageDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderMessageDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_DataSetReaderMessageDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataSetReaderMessageDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_DataSetReaderMessageDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscribedDataSetDataType:
		return "OpcUa_XmlSchema_SubscribedDataSetDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscribedDataSetDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_SubscribedDataSetDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscribedDataSetDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_SubscribedDataSetDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TargetVariablesDataType:
		return "OpcUa_XmlSchema_TargetVariablesDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TargetVariablesDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_TargetVariablesDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TargetVariablesDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_TargetVariablesDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscribedDataSetMirrorDataType:
		return "OpcUa_XmlSchema_SubscribedDataSetMirrorDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscribedDataSetMirrorDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_SubscribedDataSetMirrorDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscribedDataSetMirrorDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_SubscribedDataSetMirrorDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpWriterGroupMessageDataType:
		return "OpcUa_XmlSchema_UadpWriterGroupMessageDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpWriterGroupMessageDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_UadpWriterGroupMessageDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpWriterGroupMessageDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_UadpWriterGroupMessageDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpDataSetWriterMessageDataType:
		return "OpcUa_XmlSchema_UadpDataSetWriterMessageDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpDataSetWriterMessageDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_UadpDataSetWriterMessageDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpDataSetWriterMessageDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_UadpDataSetWriterMessageDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpDataSetReaderMessageDataType:
		return "OpcUa_XmlSchema_UadpDataSetReaderMessageDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpDataSetReaderMessageDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_UadpDataSetReaderMessageDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UadpDataSetReaderMessageDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_UadpDataSetReaderMessageDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonWriterGroupMessageDataType:
		return "OpcUa_XmlSchema_JsonWriterGroupMessageDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonWriterGroupMessageDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_JsonWriterGroupMessageDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonWriterGroupMessageDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_JsonWriterGroupMessageDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonDataSetWriterMessageDataType:
		return "OpcUa_XmlSchema_JsonDataSetWriterMessageDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonDataSetWriterMessageDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_JsonDataSetWriterMessageDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonDataSetWriterMessageDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_JsonDataSetWriterMessageDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonDataSetReaderMessageDataType:
		return "OpcUa_XmlSchema_JsonDataSetReaderMessageDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonDataSetReaderMessageDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_JsonDataSetReaderMessageDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_JsonDataSetReaderMessageDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_JsonDataSetReaderMessageDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerWriterGroupTransportDataType:
		return "OpcUa_XmlSchema_BrokerWriterGroupTransportDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RolePermissionType:
		return "OpcUa_XmlSchema_RolePermissionType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RolePermissionType_DataTypeVersion:
		return "OpcUa_XmlSchema_RolePermissionType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RolePermissionType_DictionaryFragment:
		return "OpcUa_XmlSchema_RolePermissionType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerWriterGroupTransportDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_BrokerWriterGroupTransportDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RolePermissionType:
		return "OpcUa_BinarySchema_RolePermissionType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RolePermissionType_DataTypeVersion:
		return "OpcUa_BinarySchema_RolePermissionType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RolePermissionType_DictionaryFragment:
		return "OpcUa_BinarySchema_RolePermissionType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerWriterGroupTransportDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_BrokerWriterGroupTransportDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerDataSetWriterTransportDataType:
		return "OpcUa_XmlSchema_BrokerDataSetWriterTransportDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerDataSetWriterTransportDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_BrokerDataSetWriterTransportDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerDataSetWriterTransportDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_BrokerDataSetWriterTransportDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerDataSetReaderTransportDataType:
		return "OpcUa_XmlSchema_BrokerDataSetReaderTransportDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerDataSetReaderTransportDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_BrokerDataSetReaderTransportDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BrokerDataSetReaderTransportDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_BrokerDataSetReaderTransportDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramConnectionTransportDataType:
		return "OpcUa_BinarySchema_DatagramConnectionTransportDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramConnectionTransportDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_DatagramConnectionTransportDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramConnectionTransportDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_DatagramConnectionTransportDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramConnectionTransportDataType:
		return "OpcUa_XmlSchema_DatagramConnectionTransportDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramConnectionTransportDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_DatagramConnectionTransportDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramConnectionTransportDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_DatagramConnectionTransportDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AdditionalParametersType:
		return "OpcUa_BinarySchema_AdditionalParametersType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AdditionalParametersType_DataTypeVersion:
		return "OpcUa_BinarySchema_AdditionalParametersType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AdditionalParametersType_DictionaryFragment:
		return "OpcUa_BinarySchema_AdditionalParametersType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AdditionalParametersType:
		return "OpcUa_XmlSchema_AdditionalParametersType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AdditionalParametersType_DataTypeVersion:
		return "OpcUa_XmlSchema_AdditionalParametersType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AdditionalParametersType_DictionaryFragment:
		return "OpcUa_XmlSchema_AdditionalParametersType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EphemeralKeyType:
		return "OpcUa_BinarySchema_EphemeralKeyType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EphemeralKeyType_DataTypeVersion:
		return "OpcUa_BinarySchema_EphemeralKeyType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EphemeralKeyType_DictionaryFragment:
		return "OpcUa_BinarySchema_EphemeralKeyType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EphemeralKeyType:
		return "OpcUa_XmlSchema_EphemeralKeyType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EphemeralKeyType_DataTypeVersion:
		return "OpcUa_XmlSchema_EphemeralKeyType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EphemeralKeyType_DictionaryFragment:
		return "OpcUa_XmlSchema_EphemeralKeyType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeDefinition:
		return "OpcUa_XmlSchema_DataTypeDefinition"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeDefinition_DataTypeVersion:
		return "OpcUa_XmlSchema_DataTypeDefinition_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeDefinition_DictionaryFragment:
		return "OpcUa_XmlSchema_DataTypeDefinition_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureField:
		return "OpcUa_XmlSchema_StructureField"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureField_DataTypeVersion:
		return "OpcUa_XmlSchema_StructureField_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureField_DictionaryFragment:
		return "OpcUa_XmlSchema_StructureField_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureDefinition:
		return "OpcUa_XmlSchema_StructureDefinition"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureDefinition_DataTypeVersion:
		return "OpcUa_XmlSchema_StructureDefinition_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StructureDefinition_DictionaryFragment:
		return "OpcUa_XmlSchema_StructureDefinition_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumDefinition:
		return "OpcUa_XmlSchema_EnumDefinition"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumDefinition_DataTypeVersion:
		return "OpcUa_XmlSchema_EnumDefinition_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumDefinition_DictionaryFragment:
		return "OpcUa_XmlSchema_EnumDefinition_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeDefinition:
		return "OpcUa_BinarySchema_DataTypeDefinition"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeDefinition_DataTypeVersion:
		return "OpcUa_BinarySchema_DataTypeDefinition_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeDefinition_DictionaryFragment:
		return "OpcUa_BinarySchema_DataTypeDefinition_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureField:
		return "OpcUa_BinarySchema_StructureField"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureField_DataTypeVersion:
		return "OpcUa_BinarySchema_StructureField_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureField_DictionaryFragment:
		return "OpcUa_BinarySchema_StructureField_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureDefinition:
		return "OpcUa_BinarySchema_StructureDefinition"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureDefinition_DataTypeVersion:
		return "OpcUa_BinarySchema_StructureDefinition_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StructureDefinition_DictionaryFragment:
		return "OpcUa_BinarySchema_StructureDefinition_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumDefinition:
		return "OpcUa_BinarySchema_EnumDefinition"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumDefinition_DataTypeVersion:
		return "OpcUa_BinarySchema_EnumDefinition_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumDefinition_DictionaryFragment:
		return "OpcUa_BinarySchema_EnumDefinition_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RationalNumber:
		return "OpcUa_BinarySchema_RationalNumber"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RationalNumber_DataTypeVersion:
		return "OpcUa_BinarySchema_RationalNumber_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RationalNumber_DictionaryFragment:
		return "OpcUa_BinarySchema_RationalNumber_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Vector:
		return "OpcUa_BinarySchema_Vector"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Vector_DataTypeVersion:
		return "OpcUa_BinarySchema_Vector_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Vector_DictionaryFragment:
		return "OpcUa_BinarySchema_Vector_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDVector:
		return "OpcUa_BinarySchema_ThreeDVector"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDVector_DataTypeVersion:
		return "OpcUa_BinarySchema_ThreeDVector_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDVector_DictionaryFragment:
		return "OpcUa_BinarySchema_ThreeDVector_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_CartesianCoordinates:
		return "OpcUa_BinarySchema_CartesianCoordinates"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_CartesianCoordinates_DataTypeVersion:
		return "OpcUa_BinarySchema_CartesianCoordinates_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_CartesianCoordinates_DictionaryFragment:
		return "OpcUa_BinarySchema_CartesianCoordinates_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDCartesianCoordinates:
		return "OpcUa_BinarySchema_ThreeDCartesianCoordinates"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDCartesianCoordinates_DataTypeVersion:
		return "OpcUa_BinarySchema_ThreeDCartesianCoordinates_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDCartesianCoordinates_DictionaryFragment:
		return "OpcUa_BinarySchema_ThreeDCartesianCoordinates_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Orientation:
		return "OpcUa_BinarySchema_Orientation"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Orientation_DataTypeVersion:
		return "OpcUa_BinarySchema_Orientation_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Orientation_DictionaryFragment:
		return "OpcUa_BinarySchema_Orientation_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDOrientation:
		return "OpcUa_BinarySchema_ThreeDOrientation"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDOrientation_DataTypeVersion:
		return "OpcUa_BinarySchema_ThreeDOrientation_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDOrientation_DictionaryFragment:
		return "OpcUa_BinarySchema_ThreeDOrientation_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Frame:
		return "OpcUa_BinarySchema_Frame"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Frame_DataTypeVersion:
		return "OpcUa_BinarySchema_Frame_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Frame_DictionaryFragment:
		return "OpcUa_BinarySchema_Frame_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDFrame:
		return "OpcUa_BinarySchema_ThreeDFrame"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDFrame_DataTypeVersion:
		return "OpcUa_BinarySchema_ThreeDFrame_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ThreeDFrame_DictionaryFragment:
		return "OpcUa_BinarySchema_ThreeDFrame_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RationalNumber:
		return "OpcUa_XmlSchema_RationalNumber"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RationalNumber_DataTypeVersion:
		return "OpcUa_XmlSchema_RationalNumber_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RationalNumber_DictionaryFragment:
		return "OpcUa_XmlSchema_RationalNumber_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Vector:
		return "OpcUa_XmlSchema_Vector"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Vector_DataTypeVersion:
		return "OpcUa_XmlSchema_Vector_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Vector_DictionaryFragment:
		return "OpcUa_XmlSchema_Vector_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDVector:
		return "OpcUa_XmlSchema_ThreeDVector"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDVector_DataTypeVersion:
		return "OpcUa_XmlSchema_ThreeDVector_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDVector_DictionaryFragment:
		return "OpcUa_XmlSchema_ThreeDVector_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_CartesianCoordinates:
		return "OpcUa_XmlSchema_CartesianCoordinates"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_CartesianCoordinates_DataTypeVersion:
		return "OpcUa_XmlSchema_CartesianCoordinates_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_CartesianCoordinates_DictionaryFragment:
		return "OpcUa_XmlSchema_CartesianCoordinates_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDCartesianCoordinates:
		return "OpcUa_XmlSchema_ThreeDCartesianCoordinates"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDCartesianCoordinates_DataTypeVersion:
		return "OpcUa_XmlSchema_ThreeDCartesianCoordinates_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDCartesianCoordinates_DictionaryFragment:
		return "OpcUa_XmlSchema_ThreeDCartesianCoordinates_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Orientation:
		return "OpcUa_XmlSchema_Orientation"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Orientation_DataTypeVersion:
		return "OpcUa_XmlSchema_Orientation_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Orientation_DictionaryFragment:
		return "OpcUa_XmlSchema_Orientation_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDOrientation:
		return "OpcUa_XmlSchema_ThreeDOrientation"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDOrientation_DataTypeVersion:
		return "OpcUa_XmlSchema_ThreeDOrientation_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDOrientation_DictionaryFragment:
		return "OpcUa_XmlSchema_ThreeDOrientation_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Frame:
		return "OpcUa_XmlSchema_Frame"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Frame_DataTypeVersion:
		return "OpcUa_XmlSchema_Frame_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Frame_DictionaryFragment:
		return "OpcUa_XmlSchema_Frame_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDFrame:
		return "OpcUa_XmlSchema_ThreeDFrame"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDFrame_DataTypeVersion:
		return "OpcUa_XmlSchema_ThreeDFrame_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ThreeDFrame_DictionaryFragment:
		return "OpcUa_XmlSchema_ThreeDFrame_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FieldTargetDataType:
		return "OpcUa_BinarySchema_FieldTargetDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupDataType:
		return "OpcUa_BinarySchema_WriterGroupDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_WriterGroupDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_WriterGroupDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_WriterGroupDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkAddressDataType:
		return "OpcUa_BinarySchema_NetworkAddressDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkAddressDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_NetworkAddressDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkAddressDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_NetworkAddressDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkAddressUrlDataType:
		return "OpcUa_BinarySchema_NetworkAddressUrlDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkAddressUrlDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_NetworkAddressUrlDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NetworkAddressUrlDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_NetworkAddressUrlDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupDataType:
		return "OpcUa_BinarySchema_ReaderGroupDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_ReaderGroupDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReaderGroupDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_ReaderGroupDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationDataType:
		return "OpcUa_BinarySchema_PubSubConfigurationDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_PubSubConfigurationDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_PubSubConfigurationDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramWriterGroupTransportDataType:
		return "OpcUa_BinarySchema_DatagramWriterGroupTransportDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramWriterGroupTransportDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_DatagramWriterGroupTransportDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramWriterGroupTransportDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_DatagramWriterGroupTransportDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupDataType:
		return "OpcUa_XmlSchema_WriterGroupDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_WriterGroupDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_WriterGroupDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_WriterGroupDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkAddressDataType:
		return "OpcUa_XmlSchema_NetworkAddressDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkAddressDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_NetworkAddressDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkAddressDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_NetworkAddressDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkAddressUrlDataType:
		return "OpcUa_XmlSchema_NetworkAddressUrlDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkAddressUrlDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_NetworkAddressUrlDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NetworkAddressUrlDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_NetworkAddressUrlDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupDataType:
		return "OpcUa_XmlSchema_ReaderGroupDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_ReaderGroupDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReaderGroupDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_ReaderGroupDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationDataType:
		return "OpcUa_XmlSchema_PubSubConfigurationDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_PubSubConfigurationDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_PubSubConfigurationDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramWriterGroupTransportDataType:
		return "OpcUa_XmlSchema_DatagramWriterGroupTransportDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramWriterGroupTransportDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_DatagramWriterGroupTransportDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramWriterGroupTransportDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_DatagramWriterGroupTransportDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AliasNameDataType:
		return "OpcUa_BinarySchema_AliasNameDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AliasNameDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_AliasNameDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AliasNameDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_AliasNameDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AliasNameDataType:
		return "OpcUa_XmlSchema_AliasNameDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AliasNameDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_AliasNameDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AliasNameDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_AliasNameDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_CurrencyUnitType:
		return "OpcUa_BinarySchema_CurrencyUnitType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_CurrencyUnitType_DataTypeVersion:
		return "OpcUa_BinarySchema_CurrencyUnitType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_CurrencyUnitType_DictionaryFragment:
		return "OpcUa_BinarySchema_CurrencyUnitType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_CurrencyUnitType:
		return "OpcUa_XmlSchema_CurrencyUnitType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_CurrencyUnitType_DataTypeVersion:
		return "OpcUa_XmlSchema_CurrencyUnitType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_CurrencyUnitType_DictionaryFragment:
		return "OpcUa_XmlSchema_CurrencyUnitType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StandaloneSubscribedDataSetRefDataType:
		return "OpcUa_BinarySchema_StandaloneSubscribedDataSetRefDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StandaloneSubscribedDataSetRefDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_StandaloneSubscribedDataSetRefDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StandaloneSubscribedDataSetRefDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_StandaloneSubscribedDataSetRefDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StandaloneSubscribedDataSetDataType:
		return "OpcUa_BinarySchema_StandaloneSubscribedDataSetDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StandaloneSubscribedDataSetDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_StandaloneSubscribedDataSetDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StandaloneSubscribedDataSetDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_StandaloneSubscribedDataSetDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SecurityGroupDataType:
		return "OpcUa_BinarySchema_SecurityGroupDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SecurityGroupDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_SecurityGroupDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SecurityGroupDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_SecurityGroupDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfiguration2DataType:
		return "OpcUa_BinarySchema_PubSubConfiguration2DataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfiguration2DataType_DataTypeVersion:
		return "OpcUa_BinarySchema_PubSubConfiguration2DataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfiguration2DataType_DictionaryFragment:
		return "OpcUa_BinarySchema_PubSubConfiguration2DataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_QosDataType:
		return "OpcUa_BinarySchema_QosDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_QosDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_QosDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_QosDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_QosDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransmitQosDataType:
		return "OpcUa_BinarySchema_TransmitQosDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransmitQosDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_TransmitQosDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransmitQosDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_TransmitQosDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransmitQosPriorityDataType:
		return "OpcUa_BinarySchema_TransmitQosPriorityDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransmitQosPriorityDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_TransmitQosPriorityDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransmitQosPriorityDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_TransmitQosPriorityDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReceiveQosDataType:
		return "OpcUa_BinarySchema_ReceiveQosDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReceiveQosDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_ReceiveQosDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReceiveQosDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_ReceiveQosDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReceiveQosPriorityDataType:
		return "OpcUa_BinarySchema_ReceiveQosPriorityDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReceiveQosPriorityDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_ReceiveQosPriorityDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReceiveQosPriorityDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_ReceiveQosPriorityDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramConnectionTransport2DataType:
		return "OpcUa_BinarySchema_DatagramConnectionTransport2DataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramConnectionTransport2DataType_DataTypeVersion:
		return "OpcUa_BinarySchema_DatagramConnectionTransport2DataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramConnectionTransport2DataType_DictionaryFragment:
		return "OpcUa_BinarySchema_DatagramConnectionTransport2DataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramWriterGroupTransport2DataType:
		return "OpcUa_BinarySchema_DatagramWriterGroupTransport2DataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramWriterGroupTransport2DataType_DataTypeVersion:
		return "OpcUa_BinarySchema_DatagramWriterGroupTransport2DataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramWriterGroupTransport2DataType_DictionaryFragment:
		return "OpcUa_BinarySchema_DatagramWriterGroupTransport2DataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramDataSetReaderTransportDataType:
		return "OpcUa_BinarySchema_DatagramDataSetReaderTransportDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramDataSetReaderTransportDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_DatagramDataSetReaderTransportDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DatagramDataSetReaderTransportDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_DatagramDataSetReaderTransportDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StandaloneSubscribedDataSetRefDataType:
		return "OpcUa_XmlSchema_StandaloneSubscribedDataSetRefDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StandaloneSubscribedDataSetRefDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_StandaloneSubscribedDataSetRefDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StandaloneSubscribedDataSetRefDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_StandaloneSubscribedDataSetRefDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StandaloneSubscribedDataSetDataType:
		return "OpcUa_XmlSchema_StandaloneSubscribedDataSetDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StandaloneSubscribedDataSetDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_StandaloneSubscribedDataSetDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StandaloneSubscribedDataSetDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_StandaloneSubscribedDataSetDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SecurityGroupDataType:
		return "OpcUa_XmlSchema_SecurityGroupDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SecurityGroupDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_SecurityGroupDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SecurityGroupDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_SecurityGroupDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfiguration2DataType:
		return "OpcUa_XmlSchema_PubSubConfiguration2DataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfiguration2DataType_DataTypeVersion:
		return "OpcUa_XmlSchema_PubSubConfiguration2DataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfiguration2DataType_DictionaryFragment:
		return "OpcUa_XmlSchema_PubSubConfiguration2DataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_QosDataType:
		return "OpcUa_XmlSchema_QosDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_QosDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_QosDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_QosDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_QosDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransmitQosDataType:
		return "OpcUa_XmlSchema_TransmitQosDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransmitQosDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_TransmitQosDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransmitQosDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_TransmitQosDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransmitQosPriorityDataType:
		return "OpcUa_XmlSchema_TransmitQosPriorityDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransmitQosPriorityDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_TransmitQosPriorityDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransmitQosPriorityDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_TransmitQosPriorityDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReceiveQosDataType:
		return "OpcUa_XmlSchema_ReceiveQosDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReceiveQosDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_ReceiveQosDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReceiveQosDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_ReceiveQosDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReceiveQosPriorityDataType:
		return "OpcUa_XmlSchema_ReceiveQosPriorityDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReceiveQosPriorityDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_ReceiveQosPriorityDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReceiveQosPriorityDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_ReceiveQosPriorityDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramConnectionTransport2DataType:
		return "OpcUa_XmlSchema_DatagramConnectionTransport2DataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramConnectionTransport2DataType_DataTypeVersion:
		return "OpcUa_XmlSchema_DatagramConnectionTransport2DataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramConnectionTransport2DataType_DictionaryFragment:
		return "OpcUa_XmlSchema_DatagramConnectionTransport2DataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramWriterGroupTransport2DataType:
		return "OpcUa_XmlSchema_DatagramWriterGroupTransport2DataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramWriterGroupTransport2DataType_DataTypeVersion:
		return "OpcUa_XmlSchema_DatagramWriterGroupTransport2DataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramWriterGroupTransport2DataType_DictionaryFragment:
		return "OpcUa_XmlSchema_DatagramWriterGroupTransport2DataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramDataSetReaderTransportDataType:
		return "OpcUa_XmlSchema_DatagramDataSetReaderTransportDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramDataSetReaderTransportDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_DatagramDataSetReaderTransportDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DatagramDataSetReaderTransportDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_DatagramDataSetReaderTransportDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ProgramDiagnostic2DataType:
		return "OpcUa_BinarySchema_ProgramDiagnostic2DataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ProgramDiagnostic2DataType_DataTypeVersion:
		return "OpcUa_BinarySchema_ProgramDiagnostic2DataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ProgramDiagnostic2DataType_DictionaryFragment:
		return "OpcUa_BinarySchema_ProgramDiagnostic2DataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ProgramDiagnostic2DataType:
		return "OpcUa_XmlSchema_ProgramDiagnostic2DataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ProgramDiagnostic2DataType_DataTypeVersion:
		return "OpcUa_XmlSchema_ProgramDiagnostic2DataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ProgramDiagnostic2DataType_DictionaryFragment:
		return "OpcUa_XmlSchema_ProgramDiagnostic2DataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PortableQualifiedName:
		return "OpcUa_BinarySchema_PortableQualifiedName"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PortableQualifiedName_DataTypeVersion:
		return "OpcUa_BinarySchema_PortableQualifiedName_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PortableQualifiedName_DictionaryFragment:
		return "OpcUa_BinarySchema_PortableQualifiedName_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PortableNodeId:
		return "OpcUa_BinarySchema_PortableNodeId"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PortableNodeId_DataTypeVersion:
		return "OpcUa_BinarySchema_PortableNodeId_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PortableNodeId_DictionaryFragment:
		return "OpcUa_BinarySchema_PortableNodeId_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UnsignedRationalNumber:
		return "OpcUa_BinarySchema_UnsignedRationalNumber"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UnsignedRationalNumber_DataTypeVersion:
		return "OpcUa_BinarySchema_UnsignedRationalNumber_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UnsignedRationalNumber_DictionaryFragment:
		return "OpcUa_BinarySchema_UnsignedRationalNumber_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PortableQualifiedName:
		return "OpcUa_XmlSchema_PortableQualifiedName"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PortableQualifiedName_DataTypeVersion:
		return "OpcUa_XmlSchema_PortableQualifiedName_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PortableQualifiedName_DictionaryFragment:
		return "OpcUa_XmlSchema_PortableQualifiedName_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PortableNodeId:
		return "OpcUa_XmlSchema_PortableNodeId"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PortableNodeId_DataTypeVersion:
		return "OpcUa_XmlSchema_PortableNodeId_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PortableNodeId_DictionaryFragment:
		return "OpcUa_XmlSchema_PortableNodeId_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UnsignedRationalNumber:
		return "OpcUa_XmlSchema_UnsignedRationalNumber"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UnsignedRationalNumber_DataTypeVersion:
		return "OpcUa_XmlSchema_UnsignedRationalNumber_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UnsignedRationalNumber_DictionaryFragment:
		return "OpcUa_XmlSchema_UnsignedRationalNumber_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserManagementDataType:
		return "OpcUa_BinarySchema_UserManagementDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserManagementDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_UserManagementDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserManagementDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_UserManagementDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserManagementDataType:
		return "OpcUa_XmlSchema_UserManagementDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserManagementDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_UserManagementDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserManagementDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_UserManagementDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PriorityMappingEntryType:
		return "OpcUa_BinarySchema_PriorityMappingEntryType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PriorityMappingEntryType_DataTypeVersion:
		return "OpcUa_BinarySchema_PriorityMappingEntryType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PriorityMappingEntryType_DictionaryFragment:
		return "OpcUa_BinarySchema_PriorityMappingEntryType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PriorityMappingEntryType:
		return "OpcUa_XmlSchema_PriorityMappingEntryType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PriorityMappingEntryType_DataTypeVersion:
		return "OpcUa_XmlSchema_PriorityMappingEntryType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PriorityMappingEntryType_DictionaryFragment:
		return "OpcUa_XmlSchema_PriorityMappingEntryType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetCustomSourceDataType:
		return "OpcUa_BinarySchema_PublishedDataSetCustomSourceDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetCustomSourceDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_PublishedDataSetCustomSourceDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PublishedDataSetCustomSourceDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_PublishedDataSetCustomSourceDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubKeyPushTargetDataType:
		return "OpcUa_BinarySchema_PubSubKeyPushTargetDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubKeyPushTargetDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_PubSubKeyPushTargetDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubKeyPushTargetDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_PubSubKeyPushTargetDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationRefDataType:
		return "OpcUa_BinarySchema_PubSubConfigurationRefDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationRefDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_PubSubConfigurationRefDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationRefDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_PubSubConfigurationRefDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationValueDataType:
		return "OpcUa_BinarySchema_PubSubConfigurationValueDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationValueDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_PubSubConfigurationValueDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_PubSubConfigurationValueDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_PubSubConfigurationValueDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetCustomSourceDataType:
		return "OpcUa_XmlSchema_PublishedDataSetCustomSourceDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetCustomSourceDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_PublishedDataSetCustomSourceDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PublishedDataSetCustomSourceDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_PublishedDataSetCustomSourceDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubKeyPushTargetDataType:
		return "OpcUa_XmlSchema_PubSubKeyPushTargetDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubKeyPushTargetDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_PubSubKeyPushTargetDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubKeyPushTargetDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_PubSubKeyPushTargetDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationRefDataType:
		return "OpcUa_XmlSchema_PubSubConfigurationRefDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationRefDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_PubSubConfigurationRefDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationRefDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_PubSubConfigurationRefDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationValueDataType:
		return "OpcUa_XmlSchema_PubSubConfigurationValueDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationValueDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_PubSubConfigurationValueDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_PubSubConfigurationValueDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_PubSubConfigurationValueDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransactionErrorType:
		return "OpcUa_BinarySchema_TransactionErrorType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransactionErrorType_DataTypeVersion:
		return "OpcUa_BinarySchema_TransactionErrorType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TransactionErrorType_DictionaryFragment:
		return "OpcUa_BinarySchema_TransactionErrorType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransactionErrorType:
		return "OpcUa_XmlSchema_TransactionErrorType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransactionErrorType_DataTypeVersion:
		return "OpcUa_XmlSchema_TransactionErrorType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TransactionErrorType_DictionaryFragment:
		return "OpcUa_XmlSchema_TransactionErrorType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BitFieldDefinition:
		return "OpcUa_BinarySchema_BitFieldDefinition"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BitFieldDefinition_DataTypeVersion:
		return "OpcUa_BinarySchema_BitFieldDefinition_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BitFieldDefinition_DictionaryFragment:
		return "OpcUa_BinarySchema_BitFieldDefinition_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BitFieldDefinition:
		return "OpcUa_XmlSchema_BitFieldDefinition"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BitFieldDefinition_DataTypeVersion:
		return "OpcUa_XmlSchema_BitFieldDefinition_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BitFieldDefinition_DictionaryFragment:
		return "OpcUa_XmlSchema_BitFieldDefinition_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AnnotationDataType:
		return "OpcUa_BinarySchema_AnnotationDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AnnotationDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_AnnotationDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AnnotationDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_AnnotationDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_LinearConversionDataType:
		return "OpcUa_BinarySchema_LinearConversionDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_LinearConversionDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_LinearConversionDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_LinearConversionDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_LinearConversionDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_QuantityDimension:
		return "OpcUa_BinarySchema_QuantityDimension"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_QuantityDimension_DataTypeVersion:
		return "OpcUa_BinarySchema_QuantityDimension_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_QuantityDimension_DictionaryFragment:
		return "OpcUa_BinarySchema_QuantityDimension_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AnnotationDataType:
		return "OpcUa_XmlSchema_AnnotationDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AnnotationDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_AnnotationDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AnnotationDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_AnnotationDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_LinearConversionDataType:
		return "OpcUa_XmlSchema_LinearConversionDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_LinearConversionDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_LinearConversionDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_LinearConversionDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_LinearConversionDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_QuantityDimension:
		return "OpcUa_XmlSchema_QuantityDimension"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_QuantityDimension_DataTypeVersion:
		return "OpcUa_XmlSchema_QuantityDimension_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_QuantityDimension_DictionaryFragment:
		return "OpcUa_XmlSchema_QuantityDimension_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReferenceDescriptionDataType:
		return "OpcUa_BinarySchema_ReferenceDescriptionDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReferenceDescriptionDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_ReferenceDescriptionDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReferenceDescriptionDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_ReferenceDescriptionDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReferenceListEntryDataType:
		return "OpcUa_BinarySchema_ReferenceListEntryDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReferenceListEntryDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_ReferenceListEntryDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ReferenceListEntryDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_ReferenceListEntryDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReferenceDescriptionDataType:
		return "OpcUa_XmlSchema_ReferenceDescriptionDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReferenceDescriptionDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_ReferenceDescriptionDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReferenceDescriptionDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_ReferenceDescriptionDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReferenceListEntryDataType:
		return "OpcUa_XmlSchema_ReferenceListEntryDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReferenceListEntryDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_ReferenceListEntryDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ReferenceListEntryDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_ReferenceListEntryDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryModifiedEvent:
		return "OpcUa_BinarySchema_HistoryModifiedEvent"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryModifiedEvent_DataTypeVersion:
		return "OpcUa_BinarySchema_HistoryModifiedEvent_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryModifiedEvent_DictionaryFragment:
		return "OpcUa_BinarySchema_HistoryModifiedEvent_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryModifiedEvent:
		return "OpcUa_XmlSchema_HistoryModifiedEvent"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryModifiedEvent_DataTypeVersion:
		return "OpcUa_XmlSchema_HistoryModifiedEvent_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryModifiedEvent_DictionaryFragment:
		return "OpcUa_XmlSchema_HistoryModifiedEvent_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema:
		return "OpcUa_BinarySchema"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DataTypeVersion:
		return "OpcUa_BinarySchema_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_NamespaceUri:
		return "OpcUa_BinarySchema_NamespaceUri"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Argument:
		return "OpcUa_BinarySchema_Argument"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Argument_DataTypeVersion:
		return "OpcUa_BinarySchema_Argument_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Argument_DictionaryFragment:
		return "OpcUa_BinarySchema_Argument_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumValueType:
		return "OpcUa_BinarySchema_EnumValueType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumValueType_DataTypeVersion:
		return "OpcUa_BinarySchema_EnumValueType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EnumValueType_DictionaryFragment:
		return "OpcUa_BinarySchema_EnumValueType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StatusResult:
		return "OpcUa_BinarySchema_StatusResult"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StatusResult_DataTypeVersion:
		return "OpcUa_BinarySchema_StatusResult_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_StatusResult_DictionaryFragment:
		return "OpcUa_BinarySchema_StatusResult_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserTokenPolicy:
		return "OpcUa_BinarySchema_UserTokenPolicy"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserTokenPolicy_DataTypeVersion:
		return "OpcUa_BinarySchema_UserTokenPolicy_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserTokenPolicy_DictionaryFragment:
		return "OpcUa_BinarySchema_UserTokenPolicy_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ApplicationDescription:
		return "OpcUa_BinarySchema_ApplicationDescription"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ApplicationDescription_DataTypeVersion:
		return "OpcUa_BinarySchema_ApplicationDescription_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ApplicationDescription_DictionaryFragment:
		return "OpcUa_BinarySchema_ApplicationDescription_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointDescription:
		return "OpcUa_BinarySchema_EndpointDescription"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointDescription_DataTypeVersion:
		return "OpcUa_BinarySchema_EndpointDescription_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointDescription_DictionaryFragment:
		return "OpcUa_BinarySchema_EndpointDescription_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserIdentityToken:
		return "OpcUa_BinarySchema_UserIdentityToken"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserIdentityToken_DataTypeVersion:
		return "OpcUa_BinarySchema_UserIdentityToken_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserIdentityToken_DictionaryFragment:
		return "OpcUa_BinarySchema_UserIdentityToken_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AnonymousIdentityToken:
		return "OpcUa_BinarySchema_AnonymousIdentityToken"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AnonymousIdentityToken_DataTypeVersion:
		return "OpcUa_BinarySchema_AnonymousIdentityToken_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AnonymousIdentityToken_DictionaryFragment:
		return "OpcUa_BinarySchema_AnonymousIdentityToken_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserNameIdentityToken:
		return "OpcUa_BinarySchema_UserNameIdentityToken"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserNameIdentityToken_DataTypeVersion:
		return "OpcUa_BinarySchema_UserNameIdentityToken_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_UserNameIdentityToken_DictionaryFragment:
		return "OpcUa_BinarySchema_UserNameIdentityToken_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_X509IdentityToken:
		return "OpcUa_BinarySchema_X509IdentityToken"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_X509IdentityToken_DataTypeVersion:
		return "OpcUa_BinarySchema_X509IdentityToken_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_X509IdentityToken_DictionaryFragment:
		return "OpcUa_BinarySchema_X509IdentityToken_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_IssuedIdentityToken:
		return "OpcUa_BinarySchema_IssuedIdentityToken"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_IssuedIdentityToken_DataTypeVersion:
		return "OpcUa_BinarySchema_IssuedIdentityToken_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_IssuedIdentityToken_DictionaryFragment:
		return "OpcUa_BinarySchema_IssuedIdentityToken_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointConfiguration:
		return "OpcUa_BinarySchema_EndpointConfiguration"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointConfiguration_DataTypeVersion:
		return "OpcUa_BinarySchema_EndpointConfiguration_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EndpointConfiguration_DictionaryFragment:
		return "OpcUa_BinarySchema_EndpointConfiguration_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BuildInfo:
		return "OpcUa_BinarySchema_BuildInfo"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BuildInfo_DataTypeVersion:
		return "OpcUa_BinarySchema_BuildInfo_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_BuildInfo_DictionaryFragment:
		return "OpcUa_BinarySchema_BuildInfo_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SignedSoftwareCertificate:
		return "OpcUa_BinarySchema_SignedSoftwareCertificate"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SignedSoftwareCertificate_DataTypeVersion:
		return "OpcUa_BinarySchema_SignedSoftwareCertificate_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SignedSoftwareCertificate_DictionaryFragment:
		return "OpcUa_BinarySchema_SignedSoftwareCertificate_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AddNodesItem:
		return "OpcUa_BinarySchema_AddNodesItem"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AddNodesItem_DataTypeVersion:
		return "OpcUa_BinarySchema_AddNodesItem_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AddNodesItem_DictionaryFragment:
		return "OpcUa_BinarySchema_AddNodesItem_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AddReferencesItem:
		return "OpcUa_BinarySchema_AddReferencesItem"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AddReferencesItem_DataTypeVersion:
		return "OpcUa_BinarySchema_AddReferencesItem_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AddReferencesItem_DictionaryFragment:
		return "OpcUa_BinarySchema_AddReferencesItem_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DeleteNodesItem:
		return "OpcUa_BinarySchema_DeleteNodesItem"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DeleteNodesItem_DataTypeVersion:
		return "OpcUa_BinarySchema_DeleteNodesItem_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DeleteNodesItem_DictionaryFragment:
		return "OpcUa_BinarySchema_DeleteNodesItem_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DeleteReferencesItem:
		return "OpcUa_BinarySchema_DeleteReferencesItem"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DeleteReferencesItem_DataTypeVersion:
		return "OpcUa_BinarySchema_DeleteReferencesItem_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_DeleteReferencesItem_DictionaryFragment:
		return "OpcUa_BinarySchema_DeleteReferencesItem_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RegisteredServer:
		return "OpcUa_BinarySchema_RegisteredServer"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RegisteredServer_DataTypeVersion:
		return "OpcUa_BinarySchema_RegisteredServer_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RegisteredServer_DictionaryFragment:
		return "OpcUa_BinarySchema_RegisteredServer_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ContentFilterElement:
		return "OpcUa_BinarySchema_ContentFilterElement"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ContentFilterElement_DataTypeVersion:
		return "OpcUa_BinarySchema_ContentFilterElement_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ContentFilterElement_DictionaryFragment:
		return "OpcUa_BinarySchema_ContentFilterElement_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ContentFilter:
		return "OpcUa_BinarySchema_ContentFilter"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ContentFilter_DataTypeVersion:
		return "OpcUa_BinarySchema_ContentFilter_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ContentFilter_DictionaryFragment:
		return "OpcUa_BinarySchema_ContentFilter_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FilterOperand:
		return "OpcUa_BinarySchema_FilterOperand"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FilterOperand_DataTypeVersion:
		return "OpcUa_BinarySchema_FilterOperand_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_FilterOperand_DictionaryFragment:
		return "OpcUa_BinarySchema_FilterOperand_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ElementOperand:
		return "OpcUa_BinarySchema_ElementOperand"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ElementOperand_DataTypeVersion:
		return "OpcUa_BinarySchema_ElementOperand_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ElementOperand_DictionaryFragment:
		return "OpcUa_BinarySchema_ElementOperand_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_LiteralOperand:
		return "OpcUa_BinarySchema_LiteralOperand"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_LiteralOperand_DataTypeVersion:
		return "OpcUa_BinarySchema_LiteralOperand_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_LiteralOperand_DictionaryFragment:
		return "OpcUa_BinarySchema_LiteralOperand_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AttributeOperand:
		return "OpcUa_BinarySchema_AttributeOperand"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AttributeOperand_DataTypeVersion:
		return "OpcUa_BinarySchema_AttributeOperand_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AttributeOperand_DictionaryFragment:
		return "OpcUa_BinarySchema_AttributeOperand_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SimpleAttributeOperand:
		return "OpcUa_BinarySchema_SimpleAttributeOperand"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SimpleAttributeOperand_DataTypeVersion:
		return "OpcUa_BinarySchema_SimpleAttributeOperand_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SimpleAttributeOperand_DictionaryFragment:
		return "OpcUa_BinarySchema_SimpleAttributeOperand_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryEvent:
		return "OpcUa_BinarySchema_HistoryEvent"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryEvent_DataTypeVersion:
		return "OpcUa_BinarySchema_HistoryEvent_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryEvent_DictionaryFragment:
		return "OpcUa_BinarySchema_HistoryEvent_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_MonitoringFilter:
		return "OpcUa_BinarySchema_MonitoringFilter"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_MonitoringFilter_DataTypeVersion:
		return "OpcUa_BinarySchema_MonitoringFilter_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_MonitoringFilter_DictionaryFragment:
		return "OpcUa_BinarySchema_MonitoringFilter_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EventFilter:
		return "OpcUa_BinarySchema_EventFilter"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EventFilter_DataTypeVersion:
		return "OpcUa_BinarySchema_EventFilter_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EventFilter_DictionaryFragment:
		return "OpcUa_BinarySchema_EventFilter_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AggregateConfiguration:
		return "OpcUa_BinarySchema_AggregateConfiguration"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AggregateConfiguration_DataTypeVersion:
		return "OpcUa_BinarySchema_AggregateConfiguration_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_AggregateConfiguration_DictionaryFragment:
		return "OpcUa_BinarySchema_AggregateConfiguration_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryEventFieldList:
		return "OpcUa_BinarySchema_HistoryEventFieldList"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryEventFieldList_DataTypeVersion:
		return "OpcUa_BinarySchema_HistoryEventFieldList_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_HistoryEventFieldList_DictionaryFragment:
		return "OpcUa_BinarySchema_HistoryEventFieldList_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RedundantServerDataType:
		return "OpcUa_BinarySchema_RedundantServerDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RedundantServerDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_RedundantServerDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_RedundantServerDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_RedundantServerDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SamplingIntervalDiagnosticsDataType:
		return "OpcUa_BinarySchema_SamplingIntervalDiagnosticsDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SamplingIntervalDiagnosticsDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_SamplingIntervalDiagnosticsDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SamplingIntervalDiagnosticsDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_SamplingIntervalDiagnosticsDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerDiagnosticsSummaryDataType:
		return "OpcUa_BinarySchema_ServerDiagnosticsSummaryDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerDiagnosticsSummaryDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_ServerDiagnosticsSummaryDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerDiagnosticsSummaryDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_ServerDiagnosticsSummaryDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerStatusDataType:
		return "OpcUa_BinarySchema_ServerStatusDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerStatusDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_ServerStatusDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServerStatusDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_ServerStatusDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SessionDiagnosticsDataType:
		return "OpcUa_BinarySchema_SessionDiagnosticsDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SessionDiagnosticsDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_SessionDiagnosticsDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SessionDiagnosticsDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_SessionDiagnosticsDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SessionSecurityDiagnosticsDataType:
		return "OpcUa_BinarySchema_SessionSecurityDiagnosticsDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SessionSecurityDiagnosticsDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_SessionSecurityDiagnosticsDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SessionSecurityDiagnosticsDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_SessionSecurityDiagnosticsDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServiceCounterDataType:
		return "OpcUa_BinarySchema_ServiceCounterDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServiceCounterDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_ServiceCounterDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ServiceCounterDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_ServiceCounterDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscriptionDiagnosticsDataType:
		return "OpcUa_BinarySchema_SubscriptionDiagnosticsDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscriptionDiagnosticsDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_SubscriptionDiagnosticsDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SubscriptionDiagnosticsDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_SubscriptionDiagnosticsDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ModelChangeStructureDataType:
		return "OpcUa_BinarySchema_ModelChangeStructureDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ModelChangeStructureDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_ModelChangeStructureDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ModelChangeStructureDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_ModelChangeStructureDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SemanticChangeStructureDataType:
		return "OpcUa_BinarySchema_SemanticChangeStructureDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SemanticChangeStructureDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_SemanticChangeStructureDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_SemanticChangeStructureDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_SemanticChangeStructureDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Range:
		return "OpcUa_BinarySchema_Range"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Range_DataTypeVersion:
		return "OpcUa_BinarySchema_Range_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Range_DictionaryFragment:
		return "OpcUa_BinarySchema_Range_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EUInformation:
		return "OpcUa_BinarySchema_EUInformation"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EUInformation_DataTypeVersion:
		return "OpcUa_BinarySchema_EUInformation_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_EUInformation_DictionaryFragment:
		return "OpcUa_BinarySchema_EUInformation_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Annotation:
		return "OpcUa_BinarySchema_Annotation"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Annotation_DataTypeVersion:
		return "OpcUa_BinarySchema_Annotation_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_Annotation_DictionaryFragment:
		return "OpcUa_BinarySchema_Annotation_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ProgramDiagnosticDataType:
		return "OpcUa_BinarySchema_ProgramDiagnosticDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ProgramDiagnosticDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_ProgramDiagnosticDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_ProgramDiagnosticDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_ProgramDiagnosticDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema:
		return "OpcUa_XmlSchema"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DataTypeVersion:
		return "OpcUa_XmlSchema_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_NamespaceUri:
		return "OpcUa_XmlSchema_NamespaceUri"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Argument:
		return "OpcUa_XmlSchema_Argument"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Argument_DataTypeVersion:
		return "OpcUa_XmlSchema_Argument_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Argument_DictionaryFragment:
		return "OpcUa_XmlSchema_Argument_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumValueType:
		return "OpcUa_XmlSchema_EnumValueType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumValueType_DataTypeVersion:
		return "OpcUa_XmlSchema_EnumValueType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EnumValueType_DictionaryFragment:
		return "OpcUa_XmlSchema_EnumValueType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StatusResult:
		return "OpcUa_XmlSchema_StatusResult"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StatusResult_DataTypeVersion:
		return "OpcUa_XmlSchema_StatusResult_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_StatusResult_DictionaryFragment:
		return "OpcUa_XmlSchema_StatusResult_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserTokenPolicy:
		return "OpcUa_XmlSchema_UserTokenPolicy"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserTokenPolicy_DataTypeVersion:
		return "OpcUa_XmlSchema_UserTokenPolicy_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserTokenPolicy_DictionaryFragment:
		return "OpcUa_XmlSchema_UserTokenPolicy_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ApplicationDescription:
		return "OpcUa_XmlSchema_ApplicationDescription"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ApplicationDescription_DataTypeVersion:
		return "OpcUa_XmlSchema_ApplicationDescription_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ApplicationDescription_DictionaryFragment:
		return "OpcUa_XmlSchema_ApplicationDescription_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointDescription:
		return "OpcUa_XmlSchema_EndpointDescription"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointDescription_DataTypeVersion:
		return "OpcUa_XmlSchema_EndpointDescription_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointDescription_DictionaryFragment:
		return "OpcUa_XmlSchema_EndpointDescription_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserIdentityToken:
		return "OpcUa_XmlSchema_UserIdentityToken"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserIdentityToken_DataTypeVersion:
		return "OpcUa_XmlSchema_UserIdentityToken_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserIdentityToken_DictionaryFragment:
		return "OpcUa_XmlSchema_UserIdentityToken_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AnonymousIdentityToken:
		return "OpcUa_XmlSchema_AnonymousIdentityToken"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AnonymousIdentityToken_DataTypeVersion:
		return "OpcUa_XmlSchema_AnonymousIdentityToken_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AnonymousIdentityToken_DictionaryFragment:
		return "OpcUa_XmlSchema_AnonymousIdentityToken_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserNameIdentityToken:
		return "OpcUa_XmlSchema_UserNameIdentityToken"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserNameIdentityToken_DataTypeVersion:
		return "OpcUa_XmlSchema_UserNameIdentityToken_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_UserNameIdentityToken_DictionaryFragment:
		return "OpcUa_XmlSchema_UserNameIdentityToken_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_X509IdentityToken:
		return "OpcUa_XmlSchema_X509IdentityToken"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_X509IdentityToken_DataTypeVersion:
		return "OpcUa_XmlSchema_X509IdentityToken_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_X509IdentityToken_DictionaryFragment:
		return "OpcUa_XmlSchema_X509IdentityToken_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_IssuedIdentityToken:
		return "OpcUa_XmlSchema_IssuedIdentityToken"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_IssuedIdentityToken_DataTypeVersion:
		return "OpcUa_XmlSchema_IssuedIdentityToken_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_IssuedIdentityToken_DictionaryFragment:
		return "OpcUa_XmlSchema_IssuedIdentityToken_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointConfiguration:
		return "OpcUa_XmlSchema_EndpointConfiguration"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointConfiguration_DataTypeVersion:
		return "OpcUa_XmlSchema_EndpointConfiguration_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EndpointConfiguration_DictionaryFragment:
		return "OpcUa_XmlSchema_EndpointConfiguration_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BuildInfo:
		return "OpcUa_XmlSchema_BuildInfo"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BuildInfo_DataTypeVersion:
		return "OpcUa_XmlSchema_BuildInfo_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_BuildInfo_DictionaryFragment:
		return "OpcUa_XmlSchema_BuildInfo_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SignedSoftwareCertificate:
		return "OpcUa_XmlSchema_SignedSoftwareCertificate"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SignedSoftwareCertificate_DataTypeVersion:
		return "OpcUa_XmlSchema_SignedSoftwareCertificate_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SignedSoftwareCertificate_DictionaryFragment:
		return "OpcUa_XmlSchema_SignedSoftwareCertificate_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AddNodesItem:
		return "OpcUa_XmlSchema_AddNodesItem"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AddNodesItem_DataTypeVersion:
		return "OpcUa_XmlSchema_AddNodesItem_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AddNodesItem_DictionaryFragment:
		return "OpcUa_XmlSchema_AddNodesItem_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AddReferencesItem:
		return "OpcUa_XmlSchema_AddReferencesItem"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AddReferencesItem_DataTypeVersion:
		return "OpcUa_XmlSchema_AddReferencesItem_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AddReferencesItem_DictionaryFragment:
		return "OpcUa_XmlSchema_AddReferencesItem_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DeleteNodesItem:
		return "OpcUa_XmlSchema_DeleteNodesItem"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DeleteNodesItem_DataTypeVersion:
		return "OpcUa_XmlSchema_DeleteNodesItem_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DeleteNodesItem_DictionaryFragment:
		return "OpcUa_XmlSchema_DeleteNodesItem_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DeleteReferencesItem:
		return "OpcUa_XmlSchema_DeleteReferencesItem"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DeleteReferencesItem_DataTypeVersion:
		return "OpcUa_XmlSchema_DeleteReferencesItem_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_DeleteReferencesItem_DictionaryFragment:
		return "OpcUa_XmlSchema_DeleteReferencesItem_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RegisteredServer:
		return "OpcUa_XmlSchema_RegisteredServer"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RegisteredServer_DataTypeVersion:
		return "OpcUa_XmlSchema_RegisteredServer_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RegisteredServer_DictionaryFragment:
		return "OpcUa_XmlSchema_RegisteredServer_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ContentFilterElement:
		return "OpcUa_XmlSchema_ContentFilterElement"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ContentFilterElement_DataTypeVersion:
		return "OpcUa_XmlSchema_ContentFilterElement_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ContentFilterElement_DictionaryFragment:
		return "OpcUa_XmlSchema_ContentFilterElement_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ContentFilter:
		return "OpcUa_XmlSchema_ContentFilter"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ContentFilter_DataTypeVersion:
		return "OpcUa_XmlSchema_ContentFilter_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ContentFilter_DictionaryFragment:
		return "OpcUa_XmlSchema_ContentFilter_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FilterOperand:
		return "OpcUa_XmlSchema_FilterOperand"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FilterOperand_DataTypeVersion:
		return "OpcUa_XmlSchema_FilterOperand_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_FilterOperand_DictionaryFragment:
		return "OpcUa_XmlSchema_FilterOperand_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ElementOperand:
		return "OpcUa_XmlSchema_ElementOperand"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ElementOperand_DataTypeVersion:
		return "OpcUa_XmlSchema_ElementOperand_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ElementOperand_DictionaryFragment:
		return "OpcUa_XmlSchema_ElementOperand_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_LiteralOperand:
		return "OpcUa_XmlSchema_LiteralOperand"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_LiteralOperand_DataTypeVersion:
		return "OpcUa_XmlSchema_LiteralOperand_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_LiteralOperand_DictionaryFragment:
		return "OpcUa_XmlSchema_LiteralOperand_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AttributeOperand:
		return "OpcUa_XmlSchema_AttributeOperand"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AttributeOperand_DataTypeVersion:
		return "OpcUa_XmlSchema_AttributeOperand_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AttributeOperand_DictionaryFragment:
		return "OpcUa_XmlSchema_AttributeOperand_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SimpleAttributeOperand:
		return "OpcUa_XmlSchema_SimpleAttributeOperand"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SimpleAttributeOperand_DataTypeVersion:
		return "OpcUa_XmlSchema_SimpleAttributeOperand_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SimpleAttributeOperand_DictionaryFragment:
		return "OpcUa_XmlSchema_SimpleAttributeOperand_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryEvent:
		return "OpcUa_XmlSchema_HistoryEvent"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryEvent_DataTypeVersion:
		return "OpcUa_XmlSchema_HistoryEvent_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryEvent_DictionaryFragment:
		return "OpcUa_XmlSchema_HistoryEvent_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_MonitoringFilter:
		return "OpcUa_XmlSchema_MonitoringFilter"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_MonitoringFilter_DataTypeVersion:
		return "OpcUa_XmlSchema_MonitoringFilter_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_MonitoringFilter_DictionaryFragment:
		return "OpcUa_XmlSchema_MonitoringFilter_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EventFilter:
		return "OpcUa_XmlSchema_EventFilter"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EventFilter_DataTypeVersion:
		return "OpcUa_XmlSchema_EventFilter_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EventFilter_DictionaryFragment:
		return "OpcUa_XmlSchema_EventFilter_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AggregateConfiguration:
		return "OpcUa_XmlSchema_AggregateConfiguration"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AggregateConfiguration_DataTypeVersion:
		return "OpcUa_XmlSchema_AggregateConfiguration_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_AggregateConfiguration_DictionaryFragment:
		return "OpcUa_XmlSchema_AggregateConfiguration_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryEventFieldList:
		return "OpcUa_XmlSchema_HistoryEventFieldList"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryEventFieldList_DataTypeVersion:
		return "OpcUa_XmlSchema_HistoryEventFieldList_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_HistoryEventFieldList_DictionaryFragment:
		return "OpcUa_XmlSchema_HistoryEventFieldList_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RedundantServerDataType:
		return "OpcUa_XmlSchema_RedundantServerDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RedundantServerDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_RedundantServerDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_RedundantServerDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_RedundantServerDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SamplingIntervalDiagnosticsDataType:
		return "OpcUa_XmlSchema_SamplingIntervalDiagnosticsDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SamplingIntervalDiagnosticsDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_SamplingIntervalDiagnosticsDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SamplingIntervalDiagnosticsDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_SamplingIntervalDiagnosticsDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerDiagnosticsSummaryDataType:
		return "OpcUa_XmlSchema_ServerDiagnosticsSummaryDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerDiagnosticsSummaryDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_ServerDiagnosticsSummaryDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerDiagnosticsSummaryDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_ServerDiagnosticsSummaryDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerStatusDataType:
		return "OpcUa_XmlSchema_ServerStatusDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerStatusDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_ServerStatusDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServerStatusDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_ServerStatusDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SessionDiagnosticsDataType:
		return "OpcUa_XmlSchema_SessionDiagnosticsDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SessionDiagnosticsDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_SessionDiagnosticsDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SessionDiagnosticsDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_SessionDiagnosticsDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SessionSecurityDiagnosticsDataType:
		return "OpcUa_XmlSchema_SessionSecurityDiagnosticsDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SessionSecurityDiagnosticsDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_SessionSecurityDiagnosticsDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SessionSecurityDiagnosticsDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_SessionSecurityDiagnosticsDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServiceCounterDataType:
		return "OpcUa_XmlSchema_ServiceCounterDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServiceCounterDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_ServiceCounterDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ServiceCounterDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_ServiceCounterDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscriptionDiagnosticsDataType:
		return "OpcUa_XmlSchema_SubscriptionDiagnosticsDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscriptionDiagnosticsDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_SubscriptionDiagnosticsDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SubscriptionDiagnosticsDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_SubscriptionDiagnosticsDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ModelChangeStructureDataType:
		return "OpcUa_XmlSchema_ModelChangeStructureDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ModelChangeStructureDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_ModelChangeStructureDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ModelChangeStructureDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_ModelChangeStructureDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SemanticChangeStructureDataType:
		return "OpcUa_XmlSchema_SemanticChangeStructureDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SemanticChangeStructureDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_SemanticChangeStructureDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_SemanticChangeStructureDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_SemanticChangeStructureDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Range:
		return "OpcUa_XmlSchema_Range"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Range_DataTypeVersion:
		return "OpcUa_XmlSchema_Range_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Range_DictionaryFragment:
		return "OpcUa_XmlSchema_Range_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EUInformation:
		return "OpcUa_XmlSchema_EUInformation"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EUInformation_DataTypeVersion:
		return "OpcUa_XmlSchema_EUInformation_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_EUInformation_DictionaryFragment:
		return "OpcUa_XmlSchema_EUInformation_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Annotation:
		return "OpcUa_XmlSchema_Annotation"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Annotation_DataTypeVersion:
		return "OpcUa_XmlSchema_Annotation_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_Annotation_DictionaryFragment:
		return "OpcUa_XmlSchema_Annotation_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ProgramDiagnosticDataType:
		return "OpcUa_XmlSchema_ProgramDiagnosticDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ProgramDiagnosticDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_ProgramDiagnosticDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_ProgramDiagnosticDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_ProgramDiagnosticDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TimeZoneDataType:
		return "OpcUa_BinarySchema_TimeZoneDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TimeZoneDataType_DataTypeVersion:
		return "OpcUa_BinarySchema_TimeZoneDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_BinarySchema_TimeZoneDataType_DictionaryFragment:
		return "OpcUa_BinarySchema_TimeZoneDataType_DictionaryFragment"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TimeZoneDataType:
		return "OpcUa_XmlSchema_TimeZoneDataType"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TimeZoneDataType_DataTypeVersion:
		return "OpcUa_XmlSchema_TimeZoneDataType_DataTypeVersion"
	case OpcuaNodeIdServicesVariableOpc_OpcUa_XmlSchema_TimeZoneDataType_DictionaryFragment:
		return "OpcUa_XmlSchema_TimeZoneDataType_DictionaryFragment"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableOpc) String() string {
	return e.PLC4XEnumName()
}
