/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableMulti is an enum
type OpcuaNodeIdServicesVariableMulti int32

type IOpcuaNodeIdServicesVariableMulti interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableMulti_MultiStateDiscreteType_EnumStrings                                 OpcuaNodeIdServicesVariableMulti = 2377
	OpcuaNodeIdServicesVariableMulti_MultiStateValueDiscreteType_EnumValues                             OpcuaNodeIdServicesVariableMulti = 11241
	OpcuaNodeIdServicesVariableMulti_MultiStateValueDiscreteType_ValueAsText                            OpcuaNodeIdServicesVariableMulti = 11461
	OpcuaNodeIdServicesVariableMulti_MultiStateDictionaryEntryDiscreteBaseType_EnumDictionaryEntries    OpcuaNodeIdServicesVariableMulti = 19082
	OpcuaNodeIdServicesVariableMulti_MultiStateDictionaryEntryDiscreteBaseType_ValueAsDictionaryEntries OpcuaNodeIdServicesVariableMulti = 19083
	OpcuaNodeIdServicesVariableMulti_MultiStateDictionaryEntryDiscreteType_ValueAsDictionaryEntries     OpcuaNodeIdServicesVariableMulti = 19090
)

var OpcuaNodeIdServicesVariableMultiValues []OpcuaNodeIdServicesVariableMulti

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableMultiValues = []OpcuaNodeIdServicesVariableMulti{
		OpcuaNodeIdServicesVariableMulti_MultiStateDiscreteType_EnumStrings,
		OpcuaNodeIdServicesVariableMulti_MultiStateValueDiscreteType_EnumValues,
		OpcuaNodeIdServicesVariableMulti_MultiStateValueDiscreteType_ValueAsText,
		OpcuaNodeIdServicesVariableMulti_MultiStateDictionaryEntryDiscreteBaseType_EnumDictionaryEntries,
		OpcuaNodeIdServicesVariableMulti_MultiStateDictionaryEntryDiscreteBaseType_ValueAsDictionaryEntries,
		OpcuaNodeIdServicesVariableMulti_MultiStateDictionaryEntryDiscreteType_ValueAsDictionaryEntries,
	}
}

func OpcuaNodeIdServicesVariableMultiByValue(value int32) (enum OpcuaNodeIdServicesVariableMulti, ok bool) {
	switch value {
	case 11241:
		return OpcuaNodeIdServicesVariableMulti_MultiStateValueDiscreteType_EnumValues, true
	case 11461:
		return OpcuaNodeIdServicesVariableMulti_MultiStateValueDiscreteType_ValueAsText, true
	case 19082:
		return OpcuaNodeIdServicesVariableMulti_MultiStateDictionaryEntryDiscreteBaseType_EnumDictionaryEntries, true
	case 19083:
		return OpcuaNodeIdServicesVariableMulti_MultiStateDictionaryEntryDiscreteBaseType_ValueAsDictionaryEntries, true
	case 19090:
		return OpcuaNodeIdServicesVariableMulti_MultiStateDictionaryEntryDiscreteType_ValueAsDictionaryEntries, true
	case 2377:
		return OpcuaNodeIdServicesVariableMulti_MultiStateDiscreteType_EnumStrings, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableMultiByName(value string) (enum OpcuaNodeIdServicesVariableMulti, ok bool) {
	switch value {
	case "MultiStateValueDiscreteType_EnumValues":
		return OpcuaNodeIdServicesVariableMulti_MultiStateValueDiscreteType_EnumValues, true
	case "MultiStateValueDiscreteType_ValueAsText":
		return OpcuaNodeIdServicesVariableMulti_MultiStateValueDiscreteType_ValueAsText, true
	case "MultiStateDictionaryEntryDiscreteBaseType_EnumDictionaryEntries":
		return OpcuaNodeIdServicesVariableMulti_MultiStateDictionaryEntryDiscreteBaseType_EnumDictionaryEntries, true
	case "MultiStateDictionaryEntryDiscreteBaseType_ValueAsDictionaryEntries":
		return OpcuaNodeIdServicesVariableMulti_MultiStateDictionaryEntryDiscreteBaseType_ValueAsDictionaryEntries, true
	case "MultiStateDictionaryEntryDiscreteType_ValueAsDictionaryEntries":
		return OpcuaNodeIdServicesVariableMulti_MultiStateDictionaryEntryDiscreteType_ValueAsDictionaryEntries, true
	case "MultiStateDiscreteType_EnumStrings":
		return OpcuaNodeIdServicesVariableMulti_MultiStateDiscreteType_EnumStrings, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableMultiKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableMultiValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableMulti(structType any) OpcuaNodeIdServicesVariableMulti {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableMulti {
		if sOpcuaNodeIdServicesVariableMulti, ok := typ.(OpcuaNodeIdServicesVariableMulti); ok {
			return sOpcuaNodeIdServicesVariableMulti
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableMulti) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableMulti) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableMultiParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableMulti, error) {
	return OpcuaNodeIdServicesVariableMultiParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableMultiParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableMulti, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableMulti", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableMulti")
	}
	if enum, ok := OpcuaNodeIdServicesVariableMultiByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableMulti")
		return OpcuaNodeIdServicesVariableMulti(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableMulti) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableMulti) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableMulti", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableMulti) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableMulti_MultiStateValueDiscreteType_EnumValues:
		return "MultiStateValueDiscreteType_EnumValues"
	case OpcuaNodeIdServicesVariableMulti_MultiStateValueDiscreteType_ValueAsText:
		return "MultiStateValueDiscreteType_ValueAsText"
	case OpcuaNodeIdServicesVariableMulti_MultiStateDictionaryEntryDiscreteBaseType_EnumDictionaryEntries:
		return "MultiStateDictionaryEntryDiscreteBaseType_EnumDictionaryEntries"
	case OpcuaNodeIdServicesVariableMulti_MultiStateDictionaryEntryDiscreteBaseType_ValueAsDictionaryEntries:
		return "MultiStateDictionaryEntryDiscreteBaseType_ValueAsDictionaryEntries"
	case OpcuaNodeIdServicesVariableMulti_MultiStateDictionaryEntryDiscreteType_ValueAsDictionaryEntries:
		return "MultiStateDictionaryEntryDiscreteType_ValueAsDictionaryEntries"
	case OpcuaNodeIdServicesVariableMulti_MultiStateDiscreteType_EnumStrings:
		return "MultiStateDiscreteType_EnumStrings"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableMulti) String() string {
	return e.PLC4XEnumName()
}
