/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableJson is an enum
type OpcuaNodeIdServicesVariableJson int32

type IOpcuaNodeIdServicesVariableJson interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableJson_JsonNetworkMessageContentMask_OptionSetValues          OpcuaNodeIdServicesVariableJson = 15655
	OpcuaNodeIdServicesVariableJson_JsonDataSetMessageContentMask_OptionSetValues          OpcuaNodeIdServicesVariableJson = 15659
	OpcuaNodeIdServicesVariableJson_JsonWriterGroupMessageType_NetworkMessageContentMask   OpcuaNodeIdServicesVariableJson = 21127
	OpcuaNodeIdServicesVariableJson_JsonDataSetWriterMessageType_DataSetMessageContentMask OpcuaNodeIdServicesVariableJson = 21129
	OpcuaNodeIdServicesVariableJson_JsonDataSetReaderMessageType_NetworkMessageContentMask OpcuaNodeIdServicesVariableJson = 21131
	OpcuaNodeIdServicesVariableJson_JsonDataSetReaderMessageType_DataSetMessageContentMask OpcuaNodeIdServicesVariableJson = 21132
)

var OpcuaNodeIdServicesVariableJsonValues []OpcuaNodeIdServicesVariableJson

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableJsonValues = []OpcuaNodeIdServicesVariableJson{
		OpcuaNodeIdServicesVariableJson_JsonNetworkMessageContentMask_OptionSetValues,
		OpcuaNodeIdServicesVariableJson_JsonDataSetMessageContentMask_OptionSetValues,
		OpcuaNodeIdServicesVariableJson_JsonWriterGroupMessageType_NetworkMessageContentMask,
		OpcuaNodeIdServicesVariableJson_JsonDataSetWriterMessageType_DataSetMessageContentMask,
		OpcuaNodeIdServicesVariableJson_JsonDataSetReaderMessageType_NetworkMessageContentMask,
		OpcuaNodeIdServicesVariableJson_JsonDataSetReaderMessageType_DataSetMessageContentMask,
	}
}

func OpcuaNodeIdServicesVariableJsonByValue(value int32) (enum OpcuaNodeIdServicesVariableJson, ok bool) {
	switch value {
	case 15655:
		return OpcuaNodeIdServicesVariableJson_JsonNetworkMessageContentMask_OptionSetValues, true
	case 15659:
		return OpcuaNodeIdServicesVariableJson_JsonDataSetMessageContentMask_OptionSetValues, true
	case 21127:
		return OpcuaNodeIdServicesVariableJson_JsonWriterGroupMessageType_NetworkMessageContentMask, true
	case 21129:
		return OpcuaNodeIdServicesVariableJson_JsonDataSetWriterMessageType_DataSetMessageContentMask, true
	case 21131:
		return OpcuaNodeIdServicesVariableJson_JsonDataSetReaderMessageType_NetworkMessageContentMask, true
	case 21132:
		return OpcuaNodeIdServicesVariableJson_JsonDataSetReaderMessageType_DataSetMessageContentMask, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableJsonByName(value string) (enum OpcuaNodeIdServicesVariableJson, ok bool) {
	switch value {
	case "JsonNetworkMessageContentMask_OptionSetValues":
		return OpcuaNodeIdServicesVariableJson_JsonNetworkMessageContentMask_OptionSetValues, true
	case "JsonDataSetMessageContentMask_OptionSetValues":
		return OpcuaNodeIdServicesVariableJson_JsonDataSetMessageContentMask_OptionSetValues, true
	case "JsonWriterGroupMessageType_NetworkMessageContentMask":
		return OpcuaNodeIdServicesVariableJson_JsonWriterGroupMessageType_NetworkMessageContentMask, true
	case "JsonDataSetWriterMessageType_DataSetMessageContentMask":
		return OpcuaNodeIdServicesVariableJson_JsonDataSetWriterMessageType_DataSetMessageContentMask, true
	case "JsonDataSetReaderMessageType_NetworkMessageContentMask":
		return OpcuaNodeIdServicesVariableJson_JsonDataSetReaderMessageType_NetworkMessageContentMask, true
	case "JsonDataSetReaderMessageType_DataSetMessageContentMask":
		return OpcuaNodeIdServicesVariableJson_JsonDataSetReaderMessageType_DataSetMessageContentMask, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableJsonKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableJsonValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableJson(structType any) OpcuaNodeIdServicesVariableJson {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableJson {
		if sOpcuaNodeIdServicesVariableJson, ok := typ.(OpcuaNodeIdServicesVariableJson); ok {
			return sOpcuaNodeIdServicesVariableJson
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableJson) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableJson) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableJsonParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableJson, error) {
	return OpcuaNodeIdServicesVariableJsonParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableJsonParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableJson, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableJson", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableJson")
	}
	if enum, ok := OpcuaNodeIdServicesVariableJsonByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableJson")
		return OpcuaNodeIdServicesVariableJson(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableJson) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableJson) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableJson", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableJson) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableJson_JsonNetworkMessageContentMask_OptionSetValues:
		return "JsonNetworkMessageContentMask_OptionSetValues"
	case OpcuaNodeIdServicesVariableJson_JsonDataSetMessageContentMask_OptionSetValues:
		return "JsonDataSetMessageContentMask_OptionSetValues"
	case OpcuaNodeIdServicesVariableJson_JsonWriterGroupMessageType_NetworkMessageContentMask:
		return "JsonWriterGroupMessageType_NetworkMessageContentMask"
	case OpcuaNodeIdServicesVariableJson_JsonDataSetWriterMessageType_DataSetMessageContentMask:
		return "JsonDataSetWriterMessageType_DataSetMessageContentMask"
	case OpcuaNodeIdServicesVariableJson_JsonDataSetReaderMessageType_NetworkMessageContentMask:
		return "JsonDataSetReaderMessageType_NetworkMessageContentMask"
	case OpcuaNodeIdServicesVariableJson_JsonDataSetReaderMessageType_DataSetMessageContentMask:
		return "JsonDataSetReaderMessageType_DataSetMessageContentMask"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableJson) String() string {
	return e.PLC4XEnumName()
}
