/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableInstrument is an enum
type OpcuaNodeIdServicesVariableInstrument int32

type IOpcuaNodeIdServicesVariableInstrument interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EventId                                              OpcuaNodeIdServicesVariableInstrument = 18348
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EventType                                            OpcuaNodeIdServicesVariableInstrument = 18349
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SourceNode                                           OpcuaNodeIdServicesVariableInstrument = 18350
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SourceName                                           OpcuaNodeIdServicesVariableInstrument = 18351
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Time                                                 OpcuaNodeIdServicesVariableInstrument = 18352
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ReceiveTime                                          OpcuaNodeIdServicesVariableInstrument = 18353
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LocalTime                                            OpcuaNodeIdServicesVariableInstrument = 18354
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Message                                              OpcuaNodeIdServicesVariableInstrument = 18355
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Severity                                             OpcuaNodeIdServicesVariableInstrument = 18356
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConditionClassId                                     OpcuaNodeIdServicesVariableInstrument = 18357
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConditionClassName                                   OpcuaNodeIdServicesVariableInstrument = 18358
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConditionSubClassId                                  OpcuaNodeIdServicesVariableInstrument = 18359
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConditionSubClassName                                OpcuaNodeIdServicesVariableInstrument = 18360
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConditionName                                        OpcuaNodeIdServicesVariableInstrument = 18361
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_BranchId                                             OpcuaNodeIdServicesVariableInstrument = 18362
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Retain                                               OpcuaNodeIdServicesVariableInstrument = 18363
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState                                         OpcuaNodeIdServicesVariableInstrument = 18364
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_Id                                      OpcuaNodeIdServicesVariableInstrument = 18365
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_Name                                    OpcuaNodeIdServicesVariableInstrument = 18366
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_Number                                  OpcuaNodeIdServicesVariableInstrument = 18367
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableInstrument = 18368
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_TransitionTime                          OpcuaNodeIdServicesVariableInstrument = 18369
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableInstrument = 18370
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_TrueState                               OpcuaNodeIdServicesVariableInstrument = 18371
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_FalseState                              OpcuaNodeIdServicesVariableInstrument = 18372
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Quality                                              OpcuaNodeIdServicesVariableInstrument = 18373
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Quality_SourceTimestamp                              OpcuaNodeIdServicesVariableInstrument = 18374
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LastSeverity                                         OpcuaNodeIdServicesVariableInstrument = 18375
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LastSeverity_SourceTimestamp                         OpcuaNodeIdServicesVariableInstrument = 18376
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Comment                                              OpcuaNodeIdServicesVariableInstrument = 18377
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Comment_SourceTimestamp                              OpcuaNodeIdServicesVariableInstrument = 18378
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ClientUserId                                         OpcuaNodeIdServicesVariableInstrument = 18379
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AddComment_InputArguments                            OpcuaNodeIdServicesVariableInstrument = 18383
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConditionRefresh_InputArguments                      OpcuaNodeIdServicesVariableInstrument = 18385
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConditionRefresh2_InputArguments                     OpcuaNodeIdServicesVariableInstrument = 18387
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState                                           OpcuaNodeIdServicesVariableInstrument = 18388
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_Id                                        OpcuaNodeIdServicesVariableInstrument = 18389
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_Name                                      OpcuaNodeIdServicesVariableInstrument = 18390
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_Number                                    OpcuaNodeIdServicesVariableInstrument = 18391
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableInstrument = 18392
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_TransitionTime                            OpcuaNodeIdServicesVariableInstrument = 18393
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableInstrument = 18394
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_TrueState                                 OpcuaNodeIdServicesVariableInstrument = 18395
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_FalseState                                OpcuaNodeIdServicesVariableInstrument = 18396
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState                                       OpcuaNodeIdServicesVariableInstrument = 18397
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_Id                                    OpcuaNodeIdServicesVariableInstrument = 18398
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_Name                                  OpcuaNodeIdServicesVariableInstrument = 18399
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_Number                                OpcuaNodeIdServicesVariableInstrument = 18400
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_EffectiveDisplayName                  OpcuaNodeIdServicesVariableInstrument = 18401
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_TransitionTime                        OpcuaNodeIdServicesVariableInstrument = 18402
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_EffectiveTransitionTime               OpcuaNodeIdServicesVariableInstrument = 18403
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_TrueState                             OpcuaNodeIdServicesVariableInstrument = 18404
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_FalseState                            OpcuaNodeIdServicesVariableInstrument = 18405
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Acknowledge_InputArguments                           OpcuaNodeIdServicesVariableInstrument = 18407
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Confirm_InputArguments                               OpcuaNodeIdServicesVariableInstrument = 18409
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState                                          OpcuaNodeIdServicesVariableInstrument = 18410
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_Id                                       OpcuaNodeIdServicesVariableInstrument = 18411
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_Name                                     OpcuaNodeIdServicesVariableInstrument = 18412
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_Number                                   OpcuaNodeIdServicesVariableInstrument = 18413
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_EffectiveDisplayName                     OpcuaNodeIdServicesVariableInstrument = 18414
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_TransitionTime                           OpcuaNodeIdServicesVariableInstrument = 18415
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_EffectiveTransitionTime                  OpcuaNodeIdServicesVariableInstrument = 18416
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_TrueState                                OpcuaNodeIdServicesVariableInstrument = 18417
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_FalseState                               OpcuaNodeIdServicesVariableInstrument = 18418
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_InputNode                                            OpcuaNodeIdServicesVariableInstrument = 18419
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState                                      OpcuaNodeIdServicesVariableInstrument = 18420
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_Id                                   OpcuaNodeIdServicesVariableInstrument = 18421
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_Name                                 OpcuaNodeIdServicesVariableInstrument = 18422
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_Number                               OpcuaNodeIdServicesVariableInstrument = 18423
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_EffectiveDisplayName                 OpcuaNodeIdServicesVariableInstrument = 18424
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_TransitionTime                       OpcuaNodeIdServicesVariableInstrument = 18425
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_EffectiveTransitionTime              OpcuaNodeIdServicesVariableInstrument = 18426
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_TrueState                            OpcuaNodeIdServicesVariableInstrument = 18427
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_FalseState                           OpcuaNodeIdServicesVariableInstrument = 18428
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState                                    OpcuaNodeIdServicesVariableInstrument = 18429
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_Id                                 OpcuaNodeIdServicesVariableInstrument = 18430
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_Name                               OpcuaNodeIdServicesVariableInstrument = 18431
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_Number                             OpcuaNodeIdServicesVariableInstrument = 18432
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_EffectiveDisplayName               OpcuaNodeIdServicesVariableInstrument = 18433
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_TransitionTime                     OpcuaNodeIdServicesVariableInstrument = 18434
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_EffectiveTransitionTime            OpcuaNodeIdServicesVariableInstrument = 18435
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_TrueState                          OpcuaNodeIdServicesVariableInstrument = 18436
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_FalseState                         OpcuaNodeIdServicesVariableInstrument = 18437
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_CurrentState                           OpcuaNodeIdServicesVariableInstrument = 18439
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_Id                        OpcuaNodeIdServicesVariableInstrument = 18440
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_Name                      OpcuaNodeIdServicesVariableInstrument = 18441
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_Number                    OpcuaNodeIdServicesVariableInstrument = 18442
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_EffectiveDisplayName      OpcuaNodeIdServicesVariableInstrument = 18443
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_LastTransition                         OpcuaNodeIdServicesVariableInstrument = 18444
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_Id                      OpcuaNodeIdServicesVariableInstrument = 18445
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_Name                    OpcuaNodeIdServicesVariableInstrument = 18446
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_Number                  OpcuaNodeIdServicesVariableInstrument = 18447
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_TransitionTime          OpcuaNodeIdServicesVariableInstrument = 18448
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime OpcuaNodeIdServicesVariableInstrument = 18449
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_AvailableStates                        OpcuaNodeIdServicesVariableInstrument = 18450
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_AvailableTransitions                   OpcuaNodeIdServicesVariableInstrument = 18451
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_UnshelveTime                           OpcuaNodeIdServicesVariableInstrument = 18452
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_TimedShelve_InputArguments             OpcuaNodeIdServicesVariableInstrument = 18454
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedOrShelved                                  OpcuaNodeIdServicesVariableInstrument = 18457
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_MaxTimeShelved                                       OpcuaNodeIdServicesVariableInstrument = 18458
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AudibleEnabled                                       OpcuaNodeIdServicesVariableInstrument = 18459
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AudibleSound                                         OpcuaNodeIdServicesVariableInstrument = 18460
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AudibleSound_ListId                                  OpcuaNodeIdServicesVariableInstrument = 18461
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AudibleSound_AgencyId                                OpcuaNodeIdServicesVariableInstrument = 18462
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AudibleSound_VersionId                               OpcuaNodeIdServicesVariableInstrument = 18463
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState                                         OpcuaNodeIdServicesVariableInstrument = 18464
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_Id                                      OpcuaNodeIdServicesVariableInstrument = 18465
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_Name                                    OpcuaNodeIdServicesVariableInstrument = 18466
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_Number                                  OpcuaNodeIdServicesVariableInstrument = 18467
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableInstrument = 18468
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_TransitionTime                          OpcuaNodeIdServicesVariableInstrument = 18469
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableInstrument = 18470
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_TrueState                               OpcuaNodeIdServicesVariableInstrument = 18471
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_FalseState                              OpcuaNodeIdServicesVariableInstrument = 18472
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OnDelay                                              OpcuaNodeIdServicesVariableInstrument = 18473
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OffDelay                                             OpcuaNodeIdServicesVariableInstrument = 18474
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_FirstInGroupFlag                                     OpcuaNodeIdServicesVariableInstrument = 18475
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState                                         OpcuaNodeIdServicesVariableInstrument = 18477
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_Id                                      OpcuaNodeIdServicesVariableInstrument = 18478
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_Name                                    OpcuaNodeIdServicesVariableInstrument = 18479
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_Number                                  OpcuaNodeIdServicesVariableInstrument = 18480
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableInstrument = 18481
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_TransitionTime                          OpcuaNodeIdServicesVariableInstrument = 18482
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableInstrument = 18483
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_TrueState                               OpcuaNodeIdServicesVariableInstrument = 18484
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_FalseState                              OpcuaNodeIdServicesVariableInstrument = 18485
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ReAlarmTime                                          OpcuaNodeIdServicesVariableInstrument = 18487
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ReAlarmRepeatCount                                   OpcuaNodeIdServicesVariableInstrument = 18488
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_NormalState                                          OpcuaNodeIdServicesVariableInstrument = 18495
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Suppress2_InputArguments                             OpcuaNodeIdServicesVariableInstrument = 24469
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Unsuppress2_InputArguments                           OpcuaNodeIdServicesVariableInstrument = 24471
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_RemoveFromService2_InputArguments                    OpcuaNodeIdServicesVariableInstrument = 24473
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_PlaceInService2_InputArguments                       OpcuaNodeIdServicesVariableInstrument = 24475
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Reset2_InputArguments                                OpcuaNodeIdServicesVariableInstrument = 24477
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_TimedShelve2_InputArguments            OpcuaNodeIdServicesVariableInstrument = 24939
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_Unshelve2_InputArguments               OpcuaNodeIdServicesVariableInstrument = 24941
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_OneShotShelve2_InputArguments          OpcuaNodeIdServicesVariableInstrument = 24943
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_GetGroupMemberships_OutputArguments                  OpcuaNodeIdServicesVariableInstrument = 25172
	OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SupportsFilteredRetain                               OpcuaNodeIdServicesVariableInstrument = 32240
)

var OpcuaNodeIdServicesVariableInstrumentValues []OpcuaNodeIdServicesVariableInstrument

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableInstrumentValues = []OpcuaNodeIdServicesVariableInstrument{
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EventId,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EventType,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SourceNode,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SourceName,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Time,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ReceiveTime,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LocalTime,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Message,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Severity,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConditionClassId,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConditionClassName,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConditionName,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_BranchId,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Retain,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_Id,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_Name,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_Number,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Quality,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LastSeverity,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Comment,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ClientUserId,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConditionRefresh_InputArguments,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConditionRefresh2_InputArguments,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_Id,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_Name,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_Number,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_TrueState,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_FalseState,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_Id,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_Name,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_Number,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_InputNode,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_Id,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_Name,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_Number,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_MaxTimeShelved,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AudibleEnabled,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AudibleSound,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_Id,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_Name,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_Number,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OnDelay,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OffDelay,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_Id,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_Name,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_Number,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ReAlarmTime,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_NormalState,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SupportsFilteredRetain,
	}
}

func OpcuaNodeIdServicesVariableInstrumentByValue(value int32) (enum OpcuaNodeIdServicesVariableInstrument, ok bool) {
	switch value {
	case 18348:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EventId, true
	case 18349:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EventType, true
	case 18350:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SourceNode, true
	case 18351:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SourceName, true
	case 18352:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Time, true
	case 18353:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ReceiveTime, true
	case 18354:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LocalTime, true
	case 18355:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Message, true
	case 18356:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Severity, true
	case 18357:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConditionClassId, true
	case 18358:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConditionClassName, true
	case 18359:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConditionSubClassId, true
	case 18360:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConditionSubClassName, true
	case 18361:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConditionName, true
	case 18362:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_BranchId, true
	case 18363:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Retain, true
	case 18364:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState, true
	case 18365:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_Id, true
	case 18366:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_Name, true
	case 18367:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_Number, true
	case 18368:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_EffectiveDisplayName, true
	case 18369:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_TransitionTime, true
	case 18370:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_EffectiveTransitionTime, true
	case 18371:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_TrueState, true
	case 18372:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_FalseState, true
	case 18373:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Quality, true
	case 18374:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Quality_SourceTimestamp, true
	case 18375:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LastSeverity, true
	case 18376:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LastSeverity_SourceTimestamp, true
	case 18377:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Comment, true
	case 18378:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Comment_SourceTimestamp, true
	case 18379:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ClientUserId, true
	case 18383:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AddComment_InputArguments, true
	case 18385:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConditionRefresh_InputArguments, true
	case 18387:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConditionRefresh2_InputArguments, true
	case 18388:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState, true
	case 18389:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_Id, true
	case 18390:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_Name, true
	case 18391:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_Number, true
	case 18392:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_EffectiveDisplayName, true
	case 18393:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_TransitionTime, true
	case 18394:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_EffectiveTransitionTime, true
	case 18395:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_TrueState, true
	case 18396:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_FalseState, true
	case 18397:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState, true
	case 18398:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_Id, true
	case 18399:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_Name, true
	case 18400:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_Number, true
	case 18401:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_EffectiveDisplayName, true
	case 18402:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_TransitionTime, true
	case 18403:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_EffectiveTransitionTime, true
	case 18404:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_TrueState, true
	case 18405:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_FalseState, true
	case 18407:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Acknowledge_InputArguments, true
	case 18409:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Confirm_InputArguments, true
	case 18410:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState, true
	case 18411:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_Id, true
	case 18412:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_Name, true
	case 18413:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_Number, true
	case 18414:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_EffectiveDisplayName, true
	case 18415:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_TransitionTime, true
	case 18416:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_EffectiveTransitionTime, true
	case 18417:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_TrueState, true
	case 18418:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_FalseState, true
	case 18419:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_InputNode, true
	case 18420:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState, true
	case 18421:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_Id, true
	case 18422:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_Name, true
	case 18423:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_Number, true
	case 18424:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_EffectiveDisplayName, true
	case 18425:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_TransitionTime, true
	case 18426:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_EffectiveTransitionTime, true
	case 18427:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_TrueState, true
	case 18428:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_FalseState, true
	case 18429:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState, true
	case 18430:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_Id, true
	case 18431:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_Name, true
	case 18432:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_Number, true
	case 18433:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_EffectiveDisplayName, true
	case 18434:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_TransitionTime, true
	case 18435:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_EffectiveTransitionTime, true
	case 18436:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_TrueState, true
	case 18437:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_FalseState, true
	case 18439:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_CurrentState, true
	case 18440:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_Id, true
	case 18441:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_Name, true
	case 18442:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_Number, true
	case 18443:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 18444:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_LastTransition, true
	case 18445:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_Id, true
	case 18446:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_Name, true
	case 18447:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_Number, true
	case 18448:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_TransitionTime, true
	case 18449:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 18450:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_AvailableStates, true
	case 18451:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_AvailableTransitions, true
	case 18452:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_UnshelveTime, true
	case 18454:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_TimedShelve_InputArguments, true
	case 18457:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedOrShelved, true
	case 18458:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_MaxTimeShelved, true
	case 18459:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AudibleEnabled, true
	case 18460:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AudibleSound, true
	case 18461:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AudibleSound_ListId, true
	case 18462:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AudibleSound_AgencyId, true
	case 18463:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AudibleSound_VersionId, true
	case 18464:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState, true
	case 18465:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_Id, true
	case 18466:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_Name, true
	case 18467:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_Number, true
	case 18468:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_EffectiveDisplayName, true
	case 18469:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_TransitionTime, true
	case 18470:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_EffectiveTransitionTime, true
	case 18471:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_TrueState, true
	case 18472:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_FalseState, true
	case 18473:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OnDelay, true
	case 18474:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OffDelay, true
	case 18475:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_FirstInGroupFlag, true
	case 18477:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState, true
	case 18478:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_Id, true
	case 18479:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_Name, true
	case 18480:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_Number, true
	case 18481:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_EffectiveDisplayName, true
	case 18482:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_TransitionTime, true
	case 18483:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_EffectiveTransitionTime, true
	case 18484:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_TrueState, true
	case 18485:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_FalseState, true
	case 18487:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ReAlarmTime, true
	case 18488:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ReAlarmRepeatCount, true
	case 18495:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_NormalState, true
	case 24469:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Suppress2_InputArguments, true
	case 24471:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Unsuppress2_InputArguments, true
	case 24473:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_RemoveFromService2_InputArguments, true
	case 24475:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_PlaceInService2_InputArguments, true
	case 24477:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Reset2_InputArguments, true
	case 24939:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_TimedShelve2_InputArguments, true
	case 24941:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_Unshelve2_InputArguments, true
	case 24943:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_OneShotShelve2_InputArguments, true
	case 25172:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_GetGroupMemberships_OutputArguments, true
	case 32240:
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SupportsFilteredRetain, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableInstrumentByName(value string) (enum OpcuaNodeIdServicesVariableInstrument, ok bool) {
	switch value {
	case "InstrumentDiagnosticAlarmType_EventId":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EventId, true
	case "InstrumentDiagnosticAlarmType_EventType":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EventType, true
	case "InstrumentDiagnosticAlarmType_SourceNode":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SourceNode, true
	case "InstrumentDiagnosticAlarmType_SourceName":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SourceName, true
	case "InstrumentDiagnosticAlarmType_Time":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Time, true
	case "InstrumentDiagnosticAlarmType_ReceiveTime":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ReceiveTime, true
	case "InstrumentDiagnosticAlarmType_LocalTime":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LocalTime, true
	case "InstrumentDiagnosticAlarmType_Message":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Message, true
	case "InstrumentDiagnosticAlarmType_Severity":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Severity, true
	case "InstrumentDiagnosticAlarmType_ConditionClassId":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConditionClassId, true
	case "InstrumentDiagnosticAlarmType_ConditionClassName":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConditionClassName, true
	case "InstrumentDiagnosticAlarmType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConditionSubClassId, true
	case "InstrumentDiagnosticAlarmType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConditionSubClassName, true
	case "InstrumentDiagnosticAlarmType_ConditionName":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConditionName, true
	case "InstrumentDiagnosticAlarmType_BranchId":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_BranchId, true
	case "InstrumentDiagnosticAlarmType_Retain":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Retain, true
	case "InstrumentDiagnosticAlarmType_EnabledState":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState, true
	case "InstrumentDiagnosticAlarmType_EnabledState_Id":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_Id, true
	case "InstrumentDiagnosticAlarmType_EnabledState_Name":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_Name, true
	case "InstrumentDiagnosticAlarmType_EnabledState_Number":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_Number, true
	case "InstrumentDiagnosticAlarmType_EnabledState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_EffectiveDisplayName, true
	case "InstrumentDiagnosticAlarmType_EnabledState_TransitionTime":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_TransitionTime, true
	case "InstrumentDiagnosticAlarmType_EnabledState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_EffectiveTransitionTime, true
	case "InstrumentDiagnosticAlarmType_EnabledState_TrueState":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_TrueState, true
	case "InstrumentDiagnosticAlarmType_EnabledState_FalseState":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_FalseState, true
	case "InstrumentDiagnosticAlarmType_Quality":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Quality, true
	case "InstrumentDiagnosticAlarmType_Quality_SourceTimestamp":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Quality_SourceTimestamp, true
	case "InstrumentDiagnosticAlarmType_LastSeverity":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LastSeverity, true
	case "InstrumentDiagnosticAlarmType_LastSeverity_SourceTimestamp":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LastSeverity_SourceTimestamp, true
	case "InstrumentDiagnosticAlarmType_Comment":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Comment, true
	case "InstrumentDiagnosticAlarmType_Comment_SourceTimestamp":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Comment_SourceTimestamp, true
	case "InstrumentDiagnosticAlarmType_ClientUserId":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ClientUserId, true
	case "InstrumentDiagnosticAlarmType_AddComment_InputArguments":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AddComment_InputArguments, true
	case "InstrumentDiagnosticAlarmType_ConditionRefresh_InputArguments":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConditionRefresh_InputArguments, true
	case "InstrumentDiagnosticAlarmType_ConditionRefresh2_InputArguments":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConditionRefresh2_InputArguments, true
	case "InstrumentDiagnosticAlarmType_AckedState":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState, true
	case "InstrumentDiagnosticAlarmType_AckedState_Id":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_Id, true
	case "InstrumentDiagnosticAlarmType_AckedState_Name":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_Name, true
	case "InstrumentDiagnosticAlarmType_AckedState_Number":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_Number, true
	case "InstrumentDiagnosticAlarmType_AckedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_EffectiveDisplayName, true
	case "InstrumentDiagnosticAlarmType_AckedState_TransitionTime":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_TransitionTime, true
	case "InstrumentDiagnosticAlarmType_AckedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_EffectiveTransitionTime, true
	case "InstrumentDiagnosticAlarmType_AckedState_TrueState":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_TrueState, true
	case "InstrumentDiagnosticAlarmType_AckedState_FalseState":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_FalseState, true
	case "InstrumentDiagnosticAlarmType_ConfirmedState":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState, true
	case "InstrumentDiagnosticAlarmType_ConfirmedState_Id":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_Id, true
	case "InstrumentDiagnosticAlarmType_ConfirmedState_Name":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_Name, true
	case "InstrumentDiagnosticAlarmType_ConfirmedState_Number":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_Number, true
	case "InstrumentDiagnosticAlarmType_ConfirmedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_EffectiveDisplayName, true
	case "InstrumentDiagnosticAlarmType_ConfirmedState_TransitionTime":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_TransitionTime, true
	case "InstrumentDiagnosticAlarmType_ConfirmedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_EffectiveTransitionTime, true
	case "InstrumentDiagnosticAlarmType_ConfirmedState_TrueState":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_TrueState, true
	case "InstrumentDiagnosticAlarmType_ConfirmedState_FalseState":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_FalseState, true
	case "InstrumentDiagnosticAlarmType_Acknowledge_InputArguments":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Acknowledge_InputArguments, true
	case "InstrumentDiagnosticAlarmType_Confirm_InputArguments":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Confirm_InputArguments, true
	case "InstrumentDiagnosticAlarmType_ActiveState":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState, true
	case "InstrumentDiagnosticAlarmType_ActiveState_Id":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_Id, true
	case "InstrumentDiagnosticAlarmType_ActiveState_Name":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_Name, true
	case "InstrumentDiagnosticAlarmType_ActiveState_Number":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_Number, true
	case "InstrumentDiagnosticAlarmType_ActiveState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_EffectiveDisplayName, true
	case "InstrumentDiagnosticAlarmType_ActiveState_TransitionTime":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_TransitionTime, true
	case "InstrumentDiagnosticAlarmType_ActiveState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_EffectiveTransitionTime, true
	case "InstrumentDiagnosticAlarmType_ActiveState_TrueState":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_TrueState, true
	case "InstrumentDiagnosticAlarmType_ActiveState_FalseState":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_FalseState, true
	case "InstrumentDiagnosticAlarmType_InputNode":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_InputNode, true
	case "InstrumentDiagnosticAlarmType_SuppressedState":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState, true
	case "InstrumentDiagnosticAlarmType_SuppressedState_Id":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_Id, true
	case "InstrumentDiagnosticAlarmType_SuppressedState_Name":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_Name, true
	case "InstrumentDiagnosticAlarmType_SuppressedState_Number":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_Number, true
	case "InstrumentDiagnosticAlarmType_SuppressedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_EffectiveDisplayName, true
	case "InstrumentDiagnosticAlarmType_SuppressedState_TransitionTime":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_TransitionTime, true
	case "InstrumentDiagnosticAlarmType_SuppressedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_EffectiveTransitionTime, true
	case "InstrumentDiagnosticAlarmType_SuppressedState_TrueState":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_TrueState, true
	case "InstrumentDiagnosticAlarmType_SuppressedState_FalseState":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_FalseState, true
	case "InstrumentDiagnosticAlarmType_OutOfServiceState":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState, true
	case "InstrumentDiagnosticAlarmType_OutOfServiceState_Id":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_Id, true
	case "InstrumentDiagnosticAlarmType_OutOfServiceState_Name":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_Name, true
	case "InstrumentDiagnosticAlarmType_OutOfServiceState_Number":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_Number, true
	case "InstrumentDiagnosticAlarmType_OutOfServiceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_EffectiveDisplayName, true
	case "InstrumentDiagnosticAlarmType_OutOfServiceState_TransitionTime":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_TransitionTime, true
	case "InstrumentDiagnosticAlarmType_OutOfServiceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_EffectiveTransitionTime, true
	case "InstrumentDiagnosticAlarmType_OutOfServiceState_TrueState":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_TrueState, true
	case "InstrumentDiagnosticAlarmType_OutOfServiceState_FalseState":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_FalseState, true
	case "InstrumentDiagnosticAlarmType_ShelvingState_CurrentState":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_CurrentState, true
	case "InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_Id":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_Id, true
	case "InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_Name":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_Name, true
	case "InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_Number":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_Number, true
	case "InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_EffectiveDisplayName, true
	case "InstrumentDiagnosticAlarmType_ShelvingState_LastTransition":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_LastTransition, true
	case "InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_Id":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_Id, true
	case "InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_Name":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_Name, true
	case "InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_Number":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_Number, true
	case "InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_TransitionTime, true
	case "InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case "InstrumentDiagnosticAlarmType_ShelvingState_AvailableStates":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_AvailableStates, true
	case "InstrumentDiagnosticAlarmType_ShelvingState_AvailableTransitions":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_AvailableTransitions, true
	case "InstrumentDiagnosticAlarmType_ShelvingState_UnshelveTime":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_UnshelveTime, true
	case "InstrumentDiagnosticAlarmType_ShelvingState_TimedShelve_InputArguments":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_TimedShelve_InputArguments, true
	case "InstrumentDiagnosticAlarmType_SuppressedOrShelved":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedOrShelved, true
	case "InstrumentDiagnosticAlarmType_MaxTimeShelved":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_MaxTimeShelved, true
	case "InstrumentDiagnosticAlarmType_AudibleEnabled":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AudibleEnabled, true
	case "InstrumentDiagnosticAlarmType_AudibleSound":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AudibleSound, true
	case "InstrumentDiagnosticAlarmType_AudibleSound_ListId":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AudibleSound_ListId, true
	case "InstrumentDiagnosticAlarmType_AudibleSound_AgencyId":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AudibleSound_AgencyId, true
	case "InstrumentDiagnosticAlarmType_AudibleSound_VersionId":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AudibleSound_VersionId, true
	case "InstrumentDiagnosticAlarmType_SilenceState":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState, true
	case "InstrumentDiagnosticAlarmType_SilenceState_Id":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_Id, true
	case "InstrumentDiagnosticAlarmType_SilenceState_Name":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_Name, true
	case "InstrumentDiagnosticAlarmType_SilenceState_Number":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_Number, true
	case "InstrumentDiagnosticAlarmType_SilenceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_EffectiveDisplayName, true
	case "InstrumentDiagnosticAlarmType_SilenceState_TransitionTime":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_TransitionTime, true
	case "InstrumentDiagnosticAlarmType_SilenceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_EffectiveTransitionTime, true
	case "InstrumentDiagnosticAlarmType_SilenceState_TrueState":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_TrueState, true
	case "InstrumentDiagnosticAlarmType_SilenceState_FalseState":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_FalseState, true
	case "InstrumentDiagnosticAlarmType_OnDelay":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OnDelay, true
	case "InstrumentDiagnosticAlarmType_OffDelay":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OffDelay, true
	case "InstrumentDiagnosticAlarmType_FirstInGroupFlag":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_FirstInGroupFlag, true
	case "InstrumentDiagnosticAlarmType_LatchedState":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState, true
	case "InstrumentDiagnosticAlarmType_LatchedState_Id":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_Id, true
	case "InstrumentDiagnosticAlarmType_LatchedState_Name":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_Name, true
	case "InstrumentDiagnosticAlarmType_LatchedState_Number":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_Number, true
	case "InstrumentDiagnosticAlarmType_LatchedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_EffectiveDisplayName, true
	case "InstrumentDiagnosticAlarmType_LatchedState_TransitionTime":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_TransitionTime, true
	case "InstrumentDiagnosticAlarmType_LatchedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_EffectiveTransitionTime, true
	case "InstrumentDiagnosticAlarmType_LatchedState_TrueState":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_TrueState, true
	case "InstrumentDiagnosticAlarmType_LatchedState_FalseState":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_FalseState, true
	case "InstrumentDiagnosticAlarmType_ReAlarmTime":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ReAlarmTime, true
	case "InstrumentDiagnosticAlarmType_ReAlarmRepeatCount":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ReAlarmRepeatCount, true
	case "InstrumentDiagnosticAlarmType_NormalState":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_NormalState, true
	case "InstrumentDiagnosticAlarmType_Suppress2_InputArguments":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Suppress2_InputArguments, true
	case "InstrumentDiagnosticAlarmType_Unsuppress2_InputArguments":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Unsuppress2_InputArguments, true
	case "InstrumentDiagnosticAlarmType_RemoveFromService2_InputArguments":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_RemoveFromService2_InputArguments, true
	case "InstrumentDiagnosticAlarmType_PlaceInService2_InputArguments":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_PlaceInService2_InputArguments, true
	case "InstrumentDiagnosticAlarmType_Reset2_InputArguments":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Reset2_InputArguments, true
	case "InstrumentDiagnosticAlarmType_ShelvingState_TimedShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_TimedShelve2_InputArguments, true
	case "InstrumentDiagnosticAlarmType_ShelvingState_Unshelve2_InputArguments":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_Unshelve2_InputArguments, true
	case "InstrumentDiagnosticAlarmType_ShelvingState_OneShotShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_OneShotShelve2_InputArguments, true
	case "InstrumentDiagnosticAlarmType_GetGroupMemberships_OutputArguments":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_GetGroupMemberships_OutputArguments, true
	case "InstrumentDiagnosticAlarmType_SupportsFilteredRetain":
		return OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SupportsFilteredRetain, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableInstrumentKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableInstrumentValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableInstrument(structType any) OpcuaNodeIdServicesVariableInstrument {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableInstrument {
		if sOpcuaNodeIdServicesVariableInstrument, ok := typ.(OpcuaNodeIdServicesVariableInstrument); ok {
			return sOpcuaNodeIdServicesVariableInstrument
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableInstrument) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableInstrument) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableInstrumentParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableInstrument, error) {
	return OpcuaNodeIdServicesVariableInstrumentParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableInstrumentParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableInstrument, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableInstrument", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableInstrument")
	}
	if enum, ok := OpcuaNodeIdServicesVariableInstrumentByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableInstrument")
		return OpcuaNodeIdServicesVariableInstrument(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableInstrument) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableInstrument) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableInstrument", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableInstrument) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EventId:
		return "InstrumentDiagnosticAlarmType_EventId"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EventType:
		return "InstrumentDiagnosticAlarmType_EventType"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SourceNode:
		return "InstrumentDiagnosticAlarmType_SourceNode"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SourceName:
		return "InstrumentDiagnosticAlarmType_SourceName"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Time:
		return "InstrumentDiagnosticAlarmType_Time"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ReceiveTime:
		return "InstrumentDiagnosticAlarmType_ReceiveTime"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LocalTime:
		return "InstrumentDiagnosticAlarmType_LocalTime"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Message:
		return "InstrumentDiagnosticAlarmType_Message"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Severity:
		return "InstrumentDiagnosticAlarmType_Severity"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConditionClassId:
		return "InstrumentDiagnosticAlarmType_ConditionClassId"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConditionClassName:
		return "InstrumentDiagnosticAlarmType_ConditionClassName"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConditionSubClassId:
		return "InstrumentDiagnosticAlarmType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConditionSubClassName:
		return "InstrumentDiagnosticAlarmType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConditionName:
		return "InstrumentDiagnosticAlarmType_ConditionName"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_BranchId:
		return "InstrumentDiagnosticAlarmType_BranchId"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Retain:
		return "InstrumentDiagnosticAlarmType_Retain"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState:
		return "InstrumentDiagnosticAlarmType_EnabledState"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_Id:
		return "InstrumentDiagnosticAlarmType_EnabledState_Id"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_Name:
		return "InstrumentDiagnosticAlarmType_EnabledState_Name"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_Number:
		return "InstrumentDiagnosticAlarmType_EnabledState_Number"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_EffectiveDisplayName:
		return "InstrumentDiagnosticAlarmType_EnabledState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_TransitionTime:
		return "InstrumentDiagnosticAlarmType_EnabledState_TransitionTime"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_EffectiveTransitionTime:
		return "InstrumentDiagnosticAlarmType_EnabledState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_TrueState:
		return "InstrumentDiagnosticAlarmType_EnabledState_TrueState"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_EnabledState_FalseState:
		return "InstrumentDiagnosticAlarmType_EnabledState_FalseState"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Quality:
		return "InstrumentDiagnosticAlarmType_Quality"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Quality_SourceTimestamp:
		return "InstrumentDiagnosticAlarmType_Quality_SourceTimestamp"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LastSeverity:
		return "InstrumentDiagnosticAlarmType_LastSeverity"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LastSeverity_SourceTimestamp:
		return "InstrumentDiagnosticAlarmType_LastSeverity_SourceTimestamp"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Comment:
		return "InstrumentDiagnosticAlarmType_Comment"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Comment_SourceTimestamp:
		return "InstrumentDiagnosticAlarmType_Comment_SourceTimestamp"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ClientUserId:
		return "InstrumentDiagnosticAlarmType_ClientUserId"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AddComment_InputArguments:
		return "InstrumentDiagnosticAlarmType_AddComment_InputArguments"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConditionRefresh_InputArguments:
		return "InstrumentDiagnosticAlarmType_ConditionRefresh_InputArguments"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConditionRefresh2_InputArguments:
		return "InstrumentDiagnosticAlarmType_ConditionRefresh2_InputArguments"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState:
		return "InstrumentDiagnosticAlarmType_AckedState"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_Id:
		return "InstrumentDiagnosticAlarmType_AckedState_Id"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_Name:
		return "InstrumentDiagnosticAlarmType_AckedState_Name"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_Number:
		return "InstrumentDiagnosticAlarmType_AckedState_Number"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_EffectiveDisplayName:
		return "InstrumentDiagnosticAlarmType_AckedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_TransitionTime:
		return "InstrumentDiagnosticAlarmType_AckedState_TransitionTime"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_EffectiveTransitionTime:
		return "InstrumentDiagnosticAlarmType_AckedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_TrueState:
		return "InstrumentDiagnosticAlarmType_AckedState_TrueState"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AckedState_FalseState:
		return "InstrumentDiagnosticAlarmType_AckedState_FalseState"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState:
		return "InstrumentDiagnosticAlarmType_ConfirmedState"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_Id:
		return "InstrumentDiagnosticAlarmType_ConfirmedState_Id"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_Name:
		return "InstrumentDiagnosticAlarmType_ConfirmedState_Name"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_Number:
		return "InstrumentDiagnosticAlarmType_ConfirmedState_Number"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_EffectiveDisplayName:
		return "InstrumentDiagnosticAlarmType_ConfirmedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_TransitionTime:
		return "InstrumentDiagnosticAlarmType_ConfirmedState_TransitionTime"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_EffectiveTransitionTime:
		return "InstrumentDiagnosticAlarmType_ConfirmedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_TrueState:
		return "InstrumentDiagnosticAlarmType_ConfirmedState_TrueState"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ConfirmedState_FalseState:
		return "InstrumentDiagnosticAlarmType_ConfirmedState_FalseState"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Acknowledge_InputArguments:
		return "InstrumentDiagnosticAlarmType_Acknowledge_InputArguments"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Confirm_InputArguments:
		return "InstrumentDiagnosticAlarmType_Confirm_InputArguments"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState:
		return "InstrumentDiagnosticAlarmType_ActiveState"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_Id:
		return "InstrumentDiagnosticAlarmType_ActiveState_Id"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_Name:
		return "InstrumentDiagnosticAlarmType_ActiveState_Name"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_Number:
		return "InstrumentDiagnosticAlarmType_ActiveState_Number"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_EffectiveDisplayName:
		return "InstrumentDiagnosticAlarmType_ActiveState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_TransitionTime:
		return "InstrumentDiagnosticAlarmType_ActiveState_TransitionTime"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_EffectiveTransitionTime:
		return "InstrumentDiagnosticAlarmType_ActiveState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_TrueState:
		return "InstrumentDiagnosticAlarmType_ActiveState_TrueState"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ActiveState_FalseState:
		return "InstrumentDiagnosticAlarmType_ActiveState_FalseState"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_InputNode:
		return "InstrumentDiagnosticAlarmType_InputNode"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState:
		return "InstrumentDiagnosticAlarmType_SuppressedState"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_Id:
		return "InstrumentDiagnosticAlarmType_SuppressedState_Id"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_Name:
		return "InstrumentDiagnosticAlarmType_SuppressedState_Name"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_Number:
		return "InstrumentDiagnosticAlarmType_SuppressedState_Number"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_EffectiveDisplayName:
		return "InstrumentDiagnosticAlarmType_SuppressedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_TransitionTime:
		return "InstrumentDiagnosticAlarmType_SuppressedState_TransitionTime"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_EffectiveTransitionTime:
		return "InstrumentDiagnosticAlarmType_SuppressedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_TrueState:
		return "InstrumentDiagnosticAlarmType_SuppressedState_TrueState"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedState_FalseState:
		return "InstrumentDiagnosticAlarmType_SuppressedState_FalseState"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState:
		return "InstrumentDiagnosticAlarmType_OutOfServiceState"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_Id:
		return "InstrumentDiagnosticAlarmType_OutOfServiceState_Id"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_Name:
		return "InstrumentDiagnosticAlarmType_OutOfServiceState_Name"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_Number:
		return "InstrumentDiagnosticAlarmType_OutOfServiceState_Number"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_EffectiveDisplayName:
		return "InstrumentDiagnosticAlarmType_OutOfServiceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_TransitionTime:
		return "InstrumentDiagnosticAlarmType_OutOfServiceState_TransitionTime"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_EffectiveTransitionTime:
		return "InstrumentDiagnosticAlarmType_OutOfServiceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_TrueState:
		return "InstrumentDiagnosticAlarmType_OutOfServiceState_TrueState"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OutOfServiceState_FalseState:
		return "InstrumentDiagnosticAlarmType_OutOfServiceState_FalseState"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_CurrentState:
		return "InstrumentDiagnosticAlarmType_ShelvingState_CurrentState"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_Id:
		return "InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_Id"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_Name:
		return "InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_Name"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_Number:
		return "InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_Number"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_EffectiveDisplayName:
		return "InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_LastTransition:
		return "InstrumentDiagnosticAlarmType_ShelvingState_LastTransition"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_Id:
		return "InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_Id"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_Name:
		return "InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_Name"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_Number:
		return "InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_Number"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_TransitionTime:
		return "InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_TransitionTime"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime:
		return "InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_AvailableStates:
		return "InstrumentDiagnosticAlarmType_ShelvingState_AvailableStates"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_AvailableTransitions:
		return "InstrumentDiagnosticAlarmType_ShelvingState_AvailableTransitions"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_UnshelveTime:
		return "InstrumentDiagnosticAlarmType_ShelvingState_UnshelveTime"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_TimedShelve_InputArguments:
		return "InstrumentDiagnosticAlarmType_ShelvingState_TimedShelve_InputArguments"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SuppressedOrShelved:
		return "InstrumentDiagnosticAlarmType_SuppressedOrShelved"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_MaxTimeShelved:
		return "InstrumentDiagnosticAlarmType_MaxTimeShelved"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AudibleEnabled:
		return "InstrumentDiagnosticAlarmType_AudibleEnabled"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AudibleSound:
		return "InstrumentDiagnosticAlarmType_AudibleSound"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AudibleSound_ListId:
		return "InstrumentDiagnosticAlarmType_AudibleSound_ListId"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AudibleSound_AgencyId:
		return "InstrumentDiagnosticAlarmType_AudibleSound_AgencyId"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_AudibleSound_VersionId:
		return "InstrumentDiagnosticAlarmType_AudibleSound_VersionId"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState:
		return "InstrumentDiagnosticAlarmType_SilenceState"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_Id:
		return "InstrumentDiagnosticAlarmType_SilenceState_Id"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_Name:
		return "InstrumentDiagnosticAlarmType_SilenceState_Name"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_Number:
		return "InstrumentDiagnosticAlarmType_SilenceState_Number"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_EffectiveDisplayName:
		return "InstrumentDiagnosticAlarmType_SilenceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_TransitionTime:
		return "InstrumentDiagnosticAlarmType_SilenceState_TransitionTime"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_EffectiveTransitionTime:
		return "InstrumentDiagnosticAlarmType_SilenceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_TrueState:
		return "InstrumentDiagnosticAlarmType_SilenceState_TrueState"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SilenceState_FalseState:
		return "InstrumentDiagnosticAlarmType_SilenceState_FalseState"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OnDelay:
		return "InstrumentDiagnosticAlarmType_OnDelay"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_OffDelay:
		return "InstrumentDiagnosticAlarmType_OffDelay"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_FirstInGroupFlag:
		return "InstrumentDiagnosticAlarmType_FirstInGroupFlag"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState:
		return "InstrumentDiagnosticAlarmType_LatchedState"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_Id:
		return "InstrumentDiagnosticAlarmType_LatchedState_Id"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_Name:
		return "InstrumentDiagnosticAlarmType_LatchedState_Name"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_Number:
		return "InstrumentDiagnosticAlarmType_LatchedState_Number"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_EffectiveDisplayName:
		return "InstrumentDiagnosticAlarmType_LatchedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_TransitionTime:
		return "InstrumentDiagnosticAlarmType_LatchedState_TransitionTime"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_EffectiveTransitionTime:
		return "InstrumentDiagnosticAlarmType_LatchedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_TrueState:
		return "InstrumentDiagnosticAlarmType_LatchedState_TrueState"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_LatchedState_FalseState:
		return "InstrumentDiagnosticAlarmType_LatchedState_FalseState"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ReAlarmTime:
		return "InstrumentDiagnosticAlarmType_ReAlarmTime"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ReAlarmRepeatCount:
		return "InstrumentDiagnosticAlarmType_ReAlarmRepeatCount"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_NormalState:
		return "InstrumentDiagnosticAlarmType_NormalState"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Suppress2_InputArguments:
		return "InstrumentDiagnosticAlarmType_Suppress2_InputArguments"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Unsuppress2_InputArguments:
		return "InstrumentDiagnosticAlarmType_Unsuppress2_InputArguments"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_RemoveFromService2_InputArguments:
		return "InstrumentDiagnosticAlarmType_RemoveFromService2_InputArguments"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_PlaceInService2_InputArguments:
		return "InstrumentDiagnosticAlarmType_PlaceInService2_InputArguments"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_Reset2_InputArguments:
		return "InstrumentDiagnosticAlarmType_Reset2_InputArguments"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_TimedShelve2_InputArguments:
		return "InstrumentDiagnosticAlarmType_ShelvingState_TimedShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_Unshelve2_InputArguments:
		return "InstrumentDiagnosticAlarmType_ShelvingState_Unshelve2_InputArguments"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_ShelvingState_OneShotShelve2_InputArguments:
		return "InstrumentDiagnosticAlarmType_ShelvingState_OneShotShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_GetGroupMemberships_OutputArguments:
		return "InstrumentDiagnosticAlarmType_GetGroupMemberships_OutputArguments"
	case OpcuaNodeIdServicesVariableInstrument_InstrumentDiagnosticAlarmType_SupportsFilteredRetain:
		return "InstrumentDiagnosticAlarmType_SupportsFilteredRetain"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableInstrument) String() string {
	return e.PLC4XEnumName()
}
