/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableIetf is an enum
type OpcuaNodeIdServicesVariableIetf int32

type IOpcuaNodeIdServicesVariableIetf interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_AdminStatus            OpcuaNodeIdServicesVariableIetf = 25222
	OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_OperStatus             OpcuaNodeIdServicesVariableIetf = 25223
	OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_PhysAddress            OpcuaNodeIdServicesVariableIetf = 25224
	OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_Speed                  OpcuaNodeIdServicesVariableIetf = 25225
	OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_Speed_Definition       OpcuaNodeIdServicesVariableIetf = 25248
	OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_Speed_ValuePrecision   OpcuaNodeIdServicesVariableIetf = 25249
	OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_Speed_InstrumentRange  OpcuaNodeIdServicesVariableIetf = 25250
	OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_Speed_EURange          OpcuaNodeIdServicesVariableIetf = 25251
	OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_Speed_EngineeringUnits OpcuaNodeIdServicesVariableIetf = 25252
)

var OpcuaNodeIdServicesVariableIetfValues []OpcuaNodeIdServicesVariableIetf

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableIetfValues = []OpcuaNodeIdServicesVariableIetf{
		OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_AdminStatus,
		OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_OperStatus,
		OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_PhysAddress,
		OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_Speed,
		OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_Speed_Definition,
		OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_Speed_ValuePrecision,
		OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_Speed_InstrumentRange,
		OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_Speed_EURange,
		OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_Speed_EngineeringUnits,
	}
}

func OpcuaNodeIdServicesVariableIetfByValue(value int32) (enum OpcuaNodeIdServicesVariableIetf, ok bool) {
	switch value {
	case 25222:
		return OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_AdminStatus, true
	case 25223:
		return OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_OperStatus, true
	case 25224:
		return OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_PhysAddress, true
	case 25225:
		return OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_Speed, true
	case 25248:
		return OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_Speed_Definition, true
	case 25249:
		return OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_Speed_ValuePrecision, true
	case 25250:
		return OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_Speed_InstrumentRange, true
	case 25251:
		return OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_Speed_EURange, true
	case 25252:
		return OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_Speed_EngineeringUnits, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableIetfByName(value string) (enum OpcuaNodeIdServicesVariableIetf, ok bool) {
	switch value {
	case "IetfBaseNetworkInterfaceType_AdminStatus":
		return OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_AdminStatus, true
	case "IetfBaseNetworkInterfaceType_OperStatus":
		return OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_OperStatus, true
	case "IetfBaseNetworkInterfaceType_PhysAddress":
		return OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_PhysAddress, true
	case "IetfBaseNetworkInterfaceType_Speed":
		return OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_Speed, true
	case "IetfBaseNetworkInterfaceType_Speed_Definition":
		return OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_Speed_Definition, true
	case "IetfBaseNetworkInterfaceType_Speed_ValuePrecision":
		return OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_Speed_ValuePrecision, true
	case "IetfBaseNetworkInterfaceType_Speed_InstrumentRange":
		return OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_Speed_InstrumentRange, true
	case "IetfBaseNetworkInterfaceType_Speed_EURange":
		return OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_Speed_EURange, true
	case "IetfBaseNetworkInterfaceType_Speed_EngineeringUnits":
		return OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_Speed_EngineeringUnits, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableIetfKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableIetfValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableIetf(structType any) OpcuaNodeIdServicesVariableIetf {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableIetf {
		if sOpcuaNodeIdServicesVariableIetf, ok := typ.(OpcuaNodeIdServicesVariableIetf); ok {
			return sOpcuaNodeIdServicesVariableIetf
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableIetf) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableIetf) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableIetfParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableIetf, error) {
	return OpcuaNodeIdServicesVariableIetfParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableIetfParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableIetf, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableIetf", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableIetf")
	}
	if enum, ok := OpcuaNodeIdServicesVariableIetfByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableIetf")
		return OpcuaNodeIdServicesVariableIetf(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableIetf) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableIetf) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableIetf", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableIetf) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_AdminStatus:
		return "IetfBaseNetworkInterfaceType_AdminStatus"
	case OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_OperStatus:
		return "IetfBaseNetworkInterfaceType_OperStatus"
	case OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_PhysAddress:
		return "IetfBaseNetworkInterfaceType_PhysAddress"
	case OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_Speed:
		return "IetfBaseNetworkInterfaceType_Speed"
	case OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_Speed_Definition:
		return "IetfBaseNetworkInterfaceType_Speed_Definition"
	case OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_Speed_ValuePrecision:
		return "IetfBaseNetworkInterfaceType_Speed_ValuePrecision"
	case OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_Speed_InstrumentRange:
		return "IetfBaseNetworkInterfaceType_Speed_InstrumentRange"
	case OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_Speed_EURange:
		return "IetfBaseNetworkInterfaceType_Speed_EURange"
	case OpcuaNodeIdServicesVariableIetf_IetfBaseNetworkInterfaceType_Speed_EngineeringUnits:
		return "IetfBaseNetworkInterfaceType_Speed_EngineeringUnits"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableIetf) String() string {
	return e.PLC4XEnumName()
}
