/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableHistory is an enum
type OpcuaNodeIdServicesVariableHistory int32

type IOpcuaNodeIdServicesVariableHistory interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_AccessHistoryDataCapability   OpcuaNodeIdServicesVariableHistory = 2331
	OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_AccessHistoryEventsCapability OpcuaNodeIdServicesVariableHistory = 2332
	OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_InsertDataCapability          OpcuaNodeIdServicesVariableHistory = 2334
	OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_ReplaceDataCapability         OpcuaNodeIdServicesVariableHistory = 2335
	OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_UpdateDataCapability          OpcuaNodeIdServicesVariableHistory = 2336
	OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_DeleteRawCapability           OpcuaNodeIdServicesVariableHistory = 2337
	OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_DeleteAtTimeCapability        OpcuaNodeIdServicesVariableHistory = 2338
	OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_AccessHistoryDataCapability       OpcuaNodeIdServicesVariableHistory = 11193
	OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_InsertDataCapability              OpcuaNodeIdServicesVariableHistory = 11196
	OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_ReplaceDataCapability             OpcuaNodeIdServicesVariableHistory = 11197
	OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_UpdateDataCapability              OpcuaNodeIdServicesVariableHistory = 11198
	OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_DeleteRawCapability               OpcuaNodeIdServicesVariableHistory = 11199
	OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_DeleteAtTimeCapability            OpcuaNodeIdServicesVariableHistory = 11200
	OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_AccessHistoryEventsCapability     OpcuaNodeIdServicesVariableHistory = 11242
	OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_MaxReturnDataValues           OpcuaNodeIdServicesVariableHistory = 11268
	OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_MaxReturnEventValues          OpcuaNodeIdServicesVariableHistory = 11269
	OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_InsertAnnotationCapability    OpcuaNodeIdServicesVariableHistory = 11270
	OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_MaxReturnDataValues               OpcuaNodeIdServicesVariableHistory = 11273
	OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_MaxReturnEventValues              OpcuaNodeIdServicesVariableHistory = 11274
	OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_InsertAnnotationCapability        OpcuaNodeIdServicesVariableHistory = 11275
	OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_InsertEventCapability         OpcuaNodeIdServicesVariableHistory = 11278
	OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_ReplaceEventCapability        OpcuaNodeIdServicesVariableHistory = 11279
	OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_UpdateEventCapability         OpcuaNodeIdServicesVariableHistory = 11280
	OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_InsertEventCapability             OpcuaNodeIdServicesVariableHistory = 11281
	OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_ReplaceEventCapability            OpcuaNodeIdServicesVariableHistory = 11282
	OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_UpdateEventCapability             OpcuaNodeIdServicesVariableHistory = 11283
	OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_DeleteEventCapability         OpcuaNodeIdServicesVariableHistory = 11501
	OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_DeleteEventCapability             OpcuaNodeIdServicesVariableHistory = 11502
	OpcuaNodeIdServicesVariableHistory_HistoryUpdateType_EnumValues                                OpcuaNodeIdServicesVariableHistory = 11884
	OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_ServerTimestampSupported          OpcuaNodeIdServicesVariableHistory = 19091
	OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_ServerTimestampSupported      OpcuaNodeIdServicesVariableHistory = 19094
)

var OpcuaNodeIdServicesVariableHistoryValues []OpcuaNodeIdServicesVariableHistory

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableHistoryValues = []OpcuaNodeIdServicesVariableHistory{
		OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_AccessHistoryDataCapability,
		OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_AccessHistoryEventsCapability,
		OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_InsertDataCapability,
		OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_ReplaceDataCapability,
		OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_UpdateDataCapability,
		OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_DeleteRawCapability,
		OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_DeleteAtTimeCapability,
		OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_AccessHistoryDataCapability,
		OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_InsertDataCapability,
		OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_ReplaceDataCapability,
		OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_UpdateDataCapability,
		OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_DeleteRawCapability,
		OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_DeleteAtTimeCapability,
		OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_AccessHistoryEventsCapability,
		OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_MaxReturnDataValues,
		OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_MaxReturnEventValues,
		OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_InsertAnnotationCapability,
		OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_MaxReturnDataValues,
		OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_MaxReturnEventValues,
		OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_InsertAnnotationCapability,
		OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_InsertEventCapability,
		OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_ReplaceEventCapability,
		OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_UpdateEventCapability,
		OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_InsertEventCapability,
		OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_ReplaceEventCapability,
		OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_UpdateEventCapability,
		OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_DeleteEventCapability,
		OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_DeleteEventCapability,
		OpcuaNodeIdServicesVariableHistory_HistoryUpdateType_EnumValues,
		OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_ServerTimestampSupported,
		OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_ServerTimestampSupported,
	}
}

func OpcuaNodeIdServicesVariableHistoryByValue(value int32) (enum OpcuaNodeIdServicesVariableHistory, ok bool) {
	switch value {
	case 11193:
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_AccessHistoryDataCapability, true
	case 11196:
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_InsertDataCapability, true
	case 11197:
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_ReplaceDataCapability, true
	case 11198:
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_UpdateDataCapability, true
	case 11199:
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_DeleteRawCapability, true
	case 11200:
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_DeleteAtTimeCapability, true
	case 11242:
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_AccessHistoryEventsCapability, true
	case 11268:
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_MaxReturnDataValues, true
	case 11269:
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_MaxReturnEventValues, true
	case 11270:
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_InsertAnnotationCapability, true
	case 11273:
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_MaxReturnDataValues, true
	case 11274:
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_MaxReturnEventValues, true
	case 11275:
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_InsertAnnotationCapability, true
	case 11278:
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_InsertEventCapability, true
	case 11279:
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_ReplaceEventCapability, true
	case 11280:
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_UpdateEventCapability, true
	case 11281:
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_InsertEventCapability, true
	case 11282:
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_ReplaceEventCapability, true
	case 11283:
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_UpdateEventCapability, true
	case 11501:
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_DeleteEventCapability, true
	case 11502:
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_DeleteEventCapability, true
	case 11884:
		return OpcuaNodeIdServicesVariableHistory_HistoryUpdateType_EnumValues, true
	case 19091:
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_ServerTimestampSupported, true
	case 19094:
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_ServerTimestampSupported, true
	case 2331:
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_AccessHistoryDataCapability, true
	case 2332:
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_AccessHistoryEventsCapability, true
	case 2334:
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_InsertDataCapability, true
	case 2335:
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_ReplaceDataCapability, true
	case 2336:
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_UpdateDataCapability, true
	case 2337:
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_DeleteRawCapability, true
	case 2338:
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_DeleteAtTimeCapability, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableHistoryByName(value string) (enum OpcuaNodeIdServicesVariableHistory, ok bool) {
	switch value {
	case "HistoryServerCapabilities_AccessHistoryDataCapability":
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_AccessHistoryDataCapability, true
	case "HistoryServerCapabilities_InsertDataCapability":
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_InsertDataCapability, true
	case "HistoryServerCapabilities_ReplaceDataCapability":
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_ReplaceDataCapability, true
	case "HistoryServerCapabilities_UpdateDataCapability":
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_UpdateDataCapability, true
	case "HistoryServerCapabilities_DeleteRawCapability":
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_DeleteRawCapability, true
	case "HistoryServerCapabilities_DeleteAtTimeCapability":
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_DeleteAtTimeCapability, true
	case "HistoryServerCapabilities_AccessHistoryEventsCapability":
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_AccessHistoryEventsCapability, true
	case "HistoryServerCapabilitiesType_MaxReturnDataValues":
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_MaxReturnDataValues, true
	case "HistoryServerCapabilitiesType_MaxReturnEventValues":
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_MaxReturnEventValues, true
	case "HistoryServerCapabilitiesType_InsertAnnotationCapability":
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_InsertAnnotationCapability, true
	case "HistoryServerCapabilities_MaxReturnDataValues":
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_MaxReturnDataValues, true
	case "HistoryServerCapabilities_MaxReturnEventValues":
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_MaxReturnEventValues, true
	case "HistoryServerCapabilities_InsertAnnotationCapability":
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_InsertAnnotationCapability, true
	case "HistoryServerCapabilitiesType_InsertEventCapability":
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_InsertEventCapability, true
	case "HistoryServerCapabilitiesType_ReplaceEventCapability":
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_ReplaceEventCapability, true
	case "HistoryServerCapabilitiesType_UpdateEventCapability":
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_UpdateEventCapability, true
	case "HistoryServerCapabilities_InsertEventCapability":
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_InsertEventCapability, true
	case "HistoryServerCapabilities_ReplaceEventCapability":
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_ReplaceEventCapability, true
	case "HistoryServerCapabilities_UpdateEventCapability":
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_UpdateEventCapability, true
	case "HistoryServerCapabilitiesType_DeleteEventCapability":
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_DeleteEventCapability, true
	case "HistoryServerCapabilities_DeleteEventCapability":
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_DeleteEventCapability, true
	case "HistoryUpdateType_EnumValues":
		return OpcuaNodeIdServicesVariableHistory_HistoryUpdateType_EnumValues, true
	case "HistoryServerCapabilities_ServerTimestampSupported":
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_ServerTimestampSupported, true
	case "HistoryServerCapabilitiesType_ServerTimestampSupported":
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_ServerTimestampSupported, true
	case "HistoryServerCapabilitiesType_AccessHistoryDataCapability":
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_AccessHistoryDataCapability, true
	case "HistoryServerCapabilitiesType_AccessHistoryEventsCapability":
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_AccessHistoryEventsCapability, true
	case "HistoryServerCapabilitiesType_InsertDataCapability":
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_InsertDataCapability, true
	case "HistoryServerCapabilitiesType_ReplaceDataCapability":
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_ReplaceDataCapability, true
	case "HistoryServerCapabilitiesType_UpdateDataCapability":
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_UpdateDataCapability, true
	case "HistoryServerCapabilitiesType_DeleteRawCapability":
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_DeleteRawCapability, true
	case "HistoryServerCapabilitiesType_DeleteAtTimeCapability":
		return OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_DeleteAtTimeCapability, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableHistoryKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableHistoryValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableHistory(structType any) OpcuaNodeIdServicesVariableHistory {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableHistory {
		if sOpcuaNodeIdServicesVariableHistory, ok := typ.(OpcuaNodeIdServicesVariableHistory); ok {
			return sOpcuaNodeIdServicesVariableHistory
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableHistory) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableHistory) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableHistoryParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableHistory, error) {
	return OpcuaNodeIdServicesVariableHistoryParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableHistoryParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableHistory, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableHistory", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableHistory")
	}
	if enum, ok := OpcuaNodeIdServicesVariableHistoryByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableHistory")
		return OpcuaNodeIdServicesVariableHistory(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableHistory) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableHistory) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableHistory", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableHistory) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_AccessHistoryDataCapability:
		return "HistoryServerCapabilities_AccessHistoryDataCapability"
	case OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_InsertDataCapability:
		return "HistoryServerCapabilities_InsertDataCapability"
	case OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_ReplaceDataCapability:
		return "HistoryServerCapabilities_ReplaceDataCapability"
	case OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_UpdateDataCapability:
		return "HistoryServerCapabilities_UpdateDataCapability"
	case OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_DeleteRawCapability:
		return "HistoryServerCapabilities_DeleteRawCapability"
	case OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_DeleteAtTimeCapability:
		return "HistoryServerCapabilities_DeleteAtTimeCapability"
	case OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_AccessHistoryEventsCapability:
		return "HistoryServerCapabilities_AccessHistoryEventsCapability"
	case OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_MaxReturnDataValues:
		return "HistoryServerCapabilitiesType_MaxReturnDataValues"
	case OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_MaxReturnEventValues:
		return "HistoryServerCapabilitiesType_MaxReturnEventValues"
	case OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_InsertAnnotationCapability:
		return "HistoryServerCapabilitiesType_InsertAnnotationCapability"
	case OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_MaxReturnDataValues:
		return "HistoryServerCapabilities_MaxReturnDataValues"
	case OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_MaxReturnEventValues:
		return "HistoryServerCapabilities_MaxReturnEventValues"
	case OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_InsertAnnotationCapability:
		return "HistoryServerCapabilities_InsertAnnotationCapability"
	case OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_InsertEventCapability:
		return "HistoryServerCapabilitiesType_InsertEventCapability"
	case OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_ReplaceEventCapability:
		return "HistoryServerCapabilitiesType_ReplaceEventCapability"
	case OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_UpdateEventCapability:
		return "HistoryServerCapabilitiesType_UpdateEventCapability"
	case OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_InsertEventCapability:
		return "HistoryServerCapabilities_InsertEventCapability"
	case OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_ReplaceEventCapability:
		return "HistoryServerCapabilities_ReplaceEventCapability"
	case OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_UpdateEventCapability:
		return "HistoryServerCapabilities_UpdateEventCapability"
	case OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_DeleteEventCapability:
		return "HistoryServerCapabilitiesType_DeleteEventCapability"
	case OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_DeleteEventCapability:
		return "HistoryServerCapabilities_DeleteEventCapability"
	case OpcuaNodeIdServicesVariableHistory_HistoryUpdateType_EnumValues:
		return "HistoryUpdateType_EnumValues"
	case OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilities_ServerTimestampSupported:
		return "HistoryServerCapabilities_ServerTimestampSupported"
	case OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_ServerTimestampSupported:
		return "HistoryServerCapabilitiesType_ServerTimestampSupported"
	case OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_AccessHistoryDataCapability:
		return "HistoryServerCapabilitiesType_AccessHistoryDataCapability"
	case OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_AccessHistoryEventsCapability:
		return "HistoryServerCapabilitiesType_AccessHistoryEventsCapability"
	case OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_InsertDataCapability:
		return "HistoryServerCapabilitiesType_InsertDataCapability"
	case OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_ReplaceDataCapability:
		return "HistoryServerCapabilitiesType_ReplaceDataCapability"
	case OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_UpdateDataCapability:
		return "HistoryServerCapabilitiesType_UpdateDataCapability"
	case OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_DeleteRawCapability:
		return "HistoryServerCapabilitiesType_DeleteRawCapability"
	case OpcuaNodeIdServicesVariableHistory_HistoryServerCapabilitiesType_DeleteAtTimeCapability:
		return "HistoryServerCapabilitiesType_DeleteAtTimeCapability"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableHistory) String() string {
	return e.PLC4XEnumName()
}
