/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableEvent is an enum
type OpcuaNodeIdServicesVariableEvent int32

type IOpcuaNodeIdServicesVariableEvent interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableEvent_EventNotifierType_OptionSetValues OpcuaNodeIdServicesVariableEvent = 15034
)

var OpcuaNodeIdServicesVariableEventValues []OpcuaNodeIdServicesVariableEvent

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableEventValues = []OpcuaNodeIdServicesVariableEvent{
		OpcuaNodeIdServicesVariableEvent_EventNotifierType_OptionSetValues,
	}
}

func OpcuaNodeIdServicesVariableEventByValue(value int32) (enum OpcuaNodeIdServicesVariableEvent, ok bool) {
	switch value {
	case 15034:
		return OpcuaNodeIdServicesVariableEvent_EventNotifierType_OptionSetValues, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableEventByName(value string) (enum OpcuaNodeIdServicesVariableEvent, ok bool) {
	switch value {
	case "EventNotifierType_OptionSetValues":
		return OpcuaNodeIdServicesVariableEvent_EventNotifierType_OptionSetValues, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableEventKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableEventValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableEvent(structType any) OpcuaNodeIdServicesVariableEvent {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableEvent {
		if sOpcuaNodeIdServicesVariableEvent, ok := typ.(OpcuaNodeIdServicesVariableEvent); ok {
			return sOpcuaNodeIdServicesVariableEvent
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableEvent) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableEvent) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableEventParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableEvent, error) {
	return OpcuaNodeIdServicesVariableEventParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableEventParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableEvent, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableEvent", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableEvent")
	}
	if enum, ok := OpcuaNodeIdServicesVariableEventByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableEvent")
		return OpcuaNodeIdServicesVariableEvent(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableEvent) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableEvent) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableEvent", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableEvent) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableEvent_EventNotifierType_OptionSetValues:
		return "EventNotifierType_OptionSetValues"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableEvent) String() string {
	return e.PLC4XEnumName()
}
