/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableDiscrepancy is an enum
type OpcuaNodeIdServicesVariableDiscrepancy int32

type IOpcuaNodeIdServicesVariableDiscrepancy interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_TargetValueNode OpcuaNodeIdServicesVariableDiscrepancy = 17215
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ExpectedTime    OpcuaNodeIdServicesVariableDiscrepancy = 17216
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Tolerance       OpcuaNodeIdServicesVariableDiscrepancy = 17217
)

var OpcuaNodeIdServicesVariableDiscrepancyValues []OpcuaNodeIdServicesVariableDiscrepancy

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableDiscrepancyValues = []OpcuaNodeIdServicesVariableDiscrepancy{
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_TargetValueNode,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ExpectedTime,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Tolerance,
	}
}

func OpcuaNodeIdServicesVariableDiscrepancyByValue(value int32) (enum OpcuaNodeIdServicesVariableDiscrepancy, ok bool) {
	switch value {
	case 17215:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_TargetValueNode, true
	case 17216:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ExpectedTime, true
	case 17217:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Tolerance, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableDiscrepancyByName(value string) (enum OpcuaNodeIdServicesVariableDiscrepancy, ok bool) {
	switch value {
	case "DiscrepancyAlarmType_TargetValueNode":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_TargetValueNode, true
	case "DiscrepancyAlarmType_ExpectedTime":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ExpectedTime, true
	case "DiscrepancyAlarmType_Tolerance":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Tolerance, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableDiscrepancyKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableDiscrepancyValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableDiscrepancy(structType any) OpcuaNodeIdServicesVariableDiscrepancy {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableDiscrepancy {
		if sOpcuaNodeIdServicesVariableDiscrepancy, ok := typ.(OpcuaNodeIdServicesVariableDiscrepancy); ok {
			return sOpcuaNodeIdServicesVariableDiscrepancy
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableDiscrepancy) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableDiscrepancy) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableDiscrepancyParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableDiscrepancy, error) {
	return OpcuaNodeIdServicesVariableDiscrepancyParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableDiscrepancyParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableDiscrepancy, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableDiscrepancy", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableDiscrepancy")
	}
	if enum, ok := OpcuaNodeIdServicesVariableDiscrepancyByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableDiscrepancy")
		return OpcuaNodeIdServicesVariableDiscrepancy(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableDiscrepancy) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableDiscrepancy) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableDiscrepancy", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableDiscrepancy) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_TargetValueNode:
		return "DiscrepancyAlarmType_TargetValueNode"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ExpectedTime:
		return "DiscrepancyAlarmType_ExpectedTime"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Tolerance:
		return "DiscrepancyAlarmType_Tolerance"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableDiscrepancy) String() string {
	return e.PLC4XEnumName()
}
