/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableDelete is an enum
type OpcuaNodeIdServicesVariableDelete int32

type IOpcuaNodeIdServicesVariableDelete interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableDelete_DeleteFileMethodType_InputArguments                 OpcuaNodeIdServicesVariableDelete = 13349
	OpcuaNodeIdServicesVariableDelete_DeletePriorityMappingEntryMethodType_InputArguments OpcuaNodeIdServicesVariableDelete = 25236
)

var OpcuaNodeIdServicesVariableDeleteValues []OpcuaNodeIdServicesVariableDelete

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableDeleteValues = []OpcuaNodeIdServicesVariableDelete{
		OpcuaNodeIdServicesVariableDelete_DeleteFileMethodType_InputArguments,
		OpcuaNodeIdServicesVariableDelete_DeletePriorityMappingEntryMethodType_InputArguments,
	}
}

func OpcuaNodeIdServicesVariableDeleteByValue(value int32) (enum OpcuaNodeIdServicesVariableDelete, ok bool) {
	switch value {
	case 13349:
		return OpcuaNodeIdServicesVariableDelete_DeleteFileMethodType_InputArguments, true
	case 25236:
		return OpcuaNodeIdServicesVariableDelete_DeletePriorityMappingEntryMethodType_InputArguments, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableDeleteByName(value string) (enum OpcuaNodeIdServicesVariableDelete, ok bool) {
	switch value {
	case "DeleteFileMethodType_InputArguments":
		return OpcuaNodeIdServicesVariableDelete_DeleteFileMethodType_InputArguments, true
	case "DeletePriorityMappingEntryMethodType_InputArguments":
		return OpcuaNodeIdServicesVariableDelete_DeletePriorityMappingEntryMethodType_InputArguments, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableDeleteKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableDeleteValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableDelete(structType any) OpcuaNodeIdServicesVariableDelete {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableDelete {
		if sOpcuaNodeIdServicesVariableDelete, ok := typ.(OpcuaNodeIdServicesVariableDelete); ok {
			return sOpcuaNodeIdServicesVariableDelete
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableDelete) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableDelete) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableDeleteParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableDelete, error) {
	return OpcuaNodeIdServicesVariableDeleteParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableDeleteParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableDelete, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableDelete", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableDelete")
	}
	if enum, ok := OpcuaNodeIdServicesVariableDeleteByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableDelete")
		return OpcuaNodeIdServicesVariableDelete(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableDelete) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableDelete) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableDelete", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableDelete) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableDelete_DeleteFileMethodType_InputArguments:
		return "DeleteFileMethodType_InputArguments"
	case OpcuaNodeIdServicesVariableDelete_DeletePriorityMappingEntryMethodType_InputArguments:
		return "DeletePriorityMappingEntryMethodType_InputArguments"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableDelete) String() string {
	return e.PLC4XEnumName()
}
