/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableCube is an enum
type OpcuaNodeIdServicesVariableCube int32

type IOpcuaNodeIdServicesVariableCube interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableCube_CubeItemType_XAxisDefinition OpcuaNodeIdServicesVariableCube = 12065
	OpcuaNodeIdServicesVariableCube_CubeItemType_YAxisDefinition OpcuaNodeIdServicesVariableCube = 12066
	OpcuaNodeIdServicesVariableCube_CubeItemType_ZAxisDefinition OpcuaNodeIdServicesVariableCube = 12067
)

var OpcuaNodeIdServicesVariableCubeValues []OpcuaNodeIdServicesVariableCube

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableCubeValues = []OpcuaNodeIdServicesVariableCube{
		OpcuaNodeIdServicesVariableCube_CubeItemType_XAxisDefinition,
		OpcuaNodeIdServicesVariableCube_CubeItemType_YAxisDefinition,
		OpcuaNodeIdServicesVariableCube_CubeItemType_ZAxisDefinition,
	}
}

func OpcuaNodeIdServicesVariableCubeByValue(value int32) (enum OpcuaNodeIdServicesVariableCube, ok bool) {
	switch value {
	case 12065:
		return OpcuaNodeIdServicesVariableCube_CubeItemType_XAxisDefinition, true
	case 12066:
		return OpcuaNodeIdServicesVariableCube_CubeItemType_YAxisDefinition, true
	case 12067:
		return OpcuaNodeIdServicesVariableCube_CubeItemType_ZAxisDefinition, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableCubeByName(value string) (enum OpcuaNodeIdServicesVariableCube, ok bool) {
	switch value {
	case "CubeItemType_XAxisDefinition":
		return OpcuaNodeIdServicesVariableCube_CubeItemType_XAxisDefinition, true
	case "CubeItemType_YAxisDefinition":
		return OpcuaNodeIdServicesVariableCube_CubeItemType_YAxisDefinition, true
	case "CubeItemType_ZAxisDefinition":
		return OpcuaNodeIdServicesVariableCube_CubeItemType_ZAxisDefinition, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableCubeKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableCubeValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableCube(structType any) OpcuaNodeIdServicesVariableCube {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableCube {
		if sOpcuaNodeIdServicesVariableCube, ok := typ.(OpcuaNodeIdServicesVariableCube); ok {
			return sOpcuaNodeIdServicesVariableCube
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableCube) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableCube) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableCubeParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableCube, error) {
	return OpcuaNodeIdServicesVariableCubeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableCubeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableCube, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableCube", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableCube")
	}
	if enum, ok := OpcuaNodeIdServicesVariableCubeByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableCube")
		return OpcuaNodeIdServicesVariableCube(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableCube) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableCube) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableCube", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableCube) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableCube_CubeItemType_XAxisDefinition:
		return "CubeItemType_XAxisDefinition"
	case OpcuaNodeIdServicesVariableCube_CubeItemType_YAxisDefinition:
		return "CubeItemType_YAxisDefinition"
	case OpcuaNodeIdServicesVariableCube_CubeItemType_ZAxisDefinition:
		return "CubeItemType_ZAxisDefinition"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableCube) String() string {
	return e.PLC4XEnumName()
}
