/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableApplication is an enum
type OpcuaNodeIdServicesVariableApplication int32

type IOpcuaNodeIdServicesVariableApplication interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableApplication_ApplicationType_EnumStrings                  OpcuaNodeIdServicesVariableApplication = 7597
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_Enabled         OpcuaNodeIdServicesVariableApplication = 26849
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_ApplicationUri  OpcuaNodeIdServicesVariableApplication = 26850
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_ProductUri      OpcuaNodeIdServicesVariableApplication = 26851
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_ApplicationType OpcuaNodeIdServicesVariableApplication = 26852
)

var OpcuaNodeIdServicesVariableApplicationValues []OpcuaNodeIdServicesVariableApplication

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableApplicationValues = []OpcuaNodeIdServicesVariableApplication{
		OpcuaNodeIdServicesVariableApplication_ApplicationType_EnumStrings,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_Enabled,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_ApplicationUri,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_ProductUri,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_ApplicationType,
	}
}

func OpcuaNodeIdServicesVariableApplicationByValue(value int32) (enum OpcuaNodeIdServicesVariableApplication, ok bool) {
	switch value {
	case 26849:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_Enabled, true
	case 26850:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_ApplicationUri, true
	case 26851:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_ProductUri, true
	case 26852:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_ApplicationType, true
	case 7597:
		return OpcuaNodeIdServicesVariableApplication_ApplicationType_EnumStrings, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableApplicationByName(value string) (enum OpcuaNodeIdServicesVariableApplication, ok bool) {
	switch value {
	case "ApplicationConfigurationType_Enabled":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_Enabled, true
	case "ApplicationConfigurationType_ApplicationUri":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_ApplicationUri, true
	case "ApplicationConfigurationType_ProductUri":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_ProductUri, true
	case "ApplicationConfigurationType_ApplicationType":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_ApplicationType, true
	case "ApplicationType_EnumStrings":
		return OpcuaNodeIdServicesVariableApplication_ApplicationType_EnumStrings, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableApplicationKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableApplicationValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableApplication(structType any) OpcuaNodeIdServicesVariableApplication {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableApplication {
		if sOpcuaNodeIdServicesVariableApplication, ok := typ.(OpcuaNodeIdServicesVariableApplication); ok {
			return sOpcuaNodeIdServicesVariableApplication
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableApplication) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableApplication) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableApplicationParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableApplication, error) {
	return OpcuaNodeIdServicesVariableApplicationParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableApplicationParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableApplication, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableApplication", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableApplication")
	}
	if enum, ok := OpcuaNodeIdServicesVariableApplicationByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableApplication")
		return OpcuaNodeIdServicesVariableApplication(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableApplication) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableApplication) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableApplication", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableApplication) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_Enabled:
		return "ApplicationConfigurationType_Enabled"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_ApplicationUri:
		return "ApplicationConfigurationType_ApplicationUri"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_ProductUri:
		return "ApplicationConfigurationType_ProductUri"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_ApplicationType:
		return "ApplicationConfigurationType_ApplicationType"
	case OpcuaNodeIdServicesVariableApplication_ApplicationType_EnumStrings:
		return "ApplicationType_EnumStrings"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableApplication) String() string {
	return e.PLC4XEnumName()
}
