/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableAlternative is an enum
type OpcuaNodeIdServicesVariableAlternative int32

type IOpcuaNodeIdServicesVariableAlternative interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableAlternative_AlternativeUnitType_LinearConversion        OpcuaNodeIdServicesVariableAlternative = 32472
	OpcuaNodeIdServicesVariableAlternative_AlternativeUnitType_MathMLConversion        OpcuaNodeIdServicesVariableAlternative = 32473
	OpcuaNodeIdServicesVariableAlternative_AlternativeUnitType_MathMLInverseConversion OpcuaNodeIdServicesVariableAlternative = 32474
)

var OpcuaNodeIdServicesVariableAlternativeValues []OpcuaNodeIdServicesVariableAlternative

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableAlternativeValues = []OpcuaNodeIdServicesVariableAlternative{
		OpcuaNodeIdServicesVariableAlternative_AlternativeUnitType_LinearConversion,
		OpcuaNodeIdServicesVariableAlternative_AlternativeUnitType_MathMLConversion,
		OpcuaNodeIdServicesVariableAlternative_AlternativeUnitType_MathMLInverseConversion,
	}
}

func OpcuaNodeIdServicesVariableAlternativeByValue(value int32) (enum OpcuaNodeIdServicesVariableAlternative, ok bool) {
	switch value {
	case 32472:
		return OpcuaNodeIdServicesVariableAlternative_AlternativeUnitType_LinearConversion, true
	case 32473:
		return OpcuaNodeIdServicesVariableAlternative_AlternativeUnitType_MathMLConversion, true
	case 32474:
		return OpcuaNodeIdServicesVariableAlternative_AlternativeUnitType_MathMLInverseConversion, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableAlternativeByName(value string) (enum OpcuaNodeIdServicesVariableAlternative, ok bool) {
	switch value {
	case "AlternativeUnitType_LinearConversion":
		return OpcuaNodeIdServicesVariableAlternative_AlternativeUnitType_LinearConversion, true
	case "AlternativeUnitType_MathMLConversion":
		return OpcuaNodeIdServicesVariableAlternative_AlternativeUnitType_MathMLConversion, true
	case "AlternativeUnitType_MathMLInverseConversion":
		return OpcuaNodeIdServicesVariableAlternative_AlternativeUnitType_MathMLInverseConversion, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableAlternativeKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableAlternativeValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableAlternative(structType any) OpcuaNodeIdServicesVariableAlternative {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableAlternative {
		if sOpcuaNodeIdServicesVariableAlternative, ok := typ.(OpcuaNodeIdServicesVariableAlternative); ok {
			return sOpcuaNodeIdServicesVariableAlternative
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableAlternative) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableAlternative) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableAlternativeParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableAlternative, error) {
	return OpcuaNodeIdServicesVariableAlternativeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableAlternativeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableAlternative, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableAlternative", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableAlternative")
	}
	if enum, ok := OpcuaNodeIdServicesVariableAlternativeByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableAlternative")
		return OpcuaNodeIdServicesVariableAlternative(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableAlternative) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableAlternative) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableAlternative", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableAlternative) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableAlternative_AlternativeUnitType_LinearConversion:
		return "AlternativeUnitType_LinearConversion"
	case OpcuaNodeIdServicesVariableAlternative_AlternativeUnitType_MathMLConversion:
		return "AlternativeUnitType_MathMLConversion"
	case OpcuaNodeIdServicesVariableAlternative_AlternativeUnitType_MathMLInverseConversion:
		return "AlternativeUnitType_MathMLInverseConversion"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableAlternative) String() string {
	return e.PLC4XEnumName()
}
