/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableAliases is an enum
type OpcuaNodeIdServicesVariableAliases int32

type IOpcuaNodeIdServicesVariableAliases interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableAliases_Aliases_FindAlias_InputArguments  OpcuaNodeIdServicesVariableAliases = 23477
	OpcuaNodeIdServicesVariableAliases_Aliases_FindAlias_OutputArguments OpcuaNodeIdServicesVariableAliases = 23478
	OpcuaNodeIdServicesVariableAliases_Aliases_LastChange                OpcuaNodeIdServicesVariableAliases = 32852
)

var OpcuaNodeIdServicesVariableAliasesValues []OpcuaNodeIdServicesVariableAliases

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableAliasesValues = []OpcuaNodeIdServicesVariableAliases{
		OpcuaNodeIdServicesVariableAliases_Aliases_FindAlias_InputArguments,
		OpcuaNodeIdServicesVariableAliases_Aliases_FindAlias_OutputArguments,
		OpcuaNodeIdServicesVariableAliases_Aliases_LastChange,
	}
}

func OpcuaNodeIdServicesVariableAliasesByValue(value int32) (enum OpcuaNodeIdServicesVariableAliases, ok bool) {
	switch value {
	case 23477:
		return OpcuaNodeIdServicesVariableAliases_Aliases_FindAlias_InputArguments, true
	case 23478:
		return OpcuaNodeIdServicesVariableAliases_Aliases_FindAlias_OutputArguments, true
	case 32852:
		return OpcuaNodeIdServicesVariableAliases_Aliases_LastChange, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableAliasesByName(value string) (enum OpcuaNodeIdServicesVariableAliases, ok bool) {
	switch value {
	case "Aliases_FindAlias_InputArguments":
		return OpcuaNodeIdServicesVariableAliases_Aliases_FindAlias_InputArguments, true
	case "Aliases_FindAlias_OutputArguments":
		return OpcuaNodeIdServicesVariableAliases_Aliases_FindAlias_OutputArguments, true
	case "Aliases_LastChange":
		return OpcuaNodeIdServicesVariableAliases_Aliases_LastChange, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableAliasesKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableAliasesValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableAliases(structType any) OpcuaNodeIdServicesVariableAliases {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableAliases {
		if sOpcuaNodeIdServicesVariableAliases, ok := typ.(OpcuaNodeIdServicesVariableAliases); ok {
			return sOpcuaNodeIdServicesVariableAliases
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableAliases) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableAliases) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableAliasesParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableAliases, error) {
	return OpcuaNodeIdServicesVariableAliasesParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableAliasesParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableAliases, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableAliases", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableAliases")
	}
	if enum, ok := OpcuaNodeIdServicesVariableAliasesByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableAliases")
		return OpcuaNodeIdServicesVariableAliases(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableAliases) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableAliases) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableAliases", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableAliases) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableAliases_Aliases_FindAlias_InputArguments:
		return "Aliases_FindAlias_InputArguments"
	case OpcuaNodeIdServicesVariableAliases_Aliases_FindAlias_OutputArguments:
		return "Aliases_FindAlias_OutputArguments"
	case OpcuaNodeIdServicesVariableAliases_Aliases_LastChange:
		return "Aliases_LastChange"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableAliases) String() string {
	return e.PLC4XEnumName()
}
