/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableAcknowledgeable is an enum
type OpcuaNodeIdServicesVariableAcknowledgeable int32

type IOpcuaNodeIdServicesVariableAcknowledgeable interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState                           OpcuaNodeIdServicesVariableAcknowledgeable = 9073
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_Id                        OpcuaNodeIdServicesVariableAcknowledgeable = 9074
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_Name                      OpcuaNodeIdServicesVariableAcknowledgeable = 9075
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_Number                    OpcuaNodeIdServicesVariableAcknowledgeable = 9076
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_EffectiveDisplayName      OpcuaNodeIdServicesVariableAcknowledgeable = 9077
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_TransitionTime            OpcuaNodeIdServicesVariableAcknowledgeable = 9078
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_EffectiveTransitionTime   OpcuaNodeIdServicesVariableAcknowledgeable = 9079
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_TrueState                 OpcuaNodeIdServicesVariableAcknowledgeable = 9080
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_FalseState                OpcuaNodeIdServicesVariableAcknowledgeable = 9081
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState                             OpcuaNodeIdServicesVariableAcknowledgeable = 9093
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_Id                          OpcuaNodeIdServicesVariableAcknowledgeable = 9094
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_Name                        OpcuaNodeIdServicesVariableAcknowledgeable = 9095
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_Number                      OpcuaNodeIdServicesVariableAcknowledgeable = 9096
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_EffectiveDisplayName        OpcuaNodeIdServicesVariableAcknowledgeable = 9097
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_TransitionTime              OpcuaNodeIdServicesVariableAcknowledgeable = 9098
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_EffectiveTransitionTime     OpcuaNodeIdServicesVariableAcknowledgeable = 9099
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_TrueState                   OpcuaNodeIdServicesVariableAcknowledgeable = 9100
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_FalseState                  OpcuaNodeIdServicesVariableAcknowledgeable = 9101
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState                         OpcuaNodeIdServicesVariableAcknowledgeable = 9102
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_Id                      OpcuaNodeIdServicesVariableAcknowledgeable = 9103
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_Name                    OpcuaNodeIdServicesVariableAcknowledgeable = 9104
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_Number                  OpcuaNodeIdServicesVariableAcknowledgeable = 9105
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_EffectiveDisplayName    OpcuaNodeIdServicesVariableAcknowledgeable = 9106
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_TransitionTime          OpcuaNodeIdServicesVariableAcknowledgeable = 9107
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_EffectiveTransitionTime OpcuaNodeIdServicesVariableAcknowledgeable = 9108
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_TrueState               OpcuaNodeIdServicesVariableAcknowledgeable = 9109
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_FalseState              OpcuaNodeIdServicesVariableAcknowledgeable = 9110
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Acknowledge_InputArguments             OpcuaNodeIdServicesVariableAcknowledgeable = 9112
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Confirm_InputArguments                 OpcuaNodeIdServicesVariableAcknowledgeable = 9114
)

var OpcuaNodeIdServicesVariableAcknowledgeableValues []OpcuaNodeIdServicesVariableAcknowledgeable

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableAcknowledgeableValues = []OpcuaNodeIdServicesVariableAcknowledgeable{
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_Id,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_Name,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_Number,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_Id,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_Name,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_Number,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_TrueState,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_FalseState,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Confirm_InputArguments,
	}
}

func OpcuaNodeIdServicesVariableAcknowledgeableByValue(value int32) (enum OpcuaNodeIdServicesVariableAcknowledgeable, ok bool) {
	switch value {
	case 9073:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState, true
	case 9074:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_Id, true
	case 9075:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_Name, true
	case 9076:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_Number, true
	case 9077:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_EffectiveDisplayName, true
	case 9078:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_TransitionTime, true
	case 9079:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_EffectiveTransitionTime, true
	case 9080:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_TrueState, true
	case 9081:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_FalseState, true
	case 9093:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState, true
	case 9094:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_Id, true
	case 9095:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_Name, true
	case 9096:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_Number, true
	case 9097:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_EffectiveDisplayName, true
	case 9098:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_TransitionTime, true
	case 9099:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_EffectiveTransitionTime, true
	case 9100:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_TrueState, true
	case 9101:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_FalseState, true
	case 9102:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState, true
	case 9103:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_Id, true
	case 9104:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_Name, true
	case 9105:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_Number, true
	case 9106:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_EffectiveDisplayName, true
	case 9107:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_TransitionTime, true
	case 9108:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_EffectiveTransitionTime, true
	case 9109:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_TrueState, true
	case 9110:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_FalseState, true
	case 9112:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Acknowledge_InputArguments, true
	case 9114:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Confirm_InputArguments, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableAcknowledgeableByName(value string) (enum OpcuaNodeIdServicesVariableAcknowledgeable, ok bool) {
	switch value {
	case "AcknowledgeableConditionType_EnabledState":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState, true
	case "AcknowledgeableConditionType_EnabledState_Id":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_Id, true
	case "AcknowledgeableConditionType_EnabledState_Name":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_Name, true
	case "AcknowledgeableConditionType_EnabledState_Number":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_Number, true
	case "AcknowledgeableConditionType_EnabledState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_EffectiveDisplayName, true
	case "AcknowledgeableConditionType_EnabledState_TransitionTime":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_TransitionTime, true
	case "AcknowledgeableConditionType_EnabledState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_EffectiveTransitionTime, true
	case "AcknowledgeableConditionType_EnabledState_TrueState":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_TrueState, true
	case "AcknowledgeableConditionType_EnabledState_FalseState":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_FalseState, true
	case "AcknowledgeableConditionType_AckedState":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState, true
	case "AcknowledgeableConditionType_AckedState_Id":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_Id, true
	case "AcknowledgeableConditionType_AckedState_Name":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_Name, true
	case "AcknowledgeableConditionType_AckedState_Number":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_Number, true
	case "AcknowledgeableConditionType_AckedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_EffectiveDisplayName, true
	case "AcknowledgeableConditionType_AckedState_TransitionTime":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_TransitionTime, true
	case "AcknowledgeableConditionType_AckedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_EffectiveTransitionTime, true
	case "AcknowledgeableConditionType_AckedState_TrueState":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_TrueState, true
	case "AcknowledgeableConditionType_AckedState_FalseState":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_FalseState, true
	case "AcknowledgeableConditionType_ConfirmedState":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState, true
	case "AcknowledgeableConditionType_ConfirmedState_Id":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_Id, true
	case "AcknowledgeableConditionType_ConfirmedState_Name":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_Name, true
	case "AcknowledgeableConditionType_ConfirmedState_Number":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_Number, true
	case "AcknowledgeableConditionType_ConfirmedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_EffectiveDisplayName, true
	case "AcknowledgeableConditionType_ConfirmedState_TransitionTime":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_TransitionTime, true
	case "AcknowledgeableConditionType_ConfirmedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_EffectiveTransitionTime, true
	case "AcknowledgeableConditionType_ConfirmedState_TrueState":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_TrueState, true
	case "AcknowledgeableConditionType_ConfirmedState_FalseState":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_FalseState, true
	case "AcknowledgeableConditionType_Acknowledge_InputArguments":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Acknowledge_InputArguments, true
	case "AcknowledgeableConditionType_Confirm_InputArguments":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Confirm_InputArguments, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableAcknowledgeableKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableAcknowledgeableValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableAcknowledgeable(structType any) OpcuaNodeIdServicesVariableAcknowledgeable {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableAcknowledgeable {
		if sOpcuaNodeIdServicesVariableAcknowledgeable, ok := typ.(OpcuaNodeIdServicesVariableAcknowledgeable); ok {
			return sOpcuaNodeIdServicesVariableAcknowledgeable
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableAcknowledgeable) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableAcknowledgeable) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableAcknowledgeableParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableAcknowledgeable, error) {
	return OpcuaNodeIdServicesVariableAcknowledgeableParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableAcknowledgeableParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableAcknowledgeable, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableAcknowledgeable", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableAcknowledgeable")
	}
	if enum, ok := OpcuaNodeIdServicesVariableAcknowledgeableByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableAcknowledgeable")
		return OpcuaNodeIdServicesVariableAcknowledgeable(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableAcknowledgeable) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableAcknowledgeable) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableAcknowledgeable", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableAcknowledgeable) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState:
		return "AcknowledgeableConditionType_EnabledState"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_Id:
		return "AcknowledgeableConditionType_EnabledState_Id"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_Name:
		return "AcknowledgeableConditionType_EnabledState_Name"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_Number:
		return "AcknowledgeableConditionType_EnabledState_Number"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_EffectiveDisplayName:
		return "AcknowledgeableConditionType_EnabledState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_TransitionTime:
		return "AcknowledgeableConditionType_EnabledState_TransitionTime"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_EffectiveTransitionTime:
		return "AcknowledgeableConditionType_EnabledState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_TrueState:
		return "AcknowledgeableConditionType_EnabledState_TrueState"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_FalseState:
		return "AcknowledgeableConditionType_EnabledState_FalseState"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState:
		return "AcknowledgeableConditionType_AckedState"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_Id:
		return "AcknowledgeableConditionType_AckedState_Id"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_Name:
		return "AcknowledgeableConditionType_AckedState_Name"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_Number:
		return "AcknowledgeableConditionType_AckedState_Number"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_EffectiveDisplayName:
		return "AcknowledgeableConditionType_AckedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_TransitionTime:
		return "AcknowledgeableConditionType_AckedState_TransitionTime"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_EffectiveTransitionTime:
		return "AcknowledgeableConditionType_AckedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_TrueState:
		return "AcknowledgeableConditionType_AckedState_TrueState"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_FalseState:
		return "AcknowledgeableConditionType_AckedState_FalseState"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState:
		return "AcknowledgeableConditionType_ConfirmedState"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_Id:
		return "AcknowledgeableConditionType_ConfirmedState_Id"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_Name:
		return "AcknowledgeableConditionType_ConfirmedState_Name"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_Number:
		return "AcknowledgeableConditionType_ConfirmedState_Number"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_EffectiveDisplayName:
		return "AcknowledgeableConditionType_ConfirmedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_TransitionTime:
		return "AcknowledgeableConditionType_ConfirmedState_TransitionTime"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_EffectiveTransitionTime:
		return "AcknowledgeableConditionType_ConfirmedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_TrueState:
		return "AcknowledgeableConditionType_ConfirmedState_TrueState"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_FalseState:
		return "AcknowledgeableConditionType_ConfirmedState_FalseState"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Acknowledge_InputArguments:
		return "AcknowledgeableConditionType_Acknowledge_InputArguments"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Confirm_InputArguments:
		return "AcknowledgeableConditionType_Confirm_InputArguments"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableAcknowledgeable) String() string {
	return e.PLC4XEnumName()
}
