/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesObjectType is an enum
type OpcuaNodeIdServicesObjectType int32

type IOpcuaNodeIdServicesObjectType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesObjectType_BaseObjectType                               OpcuaNodeIdServicesObjectType = 58
	OpcuaNodeIdServicesObjectType_FolderType                                   OpcuaNodeIdServicesObjectType = 61
	OpcuaNodeIdServicesObjectType_DataTypeSystemType                           OpcuaNodeIdServicesObjectType = 75
	OpcuaNodeIdServicesObjectType_DataTypeEncodingType                         OpcuaNodeIdServicesObjectType = 76
	OpcuaNodeIdServicesObjectType_ModellingRuleType                            OpcuaNodeIdServicesObjectType = 77
	OpcuaNodeIdServicesObjectType_ServerType                                   OpcuaNodeIdServicesObjectType = 2004
	OpcuaNodeIdServicesObjectType_ServerCapabilitiesType                       OpcuaNodeIdServicesObjectType = 2013
	OpcuaNodeIdServicesObjectType_ServerDiagnosticsType                        OpcuaNodeIdServicesObjectType = 2020
	OpcuaNodeIdServicesObjectType_SessionsDiagnosticsSummaryType               OpcuaNodeIdServicesObjectType = 2026
	OpcuaNodeIdServicesObjectType_SessionDiagnosticsObjectType                 OpcuaNodeIdServicesObjectType = 2029
	OpcuaNodeIdServicesObjectType_VendorServerInfoType                         OpcuaNodeIdServicesObjectType = 2033
	OpcuaNodeIdServicesObjectType_ServerRedundancyType                         OpcuaNodeIdServicesObjectType = 2034
	OpcuaNodeIdServicesObjectType_TransparentRedundancyType                    OpcuaNodeIdServicesObjectType = 2036
	OpcuaNodeIdServicesObjectType_NonTransparentRedundancyType                 OpcuaNodeIdServicesObjectType = 2039
	OpcuaNodeIdServicesObjectType_BaseEventType                                OpcuaNodeIdServicesObjectType = 2041
	OpcuaNodeIdServicesObjectType_AuditEventType                               OpcuaNodeIdServicesObjectType = 2052
	OpcuaNodeIdServicesObjectType_AuditSecurityEventType                       OpcuaNodeIdServicesObjectType = 2058
	OpcuaNodeIdServicesObjectType_AuditChannelEventType                        OpcuaNodeIdServicesObjectType = 2059
	OpcuaNodeIdServicesObjectType_AuditOpenSecureChannelEventType              OpcuaNodeIdServicesObjectType = 2060
	OpcuaNodeIdServicesObjectType_AuditSessionEventType                        OpcuaNodeIdServicesObjectType = 2069
	OpcuaNodeIdServicesObjectType_AuditCreateSessionEventType                  OpcuaNodeIdServicesObjectType = 2071
	OpcuaNodeIdServicesObjectType_AuditActivateSessionEventType                OpcuaNodeIdServicesObjectType = 2075
	OpcuaNodeIdServicesObjectType_AuditCancelEventType                         OpcuaNodeIdServicesObjectType = 2078
	OpcuaNodeIdServicesObjectType_AuditCertificateEventType                    OpcuaNodeIdServicesObjectType = 2080
	OpcuaNodeIdServicesObjectType_AuditCertificateDataMismatchEventType        OpcuaNodeIdServicesObjectType = 2082
	OpcuaNodeIdServicesObjectType_AuditCertificateExpiredEventType             OpcuaNodeIdServicesObjectType = 2085
	OpcuaNodeIdServicesObjectType_AuditCertificateInvalidEventType             OpcuaNodeIdServicesObjectType = 2086
	OpcuaNodeIdServicesObjectType_AuditCertificateUntrustedEventType           OpcuaNodeIdServicesObjectType = 2087
	OpcuaNodeIdServicesObjectType_AuditCertificateRevokedEventType             OpcuaNodeIdServicesObjectType = 2088
	OpcuaNodeIdServicesObjectType_AuditCertificateMismatchEventType            OpcuaNodeIdServicesObjectType = 2089
	OpcuaNodeIdServicesObjectType_AuditNodeManagementEventType                 OpcuaNodeIdServicesObjectType = 2090
	OpcuaNodeIdServicesObjectType_AuditAddNodesEventType                       OpcuaNodeIdServicesObjectType = 2091
	OpcuaNodeIdServicesObjectType_AuditDeleteNodesEventType                    OpcuaNodeIdServicesObjectType = 2093
	OpcuaNodeIdServicesObjectType_AuditAddReferencesEventType                  OpcuaNodeIdServicesObjectType = 2095
	OpcuaNodeIdServicesObjectType_AuditDeleteReferencesEventType               OpcuaNodeIdServicesObjectType = 2097
	OpcuaNodeIdServicesObjectType_AuditUpdateEventType                         OpcuaNodeIdServicesObjectType = 2099
	OpcuaNodeIdServicesObjectType_AuditWriteUpdateEventType                    OpcuaNodeIdServicesObjectType = 2100
	OpcuaNodeIdServicesObjectType_AuditHistoryUpdateEventType                  OpcuaNodeIdServicesObjectType = 2104
	OpcuaNodeIdServicesObjectType_AuditUpdateMethodEventType                   OpcuaNodeIdServicesObjectType = 2127
	OpcuaNodeIdServicesObjectType_SystemEventType                              OpcuaNodeIdServicesObjectType = 2130
	OpcuaNodeIdServicesObjectType_DeviceFailureEventType                       OpcuaNodeIdServicesObjectType = 2131
	OpcuaNodeIdServicesObjectType_BaseModelChangeEventType                     OpcuaNodeIdServicesObjectType = 2132
	OpcuaNodeIdServicesObjectType_GeneralModelChangeEventType                  OpcuaNodeIdServicesObjectType = 2133
	OpcuaNodeIdServicesObjectType_StateMachineType                             OpcuaNodeIdServicesObjectType = 2299
	OpcuaNodeIdServicesObjectType_StateType                                    OpcuaNodeIdServicesObjectType = 2307
	OpcuaNodeIdServicesObjectType_InitialStateType                             OpcuaNodeIdServicesObjectType = 2309
	OpcuaNodeIdServicesObjectType_TransitionType                               OpcuaNodeIdServicesObjectType = 2310
	OpcuaNodeIdServicesObjectType_TransitionEventType                          OpcuaNodeIdServicesObjectType = 2311
	OpcuaNodeIdServicesObjectType_AuditUpdateStateEventType                    OpcuaNodeIdServicesObjectType = 2315
	OpcuaNodeIdServicesObjectType_HistoricalDataConfigurationType              OpcuaNodeIdServicesObjectType = 2318
	OpcuaNodeIdServicesObjectType_HistoryServerCapabilitiesType                OpcuaNodeIdServicesObjectType = 2330
	OpcuaNodeIdServicesObjectType_AggregateFunctionType                        OpcuaNodeIdServicesObjectType = 2340
	OpcuaNodeIdServicesObjectType_ProgramTransitionEventType                   OpcuaNodeIdServicesObjectType = 2378
	OpcuaNodeIdServicesObjectType_ProgramStateMachineType                      OpcuaNodeIdServicesObjectType = 2391
	OpcuaNodeIdServicesObjectType_SemanticChangeEventType                      OpcuaNodeIdServicesObjectType = 2738
	OpcuaNodeIdServicesObjectType_AuditUrlMismatchEventType                    OpcuaNodeIdServicesObjectType = 2748
	OpcuaNodeIdServicesObjectType_FiniteStateMachineType                       OpcuaNodeIdServicesObjectType = 2771
	OpcuaNodeIdServicesObjectType_ConditionType                                OpcuaNodeIdServicesObjectType = 2782
	OpcuaNodeIdServicesObjectType_RefreshStartEventType                        OpcuaNodeIdServicesObjectType = 2787
	OpcuaNodeIdServicesObjectType_RefreshEndEventType                          OpcuaNodeIdServicesObjectType = 2788
	OpcuaNodeIdServicesObjectType_RefreshRequiredEventType                     OpcuaNodeIdServicesObjectType = 2789
	OpcuaNodeIdServicesObjectType_AuditConditionEventType                      OpcuaNodeIdServicesObjectType = 2790
	OpcuaNodeIdServicesObjectType_AuditConditionEnableEventType                OpcuaNodeIdServicesObjectType = 2803
	OpcuaNodeIdServicesObjectType_AuditConditionCommentEventType               OpcuaNodeIdServicesObjectType = 2829
	OpcuaNodeIdServicesObjectType_DialogConditionType                          OpcuaNodeIdServicesObjectType = 2830
	OpcuaNodeIdServicesObjectType_AcknowledgeableConditionType                 OpcuaNodeIdServicesObjectType = 2881
	OpcuaNodeIdServicesObjectType_AlarmConditionType                           OpcuaNodeIdServicesObjectType = 2915
	OpcuaNodeIdServicesObjectType_ShelvedStateMachineType                      OpcuaNodeIdServicesObjectType = 2929
	OpcuaNodeIdServicesObjectType_LimitAlarmType                               OpcuaNodeIdServicesObjectType = 2955
	OpcuaNodeIdServicesObjectType_AuditHistoryEventUpdateEventType             OpcuaNodeIdServicesObjectType = 2999
	OpcuaNodeIdServicesObjectType_AuditHistoryValueUpdateEventType             OpcuaNodeIdServicesObjectType = 3006
	OpcuaNodeIdServicesObjectType_AuditHistoryDeleteEventType                  OpcuaNodeIdServicesObjectType = 3012
	OpcuaNodeIdServicesObjectType_AuditHistoryRawModifyDeleteEventType         OpcuaNodeIdServicesObjectType = 3014
	OpcuaNodeIdServicesObjectType_AuditHistoryAtTimeDeleteEventType            OpcuaNodeIdServicesObjectType = 3019
	OpcuaNodeIdServicesObjectType_AuditHistoryEventDeleteEventType             OpcuaNodeIdServicesObjectType = 3022
	OpcuaNodeIdServicesObjectType_EventQueueOverflowEventType                  OpcuaNodeIdServicesObjectType = 3035
	OpcuaNodeIdServicesObjectType_ProgramTransitionAuditEventType              OpcuaNodeIdServicesObjectType = 3806
	OpcuaNodeIdServicesObjectType_AuditConditionRespondEventType               OpcuaNodeIdServicesObjectType = 8927
	OpcuaNodeIdServicesObjectType_AuditConditionAcknowledgeEventType           OpcuaNodeIdServicesObjectType = 8944
	OpcuaNodeIdServicesObjectType_AuditConditionConfirmEventType               OpcuaNodeIdServicesObjectType = 8961
	OpcuaNodeIdServicesObjectType_ExclusiveLimitStateMachineType               OpcuaNodeIdServicesObjectType = 9318
	OpcuaNodeIdServicesObjectType_ExclusiveLimitAlarmType                      OpcuaNodeIdServicesObjectType = 9341
	OpcuaNodeIdServicesObjectType_ExclusiveLevelAlarmType                      OpcuaNodeIdServicesObjectType = 9482
	OpcuaNodeIdServicesObjectType_ExclusiveRateOfChangeAlarmType               OpcuaNodeIdServicesObjectType = 9623
	OpcuaNodeIdServicesObjectType_ExclusiveDeviationAlarmType                  OpcuaNodeIdServicesObjectType = 9764
	OpcuaNodeIdServicesObjectType_NonExclusiveLimitAlarmType                   OpcuaNodeIdServicesObjectType = 9906
	OpcuaNodeIdServicesObjectType_NonExclusiveLevelAlarmType                   OpcuaNodeIdServicesObjectType = 10060
	OpcuaNodeIdServicesObjectType_NonExclusiveRateOfChangeAlarmType            OpcuaNodeIdServicesObjectType = 10214
	OpcuaNodeIdServicesObjectType_NonExclusiveDeviationAlarmType               OpcuaNodeIdServicesObjectType = 10368
	OpcuaNodeIdServicesObjectType_DiscreteAlarmType                            OpcuaNodeIdServicesObjectType = 10523
	OpcuaNodeIdServicesObjectType_OffNormalAlarmType                           OpcuaNodeIdServicesObjectType = 10637
	OpcuaNodeIdServicesObjectType_TripAlarmType                                OpcuaNodeIdServicesObjectType = 10751
	OpcuaNodeIdServicesObjectType_AuditConditionShelvingEventType              OpcuaNodeIdServicesObjectType = 11093
	OpcuaNodeIdServicesObjectType_BaseConditionClassType                       OpcuaNodeIdServicesObjectType = 11163
	OpcuaNodeIdServicesObjectType_ProcessConditionClassType                    OpcuaNodeIdServicesObjectType = 11164
	OpcuaNodeIdServicesObjectType_MaintenanceConditionClassType                OpcuaNodeIdServicesObjectType = 11165
	OpcuaNodeIdServicesObjectType_SystemConditionClassType                     OpcuaNodeIdServicesObjectType = 11166
	OpcuaNodeIdServicesObjectType_AggregateConfigurationType                   OpcuaNodeIdServicesObjectType = 11187
	OpcuaNodeIdServicesObjectType_ProgressEventType                            OpcuaNodeIdServicesObjectType = 11436
	OpcuaNodeIdServicesObjectType_SystemStatusChangeEventType                  OpcuaNodeIdServicesObjectType = 11446
	OpcuaNodeIdServicesObjectType_OperationLimitsType                          OpcuaNodeIdServicesObjectType = 11564
	OpcuaNodeIdServicesObjectType_FileType                                     OpcuaNodeIdServicesObjectType = 11575
	OpcuaNodeIdServicesObjectType_AddressSpaceFileType                         OpcuaNodeIdServicesObjectType = 11595
	OpcuaNodeIdServicesObjectType_NamespaceMetadataType                        OpcuaNodeIdServicesObjectType = 11616
	OpcuaNodeIdServicesObjectType_NamespacesType                               OpcuaNodeIdServicesObjectType = 11645
	OpcuaNodeIdServicesObjectType_SystemOffNormalAlarmType                     OpcuaNodeIdServicesObjectType = 11753
	OpcuaNodeIdServicesObjectType_AuditProgramTransitionEventType              OpcuaNodeIdServicesObjectType = 11856
	OpcuaNodeIdServicesObjectType_NonTransparentNetworkRedundancyType          OpcuaNodeIdServicesObjectType = 11945
	OpcuaNodeIdServicesObjectType_TrustListType                                OpcuaNodeIdServicesObjectType = 12522
	OpcuaNodeIdServicesObjectType_CertificateGroupType                         OpcuaNodeIdServicesObjectType = 12555
	OpcuaNodeIdServicesObjectType_CertificateType                              OpcuaNodeIdServicesObjectType = 12556
	OpcuaNodeIdServicesObjectType_ApplicationCertificateType                   OpcuaNodeIdServicesObjectType = 12557
	OpcuaNodeIdServicesObjectType_HttpsCertificateType                         OpcuaNodeIdServicesObjectType = 12558
	OpcuaNodeIdServicesObjectType_RsaMinApplicationCertificateType             OpcuaNodeIdServicesObjectType = 12559
	OpcuaNodeIdServicesObjectType_RsaSha256ApplicationCertificateType          OpcuaNodeIdServicesObjectType = 12560
	OpcuaNodeIdServicesObjectType_TrustListUpdatedAuditEventType               OpcuaNodeIdServicesObjectType = 12561
	OpcuaNodeIdServicesObjectType_ServerConfigurationType                      OpcuaNodeIdServicesObjectType = 12581
	OpcuaNodeIdServicesObjectType_CertificateUpdatedAuditEventType             OpcuaNodeIdServicesObjectType = 12620
	OpcuaNodeIdServicesObjectType_CertificateExpirationAlarmType               OpcuaNodeIdServicesObjectType = 13225
	OpcuaNodeIdServicesObjectType_FileDirectoryType                            OpcuaNodeIdServicesObjectType = 13353
	OpcuaNodeIdServicesObjectType_CertificateGroupFolderType                   OpcuaNodeIdServicesObjectType = 13813
	OpcuaNodeIdServicesObjectType_PubSubConnectionType                         OpcuaNodeIdServicesObjectType = 14209
	OpcuaNodeIdServicesObjectType_PubSubGroupType                              OpcuaNodeIdServicesObjectType = 14232
	OpcuaNodeIdServicesObjectType_PublishSubscribeType                         OpcuaNodeIdServicesObjectType = 14416
	OpcuaNodeIdServicesObjectType_DataSetFolderType                            OpcuaNodeIdServicesObjectType = 14477
	OpcuaNodeIdServicesObjectType_PublishedDataSetType                         OpcuaNodeIdServicesObjectType = 14509
	OpcuaNodeIdServicesObjectType_PublishedDataItemsType                       OpcuaNodeIdServicesObjectType = 14534
	OpcuaNodeIdServicesObjectType_PublishedEventsType                          OpcuaNodeIdServicesObjectType = 14572
	OpcuaNodeIdServicesObjectType_PubSubStatusType                             OpcuaNodeIdServicesObjectType = 14643
	OpcuaNodeIdServicesObjectType_AuditConditionResetEventType                 OpcuaNodeIdServicesObjectType = 15013
	OpcuaNodeIdServicesObjectType_DatagramConnectionTransportType              OpcuaNodeIdServicesObjectType = 15064
	OpcuaNodeIdServicesObjectType_SubscribedDataSetType                        OpcuaNodeIdServicesObjectType = 15108
	OpcuaNodeIdServicesObjectType_ChoiceStateType                              OpcuaNodeIdServicesObjectType = 15109
	OpcuaNodeIdServicesObjectType_TargetVariablesType                          OpcuaNodeIdServicesObjectType = 15111
	OpcuaNodeIdServicesObjectType_SubscribedDataSetMirrorType                  OpcuaNodeIdServicesObjectType = 15127
	OpcuaNodeIdServicesObjectType_BrokerConnectionTransportType                OpcuaNodeIdServicesObjectType = 15155
	OpcuaNodeIdServicesObjectType_UserCredentialCertificateType                OpcuaNodeIdServicesObjectType = 15181
	OpcuaNodeIdServicesObjectType_DataSetWriterType                            OpcuaNodeIdServicesObjectType = 15298
	OpcuaNodeIdServicesObjectType_DataSetWriterTransportType                   OpcuaNodeIdServicesObjectType = 15305
	OpcuaNodeIdServicesObjectType_DataSetReaderType                            OpcuaNodeIdServicesObjectType = 15306
	OpcuaNodeIdServicesObjectType_DataSetReaderTransportType                   OpcuaNodeIdServicesObjectType = 15319
	OpcuaNodeIdServicesObjectType_SecurityGroupFolderType                      OpcuaNodeIdServicesObjectType = 15452
	OpcuaNodeIdServicesObjectType_SecurityGroupType                            OpcuaNodeIdServicesObjectType = 15471
	OpcuaNodeIdServicesObjectType_ExtensionFieldsType                          OpcuaNodeIdServicesObjectType = 15489
	OpcuaNodeIdServicesObjectType_PubSubStatusEventType                        OpcuaNodeIdServicesObjectType = 15535
	OpcuaNodeIdServicesObjectType_PubSubTransportLimitsExceedEventType         OpcuaNodeIdServicesObjectType = 15548
	OpcuaNodeIdServicesObjectType_PubSubCommunicationFailureEventType          OpcuaNodeIdServicesObjectType = 15563
	OpcuaNodeIdServicesObjectType_RoleSetType                                  OpcuaNodeIdServicesObjectType = 15607
	OpcuaNodeIdServicesObjectType_RoleType                                     OpcuaNodeIdServicesObjectType = 15620
	OpcuaNodeIdServicesObjectType_TemporaryFileTransferType                    OpcuaNodeIdServicesObjectType = 15744
	OpcuaNodeIdServicesObjectType_FileTransferStateMachineType                 OpcuaNodeIdServicesObjectType = 15803
	OpcuaNodeIdServicesObjectType_PubSubKeyServiceType                         OpcuaNodeIdServicesObjectType = 15906
	OpcuaNodeIdServicesObjectType_AlarmGroupType                               OpcuaNodeIdServicesObjectType = 16405
	OpcuaNodeIdServicesObjectType_DiscrepancyAlarmType                         OpcuaNodeIdServicesObjectType = 17080
	OpcuaNodeIdServicesObjectType_SafetyConditionClassType                     OpcuaNodeIdServicesObjectType = 17218
	OpcuaNodeIdServicesObjectType_HighlyManagedAlarmConditionClassType         OpcuaNodeIdServicesObjectType = 17219
	OpcuaNodeIdServicesObjectType_TrainingConditionClassType                   OpcuaNodeIdServicesObjectType = 17220
	OpcuaNodeIdServicesObjectType_TestingConditionClassType                    OpcuaNodeIdServicesObjectType = 17221
	OpcuaNodeIdServicesObjectType_AuditConditionSuppressionEventType           OpcuaNodeIdServicesObjectType = 17225
	OpcuaNodeIdServicesObjectType_AuditConditionSilenceEventType               OpcuaNodeIdServicesObjectType = 17242
	OpcuaNodeIdServicesObjectType_AuditConditionOutOfServiceEventType          OpcuaNodeIdServicesObjectType = 17259
	OpcuaNodeIdServicesObjectType_AlarmMetricsType                             OpcuaNodeIdServicesObjectType = 17279
	OpcuaNodeIdServicesObjectType_KeyCredentialConfigurationFolderType         OpcuaNodeIdServicesObjectType = 17496
	OpcuaNodeIdServicesObjectType_DictionaryEntryType                          OpcuaNodeIdServicesObjectType = 17589
	OpcuaNodeIdServicesObjectType_DictionaryFolderType                         OpcuaNodeIdServicesObjectType = 17591
	OpcuaNodeIdServicesObjectType_IrdiDictionaryEntryType                      OpcuaNodeIdServicesObjectType = 17598
	OpcuaNodeIdServicesObjectType_UriDictionaryEntryType                       OpcuaNodeIdServicesObjectType = 17600
	OpcuaNodeIdServicesObjectType_BaseInterfaceType                            OpcuaNodeIdServicesObjectType = 17602
	OpcuaNodeIdServicesObjectType_RoleMappingRuleChangedAuditEventType         OpcuaNodeIdServicesObjectType = 17641
	OpcuaNodeIdServicesObjectType_ConnectionTransportType                      OpcuaNodeIdServicesObjectType = 17721
	OpcuaNodeIdServicesObjectType_WriterGroupType                              OpcuaNodeIdServicesObjectType = 17725
	OpcuaNodeIdServicesObjectType_AuthorizationServiceConfigurationType        OpcuaNodeIdServicesObjectType = 17852
	OpcuaNodeIdServicesObjectType_WriterGroupTransportType                     OpcuaNodeIdServicesObjectType = 17997
	OpcuaNodeIdServicesObjectType_WriterGroupMessageType                       OpcuaNodeIdServicesObjectType = 17998
	OpcuaNodeIdServicesObjectType_ReaderGroupType                              OpcuaNodeIdServicesObjectType = 17999
	OpcuaNodeIdServicesObjectType_KeyCredentialConfigurationType               OpcuaNodeIdServicesObjectType = 18001
	OpcuaNodeIdServicesObjectType_KeyCredentialAuditEventType                  OpcuaNodeIdServicesObjectType = 18011
	OpcuaNodeIdServicesObjectType_KeyCredentialUpdatedAuditEventType           OpcuaNodeIdServicesObjectType = 18029
	OpcuaNodeIdServicesObjectType_KeyCredentialDeletedAuditEventType           OpcuaNodeIdServicesObjectType = 18047
	OpcuaNodeIdServicesObjectType_InstrumentDiagnosticAlarmType                OpcuaNodeIdServicesObjectType = 18347
	OpcuaNodeIdServicesObjectType_SystemDiagnosticAlarmType                    OpcuaNodeIdServicesObjectType = 18496
	OpcuaNodeIdServicesObjectType_StatisticalConditionClassType                OpcuaNodeIdServicesObjectType = 18665
	OpcuaNodeIdServicesObjectType_AuditHistoryAnnotationUpdateEventType        OpcuaNodeIdServicesObjectType = 19095
	OpcuaNodeIdServicesObjectType_TrustListOutOfDateAlarmType                  OpcuaNodeIdServicesObjectType = 19297
	OpcuaNodeIdServicesObjectType_PubSubDiagnosticsType                        OpcuaNodeIdServicesObjectType = 19677
	OpcuaNodeIdServicesObjectType_PubSubDiagnosticsRootType                    OpcuaNodeIdServicesObjectType = 19732
	OpcuaNodeIdServicesObjectType_PubSubDiagnosticsConnectionType              OpcuaNodeIdServicesObjectType = 19786
	OpcuaNodeIdServicesObjectType_PubSubDiagnosticsWriterGroupType             OpcuaNodeIdServicesObjectType = 19834
	OpcuaNodeIdServicesObjectType_PubSubDiagnosticsReaderGroupType             OpcuaNodeIdServicesObjectType = 19903
	OpcuaNodeIdServicesObjectType_PubSubDiagnosticsDataSetWriterType           OpcuaNodeIdServicesObjectType = 19968
	OpcuaNodeIdServicesObjectType_PubSubDiagnosticsDataSetReaderType           OpcuaNodeIdServicesObjectType = 20027
	OpcuaNodeIdServicesObjectType_ReaderGroupTransportType                     OpcuaNodeIdServicesObjectType = 21090
	OpcuaNodeIdServicesObjectType_ReaderGroupMessageType                       OpcuaNodeIdServicesObjectType = 21091
	OpcuaNodeIdServicesObjectType_DataSetWriterMessageType                     OpcuaNodeIdServicesObjectType = 21096
	OpcuaNodeIdServicesObjectType_DataSetReaderMessageType                     OpcuaNodeIdServicesObjectType = 21104
	OpcuaNodeIdServicesObjectType_UadpWriterGroupMessageType                   OpcuaNodeIdServicesObjectType = 21105
	OpcuaNodeIdServicesObjectType_UadpDataSetWriterMessageType                 OpcuaNodeIdServicesObjectType = 21111
	OpcuaNodeIdServicesObjectType_UadpDataSetReaderMessageType                 OpcuaNodeIdServicesObjectType = 21116
	OpcuaNodeIdServicesObjectType_JsonWriterGroupMessageType                   OpcuaNodeIdServicesObjectType = 21126
	OpcuaNodeIdServicesObjectType_JsonDataSetWriterMessageType                 OpcuaNodeIdServicesObjectType = 21128
	OpcuaNodeIdServicesObjectType_JsonDataSetReaderMessageType                 OpcuaNodeIdServicesObjectType = 21130
	OpcuaNodeIdServicesObjectType_DatagramWriterGroupTransportType             OpcuaNodeIdServicesObjectType = 21133
	OpcuaNodeIdServicesObjectType_BrokerWriterGroupTransportType               OpcuaNodeIdServicesObjectType = 21136
	OpcuaNodeIdServicesObjectType_BrokerDataSetWriterTransportType             OpcuaNodeIdServicesObjectType = 21138
	OpcuaNodeIdServicesObjectType_BrokerDataSetReaderTransportType             OpcuaNodeIdServicesObjectType = 21142
	OpcuaNodeIdServicesObjectType_NetworkAddressType                           OpcuaNodeIdServicesObjectType = 21145
	OpcuaNodeIdServicesObjectType_NetworkAddressUrlType                        OpcuaNodeIdServicesObjectType = 21147
	OpcuaNodeIdServicesObjectType_AliasNameType                                OpcuaNodeIdServicesObjectType = 23455
	OpcuaNodeIdServicesObjectType_AliasNameCategoryType                        OpcuaNodeIdServicesObjectType = 23456
	OpcuaNodeIdServicesObjectType_IOrderedObjectType                           OpcuaNodeIdServicesObjectType = 23513
	OpcuaNodeIdServicesObjectType_OrderedListType                              OpcuaNodeIdServicesObjectType = 23518
	OpcuaNodeIdServicesObjectType_EccApplicationCertificateType                OpcuaNodeIdServicesObjectType = 23537
	OpcuaNodeIdServicesObjectType_EccNistP256ApplicationCertificateType        OpcuaNodeIdServicesObjectType = 23538
	OpcuaNodeIdServicesObjectType_EccNistP384ApplicationCertificateType        OpcuaNodeIdServicesObjectType = 23539
	OpcuaNodeIdServicesObjectType_EccBrainpoolP256r1ApplicationCertificateType OpcuaNodeIdServicesObjectType = 23540
	OpcuaNodeIdServicesObjectType_EccBrainpoolP384r1ApplicationCertificateType OpcuaNodeIdServicesObjectType = 23541
	OpcuaNodeIdServicesObjectType_EccCurve25519ApplicationCertificateType      OpcuaNodeIdServicesObjectType = 23542
	OpcuaNodeIdServicesObjectType_EccCurve448ApplicationCertificateType        OpcuaNodeIdServicesObjectType = 23543
	OpcuaNodeIdServicesObjectType_AuthorizationServicesConfigurationFolderType OpcuaNodeIdServicesObjectType = 23556
	OpcuaNodeIdServicesObjectType_AuditClientEventType                         OpcuaNodeIdServicesObjectType = 23606
	OpcuaNodeIdServicesObjectType_SubscribedDataSetFolderType                  OpcuaNodeIdServicesObjectType = 23795
	OpcuaNodeIdServicesObjectType_StandaloneSubscribedDataSetType              OpcuaNodeIdServicesObjectType = 23828
	OpcuaNodeIdServicesObjectType_PubSubCapabilitiesType                       OpcuaNodeIdServicesObjectType = 23832
	OpcuaNodeIdServicesObjectType_AuditClientUpdateMethodResultEventType       OpcuaNodeIdServicesObjectType = 23926
	OpcuaNodeIdServicesObjectType_DatagramDataSetReaderTransportType           OpcuaNodeIdServicesObjectType = 24016
	OpcuaNodeIdServicesObjectType_IIetfBaseNetworkInterfaceType                OpcuaNodeIdServicesObjectType = 24148
	OpcuaNodeIdServicesObjectType_IIeeeBaseEthernetPortType                    OpcuaNodeIdServicesObjectType = 24158
	OpcuaNodeIdServicesObjectType_IBaseEthernetCapabilitiesType                OpcuaNodeIdServicesObjectType = 24167
	OpcuaNodeIdServicesObjectType_ISrClassType                                 OpcuaNodeIdServicesObjectType = 24169
	OpcuaNodeIdServicesObjectType_IIeeeBaseTsnStreamType                       OpcuaNodeIdServicesObjectType = 24173
	OpcuaNodeIdServicesObjectType_IIeeeBaseTsnTrafficSpecificationType         OpcuaNodeIdServicesObjectType = 24179
	OpcuaNodeIdServicesObjectType_IIeeeBaseTsnStatusStreamType                 OpcuaNodeIdServicesObjectType = 24183
	OpcuaNodeIdServicesObjectType_IIeeeTsnInterfaceConfigurationType           OpcuaNodeIdServicesObjectType = 24188
	OpcuaNodeIdServicesObjectType_IIeeeTsnInterfaceConfigurationTalkerType     OpcuaNodeIdServicesObjectType = 24191
	OpcuaNodeIdServicesObjectType_IIeeeTsnInterfaceConfigurationListenerType   OpcuaNodeIdServicesObjectType = 24195
	OpcuaNodeIdServicesObjectType_IIeeeTsnMacAddressType                       OpcuaNodeIdServicesObjectType = 24199
	OpcuaNodeIdServicesObjectType_IIeeeTsnVlanTagType                          OpcuaNodeIdServicesObjectType = 24202
	OpcuaNodeIdServicesObjectType_IPriorityMappingEntryType                    OpcuaNodeIdServicesObjectType = 24205
	OpcuaNodeIdServicesObjectType_IIeeeAutoNegotiationStatusType               OpcuaNodeIdServicesObjectType = 24233
	OpcuaNodeIdServicesObjectType_UserManagementType                           OpcuaNodeIdServicesObjectType = 24264
	OpcuaNodeIdServicesObjectType_IVlanIdType                                  OpcuaNodeIdServicesObjectType = 25218
	OpcuaNodeIdServicesObjectType_IetfBaseNetworkInterfaceType                 OpcuaNodeIdServicesObjectType = 25221
	OpcuaNodeIdServicesObjectType_PriorityMappingTableType                     OpcuaNodeIdServicesObjectType = 25227
	OpcuaNodeIdServicesObjectType_PubSubKeyPushTargetType                      OpcuaNodeIdServicesObjectType = 25337
	OpcuaNodeIdServicesObjectType_PubSubKeyPushTargetFolderType                OpcuaNodeIdServicesObjectType = 25346
	OpcuaNodeIdServicesObjectType_PubSubConfigurationType                      OpcuaNodeIdServicesObjectType = 25482
	OpcuaNodeIdServicesObjectType_ApplicationConfigurationType                 OpcuaNodeIdServicesObjectType = 25731
	OpcuaNodeIdServicesObjectType_ProvisionableDeviceType                      OpcuaNodeIdServicesObjectType = 26871
	OpcuaNodeIdServicesObjectType_AlarmSuppressionGroupType                    OpcuaNodeIdServicesObjectType = 32064
	OpcuaNodeIdServicesObjectType_TrustListUpdateRequestedAuditEventType       OpcuaNodeIdServicesObjectType = 32260
	OpcuaNodeIdServicesObjectType_TransactionDiagnosticsType                   OpcuaNodeIdServicesObjectType = 32286
	OpcuaNodeIdServicesObjectType_CertificateUpdateRequestedAuditEventType     OpcuaNodeIdServicesObjectType = 32306
	OpcuaNodeIdServicesObjectType_NonTransparentBackupRedundancyType           OpcuaNodeIdServicesObjectType = 32411
	OpcuaNodeIdServicesObjectType_SyntaxReferenceEntryType                     OpcuaNodeIdServicesObjectType = 32439
	OpcuaNodeIdServicesObjectType_UnitType                                     OpcuaNodeIdServicesObjectType = 32442
	OpcuaNodeIdServicesObjectType_ServerUnitType                               OpcuaNodeIdServicesObjectType = 32447
	OpcuaNodeIdServicesObjectType_AlternativeUnitType                          OpcuaNodeIdServicesObjectType = 32467
	OpcuaNodeIdServicesObjectType_QuantityType                                 OpcuaNodeIdServicesObjectType = 32475
	OpcuaNodeIdServicesObjectType_QuantitiesFolderType                         OpcuaNodeIdServicesObjectType = 32502
	OpcuaNodeIdServicesObjectType_HistoricalEventConfigurationType             OpcuaNodeIdServicesObjectType = 32621
	OpcuaNodeIdServicesObjectType_HistoricalExternalEventSourceType            OpcuaNodeIdServicesObjectType = 32625
	OpcuaNodeIdServicesObjectType_AuditHistoryConfigurationChangeEventType     OpcuaNodeIdServicesObjectType = 32758
	OpcuaNodeIdServicesObjectType_AuditHistoryBulkInsertEventType              OpcuaNodeIdServicesObjectType = 32803
)

var OpcuaNodeIdServicesObjectTypeValues []OpcuaNodeIdServicesObjectType

func init() {
	_ = errors.New
	OpcuaNodeIdServicesObjectTypeValues = []OpcuaNodeIdServicesObjectType{
		OpcuaNodeIdServicesObjectType_BaseObjectType,
		OpcuaNodeIdServicesObjectType_FolderType,
		OpcuaNodeIdServicesObjectType_DataTypeSystemType,
		OpcuaNodeIdServicesObjectType_DataTypeEncodingType,
		OpcuaNodeIdServicesObjectType_ModellingRuleType,
		OpcuaNodeIdServicesObjectType_ServerType,
		OpcuaNodeIdServicesObjectType_ServerCapabilitiesType,
		OpcuaNodeIdServicesObjectType_ServerDiagnosticsType,
		OpcuaNodeIdServicesObjectType_SessionsDiagnosticsSummaryType,
		OpcuaNodeIdServicesObjectType_SessionDiagnosticsObjectType,
		OpcuaNodeIdServicesObjectType_VendorServerInfoType,
		OpcuaNodeIdServicesObjectType_ServerRedundancyType,
		OpcuaNodeIdServicesObjectType_TransparentRedundancyType,
		OpcuaNodeIdServicesObjectType_NonTransparentRedundancyType,
		OpcuaNodeIdServicesObjectType_BaseEventType,
		OpcuaNodeIdServicesObjectType_AuditEventType,
		OpcuaNodeIdServicesObjectType_AuditSecurityEventType,
		OpcuaNodeIdServicesObjectType_AuditChannelEventType,
		OpcuaNodeIdServicesObjectType_AuditOpenSecureChannelEventType,
		OpcuaNodeIdServicesObjectType_AuditSessionEventType,
		OpcuaNodeIdServicesObjectType_AuditCreateSessionEventType,
		OpcuaNodeIdServicesObjectType_AuditActivateSessionEventType,
		OpcuaNodeIdServicesObjectType_AuditCancelEventType,
		OpcuaNodeIdServicesObjectType_AuditCertificateEventType,
		OpcuaNodeIdServicesObjectType_AuditCertificateDataMismatchEventType,
		OpcuaNodeIdServicesObjectType_AuditCertificateExpiredEventType,
		OpcuaNodeIdServicesObjectType_AuditCertificateInvalidEventType,
		OpcuaNodeIdServicesObjectType_AuditCertificateUntrustedEventType,
		OpcuaNodeIdServicesObjectType_AuditCertificateRevokedEventType,
		OpcuaNodeIdServicesObjectType_AuditCertificateMismatchEventType,
		OpcuaNodeIdServicesObjectType_AuditNodeManagementEventType,
		OpcuaNodeIdServicesObjectType_AuditAddNodesEventType,
		OpcuaNodeIdServicesObjectType_AuditDeleteNodesEventType,
		OpcuaNodeIdServicesObjectType_AuditAddReferencesEventType,
		OpcuaNodeIdServicesObjectType_AuditDeleteReferencesEventType,
		OpcuaNodeIdServicesObjectType_AuditUpdateEventType,
		OpcuaNodeIdServicesObjectType_AuditWriteUpdateEventType,
		OpcuaNodeIdServicesObjectType_AuditHistoryUpdateEventType,
		OpcuaNodeIdServicesObjectType_AuditUpdateMethodEventType,
		OpcuaNodeIdServicesObjectType_SystemEventType,
		OpcuaNodeIdServicesObjectType_DeviceFailureEventType,
		OpcuaNodeIdServicesObjectType_BaseModelChangeEventType,
		OpcuaNodeIdServicesObjectType_GeneralModelChangeEventType,
		OpcuaNodeIdServicesObjectType_StateMachineType,
		OpcuaNodeIdServicesObjectType_StateType,
		OpcuaNodeIdServicesObjectType_InitialStateType,
		OpcuaNodeIdServicesObjectType_TransitionType,
		OpcuaNodeIdServicesObjectType_TransitionEventType,
		OpcuaNodeIdServicesObjectType_AuditUpdateStateEventType,
		OpcuaNodeIdServicesObjectType_HistoricalDataConfigurationType,
		OpcuaNodeIdServicesObjectType_HistoryServerCapabilitiesType,
		OpcuaNodeIdServicesObjectType_AggregateFunctionType,
		OpcuaNodeIdServicesObjectType_ProgramTransitionEventType,
		OpcuaNodeIdServicesObjectType_ProgramStateMachineType,
		OpcuaNodeIdServicesObjectType_SemanticChangeEventType,
		OpcuaNodeIdServicesObjectType_AuditUrlMismatchEventType,
		OpcuaNodeIdServicesObjectType_FiniteStateMachineType,
		OpcuaNodeIdServicesObjectType_ConditionType,
		OpcuaNodeIdServicesObjectType_RefreshStartEventType,
		OpcuaNodeIdServicesObjectType_RefreshEndEventType,
		OpcuaNodeIdServicesObjectType_RefreshRequiredEventType,
		OpcuaNodeIdServicesObjectType_AuditConditionEventType,
		OpcuaNodeIdServicesObjectType_AuditConditionEnableEventType,
		OpcuaNodeIdServicesObjectType_AuditConditionCommentEventType,
		OpcuaNodeIdServicesObjectType_DialogConditionType,
		OpcuaNodeIdServicesObjectType_AcknowledgeableConditionType,
		OpcuaNodeIdServicesObjectType_AlarmConditionType,
		OpcuaNodeIdServicesObjectType_ShelvedStateMachineType,
		OpcuaNodeIdServicesObjectType_LimitAlarmType,
		OpcuaNodeIdServicesObjectType_AuditHistoryEventUpdateEventType,
		OpcuaNodeIdServicesObjectType_AuditHistoryValueUpdateEventType,
		OpcuaNodeIdServicesObjectType_AuditHistoryDeleteEventType,
		OpcuaNodeIdServicesObjectType_AuditHistoryRawModifyDeleteEventType,
		OpcuaNodeIdServicesObjectType_AuditHistoryAtTimeDeleteEventType,
		OpcuaNodeIdServicesObjectType_AuditHistoryEventDeleteEventType,
		OpcuaNodeIdServicesObjectType_EventQueueOverflowEventType,
		OpcuaNodeIdServicesObjectType_ProgramTransitionAuditEventType,
		OpcuaNodeIdServicesObjectType_AuditConditionRespondEventType,
		OpcuaNodeIdServicesObjectType_AuditConditionAcknowledgeEventType,
		OpcuaNodeIdServicesObjectType_AuditConditionConfirmEventType,
		OpcuaNodeIdServicesObjectType_ExclusiveLimitStateMachineType,
		OpcuaNodeIdServicesObjectType_ExclusiveLimitAlarmType,
		OpcuaNodeIdServicesObjectType_ExclusiveLevelAlarmType,
		OpcuaNodeIdServicesObjectType_ExclusiveRateOfChangeAlarmType,
		OpcuaNodeIdServicesObjectType_ExclusiveDeviationAlarmType,
		OpcuaNodeIdServicesObjectType_NonExclusiveLimitAlarmType,
		OpcuaNodeIdServicesObjectType_NonExclusiveLevelAlarmType,
		OpcuaNodeIdServicesObjectType_NonExclusiveRateOfChangeAlarmType,
		OpcuaNodeIdServicesObjectType_NonExclusiveDeviationAlarmType,
		OpcuaNodeIdServicesObjectType_DiscreteAlarmType,
		OpcuaNodeIdServicesObjectType_OffNormalAlarmType,
		OpcuaNodeIdServicesObjectType_TripAlarmType,
		OpcuaNodeIdServicesObjectType_AuditConditionShelvingEventType,
		OpcuaNodeIdServicesObjectType_BaseConditionClassType,
		OpcuaNodeIdServicesObjectType_ProcessConditionClassType,
		OpcuaNodeIdServicesObjectType_MaintenanceConditionClassType,
		OpcuaNodeIdServicesObjectType_SystemConditionClassType,
		OpcuaNodeIdServicesObjectType_AggregateConfigurationType,
		OpcuaNodeIdServicesObjectType_ProgressEventType,
		OpcuaNodeIdServicesObjectType_SystemStatusChangeEventType,
		OpcuaNodeIdServicesObjectType_OperationLimitsType,
		OpcuaNodeIdServicesObjectType_FileType,
		OpcuaNodeIdServicesObjectType_AddressSpaceFileType,
		OpcuaNodeIdServicesObjectType_NamespaceMetadataType,
		OpcuaNodeIdServicesObjectType_NamespacesType,
		OpcuaNodeIdServicesObjectType_SystemOffNormalAlarmType,
		OpcuaNodeIdServicesObjectType_AuditProgramTransitionEventType,
		OpcuaNodeIdServicesObjectType_NonTransparentNetworkRedundancyType,
		OpcuaNodeIdServicesObjectType_TrustListType,
		OpcuaNodeIdServicesObjectType_CertificateGroupType,
		OpcuaNodeIdServicesObjectType_CertificateType,
		OpcuaNodeIdServicesObjectType_ApplicationCertificateType,
		OpcuaNodeIdServicesObjectType_HttpsCertificateType,
		OpcuaNodeIdServicesObjectType_RsaMinApplicationCertificateType,
		OpcuaNodeIdServicesObjectType_RsaSha256ApplicationCertificateType,
		OpcuaNodeIdServicesObjectType_TrustListUpdatedAuditEventType,
		OpcuaNodeIdServicesObjectType_ServerConfigurationType,
		OpcuaNodeIdServicesObjectType_CertificateUpdatedAuditEventType,
		OpcuaNodeIdServicesObjectType_CertificateExpirationAlarmType,
		OpcuaNodeIdServicesObjectType_FileDirectoryType,
		OpcuaNodeIdServicesObjectType_CertificateGroupFolderType,
		OpcuaNodeIdServicesObjectType_PubSubConnectionType,
		OpcuaNodeIdServicesObjectType_PubSubGroupType,
		OpcuaNodeIdServicesObjectType_PublishSubscribeType,
		OpcuaNodeIdServicesObjectType_DataSetFolderType,
		OpcuaNodeIdServicesObjectType_PublishedDataSetType,
		OpcuaNodeIdServicesObjectType_PublishedDataItemsType,
		OpcuaNodeIdServicesObjectType_PublishedEventsType,
		OpcuaNodeIdServicesObjectType_PubSubStatusType,
		OpcuaNodeIdServicesObjectType_AuditConditionResetEventType,
		OpcuaNodeIdServicesObjectType_DatagramConnectionTransportType,
		OpcuaNodeIdServicesObjectType_SubscribedDataSetType,
		OpcuaNodeIdServicesObjectType_ChoiceStateType,
		OpcuaNodeIdServicesObjectType_TargetVariablesType,
		OpcuaNodeIdServicesObjectType_SubscribedDataSetMirrorType,
		OpcuaNodeIdServicesObjectType_BrokerConnectionTransportType,
		OpcuaNodeIdServicesObjectType_UserCredentialCertificateType,
		OpcuaNodeIdServicesObjectType_DataSetWriterType,
		OpcuaNodeIdServicesObjectType_DataSetWriterTransportType,
		OpcuaNodeIdServicesObjectType_DataSetReaderType,
		OpcuaNodeIdServicesObjectType_DataSetReaderTransportType,
		OpcuaNodeIdServicesObjectType_SecurityGroupFolderType,
		OpcuaNodeIdServicesObjectType_SecurityGroupType,
		OpcuaNodeIdServicesObjectType_ExtensionFieldsType,
		OpcuaNodeIdServicesObjectType_PubSubStatusEventType,
		OpcuaNodeIdServicesObjectType_PubSubTransportLimitsExceedEventType,
		OpcuaNodeIdServicesObjectType_PubSubCommunicationFailureEventType,
		OpcuaNodeIdServicesObjectType_RoleSetType,
		OpcuaNodeIdServicesObjectType_RoleType,
		OpcuaNodeIdServicesObjectType_TemporaryFileTransferType,
		OpcuaNodeIdServicesObjectType_FileTransferStateMachineType,
		OpcuaNodeIdServicesObjectType_PubSubKeyServiceType,
		OpcuaNodeIdServicesObjectType_AlarmGroupType,
		OpcuaNodeIdServicesObjectType_DiscrepancyAlarmType,
		OpcuaNodeIdServicesObjectType_SafetyConditionClassType,
		OpcuaNodeIdServicesObjectType_HighlyManagedAlarmConditionClassType,
		OpcuaNodeIdServicesObjectType_TrainingConditionClassType,
		OpcuaNodeIdServicesObjectType_TestingConditionClassType,
		OpcuaNodeIdServicesObjectType_AuditConditionSuppressionEventType,
		OpcuaNodeIdServicesObjectType_AuditConditionSilenceEventType,
		OpcuaNodeIdServicesObjectType_AuditConditionOutOfServiceEventType,
		OpcuaNodeIdServicesObjectType_AlarmMetricsType,
		OpcuaNodeIdServicesObjectType_KeyCredentialConfigurationFolderType,
		OpcuaNodeIdServicesObjectType_DictionaryEntryType,
		OpcuaNodeIdServicesObjectType_DictionaryFolderType,
		OpcuaNodeIdServicesObjectType_IrdiDictionaryEntryType,
		OpcuaNodeIdServicesObjectType_UriDictionaryEntryType,
		OpcuaNodeIdServicesObjectType_BaseInterfaceType,
		OpcuaNodeIdServicesObjectType_RoleMappingRuleChangedAuditEventType,
		OpcuaNodeIdServicesObjectType_ConnectionTransportType,
		OpcuaNodeIdServicesObjectType_WriterGroupType,
		OpcuaNodeIdServicesObjectType_AuthorizationServiceConfigurationType,
		OpcuaNodeIdServicesObjectType_WriterGroupTransportType,
		OpcuaNodeIdServicesObjectType_WriterGroupMessageType,
		OpcuaNodeIdServicesObjectType_ReaderGroupType,
		OpcuaNodeIdServicesObjectType_KeyCredentialConfigurationType,
		OpcuaNodeIdServicesObjectType_KeyCredentialAuditEventType,
		OpcuaNodeIdServicesObjectType_KeyCredentialUpdatedAuditEventType,
		OpcuaNodeIdServicesObjectType_KeyCredentialDeletedAuditEventType,
		OpcuaNodeIdServicesObjectType_InstrumentDiagnosticAlarmType,
		OpcuaNodeIdServicesObjectType_SystemDiagnosticAlarmType,
		OpcuaNodeIdServicesObjectType_StatisticalConditionClassType,
		OpcuaNodeIdServicesObjectType_AuditHistoryAnnotationUpdateEventType,
		OpcuaNodeIdServicesObjectType_TrustListOutOfDateAlarmType,
		OpcuaNodeIdServicesObjectType_PubSubDiagnosticsType,
		OpcuaNodeIdServicesObjectType_PubSubDiagnosticsRootType,
		OpcuaNodeIdServicesObjectType_PubSubDiagnosticsConnectionType,
		OpcuaNodeIdServicesObjectType_PubSubDiagnosticsWriterGroupType,
		OpcuaNodeIdServicesObjectType_PubSubDiagnosticsReaderGroupType,
		OpcuaNodeIdServicesObjectType_PubSubDiagnosticsDataSetWriterType,
		OpcuaNodeIdServicesObjectType_PubSubDiagnosticsDataSetReaderType,
		OpcuaNodeIdServicesObjectType_ReaderGroupTransportType,
		OpcuaNodeIdServicesObjectType_ReaderGroupMessageType,
		OpcuaNodeIdServicesObjectType_DataSetWriterMessageType,
		OpcuaNodeIdServicesObjectType_DataSetReaderMessageType,
		OpcuaNodeIdServicesObjectType_UadpWriterGroupMessageType,
		OpcuaNodeIdServicesObjectType_UadpDataSetWriterMessageType,
		OpcuaNodeIdServicesObjectType_UadpDataSetReaderMessageType,
		OpcuaNodeIdServicesObjectType_JsonWriterGroupMessageType,
		OpcuaNodeIdServicesObjectType_JsonDataSetWriterMessageType,
		OpcuaNodeIdServicesObjectType_JsonDataSetReaderMessageType,
		OpcuaNodeIdServicesObjectType_DatagramWriterGroupTransportType,
		OpcuaNodeIdServicesObjectType_BrokerWriterGroupTransportType,
		OpcuaNodeIdServicesObjectType_BrokerDataSetWriterTransportType,
		OpcuaNodeIdServicesObjectType_BrokerDataSetReaderTransportType,
		OpcuaNodeIdServicesObjectType_NetworkAddressType,
		OpcuaNodeIdServicesObjectType_NetworkAddressUrlType,
		OpcuaNodeIdServicesObjectType_AliasNameType,
		OpcuaNodeIdServicesObjectType_AliasNameCategoryType,
		OpcuaNodeIdServicesObjectType_IOrderedObjectType,
		OpcuaNodeIdServicesObjectType_OrderedListType,
		OpcuaNodeIdServicesObjectType_EccApplicationCertificateType,
		OpcuaNodeIdServicesObjectType_EccNistP256ApplicationCertificateType,
		OpcuaNodeIdServicesObjectType_EccNistP384ApplicationCertificateType,
		OpcuaNodeIdServicesObjectType_EccBrainpoolP256r1ApplicationCertificateType,
		OpcuaNodeIdServicesObjectType_EccBrainpoolP384r1ApplicationCertificateType,
		OpcuaNodeIdServicesObjectType_EccCurve25519ApplicationCertificateType,
		OpcuaNodeIdServicesObjectType_EccCurve448ApplicationCertificateType,
		OpcuaNodeIdServicesObjectType_AuthorizationServicesConfigurationFolderType,
		OpcuaNodeIdServicesObjectType_AuditClientEventType,
		OpcuaNodeIdServicesObjectType_SubscribedDataSetFolderType,
		OpcuaNodeIdServicesObjectType_StandaloneSubscribedDataSetType,
		OpcuaNodeIdServicesObjectType_PubSubCapabilitiesType,
		OpcuaNodeIdServicesObjectType_AuditClientUpdateMethodResultEventType,
		OpcuaNodeIdServicesObjectType_DatagramDataSetReaderTransportType,
		OpcuaNodeIdServicesObjectType_IIetfBaseNetworkInterfaceType,
		OpcuaNodeIdServicesObjectType_IIeeeBaseEthernetPortType,
		OpcuaNodeIdServicesObjectType_IBaseEthernetCapabilitiesType,
		OpcuaNodeIdServicesObjectType_ISrClassType,
		OpcuaNodeIdServicesObjectType_IIeeeBaseTsnStreamType,
		OpcuaNodeIdServicesObjectType_IIeeeBaseTsnTrafficSpecificationType,
		OpcuaNodeIdServicesObjectType_IIeeeBaseTsnStatusStreamType,
		OpcuaNodeIdServicesObjectType_IIeeeTsnInterfaceConfigurationType,
		OpcuaNodeIdServicesObjectType_IIeeeTsnInterfaceConfigurationTalkerType,
		OpcuaNodeIdServicesObjectType_IIeeeTsnInterfaceConfigurationListenerType,
		OpcuaNodeIdServicesObjectType_IIeeeTsnMacAddressType,
		OpcuaNodeIdServicesObjectType_IIeeeTsnVlanTagType,
		OpcuaNodeIdServicesObjectType_IPriorityMappingEntryType,
		OpcuaNodeIdServicesObjectType_IIeeeAutoNegotiationStatusType,
		OpcuaNodeIdServicesObjectType_UserManagementType,
		OpcuaNodeIdServicesObjectType_IVlanIdType,
		OpcuaNodeIdServicesObjectType_IetfBaseNetworkInterfaceType,
		OpcuaNodeIdServicesObjectType_PriorityMappingTableType,
		OpcuaNodeIdServicesObjectType_PubSubKeyPushTargetType,
		OpcuaNodeIdServicesObjectType_PubSubKeyPushTargetFolderType,
		OpcuaNodeIdServicesObjectType_PubSubConfigurationType,
		OpcuaNodeIdServicesObjectType_ApplicationConfigurationType,
		OpcuaNodeIdServicesObjectType_ProvisionableDeviceType,
		OpcuaNodeIdServicesObjectType_AlarmSuppressionGroupType,
		OpcuaNodeIdServicesObjectType_TrustListUpdateRequestedAuditEventType,
		OpcuaNodeIdServicesObjectType_TransactionDiagnosticsType,
		OpcuaNodeIdServicesObjectType_CertificateUpdateRequestedAuditEventType,
		OpcuaNodeIdServicesObjectType_NonTransparentBackupRedundancyType,
		OpcuaNodeIdServicesObjectType_SyntaxReferenceEntryType,
		OpcuaNodeIdServicesObjectType_UnitType,
		OpcuaNodeIdServicesObjectType_ServerUnitType,
		OpcuaNodeIdServicesObjectType_AlternativeUnitType,
		OpcuaNodeIdServicesObjectType_QuantityType,
		OpcuaNodeIdServicesObjectType_QuantitiesFolderType,
		OpcuaNodeIdServicesObjectType_HistoricalEventConfigurationType,
		OpcuaNodeIdServicesObjectType_HistoricalExternalEventSourceType,
		OpcuaNodeIdServicesObjectType_AuditHistoryConfigurationChangeEventType,
		OpcuaNodeIdServicesObjectType_AuditHistoryBulkInsertEventType,
	}
}

func OpcuaNodeIdServicesObjectTypeByValue(value int32) (enum OpcuaNodeIdServicesObjectType, ok bool) {
	switch value {
	case 10060:
		return OpcuaNodeIdServicesObjectType_NonExclusiveLevelAlarmType, true
	case 10214:
		return OpcuaNodeIdServicesObjectType_NonExclusiveRateOfChangeAlarmType, true
	case 10368:
		return OpcuaNodeIdServicesObjectType_NonExclusiveDeviationAlarmType, true
	case 10523:
		return OpcuaNodeIdServicesObjectType_DiscreteAlarmType, true
	case 10637:
		return OpcuaNodeIdServicesObjectType_OffNormalAlarmType, true
	case 10751:
		return OpcuaNodeIdServicesObjectType_TripAlarmType, true
	case 11093:
		return OpcuaNodeIdServicesObjectType_AuditConditionShelvingEventType, true
	case 11163:
		return OpcuaNodeIdServicesObjectType_BaseConditionClassType, true
	case 11164:
		return OpcuaNodeIdServicesObjectType_ProcessConditionClassType, true
	case 11165:
		return OpcuaNodeIdServicesObjectType_MaintenanceConditionClassType, true
	case 11166:
		return OpcuaNodeIdServicesObjectType_SystemConditionClassType, true
	case 11187:
		return OpcuaNodeIdServicesObjectType_AggregateConfigurationType, true
	case 11436:
		return OpcuaNodeIdServicesObjectType_ProgressEventType, true
	case 11446:
		return OpcuaNodeIdServicesObjectType_SystemStatusChangeEventType, true
	case 11564:
		return OpcuaNodeIdServicesObjectType_OperationLimitsType, true
	case 11575:
		return OpcuaNodeIdServicesObjectType_FileType, true
	case 11595:
		return OpcuaNodeIdServicesObjectType_AddressSpaceFileType, true
	case 11616:
		return OpcuaNodeIdServicesObjectType_NamespaceMetadataType, true
	case 11645:
		return OpcuaNodeIdServicesObjectType_NamespacesType, true
	case 11753:
		return OpcuaNodeIdServicesObjectType_SystemOffNormalAlarmType, true
	case 11856:
		return OpcuaNodeIdServicesObjectType_AuditProgramTransitionEventType, true
	case 11945:
		return OpcuaNodeIdServicesObjectType_NonTransparentNetworkRedundancyType, true
	case 12522:
		return OpcuaNodeIdServicesObjectType_TrustListType, true
	case 12555:
		return OpcuaNodeIdServicesObjectType_CertificateGroupType, true
	case 12556:
		return OpcuaNodeIdServicesObjectType_CertificateType, true
	case 12557:
		return OpcuaNodeIdServicesObjectType_ApplicationCertificateType, true
	case 12558:
		return OpcuaNodeIdServicesObjectType_HttpsCertificateType, true
	case 12559:
		return OpcuaNodeIdServicesObjectType_RsaMinApplicationCertificateType, true
	case 12560:
		return OpcuaNodeIdServicesObjectType_RsaSha256ApplicationCertificateType, true
	case 12561:
		return OpcuaNodeIdServicesObjectType_TrustListUpdatedAuditEventType, true
	case 12581:
		return OpcuaNodeIdServicesObjectType_ServerConfigurationType, true
	case 12620:
		return OpcuaNodeIdServicesObjectType_CertificateUpdatedAuditEventType, true
	case 13225:
		return OpcuaNodeIdServicesObjectType_CertificateExpirationAlarmType, true
	case 13353:
		return OpcuaNodeIdServicesObjectType_FileDirectoryType, true
	case 13813:
		return OpcuaNodeIdServicesObjectType_CertificateGroupFolderType, true
	case 14209:
		return OpcuaNodeIdServicesObjectType_PubSubConnectionType, true
	case 14232:
		return OpcuaNodeIdServicesObjectType_PubSubGroupType, true
	case 14416:
		return OpcuaNodeIdServicesObjectType_PublishSubscribeType, true
	case 14477:
		return OpcuaNodeIdServicesObjectType_DataSetFolderType, true
	case 14509:
		return OpcuaNodeIdServicesObjectType_PublishedDataSetType, true
	case 14534:
		return OpcuaNodeIdServicesObjectType_PublishedDataItemsType, true
	case 14572:
		return OpcuaNodeIdServicesObjectType_PublishedEventsType, true
	case 14643:
		return OpcuaNodeIdServicesObjectType_PubSubStatusType, true
	case 15013:
		return OpcuaNodeIdServicesObjectType_AuditConditionResetEventType, true
	case 15064:
		return OpcuaNodeIdServicesObjectType_DatagramConnectionTransportType, true
	case 15108:
		return OpcuaNodeIdServicesObjectType_SubscribedDataSetType, true
	case 15109:
		return OpcuaNodeIdServicesObjectType_ChoiceStateType, true
	case 15111:
		return OpcuaNodeIdServicesObjectType_TargetVariablesType, true
	case 15127:
		return OpcuaNodeIdServicesObjectType_SubscribedDataSetMirrorType, true
	case 15155:
		return OpcuaNodeIdServicesObjectType_BrokerConnectionTransportType, true
	case 15181:
		return OpcuaNodeIdServicesObjectType_UserCredentialCertificateType, true
	case 15298:
		return OpcuaNodeIdServicesObjectType_DataSetWriterType, true
	case 15305:
		return OpcuaNodeIdServicesObjectType_DataSetWriterTransportType, true
	case 15306:
		return OpcuaNodeIdServicesObjectType_DataSetReaderType, true
	case 15319:
		return OpcuaNodeIdServicesObjectType_DataSetReaderTransportType, true
	case 15452:
		return OpcuaNodeIdServicesObjectType_SecurityGroupFolderType, true
	case 15471:
		return OpcuaNodeIdServicesObjectType_SecurityGroupType, true
	case 15489:
		return OpcuaNodeIdServicesObjectType_ExtensionFieldsType, true
	case 15535:
		return OpcuaNodeIdServicesObjectType_PubSubStatusEventType, true
	case 15548:
		return OpcuaNodeIdServicesObjectType_PubSubTransportLimitsExceedEventType, true
	case 15563:
		return OpcuaNodeIdServicesObjectType_PubSubCommunicationFailureEventType, true
	case 15607:
		return OpcuaNodeIdServicesObjectType_RoleSetType, true
	case 15620:
		return OpcuaNodeIdServicesObjectType_RoleType, true
	case 15744:
		return OpcuaNodeIdServicesObjectType_TemporaryFileTransferType, true
	case 15803:
		return OpcuaNodeIdServicesObjectType_FileTransferStateMachineType, true
	case 15906:
		return OpcuaNodeIdServicesObjectType_PubSubKeyServiceType, true
	case 16405:
		return OpcuaNodeIdServicesObjectType_AlarmGroupType, true
	case 17080:
		return OpcuaNodeIdServicesObjectType_DiscrepancyAlarmType, true
	case 17218:
		return OpcuaNodeIdServicesObjectType_SafetyConditionClassType, true
	case 17219:
		return OpcuaNodeIdServicesObjectType_HighlyManagedAlarmConditionClassType, true
	case 17220:
		return OpcuaNodeIdServicesObjectType_TrainingConditionClassType, true
	case 17221:
		return OpcuaNodeIdServicesObjectType_TestingConditionClassType, true
	case 17225:
		return OpcuaNodeIdServicesObjectType_AuditConditionSuppressionEventType, true
	case 17242:
		return OpcuaNodeIdServicesObjectType_AuditConditionSilenceEventType, true
	case 17259:
		return OpcuaNodeIdServicesObjectType_AuditConditionOutOfServiceEventType, true
	case 17279:
		return OpcuaNodeIdServicesObjectType_AlarmMetricsType, true
	case 17496:
		return OpcuaNodeIdServicesObjectType_KeyCredentialConfigurationFolderType, true
	case 17589:
		return OpcuaNodeIdServicesObjectType_DictionaryEntryType, true
	case 17591:
		return OpcuaNodeIdServicesObjectType_DictionaryFolderType, true
	case 17598:
		return OpcuaNodeIdServicesObjectType_IrdiDictionaryEntryType, true
	case 17600:
		return OpcuaNodeIdServicesObjectType_UriDictionaryEntryType, true
	case 17602:
		return OpcuaNodeIdServicesObjectType_BaseInterfaceType, true
	case 17641:
		return OpcuaNodeIdServicesObjectType_RoleMappingRuleChangedAuditEventType, true
	case 17721:
		return OpcuaNodeIdServicesObjectType_ConnectionTransportType, true
	case 17725:
		return OpcuaNodeIdServicesObjectType_WriterGroupType, true
	case 17852:
		return OpcuaNodeIdServicesObjectType_AuthorizationServiceConfigurationType, true
	case 17997:
		return OpcuaNodeIdServicesObjectType_WriterGroupTransportType, true
	case 17998:
		return OpcuaNodeIdServicesObjectType_WriterGroupMessageType, true
	case 17999:
		return OpcuaNodeIdServicesObjectType_ReaderGroupType, true
	case 18001:
		return OpcuaNodeIdServicesObjectType_KeyCredentialConfigurationType, true
	case 18011:
		return OpcuaNodeIdServicesObjectType_KeyCredentialAuditEventType, true
	case 18029:
		return OpcuaNodeIdServicesObjectType_KeyCredentialUpdatedAuditEventType, true
	case 18047:
		return OpcuaNodeIdServicesObjectType_KeyCredentialDeletedAuditEventType, true
	case 18347:
		return OpcuaNodeIdServicesObjectType_InstrumentDiagnosticAlarmType, true
	case 18496:
		return OpcuaNodeIdServicesObjectType_SystemDiagnosticAlarmType, true
	case 18665:
		return OpcuaNodeIdServicesObjectType_StatisticalConditionClassType, true
	case 19095:
		return OpcuaNodeIdServicesObjectType_AuditHistoryAnnotationUpdateEventType, true
	case 19297:
		return OpcuaNodeIdServicesObjectType_TrustListOutOfDateAlarmType, true
	case 19677:
		return OpcuaNodeIdServicesObjectType_PubSubDiagnosticsType, true
	case 19732:
		return OpcuaNodeIdServicesObjectType_PubSubDiagnosticsRootType, true
	case 19786:
		return OpcuaNodeIdServicesObjectType_PubSubDiagnosticsConnectionType, true
	case 19834:
		return OpcuaNodeIdServicesObjectType_PubSubDiagnosticsWriterGroupType, true
	case 19903:
		return OpcuaNodeIdServicesObjectType_PubSubDiagnosticsReaderGroupType, true
	case 19968:
		return OpcuaNodeIdServicesObjectType_PubSubDiagnosticsDataSetWriterType, true
	case 20027:
		return OpcuaNodeIdServicesObjectType_PubSubDiagnosticsDataSetReaderType, true
	case 2004:
		return OpcuaNodeIdServicesObjectType_ServerType, true
	case 2013:
		return OpcuaNodeIdServicesObjectType_ServerCapabilitiesType, true
	case 2020:
		return OpcuaNodeIdServicesObjectType_ServerDiagnosticsType, true
	case 2026:
		return OpcuaNodeIdServicesObjectType_SessionsDiagnosticsSummaryType, true
	case 2029:
		return OpcuaNodeIdServicesObjectType_SessionDiagnosticsObjectType, true
	case 2033:
		return OpcuaNodeIdServicesObjectType_VendorServerInfoType, true
	case 2034:
		return OpcuaNodeIdServicesObjectType_ServerRedundancyType, true
	case 2036:
		return OpcuaNodeIdServicesObjectType_TransparentRedundancyType, true
	case 2039:
		return OpcuaNodeIdServicesObjectType_NonTransparentRedundancyType, true
	case 2041:
		return OpcuaNodeIdServicesObjectType_BaseEventType, true
	case 2052:
		return OpcuaNodeIdServicesObjectType_AuditEventType, true
	case 2058:
		return OpcuaNodeIdServicesObjectType_AuditSecurityEventType, true
	case 2059:
		return OpcuaNodeIdServicesObjectType_AuditChannelEventType, true
	case 2060:
		return OpcuaNodeIdServicesObjectType_AuditOpenSecureChannelEventType, true
	case 2069:
		return OpcuaNodeIdServicesObjectType_AuditSessionEventType, true
	case 2071:
		return OpcuaNodeIdServicesObjectType_AuditCreateSessionEventType, true
	case 2075:
		return OpcuaNodeIdServicesObjectType_AuditActivateSessionEventType, true
	case 2078:
		return OpcuaNodeIdServicesObjectType_AuditCancelEventType, true
	case 2080:
		return OpcuaNodeIdServicesObjectType_AuditCertificateEventType, true
	case 2082:
		return OpcuaNodeIdServicesObjectType_AuditCertificateDataMismatchEventType, true
	case 2085:
		return OpcuaNodeIdServicesObjectType_AuditCertificateExpiredEventType, true
	case 2086:
		return OpcuaNodeIdServicesObjectType_AuditCertificateInvalidEventType, true
	case 2087:
		return OpcuaNodeIdServicesObjectType_AuditCertificateUntrustedEventType, true
	case 2088:
		return OpcuaNodeIdServicesObjectType_AuditCertificateRevokedEventType, true
	case 2089:
		return OpcuaNodeIdServicesObjectType_AuditCertificateMismatchEventType, true
	case 2090:
		return OpcuaNodeIdServicesObjectType_AuditNodeManagementEventType, true
	case 2091:
		return OpcuaNodeIdServicesObjectType_AuditAddNodesEventType, true
	case 2093:
		return OpcuaNodeIdServicesObjectType_AuditDeleteNodesEventType, true
	case 2095:
		return OpcuaNodeIdServicesObjectType_AuditAddReferencesEventType, true
	case 2097:
		return OpcuaNodeIdServicesObjectType_AuditDeleteReferencesEventType, true
	case 2099:
		return OpcuaNodeIdServicesObjectType_AuditUpdateEventType, true
	case 2100:
		return OpcuaNodeIdServicesObjectType_AuditWriteUpdateEventType, true
	case 2104:
		return OpcuaNodeIdServicesObjectType_AuditHistoryUpdateEventType, true
	case 21090:
		return OpcuaNodeIdServicesObjectType_ReaderGroupTransportType, true
	case 21091:
		return OpcuaNodeIdServicesObjectType_ReaderGroupMessageType, true
	case 21096:
		return OpcuaNodeIdServicesObjectType_DataSetWriterMessageType, true
	case 21104:
		return OpcuaNodeIdServicesObjectType_DataSetReaderMessageType, true
	case 21105:
		return OpcuaNodeIdServicesObjectType_UadpWriterGroupMessageType, true
	case 21111:
		return OpcuaNodeIdServicesObjectType_UadpDataSetWriterMessageType, true
	case 21116:
		return OpcuaNodeIdServicesObjectType_UadpDataSetReaderMessageType, true
	case 21126:
		return OpcuaNodeIdServicesObjectType_JsonWriterGroupMessageType, true
	case 21128:
		return OpcuaNodeIdServicesObjectType_JsonDataSetWriterMessageType, true
	case 21130:
		return OpcuaNodeIdServicesObjectType_JsonDataSetReaderMessageType, true
	case 21133:
		return OpcuaNodeIdServicesObjectType_DatagramWriterGroupTransportType, true
	case 21136:
		return OpcuaNodeIdServicesObjectType_BrokerWriterGroupTransportType, true
	case 21138:
		return OpcuaNodeIdServicesObjectType_BrokerDataSetWriterTransportType, true
	case 21142:
		return OpcuaNodeIdServicesObjectType_BrokerDataSetReaderTransportType, true
	case 21145:
		return OpcuaNodeIdServicesObjectType_NetworkAddressType, true
	case 21147:
		return OpcuaNodeIdServicesObjectType_NetworkAddressUrlType, true
	case 2127:
		return OpcuaNodeIdServicesObjectType_AuditUpdateMethodEventType, true
	case 2130:
		return OpcuaNodeIdServicesObjectType_SystemEventType, true
	case 2131:
		return OpcuaNodeIdServicesObjectType_DeviceFailureEventType, true
	case 2132:
		return OpcuaNodeIdServicesObjectType_BaseModelChangeEventType, true
	case 2133:
		return OpcuaNodeIdServicesObjectType_GeneralModelChangeEventType, true
	case 2299:
		return OpcuaNodeIdServicesObjectType_StateMachineType, true
	case 2307:
		return OpcuaNodeIdServicesObjectType_StateType, true
	case 2309:
		return OpcuaNodeIdServicesObjectType_InitialStateType, true
	case 2310:
		return OpcuaNodeIdServicesObjectType_TransitionType, true
	case 2311:
		return OpcuaNodeIdServicesObjectType_TransitionEventType, true
	case 2315:
		return OpcuaNodeIdServicesObjectType_AuditUpdateStateEventType, true
	case 2318:
		return OpcuaNodeIdServicesObjectType_HistoricalDataConfigurationType, true
	case 2330:
		return OpcuaNodeIdServicesObjectType_HistoryServerCapabilitiesType, true
	case 2340:
		return OpcuaNodeIdServicesObjectType_AggregateFunctionType, true
	case 23455:
		return OpcuaNodeIdServicesObjectType_AliasNameType, true
	case 23456:
		return OpcuaNodeIdServicesObjectType_AliasNameCategoryType, true
	case 23513:
		return OpcuaNodeIdServicesObjectType_IOrderedObjectType, true
	case 23518:
		return OpcuaNodeIdServicesObjectType_OrderedListType, true
	case 23537:
		return OpcuaNodeIdServicesObjectType_EccApplicationCertificateType, true
	case 23538:
		return OpcuaNodeIdServicesObjectType_EccNistP256ApplicationCertificateType, true
	case 23539:
		return OpcuaNodeIdServicesObjectType_EccNistP384ApplicationCertificateType, true
	case 23540:
		return OpcuaNodeIdServicesObjectType_EccBrainpoolP256r1ApplicationCertificateType, true
	case 23541:
		return OpcuaNodeIdServicesObjectType_EccBrainpoolP384r1ApplicationCertificateType, true
	case 23542:
		return OpcuaNodeIdServicesObjectType_EccCurve25519ApplicationCertificateType, true
	case 23543:
		return OpcuaNodeIdServicesObjectType_EccCurve448ApplicationCertificateType, true
	case 23556:
		return OpcuaNodeIdServicesObjectType_AuthorizationServicesConfigurationFolderType, true
	case 23606:
		return OpcuaNodeIdServicesObjectType_AuditClientEventType, true
	case 2378:
		return OpcuaNodeIdServicesObjectType_ProgramTransitionEventType, true
	case 23795:
		return OpcuaNodeIdServicesObjectType_SubscribedDataSetFolderType, true
	case 23828:
		return OpcuaNodeIdServicesObjectType_StandaloneSubscribedDataSetType, true
	case 23832:
		return OpcuaNodeIdServicesObjectType_PubSubCapabilitiesType, true
	case 2391:
		return OpcuaNodeIdServicesObjectType_ProgramStateMachineType, true
	case 23926:
		return OpcuaNodeIdServicesObjectType_AuditClientUpdateMethodResultEventType, true
	case 24016:
		return OpcuaNodeIdServicesObjectType_DatagramDataSetReaderTransportType, true
	case 24148:
		return OpcuaNodeIdServicesObjectType_IIetfBaseNetworkInterfaceType, true
	case 24158:
		return OpcuaNodeIdServicesObjectType_IIeeeBaseEthernetPortType, true
	case 24167:
		return OpcuaNodeIdServicesObjectType_IBaseEthernetCapabilitiesType, true
	case 24169:
		return OpcuaNodeIdServicesObjectType_ISrClassType, true
	case 24173:
		return OpcuaNodeIdServicesObjectType_IIeeeBaseTsnStreamType, true
	case 24179:
		return OpcuaNodeIdServicesObjectType_IIeeeBaseTsnTrafficSpecificationType, true
	case 24183:
		return OpcuaNodeIdServicesObjectType_IIeeeBaseTsnStatusStreamType, true
	case 24188:
		return OpcuaNodeIdServicesObjectType_IIeeeTsnInterfaceConfigurationType, true
	case 24191:
		return OpcuaNodeIdServicesObjectType_IIeeeTsnInterfaceConfigurationTalkerType, true
	case 24195:
		return OpcuaNodeIdServicesObjectType_IIeeeTsnInterfaceConfigurationListenerType, true
	case 24199:
		return OpcuaNodeIdServicesObjectType_IIeeeTsnMacAddressType, true
	case 24202:
		return OpcuaNodeIdServicesObjectType_IIeeeTsnVlanTagType, true
	case 24205:
		return OpcuaNodeIdServicesObjectType_IPriorityMappingEntryType, true
	case 24233:
		return OpcuaNodeIdServicesObjectType_IIeeeAutoNegotiationStatusType, true
	case 24264:
		return OpcuaNodeIdServicesObjectType_UserManagementType, true
	case 25218:
		return OpcuaNodeIdServicesObjectType_IVlanIdType, true
	case 25221:
		return OpcuaNodeIdServicesObjectType_IetfBaseNetworkInterfaceType, true
	case 25227:
		return OpcuaNodeIdServicesObjectType_PriorityMappingTableType, true
	case 25337:
		return OpcuaNodeIdServicesObjectType_PubSubKeyPushTargetType, true
	case 25346:
		return OpcuaNodeIdServicesObjectType_PubSubKeyPushTargetFolderType, true
	case 25482:
		return OpcuaNodeIdServicesObjectType_PubSubConfigurationType, true
	case 25731:
		return OpcuaNodeIdServicesObjectType_ApplicationConfigurationType, true
	case 26871:
		return OpcuaNodeIdServicesObjectType_ProvisionableDeviceType, true
	case 2738:
		return OpcuaNodeIdServicesObjectType_SemanticChangeEventType, true
	case 2748:
		return OpcuaNodeIdServicesObjectType_AuditUrlMismatchEventType, true
	case 2771:
		return OpcuaNodeIdServicesObjectType_FiniteStateMachineType, true
	case 2782:
		return OpcuaNodeIdServicesObjectType_ConditionType, true
	case 2787:
		return OpcuaNodeIdServicesObjectType_RefreshStartEventType, true
	case 2788:
		return OpcuaNodeIdServicesObjectType_RefreshEndEventType, true
	case 2789:
		return OpcuaNodeIdServicesObjectType_RefreshRequiredEventType, true
	case 2790:
		return OpcuaNodeIdServicesObjectType_AuditConditionEventType, true
	case 2803:
		return OpcuaNodeIdServicesObjectType_AuditConditionEnableEventType, true
	case 2829:
		return OpcuaNodeIdServicesObjectType_AuditConditionCommentEventType, true
	case 2830:
		return OpcuaNodeIdServicesObjectType_DialogConditionType, true
	case 2881:
		return OpcuaNodeIdServicesObjectType_AcknowledgeableConditionType, true
	case 2915:
		return OpcuaNodeIdServicesObjectType_AlarmConditionType, true
	case 2929:
		return OpcuaNodeIdServicesObjectType_ShelvedStateMachineType, true
	case 2955:
		return OpcuaNodeIdServicesObjectType_LimitAlarmType, true
	case 2999:
		return OpcuaNodeIdServicesObjectType_AuditHistoryEventUpdateEventType, true
	case 3006:
		return OpcuaNodeIdServicesObjectType_AuditHistoryValueUpdateEventType, true
	case 3012:
		return OpcuaNodeIdServicesObjectType_AuditHistoryDeleteEventType, true
	case 3014:
		return OpcuaNodeIdServicesObjectType_AuditHistoryRawModifyDeleteEventType, true
	case 3019:
		return OpcuaNodeIdServicesObjectType_AuditHistoryAtTimeDeleteEventType, true
	case 3022:
		return OpcuaNodeIdServicesObjectType_AuditHistoryEventDeleteEventType, true
	case 3035:
		return OpcuaNodeIdServicesObjectType_EventQueueOverflowEventType, true
	case 32064:
		return OpcuaNodeIdServicesObjectType_AlarmSuppressionGroupType, true
	case 32260:
		return OpcuaNodeIdServicesObjectType_TrustListUpdateRequestedAuditEventType, true
	case 32286:
		return OpcuaNodeIdServicesObjectType_TransactionDiagnosticsType, true
	case 32306:
		return OpcuaNodeIdServicesObjectType_CertificateUpdateRequestedAuditEventType, true
	case 32411:
		return OpcuaNodeIdServicesObjectType_NonTransparentBackupRedundancyType, true
	case 32439:
		return OpcuaNodeIdServicesObjectType_SyntaxReferenceEntryType, true
	case 32442:
		return OpcuaNodeIdServicesObjectType_UnitType, true
	case 32447:
		return OpcuaNodeIdServicesObjectType_ServerUnitType, true
	case 32467:
		return OpcuaNodeIdServicesObjectType_AlternativeUnitType, true
	case 32475:
		return OpcuaNodeIdServicesObjectType_QuantityType, true
	case 32502:
		return OpcuaNodeIdServicesObjectType_QuantitiesFolderType, true
	case 32621:
		return OpcuaNodeIdServicesObjectType_HistoricalEventConfigurationType, true
	case 32625:
		return OpcuaNodeIdServicesObjectType_HistoricalExternalEventSourceType, true
	case 32758:
		return OpcuaNodeIdServicesObjectType_AuditHistoryConfigurationChangeEventType, true
	case 32803:
		return OpcuaNodeIdServicesObjectType_AuditHistoryBulkInsertEventType, true
	case 3806:
		return OpcuaNodeIdServicesObjectType_ProgramTransitionAuditEventType, true
	case 58:
		return OpcuaNodeIdServicesObjectType_BaseObjectType, true
	case 61:
		return OpcuaNodeIdServicesObjectType_FolderType, true
	case 75:
		return OpcuaNodeIdServicesObjectType_DataTypeSystemType, true
	case 76:
		return OpcuaNodeIdServicesObjectType_DataTypeEncodingType, true
	case 77:
		return OpcuaNodeIdServicesObjectType_ModellingRuleType, true
	case 8927:
		return OpcuaNodeIdServicesObjectType_AuditConditionRespondEventType, true
	case 8944:
		return OpcuaNodeIdServicesObjectType_AuditConditionAcknowledgeEventType, true
	case 8961:
		return OpcuaNodeIdServicesObjectType_AuditConditionConfirmEventType, true
	case 9318:
		return OpcuaNodeIdServicesObjectType_ExclusiveLimitStateMachineType, true
	case 9341:
		return OpcuaNodeIdServicesObjectType_ExclusiveLimitAlarmType, true
	case 9482:
		return OpcuaNodeIdServicesObjectType_ExclusiveLevelAlarmType, true
	case 9623:
		return OpcuaNodeIdServicesObjectType_ExclusiveRateOfChangeAlarmType, true
	case 9764:
		return OpcuaNodeIdServicesObjectType_ExclusiveDeviationAlarmType, true
	case 9906:
		return OpcuaNodeIdServicesObjectType_NonExclusiveLimitAlarmType, true
	}
	return 0, false
}

func OpcuaNodeIdServicesObjectTypeByName(value string) (enum OpcuaNodeIdServicesObjectType, ok bool) {
	switch value {
	case "NonExclusiveLevelAlarmType":
		return OpcuaNodeIdServicesObjectType_NonExclusiveLevelAlarmType, true
	case "NonExclusiveRateOfChangeAlarmType":
		return OpcuaNodeIdServicesObjectType_NonExclusiveRateOfChangeAlarmType, true
	case "NonExclusiveDeviationAlarmType":
		return OpcuaNodeIdServicesObjectType_NonExclusiveDeviationAlarmType, true
	case "DiscreteAlarmType":
		return OpcuaNodeIdServicesObjectType_DiscreteAlarmType, true
	case "OffNormalAlarmType":
		return OpcuaNodeIdServicesObjectType_OffNormalAlarmType, true
	case "TripAlarmType":
		return OpcuaNodeIdServicesObjectType_TripAlarmType, true
	case "AuditConditionShelvingEventType":
		return OpcuaNodeIdServicesObjectType_AuditConditionShelvingEventType, true
	case "BaseConditionClassType":
		return OpcuaNodeIdServicesObjectType_BaseConditionClassType, true
	case "ProcessConditionClassType":
		return OpcuaNodeIdServicesObjectType_ProcessConditionClassType, true
	case "MaintenanceConditionClassType":
		return OpcuaNodeIdServicesObjectType_MaintenanceConditionClassType, true
	case "SystemConditionClassType":
		return OpcuaNodeIdServicesObjectType_SystemConditionClassType, true
	case "AggregateConfigurationType":
		return OpcuaNodeIdServicesObjectType_AggregateConfigurationType, true
	case "ProgressEventType":
		return OpcuaNodeIdServicesObjectType_ProgressEventType, true
	case "SystemStatusChangeEventType":
		return OpcuaNodeIdServicesObjectType_SystemStatusChangeEventType, true
	case "OperationLimitsType":
		return OpcuaNodeIdServicesObjectType_OperationLimitsType, true
	case "FileType":
		return OpcuaNodeIdServicesObjectType_FileType, true
	case "AddressSpaceFileType":
		return OpcuaNodeIdServicesObjectType_AddressSpaceFileType, true
	case "NamespaceMetadataType":
		return OpcuaNodeIdServicesObjectType_NamespaceMetadataType, true
	case "NamespacesType":
		return OpcuaNodeIdServicesObjectType_NamespacesType, true
	case "SystemOffNormalAlarmType":
		return OpcuaNodeIdServicesObjectType_SystemOffNormalAlarmType, true
	case "AuditProgramTransitionEventType":
		return OpcuaNodeIdServicesObjectType_AuditProgramTransitionEventType, true
	case "NonTransparentNetworkRedundancyType":
		return OpcuaNodeIdServicesObjectType_NonTransparentNetworkRedundancyType, true
	case "TrustListType":
		return OpcuaNodeIdServicesObjectType_TrustListType, true
	case "CertificateGroupType":
		return OpcuaNodeIdServicesObjectType_CertificateGroupType, true
	case "CertificateType":
		return OpcuaNodeIdServicesObjectType_CertificateType, true
	case "ApplicationCertificateType":
		return OpcuaNodeIdServicesObjectType_ApplicationCertificateType, true
	case "HttpsCertificateType":
		return OpcuaNodeIdServicesObjectType_HttpsCertificateType, true
	case "RsaMinApplicationCertificateType":
		return OpcuaNodeIdServicesObjectType_RsaMinApplicationCertificateType, true
	case "RsaSha256ApplicationCertificateType":
		return OpcuaNodeIdServicesObjectType_RsaSha256ApplicationCertificateType, true
	case "TrustListUpdatedAuditEventType":
		return OpcuaNodeIdServicesObjectType_TrustListUpdatedAuditEventType, true
	case "ServerConfigurationType":
		return OpcuaNodeIdServicesObjectType_ServerConfigurationType, true
	case "CertificateUpdatedAuditEventType":
		return OpcuaNodeIdServicesObjectType_CertificateUpdatedAuditEventType, true
	case "CertificateExpirationAlarmType":
		return OpcuaNodeIdServicesObjectType_CertificateExpirationAlarmType, true
	case "FileDirectoryType":
		return OpcuaNodeIdServicesObjectType_FileDirectoryType, true
	case "CertificateGroupFolderType":
		return OpcuaNodeIdServicesObjectType_CertificateGroupFolderType, true
	case "PubSubConnectionType":
		return OpcuaNodeIdServicesObjectType_PubSubConnectionType, true
	case "PubSubGroupType":
		return OpcuaNodeIdServicesObjectType_PubSubGroupType, true
	case "PublishSubscribeType":
		return OpcuaNodeIdServicesObjectType_PublishSubscribeType, true
	case "DataSetFolderType":
		return OpcuaNodeIdServicesObjectType_DataSetFolderType, true
	case "PublishedDataSetType":
		return OpcuaNodeIdServicesObjectType_PublishedDataSetType, true
	case "PublishedDataItemsType":
		return OpcuaNodeIdServicesObjectType_PublishedDataItemsType, true
	case "PublishedEventsType":
		return OpcuaNodeIdServicesObjectType_PublishedEventsType, true
	case "PubSubStatusType":
		return OpcuaNodeIdServicesObjectType_PubSubStatusType, true
	case "AuditConditionResetEventType":
		return OpcuaNodeIdServicesObjectType_AuditConditionResetEventType, true
	case "DatagramConnectionTransportType":
		return OpcuaNodeIdServicesObjectType_DatagramConnectionTransportType, true
	case "SubscribedDataSetType":
		return OpcuaNodeIdServicesObjectType_SubscribedDataSetType, true
	case "ChoiceStateType":
		return OpcuaNodeIdServicesObjectType_ChoiceStateType, true
	case "TargetVariablesType":
		return OpcuaNodeIdServicesObjectType_TargetVariablesType, true
	case "SubscribedDataSetMirrorType":
		return OpcuaNodeIdServicesObjectType_SubscribedDataSetMirrorType, true
	case "BrokerConnectionTransportType":
		return OpcuaNodeIdServicesObjectType_BrokerConnectionTransportType, true
	case "UserCredentialCertificateType":
		return OpcuaNodeIdServicesObjectType_UserCredentialCertificateType, true
	case "DataSetWriterType":
		return OpcuaNodeIdServicesObjectType_DataSetWriterType, true
	case "DataSetWriterTransportType":
		return OpcuaNodeIdServicesObjectType_DataSetWriterTransportType, true
	case "DataSetReaderType":
		return OpcuaNodeIdServicesObjectType_DataSetReaderType, true
	case "DataSetReaderTransportType":
		return OpcuaNodeIdServicesObjectType_DataSetReaderTransportType, true
	case "SecurityGroupFolderType":
		return OpcuaNodeIdServicesObjectType_SecurityGroupFolderType, true
	case "SecurityGroupType":
		return OpcuaNodeIdServicesObjectType_SecurityGroupType, true
	case "ExtensionFieldsType":
		return OpcuaNodeIdServicesObjectType_ExtensionFieldsType, true
	case "PubSubStatusEventType":
		return OpcuaNodeIdServicesObjectType_PubSubStatusEventType, true
	case "PubSubTransportLimitsExceedEventType":
		return OpcuaNodeIdServicesObjectType_PubSubTransportLimitsExceedEventType, true
	case "PubSubCommunicationFailureEventType":
		return OpcuaNodeIdServicesObjectType_PubSubCommunicationFailureEventType, true
	case "RoleSetType":
		return OpcuaNodeIdServicesObjectType_RoleSetType, true
	case "RoleType":
		return OpcuaNodeIdServicesObjectType_RoleType, true
	case "TemporaryFileTransferType":
		return OpcuaNodeIdServicesObjectType_TemporaryFileTransferType, true
	case "FileTransferStateMachineType":
		return OpcuaNodeIdServicesObjectType_FileTransferStateMachineType, true
	case "PubSubKeyServiceType":
		return OpcuaNodeIdServicesObjectType_PubSubKeyServiceType, true
	case "AlarmGroupType":
		return OpcuaNodeIdServicesObjectType_AlarmGroupType, true
	case "DiscrepancyAlarmType":
		return OpcuaNodeIdServicesObjectType_DiscrepancyAlarmType, true
	case "SafetyConditionClassType":
		return OpcuaNodeIdServicesObjectType_SafetyConditionClassType, true
	case "HighlyManagedAlarmConditionClassType":
		return OpcuaNodeIdServicesObjectType_HighlyManagedAlarmConditionClassType, true
	case "TrainingConditionClassType":
		return OpcuaNodeIdServicesObjectType_TrainingConditionClassType, true
	case "TestingConditionClassType":
		return OpcuaNodeIdServicesObjectType_TestingConditionClassType, true
	case "AuditConditionSuppressionEventType":
		return OpcuaNodeIdServicesObjectType_AuditConditionSuppressionEventType, true
	case "AuditConditionSilenceEventType":
		return OpcuaNodeIdServicesObjectType_AuditConditionSilenceEventType, true
	case "AuditConditionOutOfServiceEventType":
		return OpcuaNodeIdServicesObjectType_AuditConditionOutOfServiceEventType, true
	case "AlarmMetricsType":
		return OpcuaNodeIdServicesObjectType_AlarmMetricsType, true
	case "KeyCredentialConfigurationFolderType":
		return OpcuaNodeIdServicesObjectType_KeyCredentialConfigurationFolderType, true
	case "DictionaryEntryType":
		return OpcuaNodeIdServicesObjectType_DictionaryEntryType, true
	case "DictionaryFolderType":
		return OpcuaNodeIdServicesObjectType_DictionaryFolderType, true
	case "IrdiDictionaryEntryType":
		return OpcuaNodeIdServicesObjectType_IrdiDictionaryEntryType, true
	case "UriDictionaryEntryType":
		return OpcuaNodeIdServicesObjectType_UriDictionaryEntryType, true
	case "BaseInterfaceType":
		return OpcuaNodeIdServicesObjectType_BaseInterfaceType, true
	case "RoleMappingRuleChangedAuditEventType":
		return OpcuaNodeIdServicesObjectType_RoleMappingRuleChangedAuditEventType, true
	case "ConnectionTransportType":
		return OpcuaNodeIdServicesObjectType_ConnectionTransportType, true
	case "WriterGroupType":
		return OpcuaNodeIdServicesObjectType_WriterGroupType, true
	case "AuthorizationServiceConfigurationType":
		return OpcuaNodeIdServicesObjectType_AuthorizationServiceConfigurationType, true
	case "WriterGroupTransportType":
		return OpcuaNodeIdServicesObjectType_WriterGroupTransportType, true
	case "WriterGroupMessageType":
		return OpcuaNodeIdServicesObjectType_WriterGroupMessageType, true
	case "ReaderGroupType":
		return OpcuaNodeIdServicesObjectType_ReaderGroupType, true
	case "KeyCredentialConfigurationType":
		return OpcuaNodeIdServicesObjectType_KeyCredentialConfigurationType, true
	case "KeyCredentialAuditEventType":
		return OpcuaNodeIdServicesObjectType_KeyCredentialAuditEventType, true
	case "KeyCredentialUpdatedAuditEventType":
		return OpcuaNodeIdServicesObjectType_KeyCredentialUpdatedAuditEventType, true
	case "KeyCredentialDeletedAuditEventType":
		return OpcuaNodeIdServicesObjectType_KeyCredentialDeletedAuditEventType, true
	case "InstrumentDiagnosticAlarmType":
		return OpcuaNodeIdServicesObjectType_InstrumentDiagnosticAlarmType, true
	case "SystemDiagnosticAlarmType":
		return OpcuaNodeIdServicesObjectType_SystemDiagnosticAlarmType, true
	case "StatisticalConditionClassType":
		return OpcuaNodeIdServicesObjectType_StatisticalConditionClassType, true
	case "AuditHistoryAnnotationUpdateEventType":
		return OpcuaNodeIdServicesObjectType_AuditHistoryAnnotationUpdateEventType, true
	case "TrustListOutOfDateAlarmType":
		return OpcuaNodeIdServicesObjectType_TrustListOutOfDateAlarmType, true
	case "PubSubDiagnosticsType":
		return OpcuaNodeIdServicesObjectType_PubSubDiagnosticsType, true
	case "PubSubDiagnosticsRootType":
		return OpcuaNodeIdServicesObjectType_PubSubDiagnosticsRootType, true
	case "PubSubDiagnosticsConnectionType":
		return OpcuaNodeIdServicesObjectType_PubSubDiagnosticsConnectionType, true
	case "PubSubDiagnosticsWriterGroupType":
		return OpcuaNodeIdServicesObjectType_PubSubDiagnosticsWriterGroupType, true
	case "PubSubDiagnosticsReaderGroupType":
		return OpcuaNodeIdServicesObjectType_PubSubDiagnosticsReaderGroupType, true
	case "PubSubDiagnosticsDataSetWriterType":
		return OpcuaNodeIdServicesObjectType_PubSubDiagnosticsDataSetWriterType, true
	case "PubSubDiagnosticsDataSetReaderType":
		return OpcuaNodeIdServicesObjectType_PubSubDiagnosticsDataSetReaderType, true
	case "ServerType":
		return OpcuaNodeIdServicesObjectType_ServerType, true
	case "ServerCapabilitiesType":
		return OpcuaNodeIdServicesObjectType_ServerCapabilitiesType, true
	case "ServerDiagnosticsType":
		return OpcuaNodeIdServicesObjectType_ServerDiagnosticsType, true
	case "SessionsDiagnosticsSummaryType":
		return OpcuaNodeIdServicesObjectType_SessionsDiagnosticsSummaryType, true
	case "SessionDiagnosticsObjectType":
		return OpcuaNodeIdServicesObjectType_SessionDiagnosticsObjectType, true
	case "VendorServerInfoType":
		return OpcuaNodeIdServicesObjectType_VendorServerInfoType, true
	case "ServerRedundancyType":
		return OpcuaNodeIdServicesObjectType_ServerRedundancyType, true
	case "TransparentRedundancyType":
		return OpcuaNodeIdServicesObjectType_TransparentRedundancyType, true
	case "NonTransparentRedundancyType":
		return OpcuaNodeIdServicesObjectType_NonTransparentRedundancyType, true
	case "BaseEventType":
		return OpcuaNodeIdServicesObjectType_BaseEventType, true
	case "AuditEventType":
		return OpcuaNodeIdServicesObjectType_AuditEventType, true
	case "AuditSecurityEventType":
		return OpcuaNodeIdServicesObjectType_AuditSecurityEventType, true
	case "AuditChannelEventType":
		return OpcuaNodeIdServicesObjectType_AuditChannelEventType, true
	case "AuditOpenSecureChannelEventType":
		return OpcuaNodeIdServicesObjectType_AuditOpenSecureChannelEventType, true
	case "AuditSessionEventType":
		return OpcuaNodeIdServicesObjectType_AuditSessionEventType, true
	case "AuditCreateSessionEventType":
		return OpcuaNodeIdServicesObjectType_AuditCreateSessionEventType, true
	case "AuditActivateSessionEventType":
		return OpcuaNodeIdServicesObjectType_AuditActivateSessionEventType, true
	case "AuditCancelEventType":
		return OpcuaNodeIdServicesObjectType_AuditCancelEventType, true
	case "AuditCertificateEventType":
		return OpcuaNodeIdServicesObjectType_AuditCertificateEventType, true
	case "AuditCertificateDataMismatchEventType":
		return OpcuaNodeIdServicesObjectType_AuditCertificateDataMismatchEventType, true
	case "AuditCertificateExpiredEventType":
		return OpcuaNodeIdServicesObjectType_AuditCertificateExpiredEventType, true
	case "AuditCertificateInvalidEventType":
		return OpcuaNodeIdServicesObjectType_AuditCertificateInvalidEventType, true
	case "AuditCertificateUntrustedEventType":
		return OpcuaNodeIdServicesObjectType_AuditCertificateUntrustedEventType, true
	case "AuditCertificateRevokedEventType":
		return OpcuaNodeIdServicesObjectType_AuditCertificateRevokedEventType, true
	case "AuditCertificateMismatchEventType":
		return OpcuaNodeIdServicesObjectType_AuditCertificateMismatchEventType, true
	case "AuditNodeManagementEventType":
		return OpcuaNodeIdServicesObjectType_AuditNodeManagementEventType, true
	case "AuditAddNodesEventType":
		return OpcuaNodeIdServicesObjectType_AuditAddNodesEventType, true
	case "AuditDeleteNodesEventType":
		return OpcuaNodeIdServicesObjectType_AuditDeleteNodesEventType, true
	case "AuditAddReferencesEventType":
		return OpcuaNodeIdServicesObjectType_AuditAddReferencesEventType, true
	case "AuditDeleteReferencesEventType":
		return OpcuaNodeIdServicesObjectType_AuditDeleteReferencesEventType, true
	case "AuditUpdateEventType":
		return OpcuaNodeIdServicesObjectType_AuditUpdateEventType, true
	case "AuditWriteUpdateEventType":
		return OpcuaNodeIdServicesObjectType_AuditWriteUpdateEventType, true
	case "AuditHistoryUpdateEventType":
		return OpcuaNodeIdServicesObjectType_AuditHistoryUpdateEventType, true
	case "ReaderGroupTransportType":
		return OpcuaNodeIdServicesObjectType_ReaderGroupTransportType, true
	case "ReaderGroupMessageType":
		return OpcuaNodeIdServicesObjectType_ReaderGroupMessageType, true
	case "DataSetWriterMessageType":
		return OpcuaNodeIdServicesObjectType_DataSetWriterMessageType, true
	case "DataSetReaderMessageType":
		return OpcuaNodeIdServicesObjectType_DataSetReaderMessageType, true
	case "UadpWriterGroupMessageType":
		return OpcuaNodeIdServicesObjectType_UadpWriterGroupMessageType, true
	case "UadpDataSetWriterMessageType":
		return OpcuaNodeIdServicesObjectType_UadpDataSetWriterMessageType, true
	case "UadpDataSetReaderMessageType":
		return OpcuaNodeIdServicesObjectType_UadpDataSetReaderMessageType, true
	case "JsonWriterGroupMessageType":
		return OpcuaNodeIdServicesObjectType_JsonWriterGroupMessageType, true
	case "JsonDataSetWriterMessageType":
		return OpcuaNodeIdServicesObjectType_JsonDataSetWriterMessageType, true
	case "JsonDataSetReaderMessageType":
		return OpcuaNodeIdServicesObjectType_JsonDataSetReaderMessageType, true
	case "DatagramWriterGroupTransportType":
		return OpcuaNodeIdServicesObjectType_DatagramWriterGroupTransportType, true
	case "BrokerWriterGroupTransportType":
		return OpcuaNodeIdServicesObjectType_BrokerWriterGroupTransportType, true
	case "BrokerDataSetWriterTransportType":
		return OpcuaNodeIdServicesObjectType_BrokerDataSetWriterTransportType, true
	case "BrokerDataSetReaderTransportType":
		return OpcuaNodeIdServicesObjectType_BrokerDataSetReaderTransportType, true
	case "NetworkAddressType":
		return OpcuaNodeIdServicesObjectType_NetworkAddressType, true
	case "NetworkAddressUrlType":
		return OpcuaNodeIdServicesObjectType_NetworkAddressUrlType, true
	case "AuditUpdateMethodEventType":
		return OpcuaNodeIdServicesObjectType_AuditUpdateMethodEventType, true
	case "SystemEventType":
		return OpcuaNodeIdServicesObjectType_SystemEventType, true
	case "DeviceFailureEventType":
		return OpcuaNodeIdServicesObjectType_DeviceFailureEventType, true
	case "BaseModelChangeEventType":
		return OpcuaNodeIdServicesObjectType_BaseModelChangeEventType, true
	case "GeneralModelChangeEventType":
		return OpcuaNodeIdServicesObjectType_GeneralModelChangeEventType, true
	case "StateMachineType":
		return OpcuaNodeIdServicesObjectType_StateMachineType, true
	case "StateType":
		return OpcuaNodeIdServicesObjectType_StateType, true
	case "InitialStateType":
		return OpcuaNodeIdServicesObjectType_InitialStateType, true
	case "TransitionType":
		return OpcuaNodeIdServicesObjectType_TransitionType, true
	case "TransitionEventType":
		return OpcuaNodeIdServicesObjectType_TransitionEventType, true
	case "AuditUpdateStateEventType":
		return OpcuaNodeIdServicesObjectType_AuditUpdateStateEventType, true
	case "HistoricalDataConfigurationType":
		return OpcuaNodeIdServicesObjectType_HistoricalDataConfigurationType, true
	case "HistoryServerCapabilitiesType":
		return OpcuaNodeIdServicesObjectType_HistoryServerCapabilitiesType, true
	case "AggregateFunctionType":
		return OpcuaNodeIdServicesObjectType_AggregateFunctionType, true
	case "AliasNameType":
		return OpcuaNodeIdServicesObjectType_AliasNameType, true
	case "AliasNameCategoryType":
		return OpcuaNodeIdServicesObjectType_AliasNameCategoryType, true
	case "IOrderedObjectType":
		return OpcuaNodeIdServicesObjectType_IOrderedObjectType, true
	case "OrderedListType":
		return OpcuaNodeIdServicesObjectType_OrderedListType, true
	case "EccApplicationCertificateType":
		return OpcuaNodeIdServicesObjectType_EccApplicationCertificateType, true
	case "EccNistP256ApplicationCertificateType":
		return OpcuaNodeIdServicesObjectType_EccNistP256ApplicationCertificateType, true
	case "EccNistP384ApplicationCertificateType":
		return OpcuaNodeIdServicesObjectType_EccNistP384ApplicationCertificateType, true
	case "EccBrainpoolP256r1ApplicationCertificateType":
		return OpcuaNodeIdServicesObjectType_EccBrainpoolP256r1ApplicationCertificateType, true
	case "EccBrainpoolP384r1ApplicationCertificateType":
		return OpcuaNodeIdServicesObjectType_EccBrainpoolP384r1ApplicationCertificateType, true
	case "EccCurve25519ApplicationCertificateType":
		return OpcuaNodeIdServicesObjectType_EccCurve25519ApplicationCertificateType, true
	case "EccCurve448ApplicationCertificateType":
		return OpcuaNodeIdServicesObjectType_EccCurve448ApplicationCertificateType, true
	case "AuthorizationServicesConfigurationFolderType":
		return OpcuaNodeIdServicesObjectType_AuthorizationServicesConfigurationFolderType, true
	case "AuditClientEventType":
		return OpcuaNodeIdServicesObjectType_AuditClientEventType, true
	case "ProgramTransitionEventType":
		return OpcuaNodeIdServicesObjectType_ProgramTransitionEventType, true
	case "SubscribedDataSetFolderType":
		return OpcuaNodeIdServicesObjectType_SubscribedDataSetFolderType, true
	case "StandaloneSubscribedDataSetType":
		return OpcuaNodeIdServicesObjectType_StandaloneSubscribedDataSetType, true
	case "PubSubCapabilitiesType":
		return OpcuaNodeIdServicesObjectType_PubSubCapabilitiesType, true
	case "ProgramStateMachineType":
		return OpcuaNodeIdServicesObjectType_ProgramStateMachineType, true
	case "AuditClientUpdateMethodResultEventType":
		return OpcuaNodeIdServicesObjectType_AuditClientUpdateMethodResultEventType, true
	case "DatagramDataSetReaderTransportType":
		return OpcuaNodeIdServicesObjectType_DatagramDataSetReaderTransportType, true
	case "IIetfBaseNetworkInterfaceType":
		return OpcuaNodeIdServicesObjectType_IIetfBaseNetworkInterfaceType, true
	case "IIeeeBaseEthernetPortType":
		return OpcuaNodeIdServicesObjectType_IIeeeBaseEthernetPortType, true
	case "IBaseEthernetCapabilitiesType":
		return OpcuaNodeIdServicesObjectType_IBaseEthernetCapabilitiesType, true
	case "ISrClassType":
		return OpcuaNodeIdServicesObjectType_ISrClassType, true
	case "IIeeeBaseTsnStreamType":
		return OpcuaNodeIdServicesObjectType_IIeeeBaseTsnStreamType, true
	case "IIeeeBaseTsnTrafficSpecificationType":
		return OpcuaNodeIdServicesObjectType_IIeeeBaseTsnTrafficSpecificationType, true
	case "IIeeeBaseTsnStatusStreamType":
		return OpcuaNodeIdServicesObjectType_IIeeeBaseTsnStatusStreamType, true
	case "IIeeeTsnInterfaceConfigurationType":
		return OpcuaNodeIdServicesObjectType_IIeeeTsnInterfaceConfigurationType, true
	case "IIeeeTsnInterfaceConfigurationTalkerType":
		return OpcuaNodeIdServicesObjectType_IIeeeTsnInterfaceConfigurationTalkerType, true
	case "IIeeeTsnInterfaceConfigurationListenerType":
		return OpcuaNodeIdServicesObjectType_IIeeeTsnInterfaceConfigurationListenerType, true
	case "IIeeeTsnMacAddressType":
		return OpcuaNodeIdServicesObjectType_IIeeeTsnMacAddressType, true
	case "IIeeeTsnVlanTagType":
		return OpcuaNodeIdServicesObjectType_IIeeeTsnVlanTagType, true
	case "IPriorityMappingEntryType":
		return OpcuaNodeIdServicesObjectType_IPriorityMappingEntryType, true
	case "IIeeeAutoNegotiationStatusType":
		return OpcuaNodeIdServicesObjectType_IIeeeAutoNegotiationStatusType, true
	case "UserManagementType":
		return OpcuaNodeIdServicesObjectType_UserManagementType, true
	case "IVlanIdType":
		return OpcuaNodeIdServicesObjectType_IVlanIdType, true
	case "IetfBaseNetworkInterfaceType":
		return OpcuaNodeIdServicesObjectType_IetfBaseNetworkInterfaceType, true
	case "PriorityMappingTableType":
		return OpcuaNodeIdServicesObjectType_PriorityMappingTableType, true
	case "PubSubKeyPushTargetType":
		return OpcuaNodeIdServicesObjectType_PubSubKeyPushTargetType, true
	case "PubSubKeyPushTargetFolderType":
		return OpcuaNodeIdServicesObjectType_PubSubKeyPushTargetFolderType, true
	case "PubSubConfigurationType":
		return OpcuaNodeIdServicesObjectType_PubSubConfigurationType, true
	case "ApplicationConfigurationType":
		return OpcuaNodeIdServicesObjectType_ApplicationConfigurationType, true
	case "ProvisionableDeviceType":
		return OpcuaNodeIdServicesObjectType_ProvisionableDeviceType, true
	case "SemanticChangeEventType":
		return OpcuaNodeIdServicesObjectType_SemanticChangeEventType, true
	case "AuditUrlMismatchEventType":
		return OpcuaNodeIdServicesObjectType_AuditUrlMismatchEventType, true
	case "FiniteStateMachineType":
		return OpcuaNodeIdServicesObjectType_FiniteStateMachineType, true
	case "ConditionType":
		return OpcuaNodeIdServicesObjectType_ConditionType, true
	case "RefreshStartEventType":
		return OpcuaNodeIdServicesObjectType_RefreshStartEventType, true
	case "RefreshEndEventType":
		return OpcuaNodeIdServicesObjectType_RefreshEndEventType, true
	case "RefreshRequiredEventType":
		return OpcuaNodeIdServicesObjectType_RefreshRequiredEventType, true
	case "AuditConditionEventType":
		return OpcuaNodeIdServicesObjectType_AuditConditionEventType, true
	case "AuditConditionEnableEventType":
		return OpcuaNodeIdServicesObjectType_AuditConditionEnableEventType, true
	case "AuditConditionCommentEventType":
		return OpcuaNodeIdServicesObjectType_AuditConditionCommentEventType, true
	case "DialogConditionType":
		return OpcuaNodeIdServicesObjectType_DialogConditionType, true
	case "AcknowledgeableConditionType":
		return OpcuaNodeIdServicesObjectType_AcknowledgeableConditionType, true
	case "AlarmConditionType":
		return OpcuaNodeIdServicesObjectType_AlarmConditionType, true
	case "ShelvedStateMachineType":
		return OpcuaNodeIdServicesObjectType_ShelvedStateMachineType, true
	case "LimitAlarmType":
		return OpcuaNodeIdServicesObjectType_LimitAlarmType, true
	case "AuditHistoryEventUpdateEventType":
		return OpcuaNodeIdServicesObjectType_AuditHistoryEventUpdateEventType, true
	case "AuditHistoryValueUpdateEventType":
		return OpcuaNodeIdServicesObjectType_AuditHistoryValueUpdateEventType, true
	case "AuditHistoryDeleteEventType":
		return OpcuaNodeIdServicesObjectType_AuditHistoryDeleteEventType, true
	case "AuditHistoryRawModifyDeleteEventType":
		return OpcuaNodeIdServicesObjectType_AuditHistoryRawModifyDeleteEventType, true
	case "AuditHistoryAtTimeDeleteEventType":
		return OpcuaNodeIdServicesObjectType_AuditHistoryAtTimeDeleteEventType, true
	case "AuditHistoryEventDeleteEventType":
		return OpcuaNodeIdServicesObjectType_AuditHistoryEventDeleteEventType, true
	case "EventQueueOverflowEventType":
		return OpcuaNodeIdServicesObjectType_EventQueueOverflowEventType, true
	case "AlarmSuppressionGroupType":
		return OpcuaNodeIdServicesObjectType_AlarmSuppressionGroupType, true
	case "TrustListUpdateRequestedAuditEventType":
		return OpcuaNodeIdServicesObjectType_TrustListUpdateRequestedAuditEventType, true
	case "TransactionDiagnosticsType":
		return OpcuaNodeIdServicesObjectType_TransactionDiagnosticsType, true
	case "CertificateUpdateRequestedAuditEventType":
		return OpcuaNodeIdServicesObjectType_CertificateUpdateRequestedAuditEventType, true
	case "NonTransparentBackupRedundancyType":
		return OpcuaNodeIdServicesObjectType_NonTransparentBackupRedundancyType, true
	case "SyntaxReferenceEntryType":
		return OpcuaNodeIdServicesObjectType_SyntaxReferenceEntryType, true
	case "UnitType":
		return OpcuaNodeIdServicesObjectType_UnitType, true
	case "ServerUnitType":
		return OpcuaNodeIdServicesObjectType_ServerUnitType, true
	case "AlternativeUnitType":
		return OpcuaNodeIdServicesObjectType_AlternativeUnitType, true
	case "QuantityType":
		return OpcuaNodeIdServicesObjectType_QuantityType, true
	case "QuantitiesFolderType":
		return OpcuaNodeIdServicesObjectType_QuantitiesFolderType, true
	case "HistoricalEventConfigurationType":
		return OpcuaNodeIdServicesObjectType_HistoricalEventConfigurationType, true
	case "HistoricalExternalEventSourceType":
		return OpcuaNodeIdServicesObjectType_HistoricalExternalEventSourceType, true
	case "AuditHistoryConfigurationChangeEventType":
		return OpcuaNodeIdServicesObjectType_AuditHistoryConfigurationChangeEventType, true
	case "AuditHistoryBulkInsertEventType":
		return OpcuaNodeIdServicesObjectType_AuditHistoryBulkInsertEventType, true
	case "ProgramTransitionAuditEventType":
		return OpcuaNodeIdServicesObjectType_ProgramTransitionAuditEventType, true
	case "BaseObjectType":
		return OpcuaNodeIdServicesObjectType_BaseObjectType, true
	case "FolderType":
		return OpcuaNodeIdServicesObjectType_FolderType, true
	case "DataTypeSystemType":
		return OpcuaNodeIdServicesObjectType_DataTypeSystemType, true
	case "DataTypeEncodingType":
		return OpcuaNodeIdServicesObjectType_DataTypeEncodingType, true
	case "ModellingRuleType":
		return OpcuaNodeIdServicesObjectType_ModellingRuleType, true
	case "AuditConditionRespondEventType":
		return OpcuaNodeIdServicesObjectType_AuditConditionRespondEventType, true
	case "AuditConditionAcknowledgeEventType":
		return OpcuaNodeIdServicesObjectType_AuditConditionAcknowledgeEventType, true
	case "AuditConditionConfirmEventType":
		return OpcuaNodeIdServicesObjectType_AuditConditionConfirmEventType, true
	case "ExclusiveLimitStateMachineType":
		return OpcuaNodeIdServicesObjectType_ExclusiveLimitStateMachineType, true
	case "ExclusiveLimitAlarmType":
		return OpcuaNodeIdServicesObjectType_ExclusiveLimitAlarmType, true
	case "ExclusiveLevelAlarmType":
		return OpcuaNodeIdServicesObjectType_ExclusiveLevelAlarmType, true
	case "ExclusiveRateOfChangeAlarmType":
		return OpcuaNodeIdServicesObjectType_ExclusiveRateOfChangeAlarmType, true
	case "ExclusiveDeviationAlarmType":
		return OpcuaNodeIdServicesObjectType_ExclusiveDeviationAlarmType, true
	case "NonExclusiveLimitAlarmType":
		return OpcuaNodeIdServicesObjectType_NonExclusiveLimitAlarmType, true
	}
	return 0, false
}

func OpcuaNodeIdServicesObjectTypeKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesObjectTypeValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesObjectType(structType any) OpcuaNodeIdServicesObjectType {
	castFunc := func(typ any) OpcuaNodeIdServicesObjectType {
		if sOpcuaNodeIdServicesObjectType, ok := typ.(OpcuaNodeIdServicesObjectType); ok {
			return sOpcuaNodeIdServicesObjectType
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesObjectType) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesObjectType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesObjectTypeParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesObjectType, error) {
	return OpcuaNodeIdServicesObjectTypeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesObjectTypeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesObjectType, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesObjectType", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesObjectType")
	}
	if enum, ok := OpcuaNodeIdServicesObjectTypeByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesObjectType")
		return OpcuaNodeIdServicesObjectType(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesObjectType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesObjectType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesObjectType", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesObjectType) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesObjectType_NonExclusiveLevelAlarmType:
		return "NonExclusiveLevelAlarmType"
	case OpcuaNodeIdServicesObjectType_NonExclusiveRateOfChangeAlarmType:
		return "NonExclusiveRateOfChangeAlarmType"
	case OpcuaNodeIdServicesObjectType_NonExclusiveDeviationAlarmType:
		return "NonExclusiveDeviationAlarmType"
	case OpcuaNodeIdServicesObjectType_DiscreteAlarmType:
		return "DiscreteAlarmType"
	case OpcuaNodeIdServicesObjectType_OffNormalAlarmType:
		return "OffNormalAlarmType"
	case OpcuaNodeIdServicesObjectType_TripAlarmType:
		return "TripAlarmType"
	case OpcuaNodeIdServicesObjectType_AuditConditionShelvingEventType:
		return "AuditConditionShelvingEventType"
	case OpcuaNodeIdServicesObjectType_BaseConditionClassType:
		return "BaseConditionClassType"
	case OpcuaNodeIdServicesObjectType_ProcessConditionClassType:
		return "ProcessConditionClassType"
	case OpcuaNodeIdServicesObjectType_MaintenanceConditionClassType:
		return "MaintenanceConditionClassType"
	case OpcuaNodeIdServicesObjectType_SystemConditionClassType:
		return "SystemConditionClassType"
	case OpcuaNodeIdServicesObjectType_AggregateConfigurationType:
		return "AggregateConfigurationType"
	case OpcuaNodeIdServicesObjectType_ProgressEventType:
		return "ProgressEventType"
	case OpcuaNodeIdServicesObjectType_SystemStatusChangeEventType:
		return "SystemStatusChangeEventType"
	case OpcuaNodeIdServicesObjectType_OperationLimitsType:
		return "OperationLimitsType"
	case OpcuaNodeIdServicesObjectType_FileType:
		return "FileType"
	case OpcuaNodeIdServicesObjectType_AddressSpaceFileType:
		return "AddressSpaceFileType"
	case OpcuaNodeIdServicesObjectType_NamespaceMetadataType:
		return "NamespaceMetadataType"
	case OpcuaNodeIdServicesObjectType_NamespacesType:
		return "NamespacesType"
	case OpcuaNodeIdServicesObjectType_SystemOffNormalAlarmType:
		return "SystemOffNormalAlarmType"
	case OpcuaNodeIdServicesObjectType_AuditProgramTransitionEventType:
		return "AuditProgramTransitionEventType"
	case OpcuaNodeIdServicesObjectType_NonTransparentNetworkRedundancyType:
		return "NonTransparentNetworkRedundancyType"
	case OpcuaNodeIdServicesObjectType_TrustListType:
		return "TrustListType"
	case OpcuaNodeIdServicesObjectType_CertificateGroupType:
		return "CertificateGroupType"
	case OpcuaNodeIdServicesObjectType_CertificateType:
		return "CertificateType"
	case OpcuaNodeIdServicesObjectType_ApplicationCertificateType:
		return "ApplicationCertificateType"
	case OpcuaNodeIdServicesObjectType_HttpsCertificateType:
		return "HttpsCertificateType"
	case OpcuaNodeIdServicesObjectType_RsaMinApplicationCertificateType:
		return "RsaMinApplicationCertificateType"
	case OpcuaNodeIdServicesObjectType_RsaSha256ApplicationCertificateType:
		return "RsaSha256ApplicationCertificateType"
	case OpcuaNodeIdServicesObjectType_TrustListUpdatedAuditEventType:
		return "TrustListUpdatedAuditEventType"
	case OpcuaNodeIdServicesObjectType_ServerConfigurationType:
		return "ServerConfigurationType"
	case OpcuaNodeIdServicesObjectType_CertificateUpdatedAuditEventType:
		return "CertificateUpdatedAuditEventType"
	case OpcuaNodeIdServicesObjectType_CertificateExpirationAlarmType:
		return "CertificateExpirationAlarmType"
	case OpcuaNodeIdServicesObjectType_FileDirectoryType:
		return "FileDirectoryType"
	case OpcuaNodeIdServicesObjectType_CertificateGroupFolderType:
		return "CertificateGroupFolderType"
	case OpcuaNodeIdServicesObjectType_PubSubConnectionType:
		return "PubSubConnectionType"
	case OpcuaNodeIdServicesObjectType_PubSubGroupType:
		return "PubSubGroupType"
	case OpcuaNodeIdServicesObjectType_PublishSubscribeType:
		return "PublishSubscribeType"
	case OpcuaNodeIdServicesObjectType_DataSetFolderType:
		return "DataSetFolderType"
	case OpcuaNodeIdServicesObjectType_PublishedDataSetType:
		return "PublishedDataSetType"
	case OpcuaNodeIdServicesObjectType_PublishedDataItemsType:
		return "PublishedDataItemsType"
	case OpcuaNodeIdServicesObjectType_PublishedEventsType:
		return "PublishedEventsType"
	case OpcuaNodeIdServicesObjectType_PubSubStatusType:
		return "PubSubStatusType"
	case OpcuaNodeIdServicesObjectType_AuditConditionResetEventType:
		return "AuditConditionResetEventType"
	case OpcuaNodeIdServicesObjectType_DatagramConnectionTransportType:
		return "DatagramConnectionTransportType"
	case OpcuaNodeIdServicesObjectType_SubscribedDataSetType:
		return "SubscribedDataSetType"
	case OpcuaNodeIdServicesObjectType_ChoiceStateType:
		return "ChoiceStateType"
	case OpcuaNodeIdServicesObjectType_TargetVariablesType:
		return "TargetVariablesType"
	case OpcuaNodeIdServicesObjectType_SubscribedDataSetMirrorType:
		return "SubscribedDataSetMirrorType"
	case OpcuaNodeIdServicesObjectType_BrokerConnectionTransportType:
		return "BrokerConnectionTransportType"
	case OpcuaNodeIdServicesObjectType_UserCredentialCertificateType:
		return "UserCredentialCertificateType"
	case OpcuaNodeIdServicesObjectType_DataSetWriterType:
		return "DataSetWriterType"
	case OpcuaNodeIdServicesObjectType_DataSetWriterTransportType:
		return "DataSetWriterTransportType"
	case OpcuaNodeIdServicesObjectType_DataSetReaderType:
		return "DataSetReaderType"
	case OpcuaNodeIdServicesObjectType_DataSetReaderTransportType:
		return "DataSetReaderTransportType"
	case OpcuaNodeIdServicesObjectType_SecurityGroupFolderType:
		return "SecurityGroupFolderType"
	case OpcuaNodeIdServicesObjectType_SecurityGroupType:
		return "SecurityGroupType"
	case OpcuaNodeIdServicesObjectType_ExtensionFieldsType:
		return "ExtensionFieldsType"
	case OpcuaNodeIdServicesObjectType_PubSubStatusEventType:
		return "PubSubStatusEventType"
	case OpcuaNodeIdServicesObjectType_PubSubTransportLimitsExceedEventType:
		return "PubSubTransportLimitsExceedEventType"
	case OpcuaNodeIdServicesObjectType_PubSubCommunicationFailureEventType:
		return "PubSubCommunicationFailureEventType"
	case OpcuaNodeIdServicesObjectType_RoleSetType:
		return "RoleSetType"
	case OpcuaNodeIdServicesObjectType_RoleType:
		return "RoleType"
	case OpcuaNodeIdServicesObjectType_TemporaryFileTransferType:
		return "TemporaryFileTransferType"
	case OpcuaNodeIdServicesObjectType_FileTransferStateMachineType:
		return "FileTransferStateMachineType"
	case OpcuaNodeIdServicesObjectType_PubSubKeyServiceType:
		return "PubSubKeyServiceType"
	case OpcuaNodeIdServicesObjectType_AlarmGroupType:
		return "AlarmGroupType"
	case OpcuaNodeIdServicesObjectType_DiscrepancyAlarmType:
		return "DiscrepancyAlarmType"
	case OpcuaNodeIdServicesObjectType_SafetyConditionClassType:
		return "SafetyConditionClassType"
	case OpcuaNodeIdServicesObjectType_HighlyManagedAlarmConditionClassType:
		return "HighlyManagedAlarmConditionClassType"
	case OpcuaNodeIdServicesObjectType_TrainingConditionClassType:
		return "TrainingConditionClassType"
	case OpcuaNodeIdServicesObjectType_TestingConditionClassType:
		return "TestingConditionClassType"
	case OpcuaNodeIdServicesObjectType_AuditConditionSuppressionEventType:
		return "AuditConditionSuppressionEventType"
	case OpcuaNodeIdServicesObjectType_AuditConditionSilenceEventType:
		return "AuditConditionSilenceEventType"
	case OpcuaNodeIdServicesObjectType_AuditConditionOutOfServiceEventType:
		return "AuditConditionOutOfServiceEventType"
	case OpcuaNodeIdServicesObjectType_AlarmMetricsType:
		return "AlarmMetricsType"
	case OpcuaNodeIdServicesObjectType_KeyCredentialConfigurationFolderType:
		return "KeyCredentialConfigurationFolderType"
	case OpcuaNodeIdServicesObjectType_DictionaryEntryType:
		return "DictionaryEntryType"
	case OpcuaNodeIdServicesObjectType_DictionaryFolderType:
		return "DictionaryFolderType"
	case OpcuaNodeIdServicesObjectType_IrdiDictionaryEntryType:
		return "IrdiDictionaryEntryType"
	case OpcuaNodeIdServicesObjectType_UriDictionaryEntryType:
		return "UriDictionaryEntryType"
	case OpcuaNodeIdServicesObjectType_BaseInterfaceType:
		return "BaseInterfaceType"
	case OpcuaNodeIdServicesObjectType_RoleMappingRuleChangedAuditEventType:
		return "RoleMappingRuleChangedAuditEventType"
	case OpcuaNodeIdServicesObjectType_ConnectionTransportType:
		return "ConnectionTransportType"
	case OpcuaNodeIdServicesObjectType_WriterGroupType:
		return "WriterGroupType"
	case OpcuaNodeIdServicesObjectType_AuthorizationServiceConfigurationType:
		return "AuthorizationServiceConfigurationType"
	case OpcuaNodeIdServicesObjectType_WriterGroupTransportType:
		return "WriterGroupTransportType"
	case OpcuaNodeIdServicesObjectType_WriterGroupMessageType:
		return "WriterGroupMessageType"
	case OpcuaNodeIdServicesObjectType_ReaderGroupType:
		return "ReaderGroupType"
	case OpcuaNodeIdServicesObjectType_KeyCredentialConfigurationType:
		return "KeyCredentialConfigurationType"
	case OpcuaNodeIdServicesObjectType_KeyCredentialAuditEventType:
		return "KeyCredentialAuditEventType"
	case OpcuaNodeIdServicesObjectType_KeyCredentialUpdatedAuditEventType:
		return "KeyCredentialUpdatedAuditEventType"
	case OpcuaNodeIdServicesObjectType_KeyCredentialDeletedAuditEventType:
		return "KeyCredentialDeletedAuditEventType"
	case OpcuaNodeIdServicesObjectType_InstrumentDiagnosticAlarmType:
		return "InstrumentDiagnosticAlarmType"
	case OpcuaNodeIdServicesObjectType_SystemDiagnosticAlarmType:
		return "SystemDiagnosticAlarmType"
	case OpcuaNodeIdServicesObjectType_StatisticalConditionClassType:
		return "StatisticalConditionClassType"
	case OpcuaNodeIdServicesObjectType_AuditHistoryAnnotationUpdateEventType:
		return "AuditHistoryAnnotationUpdateEventType"
	case OpcuaNodeIdServicesObjectType_TrustListOutOfDateAlarmType:
		return "TrustListOutOfDateAlarmType"
	case OpcuaNodeIdServicesObjectType_PubSubDiagnosticsType:
		return "PubSubDiagnosticsType"
	case OpcuaNodeIdServicesObjectType_PubSubDiagnosticsRootType:
		return "PubSubDiagnosticsRootType"
	case OpcuaNodeIdServicesObjectType_PubSubDiagnosticsConnectionType:
		return "PubSubDiagnosticsConnectionType"
	case OpcuaNodeIdServicesObjectType_PubSubDiagnosticsWriterGroupType:
		return "PubSubDiagnosticsWriterGroupType"
	case OpcuaNodeIdServicesObjectType_PubSubDiagnosticsReaderGroupType:
		return "PubSubDiagnosticsReaderGroupType"
	case OpcuaNodeIdServicesObjectType_PubSubDiagnosticsDataSetWriterType:
		return "PubSubDiagnosticsDataSetWriterType"
	case OpcuaNodeIdServicesObjectType_PubSubDiagnosticsDataSetReaderType:
		return "PubSubDiagnosticsDataSetReaderType"
	case OpcuaNodeIdServicesObjectType_ServerType:
		return "ServerType"
	case OpcuaNodeIdServicesObjectType_ServerCapabilitiesType:
		return "ServerCapabilitiesType"
	case OpcuaNodeIdServicesObjectType_ServerDiagnosticsType:
		return "ServerDiagnosticsType"
	case OpcuaNodeIdServicesObjectType_SessionsDiagnosticsSummaryType:
		return "SessionsDiagnosticsSummaryType"
	case OpcuaNodeIdServicesObjectType_SessionDiagnosticsObjectType:
		return "SessionDiagnosticsObjectType"
	case OpcuaNodeIdServicesObjectType_VendorServerInfoType:
		return "VendorServerInfoType"
	case OpcuaNodeIdServicesObjectType_ServerRedundancyType:
		return "ServerRedundancyType"
	case OpcuaNodeIdServicesObjectType_TransparentRedundancyType:
		return "TransparentRedundancyType"
	case OpcuaNodeIdServicesObjectType_NonTransparentRedundancyType:
		return "NonTransparentRedundancyType"
	case OpcuaNodeIdServicesObjectType_BaseEventType:
		return "BaseEventType"
	case OpcuaNodeIdServicesObjectType_AuditEventType:
		return "AuditEventType"
	case OpcuaNodeIdServicesObjectType_AuditSecurityEventType:
		return "AuditSecurityEventType"
	case OpcuaNodeIdServicesObjectType_AuditChannelEventType:
		return "AuditChannelEventType"
	case OpcuaNodeIdServicesObjectType_AuditOpenSecureChannelEventType:
		return "AuditOpenSecureChannelEventType"
	case OpcuaNodeIdServicesObjectType_AuditSessionEventType:
		return "AuditSessionEventType"
	case OpcuaNodeIdServicesObjectType_AuditCreateSessionEventType:
		return "AuditCreateSessionEventType"
	case OpcuaNodeIdServicesObjectType_AuditActivateSessionEventType:
		return "AuditActivateSessionEventType"
	case OpcuaNodeIdServicesObjectType_AuditCancelEventType:
		return "AuditCancelEventType"
	case OpcuaNodeIdServicesObjectType_AuditCertificateEventType:
		return "AuditCertificateEventType"
	case OpcuaNodeIdServicesObjectType_AuditCertificateDataMismatchEventType:
		return "AuditCertificateDataMismatchEventType"
	case OpcuaNodeIdServicesObjectType_AuditCertificateExpiredEventType:
		return "AuditCertificateExpiredEventType"
	case OpcuaNodeIdServicesObjectType_AuditCertificateInvalidEventType:
		return "AuditCertificateInvalidEventType"
	case OpcuaNodeIdServicesObjectType_AuditCertificateUntrustedEventType:
		return "AuditCertificateUntrustedEventType"
	case OpcuaNodeIdServicesObjectType_AuditCertificateRevokedEventType:
		return "AuditCertificateRevokedEventType"
	case OpcuaNodeIdServicesObjectType_AuditCertificateMismatchEventType:
		return "AuditCertificateMismatchEventType"
	case OpcuaNodeIdServicesObjectType_AuditNodeManagementEventType:
		return "AuditNodeManagementEventType"
	case OpcuaNodeIdServicesObjectType_AuditAddNodesEventType:
		return "AuditAddNodesEventType"
	case OpcuaNodeIdServicesObjectType_AuditDeleteNodesEventType:
		return "AuditDeleteNodesEventType"
	case OpcuaNodeIdServicesObjectType_AuditAddReferencesEventType:
		return "AuditAddReferencesEventType"
	case OpcuaNodeIdServicesObjectType_AuditDeleteReferencesEventType:
		return "AuditDeleteReferencesEventType"
	case OpcuaNodeIdServicesObjectType_AuditUpdateEventType:
		return "AuditUpdateEventType"
	case OpcuaNodeIdServicesObjectType_AuditWriteUpdateEventType:
		return "AuditWriteUpdateEventType"
	case OpcuaNodeIdServicesObjectType_AuditHistoryUpdateEventType:
		return "AuditHistoryUpdateEventType"
	case OpcuaNodeIdServicesObjectType_ReaderGroupTransportType:
		return "ReaderGroupTransportType"
	case OpcuaNodeIdServicesObjectType_ReaderGroupMessageType:
		return "ReaderGroupMessageType"
	case OpcuaNodeIdServicesObjectType_DataSetWriterMessageType:
		return "DataSetWriterMessageType"
	case OpcuaNodeIdServicesObjectType_DataSetReaderMessageType:
		return "DataSetReaderMessageType"
	case OpcuaNodeIdServicesObjectType_UadpWriterGroupMessageType:
		return "UadpWriterGroupMessageType"
	case OpcuaNodeIdServicesObjectType_UadpDataSetWriterMessageType:
		return "UadpDataSetWriterMessageType"
	case OpcuaNodeIdServicesObjectType_UadpDataSetReaderMessageType:
		return "UadpDataSetReaderMessageType"
	case OpcuaNodeIdServicesObjectType_JsonWriterGroupMessageType:
		return "JsonWriterGroupMessageType"
	case OpcuaNodeIdServicesObjectType_JsonDataSetWriterMessageType:
		return "JsonDataSetWriterMessageType"
	case OpcuaNodeIdServicesObjectType_JsonDataSetReaderMessageType:
		return "JsonDataSetReaderMessageType"
	case OpcuaNodeIdServicesObjectType_DatagramWriterGroupTransportType:
		return "DatagramWriterGroupTransportType"
	case OpcuaNodeIdServicesObjectType_BrokerWriterGroupTransportType:
		return "BrokerWriterGroupTransportType"
	case OpcuaNodeIdServicesObjectType_BrokerDataSetWriterTransportType:
		return "BrokerDataSetWriterTransportType"
	case OpcuaNodeIdServicesObjectType_BrokerDataSetReaderTransportType:
		return "BrokerDataSetReaderTransportType"
	case OpcuaNodeIdServicesObjectType_NetworkAddressType:
		return "NetworkAddressType"
	case OpcuaNodeIdServicesObjectType_NetworkAddressUrlType:
		return "NetworkAddressUrlType"
	case OpcuaNodeIdServicesObjectType_AuditUpdateMethodEventType:
		return "AuditUpdateMethodEventType"
	case OpcuaNodeIdServicesObjectType_SystemEventType:
		return "SystemEventType"
	case OpcuaNodeIdServicesObjectType_DeviceFailureEventType:
		return "DeviceFailureEventType"
	case OpcuaNodeIdServicesObjectType_BaseModelChangeEventType:
		return "BaseModelChangeEventType"
	case OpcuaNodeIdServicesObjectType_GeneralModelChangeEventType:
		return "GeneralModelChangeEventType"
	case OpcuaNodeIdServicesObjectType_StateMachineType:
		return "StateMachineType"
	case OpcuaNodeIdServicesObjectType_StateType:
		return "StateType"
	case OpcuaNodeIdServicesObjectType_InitialStateType:
		return "InitialStateType"
	case OpcuaNodeIdServicesObjectType_TransitionType:
		return "TransitionType"
	case OpcuaNodeIdServicesObjectType_TransitionEventType:
		return "TransitionEventType"
	case OpcuaNodeIdServicesObjectType_AuditUpdateStateEventType:
		return "AuditUpdateStateEventType"
	case OpcuaNodeIdServicesObjectType_HistoricalDataConfigurationType:
		return "HistoricalDataConfigurationType"
	case OpcuaNodeIdServicesObjectType_HistoryServerCapabilitiesType:
		return "HistoryServerCapabilitiesType"
	case OpcuaNodeIdServicesObjectType_AggregateFunctionType:
		return "AggregateFunctionType"
	case OpcuaNodeIdServicesObjectType_AliasNameType:
		return "AliasNameType"
	case OpcuaNodeIdServicesObjectType_AliasNameCategoryType:
		return "AliasNameCategoryType"
	case OpcuaNodeIdServicesObjectType_IOrderedObjectType:
		return "IOrderedObjectType"
	case OpcuaNodeIdServicesObjectType_OrderedListType:
		return "OrderedListType"
	case OpcuaNodeIdServicesObjectType_EccApplicationCertificateType:
		return "EccApplicationCertificateType"
	case OpcuaNodeIdServicesObjectType_EccNistP256ApplicationCertificateType:
		return "EccNistP256ApplicationCertificateType"
	case OpcuaNodeIdServicesObjectType_EccNistP384ApplicationCertificateType:
		return "EccNistP384ApplicationCertificateType"
	case OpcuaNodeIdServicesObjectType_EccBrainpoolP256r1ApplicationCertificateType:
		return "EccBrainpoolP256r1ApplicationCertificateType"
	case OpcuaNodeIdServicesObjectType_EccBrainpoolP384r1ApplicationCertificateType:
		return "EccBrainpoolP384r1ApplicationCertificateType"
	case OpcuaNodeIdServicesObjectType_EccCurve25519ApplicationCertificateType:
		return "EccCurve25519ApplicationCertificateType"
	case OpcuaNodeIdServicesObjectType_EccCurve448ApplicationCertificateType:
		return "EccCurve448ApplicationCertificateType"
	case OpcuaNodeIdServicesObjectType_AuthorizationServicesConfigurationFolderType:
		return "AuthorizationServicesConfigurationFolderType"
	case OpcuaNodeIdServicesObjectType_AuditClientEventType:
		return "AuditClientEventType"
	case OpcuaNodeIdServicesObjectType_ProgramTransitionEventType:
		return "ProgramTransitionEventType"
	case OpcuaNodeIdServicesObjectType_SubscribedDataSetFolderType:
		return "SubscribedDataSetFolderType"
	case OpcuaNodeIdServicesObjectType_StandaloneSubscribedDataSetType:
		return "StandaloneSubscribedDataSetType"
	case OpcuaNodeIdServicesObjectType_PubSubCapabilitiesType:
		return "PubSubCapabilitiesType"
	case OpcuaNodeIdServicesObjectType_ProgramStateMachineType:
		return "ProgramStateMachineType"
	case OpcuaNodeIdServicesObjectType_AuditClientUpdateMethodResultEventType:
		return "AuditClientUpdateMethodResultEventType"
	case OpcuaNodeIdServicesObjectType_DatagramDataSetReaderTransportType:
		return "DatagramDataSetReaderTransportType"
	case OpcuaNodeIdServicesObjectType_IIetfBaseNetworkInterfaceType:
		return "IIetfBaseNetworkInterfaceType"
	case OpcuaNodeIdServicesObjectType_IIeeeBaseEthernetPortType:
		return "IIeeeBaseEthernetPortType"
	case OpcuaNodeIdServicesObjectType_IBaseEthernetCapabilitiesType:
		return "IBaseEthernetCapabilitiesType"
	case OpcuaNodeIdServicesObjectType_ISrClassType:
		return "ISrClassType"
	case OpcuaNodeIdServicesObjectType_IIeeeBaseTsnStreamType:
		return "IIeeeBaseTsnStreamType"
	case OpcuaNodeIdServicesObjectType_IIeeeBaseTsnTrafficSpecificationType:
		return "IIeeeBaseTsnTrafficSpecificationType"
	case OpcuaNodeIdServicesObjectType_IIeeeBaseTsnStatusStreamType:
		return "IIeeeBaseTsnStatusStreamType"
	case OpcuaNodeIdServicesObjectType_IIeeeTsnInterfaceConfigurationType:
		return "IIeeeTsnInterfaceConfigurationType"
	case OpcuaNodeIdServicesObjectType_IIeeeTsnInterfaceConfigurationTalkerType:
		return "IIeeeTsnInterfaceConfigurationTalkerType"
	case OpcuaNodeIdServicesObjectType_IIeeeTsnInterfaceConfigurationListenerType:
		return "IIeeeTsnInterfaceConfigurationListenerType"
	case OpcuaNodeIdServicesObjectType_IIeeeTsnMacAddressType:
		return "IIeeeTsnMacAddressType"
	case OpcuaNodeIdServicesObjectType_IIeeeTsnVlanTagType:
		return "IIeeeTsnVlanTagType"
	case OpcuaNodeIdServicesObjectType_IPriorityMappingEntryType:
		return "IPriorityMappingEntryType"
	case OpcuaNodeIdServicesObjectType_IIeeeAutoNegotiationStatusType:
		return "IIeeeAutoNegotiationStatusType"
	case OpcuaNodeIdServicesObjectType_UserManagementType:
		return "UserManagementType"
	case OpcuaNodeIdServicesObjectType_IVlanIdType:
		return "IVlanIdType"
	case OpcuaNodeIdServicesObjectType_IetfBaseNetworkInterfaceType:
		return "IetfBaseNetworkInterfaceType"
	case OpcuaNodeIdServicesObjectType_PriorityMappingTableType:
		return "PriorityMappingTableType"
	case OpcuaNodeIdServicesObjectType_PubSubKeyPushTargetType:
		return "PubSubKeyPushTargetType"
	case OpcuaNodeIdServicesObjectType_PubSubKeyPushTargetFolderType:
		return "PubSubKeyPushTargetFolderType"
	case OpcuaNodeIdServicesObjectType_PubSubConfigurationType:
		return "PubSubConfigurationType"
	case OpcuaNodeIdServicesObjectType_ApplicationConfigurationType:
		return "ApplicationConfigurationType"
	case OpcuaNodeIdServicesObjectType_ProvisionableDeviceType:
		return "ProvisionableDeviceType"
	case OpcuaNodeIdServicesObjectType_SemanticChangeEventType:
		return "SemanticChangeEventType"
	case OpcuaNodeIdServicesObjectType_AuditUrlMismatchEventType:
		return "AuditUrlMismatchEventType"
	case OpcuaNodeIdServicesObjectType_FiniteStateMachineType:
		return "FiniteStateMachineType"
	case OpcuaNodeIdServicesObjectType_ConditionType:
		return "ConditionType"
	case OpcuaNodeIdServicesObjectType_RefreshStartEventType:
		return "RefreshStartEventType"
	case OpcuaNodeIdServicesObjectType_RefreshEndEventType:
		return "RefreshEndEventType"
	case OpcuaNodeIdServicesObjectType_RefreshRequiredEventType:
		return "RefreshRequiredEventType"
	case OpcuaNodeIdServicesObjectType_AuditConditionEventType:
		return "AuditConditionEventType"
	case OpcuaNodeIdServicesObjectType_AuditConditionEnableEventType:
		return "AuditConditionEnableEventType"
	case OpcuaNodeIdServicesObjectType_AuditConditionCommentEventType:
		return "AuditConditionCommentEventType"
	case OpcuaNodeIdServicesObjectType_DialogConditionType:
		return "DialogConditionType"
	case OpcuaNodeIdServicesObjectType_AcknowledgeableConditionType:
		return "AcknowledgeableConditionType"
	case OpcuaNodeIdServicesObjectType_AlarmConditionType:
		return "AlarmConditionType"
	case OpcuaNodeIdServicesObjectType_ShelvedStateMachineType:
		return "ShelvedStateMachineType"
	case OpcuaNodeIdServicesObjectType_LimitAlarmType:
		return "LimitAlarmType"
	case OpcuaNodeIdServicesObjectType_AuditHistoryEventUpdateEventType:
		return "AuditHistoryEventUpdateEventType"
	case OpcuaNodeIdServicesObjectType_AuditHistoryValueUpdateEventType:
		return "AuditHistoryValueUpdateEventType"
	case OpcuaNodeIdServicesObjectType_AuditHistoryDeleteEventType:
		return "AuditHistoryDeleteEventType"
	case OpcuaNodeIdServicesObjectType_AuditHistoryRawModifyDeleteEventType:
		return "AuditHistoryRawModifyDeleteEventType"
	case OpcuaNodeIdServicesObjectType_AuditHistoryAtTimeDeleteEventType:
		return "AuditHistoryAtTimeDeleteEventType"
	case OpcuaNodeIdServicesObjectType_AuditHistoryEventDeleteEventType:
		return "AuditHistoryEventDeleteEventType"
	case OpcuaNodeIdServicesObjectType_EventQueueOverflowEventType:
		return "EventQueueOverflowEventType"
	case OpcuaNodeIdServicesObjectType_AlarmSuppressionGroupType:
		return "AlarmSuppressionGroupType"
	case OpcuaNodeIdServicesObjectType_TrustListUpdateRequestedAuditEventType:
		return "TrustListUpdateRequestedAuditEventType"
	case OpcuaNodeIdServicesObjectType_TransactionDiagnosticsType:
		return "TransactionDiagnosticsType"
	case OpcuaNodeIdServicesObjectType_CertificateUpdateRequestedAuditEventType:
		return "CertificateUpdateRequestedAuditEventType"
	case OpcuaNodeIdServicesObjectType_NonTransparentBackupRedundancyType:
		return "NonTransparentBackupRedundancyType"
	case OpcuaNodeIdServicesObjectType_SyntaxReferenceEntryType:
		return "SyntaxReferenceEntryType"
	case OpcuaNodeIdServicesObjectType_UnitType:
		return "UnitType"
	case OpcuaNodeIdServicesObjectType_ServerUnitType:
		return "ServerUnitType"
	case OpcuaNodeIdServicesObjectType_AlternativeUnitType:
		return "AlternativeUnitType"
	case OpcuaNodeIdServicesObjectType_QuantityType:
		return "QuantityType"
	case OpcuaNodeIdServicesObjectType_QuantitiesFolderType:
		return "QuantitiesFolderType"
	case OpcuaNodeIdServicesObjectType_HistoricalEventConfigurationType:
		return "HistoricalEventConfigurationType"
	case OpcuaNodeIdServicesObjectType_HistoricalExternalEventSourceType:
		return "HistoricalExternalEventSourceType"
	case OpcuaNodeIdServicesObjectType_AuditHistoryConfigurationChangeEventType:
		return "AuditHistoryConfigurationChangeEventType"
	case OpcuaNodeIdServicesObjectType_AuditHistoryBulkInsertEventType:
		return "AuditHistoryBulkInsertEventType"
	case OpcuaNodeIdServicesObjectType_ProgramTransitionAuditEventType:
		return "ProgramTransitionAuditEventType"
	case OpcuaNodeIdServicesObjectType_BaseObjectType:
		return "BaseObjectType"
	case OpcuaNodeIdServicesObjectType_FolderType:
		return "FolderType"
	case OpcuaNodeIdServicesObjectType_DataTypeSystemType:
		return "DataTypeSystemType"
	case OpcuaNodeIdServicesObjectType_DataTypeEncodingType:
		return "DataTypeEncodingType"
	case OpcuaNodeIdServicesObjectType_ModellingRuleType:
		return "ModellingRuleType"
	case OpcuaNodeIdServicesObjectType_AuditConditionRespondEventType:
		return "AuditConditionRespondEventType"
	case OpcuaNodeIdServicesObjectType_AuditConditionAcknowledgeEventType:
		return "AuditConditionAcknowledgeEventType"
	case OpcuaNodeIdServicesObjectType_AuditConditionConfirmEventType:
		return "AuditConditionConfirmEventType"
	case OpcuaNodeIdServicesObjectType_ExclusiveLimitStateMachineType:
		return "ExclusiveLimitStateMachineType"
	case OpcuaNodeIdServicesObjectType_ExclusiveLimitAlarmType:
		return "ExclusiveLimitAlarmType"
	case OpcuaNodeIdServicesObjectType_ExclusiveLevelAlarmType:
		return "ExclusiveLevelAlarmType"
	case OpcuaNodeIdServicesObjectType_ExclusiveRateOfChangeAlarmType:
		return "ExclusiveRateOfChangeAlarmType"
	case OpcuaNodeIdServicesObjectType_ExclusiveDeviationAlarmType:
		return "ExclusiveDeviationAlarmType"
	case OpcuaNodeIdServicesObjectType_NonExclusiveLimitAlarmType:
		return "NonExclusiveLimitAlarmType"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesObjectType) String() string {
	return e.PLC4XEnumName()
}
