/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaCloseRequest is the corresponding interface of OpcuaCloseRequest
type OpcuaCloseRequest interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	MessagePDU
	// GetSecurityHeader returns SecurityHeader (property field)
	GetSecurityHeader() SecurityHeader
	// GetMessage returns Message (property field)
	GetMessage() Payload
}

// OpcuaCloseRequestExactly can be used when we want exactly this type and not a type which fulfills OpcuaCloseRequest.
// This is useful for switch cases.
type OpcuaCloseRequestExactly interface {
	OpcuaCloseRequest
	isOpcuaCloseRequest() bool
}

// _OpcuaCloseRequest is the data-structure of this message
type _OpcuaCloseRequest struct {
	*_MessagePDU
	SecurityHeader SecurityHeader
	Message        Payload
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_OpcuaCloseRequest) GetMessageType() string {
	return "CLO"
}

func (m *_OpcuaCloseRequest) GetResponse() bool {
	return bool(false)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_OpcuaCloseRequest) InitializeParent(parent MessagePDU, chunk ChunkType) {
	m.Chunk = chunk
}

func (m *_OpcuaCloseRequest) GetParent() MessagePDU {
	return m._MessagePDU
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_OpcuaCloseRequest) GetSecurityHeader() SecurityHeader {
	return m.SecurityHeader
}

func (m *_OpcuaCloseRequest) GetMessage() Payload {
	return m.Message
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewOpcuaCloseRequest factory function for _OpcuaCloseRequest
func NewOpcuaCloseRequest(securityHeader SecurityHeader, message Payload, chunk ChunkType) *_OpcuaCloseRequest {
	_result := &_OpcuaCloseRequest{
		SecurityHeader: securityHeader,
		Message:        message,
		_MessagePDU:    NewMessagePDU(chunk),
	}
	_result._MessagePDU._MessagePDUChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastOpcuaCloseRequest(structType any) OpcuaCloseRequest {
	if casted, ok := structType.(OpcuaCloseRequest); ok {
		return casted
	}
	if casted, ok := structType.(*OpcuaCloseRequest); ok {
		return *casted
	}
	return nil
}

func (m *_OpcuaCloseRequest) GetTypeName() string {
	return "OpcuaCloseRequest"
}

func (m *_OpcuaCloseRequest) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (securityHeader)
	lengthInBits += m.SecurityHeader.GetLengthInBits(ctx)

	// Simple field (message)
	lengthInBits += m.Message.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_OpcuaCloseRequest) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaCloseRequestParse(ctx context.Context, theBytes []byte, response bool) (OpcuaCloseRequest, error) {
	return OpcuaCloseRequestParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), response)
}

func OpcuaCloseRequestParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, response bool) (OpcuaCloseRequest, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("OpcuaCloseRequest"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for OpcuaCloseRequest")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (securityHeader)
	if pullErr := readBuffer.PullContext("securityHeader"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for securityHeader")
	}
	_securityHeader, _securityHeaderErr := SecurityHeaderParseWithBuffer(ctx, readBuffer)
	if _securityHeaderErr != nil {
		return nil, errors.Wrap(_securityHeaderErr, "Error parsing 'securityHeader' field of OpcuaCloseRequest")
	}
	securityHeader := _securityHeader.(SecurityHeader)
	if closeErr := readBuffer.CloseContext("securityHeader"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for securityHeader")
	}

	// Simple Field (message)
	if pullErr := readBuffer.PullContext("message"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for message")
	}
	_message, _messageErr := PayloadParseWithBuffer(ctx, readBuffer, bool(bool(false)), uint32(uint32(0)))
	if _messageErr != nil {
		return nil, errors.Wrap(_messageErr, "Error parsing 'message' field of OpcuaCloseRequest")
	}
	message := _message.(Payload)
	if closeErr := readBuffer.CloseContext("message"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for message")
	}

	if closeErr := readBuffer.CloseContext("OpcuaCloseRequest"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for OpcuaCloseRequest")
	}

	// Create a partially initialized instance
	_child := &_OpcuaCloseRequest{
		_MessagePDU:    &_MessagePDU{},
		SecurityHeader: securityHeader,
		Message:        message,
	}
	_child._MessagePDU._MessagePDUChildRequirements = _child
	return _child, nil
}

func (m *_OpcuaCloseRequest) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_OpcuaCloseRequest) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("OpcuaCloseRequest"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for OpcuaCloseRequest")
		}

		// Simple Field (securityHeader)
		if pushErr := writeBuffer.PushContext("securityHeader"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for securityHeader")
		}
		_securityHeaderErr := writeBuffer.WriteSerializable(ctx, m.GetSecurityHeader())
		if popErr := writeBuffer.PopContext("securityHeader"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for securityHeader")
		}
		if _securityHeaderErr != nil {
			return errors.Wrap(_securityHeaderErr, "Error serializing 'securityHeader' field")
		}

		// Simple Field (message)
		if pushErr := writeBuffer.PushContext("message"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for message")
		}
		_messageErr := writeBuffer.WriteSerializable(ctx, m.GetMessage())
		if popErr := writeBuffer.PopContext("message"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for message")
		}
		if _messageErr != nil {
			return errors.Wrap(_messageErr, "Error serializing 'message' field")
		}

		if popErr := writeBuffer.PopContext("OpcuaCloseRequest"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for OpcuaCloseRequest")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_OpcuaCloseRequest) isOpcuaCloseRequest() bool {
	return true
}

func (m *_OpcuaCloseRequest) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
