/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// KeyValuePair is the corresponding interface of KeyValuePair
type KeyValuePair interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetKey returns Key (property field)
	GetKey() QualifiedName
	// GetValue returns Value (property field)
	GetValue() Variant
}

// KeyValuePairExactly can be used when we want exactly this type and not a type which fulfills KeyValuePair.
// This is useful for switch cases.
type KeyValuePairExactly interface {
	KeyValuePair
	isKeyValuePair() bool
}

// _KeyValuePair is the data-structure of this message
type _KeyValuePair struct {
	*_ExtensionObjectDefinition
	Key   QualifiedName
	Value Variant
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_KeyValuePair) GetIdentifier() string {
	return "14535"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_KeyValuePair) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_KeyValuePair) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_KeyValuePair) GetKey() QualifiedName {
	return m.Key
}

func (m *_KeyValuePair) GetValue() Variant {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewKeyValuePair factory function for _KeyValuePair
func NewKeyValuePair(key QualifiedName, value Variant) *_KeyValuePair {
	_result := &_KeyValuePair{
		Key:                        key,
		Value:                      value,
		_ExtensionObjectDefinition: NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastKeyValuePair(structType any) KeyValuePair {
	if casted, ok := structType.(KeyValuePair); ok {
		return casted
	}
	if casted, ok := structType.(*KeyValuePair); ok {
		return *casted
	}
	return nil
}

func (m *_KeyValuePair) GetTypeName() string {
	return "KeyValuePair"
}

func (m *_KeyValuePair) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (key)
	lengthInBits += m.Key.GetLengthInBits(ctx)

	// Simple field (value)
	lengthInBits += m.Value.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_KeyValuePair) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func KeyValuePairParse(ctx context.Context, theBytes []byte, identifier string) (KeyValuePair, error) {
	return KeyValuePairParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func KeyValuePairParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (KeyValuePair, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("KeyValuePair"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for KeyValuePair")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (key)
	if pullErr := readBuffer.PullContext("key"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for key")
	}
	_key, _keyErr := QualifiedNameParseWithBuffer(ctx, readBuffer)
	if _keyErr != nil {
		return nil, errors.Wrap(_keyErr, "Error parsing 'key' field of KeyValuePair")
	}
	key := _key.(QualifiedName)
	if closeErr := readBuffer.CloseContext("key"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for key")
	}

	// Simple Field (value)
	if pullErr := readBuffer.PullContext("value"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for value")
	}
	_value, _valueErr := VariantParseWithBuffer(ctx, readBuffer)
	if _valueErr != nil {
		return nil, errors.Wrap(_valueErr, "Error parsing 'value' field of KeyValuePair")
	}
	value := _value.(Variant)
	if closeErr := readBuffer.CloseContext("value"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for value")
	}

	if closeErr := readBuffer.CloseContext("KeyValuePair"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for KeyValuePair")
	}

	// Create a partially initialized instance
	_child := &_KeyValuePair{
		_ExtensionObjectDefinition: &_ExtensionObjectDefinition{},
		Key:                        key,
		Value:                      value,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_KeyValuePair) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_KeyValuePair) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("KeyValuePair"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for KeyValuePair")
		}

		// Simple Field (key)
		if pushErr := writeBuffer.PushContext("key"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for key")
		}
		_keyErr := writeBuffer.WriteSerializable(ctx, m.GetKey())
		if popErr := writeBuffer.PopContext("key"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for key")
		}
		if _keyErr != nil {
			return errors.Wrap(_keyErr, "Error serializing 'key' field")
		}

		// Simple Field (value)
		if pushErr := writeBuffer.PushContext("value"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for value")
		}
		_valueErr := writeBuffer.WriteSerializable(ctx, m.GetValue())
		if popErr := writeBuffer.PopContext("value"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for value")
		}
		if _valueErr != nil {
			return errors.Wrap(_valueErr, "Error serializing 'value' field")
		}

		if popErr := writeBuffer.PopContext("KeyValuePair"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for KeyValuePair")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_KeyValuePair) isKeyValuePair() bool {
	return true
}

func (m *_KeyValuePair) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
