/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// GetEndpointsResponse is the corresponding interface of GetEndpointsResponse
type GetEndpointsResponse interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetResponseHeader returns ResponseHeader (property field)
	GetResponseHeader() ExtensionObjectDefinition
	// GetNoOfEndpoints returns NoOfEndpoints (property field)
	GetNoOfEndpoints() int32
	// GetEndpoints returns Endpoints (property field)
	GetEndpoints() []ExtensionObjectDefinition
}

// GetEndpointsResponseExactly can be used when we want exactly this type and not a type which fulfills GetEndpointsResponse.
// This is useful for switch cases.
type GetEndpointsResponseExactly interface {
	GetEndpointsResponse
	isGetEndpointsResponse() bool
}

// _GetEndpointsResponse is the data-structure of this message
type _GetEndpointsResponse struct {
	*_ExtensionObjectDefinition
	ResponseHeader ExtensionObjectDefinition
	NoOfEndpoints  int32
	Endpoints      []ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_GetEndpointsResponse) GetIdentifier() string {
	return "431"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_GetEndpointsResponse) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_GetEndpointsResponse) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_GetEndpointsResponse) GetResponseHeader() ExtensionObjectDefinition {
	return m.ResponseHeader
}

func (m *_GetEndpointsResponse) GetNoOfEndpoints() int32 {
	return m.NoOfEndpoints
}

func (m *_GetEndpointsResponse) GetEndpoints() []ExtensionObjectDefinition {
	return m.Endpoints
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewGetEndpointsResponse factory function for _GetEndpointsResponse
func NewGetEndpointsResponse(responseHeader ExtensionObjectDefinition, noOfEndpoints int32, endpoints []ExtensionObjectDefinition) *_GetEndpointsResponse {
	_result := &_GetEndpointsResponse{
		ResponseHeader:             responseHeader,
		NoOfEndpoints:              noOfEndpoints,
		Endpoints:                  endpoints,
		_ExtensionObjectDefinition: NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastGetEndpointsResponse(structType any) GetEndpointsResponse {
	if casted, ok := structType.(GetEndpointsResponse); ok {
		return casted
	}
	if casted, ok := structType.(*GetEndpointsResponse); ok {
		return *casted
	}
	return nil
}

func (m *_GetEndpointsResponse) GetTypeName() string {
	return "GetEndpointsResponse"
}

func (m *_GetEndpointsResponse) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (responseHeader)
	lengthInBits += m.ResponseHeader.GetLengthInBits(ctx)

	// Simple field (noOfEndpoints)
	lengthInBits += 32

	// Array field
	if len(m.Endpoints) > 0 {
		for _curItem, element := range m.Endpoints {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.Endpoints), _curItem)
			_ = arrayCtx
			_ = _curItem
			lengthInBits += element.(interface{ GetLengthInBits(context.Context) uint16 }).GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_GetEndpointsResponse) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func GetEndpointsResponseParse(ctx context.Context, theBytes []byte, identifier string) (GetEndpointsResponse, error) {
	return GetEndpointsResponseParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func GetEndpointsResponseParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (GetEndpointsResponse, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("GetEndpointsResponse"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for GetEndpointsResponse")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (responseHeader)
	if pullErr := readBuffer.PullContext("responseHeader"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for responseHeader")
	}
	_responseHeader, _responseHeaderErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("394"))
	if _responseHeaderErr != nil {
		return nil, errors.Wrap(_responseHeaderErr, "Error parsing 'responseHeader' field of GetEndpointsResponse")
	}
	responseHeader := _responseHeader.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("responseHeader"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for responseHeader")
	}

	// Simple Field (noOfEndpoints)
	_noOfEndpoints, _noOfEndpointsErr := readBuffer.ReadInt32("noOfEndpoints", 32)
	if _noOfEndpointsErr != nil {
		return nil, errors.Wrap(_noOfEndpointsErr, "Error parsing 'noOfEndpoints' field of GetEndpointsResponse")
	}
	noOfEndpoints := _noOfEndpoints

	// Array field (endpoints)
	if pullErr := readBuffer.PullContext("endpoints", utils.WithRenderAsList(true)); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for endpoints")
	}
	// Count array
	endpoints := make([]ExtensionObjectDefinition, utils.Max(noOfEndpoints, 0))
	// This happens when the size is set conditional to 0
	if len(endpoints) == 0 {
		endpoints = nil
	}
	{
		_numItems := uint16(utils.Max(noOfEndpoints, 0))
		for _curItem := uint16(0); _curItem < _numItems; _curItem++ {
			arrayCtx := utils.CreateArrayContext(ctx, int(_numItems), int(_curItem))
			_ = arrayCtx
			_ = _curItem
			_item, _err := ExtensionObjectDefinitionParseWithBuffer(arrayCtx, readBuffer, "314")
			if _err != nil {
				return nil, errors.Wrap(_err, "Error parsing 'endpoints' field of GetEndpointsResponse")
			}
			endpoints[_curItem] = _item.(ExtensionObjectDefinition)
		}
	}
	if closeErr := readBuffer.CloseContext("endpoints", utils.WithRenderAsList(true)); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for endpoints")
	}

	if closeErr := readBuffer.CloseContext("GetEndpointsResponse"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for GetEndpointsResponse")
	}

	// Create a partially initialized instance
	_child := &_GetEndpointsResponse{
		_ExtensionObjectDefinition: &_ExtensionObjectDefinition{},
		ResponseHeader:             responseHeader,
		NoOfEndpoints:              noOfEndpoints,
		Endpoints:                  endpoints,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_GetEndpointsResponse) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_GetEndpointsResponse) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("GetEndpointsResponse"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for GetEndpointsResponse")
		}

		// Simple Field (responseHeader)
		if pushErr := writeBuffer.PushContext("responseHeader"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for responseHeader")
		}
		_responseHeaderErr := writeBuffer.WriteSerializable(ctx, m.GetResponseHeader())
		if popErr := writeBuffer.PopContext("responseHeader"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for responseHeader")
		}
		if _responseHeaderErr != nil {
			return errors.Wrap(_responseHeaderErr, "Error serializing 'responseHeader' field")
		}

		// Simple Field (noOfEndpoints)
		noOfEndpoints := int32(m.GetNoOfEndpoints())
		_noOfEndpointsErr := writeBuffer.WriteInt32("noOfEndpoints", 32, int32((noOfEndpoints)))
		if _noOfEndpointsErr != nil {
			return errors.Wrap(_noOfEndpointsErr, "Error serializing 'noOfEndpoints' field")
		}

		// Array Field (endpoints)
		if pushErr := writeBuffer.PushContext("endpoints", utils.WithRenderAsList(true)); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for endpoints")
		}
		for _curItem, _element := range m.GetEndpoints() {
			_ = _curItem
			arrayCtx := utils.CreateArrayContext(ctx, len(m.GetEndpoints()), _curItem)
			_ = arrayCtx
			_elementErr := writeBuffer.WriteSerializable(arrayCtx, _element)
			if _elementErr != nil {
				return errors.Wrap(_elementErr, "Error serializing 'endpoints' field")
			}
		}
		if popErr := writeBuffer.PopContext("endpoints", utils.WithRenderAsList(true)); popErr != nil {
			return errors.Wrap(popErr, "Error popping for endpoints")
		}

		if popErr := writeBuffer.PopContext("GetEndpointsResponse"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for GetEndpointsResponse")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_GetEndpointsResponse) isGetEndpointsResponse() bool {
	return true
}

func (m *_GetEndpointsResponse) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
