/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// ExtensionObjectDefinition is the corresponding interface of ExtensionObjectDefinition
type ExtensionObjectDefinition interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	// GetIdentifier returns Identifier (discriminator field)
	GetIdentifier() string
}

// ExtensionObjectDefinitionExactly can be used when we want exactly this type and not a type which fulfills ExtensionObjectDefinition.
// This is useful for switch cases.
type ExtensionObjectDefinitionExactly interface {
	ExtensionObjectDefinition
	isExtensionObjectDefinition() bool
}

// _ExtensionObjectDefinition is the data-structure of this message
type _ExtensionObjectDefinition struct {
	_ExtensionObjectDefinitionChildRequirements
}

type _ExtensionObjectDefinitionChildRequirements interface {
	utils.Serializable
	GetLengthInBits(ctx context.Context) uint16
	GetIdentifier() string
}

type ExtensionObjectDefinitionParent interface {
	SerializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child ExtensionObjectDefinition, serializeChildFunction func() error) error
	GetTypeName() string
}

type ExtensionObjectDefinitionChild interface {
	utils.Serializable
	InitializeParent(parent ExtensionObjectDefinition)
	GetParent() *ExtensionObjectDefinition

	GetTypeName() string
	ExtensionObjectDefinition
}

// NewExtensionObjectDefinition factory function for _ExtensionObjectDefinition
func NewExtensionObjectDefinition() *_ExtensionObjectDefinition {
	return &_ExtensionObjectDefinition{}
}

// Deprecated: use the interface for direct cast
func CastExtensionObjectDefinition(structType any) ExtensionObjectDefinition {
	if casted, ok := structType.(ExtensionObjectDefinition); ok {
		return casted
	}
	if casted, ok := structType.(*ExtensionObjectDefinition); ok {
		return *casted
	}
	return nil
}

func (m *_ExtensionObjectDefinition) GetTypeName() string {
	return "ExtensionObjectDefinition"
}

func (m *_ExtensionObjectDefinition) GetParentLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	return lengthInBits
}

func (m *_ExtensionObjectDefinition) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ExtensionObjectDefinitionParse(ctx context.Context, theBytes []byte, identifier string) (ExtensionObjectDefinition, error) {
	return ExtensionObjectDefinitionParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func ExtensionObjectDefinitionParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (ExtensionObjectDefinition, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("ExtensionObjectDefinition"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ExtensionObjectDefinition")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	type ExtensionObjectDefinitionChildSerializeRequirement interface {
		ExtensionObjectDefinition
		InitializeParent(ExtensionObjectDefinition)
		GetParent() ExtensionObjectDefinition
	}
	var _childTemp any
	var _child ExtensionObjectDefinitionChildSerializeRequirement
	var typeSwitchError error
	switch {
	case identifier == "0": // NullExtension
		_childTemp, typeSwitchError = NullExtensionParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "12758": // Union
		_childTemp, typeSwitchError = UnionParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "14535": // KeyValuePair
		_childTemp, typeSwitchError = KeyValuePairParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "16315": // AdditionalParametersType
		_childTemp, typeSwitchError = AdditionalParametersTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "17550": // EphemeralKeyType
		_childTemp, typeSwitchError = EphemeralKeyTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "15530": // EndpointType
		_childTemp, typeSwitchError = EndpointTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "32423": // BitFieldDefinition
		_childTemp, typeSwitchError = BitFieldDefinitionParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "18808": // RationalNumber
		_childTemp, typeSwitchError = RationalNumberParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "18809": // OpcuaVector
		_childTemp, typeSwitchError = OpcuaVectorParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "18811": // CartesianCoordinates
		_childTemp, typeSwitchError = CartesianCoordinatesParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "18813": // Orientation
		_childTemp, typeSwitchError = OrientationParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "18815": // Frame
		_childTemp, typeSwitchError = FrameParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "15636": // IdentityMappingRuleType
		_childTemp, typeSwitchError = IdentityMappingRuleTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "23500": // CurrencyUnitType
		_childTemp, typeSwitchError = CurrencyUnitTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "32436": // AnnotationDataType
		_childTemp, typeSwitchError = AnnotationDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "32437": // LinearConversionDataType
		_childTemp, typeSwitchError = LinearConversionDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "32440": // QuantityDimension
		_childTemp, typeSwitchError = QuantityDimensionParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "12556": // TrustListDataType
		_childTemp, typeSwitchError = TrustListDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "32287": // TransactionErrorType
		_childTemp, typeSwitchError = TransactionErrorTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "15536": // DataTypeSchemaHeader
		_childTemp, typeSwitchError = DataTypeSchemaHeaderParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "14527": // DataTypeDescription
		_childTemp, typeSwitchError = DataTypeDescriptionParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "24107": // PortableQualifiedName
		_childTemp, typeSwitchError = PortableQualifiedNameParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "24109": // UnsignedRationalNumber
		_childTemp, typeSwitchError = UnsignedRationalNumberParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "14526": // FieldMetaData
		_childTemp, typeSwitchError = FieldMetaDataParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "14595": // ConfigurationVersionDataType
		_childTemp, typeSwitchError = ConfigurationVersionDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "15582": // PublishedDataSetSourceDataType
		_childTemp, typeSwitchError = PublishedDataSetSourceDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "14275": // PublishedVariableDataType
		_childTemp, typeSwitchError = PublishedVariableDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "15599": // DataSetWriterDataType
		_childTemp, typeSwitchError = DataSetWriterDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "15600": // DataSetWriterTransportDataType
		_childTemp, typeSwitchError = DataSetWriterTransportDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "15607": // DataSetWriterMessageDataType
		_childTemp, typeSwitchError = DataSetWriterMessageDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "15611": // PubSubGroupDataType
		_childTemp, typeSwitchError = PubSubGroupDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "15613": // WriterGroupTransportDataType
		_childTemp, typeSwitchError = WriterGroupTransportDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "15618": // WriterGroupMessageDataType
		_childTemp, typeSwitchError = WriterGroupMessageDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "15619": // PubSubConnectionDataType
		_childTemp, typeSwitchError = PubSubConnectionDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "15620": // ConnectionTransportDataType
		_childTemp, typeSwitchError = ConnectionTransportDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "15504": // NetworkAddressDataType
		_childTemp, typeSwitchError = NetworkAddressDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "15623": // ReaderGroupTransportDataType
		_childTemp, typeSwitchError = ReaderGroupTransportDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "15624": // ReaderGroupMessageDataType
		_childTemp, typeSwitchError = ReaderGroupMessageDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "15630": // DataSetReaderTransportDataType
		_childTemp, typeSwitchError = DataSetReaderTransportDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "15631": // DataSetReaderMessageDataType
		_childTemp, typeSwitchError = DataSetReaderMessageDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "15632": // SubscribedDataSetDataType
		_childTemp, typeSwitchError = SubscribedDataSetDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "14746": // FieldTargetDataType
		_childTemp, typeSwitchError = FieldTargetDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "15532": // PubSubConfigurationDataType
		_childTemp, typeSwitchError = PubSubConfigurationDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "23603": // SecurityGroupDataType
		_childTemp, typeSwitchError = SecurityGroupDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "25272": // PubSubKeyPushTargetDataType
		_childTemp, typeSwitchError = PubSubKeyPushTargetDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "23605": // QosDataType
		_childTemp, typeSwitchError = QosDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "25521": // PubSubConfigurationRefDataType
		_childTemp, typeSwitchError = PubSubConfigurationRefDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "23470": // AliasNameDataType
		_childTemp, typeSwitchError = AliasNameDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "24283": // UserManagementDataType
		_childTemp, typeSwitchError = UserManagementDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "25222": // PriorityMappingEntryType
		_childTemp, typeSwitchError = PriorityMappingEntryTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "32661": // ReferenceDescriptionDataType
		_childTemp, typeSwitchError = ReferenceDescriptionDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "32662": // ReferenceListEntryDataType
		_childTemp, typeSwitchError = ReferenceListEntryDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "98": // RolePermissionType
		_childTemp, typeSwitchError = RolePermissionTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "99": // DataTypeDefinition
		_childTemp, typeSwitchError = DataTypeDefinitionParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "103": // StructureField
		_childTemp, typeSwitchError = StructureFieldParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "298": // Argument
		_childTemp, typeSwitchError = ArgumentParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "7596": // EnumValueType
		_childTemp, typeSwitchError = EnumValueTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "12757": // OptionSet
		_childTemp, typeSwitchError = OptionSetParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "8914": // TimeZoneDataType
		_childTemp, typeSwitchError = TimeZoneDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "310": // ApplicationDescription
		_childTemp, typeSwitchError = ApplicationDescriptionParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "391": // RequestHeader
		_childTemp, typeSwitchError = RequestHeaderParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "394": // ResponseHeader
		_childTemp, typeSwitchError = ResponseHeaderParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "397": // ServiceFault
		_childTemp, typeSwitchError = ServiceFaultParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "15903": // SessionlessInvokeRequestType
		_childTemp, typeSwitchError = SessionlessInvokeRequestTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "21001": // SessionlessInvokeResponseType
		_childTemp, typeSwitchError = SessionlessInvokeResponseTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "422": // FindServersRequest
		_childTemp, typeSwitchError = FindServersRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "425": // FindServersResponse
		_childTemp, typeSwitchError = FindServersResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "12191": // ServerOnNetwork
		_childTemp, typeSwitchError = ServerOnNetworkParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "12192": // FindServersOnNetworkRequest
		_childTemp, typeSwitchError = FindServersOnNetworkRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "12193": // FindServersOnNetworkResponse
		_childTemp, typeSwitchError = FindServersOnNetworkResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "306": // UserTokenPolicy
		_childTemp, typeSwitchError = UserTokenPolicyParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "314": // EndpointDescription
		_childTemp, typeSwitchError = EndpointDescriptionParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "428": // GetEndpointsRequest
		_childTemp, typeSwitchError = GetEndpointsRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "431": // GetEndpointsResponse
		_childTemp, typeSwitchError = GetEndpointsResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "434": // RegisteredServer
		_childTemp, typeSwitchError = RegisteredServerParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "437": // RegisterServerRequest
		_childTemp, typeSwitchError = RegisterServerRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "440": // RegisterServerResponse
		_childTemp, typeSwitchError = RegisterServerResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "12892": // DiscoveryConfiguration
		_childTemp, typeSwitchError = DiscoveryConfigurationParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "12195": // RegisterServer2Request
		_childTemp, typeSwitchError = RegisterServer2RequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "12196": // RegisterServer2Response
		_childTemp, typeSwitchError = RegisterServer2ResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "443": // ChannelSecurityToken
		_childTemp, typeSwitchError = ChannelSecurityTokenParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "446": // OpenSecureChannelRequest
		_childTemp, typeSwitchError = OpenSecureChannelRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "449": // OpenSecureChannelResponse
		_childTemp, typeSwitchError = OpenSecureChannelResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "452": // CloseSecureChannelRequest
		_childTemp, typeSwitchError = CloseSecureChannelRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "455": // CloseSecureChannelResponse
		_childTemp, typeSwitchError = CloseSecureChannelResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "346": // SignedSoftwareCertificate
		_childTemp, typeSwitchError = SignedSoftwareCertificateParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "458": // SignatureData
		_childTemp, typeSwitchError = SignatureDataParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "461": // CreateSessionRequest
		_childTemp, typeSwitchError = CreateSessionRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "464": // CreateSessionResponse
		_childTemp, typeSwitchError = CreateSessionResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "467": // ActivateSessionRequest
		_childTemp, typeSwitchError = ActivateSessionRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "470": // ActivateSessionResponse
		_childTemp, typeSwitchError = ActivateSessionResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "473": // CloseSessionRequest
		_childTemp, typeSwitchError = CloseSessionRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "476": // CloseSessionResponse
		_childTemp, typeSwitchError = CloseSessionResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "479": // CancelRequest
		_childTemp, typeSwitchError = CancelRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "482": // CancelResponse
		_childTemp, typeSwitchError = CancelResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "351": // NodeAttributes
		_childTemp, typeSwitchError = NodeAttributesParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "17608": // GenericAttributeValue
		_childTemp, typeSwitchError = GenericAttributeValueParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "378": // AddNodesItem
		_childTemp, typeSwitchError = AddNodesItemParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "485": // AddNodesResult
		_childTemp, typeSwitchError = AddNodesResultParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "488": // AddNodesRequest
		_childTemp, typeSwitchError = AddNodesRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "491": // AddNodesResponse
		_childTemp, typeSwitchError = AddNodesResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "381": // AddReferencesItem
		_childTemp, typeSwitchError = AddReferencesItemParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "494": // AddReferencesRequest
		_childTemp, typeSwitchError = AddReferencesRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "497": // AddReferencesResponse
		_childTemp, typeSwitchError = AddReferencesResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "384": // DeleteNodesItem
		_childTemp, typeSwitchError = DeleteNodesItemParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "500": // DeleteNodesRequest
		_childTemp, typeSwitchError = DeleteNodesRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "503": // DeleteNodesResponse
		_childTemp, typeSwitchError = DeleteNodesResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "387": // DeleteReferencesItem
		_childTemp, typeSwitchError = DeleteReferencesItemParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "506": // DeleteReferencesRequest
		_childTemp, typeSwitchError = DeleteReferencesRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "509": // DeleteReferencesResponse
		_childTemp, typeSwitchError = DeleteReferencesResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "513": // ViewDescription
		_childTemp, typeSwitchError = ViewDescriptionParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "516": // BrowseDescription
		_childTemp, typeSwitchError = BrowseDescriptionParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "520": // ReferenceDescription
		_childTemp, typeSwitchError = ReferenceDescriptionParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "524": // BrowseResult
		_childTemp, typeSwitchError = BrowseResultParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "527": // BrowseRequest
		_childTemp, typeSwitchError = BrowseRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "530": // BrowseResponse
		_childTemp, typeSwitchError = BrowseResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "533": // BrowseNextRequest
		_childTemp, typeSwitchError = BrowseNextRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "536": // BrowseNextResponse
		_childTemp, typeSwitchError = BrowseNextResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "539": // RelativePathElement
		_childTemp, typeSwitchError = RelativePathElementParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "542": // RelativePath
		_childTemp, typeSwitchError = RelativePathParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "545": // BrowsePath
		_childTemp, typeSwitchError = BrowsePathParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "548": // BrowsePathTarget
		_childTemp, typeSwitchError = BrowsePathTargetParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "551": // BrowsePathResult
		_childTemp, typeSwitchError = BrowsePathResultParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "554": // TranslateBrowsePathsToNodeIdsRequest
		_childTemp, typeSwitchError = TranslateBrowsePathsToNodeIdsRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "557": // TranslateBrowsePathsToNodeIdsResponse
		_childTemp, typeSwitchError = TranslateBrowsePathsToNodeIdsResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "560": // RegisterNodesRequest
		_childTemp, typeSwitchError = RegisterNodesRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "563": // RegisterNodesResponse
		_childTemp, typeSwitchError = RegisterNodesResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "566": // UnregisterNodesRequest
		_childTemp, typeSwitchError = UnregisterNodesRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "569": // UnregisterNodesResponse
		_childTemp, typeSwitchError = UnregisterNodesResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "333": // EndpointConfiguration
		_childTemp, typeSwitchError = EndpointConfigurationParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "572": // QueryDataDescription
		_childTemp, typeSwitchError = QueryDataDescriptionParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "575": // NodeTypeDescription
		_childTemp, typeSwitchError = NodeTypeDescriptionParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "579": // QueryDataSet
		_childTemp, typeSwitchError = QueryDataSetParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "582": // NodeReference
		_childTemp, typeSwitchError = NodeReferenceParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "585": // ContentFilterElement
		_childTemp, typeSwitchError = ContentFilterElementParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "588": // ContentFilter
		_childTemp, typeSwitchError = ContentFilterParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "591": // FilterOperand
		_childTemp, typeSwitchError = FilterOperandParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "606": // ContentFilterElementResult
		_childTemp, typeSwitchError = ContentFilterElementResultParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "609": // ContentFilterResult
		_childTemp, typeSwitchError = ContentFilterResultParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "612": // ParsingResult
		_childTemp, typeSwitchError = ParsingResultParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "615": // QueryFirstRequest
		_childTemp, typeSwitchError = QueryFirstRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "618": // QueryFirstResponse
		_childTemp, typeSwitchError = QueryFirstResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "621": // QueryNextRequest
		_childTemp, typeSwitchError = QueryNextRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "624": // QueryNextResponse
		_childTemp, typeSwitchError = QueryNextResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "628": // ReadValueId
		_childTemp, typeSwitchError = ReadValueIdParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "631": // ReadRequest
		_childTemp, typeSwitchError = ReadRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "634": // ReadResponse
		_childTemp, typeSwitchError = ReadResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "637": // HistoryReadValueId
		_childTemp, typeSwitchError = HistoryReadValueIdParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "640": // HistoryReadResult
		_childTemp, typeSwitchError = HistoryReadResultParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "643": // HistoryReadDetails
		_childTemp, typeSwitchError = HistoryReadDetailsParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "658": // HistoryData
		_childTemp, typeSwitchError = HistoryDataParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "11218": // ModificationInfo
		_childTemp, typeSwitchError = ModificationInfoParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "661": // HistoryEvent
		_childTemp, typeSwitchError = HistoryEventParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "664": // HistoryReadRequest
		_childTemp, typeSwitchError = HistoryReadRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "667": // HistoryReadResponse
		_childTemp, typeSwitchError = HistoryReadResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "670": // WriteValue
		_childTemp, typeSwitchError = WriteValueParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "673": // WriteRequest
		_childTemp, typeSwitchError = WriteRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "676": // WriteResponse
		_childTemp, typeSwitchError = WriteResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "679": // HistoryUpdateDetails
		_childTemp, typeSwitchError = HistoryUpdateDetailsParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "697": // HistoryUpdateResult
		_childTemp, typeSwitchError = HistoryUpdateResultParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "700": // HistoryUpdateRequest
		_childTemp, typeSwitchError = HistoryUpdateRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "703": // HistoryUpdateResponse
		_childTemp, typeSwitchError = HistoryUpdateResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "706": // CallMethodRequest
		_childTemp, typeSwitchError = CallMethodRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "709": // CallMethodResult
		_childTemp, typeSwitchError = CallMethodResultParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "712": // CallRequest
		_childTemp, typeSwitchError = CallRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "715": // CallResponse
		_childTemp, typeSwitchError = CallResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "721": // MonitoringFilter
		_childTemp, typeSwitchError = MonitoringFilterParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "950": // AggregateConfiguration
		_childTemp, typeSwitchError = AggregateConfigurationParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "733": // MonitoringFilterResult
		_childTemp, typeSwitchError = MonitoringFilterResultParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "742": // MonitoringParameters
		_childTemp, typeSwitchError = MonitoringParametersParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "745": // MonitoredItemCreateRequest
		_childTemp, typeSwitchError = MonitoredItemCreateRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "748": // MonitoredItemCreateResult
		_childTemp, typeSwitchError = MonitoredItemCreateResultParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "751": // CreateMonitoredItemsRequest
		_childTemp, typeSwitchError = CreateMonitoredItemsRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "754": // CreateMonitoredItemsResponse
		_childTemp, typeSwitchError = CreateMonitoredItemsResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "757": // MonitoredItemModifyRequest
		_childTemp, typeSwitchError = MonitoredItemModifyRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "760": // MonitoredItemModifyResult
		_childTemp, typeSwitchError = MonitoredItemModifyResultParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "763": // ModifyMonitoredItemsRequest
		_childTemp, typeSwitchError = ModifyMonitoredItemsRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "766": // ModifyMonitoredItemsResponse
		_childTemp, typeSwitchError = ModifyMonitoredItemsResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "769": // SetMonitoringModeRequest
		_childTemp, typeSwitchError = SetMonitoringModeRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "772": // SetMonitoringModeResponse
		_childTemp, typeSwitchError = SetMonitoringModeResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "775": // SetTriggeringRequest
		_childTemp, typeSwitchError = SetTriggeringRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "778": // SetTriggeringResponse
		_childTemp, typeSwitchError = SetTriggeringResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "781": // DeleteMonitoredItemsRequest
		_childTemp, typeSwitchError = DeleteMonitoredItemsRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "784": // DeleteMonitoredItemsResponse
		_childTemp, typeSwitchError = DeleteMonitoredItemsResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "787": // CreateSubscriptionRequest
		_childTemp, typeSwitchError = CreateSubscriptionRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "790": // CreateSubscriptionResponse
		_childTemp, typeSwitchError = CreateSubscriptionResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "793": // ModifySubscriptionRequest
		_childTemp, typeSwitchError = ModifySubscriptionRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "796": // ModifySubscriptionResponse
		_childTemp, typeSwitchError = ModifySubscriptionResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "799": // SetPublishingModeRequest
		_childTemp, typeSwitchError = SetPublishingModeRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "802": // SetPublishingModeResponse
		_childTemp, typeSwitchError = SetPublishingModeResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "805": // NotificationMessage
		_childTemp, typeSwitchError = NotificationMessageParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "947": // NotificationData
		_childTemp, typeSwitchError = NotificationDataParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "808": // MonitoredItemNotification
		_childTemp, typeSwitchError = MonitoredItemNotificationParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "919": // EventFieldList
		_childTemp, typeSwitchError = EventFieldListParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "922": // HistoryEventFieldList
		_childTemp, typeSwitchError = HistoryEventFieldListParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "823": // SubscriptionAcknowledgement
		_childTemp, typeSwitchError = SubscriptionAcknowledgementParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "826": // PublishRequest
		_childTemp, typeSwitchError = PublishRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "829": // PublishResponse
		_childTemp, typeSwitchError = PublishResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "832": // RepublishRequest
		_childTemp, typeSwitchError = RepublishRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "835": // RepublishResponse
		_childTemp, typeSwitchError = RepublishResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "838": // TransferResult
		_childTemp, typeSwitchError = TransferResultParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "841": // TransferSubscriptionsRequest
		_childTemp, typeSwitchError = TransferSubscriptionsRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "844": // TransferSubscriptionsResponse
		_childTemp, typeSwitchError = TransferSubscriptionsResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "847": // DeleteSubscriptionsRequest
		_childTemp, typeSwitchError = DeleteSubscriptionsRequestParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "850": // DeleteSubscriptionsResponse
		_childTemp, typeSwitchError = DeleteSubscriptionsResponseParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "340": // BuildInfo
		_childTemp, typeSwitchError = BuildInfoParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "855": // RedundantServerDataType
		_childTemp, typeSwitchError = RedundantServerDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "11945": // EndpointUrlListDataType
		_childTemp, typeSwitchError = EndpointUrlListDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "11946": // NetworkGroupDataType
		_childTemp, typeSwitchError = NetworkGroupDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "858": // SamplingIntervalDiagnosticsDataType
		_childTemp, typeSwitchError = SamplingIntervalDiagnosticsDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "861": // ServerDiagnosticsSummaryDataType
		_childTemp, typeSwitchError = ServerDiagnosticsSummaryDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "864": // ServerStatusDataType
		_childTemp, typeSwitchError = ServerStatusDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "867": // SessionDiagnosticsDataType
		_childTemp, typeSwitchError = SessionDiagnosticsDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "870": // SessionSecurityDiagnosticsDataType
		_childTemp, typeSwitchError = SessionSecurityDiagnosticsDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "873": // ServiceCounterDataType
		_childTemp, typeSwitchError = ServiceCounterDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "301": // StatusResult
		_childTemp, typeSwitchError = StatusResultParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "876": // SubscriptionDiagnosticsDataType
		_childTemp, typeSwitchError = SubscriptionDiagnosticsDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "879": // ModelChangeStructureDataType
		_childTemp, typeSwitchError = ModelChangeStructureDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "899": // SemanticChangeStructureDataType
		_childTemp, typeSwitchError = SemanticChangeStructureDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "886": // Range
		_childTemp, typeSwitchError = RangeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "889": // EUInformation
		_childTemp, typeSwitchError = EUInformationParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "12173": // ComplexNumberType
		_childTemp, typeSwitchError = ComplexNumberTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "12174": // DoubleComplexNumberType
		_childTemp, typeSwitchError = DoubleComplexNumberTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "12081": // AxisInformation
		_childTemp, typeSwitchError = AxisInformationParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "12082": // XVType
		_childTemp, typeSwitchError = XVTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "896": // ProgramDiagnosticDataType
		_childTemp, typeSwitchError = ProgramDiagnosticDataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "24035": // ProgramDiagnostic2DataType
		_childTemp, typeSwitchError = ProgramDiagnostic2DataTypeParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "893": // Annotation
		_childTemp, typeSwitchError = AnnotationParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "811": // DataChangeNotification
		_childTemp, typeSwitchError = DataChangeNotificationParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "916": // EventNotificationList
		_childTemp, typeSwitchError = EventNotificationListParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "820": // StatusChangeNotification
		_childTemp, typeSwitchError = StatusChangeNotificationParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "316": // UserIdentityToken
		_childTemp, typeSwitchError = UserIdentityTokenParseWithBuffer(ctx, readBuffer, identifier)
	default:
		typeSwitchError = errors.Errorf("Unmapped type for parameters [identifier=%v]", identifier)
	}
	if typeSwitchError != nil {
		return nil, errors.Wrap(typeSwitchError, "Error parsing sub-type for type-switch of ExtensionObjectDefinition")
	}
	_child = _childTemp.(ExtensionObjectDefinitionChildSerializeRequirement)

	if closeErr := readBuffer.CloseContext("ExtensionObjectDefinition"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ExtensionObjectDefinition")
	}

	// Finish initializing
	_child.InitializeParent(_child)
	return _child, nil
}

func (pm *_ExtensionObjectDefinition) SerializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child ExtensionObjectDefinition, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("ExtensionObjectDefinition"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for ExtensionObjectDefinition")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("ExtensionObjectDefinition"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for ExtensionObjectDefinition")
	}
	return nil
}

func (m *_ExtensionObjectDefinition) isExtensionObjectDefinition() bool {
	return true
}

func (m *_ExtensionObjectDefinition) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
