/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// ExtensionHeader is the corresponding interface of ExtensionHeader
type ExtensionHeader interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	// GetXmlbody returns Xmlbody (property field)
	GetXmlbody() bool
	// GetBinaryBody returns BinaryBody (property field)
	GetBinaryBody() bool
}

// ExtensionHeaderExactly can be used when we want exactly this type and not a type which fulfills ExtensionHeader.
// This is useful for switch cases.
type ExtensionHeaderExactly interface {
	ExtensionHeader
	isExtensionHeader() bool
}

// _ExtensionHeader is the data-structure of this message
type _ExtensionHeader struct {
	Xmlbody    bool
	BinaryBody bool
	// Reserved Fields
	reservedField0 *int8
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ExtensionHeader) GetXmlbody() bool {
	return m.Xmlbody
}

func (m *_ExtensionHeader) GetBinaryBody() bool {
	return m.BinaryBody
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewExtensionHeader factory function for _ExtensionHeader
func NewExtensionHeader(xmlbody bool, binaryBody bool) *_ExtensionHeader {
	return &_ExtensionHeader{Xmlbody: xmlbody, BinaryBody: binaryBody}
}

// Deprecated: use the interface for direct cast
func CastExtensionHeader(structType any) ExtensionHeader {
	if casted, ok := structType.(ExtensionHeader); ok {
		return casted
	}
	if casted, ok := structType.(*ExtensionHeader); ok {
		return *casted
	}
	return nil
}

func (m *_ExtensionHeader) GetTypeName() string {
	return "ExtensionHeader"
}

func (m *_ExtensionHeader) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Reserved Field (reserved)
	lengthInBits += 5

	// Simple field (xmlbody)
	lengthInBits += 1

	// Simple field (binaryBody)
	lengthInBits += 1

	return lengthInBits
}

func (m *_ExtensionHeader) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ExtensionHeaderParse(ctx context.Context, theBytes []byte) (ExtensionHeader, error) {
	return ExtensionHeaderParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func ExtensionHeaderParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (ExtensionHeader, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("ExtensionHeader"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ExtensionHeader")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	var reservedField0 *int8
	// Reserved Field (Compartmentalized so the "reserved" variable can't leak)
	{
		reserved, _err := readBuffer.ReadInt8("reserved", 5)
		if _err != nil {
			return nil, errors.Wrap(_err, "Error parsing 'reserved' field of ExtensionHeader")
		}
		if reserved != int8(0x00) {
			log.Info().Fields(map[string]any{
				"expected value": int8(0x00),
				"got value":      reserved,
			}).Msg("Got unexpected response for reserved field.")
			// We save the value, so it can be re-serialized
			reservedField0 = &reserved
		}
	}

	// Simple Field (xmlbody)
	_xmlbody, _xmlbodyErr := readBuffer.ReadBit("xmlbody")
	if _xmlbodyErr != nil {
		return nil, errors.Wrap(_xmlbodyErr, "Error parsing 'xmlbody' field of ExtensionHeader")
	}
	xmlbody := _xmlbody

	// Simple Field (binaryBody)
	_binaryBody, _binaryBodyErr := readBuffer.ReadBit("binaryBody")
	if _binaryBodyErr != nil {
		return nil, errors.Wrap(_binaryBodyErr, "Error parsing 'binaryBody' field of ExtensionHeader")
	}
	binaryBody := _binaryBody

	if closeErr := readBuffer.CloseContext("ExtensionHeader"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ExtensionHeader")
	}

	// Create the instance
	return &_ExtensionHeader{
		Xmlbody:        xmlbody,
		BinaryBody:     binaryBody,
		reservedField0: reservedField0,
	}, nil
}

func (m *_ExtensionHeader) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ExtensionHeader) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("ExtensionHeader"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for ExtensionHeader")
	}

	// Reserved Field (reserved)
	{
		var reserved int8 = int8(0x00)
		if m.reservedField0 != nil {
			log.Info().Fields(map[string]any{
				"expected value": int8(0x00),
				"got value":      reserved,
			}).Msg("Overriding reserved field with unexpected value.")
			reserved = *m.reservedField0
		}
		_err := writeBuffer.WriteInt8("reserved", 5, int8(reserved))
		if _err != nil {
			return errors.Wrap(_err, "Error serializing 'reserved' field")
		}
	}

	// Simple Field (xmlbody)
	xmlbody := bool(m.GetXmlbody())
	_xmlbodyErr := writeBuffer.WriteBit("xmlbody", (xmlbody))
	if _xmlbodyErr != nil {
		return errors.Wrap(_xmlbodyErr, "Error serializing 'xmlbody' field")
	}

	// Simple Field (binaryBody)
	binaryBody := bool(m.GetBinaryBody())
	_binaryBodyErr := writeBuffer.WriteBit("binaryBody", (binaryBody))
	if _binaryBodyErr != nil {
		return errors.Wrap(_binaryBodyErr, "Error serializing 'binaryBody' field")
	}

	if popErr := writeBuffer.PopContext("ExtensionHeader"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for ExtensionHeader")
	}
	return nil
}

func (m *_ExtensionHeader) isExtensionHeader() bool {
	return true
}

func (m *_ExtensionHeader) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
