/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// ExtensiblePayload is the corresponding interface of ExtensiblePayload
type ExtensiblePayload interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	Payload
	// GetPayload returns Payload (property field)
	GetPayload() ExtensionObject
}

// ExtensiblePayloadExactly can be used when we want exactly this type and not a type which fulfills ExtensiblePayload.
// This is useful for switch cases.
type ExtensiblePayloadExactly interface {
	ExtensiblePayload
	isExtensiblePayload() bool
}

// _ExtensiblePayload is the data-structure of this message
type _ExtensiblePayload struct {
	*_Payload
	Payload ExtensionObject
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ExtensiblePayload) GetExtensible() bool {
	return bool(true)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ExtensiblePayload) InitializeParent(parent Payload, sequenceHeader SequenceHeader) {
	m.SequenceHeader = sequenceHeader
}

func (m *_ExtensiblePayload) GetParent() Payload {
	return m._Payload
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ExtensiblePayload) GetPayload() ExtensionObject {
	return m.Payload
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewExtensiblePayload factory function for _ExtensiblePayload
func NewExtensiblePayload(payload ExtensionObject, sequenceHeader SequenceHeader, byteCount uint32) *_ExtensiblePayload {
	_result := &_ExtensiblePayload{
		Payload:  payload,
		_Payload: NewPayload(sequenceHeader, byteCount),
	}
	_result._Payload._PayloadChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastExtensiblePayload(structType any) ExtensiblePayload {
	if casted, ok := structType.(ExtensiblePayload); ok {
		return casted
	}
	if casted, ok := structType.(*ExtensiblePayload); ok {
		return *casted
	}
	return nil
}

func (m *_ExtensiblePayload) GetTypeName() string {
	return "ExtensiblePayload"
}

func (m *_ExtensiblePayload) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (payload)
	lengthInBits += m.Payload.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_ExtensiblePayload) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ExtensiblePayloadParse(ctx context.Context, theBytes []byte, extensible bool, byteCount uint32) (ExtensiblePayload, error) {
	return ExtensiblePayloadParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), extensible, byteCount)
}

func ExtensiblePayloadParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, extensible bool, byteCount uint32) (ExtensiblePayload, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("ExtensiblePayload"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ExtensiblePayload")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (payload)
	if pullErr := readBuffer.PullContext("payload"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for payload")
	}
	_payload, _payloadErr := ExtensionObjectParseWithBuffer(ctx, readBuffer, bool(bool(false)))
	if _payloadErr != nil {
		return nil, errors.Wrap(_payloadErr, "Error parsing 'payload' field of ExtensiblePayload")
	}
	payload := _payload.(ExtensionObject)
	if closeErr := readBuffer.CloseContext("payload"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for payload")
	}

	if closeErr := readBuffer.CloseContext("ExtensiblePayload"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ExtensiblePayload")
	}

	// Create a partially initialized instance
	_child := &_ExtensiblePayload{
		_Payload: &_Payload{
			ByteCount: byteCount,
		},
		Payload: payload,
	}
	_child._Payload._PayloadChildRequirements = _child
	return _child, nil
}

func (m *_ExtensiblePayload) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ExtensiblePayload) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ExtensiblePayload"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ExtensiblePayload")
		}

		// Simple Field (payload)
		if pushErr := writeBuffer.PushContext("payload"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for payload")
		}
		_payloadErr := writeBuffer.WriteSerializable(ctx, m.GetPayload())
		if popErr := writeBuffer.PopContext("payload"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for payload")
		}
		if _payloadErr != nil {
			return errors.Wrap(_payloadErr, "Error serializing 'payload' field")
		}

		if popErr := writeBuffer.PopContext("ExtensiblePayload"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ExtensiblePayload")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ExtensiblePayload) isExtensiblePayload() bool {
	return true
}

func (m *_ExtensiblePayload) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
