/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// EventNotifierType is an enum
type EventNotifierType uint8

type IEventNotifierType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	EventNotifierType_eventNotifierTypeNone              EventNotifierType = 0
	EventNotifierType_eventNotifierTypeSubscribeToEvents EventNotifierType = 1
	EventNotifierType_eventNotifierTypeHistoryRead       EventNotifierType = 4
	EventNotifierType_eventNotifierTypeHistoryWrite      EventNotifierType = 8
)

var EventNotifierTypeValues []EventNotifierType

func init() {
	_ = errors.New
	EventNotifierTypeValues = []EventNotifierType{
		EventNotifierType_eventNotifierTypeNone,
		EventNotifierType_eventNotifierTypeSubscribeToEvents,
		EventNotifierType_eventNotifierTypeHistoryRead,
		EventNotifierType_eventNotifierTypeHistoryWrite,
	}
}

func EventNotifierTypeByValue(value uint8) (enum EventNotifierType, ok bool) {
	switch value {
	case 0:
		return EventNotifierType_eventNotifierTypeNone, true
	case 1:
		return EventNotifierType_eventNotifierTypeSubscribeToEvents, true
	case 4:
		return EventNotifierType_eventNotifierTypeHistoryRead, true
	case 8:
		return EventNotifierType_eventNotifierTypeHistoryWrite, true
	}
	return 0, false
}

func EventNotifierTypeByName(value string) (enum EventNotifierType, ok bool) {
	switch value {
	case "eventNotifierTypeNone":
		return EventNotifierType_eventNotifierTypeNone, true
	case "eventNotifierTypeSubscribeToEvents":
		return EventNotifierType_eventNotifierTypeSubscribeToEvents, true
	case "eventNotifierTypeHistoryRead":
		return EventNotifierType_eventNotifierTypeHistoryRead, true
	case "eventNotifierTypeHistoryWrite":
		return EventNotifierType_eventNotifierTypeHistoryWrite, true
	}
	return 0, false
}

func EventNotifierTypeKnows(value uint8) bool {
	for _, typeValue := range EventNotifierTypeValues {
		if uint8(typeValue) == value {
			return true
		}
	}
	return false
}

func CastEventNotifierType(structType any) EventNotifierType {
	castFunc := func(typ any) EventNotifierType {
		if sEventNotifierType, ok := typ.(EventNotifierType); ok {
			return sEventNotifierType
		}
		return 0
	}
	return castFunc(structType)
}

func (m EventNotifierType) GetLengthInBits(ctx context.Context) uint16 {
	return 8
}

func (m EventNotifierType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func EventNotifierTypeParse(ctx context.Context, theBytes []byte) (EventNotifierType, error) {
	return EventNotifierTypeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func EventNotifierTypeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (EventNotifierType, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadUint8("EventNotifierType", 8)
	if err != nil {
		return 0, errors.Wrap(err, "error reading EventNotifierType")
	}
	if enum, ok := EventNotifierTypeByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for EventNotifierType")
		return EventNotifierType(val), nil
	} else {
		return enum, nil
	}
}

func (e EventNotifierType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e EventNotifierType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteUint8("EventNotifierType", 8, uint8(uint8(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e EventNotifierType) PLC4XEnumName() string {
	switch e {
	case EventNotifierType_eventNotifierTypeNone:
		return "eventNotifierTypeNone"
	case EventNotifierType_eventNotifierTypeSubscribeToEvents:
		return "eventNotifierTypeSubscribeToEvents"
	case EventNotifierType_eventNotifierTypeHistoryRead:
		return "eventNotifierTypeHistoryRead"
	case EventNotifierType_eventNotifierTypeHistoryWrite:
		return "eventNotifierTypeHistoryWrite"
	}
	return fmt.Sprintf("Unknown(%v)", uint8(e))
}

func (e EventNotifierType) String() string {
	return e.PLC4XEnumName()
}
