/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// EndpointType is the corresponding interface of EndpointType
type EndpointType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetEndpointUrl returns EndpointUrl (property field)
	GetEndpointUrl() PascalString
	// GetSecurityMode returns SecurityMode (property field)
	GetSecurityMode() MessageSecurityMode
	// GetSecurityPolicyUri returns SecurityPolicyUri (property field)
	GetSecurityPolicyUri() PascalString
	// GetTransportProfileUri returns TransportProfileUri (property field)
	GetTransportProfileUri() PascalString
}

// EndpointTypeExactly can be used when we want exactly this type and not a type which fulfills EndpointType.
// This is useful for switch cases.
type EndpointTypeExactly interface {
	EndpointType
	isEndpointType() bool
}

// _EndpointType is the data-structure of this message
type _EndpointType struct {
	*_ExtensionObjectDefinition
	EndpointUrl         PascalString
	SecurityMode        MessageSecurityMode
	SecurityPolicyUri   PascalString
	TransportProfileUri PascalString
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_EndpointType) GetIdentifier() string {
	return "15530"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_EndpointType) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_EndpointType) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_EndpointType) GetEndpointUrl() PascalString {
	return m.EndpointUrl
}

func (m *_EndpointType) GetSecurityMode() MessageSecurityMode {
	return m.SecurityMode
}

func (m *_EndpointType) GetSecurityPolicyUri() PascalString {
	return m.SecurityPolicyUri
}

func (m *_EndpointType) GetTransportProfileUri() PascalString {
	return m.TransportProfileUri
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewEndpointType factory function for _EndpointType
func NewEndpointType(endpointUrl PascalString, securityMode MessageSecurityMode, securityPolicyUri PascalString, transportProfileUri PascalString) *_EndpointType {
	_result := &_EndpointType{
		EndpointUrl:                endpointUrl,
		SecurityMode:               securityMode,
		SecurityPolicyUri:          securityPolicyUri,
		TransportProfileUri:        transportProfileUri,
		_ExtensionObjectDefinition: NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastEndpointType(structType any) EndpointType {
	if casted, ok := structType.(EndpointType); ok {
		return casted
	}
	if casted, ok := structType.(*EndpointType); ok {
		return *casted
	}
	return nil
}

func (m *_EndpointType) GetTypeName() string {
	return "EndpointType"
}

func (m *_EndpointType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (endpointUrl)
	lengthInBits += m.EndpointUrl.GetLengthInBits(ctx)

	// Simple field (securityMode)
	lengthInBits += 32

	// Simple field (securityPolicyUri)
	lengthInBits += m.SecurityPolicyUri.GetLengthInBits(ctx)

	// Simple field (transportProfileUri)
	lengthInBits += m.TransportProfileUri.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_EndpointType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func EndpointTypeParse(ctx context.Context, theBytes []byte, identifier string) (EndpointType, error) {
	return EndpointTypeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func EndpointTypeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (EndpointType, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("EndpointType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for EndpointType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (endpointUrl)
	if pullErr := readBuffer.PullContext("endpointUrl"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for endpointUrl")
	}
	_endpointUrl, _endpointUrlErr := PascalStringParseWithBuffer(ctx, readBuffer)
	if _endpointUrlErr != nil {
		return nil, errors.Wrap(_endpointUrlErr, "Error parsing 'endpointUrl' field of EndpointType")
	}
	endpointUrl := _endpointUrl.(PascalString)
	if closeErr := readBuffer.CloseContext("endpointUrl"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for endpointUrl")
	}

	// Simple Field (securityMode)
	if pullErr := readBuffer.PullContext("securityMode"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for securityMode")
	}
	_securityMode, _securityModeErr := MessageSecurityModeParseWithBuffer(ctx, readBuffer)
	if _securityModeErr != nil {
		return nil, errors.Wrap(_securityModeErr, "Error parsing 'securityMode' field of EndpointType")
	}
	securityMode := _securityMode
	if closeErr := readBuffer.CloseContext("securityMode"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for securityMode")
	}

	// Simple Field (securityPolicyUri)
	if pullErr := readBuffer.PullContext("securityPolicyUri"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for securityPolicyUri")
	}
	_securityPolicyUri, _securityPolicyUriErr := PascalStringParseWithBuffer(ctx, readBuffer)
	if _securityPolicyUriErr != nil {
		return nil, errors.Wrap(_securityPolicyUriErr, "Error parsing 'securityPolicyUri' field of EndpointType")
	}
	securityPolicyUri := _securityPolicyUri.(PascalString)
	if closeErr := readBuffer.CloseContext("securityPolicyUri"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for securityPolicyUri")
	}

	// Simple Field (transportProfileUri)
	if pullErr := readBuffer.PullContext("transportProfileUri"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for transportProfileUri")
	}
	_transportProfileUri, _transportProfileUriErr := PascalStringParseWithBuffer(ctx, readBuffer)
	if _transportProfileUriErr != nil {
		return nil, errors.Wrap(_transportProfileUriErr, "Error parsing 'transportProfileUri' field of EndpointType")
	}
	transportProfileUri := _transportProfileUri.(PascalString)
	if closeErr := readBuffer.CloseContext("transportProfileUri"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for transportProfileUri")
	}

	if closeErr := readBuffer.CloseContext("EndpointType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for EndpointType")
	}

	// Create a partially initialized instance
	_child := &_EndpointType{
		_ExtensionObjectDefinition: &_ExtensionObjectDefinition{},
		EndpointUrl:                endpointUrl,
		SecurityMode:               securityMode,
		SecurityPolicyUri:          securityPolicyUri,
		TransportProfileUri:        transportProfileUri,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_EndpointType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_EndpointType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("EndpointType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for EndpointType")
		}

		// Simple Field (endpointUrl)
		if pushErr := writeBuffer.PushContext("endpointUrl"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for endpointUrl")
		}
		_endpointUrlErr := writeBuffer.WriteSerializable(ctx, m.GetEndpointUrl())
		if popErr := writeBuffer.PopContext("endpointUrl"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for endpointUrl")
		}
		if _endpointUrlErr != nil {
			return errors.Wrap(_endpointUrlErr, "Error serializing 'endpointUrl' field")
		}

		// Simple Field (securityMode)
		if pushErr := writeBuffer.PushContext("securityMode"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for securityMode")
		}
		_securityModeErr := writeBuffer.WriteSerializable(ctx, m.GetSecurityMode())
		if popErr := writeBuffer.PopContext("securityMode"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for securityMode")
		}
		if _securityModeErr != nil {
			return errors.Wrap(_securityModeErr, "Error serializing 'securityMode' field")
		}

		// Simple Field (securityPolicyUri)
		if pushErr := writeBuffer.PushContext("securityPolicyUri"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for securityPolicyUri")
		}
		_securityPolicyUriErr := writeBuffer.WriteSerializable(ctx, m.GetSecurityPolicyUri())
		if popErr := writeBuffer.PopContext("securityPolicyUri"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for securityPolicyUri")
		}
		if _securityPolicyUriErr != nil {
			return errors.Wrap(_securityPolicyUriErr, "Error serializing 'securityPolicyUri' field")
		}

		// Simple Field (transportProfileUri)
		if pushErr := writeBuffer.PushContext("transportProfileUri"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for transportProfileUri")
		}
		_transportProfileUriErr := writeBuffer.WriteSerializable(ctx, m.GetTransportProfileUri())
		if popErr := writeBuffer.PopContext("transportProfileUri"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for transportProfileUri")
		}
		if _transportProfileUriErr != nil {
			return errors.Wrap(_transportProfileUriErr, "Error serializing 'transportProfileUri' field")
		}

		if popErr := writeBuffer.PopContext("EndpointType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for EndpointType")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_EndpointType) isEndpointType() bool {
	return true
}

func (m *_EndpointType) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
