/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// Date is the corresponding interface of Date
type Date interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

// DateExactly can be used when we want exactly this type and not a type which fulfills Date.
// This is useful for switch cases.
type DateExactly interface {
	Date
	isDate() bool
}

// _Date is the data-structure of this message
type _Date struct {
}

// NewDate factory function for _Date
func NewDate() *_Date {
	return &_Date{}
}

// Deprecated: use the interface for direct cast
func CastDate(structType any) Date {
	if casted, ok := structType.(Date); ok {
		return casted
	}
	if casted, ok := structType.(*Date); ok {
		return *casted
	}
	return nil
}

func (m *_Date) GetTypeName() string {
	return "Date"
}

func (m *_Date) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	return lengthInBits
}

func (m *_Date) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func DateParse(ctx context.Context, theBytes []byte) (Date, error) {
	return DateParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func DateParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (Date, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("Date"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for Date")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("Date"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for Date")
	}

	// Create the instance
	return &_Date{}, nil
}

func (m *_Date) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_Date) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("Date"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for Date")
	}

	if popErr := writeBuffer.PopContext("Date"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for Date")
	}
	return nil
}

func (m *_Date) isDate() bool {
	return true
}

func (m *_Date) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
