/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
	"io"
)

// Code generated by code-generation. DO NOT EDIT.

// DataValue is the corresponding interface of DataValue
type DataValue interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	// GetServerPicosecondsSpecified returns ServerPicosecondsSpecified (property field)
	GetServerPicosecondsSpecified() bool
	// GetSourcePicosecondsSpecified returns SourcePicosecondsSpecified (property field)
	GetSourcePicosecondsSpecified() bool
	// GetServerTimestampSpecified returns ServerTimestampSpecified (property field)
	GetServerTimestampSpecified() bool
	// GetSourceTimestampSpecified returns SourceTimestampSpecified (property field)
	GetSourceTimestampSpecified() bool
	// GetStatusCodeSpecified returns StatusCodeSpecified (property field)
	GetStatusCodeSpecified() bool
	// GetValueSpecified returns ValueSpecified (property field)
	GetValueSpecified() bool
	// GetValue returns Value (property field)
	GetValue() Variant
	// GetStatusCode returns StatusCode (property field)
	GetStatusCode() StatusCode
	// GetSourceTimestamp returns SourceTimestamp (property field)
	GetSourceTimestamp() *int64
	// GetSourcePicoseconds returns SourcePicoseconds (property field)
	GetSourcePicoseconds() *uint16
	// GetServerTimestamp returns ServerTimestamp (property field)
	GetServerTimestamp() *int64
	// GetServerPicoseconds returns ServerPicoseconds (property field)
	GetServerPicoseconds() *uint16
}

// DataValueExactly can be used when we want exactly this type and not a type which fulfills DataValue.
// This is useful for switch cases.
type DataValueExactly interface {
	DataValue
	isDataValue() bool
}

// _DataValue is the data-structure of this message
type _DataValue struct {
	ServerPicosecondsSpecified bool
	SourcePicosecondsSpecified bool
	ServerTimestampSpecified   bool
	SourceTimestampSpecified   bool
	StatusCodeSpecified        bool
	ValueSpecified             bool
	Value                      Variant
	StatusCode                 StatusCode
	SourceTimestamp            *int64
	SourcePicoseconds          *uint16
	ServerTimestamp            *int64
	ServerPicoseconds          *uint16
	// Reserved Fields
	reservedField0 *uint8
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_DataValue) GetServerPicosecondsSpecified() bool {
	return m.ServerPicosecondsSpecified
}

func (m *_DataValue) GetSourcePicosecondsSpecified() bool {
	return m.SourcePicosecondsSpecified
}

func (m *_DataValue) GetServerTimestampSpecified() bool {
	return m.ServerTimestampSpecified
}

func (m *_DataValue) GetSourceTimestampSpecified() bool {
	return m.SourceTimestampSpecified
}

func (m *_DataValue) GetStatusCodeSpecified() bool {
	return m.StatusCodeSpecified
}

func (m *_DataValue) GetValueSpecified() bool {
	return m.ValueSpecified
}

func (m *_DataValue) GetValue() Variant {
	return m.Value
}

func (m *_DataValue) GetStatusCode() StatusCode {
	return m.StatusCode
}

func (m *_DataValue) GetSourceTimestamp() *int64 {
	return m.SourceTimestamp
}

func (m *_DataValue) GetSourcePicoseconds() *uint16 {
	return m.SourcePicoseconds
}

func (m *_DataValue) GetServerTimestamp() *int64 {
	return m.ServerTimestamp
}

func (m *_DataValue) GetServerPicoseconds() *uint16 {
	return m.ServerPicoseconds
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewDataValue factory function for _DataValue
func NewDataValue(serverPicosecondsSpecified bool, sourcePicosecondsSpecified bool, serverTimestampSpecified bool, sourceTimestampSpecified bool, statusCodeSpecified bool, valueSpecified bool, value Variant, statusCode StatusCode, sourceTimestamp *int64, sourcePicoseconds *uint16, serverTimestamp *int64, serverPicoseconds *uint16) *_DataValue {
	return &_DataValue{ServerPicosecondsSpecified: serverPicosecondsSpecified, SourcePicosecondsSpecified: sourcePicosecondsSpecified, ServerTimestampSpecified: serverTimestampSpecified, SourceTimestampSpecified: sourceTimestampSpecified, StatusCodeSpecified: statusCodeSpecified, ValueSpecified: valueSpecified, Value: value, StatusCode: statusCode, SourceTimestamp: sourceTimestamp, SourcePicoseconds: sourcePicoseconds, ServerTimestamp: serverTimestamp, ServerPicoseconds: serverPicoseconds}
}

// Deprecated: use the interface for direct cast
func CastDataValue(structType any) DataValue {
	if casted, ok := structType.(DataValue); ok {
		return casted
	}
	if casted, ok := structType.(*DataValue); ok {
		return *casted
	}
	return nil
}

func (m *_DataValue) GetTypeName() string {
	return "DataValue"
}

func (m *_DataValue) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Reserved Field (reserved)
	lengthInBits += 2

	// Simple field (serverPicosecondsSpecified)
	lengthInBits += 1

	// Simple field (sourcePicosecondsSpecified)
	lengthInBits += 1

	// Simple field (serverTimestampSpecified)
	lengthInBits += 1

	// Simple field (sourceTimestampSpecified)
	lengthInBits += 1

	// Simple field (statusCodeSpecified)
	lengthInBits += 1

	// Simple field (valueSpecified)
	lengthInBits += 1

	// Optional Field (value)
	if m.Value != nil {
		lengthInBits += m.Value.GetLengthInBits(ctx)
	}

	// Optional Field (statusCode)
	if m.StatusCode != nil {
		lengthInBits += m.StatusCode.GetLengthInBits(ctx)
	}

	// Optional Field (sourceTimestamp)
	if m.SourceTimestamp != nil {
		lengthInBits += 64
	}

	// Optional Field (sourcePicoseconds)
	if m.SourcePicoseconds != nil {
		lengthInBits += 16
	}

	// Optional Field (serverTimestamp)
	if m.ServerTimestamp != nil {
		lengthInBits += 64
	}

	// Optional Field (serverPicoseconds)
	if m.ServerPicoseconds != nil {
		lengthInBits += 16
	}

	return lengthInBits
}

func (m *_DataValue) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func DataValueParse(ctx context.Context, theBytes []byte) (DataValue, error) {
	return DataValueParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func DataValueParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (DataValue, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("DataValue"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for DataValue")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	var reservedField0 *uint8
	// Reserved Field (Compartmentalized so the "reserved" variable can't leak)
	{
		reserved, _err := readBuffer.ReadUint8("reserved", 2)
		if _err != nil {
			return nil, errors.Wrap(_err, "Error parsing 'reserved' field of DataValue")
		}
		if reserved != uint8(0x00) {
			log.Info().Fields(map[string]any{
				"expected value": uint8(0x00),
				"got value":      reserved,
			}).Msg("Got unexpected response for reserved field.")
			// We save the value, so it can be re-serialized
			reservedField0 = &reserved
		}
	}

	// Simple Field (serverPicosecondsSpecified)
	_serverPicosecondsSpecified, _serverPicosecondsSpecifiedErr := readBuffer.ReadBit("serverPicosecondsSpecified")
	if _serverPicosecondsSpecifiedErr != nil {
		return nil, errors.Wrap(_serverPicosecondsSpecifiedErr, "Error parsing 'serverPicosecondsSpecified' field of DataValue")
	}
	serverPicosecondsSpecified := _serverPicosecondsSpecified

	// Simple Field (sourcePicosecondsSpecified)
	_sourcePicosecondsSpecified, _sourcePicosecondsSpecifiedErr := readBuffer.ReadBit("sourcePicosecondsSpecified")
	if _sourcePicosecondsSpecifiedErr != nil {
		return nil, errors.Wrap(_sourcePicosecondsSpecifiedErr, "Error parsing 'sourcePicosecondsSpecified' field of DataValue")
	}
	sourcePicosecondsSpecified := _sourcePicosecondsSpecified

	// Simple Field (serverTimestampSpecified)
	_serverTimestampSpecified, _serverTimestampSpecifiedErr := readBuffer.ReadBit("serverTimestampSpecified")
	if _serverTimestampSpecifiedErr != nil {
		return nil, errors.Wrap(_serverTimestampSpecifiedErr, "Error parsing 'serverTimestampSpecified' field of DataValue")
	}
	serverTimestampSpecified := _serverTimestampSpecified

	// Simple Field (sourceTimestampSpecified)
	_sourceTimestampSpecified, _sourceTimestampSpecifiedErr := readBuffer.ReadBit("sourceTimestampSpecified")
	if _sourceTimestampSpecifiedErr != nil {
		return nil, errors.Wrap(_sourceTimestampSpecifiedErr, "Error parsing 'sourceTimestampSpecified' field of DataValue")
	}
	sourceTimestampSpecified := _sourceTimestampSpecified

	// Simple Field (statusCodeSpecified)
	_statusCodeSpecified, _statusCodeSpecifiedErr := readBuffer.ReadBit("statusCodeSpecified")
	if _statusCodeSpecifiedErr != nil {
		return nil, errors.Wrap(_statusCodeSpecifiedErr, "Error parsing 'statusCodeSpecified' field of DataValue")
	}
	statusCodeSpecified := _statusCodeSpecified

	// Simple Field (valueSpecified)
	_valueSpecified, _valueSpecifiedErr := readBuffer.ReadBit("valueSpecified")
	if _valueSpecifiedErr != nil {
		return nil, errors.Wrap(_valueSpecifiedErr, "Error parsing 'valueSpecified' field of DataValue")
	}
	valueSpecified := _valueSpecified

	// Optional Field (value) (Can be skipped, if a given expression evaluates to false)
	var value Variant = nil
	if valueSpecified {
		currentPos = positionAware.GetPos()
		if pullErr := readBuffer.PullContext("value"); pullErr != nil {
			return nil, errors.Wrap(pullErr, "Error pulling for value")
		}
		_val, _err := VariantParseWithBuffer(ctx, readBuffer)
		switch {
		case errors.Is(_err, utils.ParseAssertError{}) || errors.Is(_err, io.EOF):
			log.Debug().Err(_err).Msg("Resetting position because optional threw an error")
			readBuffer.Reset(currentPos)
		case _err != nil:
			return nil, errors.Wrap(_err, "Error parsing 'value' field of DataValue")
		default:
			value = _val.(Variant)
			if closeErr := readBuffer.CloseContext("value"); closeErr != nil {
				return nil, errors.Wrap(closeErr, "Error closing for value")
			}
		}
	}

	// Optional Field (statusCode) (Can be skipped, if a given expression evaluates to false)
	var statusCode StatusCode = nil
	if statusCodeSpecified {
		currentPos = positionAware.GetPos()
		if pullErr := readBuffer.PullContext("statusCode"); pullErr != nil {
			return nil, errors.Wrap(pullErr, "Error pulling for statusCode")
		}
		_val, _err := StatusCodeParseWithBuffer(ctx, readBuffer)
		switch {
		case errors.Is(_err, utils.ParseAssertError{}) || errors.Is(_err, io.EOF):
			log.Debug().Err(_err).Msg("Resetting position because optional threw an error")
			readBuffer.Reset(currentPos)
		case _err != nil:
			return nil, errors.Wrap(_err, "Error parsing 'statusCode' field of DataValue")
		default:
			statusCode = _val.(StatusCode)
			if closeErr := readBuffer.CloseContext("statusCode"); closeErr != nil {
				return nil, errors.Wrap(closeErr, "Error closing for statusCode")
			}
		}
	}

	// Optional Field (sourceTimestamp) (Can be skipped, if a given expression evaluates to false)
	var sourceTimestamp *int64 = nil
	if sourceTimestampSpecified {
		_val, _err := readBuffer.ReadInt64("sourceTimestamp", 64)
		if _err != nil {
			return nil, errors.Wrap(_err, "Error parsing 'sourceTimestamp' field of DataValue")
		}
		sourceTimestamp = &_val
	}

	// Optional Field (sourcePicoseconds) (Can be skipped, if a given expression evaluates to false)
	var sourcePicoseconds *uint16 = nil
	if sourcePicosecondsSpecified {
		_val, _err := readBuffer.ReadUint16("sourcePicoseconds", 16)
		if _err != nil {
			return nil, errors.Wrap(_err, "Error parsing 'sourcePicoseconds' field of DataValue")
		}
		sourcePicoseconds = &_val
	}

	// Optional Field (serverTimestamp) (Can be skipped, if a given expression evaluates to false)
	var serverTimestamp *int64 = nil
	if serverTimestampSpecified {
		_val, _err := readBuffer.ReadInt64("serverTimestamp", 64)
		if _err != nil {
			return nil, errors.Wrap(_err, "Error parsing 'serverTimestamp' field of DataValue")
		}
		serverTimestamp = &_val
	}

	// Optional Field (serverPicoseconds) (Can be skipped, if a given expression evaluates to false)
	var serverPicoseconds *uint16 = nil
	if serverPicosecondsSpecified {
		_val, _err := readBuffer.ReadUint16("serverPicoseconds", 16)
		if _err != nil {
			return nil, errors.Wrap(_err, "Error parsing 'serverPicoseconds' field of DataValue")
		}
		serverPicoseconds = &_val
	}

	if closeErr := readBuffer.CloseContext("DataValue"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for DataValue")
	}

	// Create the instance
	return &_DataValue{
		ServerPicosecondsSpecified: serverPicosecondsSpecified,
		SourcePicosecondsSpecified: sourcePicosecondsSpecified,
		ServerTimestampSpecified:   serverTimestampSpecified,
		SourceTimestampSpecified:   sourceTimestampSpecified,
		StatusCodeSpecified:        statusCodeSpecified,
		ValueSpecified:             valueSpecified,
		Value:                      value,
		StatusCode:                 statusCode,
		SourceTimestamp:            sourceTimestamp,
		SourcePicoseconds:          sourcePicoseconds,
		ServerTimestamp:            serverTimestamp,
		ServerPicoseconds:          serverPicoseconds,
		reservedField0:             reservedField0,
	}, nil
}

func (m *_DataValue) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_DataValue) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("DataValue"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for DataValue")
	}

	// Reserved Field (reserved)
	{
		var reserved uint8 = uint8(0x00)
		if m.reservedField0 != nil {
			log.Info().Fields(map[string]any{
				"expected value": uint8(0x00),
				"got value":      reserved,
			}).Msg("Overriding reserved field with unexpected value.")
			reserved = *m.reservedField0
		}
		_err := writeBuffer.WriteUint8("reserved", 2, uint8(reserved))
		if _err != nil {
			return errors.Wrap(_err, "Error serializing 'reserved' field")
		}
	}

	// Simple Field (serverPicosecondsSpecified)
	serverPicosecondsSpecified := bool(m.GetServerPicosecondsSpecified())
	_serverPicosecondsSpecifiedErr := writeBuffer.WriteBit("serverPicosecondsSpecified", (serverPicosecondsSpecified))
	if _serverPicosecondsSpecifiedErr != nil {
		return errors.Wrap(_serverPicosecondsSpecifiedErr, "Error serializing 'serverPicosecondsSpecified' field")
	}

	// Simple Field (sourcePicosecondsSpecified)
	sourcePicosecondsSpecified := bool(m.GetSourcePicosecondsSpecified())
	_sourcePicosecondsSpecifiedErr := writeBuffer.WriteBit("sourcePicosecondsSpecified", (sourcePicosecondsSpecified))
	if _sourcePicosecondsSpecifiedErr != nil {
		return errors.Wrap(_sourcePicosecondsSpecifiedErr, "Error serializing 'sourcePicosecondsSpecified' field")
	}

	// Simple Field (serverTimestampSpecified)
	serverTimestampSpecified := bool(m.GetServerTimestampSpecified())
	_serverTimestampSpecifiedErr := writeBuffer.WriteBit("serverTimestampSpecified", (serverTimestampSpecified))
	if _serverTimestampSpecifiedErr != nil {
		return errors.Wrap(_serverTimestampSpecifiedErr, "Error serializing 'serverTimestampSpecified' field")
	}

	// Simple Field (sourceTimestampSpecified)
	sourceTimestampSpecified := bool(m.GetSourceTimestampSpecified())
	_sourceTimestampSpecifiedErr := writeBuffer.WriteBit("sourceTimestampSpecified", (sourceTimestampSpecified))
	if _sourceTimestampSpecifiedErr != nil {
		return errors.Wrap(_sourceTimestampSpecifiedErr, "Error serializing 'sourceTimestampSpecified' field")
	}

	// Simple Field (statusCodeSpecified)
	statusCodeSpecified := bool(m.GetStatusCodeSpecified())
	_statusCodeSpecifiedErr := writeBuffer.WriteBit("statusCodeSpecified", (statusCodeSpecified))
	if _statusCodeSpecifiedErr != nil {
		return errors.Wrap(_statusCodeSpecifiedErr, "Error serializing 'statusCodeSpecified' field")
	}

	// Simple Field (valueSpecified)
	valueSpecified := bool(m.GetValueSpecified())
	_valueSpecifiedErr := writeBuffer.WriteBit("valueSpecified", (valueSpecified))
	if _valueSpecifiedErr != nil {
		return errors.Wrap(_valueSpecifiedErr, "Error serializing 'valueSpecified' field")
	}

	// Optional Field (value) (Can be skipped, if the value is null)
	var value Variant = nil
	if m.GetValue() != nil {
		if pushErr := writeBuffer.PushContext("value"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for value")
		}
		value = m.GetValue()
		_valueErr := writeBuffer.WriteSerializable(ctx, value)
		if popErr := writeBuffer.PopContext("value"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for value")
		}
		if _valueErr != nil {
			return errors.Wrap(_valueErr, "Error serializing 'value' field")
		}
	}

	// Optional Field (statusCode) (Can be skipped, if the value is null)
	var statusCode StatusCode = nil
	if m.GetStatusCode() != nil {
		if pushErr := writeBuffer.PushContext("statusCode"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for statusCode")
		}
		statusCode = m.GetStatusCode()
		_statusCodeErr := writeBuffer.WriteSerializable(ctx, statusCode)
		if popErr := writeBuffer.PopContext("statusCode"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for statusCode")
		}
		if _statusCodeErr != nil {
			return errors.Wrap(_statusCodeErr, "Error serializing 'statusCode' field")
		}
	}

	// Optional Field (sourceTimestamp) (Can be skipped, if the value is null)
	var sourceTimestamp *int64 = nil
	if m.GetSourceTimestamp() != nil {
		sourceTimestamp = m.GetSourceTimestamp()
		_sourceTimestampErr := writeBuffer.WriteInt64("sourceTimestamp", 64, int64(*(sourceTimestamp)))
		if _sourceTimestampErr != nil {
			return errors.Wrap(_sourceTimestampErr, "Error serializing 'sourceTimestamp' field")
		}
	}

	// Optional Field (sourcePicoseconds) (Can be skipped, if the value is null)
	var sourcePicoseconds *uint16 = nil
	if m.GetSourcePicoseconds() != nil {
		sourcePicoseconds = m.GetSourcePicoseconds()
		_sourcePicosecondsErr := writeBuffer.WriteUint16("sourcePicoseconds", 16, uint16(*(sourcePicoseconds)))
		if _sourcePicosecondsErr != nil {
			return errors.Wrap(_sourcePicosecondsErr, "Error serializing 'sourcePicoseconds' field")
		}
	}

	// Optional Field (serverTimestamp) (Can be skipped, if the value is null)
	var serverTimestamp *int64 = nil
	if m.GetServerTimestamp() != nil {
		serverTimestamp = m.GetServerTimestamp()
		_serverTimestampErr := writeBuffer.WriteInt64("serverTimestamp", 64, int64(*(serverTimestamp)))
		if _serverTimestampErr != nil {
			return errors.Wrap(_serverTimestampErr, "Error serializing 'serverTimestamp' field")
		}
	}

	// Optional Field (serverPicoseconds) (Can be skipped, if the value is null)
	var serverPicoseconds *uint16 = nil
	if m.GetServerPicoseconds() != nil {
		serverPicoseconds = m.GetServerPicoseconds()
		_serverPicosecondsErr := writeBuffer.WriteUint16("serverPicoseconds", 16, uint16(*(serverPicoseconds)))
		if _serverPicosecondsErr != nil {
			return errors.Wrap(_serverPicosecondsErr, "Error serializing 'serverPicoseconds' field")
		}
	}

	if popErr := writeBuffer.PopContext("DataValue"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for DataValue")
	}
	return nil
}

func (m *_DataValue) isDataValue() bool {
	return true
}

func (m *_DataValue) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
