/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// ConversionLimitEnum is an enum
type ConversionLimitEnum uint32

type IConversionLimitEnum interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	ConversionLimitEnum_conversionLimitEnumNoConversion ConversionLimitEnum = 0
	ConversionLimitEnum_conversionLimitEnumLimited      ConversionLimitEnum = 1
	ConversionLimitEnum_conversionLimitEnumUnlimited    ConversionLimitEnum = 2
)

var ConversionLimitEnumValues []ConversionLimitEnum

func init() {
	_ = errors.New
	ConversionLimitEnumValues = []ConversionLimitEnum{
		ConversionLimitEnum_conversionLimitEnumNoConversion,
		ConversionLimitEnum_conversionLimitEnumLimited,
		ConversionLimitEnum_conversionLimitEnumUnlimited,
	}
}

func ConversionLimitEnumByValue(value uint32) (enum ConversionLimitEnum, ok bool) {
	switch value {
	case 0:
		return ConversionLimitEnum_conversionLimitEnumNoConversion, true
	case 1:
		return ConversionLimitEnum_conversionLimitEnumLimited, true
	case 2:
		return ConversionLimitEnum_conversionLimitEnumUnlimited, true
	}
	return 0, false
}

func ConversionLimitEnumByName(value string) (enum ConversionLimitEnum, ok bool) {
	switch value {
	case "conversionLimitEnumNoConversion":
		return ConversionLimitEnum_conversionLimitEnumNoConversion, true
	case "conversionLimitEnumLimited":
		return ConversionLimitEnum_conversionLimitEnumLimited, true
	case "conversionLimitEnumUnlimited":
		return ConversionLimitEnum_conversionLimitEnumUnlimited, true
	}
	return 0, false
}

func ConversionLimitEnumKnows(value uint32) bool {
	for _, typeValue := range ConversionLimitEnumValues {
		if uint32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastConversionLimitEnum(structType any) ConversionLimitEnum {
	castFunc := func(typ any) ConversionLimitEnum {
		if sConversionLimitEnum, ok := typ.(ConversionLimitEnum); ok {
			return sConversionLimitEnum
		}
		return 0
	}
	return castFunc(structType)
}

func (m ConversionLimitEnum) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m ConversionLimitEnum) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ConversionLimitEnumParse(ctx context.Context, theBytes []byte) (ConversionLimitEnum, error) {
	return ConversionLimitEnumParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func ConversionLimitEnumParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (ConversionLimitEnum, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadUint32("ConversionLimitEnum", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading ConversionLimitEnum")
	}
	if enum, ok := ConversionLimitEnumByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for ConversionLimitEnum")
		return ConversionLimitEnum(val), nil
	} else {
		return enum, nil
	}
}

func (e ConversionLimitEnum) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e ConversionLimitEnum) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteUint32("ConversionLimitEnum", 32, uint32(uint32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e ConversionLimitEnum) PLC4XEnumName() string {
	switch e {
	case ConversionLimitEnum_conversionLimitEnumNoConversion:
		return "conversionLimitEnumNoConversion"
	case ConversionLimitEnum_conversionLimitEnumLimited:
		return "conversionLimitEnumLimited"
	case ConversionLimitEnum_conversionLimitEnumUnlimited:
		return "conversionLimitEnumUnlimited"
	}
	return fmt.Sprintf("Unknown(%v)", uint32(e))
}

func (e ConversionLimitEnum) String() string {
	return e.PLC4XEnumName()
}
