/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// ContentFilterElementResult is the corresponding interface of ContentFilterElementResult
type ContentFilterElementResult interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetStatusCode returns StatusCode (property field)
	GetStatusCode() StatusCode
	// GetNoOfOperandStatusCodes returns NoOfOperandStatusCodes (property field)
	GetNoOfOperandStatusCodes() int32
	// GetOperandStatusCodes returns OperandStatusCodes (property field)
	GetOperandStatusCodes() []StatusCode
	// GetNoOfOperandDiagnosticInfos returns NoOfOperandDiagnosticInfos (property field)
	GetNoOfOperandDiagnosticInfos() int32
	// GetOperandDiagnosticInfos returns OperandDiagnosticInfos (property field)
	GetOperandDiagnosticInfos() []DiagnosticInfo
}

// ContentFilterElementResultExactly can be used when we want exactly this type and not a type which fulfills ContentFilterElementResult.
// This is useful for switch cases.
type ContentFilterElementResultExactly interface {
	ContentFilterElementResult
	isContentFilterElementResult() bool
}

// _ContentFilterElementResult is the data-structure of this message
type _ContentFilterElementResult struct {
	*_ExtensionObjectDefinition
	StatusCode                 StatusCode
	NoOfOperandStatusCodes     int32
	OperandStatusCodes         []StatusCode
	NoOfOperandDiagnosticInfos int32
	OperandDiagnosticInfos     []DiagnosticInfo
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ContentFilterElementResult) GetIdentifier() string {
	return "606"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ContentFilterElementResult) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_ContentFilterElementResult) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ContentFilterElementResult) GetStatusCode() StatusCode {
	return m.StatusCode
}

func (m *_ContentFilterElementResult) GetNoOfOperandStatusCodes() int32 {
	return m.NoOfOperandStatusCodes
}

func (m *_ContentFilterElementResult) GetOperandStatusCodes() []StatusCode {
	return m.OperandStatusCodes
}

func (m *_ContentFilterElementResult) GetNoOfOperandDiagnosticInfos() int32 {
	return m.NoOfOperandDiagnosticInfos
}

func (m *_ContentFilterElementResult) GetOperandDiagnosticInfos() []DiagnosticInfo {
	return m.OperandDiagnosticInfos
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewContentFilterElementResult factory function for _ContentFilterElementResult
func NewContentFilterElementResult(statusCode StatusCode, noOfOperandStatusCodes int32, operandStatusCodes []StatusCode, noOfOperandDiagnosticInfos int32, operandDiagnosticInfos []DiagnosticInfo) *_ContentFilterElementResult {
	_result := &_ContentFilterElementResult{
		StatusCode:                 statusCode,
		NoOfOperandStatusCodes:     noOfOperandStatusCodes,
		OperandStatusCodes:         operandStatusCodes,
		NoOfOperandDiagnosticInfos: noOfOperandDiagnosticInfos,
		OperandDiagnosticInfos:     operandDiagnosticInfos,
		_ExtensionObjectDefinition: NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastContentFilterElementResult(structType any) ContentFilterElementResult {
	if casted, ok := structType.(ContentFilterElementResult); ok {
		return casted
	}
	if casted, ok := structType.(*ContentFilterElementResult); ok {
		return *casted
	}
	return nil
}

func (m *_ContentFilterElementResult) GetTypeName() string {
	return "ContentFilterElementResult"
}

func (m *_ContentFilterElementResult) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (statusCode)
	lengthInBits += m.StatusCode.GetLengthInBits(ctx)

	// Simple field (noOfOperandStatusCodes)
	lengthInBits += 32

	// Array field
	if len(m.OperandStatusCodes) > 0 {
		for _curItem, element := range m.OperandStatusCodes {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.OperandStatusCodes), _curItem)
			_ = arrayCtx
			_ = _curItem
			lengthInBits += element.(interface{ GetLengthInBits(context.Context) uint16 }).GetLengthInBits(arrayCtx)
		}
	}

	// Simple field (noOfOperandDiagnosticInfos)
	lengthInBits += 32

	// Array field
	if len(m.OperandDiagnosticInfos) > 0 {
		for _curItem, element := range m.OperandDiagnosticInfos {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.OperandDiagnosticInfos), _curItem)
			_ = arrayCtx
			_ = _curItem
			lengthInBits += element.(interface{ GetLengthInBits(context.Context) uint16 }).GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_ContentFilterElementResult) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ContentFilterElementResultParse(ctx context.Context, theBytes []byte, identifier string) (ContentFilterElementResult, error) {
	return ContentFilterElementResultParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func ContentFilterElementResultParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (ContentFilterElementResult, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("ContentFilterElementResult"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ContentFilterElementResult")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (statusCode)
	if pullErr := readBuffer.PullContext("statusCode"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for statusCode")
	}
	_statusCode, _statusCodeErr := StatusCodeParseWithBuffer(ctx, readBuffer)
	if _statusCodeErr != nil {
		return nil, errors.Wrap(_statusCodeErr, "Error parsing 'statusCode' field of ContentFilterElementResult")
	}
	statusCode := _statusCode.(StatusCode)
	if closeErr := readBuffer.CloseContext("statusCode"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for statusCode")
	}

	// Simple Field (noOfOperandStatusCodes)
	_noOfOperandStatusCodes, _noOfOperandStatusCodesErr := readBuffer.ReadInt32("noOfOperandStatusCodes", 32)
	if _noOfOperandStatusCodesErr != nil {
		return nil, errors.Wrap(_noOfOperandStatusCodesErr, "Error parsing 'noOfOperandStatusCodes' field of ContentFilterElementResult")
	}
	noOfOperandStatusCodes := _noOfOperandStatusCodes

	// Array field (operandStatusCodes)
	if pullErr := readBuffer.PullContext("operandStatusCodes", utils.WithRenderAsList(true)); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for operandStatusCodes")
	}
	// Count array
	operandStatusCodes := make([]StatusCode, utils.Max(noOfOperandStatusCodes, 0))
	// This happens when the size is set conditional to 0
	if len(operandStatusCodes) == 0 {
		operandStatusCodes = nil
	}
	{
		_numItems := uint16(utils.Max(noOfOperandStatusCodes, 0))
		for _curItem := uint16(0); _curItem < _numItems; _curItem++ {
			arrayCtx := utils.CreateArrayContext(ctx, int(_numItems), int(_curItem))
			_ = arrayCtx
			_ = _curItem
			_item, _err := StatusCodeParseWithBuffer(arrayCtx, readBuffer)
			if _err != nil {
				return nil, errors.Wrap(_err, "Error parsing 'operandStatusCodes' field of ContentFilterElementResult")
			}
			operandStatusCodes[_curItem] = _item.(StatusCode)
		}
	}
	if closeErr := readBuffer.CloseContext("operandStatusCodes", utils.WithRenderAsList(true)); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for operandStatusCodes")
	}

	// Simple Field (noOfOperandDiagnosticInfos)
	_noOfOperandDiagnosticInfos, _noOfOperandDiagnosticInfosErr := readBuffer.ReadInt32("noOfOperandDiagnosticInfos", 32)
	if _noOfOperandDiagnosticInfosErr != nil {
		return nil, errors.Wrap(_noOfOperandDiagnosticInfosErr, "Error parsing 'noOfOperandDiagnosticInfos' field of ContentFilterElementResult")
	}
	noOfOperandDiagnosticInfos := _noOfOperandDiagnosticInfos

	// Array field (operandDiagnosticInfos)
	if pullErr := readBuffer.PullContext("operandDiagnosticInfos", utils.WithRenderAsList(true)); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for operandDiagnosticInfos")
	}
	// Count array
	operandDiagnosticInfos := make([]DiagnosticInfo, utils.Max(noOfOperandDiagnosticInfos, 0))
	// This happens when the size is set conditional to 0
	if len(operandDiagnosticInfos) == 0 {
		operandDiagnosticInfos = nil
	}
	{
		_numItems := uint16(utils.Max(noOfOperandDiagnosticInfos, 0))
		for _curItem := uint16(0); _curItem < _numItems; _curItem++ {
			arrayCtx := utils.CreateArrayContext(ctx, int(_numItems), int(_curItem))
			_ = arrayCtx
			_ = _curItem
			_item, _err := DiagnosticInfoParseWithBuffer(arrayCtx, readBuffer)
			if _err != nil {
				return nil, errors.Wrap(_err, "Error parsing 'operandDiagnosticInfos' field of ContentFilterElementResult")
			}
			operandDiagnosticInfos[_curItem] = _item.(DiagnosticInfo)
		}
	}
	if closeErr := readBuffer.CloseContext("operandDiagnosticInfos", utils.WithRenderAsList(true)); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for operandDiagnosticInfos")
	}

	if closeErr := readBuffer.CloseContext("ContentFilterElementResult"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ContentFilterElementResult")
	}

	// Create a partially initialized instance
	_child := &_ContentFilterElementResult{
		_ExtensionObjectDefinition: &_ExtensionObjectDefinition{},
		StatusCode:                 statusCode,
		NoOfOperandStatusCodes:     noOfOperandStatusCodes,
		OperandStatusCodes:         operandStatusCodes,
		NoOfOperandDiagnosticInfos: noOfOperandDiagnosticInfos,
		OperandDiagnosticInfos:     operandDiagnosticInfos,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_ContentFilterElementResult) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ContentFilterElementResult) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ContentFilterElementResult"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ContentFilterElementResult")
		}

		// Simple Field (statusCode)
		if pushErr := writeBuffer.PushContext("statusCode"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for statusCode")
		}
		_statusCodeErr := writeBuffer.WriteSerializable(ctx, m.GetStatusCode())
		if popErr := writeBuffer.PopContext("statusCode"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for statusCode")
		}
		if _statusCodeErr != nil {
			return errors.Wrap(_statusCodeErr, "Error serializing 'statusCode' field")
		}

		// Simple Field (noOfOperandStatusCodes)
		noOfOperandStatusCodes := int32(m.GetNoOfOperandStatusCodes())
		_noOfOperandStatusCodesErr := writeBuffer.WriteInt32("noOfOperandStatusCodes", 32, int32((noOfOperandStatusCodes)))
		if _noOfOperandStatusCodesErr != nil {
			return errors.Wrap(_noOfOperandStatusCodesErr, "Error serializing 'noOfOperandStatusCodes' field")
		}

		// Array Field (operandStatusCodes)
		if pushErr := writeBuffer.PushContext("operandStatusCodes", utils.WithRenderAsList(true)); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for operandStatusCodes")
		}
		for _curItem, _element := range m.GetOperandStatusCodes() {
			_ = _curItem
			arrayCtx := utils.CreateArrayContext(ctx, len(m.GetOperandStatusCodes()), _curItem)
			_ = arrayCtx
			_elementErr := writeBuffer.WriteSerializable(arrayCtx, _element)
			if _elementErr != nil {
				return errors.Wrap(_elementErr, "Error serializing 'operandStatusCodes' field")
			}
		}
		if popErr := writeBuffer.PopContext("operandStatusCodes", utils.WithRenderAsList(true)); popErr != nil {
			return errors.Wrap(popErr, "Error popping for operandStatusCodes")
		}

		// Simple Field (noOfOperandDiagnosticInfos)
		noOfOperandDiagnosticInfos := int32(m.GetNoOfOperandDiagnosticInfos())
		_noOfOperandDiagnosticInfosErr := writeBuffer.WriteInt32("noOfOperandDiagnosticInfos", 32, int32((noOfOperandDiagnosticInfos)))
		if _noOfOperandDiagnosticInfosErr != nil {
			return errors.Wrap(_noOfOperandDiagnosticInfosErr, "Error serializing 'noOfOperandDiagnosticInfos' field")
		}

		// Array Field (operandDiagnosticInfos)
		if pushErr := writeBuffer.PushContext("operandDiagnosticInfos", utils.WithRenderAsList(true)); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for operandDiagnosticInfos")
		}
		for _curItem, _element := range m.GetOperandDiagnosticInfos() {
			_ = _curItem
			arrayCtx := utils.CreateArrayContext(ctx, len(m.GetOperandDiagnosticInfos()), _curItem)
			_ = arrayCtx
			_elementErr := writeBuffer.WriteSerializable(arrayCtx, _element)
			if _elementErr != nil {
				return errors.Wrap(_elementErr, "Error serializing 'operandDiagnosticInfos' field")
			}
		}
		if popErr := writeBuffer.PopContext("operandDiagnosticInfos", utils.WithRenderAsList(true)); popErr != nil {
			return errors.Wrap(popErr, "Error popping for operandDiagnosticInfos")
		}

		if popErr := writeBuffer.PopContext("ContentFilterElementResult"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ContentFilterElementResult")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ContentFilterElementResult) isContentFilterElementResult() bool {
	return true
}

func (m *_ContentFilterElementResult) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
