/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// CancelResponse is the corresponding interface of CancelResponse
type CancelResponse interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetResponseHeader returns ResponseHeader (property field)
	GetResponseHeader() ExtensionObjectDefinition
	// GetCancelCount returns CancelCount (property field)
	GetCancelCount() uint32
}

// CancelResponseExactly can be used when we want exactly this type and not a type which fulfills CancelResponse.
// This is useful for switch cases.
type CancelResponseExactly interface {
	CancelResponse
	isCancelResponse() bool
}

// _CancelResponse is the data-structure of this message
type _CancelResponse struct {
	*_ExtensionObjectDefinition
	ResponseHeader ExtensionObjectDefinition
	CancelCount    uint32
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_CancelResponse) GetIdentifier() string {
	return "482"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_CancelResponse) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_CancelResponse) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_CancelResponse) GetResponseHeader() ExtensionObjectDefinition {
	return m.ResponseHeader
}

func (m *_CancelResponse) GetCancelCount() uint32 {
	return m.CancelCount
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewCancelResponse factory function for _CancelResponse
func NewCancelResponse(responseHeader ExtensionObjectDefinition, cancelCount uint32) *_CancelResponse {
	_result := &_CancelResponse{
		ResponseHeader:             responseHeader,
		CancelCount:                cancelCount,
		_ExtensionObjectDefinition: NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastCancelResponse(structType any) CancelResponse {
	if casted, ok := structType.(CancelResponse); ok {
		return casted
	}
	if casted, ok := structType.(*CancelResponse); ok {
		return *casted
	}
	return nil
}

func (m *_CancelResponse) GetTypeName() string {
	return "CancelResponse"
}

func (m *_CancelResponse) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (responseHeader)
	lengthInBits += m.ResponseHeader.GetLengthInBits(ctx)

	// Simple field (cancelCount)
	lengthInBits += 32

	return lengthInBits
}

func (m *_CancelResponse) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func CancelResponseParse(ctx context.Context, theBytes []byte, identifier string) (CancelResponse, error) {
	return CancelResponseParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func CancelResponseParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (CancelResponse, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("CancelResponse"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for CancelResponse")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (responseHeader)
	if pullErr := readBuffer.PullContext("responseHeader"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for responseHeader")
	}
	_responseHeader, _responseHeaderErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("394"))
	if _responseHeaderErr != nil {
		return nil, errors.Wrap(_responseHeaderErr, "Error parsing 'responseHeader' field of CancelResponse")
	}
	responseHeader := _responseHeader.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("responseHeader"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for responseHeader")
	}

	// Simple Field (cancelCount)
	_cancelCount, _cancelCountErr := readBuffer.ReadUint32("cancelCount", 32)
	if _cancelCountErr != nil {
		return nil, errors.Wrap(_cancelCountErr, "Error parsing 'cancelCount' field of CancelResponse")
	}
	cancelCount := _cancelCount

	if closeErr := readBuffer.CloseContext("CancelResponse"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for CancelResponse")
	}

	// Create a partially initialized instance
	_child := &_CancelResponse{
		_ExtensionObjectDefinition: &_ExtensionObjectDefinition{},
		ResponseHeader:             responseHeader,
		CancelCount:                cancelCount,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_CancelResponse) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_CancelResponse) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("CancelResponse"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for CancelResponse")
		}

		// Simple Field (responseHeader)
		if pushErr := writeBuffer.PushContext("responseHeader"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for responseHeader")
		}
		_responseHeaderErr := writeBuffer.WriteSerializable(ctx, m.GetResponseHeader())
		if popErr := writeBuffer.PopContext("responseHeader"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for responseHeader")
		}
		if _responseHeaderErr != nil {
			return errors.Wrap(_responseHeaderErr, "Error serializing 'responseHeader' field")
		}

		// Simple Field (cancelCount)
		cancelCount := uint32(m.GetCancelCount())
		_cancelCountErr := writeBuffer.WriteUint32("cancelCount", 32, uint32((cancelCount)))
		if _cancelCountErr != nil {
			return errors.Wrap(_cancelCountErr, "Error serializing 'cancelCount' field")
		}

		if popErr := writeBuffer.PopContext("CancelResponse"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for CancelResponse")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_CancelResponse) isCancelResponse() bool {
	return true
}

func (m *_CancelResponse) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
