/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// BrowseResult is the corresponding interface of BrowseResult
type BrowseResult interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetStatusCode returns StatusCode (property field)
	GetStatusCode() StatusCode
	// GetContinuationPoint returns ContinuationPoint (property field)
	GetContinuationPoint() PascalByteString
	// GetNoOfReferences returns NoOfReferences (property field)
	GetNoOfReferences() int32
	// GetReferences returns References (property field)
	GetReferences() []ExtensionObjectDefinition
}

// BrowseResultExactly can be used when we want exactly this type and not a type which fulfills BrowseResult.
// This is useful for switch cases.
type BrowseResultExactly interface {
	BrowseResult
	isBrowseResult() bool
}

// _BrowseResult is the data-structure of this message
type _BrowseResult struct {
	*_ExtensionObjectDefinition
	StatusCode        StatusCode
	ContinuationPoint PascalByteString
	NoOfReferences    int32
	References        []ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BrowseResult) GetIdentifier() string {
	return "524"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BrowseResult) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_BrowseResult) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BrowseResult) GetStatusCode() StatusCode {
	return m.StatusCode
}

func (m *_BrowseResult) GetContinuationPoint() PascalByteString {
	return m.ContinuationPoint
}

func (m *_BrowseResult) GetNoOfReferences() int32 {
	return m.NoOfReferences
}

func (m *_BrowseResult) GetReferences() []ExtensionObjectDefinition {
	return m.References
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBrowseResult factory function for _BrowseResult
func NewBrowseResult(statusCode StatusCode, continuationPoint PascalByteString, noOfReferences int32, references []ExtensionObjectDefinition) *_BrowseResult {
	_result := &_BrowseResult{
		StatusCode:                 statusCode,
		ContinuationPoint:          continuationPoint,
		NoOfReferences:             noOfReferences,
		References:                 references,
		_ExtensionObjectDefinition: NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastBrowseResult(structType any) BrowseResult {
	if casted, ok := structType.(BrowseResult); ok {
		return casted
	}
	if casted, ok := structType.(*BrowseResult); ok {
		return *casted
	}
	return nil
}

func (m *_BrowseResult) GetTypeName() string {
	return "BrowseResult"
}

func (m *_BrowseResult) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (statusCode)
	lengthInBits += m.StatusCode.GetLengthInBits(ctx)

	// Simple field (continuationPoint)
	lengthInBits += m.ContinuationPoint.GetLengthInBits(ctx)

	// Simple field (noOfReferences)
	lengthInBits += 32

	// Array field
	if len(m.References) > 0 {
		for _curItem, element := range m.References {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.References), _curItem)
			_ = arrayCtx
			_ = _curItem
			lengthInBits += element.(interface{ GetLengthInBits(context.Context) uint16 }).GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_BrowseResult) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BrowseResultParse(ctx context.Context, theBytes []byte, identifier string) (BrowseResult, error) {
	return BrowseResultParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func BrowseResultParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (BrowseResult, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("BrowseResult"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BrowseResult")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (statusCode)
	if pullErr := readBuffer.PullContext("statusCode"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for statusCode")
	}
	_statusCode, _statusCodeErr := StatusCodeParseWithBuffer(ctx, readBuffer)
	if _statusCodeErr != nil {
		return nil, errors.Wrap(_statusCodeErr, "Error parsing 'statusCode' field of BrowseResult")
	}
	statusCode := _statusCode.(StatusCode)
	if closeErr := readBuffer.CloseContext("statusCode"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for statusCode")
	}

	// Simple Field (continuationPoint)
	if pullErr := readBuffer.PullContext("continuationPoint"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for continuationPoint")
	}
	_continuationPoint, _continuationPointErr := PascalByteStringParseWithBuffer(ctx, readBuffer)
	if _continuationPointErr != nil {
		return nil, errors.Wrap(_continuationPointErr, "Error parsing 'continuationPoint' field of BrowseResult")
	}
	continuationPoint := _continuationPoint.(PascalByteString)
	if closeErr := readBuffer.CloseContext("continuationPoint"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for continuationPoint")
	}

	// Simple Field (noOfReferences)
	_noOfReferences, _noOfReferencesErr := readBuffer.ReadInt32("noOfReferences", 32)
	if _noOfReferencesErr != nil {
		return nil, errors.Wrap(_noOfReferencesErr, "Error parsing 'noOfReferences' field of BrowseResult")
	}
	noOfReferences := _noOfReferences

	// Array field (references)
	if pullErr := readBuffer.PullContext("references", utils.WithRenderAsList(true)); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for references")
	}
	// Count array
	references := make([]ExtensionObjectDefinition, utils.Max(noOfReferences, 0))
	// This happens when the size is set conditional to 0
	if len(references) == 0 {
		references = nil
	}
	{
		_numItems := uint16(utils.Max(noOfReferences, 0))
		for _curItem := uint16(0); _curItem < _numItems; _curItem++ {
			arrayCtx := utils.CreateArrayContext(ctx, int(_numItems), int(_curItem))
			_ = arrayCtx
			_ = _curItem
			_item, _err := ExtensionObjectDefinitionParseWithBuffer(arrayCtx, readBuffer, "520")
			if _err != nil {
				return nil, errors.Wrap(_err, "Error parsing 'references' field of BrowseResult")
			}
			references[_curItem] = _item.(ExtensionObjectDefinition)
		}
	}
	if closeErr := readBuffer.CloseContext("references", utils.WithRenderAsList(true)); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for references")
	}

	if closeErr := readBuffer.CloseContext("BrowseResult"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BrowseResult")
	}

	// Create a partially initialized instance
	_child := &_BrowseResult{
		_ExtensionObjectDefinition: &_ExtensionObjectDefinition{},
		StatusCode:                 statusCode,
		ContinuationPoint:          continuationPoint,
		NoOfReferences:             noOfReferences,
		References:                 references,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_BrowseResult) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BrowseResult) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BrowseResult"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BrowseResult")
		}

		// Simple Field (statusCode)
		if pushErr := writeBuffer.PushContext("statusCode"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for statusCode")
		}
		_statusCodeErr := writeBuffer.WriteSerializable(ctx, m.GetStatusCode())
		if popErr := writeBuffer.PopContext("statusCode"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for statusCode")
		}
		if _statusCodeErr != nil {
			return errors.Wrap(_statusCodeErr, "Error serializing 'statusCode' field")
		}

		// Simple Field (continuationPoint)
		if pushErr := writeBuffer.PushContext("continuationPoint"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for continuationPoint")
		}
		_continuationPointErr := writeBuffer.WriteSerializable(ctx, m.GetContinuationPoint())
		if popErr := writeBuffer.PopContext("continuationPoint"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for continuationPoint")
		}
		if _continuationPointErr != nil {
			return errors.Wrap(_continuationPointErr, "Error serializing 'continuationPoint' field")
		}

		// Simple Field (noOfReferences)
		noOfReferences := int32(m.GetNoOfReferences())
		_noOfReferencesErr := writeBuffer.WriteInt32("noOfReferences", 32, int32((noOfReferences)))
		if _noOfReferencesErr != nil {
			return errors.Wrap(_noOfReferencesErr, "Error serializing 'noOfReferences' field")
		}

		// Array Field (references)
		if pushErr := writeBuffer.PushContext("references", utils.WithRenderAsList(true)); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for references")
		}
		for _curItem, _element := range m.GetReferences() {
			_ = _curItem
			arrayCtx := utils.CreateArrayContext(ctx, len(m.GetReferences()), _curItem)
			_ = arrayCtx
			_elementErr := writeBuffer.WriteSerializable(arrayCtx, _element)
			if _elementErr != nil {
				return errors.Wrap(_elementErr, "Error serializing 'references' field")
			}
		}
		if popErr := writeBuffer.PopContext("references", utils.WithRenderAsList(true)); popErr != nil {
			return errors.Wrap(popErr, "Error popping for references")
		}

		if popErr := writeBuffer.PopContext("BrowseResult"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BrowseResult")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BrowseResult) isBrowseResult() bool {
	return true
}

func (m *_BrowseResult) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
