/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// BinaryPayload is the corresponding interface of BinaryPayload
type BinaryPayload interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	Payload
	// GetPayload returns Payload (property field)
	GetPayload() []byte
}

// BinaryPayloadExactly can be used when we want exactly this type and not a type which fulfills BinaryPayload.
// This is useful for switch cases.
type BinaryPayloadExactly interface {
	BinaryPayload
	isBinaryPayload() bool
}

// _BinaryPayload is the data-structure of this message
type _BinaryPayload struct {
	*_Payload
	Payload []byte
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BinaryPayload) GetExtensible() bool {
	return bool(false)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BinaryPayload) InitializeParent(parent Payload, sequenceHeader SequenceHeader) {
	m.SequenceHeader = sequenceHeader
}

func (m *_BinaryPayload) GetParent() Payload {
	return m._Payload
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BinaryPayload) GetPayload() []byte {
	return m.Payload
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBinaryPayload factory function for _BinaryPayload
func NewBinaryPayload(payload []byte, sequenceHeader SequenceHeader, byteCount uint32) *_BinaryPayload {
	_result := &_BinaryPayload{
		Payload:  payload,
		_Payload: NewPayload(sequenceHeader, byteCount),
	}
	_result._Payload._PayloadChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastBinaryPayload(structType any) BinaryPayload {
	if casted, ok := structType.(BinaryPayload); ok {
		return casted
	}
	if casted, ok := structType.(*BinaryPayload); ok {
		return *casted
	}
	return nil
}

func (m *_BinaryPayload) GetTypeName() string {
	return "BinaryPayload"
}

func (m *_BinaryPayload) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Array field
	if len(m.Payload) > 0 {
		lengthInBits += 8 * uint16(len(m.Payload))
	}

	return lengthInBits
}

func (m *_BinaryPayload) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BinaryPayloadParse(ctx context.Context, theBytes []byte, extensible bool, byteCount uint32) (BinaryPayload, error) {
	return BinaryPayloadParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), extensible, byteCount)
}

func BinaryPayloadParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, extensible bool, byteCount uint32) (BinaryPayload, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("BinaryPayload"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BinaryPayload")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos
	// Byte Array field (payload)
	numberOfBytespayload := int(byteCount)
	payload, _readArrayErr := readBuffer.ReadByteArray("payload", numberOfBytespayload)
	if _readArrayErr != nil {
		return nil, errors.Wrap(_readArrayErr, "Error parsing 'payload' field of BinaryPayload")
	}

	if closeErr := readBuffer.CloseContext("BinaryPayload"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BinaryPayload")
	}

	// Create a partially initialized instance
	_child := &_BinaryPayload{
		_Payload: &_Payload{
			ByteCount: byteCount,
		},
		Payload: payload,
	}
	_child._Payload._PayloadChildRequirements = _child
	return _child, nil
}

func (m *_BinaryPayload) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BinaryPayload) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BinaryPayload"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BinaryPayload")
		}

		// Array Field (payload)
		// Byte Array field (payload)
		if err := writeBuffer.WriteByteArray("payload", m.GetPayload()); err != nil {
			return errors.Wrap(err, "Error serializing 'payload' field")
		}

		if popErr := writeBuffer.PopContext("BinaryPayload"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BinaryPayload")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BinaryPayload) isBinaryPayload() bool {
	return true
}

func (m *_BinaryPayload) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
