/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// AxisInformation is the corresponding interface of AxisInformation
type AxisInformation interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetEngineeringUnits returns EngineeringUnits (property field)
	GetEngineeringUnits() ExtensionObjectDefinition
	// GetEURange returns EURange (property field)
	GetEURange() ExtensionObjectDefinition
	// GetTitle returns Title (property field)
	GetTitle() LocalizedText
	// GetAxisScaleType returns AxisScaleType (property field)
	GetAxisScaleType() AxisScaleEnumeration
	// GetNoOfAxisSteps returns NoOfAxisSteps (property field)
	GetNoOfAxisSteps() int32
	// GetAxisSteps returns AxisSteps (property field)
	GetAxisSteps() []float64
}

// AxisInformationExactly can be used when we want exactly this type and not a type which fulfills AxisInformation.
// This is useful for switch cases.
type AxisInformationExactly interface {
	AxisInformation
	isAxisInformation() bool
}

// _AxisInformation is the data-structure of this message
type _AxisInformation struct {
	*_ExtensionObjectDefinition
	EngineeringUnits ExtensionObjectDefinition
	EURange          ExtensionObjectDefinition
	Title            LocalizedText
	AxisScaleType    AxisScaleEnumeration
	NoOfAxisSteps    int32
	AxisSteps        []float64
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_AxisInformation) GetIdentifier() string {
	return "12081"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_AxisInformation) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_AxisInformation) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_AxisInformation) GetEngineeringUnits() ExtensionObjectDefinition {
	return m.EngineeringUnits
}

func (m *_AxisInformation) GetEURange() ExtensionObjectDefinition {
	return m.EURange
}

func (m *_AxisInformation) GetTitle() LocalizedText {
	return m.Title
}

func (m *_AxisInformation) GetAxisScaleType() AxisScaleEnumeration {
	return m.AxisScaleType
}

func (m *_AxisInformation) GetNoOfAxisSteps() int32 {
	return m.NoOfAxisSteps
}

func (m *_AxisInformation) GetAxisSteps() []float64 {
	return m.AxisSteps
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewAxisInformation factory function for _AxisInformation
func NewAxisInformation(engineeringUnits ExtensionObjectDefinition, eURange ExtensionObjectDefinition, title LocalizedText, axisScaleType AxisScaleEnumeration, noOfAxisSteps int32, axisSteps []float64) *_AxisInformation {
	_result := &_AxisInformation{
		EngineeringUnits:           engineeringUnits,
		EURange:                    eURange,
		Title:                      title,
		AxisScaleType:              axisScaleType,
		NoOfAxisSteps:              noOfAxisSteps,
		AxisSteps:                  axisSteps,
		_ExtensionObjectDefinition: NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastAxisInformation(structType any) AxisInformation {
	if casted, ok := structType.(AxisInformation); ok {
		return casted
	}
	if casted, ok := structType.(*AxisInformation); ok {
		return *casted
	}
	return nil
}

func (m *_AxisInformation) GetTypeName() string {
	return "AxisInformation"
}

func (m *_AxisInformation) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (engineeringUnits)
	lengthInBits += m.EngineeringUnits.GetLengthInBits(ctx)

	// Simple field (eURange)
	lengthInBits += m.EURange.GetLengthInBits(ctx)

	// Simple field (title)
	lengthInBits += m.Title.GetLengthInBits(ctx)

	// Simple field (axisScaleType)
	lengthInBits += 32

	// Simple field (noOfAxisSteps)
	lengthInBits += 32

	// Array field
	if len(m.AxisSteps) > 0 {
		lengthInBits += 64 * uint16(len(m.AxisSteps))
	}

	return lengthInBits
}

func (m *_AxisInformation) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func AxisInformationParse(ctx context.Context, theBytes []byte, identifier string) (AxisInformation, error) {
	return AxisInformationParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func AxisInformationParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (AxisInformation, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("AxisInformation"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for AxisInformation")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (engineeringUnits)
	if pullErr := readBuffer.PullContext("engineeringUnits"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for engineeringUnits")
	}
	_engineeringUnits, _engineeringUnitsErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("889"))
	if _engineeringUnitsErr != nil {
		return nil, errors.Wrap(_engineeringUnitsErr, "Error parsing 'engineeringUnits' field of AxisInformation")
	}
	engineeringUnits := _engineeringUnits.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("engineeringUnits"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for engineeringUnits")
	}

	// Simple Field (eURange)
	if pullErr := readBuffer.PullContext("eURange"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for eURange")
	}
	_eURange, _eURangeErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("886"))
	if _eURangeErr != nil {
		return nil, errors.Wrap(_eURangeErr, "Error parsing 'eURange' field of AxisInformation")
	}
	eURange := _eURange.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("eURange"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for eURange")
	}

	// Simple Field (title)
	if pullErr := readBuffer.PullContext("title"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for title")
	}
	_title, _titleErr := LocalizedTextParseWithBuffer(ctx, readBuffer)
	if _titleErr != nil {
		return nil, errors.Wrap(_titleErr, "Error parsing 'title' field of AxisInformation")
	}
	title := _title.(LocalizedText)
	if closeErr := readBuffer.CloseContext("title"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for title")
	}

	// Simple Field (axisScaleType)
	if pullErr := readBuffer.PullContext("axisScaleType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for axisScaleType")
	}
	_axisScaleType, _axisScaleTypeErr := AxisScaleEnumerationParseWithBuffer(ctx, readBuffer)
	if _axisScaleTypeErr != nil {
		return nil, errors.Wrap(_axisScaleTypeErr, "Error parsing 'axisScaleType' field of AxisInformation")
	}
	axisScaleType := _axisScaleType
	if closeErr := readBuffer.CloseContext("axisScaleType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for axisScaleType")
	}

	// Simple Field (noOfAxisSteps)
	_noOfAxisSteps, _noOfAxisStepsErr := readBuffer.ReadInt32("noOfAxisSteps", 32)
	if _noOfAxisStepsErr != nil {
		return nil, errors.Wrap(_noOfAxisStepsErr, "Error parsing 'noOfAxisSteps' field of AxisInformation")
	}
	noOfAxisSteps := _noOfAxisSteps

	// Array field (axisSteps)
	if pullErr := readBuffer.PullContext("axisSteps", utils.WithRenderAsList(true)); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for axisSteps")
	}
	// Count array
	axisSteps := make([]float64, utils.Max(noOfAxisSteps, 0))
	// This happens when the size is set conditional to 0
	if len(axisSteps) == 0 {
		axisSteps = nil
	}
	{
		_numItems := uint16(utils.Max(noOfAxisSteps, 0))
		for _curItem := uint16(0); _curItem < _numItems; _curItem++ {
			arrayCtx := utils.CreateArrayContext(ctx, int(_numItems), int(_curItem))
			_ = arrayCtx
			_ = _curItem
			_item, _err := readBuffer.ReadFloat64("", 64)
			if _err != nil {
				return nil, errors.Wrap(_err, "Error parsing 'axisSteps' field of AxisInformation")
			}
			axisSteps[_curItem] = _item
		}
	}
	if closeErr := readBuffer.CloseContext("axisSteps", utils.WithRenderAsList(true)); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for axisSteps")
	}

	if closeErr := readBuffer.CloseContext("AxisInformation"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for AxisInformation")
	}

	// Create a partially initialized instance
	_child := &_AxisInformation{
		_ExtensionObjectDefinition: &_ExtensionObjectDefinition{},
		EngineeringUnits:           engineeringUnits,
		EURange:                    eURange,
		Title:                      title,
		AxisScaleType:              axisScaleType,
		NoOfAxisSteps:              noOfAxisSteps,
		AxisSteps:                  axisSteps,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_AxisInformation) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_AxisInformation) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("AxisInformation"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for AxisInformation")
		}

		// Simple Field (engineeringUnits)
		if pushErr := writeBuffer.PushContext("engineeringUnits"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for engineeringUnits")
		}
		_engineeringUnitsErr := writeBuffer.WriteSerializable(ctx, m.GetEngineeringUnits())
		if popErr := writeBuffer.PopContext("engineeringUnits"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for engineeringUnits")
		}
		if _engineeringUnitsErr != nil {
			return errors.Wrap(_engineeringUnitsErr, "Error serializing 'engineeringUnits' field")
		}

		// Simple Field (eURange)
		if pushErr := writeBuffer.PushContext("eURange"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for eURange")
		}
		_eURangeErr := writeBuffer.WriteSerializable(ctx, m.GetEURange())
		if popErr := writeBuffer.PopContext("eURange"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for eURange")
		}
		if _eURangeErr != nil {
			return errors.Wrap(_eURangeErr, "Error serializing 'eURange' field")
		}

		// Simple Field (title)
		if pushErr := writeBuffer.PushContext("title"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for title")
		}
		_titleErr := writeBuffer.WriteSerializable(ctx, m.GetTitle())
		if popErr := writeBuffer.PopContext("title"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for title")
		}
		if _titleErr != nil {
			return errors.Wrap(_titleErr, "Error serializing 'title' field")
		}

		// Simple Field (axisScaleType)
		if pushErr := writeBuffer.PushContext("axisScaleType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for axisScaleType")
		}
		_axisScaleTypeErr := writeBuffer.WriteSerializable(ctx, m.GetAxisScaleType())
		if popErr := writeBuffer.PopContext("axisScaleType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for axisScaleType")
		}
		if _axisScaleTypeErr != nil {
			return errors.Wrap(_axisScaleTypeErr, "Error serializing 'axisScaleType' field")
		}

		// Simple Field (noOfAxisSteps)
		noOfAxisSteps := int32(m.GetNoOfAxisSteps())
		_noOfAxisStepsErr := writeBuffer.WriteInt32("noOfAxisSteps", 32, int32((noOfAxisSteps)))
		if _noOfAxisStepsErr != nil {
			return errors.Wrap(_noOfAxisStepsErr, "Error serializing 'noOfAxisSteps' field")
		}

		// Array Field (axisSteps)
		if pushErr := writeBuffer.PushContext("axisSteps", utils.WithRenderAsList(true)); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for axisSteps")
		}
		for _curItem, _element := range m.GetAxisSteps() {
			_ = _curItem
			_elementErr := writeBuffer.WriteFloat64("", 64, _element)
			if _elementErr != nil {
				return errors.Wrap(_elementErr, "Error serializing 'axisSteps' field")
			}
		}
		if popErr := writeBuffer.PopContext("axisSteps", utils.WithRenderAsList(true)); popErr != nil {
			return errors.Wrap(popErr, "Error popping for axisSteps")
		}

		if popErr := writeBuffer.PopContext("AxisInformation"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for AxisInformation")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_AxisInformation) isAxisInformation() bool {
	return true
}

func (m *_AxisInformation) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
