/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// AudioDataType is the corresponding interface of AudioDataType
type AudioDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

// AudioDataTypeExactly can be used when we want exactly this type and not a type which fulfills AudioDataType.
// This is useful for switch cases.
type AudioDataTypeExactly interface {
	AudioDataType
	isAudioDataType() bool
}

// _AudioDataType is the data-structure of this message
type _AudioDataType struct {
}

// NewAudioDataType factory function for _AudioDataType
func NewAudioDataType() *_AudioDataType {
	return &_AudioDataType{}
}

// Deprecated: use the interface for direct cast
func CastAudioDataType(structType any) AudioDataType {
	if casted, ok := structType.(AudioDataType); ok {
		return casted
	}
	if casted, ok := structType.(*AudioDataType); ok {
		return *casted
	}
	return nil
}

func (m *_AudioDataType) GetTypeName() string {
	return "AudioDataType"
}

func (m *_AudioDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	return lengthInBits
}

func (m *_AudioDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func AudioDataTypeParse(ctx context.Context, theBytes []byte) (AudioDataType, error) {
	return AudioDataTypeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func AudioDataTypeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (AudioDataType, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("AudioDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for AudioDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("AudioDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for AudioDataType")
	}

	// Create the instance
	return &_AudioDataType{}, nil
}

func (m *_AudioDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_AudioDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("AudioDataType"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for AudioDataType")
	}

	if popErr := writeBuffer.PopContext("AudioDataType"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for AudioDataType")
	}
	return nil
}

func (m *_AudioDataType) isAudioDataType() bool {
	return true
}

func (m *_AudioDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
