/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// AnnotationDataType is the corresponding interface of AnnotationDataType
type AnnotationDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetAnnotation returns Annotation (property field)
	GetAnnotation() PascalString
	// GetDiscipline returns Discipline (property field)
	GetDiscipline() PascalString
	// GetUri returns Uri (property field)
	GetUri() PascalString
}

// AnnotationDataTypeExactly can be used when we want exactly this type and not a type which fulfills AnnotationDataType.
// This is useful for switch cases.
type AnnotationDataTypeExactly interface {
	AnnotationDataType
	isAnnotationDataType() bool
}

// _AnnotationDataType is the data-structure of this message
type _AnnotationDataType struct {
	*_ExtensionObjectDefinition
	Annotation PascalString
	Discipline PascalString
	Uri        PascalString
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_AnnotationDataType) GetIdentifier() string {
	return "32436"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_AnnotationDataType) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_AnnotationDataType) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_AnnotationDataType) GetAnnotation() PascalString {
	return m.Annotation
}

func (m *_AnnotationDataType) GetDiscipline() PascalString {
	return m.Discipline
}

func (m *_AnnotationDataType) GetUri() PascalString {
	return m.Uri
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewAnnotationDataType factory function for _AnnotationDataType
func NewAnnotationDataType(annotation PascalString, discipline PascalString, uri PascalString) *_AnnotationDataType {
	_result := &_AnnotationDataType{
		Annotation:                 annotation,
		Discipline:                 discipline,
		Uri:                        uri,
		_ExtensionObjectDefinition: NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastAnnotationDataType(structType any) AnnotationDataType {
	if casted, ok := structType.(AnnotationDataType); ok {
		return casted
	}
	if casted, ok := structType.(*AnnotationDataType); ok {
		return *casted
	}
	return nil
}

func (m *_AnnotationDataType) GetTypeName() string {
	return "AnnotationDataType"
}

func (m *_AnnotationDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (annotation)
	lengthInBits += m.Annotation.GetLengthInBits(ctx)

	// Simple field (discipline)
	lengthInBits += m.Discipline.GetLengthInBits(ctx)

	// Simple field (uri)
	lengthInBits += m.Uri.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_AnnotationDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func AnnotationDataTypeParse(ctx context.Context, theBytes []byte, identifier string) (AnnotationDataType, error) {
	return AnnotationDataTypeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func AnnotationDataTypeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (AnnotationDataType, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("AnnotationDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for AnnotationDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (annotation)
	if pullErr := readBuffer.PullContext("annotation"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for annotation")
	}
	_annotation, _annotationErr := PascalStringParseWithBuffer(ctx, readBuffer)
	if _annotationErr != nil {
		return nil, errors.Wrap(_annotationErr, "Error parsing 'annotation' field of AnnotationDataType")
	}
	annotation := _annotation.(PascalString)
	if closeErr := readBuffer.CloseContext("annotation"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for annotation")
	}

	// Simple Field (discipline)
	if pullErr := readBuffer.PullContext("discipline"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for discipline")
	}
	_discipline, _disciplineErr := PascalStringParseWithBuffer(ctx, readBuffer)
	if _disciplineErr != nil {
		return nil, errors.Wrap(_disciplineErr, "Error parsing 'discipline' field of AnnotationDataType")
	}
	discipline := _discipline.(PascalString)
	if closeErr := readBuffer.CloseContext("discipline"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for discipline")
	}

	// Simple Field (uri)
	if pullErr := readBuffer.PullContext("uri"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for uri")
	}
	_uri, _uriErr := PascalStringParseWithBuffer(ctx, readBuffer)
	if _uriErr != nil {
		return nil, errors.Wrap(_uriErr, "Error parsing 'uri' field of AnnotationDataType")
	}
	uri := _uri.(PascalString)
	if closeErr := readBuffer.CloseContext("uri"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for uri")
	}

	if closeErr := readBuffer.CloseContext("AnnotationDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for AnnotationDataType")
	}

	// Create a partially initialized instance
	_child := &_AnnotationDataType{
		_ExtensionObjectDefinition: &_ExtensionObjectDefinition{},
		Annotation:                 annotation,
		Discipline:                 discipline,
		Uri:                        uri,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_AnnotationDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_AnnotationDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("AnnotationDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for AnnotationDataType")
		}

		// Simple Field (annotation)
		if pushErr := writeBuffer.PushContext("annotation"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for annotation")
		}
		_annotationErr := writeBuffer.WriteSerializable(ctx, m.GetAnnotation())
		if popErr := writeBuffer.PopContext("annotation"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for annotation")
		}
		if _annotationErr != nil {
			return errors.Wrap(_annotationErr, "Error serializing 'annotation' field")
		}

		// Simple Field (discipline)
		if pushErr := writeBuffer.PushContext("discipline"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for discipline")
		}
		_disciplineErr := writeBuffer.WriteSerializable(ctx, m.GetDiscipline())
		if popErr := writeBuffer.PopContext("discipline"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for discipline")
		}
		if _disciplineErr != nil {
			return errors.Wrap(_disciplineErr, "Error serializing 'discipline' field")
		}

		// Simple Field (uri)
		if pushErr := writeBuffer.PushContext("uri"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for uri")
		}
		_uriErr := writeBuffer.WriteSerializable(ctx, m.GetUri())
		if popErr := writeBuffer.PopContext("uri"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for uri")
		}
		if _uriErr != nil {
			return errors.Wrap(_uriErr, "Error serializing 'uri' field")
		}

		if popErr := writeBuffer.PopContext("AnnotationDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for AnnotationDataType")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_AnnotationDataType) isAnnotationDataType() bool {
	return true
}

func (m *_AnnotationDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
