/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// AlarmMask is an enum
type AlarmMask uint16

type IAlarmMask interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	AlarmMask_alarmMaskNone           AlarmMask = 0
	AlarmMask_alarmMaskActive         AlarmMask = 1
	AlarmMask_alarmMaskUnacknowledged AlarmMask = 2
	AlarmMask_alarmMaskUnconfirmed    AlarmMask = 4
)

var AlarmMaskValues []AlarmMask

func init() {
	_ = errors.New
	AlarmMaskValues = []AlarmMask{
		AlarmMask_alarmMaskNone,
		AlarmMask_alarmMaskActive,
		AlarmMask_alarmMaskUnacknowledged,
		AlarmMask_alarmMaskUnconfirmed,
	}
}

func AlarmMaskByValue(value uint16) (enum AlarmMask, ok bool) {
	switch value {
	case 0:
		return AlarmMask_alarmMaskNone, true
	case 1:
		return AlarmMask_alarmMaskActive, true
	case 2:
		return AlarmMask_alarmMaskUnacknowledged, true
	case 4:
		return AlarmMask_alarmMaskUnconfirmed, true
	}
	return 0, false
}

func AlarmMaskByName(value string) (enum AlarmMask, ok bool) {
	switch value {
	case "alarmMaskNone":
		return AlarmMask_alarmMaskNone, true
	case "alarmMaskActive":
		return AlarmMask_alarmMaskActive, true
	case "alarmMaskUnacknowledged":
		return AlarmMask_alarmMaskUnacknowledged, true
	case "alarmMaskUnconfirmed":
		return AlarmMask_alarmMaskUnconfirmed, true
	}
	return 0, false
}

func AlarmMaskKnows(value uint16) bool {
	for _, typeValue := range AlarmMaskValues {
		if uint16(typeValue) == value {
			return true
		}
	}
	return false
}

func CastAlarmMask(structType any) AlarmMask {
	castFunc := func(typ any) AlarmMask {
		if sAlarmMask, ok := typ.(AlarmMask); ok {
			return sAlarmMask
		}
		return 0
	}
	return castFunc(structType)
}

func (m AlarmMask) GetLengthInBits(ctx context.Context) uint16 {
	return 16
}

func (m AlarmMask) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func AlarmMaskParse(ctx context.Context, theBytes []byte) (AlarmMask, error) {
	return AlarmMaskParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func AlarmMaskParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (AlarmMask, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadUint16("AlarmMask", 16)
	if err != nil {
		return 0, errors.Wrap(err, "error reading AlarmMask")
	}
	if enum, ok := AlarmMaskByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for AlarmMask")
		return AlarmMask(val), nil
	} else {
		return enum, nil
	}
}

func (e AlarmMask) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e AlarmMask) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteUint16("AlarmMask", 16, uint16(uint16(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e AlarmMask) PLC4XEnumName() string {
	switch e {
	case AlarmMask_alarmMaskNone:
		return "alarmMaskNone"
	case AlarmMask_alarmMaskActive:
		return "alarmMaskActive"
	case AlarmMask_alarmMaskUnacknowledged:
		return "alarmMaskUnacknowledged"
	case AlarmMask_alarmMaskUnconfirmed:
		return "alarmMaskUnconfirmed"
	}
	return fmt.Sprintf("Unknown(%v)", uint16(e))
}

func (e AlarmMask) String() string {
	return e.PLC4XEnumName()
}
