/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// AggregateConfiguration is the corresponding interface of AggregateConfiguration
type AggregateConfiguration interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetTreatUncertainAsBad returns TreatUncertainAsBad (property field)
	GetTreatUncertainAsBad() bool
	// GetUseServerCapabilitiesDefaults returns UseServerCapabilitiesDefaults (property field)
	GetUseServerCapabilitiesDefaults() bool
	// GetPercentDataBad returns PercentDataBad (property field)
	GetPercentDataBad() uint8
	// GetPercentDataGood returns PercentDataGood (property field)
	GetPercentDataGood() uint8
	// GetUseSlopedExtrapolation returns UseSlopedExtrapolation (property field)
	GetUseSlopedExtrapolation() bool
}

// AggregateConfigurationExactly can be used when we want exactly this type and not a type which fulfills AggregateConfiguration.
// This is useful for switch cases.
type AggregateConfigurationExactly interface {
	AggregateConfiguration
	isAggregateConfiguration() bool
}

// _AggregateConfiguration is the data-structure of this message
type _AggregateConfiguration struct {
	*_ExtensionObjectDefinition
	TreatUncertainAsBad           bool
	UseServerCapabilitiesDefaults bool
	PercentDataBad                uint8
	PercentDataGood               uint8
	UseSlopedExtrapolation        bool
	// Reserved Fields
	reservedField0 *uint8
	reservedField1 *uint8
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_AggregateConfiguration) GetIdentifier() string {
	return "950"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_AggregateConfiguration) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_AggregateConfiguration) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_AggregateConfiguration) GetTreatUncertainAsBad() bool {
	return m.TreatUncertainAsBad
}

func (m *_AggregateConfiguration) GetUseServerCapabilitiesDefaults() bool {
	return m.UseServerCapabilitiesDefaults
}

func (m *_AggregateConfiguration) GetPercentDataBad() uint8 {
	return m.PercentDataBad
}

func (m *_AggregateConfiguration) GetPercentDataGood() uint8 {
	return m.PercentDataGood
}

func (m *_AggregateConfiguration) GetUseSlopedExtrapolation() bool {
	return m.UseSlopedExtrapolation
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewAggregateConfiguration factory function for _AggregateConfiguration
func NewAggregateConfiguration(treatUncertainAsBad bool, useServerCapabilitiesDefaults bool, percentDataBad uint8, percentDataGood uint8, useSlopedExtrapolation bool) *_AggregateConfiguration {
	_result := &_AggregateConfiguration{
		TreatUncertainAsBad:           treatUncertainAsBad,
		UseServerCapabilitiesDefaults: useServerCapabilitiesDefaults,
		PercentDataBad:                percentDataBad,
		PercentDataGood:               percentDataGood,
		UseSlopedExtrapolation:        useSlopedExtrapolation,
		_ExtensionObjectDefinition:    NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastAggregateConfiguration(structType any) AggregateConfiguration {
	if casted, ok := structType.(AggregateConfiguration); ok {
		return casted
	}
	if casted, ok := structType.(*AggregateConfiguration); ok {
		return *casted
	}
	return nil
}

func (m *_AggregateConfiguration) GetTypeName() string {
	return "AggregateConfiguration"
}

func (m *_AggregateConfiguration) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Reserved Field (reserved)
	lengthInBits += 6

	// Simple field (treatUncertainAsBad)
	lengthInBits += 1

	// Simple field (useServerCapabilitiesDefaults)
	lengthInBits += 1

	// Simple field (percentDataBad)
	lengthInBits += 8

	// Simple field (percentDataGood)
	lengthInBits += 8

	// Reserved Field (reserved)
	lengthInBits += 7

	// Simple field (useSlopedExtrapolation)
	lengthInBits += 1

	return lengthInBits
}

func (m *_AggregateConfiguration) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func AggregateConfigurationParse(ctx context.Context, theBytes []byte, identifier string) (AggregateConfiguration, error) {
	return AggregateConfigurationParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func AggregateConfigurationParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (AggregateConfiguration, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("AggregateConfiguration"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for AggregateConfiguration")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	var reservedField0 *uint8
	// Reserved Field (Compartmentalized so the "reserved" variable can't leak)
	{
		reserved, _err := readBuffer.ReadUint8("reserved", 6)
		if _err != nil {
			return nil, errors.Wrap(_err, "Error parsing 'reserved' field of AggregateConfiguration")
		}
		if reserved != uint8(0x00) {
			log.Info().Fields(map[string]any{
				"expected value": uint8(0x00),
				"got value":      reserved,
			}).Msg("Got unexpected response for reserved field.")
			// We save the value, so it can be re-serialized
			reservedField0 = &reserved
		}
	}

	// Simple Field (treatUncertainAsBad)
	_treatUncertainAsBad, _treatUncertainAsBadErr := readBuffer.ReadBit("treatUncertainAsBad")
	if _treatUncertainAsBadErr != nil {
		return nil, errors.Wrap(_treatUncertainAsBadErr, "Error parsing 'treatUncertainAsBad' field of AggregateConfiguration")
	}
	treatUncertainAsBad := _treatUncertainAsBad

	// Simple Field (useServerCapabilitiesDefaults)
	_useServerCapabilitiesDefaults, _useServerCapabilitiesDefaultsErr := readBuffer.ReadBit("useServerCapabilitiesDefaults")
	if _useServerCapabilitiesDefaultsErr != nil {
		return nil, errors.Wrap(_useServerCapabilitiesDefaultsErr, "Error parsing 'useServerCapabilitiesDefaults' field of AggregateConfiguration")
	}
	useServerCapabilitiesDefaults := _useServerCapabilitiesDefaults

	// Simple Field (percentDataBad)
	_percentDataBad, _percentDataBadErr := readBuffer.ReadUint8("percentDataBad", 8)
	if _percentDataBadErr != nil {
		return nil, errors.Wrap(_percentDataBadErr, "Error parsing 'percentDataBad' field of AggregateConfiguration")
	}
	percentDataBad := _percentDataBad

	// Simple Field (percentDataGood)
	_percentDataGood, _percentDataGoodErr := readBuffer.ReadUint8("percentDataGood", 8)
	if _percentDataGoodErr != nil {
		return nil, errors.Wrap(_percentDataGoodErr, "Error parsing 'percentDataGood' field of AggregateConfiguration")
	}
	percentDataGood := _percentDataGood

	var reservedField1 *uint8
	// Reserved Field (Compartmentalized so the "reserved" variable can't leak)
	{
		reserved, _err := readBuffer.ReadUint8("reserved", 7)
		if _err != nil {
			return nil, errors.Wrap(_err, "Error parsing 'reserved' field of AggregateConfiguration")
		}
		if reserved != uint8(0x00) {
			log.Info().Fields(map[string]any{
				"expected value": uint8(0x00),
				"got value":      reserved,
			}).Msg("Got unexpected response for reserved field.")
			// We save the value, so it can be re-serialized
			reservedField1 = &reserved
		}
	}

	// Simple Field (useSlopedExtrapolation)
	_useSlopedExtrapolation, _useSlopedExtrapolationErr := readBuffer.ReadBit("useSlopedExtrapolation")
	if _useSlopedExtrapolationErr != nil {
		return nil, errors.Wrap(_useSlopedExtrapolationErr, "Error parsing 'useSlopedExtrapolation' field of AggregateConfiguration")
	}
	useSlopedExtrapolation := _useSlopedExtrapolation

	if closeErr := readBuffer.CloseContext("AggregateConfiguration"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for AggregateConfiguration")
	}

	// Create a partially initialized instance
	_child := &_AggregateConfiguration{
		_ExtensionObjectDefinition:    &_ExtensionObjectDefinition{},
		TreatUncertainAsBad:           treatUncertainAsBad,
		UseServerCapabilitiesDefaults: useServerCapabilitiesDefaults,
		PercentDataBad:                percentDataBad,
		PercentDataGood:               percentDataGood,
		UseSlopedExtrapolation:        useSlopedExtrapolation,
		reservedField0:                reservedField0,
		reservedField1:                reservedField1,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_AggregateConfiguration) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_AggregateConfiguration) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("AggregateConfiguration"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for AggregateConfiguration")
		}

		// Reserved Field (reserved)
		{
			var reserved uint8 = uint8(0x00)
			if m.reservedField0 != nil {
				log.Info().Fields(map[string]any{
					"expected value": uint8(0x00),
					"got value":      reserved,
				}).Msg("Overriding reserved field with unexpected value.")
				reserved = *m.reservedField0
			}
			_err := writeBuffer.WriteUint8("reserved", 6, uint8(reserved))
			if _err != nil {
				return errors.Wrap(_err, "Error serializing 'reserved' field")
			}
		}

		// Simple Field (treatUncertainAsBad)
		treatUncertainAsBad := bool(m.GetTreatUncertainAsBad())
		_treatUncertainAsBadErr := writeBuffer.WriteBit("treatUncertainAsBad", (treatUncertainAsBad))
		if _treatUncertainAsBadErr != nil {
			return errors.Wrap(_treatUncertainAsBadErr, "Error serializing 'treatUncertainAsBad' field")
		}

		// Simple Field (useServerCapabilitiesDefaults)
		useServerCapabilitiesDefaults := bool(m.GetUseServerCapabilitiesDefaults())
		_useServerCapabilitiesDefaultsErr := writeBuffer.WriteBit("useServerCapabilitiesDefaults", (useServerCapabilitiesDefaults))
		if _useServerCapabilitiesDefaultsErr != nil {
			return errors.Wrap(_useServerCapabilitiesDefaultsErr, "Error serializing 'useServerCapabilitiesDefaults' field")
		}

		// Simple Field (percentDataBad)
		percentDataBad := uint8(m.GetPercentDataBad())
		_percentDataBadErr := writeBuffer.WriteUint8("percentDataBad", 8, uint8((percentDataBad)))
		if _percentDataBadErr != nil {
			return errors.Wrap(_percentDataBadErr, "Error serializing 'percentDataBad' field")
		}

		// Simple Field (percentDataGood)
		percentDataGood := uint8(m.GetPercentDataGood())
		_percentDataGoodErr := writeBuffer.WriteUint8("percentDataGood", 8, uint8((percentDataGood)))
		if _percentDataGoodErr != nil {
			return errors.Wrap(_percentDataGoodErr, "Error serializing 'percentDataGood' field")
		}

		// Reserved Field (reserved)
		{
			var reserved uint8 = uint8(0x00)
			if m.reservedField1 != nil {
				log.Info().Fields(map[string]any{
					"expected value": uint8(0x00),
					"got value":      reserved,
				}).Msg("Overriding reserved field with unexpected value.")
				reserved = *m.reservedField1
			}
			_err := writeBuffer.WriteUint8("reserved", 7, uint8(reserved))
			if _err != nil {
				return errors.Wrap(_err, "Error serializing 'reserved' field")
			}
		}

		// Simple Field (useSlopedExtrapolation)
		useSlopedExtrapolation := bool(m.GetUseSlopedExtrapolation())
		_useSlopedExtrapolationErr := writeBuffer.WriteBit("useSlopedExtrapolation", (useSlopedExtrapolation))
		if _useSlopedExtrapolationErr != nil {
			return errors.Wrap(_useSlopedExtrapolationErr, "Error serializing 'useSlopedExtrapolation' field")
		}

		if popErr := writeBuffer.PopContext("AggregateConfiguration"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for AggregateConfiguration")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_AggregateConfiguration) isAggregateConfiguration() bool {
	return true
}

func (m *_AggregateConfiguration) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
