/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// ApduDataExtWriteRouterMemoryRequest is the corresponding interface of ApduDataExtWriteRouterMemoryRequest
type ApduDataExtWriteRouterMemoryRequest interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ApduDataExt
}

// ApduDataExtWriteRouterMemoryRequestExactly can be used when we want exactly this type and not a type which fulfills ApduDataExtWriteRouterMemoryRequest.
// This is useful for switch cases.
type ApduDataExtWriteRouterMemoryRequestExactly interface {
	ApduDataExtWriteRouterMemoryRequest
	isApduDataExtWriteRouterMemoryRequest() bool
}

// _ApduDataExtWriteRouterMemoryRequest is the data-structure of this message
type _ApduDataExtWriteRouterMemoryRequest struct {
	*_ApduDataExt
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ApduDataExtWriteRouterMemoryRequest) GetExtApciType() uint8 {
	return 0x0A
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ApduDataExtWriteRouterMemoryRequest) InitializeParent(parent ApduDataExt) {}

func (m *_ApduDataExtWriteRouterMemoryRequest) GetParent() ApduDataExt {
	return m._ApduDataExt
}

// NewApduDataExtWriteRouterMemoryRequest factory function for _ApduDataExtWriteRouterMemoryRequest
func NewApduDataExtWriteRouterMemoryRequest(length uint8) *_ApduDataExtWriteRouterMemoryRequest {
	_result := &_ApduDataExtWriteRouterMemoryRequest{
		_ApduDataExt: NewApduDataExt(length),
	}
	_result._ApduDataExt._ApduDataExtChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastApduDataExtWriteRouterMemoryRequest(structType any) ApduDataExtWriteRouterMemoryRequest {
	if casted, ok := structType.(ApduDataExtWriteRouterMemoryRequest); ok {
		return casted
	}
	if casted, ok := structType.(*ApduDataExtWriteRouterMemoryRequest); ok {
		return *casted
	}
	return nil
}

func (m *_ApduDataExtWriteRouterMemoryRequest) GetTypeName() string {
	return "ApduDataExtWriteRouterMemoryRequest"
}

func (m *_ApduDataExtWriteRouterMemoryRequest) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	return lengthInBits
}

func (m *_ApduDataExtWriteRouterMemoryRequest) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ApduDataExtWriteRouterMemoryRequestParse(ctx context.Context, theBytes []byte, length uint8) (ApduDataExtWriteRouterMemoryRequest, error) {
	return ApduDataExtWriteRouterMemoryRequestParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), length)
}

func ApduDataExtWriteRouterMemoryRequestParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, length uint8) (ApduDataExtWriteRouterMemoryRequest, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("ApduDataExtWriteRouterMemoryRequest"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ApduDataExtWriteRouterMemoryRequest")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("ApduDataExtWriteRouterMemoryRequest"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ApduDataExtWriteRouterMemoryRequest")
	}

	// Create a partially initialized instance
	_child := &_ApduDataExtWriteRouterMemoryRequest{
		_ApduDataExt: &_ApduDataExt{
			Length: length,
		},
	}
	_child._ApduDataExt._ApduDataExtChildRequirements = _child
	return _child, nil
}

func (m *_ApduDataExtWriteRouterMemoryRequest) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ApduDataExtWriteRouterMemoryRequest) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ApduDataExtWriteRouterMemoryRequest"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ApduDataExtWriteRouterMemoryRequest")
		}

		if popErr := writeBuffer.PopContext("ApduDataExtWriteRouterMemoryRequest"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ApduDataExtWriteRouterMemoryRequest")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ApduDataExtWriteRouterMemoryRequest) isApduDataExtWriteRouterMemoryRequest() bool {
	return true
}

func (m *_ApduDataExtWriteRouterMemoryRequest) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
