/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// Services is the corresponding interface of Services
type Services interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	// GetOffsets returns Offsets (property field)
	GetOffsets() []uint16
	// GetServices returns Services (property field)
	GetServices() []CipService
}

// ServicesExactly can be used when we want exactly this type and not a type which fulfills Services.
// This is useful for switch cases.
type ServicesExactly interface {
	Services
	isServices() bool
}

// _Services is the data-structure of this message
type _Services struct {
	Offsets  []uint16
	Services []CipService

	// Arguments.
	ServicesLen uint16
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_Services) GetOffsets() []uint16 {
	return m.Offsets
}

func (m *_Services) GetServices() []CipService {
	return m.Services
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewServices factory function for _Services
func NewServices(offsets []uint16, services []CipService, servicesLen uint16) *_Services {
	return &_Services{Offsets: offsets, Services: services, ServicesLen: servicesLen}
}

// Deprecated: use the interface for direct cast
func CastServices(structType any) Services {
	if casted, ok := structType.(Services); ok {
		return casted
	}
	if casted, ok := structType.(*Services); ok {
		return *casted
	}
	return nil
}

func (m *_Services) GetTypeName() string {
	return "Services"
}

func (m *_Services) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Implicit Field (serviceNb)
	lengthInBits += 16

	// Array field
	if len(m.Offsets) > 0 {
		lengthInBits += 16 * uint16(len(m.Offsets))
	}

	// Array field
	if len(m.Services) > 0 {
		for _curItem, element := range m.Services {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.Services), _curItem)
			_ = arrayCtx
			_ = _curItem
			lengthInBits += element.(interface{ GetLengthInBits(context.Context) uint16 }).GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_Services) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ServicesParse(ctx context.Context, theBytes []byte, servicesLen uint16) (Services, error) {
	return ServicesParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), servicesLen)
}

func ServicesParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, servicesLen uint16) (Services, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("Services"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for Services")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Implicit Field (serviceNb) (Used for parsing, but its value is not stored as it's implicitly given by the objects content)
	serviceNb, _serviceNbErr := readBuffer.ReadUint16("serviceNb", 16)
	_ = serviceNb
	if _serviceNbErr != nil {
		return nil, errors.Wrap(_serviceNbErr, "Error parsing 'serviceNb' field of Services")
	}

	// Array field (offsets)
	if pullErr := readBuffer.PullContext("offsets", utils.WithRenderAsList(true)); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for offsets")
	}
	// Count array
	offsets := make([]uint16, utils.Max(serviceNb, 0))
	// This happens when the size is set conditional to 0
	if len(offsets) == 0 {
		offsets = nil
	}
	{
		_numItems := uint16(utils.Max(serviceNb, 0))
		for _curItem := uint16(0); _curItem < _numItems; _curItem++ {
			arrayCtx := utils.CreateArrayContext(ctx, int(_numItems), int(_curItem))
			_ = arrayCtx
			_ = _curItem
			_item, _err := readBuffer.ReadUint16("", 16)
			if _err != nil {
				return nil, errors.Wrap(_err, "Error parsing 'offsets' field of Services")
			}
			offsets[_curItem] = _item
		}
	}
	if closeErr := readBuffer.CloseContext("offsets", utils.WithRenderAsList(true)); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for offsets")
	}

	// Array field (services)
	if pullErr := readBuffer.PullContext("services", utils.WithRenderAsList(true)); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for services")
	}
	// Count array
	services := make([]CipService, utils.Max(serviceNb, 0))
	// This happens when the size is set conditional to 0
	if len(services) == 0 {
		services = nil
	}
	{
		_numItems := uint16(utils.Max(serviceNb, 0))
		for _curItem := uint16(0); _curItem < _numItems; _curItem++ {
			arrayCtx := utils.CreateArrayContext(ctx, int(_numItems), int(_curItem))
			_ = arrayCtx
			_ = _curItem
			_item, _err := CipServiceParseWithBuffer(arrayCtx, readBuffer, bool(false), uint16(servicesLen)/uint16(serviceNb))
			if _err != nil {
				return nil, errors.Wrap(_err, "Error parsing 'services' field of Services")
			}
			services[_curItem] = _item.(CipService)
		}
	}
	if closeErr := readBuffer.CloseContext("services", utils.WithRenderAsList(true)); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for services")
	}

	if closeErr := readBuffer.CloseContext("Services"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for Services")
	}

	// Create the instance
	return &_Services{
		ServicesLen: servicesLen,
		Offsets:     offsets,
		Services:    services,
	}, nil
}

func (m *_Services) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_Services) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("Services"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for Services")
	}

	// Implicit Field (serviceNb) (Used for parsing, but it's value is not stored as it's implicitly given by the objects content)
	serviceNb := uint16(uint16(len(m.GetOffsets())))
	_serviceNbErr := writeBuffer.WriteUint16("serviceNb", 16, uint16((serviceNb)))
	if _serviceNbErr != nil {
		return errors.Wrap(_serviceNbErr, "Error serializing 'serviceNb' field")
	}

	// Array Field (offsets)
	if pushErr := writeBuffer.PushContext("offsets", utils.WithRenderAsList(true)); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for offsets")
	}
	for _curItem, _element := range m.GetOffsets() {
		_ = _curItem
		_elementErr := writeBuffer.WriteUint16("", 16, uint16(_element))
		if _elementErr != nil {
			return errors.Wrap(_elementErr, "Error serializing 'offsets' field")
		}
	}
	if popErr := writeBuffer.PopContext("offsets", utils.WithRenderAsList(true)); popErr != nil {
		return errors.Wrap(popErr, "Error popping for offsets")
	}

	// Array Field (services)
	if pushErr := writeBuffer.PushContext("services", utils.WithRenderAsList(true)); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for services")
	}
	for _curItem, _element := range m.GetServices() {
		_ = _curItem
		arrayCtx := utils.CreateArrayContext(ctx, len(m.GetServices()), _curItem)
		_ = arrayCtx
		_elementErr := writeBuffer.WriteSerializable(arrayCtx, _element)
		if _elementErr != nil {
			return errors.Wrap(_elementErr, "Error serializing 'services' field")
		}
	}
	if popErr := writeBuffer.PopContext("services", utils.WithRenderAsList(true)); popErr != nil {
		return errors.Wrap(popErr, "Error popping for services")
	}

	if popErr := writeBuffer.PopContext("Services"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for Services")
	}
	return nil
}

////
// Arguments Getter

func (m *_Services) GetServicesLen() uint16 {
	return m.ServicesLen
}

//
////

func (m *_Services) isServices() bool {
	return true
}

func (m *_Services) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
