/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// PortSegmentType is the corresponding interface of PortSegmentType
type PortSegmentType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	// GetExtendedLinkAddress returns ExtendedLinkAddress (discriminator field)
	GetExtendedLinkAddress() bool
}

// PortSegmentTypeExactly can be used when we want exactly this type and not a type which fulfills PortSegmentType.
// This is useful for switch cases.
type PortSegmentTypeExactly interface {
	PortSegmentType
	isPortSegmentType() bool
}

// _PortSegmentType is the data-structure of this message
type _PortSegmentType struct {
	_PortSegmentTypeChildRequirements
}

type _PortSegmentTypeChildRequirements interface {
	utils.Serializable
	GetLengthInBits(ctx context.Context) uint16
	GetExtendedLinkAddress() bool
}

type PortSegmentTypeParent interface {
	SerializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child PortSegmentType, serializeChildFunction func() error) error
	GetTypeName() string
}

type PortSegmentTypeChild interface {
	utils.Serializable
	InitializeParent(parent PortSegmentType)
	GetParent() *PortSegmentType

	GetTypeName() string
	PortSegmentType
}

// NewPortSegmentType factory function for _PortSegmentType
func NewPortSegmentType() *_PortSegmentType {
	return &_PortSegmentType{}
}

// Deprecated: use the interface for direct cast
func CastPortSegmentType(structType any) PortSegmentType {
	if casted, ok := structType.(PortSegmentType); ok {
		return casted
	}
	if casted, ok := structType.(*PortSegmentType); ok {
		return *casted
	}
	return nil
}

func (m *_PortSegmentType) GetTypeName() string {
	return "PortSegmentType"
}

func (m *_PortSegmentType) GetParentLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)
	// Discriminator Field (extendedLinkAddress)
	lengthInBits += 1

	return lengthInBits
}

func (m *_PortSegmentType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func PortSegmentTypeParse(ctx context.Context, theBytes []byte) (PortSegmentType, error) {
	return PortSegmentTypeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func PortSegmentTypeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (PortSegmentType, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("PortSegmentType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for PortSegmentType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Discriminator Field (extendedLinkAddress) (Used as input to a switch field)
	extendedLinkAddress, _extendedLinkAddressErr := readBuffer.ReadBit("extendedLinkAddress")
	if _extendedLinkAddressErr != nil {
		return nil, errors.Wrap(_extendedLinkAddressErr, "Error parsing 'extendedLinkAddress' field of PortSegmentType")
	}

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	type PortSegmentTypeChildSerializeRequirement interface {
		PortSegmentType
		InitializeParent(PortSegmentType)
		GetParent() PortSegmentType
	}
	var _childTemp any
	var _child PortSegmentTypeChildSerializeRequirement
	var typeSwitchError error
	switch {
	case extendedLinkAddress == bool(false): // PortSegmentNormal
		_childTemp, typeSwitchError = PortSegmentNormalParseWithBuffer(ctx, readBuffer)
	case extendedLinkAddress == bool(true): // PortSegmentExtended
		_childTemp, typeSwitchError = PortSegmentExtendedParseWithBuffer(ctx, readBuffer)
	default:
		typeSwitchError = errors.Errorf("Unmapped type for parameters [extendedLinkAddress=%v]", extendedLinkAddress)
	}
	if typeSwitchError != nil {
		return nil, errors.Wrap(typeSwitchError, "Error parsing sub-type for type-switch of PortSegmentType")
	}
	_child = _childTemp.(PortSegmentTypeChildSerializeRequirement)

	if closeErr := readBuffer.CloseContext("PortSegmentType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for PortSegmentType")
	}

	// Finish initializing
	_child.InitializeParent(_child)
	return _child, nil
}

func (pm *_PortSegmentType) SerializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child PortSegmentType, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("PortSegmentType"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for PortSegmentType")
	}

	// Discriminator Field (extendedLinkAddress) (Used as input to a switch field)
	extendedLinkAddress := bool(child.GetExtendedLinkAddress())
	_extendedLinkAddressErr := writeBuffer.WriteBit("extendedLinkAddress", (extendedLinkAddress))

	if _extendedLinkAddressErr != nil {
		return errors.Wrap(_extendedLinkAddressErr, "Error serializing 'extendedLinkAddress' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("PortSegmentType"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for PortSegmentType")
	}
	return nil
}

func (m *_PortSegmentType) isPortSegmentType() bool {
	return true
}

func (m *_PortSegmentType) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
