/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// PortSegmentNormal is the corresponding interface of PortSegmentNormal
type PortSegmentNormal interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	PortSegmentType
	// GetPort returns Port (property field)
	GetPort() uint8
	// GetLinkAddress returns LinkAddress (property field)
	GetLinkAddress() uint8
}

// PortSegmentNormalExactly can be used when we want exactly this type and not a type which fulfills PortSegmentNormal.
// This is useful for switch cases.
type PortSegmentNormalExactly interface {
	PortSegmentNormal
	isPortSegmentNormal() bool
}

// _PortSegmentNormal is the data-structure of this message
type _PortSegmentNormal struct {
	*_PortSegmentType
	Port        uint8
	LinkAddress uint8
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_PortSegmentNormal) GetExtendedLinkAddress() bool {
	return bool(false)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_PortSegmentNormal) InitializeParent(parent PortSegmentType) {}

func (m *_PortSegmentNormal) GetParent() PortSegmentType {
	return m._PortSegmentType
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_PortSegmentNormal) GetPort() uint8 {
	return m.Port
}

func (m *_PortSegmentNormal) GetLinkAddress() uint8 {
	return m.LinkAddress
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewPortSegmentNormal factory function for _PortSegmentNormal
func NewPortSegmentNormal(port uint8, linkAddress uint8) *_PortSegmentNormal {
	_result := &_PortSegmentNormal{
		Port:             port,
		LinkAddress:      linkAddress,
		_PortSegmentType: NewPortSegmentType(),
	}
	_result._PortSegmentType._PortSegmentTypeChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastPortSegmentNormal(structType any) PortSegmentNormal {
	if casted, ok := structType.(PortSegmentNormal); ok {
		return casted
	}
	if casted, ok := structType.(*PortSegmentNormal); ok {
		return *casted
	}
	return nil
}

func (m *_PortSegmentNormal) GetTypeName() string {
	return "PortSegmentNormal"
}

func (m *_PortSegmentNormal) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (port)
	lengthInBits += 4

	// Simple field (linkAddress)
	lengthInBits += 8

	return lengthInBits
}

func (m *_PortSegmentNormal) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func PortSegmentNormalParse(ctx context.Context, theBytes []byte) (PortSegmentNormal, error) {
	return PortSegmentNormalParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func PortSegmentNormalParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (PortSegmentNormal, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("PortSegmentNormal"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for PortSegmentNormal")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (port)
	_port, _portErr := readBuffer.ReadUint8("port", 4)
	if _portErr != nil {
		return nil, errors.Wrap(_portErr, "Error parsing 'port' field of PortSegmentNormal")
	}
	port := _port

	// Simple Field (linkAddress)
	_linkAddress, _linkAddressErr := readBuffer.ReadUint8("linkAddress", 8)
	if _linkAddressErr != nil {
		return nil, errors.Wrap(_linkAddressErr, "Error parsing 'linkAddress' field of PortSegmentNormal")
	}
	linkAddress := _linkAddress

	if closeErr := readBuffer.CloseContext("PortSegmentNormal"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for PortSegmentNormal")
	}

	// Create a partially initialized instance
	_child := &_PortSegmentNormal{
		_PortSegmentType: &_PortSegmentType{},
		Port:             port,
		LinkAddress:      linkAddress,
	}
	_child._PortSegmentType._PortSegmentTypeChildRequirements = _child
	return _child, nil
}

func (m *_PortSegmentNormal) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_PortSegmentNormal) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("PortSegmentNormal"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for PortSegmentNormal")
		}

		// Simple Field (port)
		port := uint8(m.GetPort())
		_portErr := writeBuffer.WriteUint8("port", 4, uint8((port)))
		if _portErr != nil {
			return errors.Wrap(_portErr, "Error serializing 'port' field")
		}

		// Simple Field (linkAddress)
		linkAddress := uint8(m.GetLinkAddress())
		_linkAddressErr := writeBuffer.WriteUint8("linkAddress", 8, uint8((linkAddress)))
		if _linkAddressErr != nil {
			return errors.Wrap(_linkAddressErr, "Error serializing 'linkAddress' field")
		}

		if popErr := writeBuffer.PopContext("PortSegmentNormal"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for PortSegmentNormal")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_PortSegmentNormal) isPortSegmentNormal() bool {
	return true
}

func (m *_PortSegmentNormal) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
