/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// PortSegmentExtended is the corresponding interface of PortSegmentExtended
type PortSegmentExtended interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	PortSegmentType
	// GetPort returns Port (property field)
	GetPort() uint8
	// GetLinkAddressSize returns LinkAddressSize (property field)
	GetLinkAddressSize() uint8
	// GetAddress returns Address (property field)
	GetAddress() string
	// GetPaddingByte returns PaddingByte (virtual field)
	GetPaddingByte() uint8
}

// PortSegmentExtendedExactly can be used when we want exactly this type and not a type which fulfills PortSegmentExtended.
// This is useful for switch cases.
type PortSegmentExtendedExactly interface {
	PortSegmentExtended
	isPortSegmentExtended() bool
}

// _PortSegmentExtended is the data-structure of this message
type _PortSegmentExtended struct {
	*_PortSegmentType
	Port            uint8
	LinkAddressSize uint8
	Address         string
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_PortSegmentExtended) GetExtendedLinkAddress() bool {
	return bool(true)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_PortSegmentExtended) InitializeParent(parent PortSegmentType) {}

func (m *_PortSegmentExtended) GetParent() PortSegmentType {
	return m._PortSegmentType
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_PortSegmentExtended) GetPort() uint8 {
	return m.Port
}

func (m *_PortSegmentExtended) GetLinkAddressSize() uint8 {
	return m.LinkAddressSize
}

func (m *_PortSegmentExtended) GetAddress() string {
	return m.Address
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_PortSegmentExtended) GetPaddingByte() uint8 {
	ctx := context.Background()
	_ = ctx
	return uint8(uint8(m.GetLinkAddressSize()) % uint8(uint8(2)))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewPortSegmentExtended factory function for _PortSegmentExtended
func NewPortSegmentExtended(port uint8, linkAddressSize uint8, address string) *_PortSegmentExtended {
	_result := &_PortSegmentExtended{
		Port:             port,
		LinkAddressSize:  linkAddressSize,
		Address:          address,
		_PortSegmentType: NewPortSegmentType(),
	}
	_result._PortSegmentType._PortSegmentTypeChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastPortSegmentExtended(structType any) PortSegmentExtended {
	if casted, ok := structType.(PortSegmentExtended); ok {
		return casted
	}
	if casted, ok := structType.(*PortSegmentExtended); ok {
		return *casted
	}
	return nil
}

func (m *_PortSegmentExtended) GetTypeName() string {
	return "PortSegmentExtended"
}

func (m *_PortSegmentExtended) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (port)
	lengthInBits += 4

	// Simple field (linkAddressSize)
	lengthInBits += 8

	// A virtual field doesn't have any in- or output.

	// Simple field (address)
	lengthInBits += uint16(int32((int32(m.GetLinkAddressSize()) * int32(int32(8)))) + int32((int32(m.GetPaddingByte()) * int32(int32(8)))))

	return lengthInBits
}

func (m *_PortSegmentExtended) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func PortSegmentExtendedParse(ctx context.Context, theBytes []byte) (PortSegmentExtended, error) {
	return PortSegmentExtendedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func PortSegmentExtendedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (PortSegmentExtended, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("PortSegmentExtended"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for PortSegmentExtended")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (port)
	_port, _portErr := readBuffer.ReadUint8("port", 4)
	if _portErr != nil {
		return nil, errors.Wrap(_portErr, "Error parsing 'port' field of PortSegmentExtended")
	}
	port := _port

	// Simple Field (linkAddressSize)
	_linkAddressSize, _linkAddressSizeErr := readBuffer.ReadUint8("linkAddressSize", 8)
	if _linkAddressSizeErr != nil {
		return nil, errors.Wrap(_linkAddressSizeErr, "Error parsing 'linkAddressSize' field of PortSegmentExtended")
	}
	linkAddressSize := _linkAddressSize

	// Virtual field
	_paddingByte := uint8(linkAddressSize) % uint8(uint8(2))
	paddingByte := uint8(_paddingByte)
	_ = paddingByte

	// Simple Field (address)
	_address, _addressErr := readBuffer.ReadString("address", uint32(((linkAddressSize)*(8))+((paddingByte)*(8))), "UTF-8")
	if _addressErr != nil {
		return nil, errors.Wrap(_addressErr, "Error parsing 'address' field of PortSegmentExtended")
	}
	address := _address

	if closeErr := readBuffer.CloseContext("PortSegmentExtended"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for PortSegmentExtended")
	}

	// Create a partially initialized instance
	_child := &_PortSegmentExtended{
		_PortSegmentType: &_PortSegmentType{},
		Port:             port,
		LinkAddressSize:  linkAddressSize,
		Address:          address,
	}
	_child._PortSegmentType._PortSegmentTypeChildRequirements = _child
	return _child, nil
}

func (m *_PortSegmentExtended) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_PortSegmentExtended) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("PortSegmentExtended"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for PortSegmentExtended")
		}

		// Simple Field (port)
		port := uint8(m.GetPort())
		_portErr := writeBuffer.WriteUint8("port", 4, uint8((port)))
		if _portErr != nil {
			return errors.Wrap(_portErr, "Error serializing 'port' field")
		}

		// Simple Field (linkAddressSize)
		linkAddressSize := uint8(m.GetLinkAddressSize())
		_linkAddressSizeErr := writeBuffer.WriteUint8("linkAddressSize", 8, uint8((linkAddressSize)))
		if _linkAddressSizeErr != nil {
			return errors.Wrap(_linkAddressSizeErr, "Error serializing 'linkAddressSize' field")
		}
		// Virtual field
		paddingByte := m.GetPaddingByte()
		_ = paddingByte
		if _paddingByteErr := writeBuffer.WriteVirtual(ctx, "paddingByte", m.GetPaddingByte()); _paddingByteErr != nil {
			return errors.Wrap(_paddingByteErr, "Error serializing 'paddingByte' field")
		}

		// Simple Field (address)
		address := string(m.GetAddress())
		_addressErr := writeBuffer.WriteString("address", uint32(((m.GetLinkAddressSize())*(8))+((m.GetPaddingByte())*(8))), "UTF-8", (address))
		if _addressErr != nil {
			return errors.Wrap(_addressErr, "Error serializing 'address' field")
		}

		if popErr := writeBuffer.PopContext("PortSegmentExtended"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for PortSegmentExtended")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_PortSegmentExtended) isPortSegmentExtended() bool {
	return true
}

func (m *_PortSegmentExtended) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
