/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// HVACHumidityError is an enum
type HVACHumidityError uint8

type IHVACHumidityError interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	HVACHumidityError_NO_ERROR                       HVACHumidityError = 0x00
	HVACHumidityError_HUMIDIFIER_TOTAL_FAILURE       HVACHumidityError = 0x01
	HVACHumidityError_DEHUMIDIFIER_TOTAL_FAILURE     HVACHumidityError = 0x02
	HVACHumidityError_FAN_TOTAL_FAILURE              HVACHumidityError = 0x03
	HVACHumidityError_HUMIDITY_SENSOR_FAILURE        HVACHumidityError = 0x04
	HVACHumidityError_HUMIDIFIER_TEMPORARY_PROBLEM   HVACHumidityError = 0x05
	HVACHumidityError_DEHUMIDIFIER_TEMPORARY_PROBLEM HVACHumidityError = 0x06
	HVACHumidityError_FAN_TEMPORARY_PROBLEM          HVACHumidityError = 0x07
	HVACHumidityError_HUMIDIFIER_SERVICE_REQUIRED    HVACHumidityError = 0x08
	HVACHumidityError_DEHUMIDIFIER_SERVICE_REQUIRED  HVACHumidityError = 0x09
	HVACHumidityError_FAN_SERVICE_REQUIRED           HVACHumidityError = 0x0A
	HVACHumidityError_FILTER_REPLACEMENT_REQUIRED    HVACHumidityError = 0x0B
	HVACHumidityError_CUSTOM_ERROR_0                 HVACHumidityError = 0x80
	HVACHumidityError_CUSTOM_ERROR_1                 HVACHumidityError = 0x81
	HVACHumidityError_CUSTOM_ERROR_2                 HVACHumidityError = 0x82
	HVACHumidityError_CUSTOM_ERROR_3                 HVACHumidityError = 0x83
	HVACHumidityError_CUSTOM_ERROR_4                 HVACHumidityError = 0x84
	HVACHumidityError_CUSTOM_ERROR_5                 HVACHumidityError = 0x85
	HVACHumidityError_CUSTOM_ERROR_6                 HVACHumidityError = 0x86
	HVACHumidityError_CUSTOM_ERROR_7                 HVACHumidityError = 0x87
	HVACHumidityError_CUSTOM_ERROR_8                 HVACHumidityError = 0x88
	HVACHumidityError_CUSTOM_ERROR_9                 HVACHumidityError = 0x89
	HVACHumidityError_CUSTOM_ERROR_10                HVACHumidityError = 0x8A
	HVACHumidityError_CUSTOM_ERROR_11                HVACHumidityError = 0x8B
	HVACHumidityError_CUSTOM_ERROR_12                HVACHumidityError = 0x8C
	HVACHumidityError_CUSTOM_ERROR_13                HVACHumidityError = 0x8D
	HVACHumidityError_CUSTOM_ERROR_14                HVACHumidityError = 0x8E
	HVACHumidityError_CUSTOM_ERROR_15                HVACHumidityError = 0x8F
	HVACHumidityError_CUSTOM_ERROR_16                HVACHumidityError = 0x90
	HVACHumidityError_CUSTOM_ERROR_17                HVACHumidityError = 0x91
	HVACHumidityError_CUSTOM_ERROR_18                HVACHumidityError = 0x92
	HVACHumidityError_CUSTOM_ERROR_19                HVACHumidityError = 0x93
	HVACHumidityError_CUSTOM_ERROR_20                HVACHumidityError = 0x94
	HVACHumidityError_CUSTOM_ERROR_21                HVACHumidityError = 0x95
	HVACHumidityError_CUSTOM_ERROR_22                HVACHumidityError = 0x96
	HVACHumidityError_CUSTOM_ERROR_23                HVACHumidityError = 0x97
	HVACHumidityError_CUSTOM_ERROR_24                HVACHumidityError = 0x98
	HVACHumidityError_CUSTOM_ERROR_25                HVACHumidityError = 0x99
	HVACHumidityError_CUSTOM_ERROR_26                HVACHumidityError = 0x9A
	HVACHumidityError_CUSTOM_ERROR_27                HVACHumidityError = 0x9B
	HVACHumidityError_CUSTOM_ERROR_28                HVACHumidityError = 0x9C
	HVACHumidityError_CUSTOM_ERROR_29                HVACHumidityError = 0x9D
	HVACHumidityError_CUSTOM_ERROR_30                HVACHumidityError = 0x9E
	HVACHumidityError_CUSTOM_ERROR_31                HVACHumidityError = 0x9F
	HVACHumidityError_CUSTOM_ERROR_32                HVACHumidityError = 0xA0
	HVACHumidityError_CUSTOM_ERROR_33                HVACHumidityError = 0xA1
	HVACHumidityError_CUSTOM_ERROR_34                HVACHumidityError = 0xA2
	HVACHumidityError_CUSTOM_ERROR_35                HVACHumidityError = 0xA3
	HVACHumidityError_CUSTOM_ERROR_36                HVACHumidityError = 0xA4
	HVACHumidityError_CUSTOM_ERROR_37                HVACHumidityError = 0xA5
	HVACHumidityError_CUSTOM_ERROR_38                HVACHumidityError = 0xA6
	HVACHumidityError_CUSTOM_ERROR_39                HVACHumidityError = 0xA7
	HVACHumidityError_CUSTOM_ERROR_40                HVACHumidityError = 0xA8
	HVACHumidityError_CUSTOM_ERROR_41                HVACHumidityError = 0xA9
	HVACHumidityError_CUSTOM_ERROR_42                HVACHumidityError = 0xAA
	HVACHumidityError_CUSTOM_ERROR_43                HVACHumidityError = 0xAB
	HVACHumidityError_CUSTOM_ERROR_44                HVACHumidityError = 0xAC
	HVACHumidityError_CUSTOM_ERROR_45                HVACHumidityError = 0xAD
	HVACHumidityError_CUSTOM_ERROR_46                HVACHumidityError = 0xAE
	HVACHumidityError_CUSTOM_ERROR_47                HVACHumidityError = 0xAF
	HVACHumidityError_CUSTOM_ERROR_48                HVACHumidityError = 0xB0
	HVACHumidityError_CUSTOM_ERROR_49                HVACHumidityError = 0xB1
	HVACHumidityError_CUSTOM_ERROR_50                HVACHumidityError = 0xB2
	HVACHumidityError_CUSTOM_ERROR_51                HVACHumidityError = 0xB3
	HVACHumidityError_CUSTOM_ERROR_52                HVACHumidityError = 0xB4
	HVACHumidityError_CUSTOM_ERROR_53                HVACHumidityError = 0xB5
	HVACHumidityError_CUSTOM_ERROR_54                HVACHumidityError = 0xB6
	HVACHumidityError_CUSTOM_ERROR_55                HVACHumidityError = 0xB7
	HVACHumidityError_CUSTOM_ERROR_56                HVACHumidityError = 0xB8
	HVACHumidityError_CUSTOM_ERROR_57                HVACHumidityError = 0xB9
	HVACHumidityError_CUSTOM_ERROR_58                HVACHumidityError = 0xBA
	HVACHumidityError_CUSTOM_ERROR_59                HVACHumidityError = 0xBB
	HVACHumidityError_CUSTOM_ERROR_60                HVACHumidityError = 0xBC
	HVACHumidityError_CUSTOM_ERROR_61                HVACHumidityError = 0xBD
	HVACHumidityError_CUSTOM_ERROR_62                HVACHumidityError = 0xBE
	HVACHumidityError_CUSTOM_ERROR_63                HVACHumidityError = 0xBF
	HVACHumidityError_CUSTOM_ERROR_64                HVACHumidityError = 0xC0
	HVACHumidityError_CUSTOM_ERROR_65                HVACHumidityError = 0xC1
	HVACHumidityError_CUSTOM_ERROR_66                HVACHumidityError = 0xC2
	HVACHumidityError_CUSTOM_ERROR_67                HVACHumidityError = 0xC3
	HVACHumidityError_CUSTOM_ERROR_68                HVACHumidityError = 0xC4
	HVACHumidityError_CUSTOM_ERROR_69                HVACHumidityError = 0xC5
	HVACHumidityError_CUSTOM_ERROR_70                HVACHumidityError = 0xC6
	HVACHumidityError_CUSTOM_ERROR_71                HVACHumidityError = 0xC7
	HVACHumidityError_CUSTOM_ERROR_72                HVACHumidityError = 0xC8
	HVACHumidityError_CUSTOM_ERROR_73                HVACHumidityError = 0xC9
	HVACHumidityError_CUSTOM_ERROR_74                HVACHumidityError = 0xCA
	HVACHumidityError_CUSTOM_ERROR_75                HVACHumidityError = 0xCB
	HVACHumidityError_CUSTOM_ERROR_76                HVACHumidityError = 0xCC
	HVACHumidityError_CUSTOM_ERROR_77                HVACHumidityError = 0xCD
	HVACHumidityError_CUSTOM_ERROR_78                HVACHumidityError = 0xCE
	HVACHumidityError_CUSTOM_ERROR_79                HVACHumidityError = 0xCF
	HVACHumidityError_CUSTOM_ERROR_80                HVACHumidityError = 0xD0
	HVACHumidityError_CUSTOM_ERROR_81                HVACHumidityError = 0xD1
	HVACHumidityError_CUSTOM_ERROR_82                HVACHumidityError = 0xD2
	HVACHumidityError_CUSTOM_ERROR_83                HVACHumidityError = 0xD3
	HVACHumidityError_CUSTOM_ERROR_84                HVACHumidityError = 0xD4
	HVACHumidityError_CUSTOM_ERROR_85                HVACHumidityError = 0xD5
	HVACHumidityError_CUSTOM_ERROR_86                HVACHumidityError = 0xD6
	HVACHumidityError_CUSTOM_ERROR_87                HVACHumidityError = 0xD7
	HVACHumidityError_CUSTOM_ERROR_88                HVACHumidityError = 0xD8
	HVACHumidityError_CUSTOM_ERROR_89                HVACHumidityError = 0xD9
	HVACHumidityError_CUSTOM_ERROR_90                HVACHumidityError = 0xDA
	HVACHumidityError_CUSTOM_ERROR_91                HVACHumidityError = 0xDB
	HVACHumidityError_CUSTOM_ERROR_92                HVACHumidityError = 0xDC
	HVACHumidityError_CUSTOM_ERROR_93                HVACHumidityError = 0xDD
	HVACHumidityError_CUSTOM_ERROR_94                HVACHumidityError = 0xDE
	HVACHumidityError_CUSTOM_ERROR_95                HVACHumidityError = 0xDF
	HVACHumidityError_CUSTOM_ERROR_96                HVACHumidityError = 0xE0
	HVACHumidityError_CUSTOM_ERROR_97                HVACHumidityError = 0xE1
	HVACHumidityError_CUSTOM_ERROR_98                HVACHumidityError = 0xE2
	HVACHumidityError_CUSTOM_ERROR_99                HVACHumidityError = 0xE3
	HVACHumidityError_CUSTOM_ERROR_100               HVACHumidityError = 0xE4
	HVACHumidityError_CUSTOM_ERROR_101               HVACHumidityError = 0xE5
	HVACHumidityError_CUSTOM_ERROR_102               HVACHumidityError = 0xE6
	HVACHumidityError_CUSTOM_ERROR_103               HVACHumidityError = 0xE7
	HVACHumidityError_CUSTOM_ERROR_104               HVACHumidityError = 0xE8
	HVACHumidityError_CUSTOM_ERROR_105               HVACHumidityError = 0xE9
	HVACHumidityError_CUSTOM_ERROR_106               HVACHumidityError = 0xEA
	HVACHumidityError_CUSTOM_ERROR_107               HVACHumidityError = 0xEB
	HVACHumidityError_CUSTOM_ERROR_108               HVACHumidityError = 0xEC
	HVACHumidityError_CUSTOM_ERROR_109               HVACHumidityError = 0xED
	HVACHumidityError_CUSTOM_ERROR_110               HVACHumidityError = 0xEE
	HVACHumidityError_CUSTOM_ERROR_111               HVACHumidityError = 0xEF
	HVACHumidityError_CUSTOM_ERROR_112               HVACHumidityError = 0xF0
	HVACHumidityError_CUSTOM_ERROR_113               HVACHumidityError = 0xF1
	HVACHumidityError_CUSTOM_ERROR_114               HVACHumidityError = 0xF2
	HVACHumidityError_CUSTOM_ERROR_115               HVACHumidityError = 0xF3
	HVACHumidityError_CUSTOM_ERROR_116               HVACHumidityError = 0xF4
	HVACHumidityError_CUSTOM_ERROR_117               HVACHumidityError = 0xF5
	HVACHumidityError_CUSTOM_ERROR_118               HVACHumidityError = 0xF6
	HVACHumidityError_CUSTOM_ERROR_119               HVACHumidityError = 0xF7
	HVACHumidityError_CUSTOM_ERROR_120               HVACHumidityError = 0xF8
	HVACHumidityError_CUSTOM_ERROR_121               HVACHumidityError = 0xF9
	HVACHumidityError_CUSTOM_ERROR_122               HVACHumidityError = 0xFA
	HVACHumidityError_CUSTOM_ERROR_123               HVACHumidityError = 0xFB
	HVACHumidityError_CUSTOM_ERROR_124               HVACHumidityError = 0xFC
	HVACHumidityError_CUSTOM_ERROR_125               HVACHumidityError = 0xFD
	HVACHumidityError_CUSTOM_ERROR_126               HVACHumidityError = 0xFE
	HVACHumidityError_CUSTOM_ERROR_127               HVACHumidityError = 0xFF
)

var HVACHumidityErrorValues []HVACHumidityError

func init() {
	_ = errors.New
	HVACHumidityErrorValues = []HVACHumidityError{
		HVACHumidityError_NO_ERROR,
		HVACHumidityError_HUMIDIFIER_TOTAL_FAILURE,
		HVACHumidityError_DEHUMIDIFIER_TOTAL_FAILURE,
		HVACHumidityError_FAN_TOTAL_FAILURE,
		HVACHumidityError_HUMIDITY_SENSOR_FAILURE,
		HVACHumidityError_HUMIDIFIER_TEMPORARY_PROBLEM,
		HVACHumidityError_DEHUMIDIFIER_TEMPORARY_PROBLEM,
		HVACHumidityError_FAN_TEMPORARY_PROBLEM,
		HVACHumidityError_HUMIDIFIER_SERVICE_REQUIRED,
		HVACHumidityError_DEHUMIDIFIER_SERVICE_REQUIRED,
		HVACHumidityError_FAN_SERVICE_REQUIRED,
		HVACHumidityError_FILTER_REPLACEMENT_REQUIRED,
		HVACHumidityError_CUSTOM_ERROR_0,
		HVACHumidityError_CUSTOM_ERROR_1,
		HVACHumidityError_CUSTOM_ERROR_2,
		HVACHumidityError_CUSTOM_ERROR_3,
		HVACHumidityError_CUSTOM_ERROR_4,
		HVACHumidityError_CUSTOM_ERROR_5,
		HVACHumidityError_CUSTOM_ERROR_6,
		HVACHumidityError_CUSTOM_ERROR_7,
		HVACHumidityError_CUSTOM_ERROR_8,
		HVACHumidityError_CUSTOM_ERROR_9,
		HVACHumidityError_CUSTOM_ERROR_10,
		HVACHumidityError_CUSTOM_ERROR_11,
		HVACHumidityError_CUSTOM_ERROR_12,
		HVACHumidityError_CUSTOM_ERROR_13,
		HVACHumidityError_CUSTOM_ERROR_14,
		HVACHumidityError_CUSTOM_ERROR_15,
		HVACHumidityError_CUSTOM_ERROR_16,
		HVACHumidityError_CUSTOM_ERROR_17,
		HVACHumidityError_CUSTOM_ERROR_18,
		HVACHumidityError_CUSTOM_ERROR_19,
		HVACHumidityError_CUSTOM_ERROR_20,
		HVACHumidityError_CUSTOM_ERROR_21,
		HVACHumidityError_CUSTOM_ERROR_22,
		HVACHumidityError_CUSTOM_ERROR_23,
		HVACHumidityError_CUSTOM_ERROR_24,
		HVACHumidityError_CUSTOM_ERROR_25,
		HVACHumidityError_CUSTOM_ERROR_26,
		HVACHumidityError_CUSTOM_ERROR_27,
		HVACHumidityError_CUSTOM_ERROR_28,
		HVACHumidityError_CUSTOM_ERROR_29,
		HVACHumidityError_CUSTOM_ERROR_30,
		HVACHumidityError_CUSTOM_ERROR_31,
		HVACHumidityError_CUSTOM_ERROR_32,
		HVACHumidityError_CUSTOM_ERROR_33,
		HVACHumidityError_CUSTOM_ERROR_34,
		HVACHumidityError_CUSTOM_ERROR_35,
		HVACHumidityError_CUSTOM_ERROR_36,
		HVACHumidityError_CUSTOM_ERROR_37,
		HVACHumidityError_CUSTOM_ERROR_38,
		HVACHumidityError_CUSTOM_ERROR_39,
		HVACHumidityError_CUSTOM_ERROR_40,
		HVACHumidityError_CUSTOM_ERROR_41,
		HVACHumidityError_CUSTOM_ERROR_42,
		HVACHumidityError_CUSTOM_ERROR_43,
		HVACHumidityError_CUSTOM_ERROR_44,
		HVACHumidityError_CUSTOM_ERROR_45,
		HVACHumidityError_CUSTOM_ERROR_46,
		HVACHumidityError_CUSTOM_ERROR_47,
		HVACHumidityError_CUSTOM_ERROR_48,
		HVACHumidityError_CUSTOM_ERROR_49,
		HVACHumidityError_CUSTOM_ERROR_50,
		HVACHumidityError_CUSTOM_ERROR_51,
		HVACHumidityError_CUSTOM_ERROR_52,
		HVACHumidityError_CUSTOM_ERROR_53,
		HVACHumidityError_CUSTOM_ERROR_54,
		HVACHumidityError_CUSTOM_ERROR_55,
		HVACHumidityError_CUSTOM_ERROR_56,
		HVACHumidityError_CUSTOM_ERROR_57,
		HVACHumidityError_CUSTOM_ERROR_58,
		HVACHumidityError_CUSTOM_ERROR_59,
		HVACHumidityError_CUSTOM_ERROR_60,
		HVACHumidityError_CUSTOM_ERROR_61,
		HVACHumidityError_CUSTOM_ERROR_62,
		HVACHumidityError_CUSTOM_ERROR_63,
		HVACHumidityError_CUSTOM_ERROR_64,
		HVACHumidityError_CUSTOM_ERROR_65,
		HVACHumidityError_CUSTOM_ERROR_66,
		HVACHumidityError_CUSTOM_ERROR_67,
		HVACHumidityError_CUSTOM_ERROR_68,
		HVACHumidityError_CUSTOM_ERROR_69,
		HVACHumidityError_CUSTOM_ERROR_70,
		HVACHumidityError_CUSTOM_ERROR_71,
		HVACHumidityError_CUSTOM_ERROR_72,
		HVACHumidityError_CUSTOM_ERROR_73,
		HVACHumidityError_CUSTOM_ERROR_74,
		HVACHumidityError_CUSTOM_ERROR_75,
		HVACHumidityError_CUSTOM_ERROR_76,
		HVACHumidityError_CUSTOM_ERROR_77,
		HVACHumidityError_CUSTOM_ERROR_78,
		HVACHumidityError_CUSTOM_ERROR_79,
		HVACHumidityError_CUSTOM_ERROR_80,
		HVACHumidityError_CUSTOM_ERROR_81,
		HVACHumidityError_CUSTOM_ERROR_82,
		HVACHumidityError_CUSTOM_ERROR_83,
		HVACHumidityError_CUSTOM_ERROR_84,
		HVACHumidityError_CUSTOM_ERROR_85,
		HVACHumidityError_CUSTOM_ERROR_86,
		HVACHumidityError_CUSTOM_ERROR_87,
		HVACHumidityError_CUSTOM_ERROR_88,
		HVACHumidityError_CUSTOM_ERROR_89,
		HVACHumidityError_CUSTOM_ERROR_90,
		HVACHumidityError_CUSTOM_ERROR_91,
		HVACHumidityError_CUSTOM_ERROR_92,
		HVACHumidityError_CUSTOM_ERROR_93,
		HVACHumidityError_CUSTOM_ERROR_94,
		HVACHumidityError_CUSTOM_ERROR_95,
		HVACHumidityError_CUSTOM_ERROR_96,
		HVACHumidityError_CUSTOM_ERROR_97,
		HVACHumidityError_CUSTOM_ERROR_98,
		HVACHumidityError_CUSTOM_ERROR_99,
		HVACHumidityError_CUSTOM_ERROR_100,
		HVACHumidityError_CUSTOM_ERROR_101,
		HVACHumidityError_CUSTOM_ERROR_102,
		HVACHumidityError_CUSTOM_ERROR_103,
		HVACHumidityError_CUSTOM_ERROR_104,
		HVACHumidityError_CUSTOM_ERROR_105,
		HVACHumidityError_CUSTOM_ERROR_106,
		HVACHumidityError_CUSTOM_ERROR_107,
		HVACHumidityError_CUSTOM_ERROR_108,
		HVACHumidityError_CUSTOM_ERROR_109,
		HVACHumidityError_CUSTOM_ERROR_110,
		HVACHumidityError_CUSTOM_ERROR_111,
		HVACHumidityError_CUSTOM_ERROR_112,
		HVACHumidityError_CUSTOM_ERROR_113,
		HVACHumidityError_CUSTOM_ERROR_114,
		HVACHumidityError_CUSTOM_ERROR_115,
		HVACHumidityError_CUSTOM_ERROR_116,
		HVACHumidityError_CUSTOM_ERROR_117,
		HVACHumidityError_CUSTOM_ERROR_118,
		HVACHumidityError_CUSTOM_ERROR_119,
		HVACHumidityError_CUSTOM_ERROR_120,
		HVACHumidityError_CUSTOM_ERROR_121,
		HVACHumidityError_CUSTOM_ERROR_122,
		HVACHumidityError_CUSTOM_ERROR_123,
		HVACHumidityError_CUSTOM_ERROR_124,
		HVACHumidityError_CUSTOM_ERROR_125,
		HVACHumidityError_CUSTOM_ERROR_126,
		HVACHumidityError_CUSTOM_ERROR_127,
	}
}

func HVACHumidityErrorByValue(value uint8) (enum HVACHumidityError, ok bool) {
	switch value {
	case 0x00:
		return HVACHumidityError_NO_ERROR, true
	case 0x01:
		return HVACHumidityError_HUMIDIFIER_TOTAL_FAILURE, true
	case 0x02:
		return HVACHumidityError_DEHUMIDIFIER_TOTAL_FAILURE, true
	case 0x03:
		return HVACHumidityError_FAN_TOTAL_FAILURE, true
	case 0x04:
		return HVACHumidityError_HUMIDITY_SENSOR_FAILURE, true
	case 0x05:
		return HVACHumidityError_HUMIDIFIER_TEMPORARY_PROBLEM, true
	case 0x06:
		return HVACHumidityError_DEHUMIDIFIER_TEMPORARY_PROBLEM, true
	case 0x07:
		return HVACHumidityError_FAN_TEMPORARY_PROBLEM, true
	case 0x08:
		return HVACHumidityError_HUMIDIFIER_SERVICE_REQUIRED, true
	case 0x09:
		return HVACHumidityError_DEHUMIDIFIER_SERVICE_REQUIRED, true
	case 0x0A:
		return HVACHumidityError_FAN_SERVICE_REQUIRED, true
	case 0x0B:
		return HVACHumidityError_FILTER_REPLACEMENT_REQUIRED, true
	case 0x80:
		return HVACHumidityError_CUSTOM_ERROR_0, true
	case 0x81:
		return HVACHumidityError_CUSTOM_ERROR_1, true
	case 0x82:
		return HVACHumidityError_CUSTOM_ERROR_2, true
	case 0x83:
		return HVACHumidityError_CUSTOM_ERROR_3, true
	case 0x84:
		return HVACHumidityError_CUSTOM_ERROR_4, true
	case 0x85:
		return HVACHumidityError_CUSTOM_ERROR_5, true
	case 0x86:
		return HVACHumidityError_CUSTOM_ERROR_6, true
	case 0x87:
		return HVACHumidityError_CUSTOM_ERROR_7, true
	case 0x88:
		return HVACHumidityError_CUSTOM_ERROR_8, true
	case 0x89:
		return HVACHumidityError_CUSTOM_ERROR_9, true
	case 0x8A:
		return HVACHumidityError_CUSTOM_ERROR_10, true
	case 0x8B:
		return HVACHumidityError_CUSTOM_ERROR_11, true
	case 0x8C:
		return HVACHumidityError_CUSTOM_ERROR_12, true
	case 0x8D:
		return HVACHumidityError_CUSTOM_ERROR_13, true
	case 0x8E:
		return HVACHumidityError_CUSTOM_ERROR_14, true
	case 0x8F:
		return HVACHumidityError_CUSTOM_ERROR_15, true
	case 0x90:
		return HVACHumidityError_CUSTOM_ERROR_16, true
	case 0x91:
		return HVACHumidityError_CUSTOM_ERROR_17, true
	case 0x92:
		return HVACHumidityError_CUSTOM_ERROR_18, true
	case 0x93:
		return HVACHumidityError_CUSTOM_ERROR_19, true
	case 0x94:
		return HVACHumidityError_CUSTOM_ERROR_20, true
	case 0x95:
		return HVACHumidityError_CUSTOM_ERROR_21, true
	case 0x96:
		return HVACHumidityError_CUSTOM_ERROR_22, true
	case 0x97:
		return HVACHumidityError_CUSTOM_ERROR_23, true
	case 0x98:
		return HVACHumidityError_CUSTOM_ERROR_24, true
	case 0x99:
		return HVACHumidityError_CUSTOM_ERROR_25, true
	case 0x9A:
		return HVACHumidityError_CUSTOM_ERROR_26, true
	case 0x9B:
		return HVACHumidityError_CUSTOM_ERROR_27, true
	case 0x9C:
		return HVACHumidityError_CUSTOM_ERROR_28, true
	case 0x9D:
		return HVACHumidityError_CUSTOM_ERROR_29, true
	case 0x9E:
		return HVACHumidityError_CUSTOM_ERROR_30, true
	case 0x9F:
		return HVACHumidityError_CUSTOM_ERROR_31, true
	case 0xA0:
		return HVACHumidityError_CUSTOM_ERROR_32, true
	case 0xA1:
		return HVACHumidityError_CUSTOM_ERROR_33, true
	case 0xA2:
		return HVACHumidityError_CUSTOM_ERROR_34, true
	case 0xA3:
		return HVACHumidityError_CUSTOM_ERROR_35, true
	case 0xA4:
		return HVACHumidityError_CUSTOM_ERROR_36, true
	case 0xA5:
		return HVACHumidityError_CUSTOM_ERROR_37, true
	case 0xA6:
		return HVACHumidityError_CUSTOM_ERROR_38, true
	case 0xA7:
		return HVACHumidityError_CUSTOM_ERROR_39, true
	case 0xA8:
		return HVACHumidityError_CUSTOM_ERROR_40, true
	case 0xA9:
		return HVACHumidityError_CUSTOM_ERROR_41, true
	case 0xAA:
		return HVACHumidityError_CUSTOM_ERROR_42, true
	case 0xAB:
		return HVACHumidityError_CUSTOM_ERROR_43, true
	case 0xAC:
		return HVACHumidityError_CUSTOM_ERROR_44, true
	case 0xAD:
		return HVACHumidityError_CUSTOM_ERROR_45, true
	case 0xAE:
		return HVACHumidityError_CUSTOM_ERROR_46, true
	case 0xAF:
		return HVACHumidityError_CUSTOM_ERROR_47, true
	case 0xB0:
		return HVACHumidityError_CUSTOM_ERROR_48, true
	case 0xB1:
		return HVACHumidityError_CUSTOM_ERROR_49, true
	case 0xB2:
		return HVACHumidityError_CUSTOM_ERROR_50, true
	case 0xB3:
		return HVACHumidityError_CUSTOM_ERROR_51, true
	case 0xB4:
		return HVACHumidityError_CUSTOM_ERROR_52, true
	case 0xB5:
		return HVACHumidityError_CUSTOM_ERROR_53, true
	case 0xB6:
		return HVACHumidityError_CUSTOM_ERROR_54, true
	case 0xB7:
		return HVACHumidityError_CUSTOM_ERROR_55, true
	case 0xB8:
		return HVACHumidityError_CUSTOM_ERROR_56, true
	case 0xB9:
		return HVACHumidityError_CUSTOM_ERROR_57, true
	case 0xBA:
		return HVACHumidityError_CUSTOM_ERROR_58, true
	case 0xBB:
		return HVACHumidityError_CUSTOM_ERROR_59, true
	case 0xBC:
		return HVACHumidityError_CUSTOM_ERROR_60, true
	case 0xBD:
		return HVACHumidityError_CUSTOM_ERROR_61, true
	case 0xBE:
		return HVACHumidityError_CUSTOM_ERROR_62, true
	case 0xBF:
		return HVACHumidityError_CUSTOM_ERROR_63, true
	case 0xC0:
		return HVACHumidityError_CUSTOM_ERROR_64, true
	case 0xC1:
		return HVACHumidityError_CUSTOM_ERROR_65, true
	case 0xC2:
		return HVACHumidityError_CUSTOM_ERROR_66, true
	case 0xC3:
		return HVACHumidityError_CUSTOM_ERROR_67, true
	case 0xC4:
		return HVACHumidityError_CUSTOM_ERROR_68, true
	case 0xC5:
		return HVACHumidityError_CUSTOM_ERROR_69, true
	case 0xC6:
		return HVACHumidityError_CUSTOM_ERROR_70, true
	case 0xC7:
		return HVACHumidityError_CUSTOM_ERROR_71, true
	case 0xC8:
		return HVACHumidityError_CUSTOM_ERROR_72, true
	case 0xC9:
		return HVACHumidityError_CUSTOM_ERROR_73, true
	case 0xCA:
		return HVACHumidityError_CUSTOM_ERROR_74, true
	case 0xCB:
		return HVACHumidityError_CUSTOM_ERROR_75, true
	case 0xCC:
		return HVACHumidityError_CUSTOM_ERROR_76, true
	case 0xCD:
		return HVACHumidityError_CUSTOM_ERROR_77, true
	case 0xCE:
		return HVACHumidityError_CUSTOM_ERROR_78, true
	case 0xCF:
		return HVACHumidityError_CUSTOM_ERROR_79, true
	case 0xD0:
		return HVACHumidityError_CUSTOM_ERROR_80, true
	case 0xD1:
		return HVACHumidityError_CUSTOM_ERROR_81, true
	case 0xD2:
		return HVACHumidityError_CUSTOM_ERROR_82, true
	case 0xD3:
		return HVACHumidityError_CUSTOM_ERROR_83, true
	case 0xD4:
		return HVACHumidityError_CUSTOM_ERROR_84, true
	case 0xD5:
		return HVACHumidityError_CUSTOM_ERROR_85, true
	case 0xD6:
		return HVACHumidityError_CUSTOM_ERROR_86, true
	case 0xD7:
		return HVACHumidityError_CUSTOM_ERROR_87, true
	case 0xD8:
		return HVACHumidityError_CUSTOM_ERROR_88, true
	case 0xD9:
		return HVACHumidityError_CUSTOM_ERROR_89, true
	case 0xDA:
		return HVACHumidityError_CUSTOM_ERROR_90, true
	case 0xDB:
		return HVACHumidityError_CUSTOM_ERROR_91, true
	case 0xDC:
		return HVACHumidityError_CUSTOM_ERROR_92, true
	case 0xDD:
		return HVACHumidityError_CUSTOM_ERROR_93, true
	case 0xDE:
		return HVACHumidityError_CUSTOM_ERROR_94, true
	case 0xDF:
		return HVACHumidityError_CUSTOM_ERROR_95, true
	case 0xE0:
		return HVACHumidityError_CUSTOM_ERROR_96, true
	case 0xE1:
		return HVACHumidityError_CUSTOM_ERROR_97, true
	case 0xE2:
		return HVACHumidityError_CUSTOM_ERROR_98, true
	case 0xE3:
		return HVACHumidityError_CUSTOM_ERROR_99, true
	case 0xE4:
		return HVACHumidityError_CUSTOM_ERROR_100, true
	case 0xE5:
		return HVACHumidityError_CUSTOM_ERROR_101, true
	case 0xE6:
		return HVACHumidityError_CUSTOM_ERROR_102, true
	case 0xE7:
		return HVACHumidityError_CUSTOM_ERROR_103, true
	case 0xE8:
		return HVACHumidityError_CUSTOM_ERROR_104, true
	case 0xE9:
		return HVACHumidityError_CUSTOM_ERROR_105, true
	case 0xEA:
		return HVACHumidityError_CUSTOM_ERROR_106, true
	case 0xEB:
		return HVACHumidityError_CUSTOM_ERROR_107, true
	case 0xEC:
		return HVACHumidityError_CUSTOM_ERROR_108, true
	case 0xED:
		return HVACHumidityError_CUSTOM_ERROR_109, true
	case 0xEE:
		return HVACHumidityError_CUSTOM_ERROR_110, true
	case 0xEF:
		return HVACHumidityError_CUSTOM_ERROR_111, true
	case 0xF0:
		return HVACHumidityError_CUSTOM_ERROR_112, true
	case 0xF1:
		return HVACHumidityError_CUSTOM_ERROR_113, true
	case 0xF2:
		return HVACHumidityError_CUSTOM_ERROR_114, true
	case 0xF3:
		return HVACHumidityError_CUSTOM_ERROR_115, true
	case 0xF4:
		return HVACHumidityError_CUSTOM_ERROR_116, true
	case 0xF5:
		return HVACHumidityError_CUSTOM_ERROR_117, true
	case 0xF6:
		return HVACHumidityError_CUSTOM_ERROR_118, true
	case 0xF7:
		return HVACHumidityError_CUSTOM_ERROR_119, true
	case 0xF8:
		return HVACHumidityError_CUSTOM_ERROR_120, true
	case 0xF9:
		return HVACHumidityError_CUSTOM_ERROR_121, true
	case 0xFA:
		return HVACHumidityError_CUSTOM_ERROR_122, true
	case 0xFB:
		return HVACHumidityError_CUSTOM_ERROR_123, true
	case 0xFC:
		return HVACHumidityError_CUSTOM_ERROR_124, true
	case 0xFD:
		return HVACHumidityError_CUSTOM_ERROR_125, true
	case 0xFE:
		return HVACHumidityError_CUSTOM_ERROR_126, true
	case 0xFF:
		return HVACHumidityError_CUSTOM_ERROR_127, true
	}
	return 0, false
}

func HVACHumidityErrorByName(value string) (enum HVACHumidityError, ok bool) {
	switch value {
	case "NO_ERROR":
		return HVACHumidityError_NO_ERROR, true
	case "HUMIDIFIER_TOTAL_FAILURE":
		return HVACHumidityError_HUMIDIFIER_TOTAL_FAILURE, true
	case "DEHUMIDIFIER_TOTAL_FAILURE":
		return HVACHumidityError_DEHUMIDIFIER_TOTAL_FAILURE, true
	case "FAN_TOTAL_FAILURE":
		return HVACHumidityError_FAN_TOTAL_FAILURE, true
	case "HUMIDITY_SENSOR_FAILURE":
		return HVACHumidityError_HUMIDITY_SENSOR_FAILURE, true
	case "HUMIDIFIER_TEMPORARY_PROBLEM":
		return HVACHumidityError_HUMIDIFIER_TEMPORARY_PROBLEM, true
	case "DEHUMIDIFIER_TEMPORARY_PROBLEM":
		return HVACHumidityError_DEHUMIDIFIER_TEMPORARY_PROBLEM, true
	case "FAN_TEMPORARY_PROBLEM":
		return HVACHumidityError_FAN_TEMPORARY_PROBLEM, true
	case "HUMIDIFIER_SERVICE_REQUIRED":
		return HVACHumidityError_HUMIDIFIER_SERVICE_REQUIRED, true
	case "DEHUMIDIFIER_SERVICE_REQUIRED":
		return HVACHumidityError_DEHUMIDIFIER_SERVICE_REQUIRED, true
	case "FAN_SERVICE_REQUIRED":
		return HVACHumidityError_FAN_SERVICE_REQUIRED, true
	case "FILTER_REPLACEMENT_REQUIRED":
		return HVACHumidityError_FILTER_REPLACEMENT_REQUIRED, true
	case "CUSTOM_ERROR_0":
		return HVACHumidityError_CUSTOM_ERROR_0, true
	case "CUSTOM_ERROR_1":
		return HVACHumidityError_CUSTOM_ERROR_1, true
	case "CUSTOM_ERROR_2":
		return HVACHumidityError_CUSTOM_ERROR_2, true
	case "CUSTOM_ERROR_3":
		return HVACHumidityError_CUSTOM_ERROR_3, true
	case "CUSTOM_ERROR_4":
		return HVACHumidityError_CUSTOM_ERROR_4, true
	case "CUSTOM_ERROR_5":
		return HVACHumidityError_CUSTOM_ERROR_5, true
	case "CUSTOM_ERROR_6":
		return HVACHumidityError_CUSTOM_ERROR_6, true
	case "CUSTOM_ERROR_7":
		return HVACHumidityError_CUSTOM_ERROR_7, true
	case "CUSTOM_ERROR_8":
		return HVACHumidityError_CUSTOM_ERROR_8, true
	case "CUSTOM_ERROR_9":
		return HVACHumidityError_CUSTOM_ERROR_9, true
	case "CUSTOM_ERROR_10":
		return HVACHumidityError_CUSTOM_ERROR_10, true
	case "CUSTOM_ERROR_11":
		return HVACHumidityError_CUSTOM_ERROR_11, true
	case "CUSTOM_ERROR_12":
		return HVACHumidityError_CUSTOM_ERROR_12, true
	case "CUSTOM_ERROR_13":
		return HVACHumidityError_CUSTOM_ERROR_13, true
	case "CUSTOM_ERROR_14":
		return HVACHumidityError_CUSTOM_ERROR_14, true
	case "CUSTOM_ERROR_15":
		return HVACHumidityError_CUSTOM_ERROR_15, true
	case "CUSTOM_ERROR_16":
		return HVACHumidityError_CUSTOM_ERROR_16, true
	case "CUSTOM_ERROR_17":
		return HVACHumidityError_CUSTOM_ERROR_17, true
	case "CUSTOM_ERROR_18":
		return HVACHumidityError_CUSTOM_ERROR_18, true
	case "CUSTOM_ERROR_19":
		return HVACHumidityError_CUSTOM_ERROR_19, true
	case "CUSTOM_ERROR_20":
		return HVACHumidityError_CUSTOM_ERROR_20, true
	case "CUSTOM_ERROR_21":
		return HVACHumidityError_CUSTOM_ERROR_21, true
	case "CUSTOM_ERROR_22":
		return HVACHumidityError_CUSTOM_ERROR_22, true
	case "CUSTOM_ERROR_23":
		return HVACHumidityError_CUSTOM_ERROR_23, true
	case "CUSTOM_ERROR_24":
		return HVACHumidityError_CUSTOM_ERROR_24, true
	case "CUSTOM_ERROR_25":
		return HVACHumidityError_CUSTOM_ERROR_25, true
	case "CUSTOM_ERROR_26":
		return HVACHumidityError_CUSTOM_ERROR_26, true
	case "CUSTOM_ERROR_27":
		return HVACHumidityError_CUSTOM_ERROR_27, true
	case "CUSTOM_ERROR_28":
		return HVACHumidityError_CUSTOM_ERROR_28, true
	case "CUSTOM_ERROR_29":
		return HVACHumidityError_CUSTOM_ERROR_29, true
	case "CUSTOM_ERROR_30":
		return HVACHumidityError_CUSTOM_ERROR_30, true
	case "CUSTOM_ERROR_31":
		return HVACHumidityError_CUSTOM_ERROR_31, true
	case "CUSTOM_ERROR_32":
		return HVACHumidityError_CUSTOM_ERROR_32, true
	case "CUSTOM_ERROR_33":
		return HVACHumidityError_CUSTOM_ERROR_33, true
	case "CUSTOM_ERROR_34":
		return HVACHumidityError_CUSTOM_ERROR_34, true
	case "CUSTOM_ERROR_35":
		return HVACHumidityError_CUSTOM_ERROR_35, true
	case "CUSTOM_ERROR_36":
		return HVACHumidityError_CUSTOM_ERROR_36, true
	case "CUSTOM_ERROR_37":
		return HVACHumidityError_CUSTOM_ERROR_37, true
	case "CUSTOM_ERROR_38":
		return HVACHumidityError_CUSTOM_ERROR_38, true
	case "CUSTOM_ERROR_39":
		return HVACHumidityError_CUSTOM_ERROR_39, true
	case "CUSTOM_ERROR_40":
		return HVACHumidityError_CUSTOM_ERROR_40, true
	case "CUSTOM_ERROR_41":
		return HVACHumidityError_CUSTOM_ERROR_41, true
	case "CUSTOM_ERROR_42":
		return HVACHumidityError_CUSTOM_ERROR_42, true
	case "CUSTOM_ERROR_43":
		return HVACHumidityError_CUSTOM_ERROR_43, true
	case "CUSTOM_ERROR_44":
		return HVACHumidityError_CUSTOM_ERROR_44, true
	case "CUSTOM_ERROR_45":
		return HVACHumidityError_CUSTOM_ERROR_45, true
	case "CUSTOM_ERROR_46":
		return HVACHumidityError_CUSTOM_ERROR_46, true
	case "CUSTOM_ERROR_47":
		return HVACHumidityError_CUSTOM_ERROR_47, true
	case "CUSTOM_ERROR_48":
		return HVACHumidityError_CUSTOM_ERROR_48, true
	case "CUSTOM_ERROR_49":
		return HVACHumidityError_CUSTOM_ERROR_49, true
	case "CUSTOM_ERROR_50":
		return HVACHumidityError_CUSTOM_ERROR_50, true
	case "CUSTOM_ERROR_51":
		return HVACHumidityError_CUSTOM_ERROR_51, true
	case "CUSTOM_ERROR_52":
		return HVACHumidityError_CUSTOM_ERROR_52, true
	case "CUSTOM_ERROR_53":
		return HVACHumidityError_CUSTOM_ERROR_53, true
	case "CUSTOM_ERROR_54":
		return HVACHumidityError_CUSTOM_ERROR_54, true
	case "CUSTOM_ERROR_55":
		return HVACHumidityError_CUSTOM_ERROR_55, true
	case "CUSTOM_ERROR_56":
		return HVACHumidityError_CUSTOM_ERROR_56, true
	case "CUSTOM_ERROR_57":
		return HVACHumidityError_CUSTOM_ERROR_57, true
	case "CUSTOM_ERROR_58":
		return HVACHumidityError_CUSTOM_ERROR_58, true
	case "CUSTOM_ERROR_59":
		return HVACHumidityError_CUSTOM_ERROR_59, true
	case "CUSTOM_ERROR_60":
		return HVACHumidityError_CUSTOM_ERROR_60, true
	case "CUSTOM_ERROR_61":
		return HVACHumidityError_CUSTOM_ERROR_61, true
	case "CUSTOM_ERROR_62":
		return HVACHumidityError_CUSTOM_ERROR_62, true
	case "CUSTOM_ERROR_63":
		return HVACHumidityError_CUSTOM_ERROR_63, true
	case "CUSTOM_ERROR_64":
		return HVACHumidityError_CUSTOM_ERROR_64, true
	case "CUSTOM_ERROR_65":
		return HVACHumidityError_CUSTOM_ERROR_65, true
	case "CUSTOM_ERROR_66":
		return HVACHumidityError_CUSTOM_ERROR_66, true
	case "CUSTOM_ERROR_67":
		return HVACHumidityError_CUSTOM_ERROR_67, true
	case "CUSTOM_ERROR_68":
		return HVACHumidityError_CUSTOM_ERROR_68, true
	case "CUSTOM_ERROR_69":
		return HVACHumidityError_CUSTOM_ERROR_69, true
	case "CUSTOM_ERROR_70":
		return HVACHumidityError_CUSTOM_ERROR_70, true
	case "CUSTOM_ERROR_71":
		return HVACHumidityError_CUSTOM_ERROR_71, true
	case "CUSTOM_ERROR_72":
		return HVACHumidityError_CUSTOM_ERROR_72, true
	case "CUSTOM_ERROR_73":
		return HVACHumidityError_CUSTOM_ERROR_73, true
	case "CUSTOM_ERROR_74":
		return HVACHumidityError_CUSTOM_ERROR_74, true
	case "CUSTOM_ERROR_75":
		return HVACHumidityError_CUSTOM_ERROR_75, true
	case "CUSTOM_ERROR_76":
		return HVACHumidityError_CUSTOM_ERROR_76, true
	case "CUSTOM_ERROR_77":
		return HVACHumidityError_CUSTOM_ERROR_77, true
	case "CUSTOM_ERROR_78":
		return HVACHumidityError_CUSTOM_ERROR_78, true
	case "CUSTOM_ERROR_79":
		return HVACHumidityError_CUSTOM_ERROR_79, true
	case "CUSTOM_ERROR_80":
		return HVACHumidityError_CUSTOM_ERROR_80, true
	case "CUSTOM_ERROR_81":
		return HVACHumidityError_CUSTOM_ERROR_81, true
	case "CUSTOM_ERROR_82":
		return HVACHumidityError_CUSTOM_ERROR_82, true
	case "CUSTOM_ERROR_83":
		return HVACHumidityError_CUSTOM_ERROR_83, true
	case "CUSTOM_ERROR_84":
		return HVACHumidityError_CUSTOM_ERROR_84, true
	case "CUSTOM_ERROR_85":
		return HVACHumidityError_CUSTOM_ERROR_85, true
	case "CUSTOM_ERROR_86":
		return HVACHumidityError_CUSTOM_ERROR_86, true
	case "CUSTOM_ERROR_87":
		return HVACHumidityError_CUSTOM_ERROR_87, true
	case "CUSTOM_ERROR_88":
		return HVACHumidityError_CUSTOM_ERROR_88, true
	case "CUSTOM_ERROR_89":
		return HVACHumidityError_CUSTOM_ERROR_89, true
	case "CUSTOM_ERROR_90":
		return HVACHumidityError_CUSTOM_ERROR_90, true
	case "CUSTOM_ERROR_91":
		return HVACHumidityError_CUSTOM_ERROR_91, true
	case "CUSTOM_ERROR_92":
		return HVACHumidityError_CUSTOM_ERROR_92, true
	case "CUSTOM_ERROR_93":
		return HVACHumidityError_CUSTOM_ERROR_93, true
	case "CUSTOM_ERROR_94":
		return HVACHumidityError_CUSTOM_ERROR_94, true
	case "CUSTOM_ERROR_95":
		return HVACHumidityError_CUSTOM_ERROR_95, true
	case "CUSTOM_ERROR_96":
		return HVACHumidityError_CUSTOM_ERROR_96, true
	case "CUSTOM_ERROR_97":
		return HVACHumidityError_CUSTOM_ERROR_97, true
	case "CUSTOM_ERROR_98":
		return HVACHumidityError_CUSTOM_ERROR_98, true
	case "CUSTOM_ERROR_99":
		return HVACHumidityError_CUSTOM_ERROR_99, true
	case "CUSTOM_ERROR_100":
		return HVACHumidityError_CUSTOM_ERROR_100, true
	case "CUSTOM_ERROR_101":
		return HVACHumidityError_CUSTOM_ERROR_101, true
	case "CUSTOM_ERROR_102":
		return HVACHumidityError_CUSTOM_ERROR_102, true
	case "CUSTOM_ERROR_103":
		return HVACHumidityError_CUSTOM_ERROR_103, true
	case "CUSTOM_ERROR_104":
		return HVACHumidityError_CUSTOM_ERROR_104, true
	case "CUSTOM_ERROR_105":
		return HVACHumidityError_CUSTOM_ERROR_105, true
	case "CUSTOM_ERROR_106":
		return HVACHumidityError_CUSTOM_ERROR_106, true
	case "CUSTOM_ERROR_107":
		return HVACHumidityError_CUSTOM_ERROR_107, true
	case "CUSTOM_ERROR_108":
		return HVACHumidityError_CUSTOM_ERROR_108, true
	case "CUSTOM_ERROR_109":
		return HVACHumidityError_CUSTOM_ERROR_109, true
	case "CUSTOM_ERROR_110":
		return HVACHumidityError_CUSTOM_ERROR_110, true
	case "CUSTOM_ERROR_111":
		return HVACHumidityError_CUSTOM_ERROR_111, true
	case "CUSTOM_ERROR_112":
		return HVACHumidityError_CUSTOM_ERROR_112, true
	case "CUSTOM_ERROR_113":
		return HVACHumidityError_CUSTOM_ERROR_113, true
	case "CUSTOM_ERROR_114":
		return HVACHumidityError_CUSTOM_ERROR_114, true
	case "CUSTOM_ERROR_115":
		return HVACHumidityError_CUSTOM_ERROR_115, true
	case "CUSTOM_ERROR_116":
		return HVACHumidityError_CUSTOM_ERROR_116, true
	case "CUSTOM_ERROR_117":
		return HVACHumidityError_CUSTOM_ERROR_117, true
	case "CUSTOM_ERROR_118":
		return HVACHumidityError_CUSTOM_ERROR_118, true
	case "CUSTOM_ERROR_119":
		return HVACHumidityError_CUSTOM_ERROR_119, true
	case "CUSTOM_ERROR_120":
		return HVACHumidityError_CUSTOM_ERROR_120, true
	case "CUSTOM_ERROR_121":
		return HVACHumidityError_CUSTOM_ERROR_121, true
	case "CUSTOM_ERROR_122":
		return HVACHumidityError_CUSTOM_ERROR_122, true
	case "CUSTOM_ERROR_123":
		return HVACHumidityError_CUSTOM_ERROR_123, true
	case "CUSTOM_ERROR_124":
		return HVACHumidityError_CUSTOM_ERROR_124, true
	case "CUSTOM_ERROR_125":
		return HVACHumidityError_CUSTOM_ERROR_125, true
	case "CUSTOM_ERROR_126":
		return HVACHumidityError_CUSTOM_ERROR_126, true
	case "CUSTOM_ERROR_127":
		return HVACHumidityError_CUSTOM_ERROR_127, true
	}
	return 0, false
}

func HVACHumidityErrorKnows(value uint8) bool {
	for _, typeValue := range HVACHumidityErrorValues {
		if uint8(typeValue) == value {
			return true
		}
	}
	return false
}

func CastHVACHumidityError(structType any) HVACHumidityError {
	castFunc := func(typ any) HVACHumidityError {
		if sHVACHumidityError, ok := typ.(HVACHumidityError); ok {
			return sHVACHumidityError
		}
		return 0
	}
	return castFunc(structType)
}

func (m HVACHumidityError) GetLengthInBits(ctx context.Context) uint16 {
	return 8
}

func (m HVACHumidityError) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func HVACHumidityErrorParse(ctx context.Context, theBytes []byte) (HVACHumidityError, error) {
	return HVACHumidityErrorParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func HVACHumidityErrorParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (HVACHumidityError, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadUint8("HVACHumidityError", 8)
	if err != nil {
		return 0, errors.Wrap(err, "error reading HVACHumidityError")
	}
	if enum, ok := HVACHumidityErrorByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for HVACHumidityError")
		return HVACHumidityError(val), nil
	} else {
		return enum, nil
	}
}

func (e HVACHumidityError) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e HVACHumidityError) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteUint8("HVACHumidityError", 8, uint8(uint8(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e HVACHumidityError) PLC4XEnumName() string {
	switch e {
	case HVACHumidityError_NO_ERROR:
		return "NO_ERROR"
	case HVACHumidityError_HUMIDIFIER_TOTAL_FAILURE:
		return "HUMIDIFIER_TOTAL_FAILURE"
	case HVACHumidityError_DEHUMIDIFIER_TOTAL_FAILURE:
		return "DEHUMIDIFIER_TOTAL_FAILURE"
	case HVACHumidityError_FAN_TOTAL_FAILURE:
		return "FAN_TOTAL_FAILURE"
	case HVACHumidityError_HUMIDITY_SENSOR_FAILURE:
		return "HUMIDITY_SENSOR_FAILURE"
	case HVACHumidityError_HUMIDIFIER_TEMPORARY_PROBLEM:
		return "HUMIDIFIER_TEMPORARY_PROBLEM"
	case HVACHumidityError_DEHUMIDIFIER_TEMPORARY_PROBLEM:
		return "DEHUMIDIFIER_TEMPORARY_PROBLEM"
	case HVACHumidityError_FAN_TEMPORARY_PROBLEM:
		return "FAN_TEMPORARY_PROBLEM"
	case HVACHumidityError_HUMIDIFIER_SERVICE_REQUIRED:
		return "HUMIDIFIER_SERVICE_REQUIRED"
	case HVACHumidityError_DEHUMIDIFIER_SERVICE_REQUIRED:
		return "DEHUMIDIFIER_SERVICE_REQUIRED"
	case HVACHumidityError_FAN_SERVICE_REQUIRED:
		return "FAN_SERVICE_REQUIRED"
	case HVACHumidityError_FILTER_REPLACEMENT_REQUIRED:
		return "FILTER_REPLACEMENT_REQUIRED"
	case HVACHumidityError_CUSTOM_ERROR_0:
		return "CUSTOM_ERROR_0"
	case HVACHumidityError_CUSTOM_ERROR_1:
		return "CUSTOM_ERROR_1"
	case HVACHumidityError_CUSTOM_ERROR_2:
		return "CUSTOM_ERROR_2"
	case HVACHumidityError_CUSTOM_ERROR_3:
		return "CUSTOM_ERROR_3"
	case HVACHumidityError_CUSTOM_ERROR_4:
		return "CUSTOM_ERROR_4"
	case HVACHumidityError_CUSTOM_ERROR_5:
		return "CUSTOM_ERROR_5"
	case HVACHumidityError_CUSTOM_ERROR_6:
		return "CUSTOM_ERROR_6"
	case HVACHumidityError_CUSTOM_ERROR_7:
		return "CUSTOM_ERROR_7"
	case HVACHumidityError_CUSTOM_ERROR_8:
		return "CUSTOM_ERROR_8"
	case HVACHumidityError_CUSTOM_ERROR_9:
		return "CUSTOM_ERROR_9"
	case HVACHumidityError_CUSTOM_ERROR_10:
		return "CUSTOM_ERROR_10"
	case HVACHumidityError_CUSTOM_ERROR_11:
		return "CUSTOM_ERROR_11"
	case HVACHumidityError_CUSTOM_ERROR_12:
		return "CUSTOM_ERROR_12"
	case HVACHumidityError_CUSTOM_ERROR_13:
		return "CUSTOM_ERROR_13"
	case HVACHumidityError_CUSTOM_ERROR_14:
		return "CUSTOM_ERROR_14"
	case HVACHumidityError_CUSTOM_ERROR_15:
		return "CUSTOM_ERROR_15"
	case HVACHumidityError_CUSTOM_ERROR_16:
		return "CUSTOM_ERROR_16"
	case HVACHumidityError_CUSTOM_ERROR_17:
		return "CUSTOM_ERROR_17"
	case HVACHumidityError_CUSTOM_ERROR_18:
		return "CUSTOM_ERROR_18"
	case HVACHumidityError_CUSTOM_ERROR_19:
		return "CUSTOM_ERROR_19"
	case HVACHumidityError_CUSTOM_ERROR_20:
		return "CUSTOM_ERROR_20"
	case HVACHumidityError_CUSTOM_ERROR_21:
		return "CUSTOM_ERROR_21"
	case HVACHumidityError_CUSTOM_ERROR_22:
		return "CUSTOM_ERROR_22"
	case HVACHumidityError_CUSTOM_ERROR_23:
		return "CUSTOM_ERROR_23"
	case HVACHumidityError_CUSTOM_ERROR_24:
		return "CUSTOM_ERROR_24"
	case HVACHumidityError_CUSTOM_ERROR_25:
		return "CUSTOM_ERROR_25"
	case HVACHumidityError_CUSTOM_ERROR_26:
		return "CUSTOM_ERROR_26"
	case HVACHumidityError_CUSTOM_ERROR_27:
		return "CUSTOM_ERROR_27"
	case HVACHumidityError_CUSTOM_ERROR_28:
		return "CUSTOM_ERROR_28"
	case HVACHumidityError_CUSTOM_ERROR_29:
		return "CUSTOM_ERROR_29"
	case HVACHumidityError_CUSTOM_ERROR_30:
		return "CUSTOM_ERROR_30"
	case HVACHumidityError_CUSTOM_ERROR_31:
		return "CUSTOM_ERROR_31"
	case HVACHumidityError_CUSTOM_ERROR_32:
		return "CUSTOM_ERROR_32"
	case HVACHumidityError_CUSTOM_ERROR_33:
		return "CUSTOM_ERROR_33"
	case HVACHumidityError_CUSTOM_ERROR_34:
		return "CUSTOM_ERROR_34"
	case HVACHumidityError_CUSTOM_ERROR_35:
		return "CUSTOM_ERROR_35"
	case HVACHumidityError_CUSTOM_ERROR_36:
		return "CUSTOM_ERROR_36"
	case HVACHumidityError_CUSTOM_ERROR_37:
		return "CUSTOM_ERROR_37"
	case HVACHumidityError_CUSTOM_ERROR_38:
		return "CUSTOM_ERROR_38"
	case HVACHumidityError_CUSTOM_ERROR_39:
		return "CUSTOM_ERROR_39"
	case HVACHumidityError_CUSTOM_ERROR_40:
		return "CUSTOM_ERROR_40"
	case HVACHumidityError_CUSTOM_ERROR_41:
		return "CUSTOM_ERROR_41"
	case HVACHumidityError_CUSTOM_ERROR_42:
		return "CUSTOM_ERROR_42"
	case HVACHumidityError_CUSTOM_ERROR_43:
		return "CUSTOM_ERROR_43"
	case HVACHumidityError_CUSTOM_ERROR_44:
		return "CUSTOM_ERROR_44"
	case HVACHumidityError_CUSTOM_ERROR_45:
		return "CUSTOM_ERROR_45"
	case HVACHumidityError_CUSTOM_ERROR_46:
		return "CUSTOM_ERROR_46"
	case HVACHumidityError_CUSTOM_ERROR_47:
		return "CUSTOM_ERROR_47"
	case HVACHumidityError_CUSTOM_ERROR_48:
		return "CUSTOM_ERROR_48"
	case HVACHumidityError_CUSTOM_ERROR_49:
		return "CUSTOM_ERROR_49"
	case HVACHumidityError_CUSTOM_ERROR_50:
		return "CUSTOM_ERROR_50"
	case HVACHumidityError_CUSTOM_ERROR_51:
		return "CUSTOM_ERROR_51"
	case HVACHumidityError_CUSTOM_ERROR_52:
		return "CUSTOM_ERROR_52"
	case HVACHumidityError_CUSTOM_ERROR_53:
		return "CUSTOM_ERROR_53"
	case HVACHumidityError_CUSTOM_ERROR_54:
		return "CUSTOM_ERROR_54"
	case HVACHumidityError_CUSTOM_ERROR_55:
		return "CUSTOM_ERROR_55"
	case HVACHumidityError_CUSTOM_ERROR_56:
		return "CUSTOM_ERROR_56"
	case HVACHumidityError_CUSTOM_ERROR_57:
		return "CUSTOM_ERROR_57"
	case HVACHumidityError_CUSTOM_ERROR_58:
		return "CUSTOM_ERROR_58"
	case HVACHumidityError_CUSTOM_ERROR_59:
		return "CUSTOM_ERROR_59"
	case HVACHumidityError_CUSTOM_ERROR_60:
		return "CUSTOM_ERROR_60"
	case HVACHumidityError_CUSTOM_ERROR_61:
		return "CUSTOM_ERROR_61"
	case HVACHumidityError_CUSTOM_ERROR_62:
		return "CUSTOM_ERROR_62"
	case HVACHumidityError_CUSTOM_ERROR_63:
		return "CUSTOM_ERROR_63"
	case HVACHumidityError_CUSTOM_ERROR_64:
		return "CUSTOM_ERROR_64"
	case HVACHumidityError_CUSTOM_ERROR_65:
		return "CUSTOM_ERROR_65"
	case HVACHumidityError_CUSTOM_ERROR_66:
		return "CUSTOM_ERROR_66"
	case HVACHumidityError_CUSTOM_ERROR_67:
		return "CUSTOM_ERROR_67"
	case HVACHumidityError_CUSTOM_ERROR_68:
		return "CUSTOM_ERROR_68"
	case HVACHumidityError_CUSTOM_ERROR_69:
		return "CUSTOM_ERROR_69"
	case HVACHumidityError_CUSTOM_ERROR_70:
		return "CUSTOM_ERROR_70"
	case HVACHumidityError_CUSTOM_ERROR_71:
		return "CUSTOM_ERROR_71"
	case HVACHumidityError_CUSTOM_ERROR_72:
		return "CUSTOM_ERROR_72"
	case HVACHumidityError_CUSTOM_ERROR_73:
		return "CUSTOM_ERROR_73"
	case HVACHumidityError_CUSTOM_ERROR_74:
		return "CUSTOM_ERROR_74"
	case HVACHumidityError_CUSTOM_ERROR_75:
		return "CUSTOM_ERROR_75"
	case HVACHumidityError_CUSTOM_ERROR_76:
		return "CUSTOM_ERROR_76"
	case HVACHumidityError_CUSTOM_ERROR_77:
		return "CUSTOM_ERROR_77"
	case HVACHumidityError_CUSTOM_ERROR_78:
		return "CUSTOM_ERROR_78"
	case HVACHumidityError_CUSTOM_ERROR_79:
		return "CUSTOM_ERROR_79"
	case HVACHumidityError_CUSTOM_ERROR_80:
		return "CUSTOM_ERROR_80"
	case HVACHumidityError_CUSTOM_ERROR_81:
		return "CUSTOM_ERROR_81"
	case HVACHumidityError_CUSTOM_ERROR_82:
		return "CUSTOM_ERROR_82"
	case HVACHumidityError_CUSTOM_ERROR_83:
		return "CUSTOM_ERROR_83"
	case HVACHumidityError_CUSTOM_ERROR_84:
		return "CUSTOM_ERROR_84"
	case HVACHumidityError_CUSTOM_ERROR_85:
		return "CUSTOM_ERROR_85"
	case HVACHumidityError_CUSTOM_ERROR_86:
		return "CUSTOM_ERROR_86"
	case HVACHumidityError_CUSTOM_ERROR_87:
		return "CUSTOM_ERROR_87"
	case HVACHumidityError_CUSTOM_ERROR_88:
		return "CUSTOM_ERROR_88"
	case HVACHumidityError_CUSTOM_ERROR_89:
		return "CUSTOM_ERROR_89"
	case HVACHumidityError_CUSTOM_ERROR_90:
		return "CUSTOM_ERROR_90"
	case HVACHumidityError_CUSTOM_ERROR_91:
		return "CUSTOM_ERROR_91"
	case HVACHumidityError_CUSTOM_ERROR_92:
		return "CUSTOM_ERROR_92"
	case HVACHumidityError_CUSTOM_ERROR_93:
		return "CUSTOM_ERROR_93"
	case HVACHumidityError_CUSTOM_ERROR_94:
		return "CUSTOM_ERROR_94"
	case HVACHumidityError_CUSTOM_ERROR_95:
		return "CUSTOM_ERROR_95"
	case HVACHumidityError_CUSTOM_ERROR_96:
		return "CUSTOM_ERROR_96"
	case HVACHumidityError_CUSTOM_ERROR_97:
		return "CUSTOM_ERROR_97"
	case HVACHumidityError_CUSTOM_ERROR_98:
		return "CUSTOM_ERROR_98"
	case HVACHumidityError_CUSTOM_ERROR_99:
		return "CUSTOM_ERROR_99"
	case HVACHumidityError_CUSTOM_ERROR_100:
		return "CUSTOM_ERROR_100"
	case HVACHumidityError_CUSTOM_ERROR_101:
		return "CUSTOM_ERROR_101"
	case HVACHumidityError_CUSTOM_ERROR_102:
		return "CUSTOM_ERROR_102"
	case HVACHumidityError_CUSTOM_ERROR_103:
		return "CUSTOM_ERROR_103"
	case HVACHumidityError_CUSTOM_ERROR_104:
		return "CUSTOM_ERROR_104"
	case HVACHumidityError_CUSTOM_ERROR_105:
		return "CUSTOM_ERROR_105"
	case HVACHumidityError_CUSTOM_ERROR_106:
		return "CUSTOM_ERROR_106"
	case HVACHumidityError_CUSTOM_ERROR_107:
		return "CUSTOM_ERROR_107"
	case HVACHumidityError_CUSTOM_ERROR_108:
		return "CUSTOM_ERROR_108"
	case HVACHumidityError_CUSTOM_ERROR_109:
		return "CUSTOM_ERROR_109"
	case HVACHumidityError_CUSTOM_ERROR_110:
		return "CUSTOM_ERROR_110"
	case HVACHumidityError_CUSTOM_ERROR_111:
		return "CUSTOM_ERROR_111"
	case HVACHumidityError_CUSTOM_ERROR_112:
		return "CUSTOM_ERROR_112"
	case HVACHumidityError_CUSTOM_ERROR_113:
		return "CUSTOM_ERROR_113"
	case HVACHumidityError_CUSTOM_ERROR_114:
		return "CUSTOM_ERROR_114"
	case HVACHumidityError_CUSTOM_ERROR_115:
		return "CUSTOM_ERROR_115"
	case HVACHumidityError_CUSTOM_ERROR_116:
		return "CUSTOM_ERROR_116"
	case HVACHumidityError_CUSTOM_ERROR_117:
		return "CUSTOM_ERROR_117"
	case HVACHumidityError_CUSTOM_ERROR_118:
		return "CUSTOM_ERROR_118"
	case HVACHumidityError_CUSTOM_ERROR_119:
		return "CUSTOM_ERROR_119"
	case HVACHumidityError_CUSTOM_ERROR_120:
		return "CUSTOM_ERROR_120"
	case HVACHumidityError_CUSTOM_ERROR_121:
		return "CUSTOM_ERROR_121"
	case HVACHumidityError_CUSTOM_ERROR_122:
		return "CUSTOM_ERROR_122"
	case HVACHumidityError_CUSTOM_ERROR_123:
		return "CUSTOM_ERROR_123"
	case HVACHumidityError_CUSTOM_ERROR_124:
		return "CUSTOM_ERROR_124"
	case HVACHumidityError_CUSTOM_ERROR_125:
		return "CUSTOM_ERROR_125"
	case HVACHumidityError_CUSTOM_ERROR_126:
		return "CUSTOM_ERROR_126"
	case HVACHumidityError_CUSTOM_ERROR_127:
		return "CUSTOM_ERROR_127"
	}
	return fmt.Sprintf("Unknown(%v)", uint8(e))
}

func (e HVACHumidityError) String() string {
	return e.PLC4XEnumName()
}
