/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// HVACError is an enum
type HVACError uint8

type IHVACError interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	HVACError_NO_ERROR                    HVACError = 0x00
	HVACError_HEATER_TOTAL_FAILURE        HVACError = 0x01
	HVACError_COOLER_TOTAL_FAILURE        HVACError = 0x02
	HVACError_FAN_TOTAL_FAILURE           HVACError = 0x03
	HVACError_TEMPERATURE_SENSOR_FAILURE  HVACError = 0x04
	HVACError_HEATER_TEMPORARY_PROBLEM    HVACError = 0x05
	HVACError_COOLER_TEMPORARY_PROBLEM    HVACError = 0x06
	HVACError_FAN_TEMPORARY_PROBLEM       HVACError = 0x07
	HVACError_HEATER_SERVICE_REQUIRED     HVACError = 0x08
	HVACError_COOLER_SERVICE_REQUIRED     HVACError = 0x09
	HVACError_FAN_SERVICE_REQUIRED        HVACError = 0x0A
	HVACError_FILTER_REPLACEMENT_REQUIRED HVACError = 0x0B
	HVACError_CUSTOM_ERROR_0              HVACError = 0x80
	HVACError_CUSTOM_ERROR_1              HVACError = 0x81
	HVACError_CUSTOM_ERROR_2              HVACError = 0x82
	HVACError_CUSTOM_ERROR_3              HVACError = 0x83
	HVACError_CUSTOM_ERROR_4              HVACError = 0x84
	HVACError_CUSTOM_ERROR_5              HVACError = 0x85
	HVACError_CUSTOM_ERROR_6              HVACError = 0x86
	HVACError_CUSTOM_ERROR_7              HVACError = 0x87
	HVACError_CUSTOM_ERROR_8              HVACError = 0x88
	HVACError_CUSTOM_ERROR_9              HVACError = 0x89
	HVACError_CUSTOM_ERROR_10             HVACError = 0x8A
	HVACError_CUSTOM_ERROR_11             HVACError = 0x8B
	HVACError_CUSTOM_ERROR_12             HVACError = 0x8C
	HVACError_CUSTOM_ERROR_13             HVACError = 0x8D
	HVACError_CUSTOM_ERROR_14             HVACError = 0x8E
	HVACError_CUSTOM_ERROR_15             HVACError = 0x8F
	HVACError_CUSTOM_ERROR_16             HVACError = 0x90
	HVACError_CUSTOM_ERROR_17             HVACError = 0x91
	HVACError_CUSTOM_ERROR_18             HVACError = 0x92
	HVACError_CUSTOM_ERROR_19             HVACError = 0x93
	HVACError_CUSTOM_ERROR_20             HVACError = 0x94
	HVACError_CUSTOM_ERROR_21             HVACError = 0x95
	HVACError_CUSTOM_ERROR_22             HVACError = 0x96
	HVACError_CUSTOM_ERROR_23             HVACError = 0x97
	HVACError_CUSTOM_ERROR_24             HVACError = 0x98
	HVACError_CUSTOM_ERROR_25             HVACError = 0x99
	HVACError_CUSTOM_ERROR_26             HVACError = 0x9A
	HVACError_CUSTOM_ERROR_27             HVACError = 0x9B
	HVACError_CUSTOM_ERROR_28             HVACError = 0x9C
	HVACError_CUSTOM_ERROR_29             HVACError = 0x9D
	HVACError_CUSTOM_ERROR_30             HVACError = 0x9E
	HVACError_CUSTOM_ERROR_31             HVACError = 0x9F
	HVACError_CUSTOM_ERROR_32             HVACError = 0xA0
	HVACError_CUSTOM_ERROR_33             HVACError = 0xA1
	HVACError_CUSTOM_ERROR_34             HVACError = 0xA2
	HVACError_CUSTOM_ERROR_35             HVACError = 0xA3
	HVACError_CUSTOM_ERROR_36             HVACError = 0xA4
	HVACError_CUSTOM_ERROR_37             HVACError = 0xA5
	HVACError_CUSTOM_ERROR_38             HVACError = 0xA6
	HVACError_CUSTOM_ERROR_39             HVACError = 0xA7
	HVACError_CUSTOM_ERROR_40             HVACError = 0xA8
	HVACError_CUSTOM_ERROR_41             HVACError = 0xA9
	HVACError_CUSTOM_ERROR_42             HVACError = 0xAA
	HVACError_CUSTOM_ERROR_43             HVACError = 0xAB
	HVACError_CUSTOM_ERROR_44             HVACError = 0xAC
	HVACError_CUSTOM_ERROR_45             HVACError = 0xAD
	HVACError_CUSTOM_ERROR_46             HVACError = 0xAE
	HVACError_CUSTOM_ERROR_47             HVACError = 0xAF
	HVACError_CUSTOM_ERROR_48             HVACError = 0xB0
	HVACError_CUSTOM_ERROR_49             HVACError = 0xB1
	HVACError_CUSTOM_ERROR_50             HVACError = 0xB2
	HVACError_CUSTOM_ERROR_51             HVACError = 0xB3
	HVACError_CUSTOM_ERROR_52             HVACError = 0xB4
	HVACError_CUSTOM_ERROR_53             HVACError = 0xB5
	HVACError_CUSTOM_ERROR_54             HVACError = 0xB6
	HVACError_CUSTOM_ERROR_55             HVACError = 0xB7
	HVACError_CUSTOM_ERROR_56             HVACError = 0xB8
	HVACError_CUSTOM_ERROR_57             HVACError = 0xB9
	HVACError_CUSTOM_ERROR_58             HVACError = 0xBA
	HVACError_CUSTOM_ERROR_59             HVACError = 0xBB
	HVACError_CUSTOM_ERROR_60             HVACError = 0xBC
	HVACError_CUSTOM_ERROR_61             HVACError = 0xBD
	HVACError_CUSTOM_ERROR_62             HVACError = 0xBE
	HVACError_CUSTOM_ERROR_63             HVACError = 0xBF
	HVACError_CUSTOM_ERROR_64             HVACError = 0xC0
	HVACError_CUSTOM_ERROR_65             HVACError = 0xC1
	HVACError_CUSTOM_ERROR_66             HVACError = 0xC2
	HVACError_CUSTOM_ERROR_67             HVACError = 0xC3
	HVACError_CUSTOM_ERROR_68             HVACError = 0xC4
	HVACError_CUSTOM_ERROR_69             HVACError = 0xC5
	HVACError_CUSTOM_ERROR_70             HVACError = 0xC6
	HVACError_CUSTOM_ERROR_71             HVACError = 0xC7
	HVACError_CUSTOM_ERROR_72             HVACError = 0xC8
	HVACError_CUSTOM_ERROR_73             HVACError = 0xC9
	HVACError_CUSTOM_ERROR_74             HVACError = 0xCA
	HVACError_CUSTOM_ERROR_75             HVACError = 0xCB
	HVACError_CUSTOM_ERROR_76             HVACError = 0xCC
	HVACError_CUSTOM_ERROR_77             HVACError = 0xCD
	HVACError_CUSTOM_ERROR_78             HVACError = 0xCE
	HVACError_CUSTOM_ERROR_79             HVACError = 0xCF
	HVACError_CUSTOM_ERROR_80             HVACError = 0xD0
	HVACError_CUSTOM_ERROR_81             HVACError = 0xD1
	HVACError_CUSTOM_ERROR_82             HVACError = 0xD2
	HVACError_CUSTOM_ERROR_83             HVACError = 0xD3
	HVACError_CUSTOM_ERROR_84             HVACError = 0xD4
	HVACError_CUSTOM_ERROR_85             HVACError = 0xD5
	HVACError_CUSTOM_ERROR_86             HVACError = 0xD6
	HVACError_CUSTOM_ERROR_87             HVACError = 0xD7
	HVACError_CUSTOM_ERROR_88             HVACError = 0xD8
	HVACError_CUSTOM_ERROR_89             HVACError = 0xD9
	HVACError_CUSTOM_ERROR_90             HVACError = 0xDA
	HVACError_CUSTOM_ERROR_91             HVACError = 0xDB
	HVACError_CUSTOM_ERROR_92             HVACError = 0xDC
	HVACError_CUSTOM_ERROR_93             HVACError = 0xDD
	HVACError_CUSTOM_ERROR_94             HVACError = 0xDE
	HVACError_CUSTOM_ERROR_95             HVACError = 0xDF
	HVACError_CUSTOM_ERROR_96             HVACError = 0xE0
	HVACError_CUSTOM_ERROR_97             HVACError = 0xE1
	HVACError_CUSTOM_ERROR_98             HVACError = 0xE2
	HVACError_CUSTOM_ERROR_99             HVACError = 0xE3
	HVACError_CUSTOM_ERROR_100            HVACError = 0xE4
	HVACError_CUSTOM_ERROR_101            HVACError = 0xE5
	HVACError_CUSTOM_ERROR_102            HVACError = 0xE6
	HVACError_CUSTOM_ERROR_103            HVACError = 0xE7
	HVACError_CUSTOM_ERROR_104            HVACError = 0xE8
	HVACError_CUSTOM_ERROR_105            HVACError = 0xE9
	HVACError_CUSTOM_ERROR_106            HVACError = 0xEA
	HVACError_CUSTOM_ERROR_107            HVACError = 0xEB
	HVACError_CUSTOM_ERROR_108            HVACError = 0xEC
	HVACError_CUSTOM_ERROR_109            HVACError = 0xED
	HVACError_CUSTOM_ERROR_110            HVACError = 0xEE
	HVACError_CUSTOM_ERROR_111            HVACError = 0xEF
	HVACError_CUSTOM_ERROR_112            HVACError = 0xF0
	HVACError_CUSTOM_ERROR_113            HVACError = 0xF1
	HVACError_CUSTOM_ERROR_114            HVACError = 0xF2
	HVACError_CUSTOM_ERROR_115            HVACError = 0xF3
	HVACError_CUSTOM_ERROR_116            HVACError = 0xF4
	HVACError_CUSTOM_ERROR_117            HVACError = 0xF5
	HVACError_CUSTOM_ERROR_118            HVACError = 0xF6
	HVACError_CUSTOM_ERROR_119            HVACError = 0xF7
	HVACError_CUSTOM_ERROR_120            HVACError = 0xF8
	HVACError_CUSTOM_ERROR_121            HVACError = 0xF9
	HVACError_CUSTOM_ERROR_122            HVACError = 0xFA
	HVACError_CUSTOM_ERROR_123            HVACError = 0xFB
	HVACError_CUSTOM_ERROR_124            HVACError = 0xFC
	HVACError_CUSTOM_ERROR_125            HVACError = 0xFD
	HVACError_CUSTOM_ERROR_126            HVACError = 0xFE
	HVACError_CUSTOM_ERROR_127            HVACError = 0xFF
)

var HVACErrorValues []HVACError

func init() {
	_ = errors.New
	HVACErrorValues = []HVACError{
		HVACError_NO_ERROR,
		HVACError_HEATER_TOTAL_FAILURE,
		HVACError_COOLER_TOTAL_FAILURE,
		HVACError_FAN_TOTAL_FAILURE,
		HVACError_TEMPERATURE_SENSOR_FAILURE,
		HVACError_HEATER_TEMPORARY_PROBLEM,
		HVACError_COOLER_TEMPORARY_PROBLEM,
		HVACError_FAN_TEMPORARY_PROBLEM,
		HVACError_HEATER_SERVICE_REQUIRED,
		HVACError_COOLER_SERVICE_REQUIRED,
		HVACError_FAN_SERVICE_REQUIRED,
		HVACError_FILTER_REPLACEMENT_REQUIRED,
		HVACError_CUSTOM_ERROR_0,
		HVACError_CUSTOM_ERROR_1,
		HVACError_CUSTOM_ERROR_2,
		HVACError_CUSTOM_ERROR_3,
		HVACError_CUSTOM_ERROR_4,
		HVACError_CUSTOM_ERROR_5,
		HVACError_CUSTOM_ERROR_6,
		HVACError_CUSTOM_ERROR_7,
		HVACError_CUSTOM_ERROR_8,
		HVACError_CUSTOM_ERROR_9,
		HVACError_CUSTOM_ERROR_10,
		HVACError_CUSTOM_ERROR_11,
		HVACError_CUSTOM_ERROR_12,
		HVACError_CUSTOM_ERROR_13,
		HVACError_CUSTOM_ERROR_14,
		HVACError_CUSTOM_ERROR_15,
		HVACError_CUSTOM_ERROR_16,
		HVACError_CUSTOM_ERROR_17,
		HVACError_CUSTOM_ERROR_18,
		HVACError_CUSTOM_ERROR_19,
		HVACError_CUSTOM_ERROR_20,
		HVACError_CUSTOM_ERROR_21,
		HVACError_CUSTOM_ERROR_22,
		HVACError_CUSTOM_ERROR_23,
		HVACError_CUSTOM_ERROR_24,
		HVACError_CUSTOM_ERROR_25,
		HVACError_CUSTOM_ERROR_26,
		HVACError_CUSTOM_ERROR_27,
		HVACError_CUSTOM_ERROR_28,
		HVACError_CUSTOM_ERROR_29,
		HVACError_CUSTOM_ERROR_30,
		HVACError_CUSTOM_ERROR_31,
		HVACError_CUSTOM_ERROR_32,
		HVACError_CUSTOM_ERROR_33,
		HVACError_CUSTOM_ERROR_34,
		HVACError_CUSTOM_ERROR_35,
		HVACError_CUSTOM_ERROR_36,
		HVACError_CUSTOM_ERROR_37,
		HVACError_CUSTOM_ERROR_38,
		HVACError_CUSTOM_ERROR_39,
		HVACError_CUSTOM_ERROR_40,
		HVACError_CUSTOM_ERROR_41,
		HVACError_CUSTOM_ERROR_42,
		HVACError_CUSTOM_ERROR_43,
		HVACError_CUSTOM_ERROR_44,
		HVACError_CUSTOM_ERROR_45,
		HVACError_CUSTOM_ERROR_46,
		HVACError_CUSTOM_ERROR_47,
		HVACError_CUSTOM_ERROR_48,
		HVACError_CUSTOM_ERROR_49,
		HVACError_CUSTOM_ERROR_50,
		HVACError_CUSTOM_ERROR_51,
		HVACError_CUSTOM_ERROR_52,
		HVACError_CUSTOM_ERROR_53,
		HVACError_CUSTOM_ERROR_54,
		HVACError_CUSTOM_ERROR_55,
		HVACError_CUSTOM_ERROR_56,
		HVACError_CUSTOM_ERROR_57,
		HVACError_CUSTOM_ERROR_58,
		HVACError_CUSTOM_ERROR_59,
		HVACError_CUSTOM_ERROR_60,
		HVACError_CUSTOM_ERROR_61,
		HVACError_CUSTOM_ERROR_62,
		HVACError_CUSTOM_ERROR_63,
		HVACError_CUSTOM_ERROR_64,
		HVACError_CUSTOM_ERROR_65,
		HVACError_CUSTOM_ERROR_66,
		HVACError_CUSTOM_ERROR_67,
		HVACError_CUSTOM_ERROR_68,
		HVACError_CUSTOM_ERROR_69,
		HVACError_CUSTOM_ERROR_70,
		HVACError_CUSTOM_ERROR_71,
		HVACError_CUSTOM_ERROR_72,
		HVACError_CUSTOM_ERROR_73,
		HVACError_CUSTOM_ERROR_74,
		HVACError_CUSTOM_ERROR_75,
		HVACError_CUSTOM_ERROR_76,
		HVACError_CUSTOM_ERROR_77,
		HVACError_CUSTOM_ERROR_78,
		HVACError_CUSTOM_ERROR_79,
		HVACError_CUSTOM_ERROR_80,
		HVACError_CUSTOM_ERROR_81,
		HVACError_CUSTOM_ERROR_82,
		HVACError_CUSTOM_ERROR_83,
		HVACError_CUSTOM_ERROR_84,
		HVACError_CUSTOM_ERROR_85,
		HVACError_CUSTOM_ERROR_86,
		HVACError_CUSTOM_ERROR_87,
		HVACError_CUSTOM_ERROR_88,
		HVACError_CUSTOM_ERROR_89,
		HVACError_CUSTOM_ERROR_90,
		HVACError_CUSTOM_ERROR_91,
		HVACError_CUSTOM_ERROR_92,
		HVACError_CUSTOM_ERROR_93,
		HVACError_CUSTOM_ERROR_94,
		HVACError_CUSTOM_ERROR_95,
		HVACError_CUSTOM_ERROR_96,
		HVACError_CUSTOM_ERROR_97,
		HVACError_CUSTOM_ERROR_98,
		HVACError_CUSTOM_ERROR_99,
		HVACError_CUSTOM_ERROR_100,
		HVACError_CUSTOM_ERROR_101,
		HVACError_CUSTOM_ERROR_102,
		HVACError_CUSTOM_ERROR_103,
		HVACError_CUSTOM_ERROR_104,
		HVACError_CUSTOM_ERROR_105,
		HVACError_CUSTOM_ERROR_106,
		HVACError_CUSTOM_ERROR_107,
		HVACError_CUSTOM_ERROR_108,
		HVACError_CUSTOM_ERROR_109,
		HVACError_CUSTOM_ERROR_110,
		HVACError_CUSTOM_ERROR_111,
		HVACError_CUSTOM_ERROR_112,
		HVACError_CUSTOM_ERROR_113,
		HVACError_CUSTOM_ERROR_114,
		HVACError_CUSTOM_ERROR_115,
		HVACError_CUSTOM_ERROR_116,
		HVACError_CUSTOM_ERROR_117,
		HVACError_CUSTOM_ERROR_118,
		HVACError_CUSTOM_ERROR_119,
		HVACError_CUSTOM_ERROR_120,
		HVACError_CUSTOM_ERROR_121,
		HVACError_CUSTOM_ERROR_122,
		HVACError_CUSTOM_ERROR_123,
		HVACError_CUSTOM_ERROR_124,
		HVACError_CUSTOM_ERROR_125,
		HVACError_CUSTOM_ERROR_126,
		HVACError_CUSTOM_ERROR_127,
	}
}

func HVACErrorByValue(value uint8) (enum HVACError, ok bool) {
	switch value {
	case 0x00:
		return HVACError_NO_ERROR, true
	case 0x01:
		return HVACError_HEATER_TOTAL_FAILURE, true
	case 0x02:
		return HVACError_COOLER_TOTAL_FAILURE, true
	case 0x03:
		return HVACError_FAN_TOTAL_FAILURE, true
	case 0x04:
		return HVACError_TEMPERATURE_SENSOR_FAILURE, true
	case 0x05:
		return HVACError_HEATER_TEMPORARY_PROBLEM, true
	case 0x06:
		return HVACError_COOLER_TEMPORARY_PROBLEM, true
	case 0x07:
		return HVACError_FAN_TEMPORARY_PROBLEM, true
	case 0x08:
		return HVACError_HEATER_SERVICE_REQUIRED, true
	case 0x09:
		return HVACError_COOLER_SERVICE_REQUIRED, true
	case 0x0A:
		return HVACError_FAN_SERVICE_REQUIRED, true
	case 0x0B:
		return HVACError_FILTER_REPLACEMENT_REQUIRED, true
	case 0x80:
		return HVACError_CUSTOM_ERROR_0, true
	case 0x81:
		return HVACError_CUSTOM_ERROR_1, true
	case 0x82:
		return HVACError_CUSTOM_ERROR_2, true
	case 0x83:
		return HVACError_CUSTOM_ERROR_3, true
	case 0x84:
		return HVACError_CUSTOM_ERROR_4, true
	case 0x85:
		return HVACError_CUSTOM_ERROR_5, true
	case 0x86:
		return HVACError_CUSTOM_ERROR_6, true
	case 0x87:
		return HVACError_CUSTOM_ERROR_7, true
	case 0x88:
		return HVACError_CUSTOM_ERROR_8, true
	case 0x89:
		return HVACError_CUSTOM_ERROR_9, true
	case 0x8A:
		return HVACError_CUSTOM_ERROR_10, true
	case 0x8B:
		return HVACError_CUSTOM_ERROR_11, true
	case 0x8C:
		return HVACError_CUSTOM_ERROR_12, true
	case 0x8D:
		return HVACError_CUSTOM_ERROR_13, true
	case 0x8E:
		return HVACError_CUSTOM_ERROR_14, true
	case 0x8F:
		return HVACError_CUSTOM_ERROR_15, true
	case 0x90:
		return HVACError_CUSTOM_ERROR_16, true
	case 0x91:
		return HVACError_CUSTOM_ERROR_17, true
	case 0x92:
		return HVACError_CUSTOM_ERROR_18, true
	case 0x93:
		return HVACError_CUSTOM_ERROR_19, true
	case 0x94:
		return HVACError_CUSTOM_ERROR_20, true
	case 0x95:
		return HVACError_CUSTOM_ERROR_21, true
	case 0x96:
		return HVACError_CUSTOM_ERROR_22, true
	case 0x97:
		return HVACError_CUSTOM_ERROR_23, true
	case 0x98:
		return HVACError_CUSTOM_ERROR_24, true
	case 0x99:
		return HVACError_CUSTOM_ERROR_25, true
	case 0x9A:
		return HVACError_CUSTOM_ERROR_26, true
	case 0x9B:
		return HVACError_CUSTOM_ERROR_27, true
	case 0x9C:
		return HVACError_CUSTOM_ERROR_28, true
	case 0x9D:
		return HVACError_CUSTOM_ERROR_29, true
	case 0x9E:
		return HVACError_CUSTOM_ERROR_30, true
	case 0x9F:
		return HVACError_CUSTOM_ERROR_31, true
	case 0xA0:
		return HVACError_CUSTOM_ERROR_32, true
	case 0xA1:
		return HVACError_CUSTOM_ERROR_33, true
	case 0xA2:
		return HVACError_CUSTOM_ERROR_34, true
	case 0xA3:
		return HVACError_CUSTOM_ERROR_35, true
	case 0xA4:
		return HVACError_CUSTOM_ERROR_36, true
	case 0xA5:
		return HVACError_CUSTOM_ERROR_37, true
	case 0xA6:
		return HVACError_CUSTOM_ERROR_38, true
	case 0xA7:
		return HVACError_CUSTOM_ERROR_39, true
	case 0xA8:
		return HVACError_CUSTOM_ERROR_40, true
	case 0xA9:
		return HVACError_CUSTOM_ERROR_41, true
	case 0xAA:
		return HVACError_CUSTOM_ERROR_42, true
	case 0xAB:
		return HVACError_CUSTOM_ERROR_43, true
	case 0xAC:
		return HVACError_CUSTOM_ERROR_44, true
	case 0xAD:
		return HVACError_CUSTOM_ERROR_45, true
	case 0xAE:
		return HVACError_CUSTOM_ERROR_46, true
	case 0xAF:
		return HVACError_CUSTOM_ERROR_47, true
	case 0xB0:
		return HVACError_CUSTOM_ERROR_48, true
	case 0xB1:
		return HVACError_CUSTOM_ERROR_49, true
	case 0xB2:
		return HVACError_CUSTOM_ERROR_50, true
	case 0xB3:
		return HVACError_CUSTOM_ERROR_51, true
	case 0xB4:
		return HVACError_CUSTOM_ERROR_52, true
	case 0xB5:
		return HVACError_CUSTOM_ERROR_53, true
	case 0xB6:
		return HVACError_CUSTOM_ERROR_54, true
	case 0xB7:
		return HVACError_CUSTOM_ERROR_55, true
	case 0xB8:
		return HVACError_CUSTOM_ERROR_56, true
	case 0xB9:
		return HVACError_CUSTOM_ERROR_57, true
	case 0xBA:
		return HVACError_CUSTOM_ERROR_58, true
	case 0xBB:
		return HVACError_CUSTOM_ERROR_59, true
	case 0xBC:
		return HVACError_CUSTOM_ERROR_60, true
	case 0xBD:
		return HVACError_CUSTOM_ERROR_61, true
	case 0xBE:
		return HVACError_CUSTOM_ERROR_62, true
	case 0xBF:
		return HVACError_CUSTOM_ERROR_63, true
	case 0xC0:
		return HVACError_CUSTOM_ERROR_64, true
	case 0xC1:
		return HVACError_CUSTOM_ERROR_65, true
	case 0xC2:
		return HVACError_CUSTOM_ERROR_66, true
	case 0xC3:
		return HVACError_CUSTOM_ERROR_67, true
	case 0xC4:
		return HVACError_CUSTOM_ERROR_68, true
	case 0xC5:
		return HVACError_CUSTOM_ERROR_69, true
	case 0xC6:
		return HVACError_CUSTOM_ERROR_70, true
	case 0xC7:
		return HVACError_CUSTOM_ERROR_71, true
	case 0xC8:
		return HVACError_CUSTOM_ERROR_72, true
	case 0xC9:
		return HVACError_CUSTOM_ERROR_73, true
	case 0xCA:
		return HVACError_CUSTOM_ERROR_74, true
	case 0xCB:
		return HVACError_CUSTOM_ERROR_75, true
	case 0xCC:
		return HVACError_CUSTOM_ERROR_76, true
	case 0xCD:
		return HVACError_CUSTOM_ERROR_77, true
	case 0xCE:
		return HVACError_CUSTOM_ERROR_78, true
	case 0xCF:
		return HVACError_CUSTOM_ERROR_79, true
	case 0xD0:
		return HVACError_CUSTOM_ERROR_80, true
	case 0xD1:
		return HVACError_CUSTOM_ERROR_81, true
	case 0xD2:
		return HVACError_CUSTOM_ERROR_82, true
	case 0xD3:
		return HVACError_CUSTOM_ERROR_83, true
	case 0xD4:
		return HVACError_CUSTOM_ERROR_84, true
	case 0xD5:
		return HVACError_CUSTOM_ERROR_85, true
	case 0xD6:
		return HVACError_CUSTOM_ERROR_86, true
	case 0xD7:
		return HVACError_CUSTOM_ERROR_87, true
	case 0xD8:
		return HVACError_CUSTOM_ERROR_88, true
	case 0xD9:
		return HVACError_CUSTOM_ERROR_89, true
	case 0xDA:
		return HVACError_CUSTOM_ERROR_90, true
	case 0xDB:
		return HVACError_CUSTOM_ERROR_91, true
	case 0xDC:
		return HVACError_CUSTOM_ERROR_92, true
	case 0xDD:
		return HVACError_CUSTOM_ERROR_93, true
	case 0xDE:
		return HVACError_CUSTOM_ERROR_94, true
	case 0xDF:
		return HVACError_CUSTOM_ERROR_95, true
	case 0xE0:
		return HVACError_CUSTOM_ERROR_96, true
	case 0xE1:
		return HVACError_CUSTOM_ERROR_97, true
	case 0xE2:
		return HVACError_CUSTOM_ERROR_98, true
	case 0xE3:
		return HVACError_CUSTOM_ERROR_99, true
	case 0xE4:
		return HVACError_CUSTOM_ERROR_100, true
	case 0xE5:
		return HVACError_CUSTOM_ERROR_101, true
	case 0xE6:
		return HVACError_CUSTOM_ERROR_102, true
	case 0xE7:
		return HVACError_CUSTOM_ERROR_103, true
	case 0xE8:
		return HVACError_CUSTOM_ERROR_104, true
	case 0xE9:
		return HVACError_CUSTOM_ERROR_105, true
	case 0xEA:
		return HVACError_CUSTOM_ERROR_106, true
	case 0xEB:
		return HVACError_CUSTOM_ERROR_107, true
	case 0xEC:
		return HVACError_CUSTOM_ERROR_108, true
	case 0xED:
		return HVACError_CUSTOM_ERROR_109, true
	case 0xEE:
		return HVACError_CUSTOM_ERROR_110, true
	case 0xEF:
		return HVACError_CUSTOM_ERROR_111, true
	case 0xF0:
		return HVACError_CUSTOM_ERROR_112, true
	case 0xF1:
		return HVACError_CUSTOM_ERROR_113, true
	case 0xF2:
		return HVACError_CUSTOM_ERROR_114, true
	case 0xF3:
		return HVACError_CUSTOM_ERROR_115, true
	case 0xF4:
		return HVACError_CUSTOM_ERROR_116, true
	case 0xF5:
		return HVACError_CUSTOM_ERROR_117, true
	case 0xF6:
		return HVACError_CUSTOM_ERROR_118, true
	case 0xF7:
		return HVACError_CUSTOM_ERROR_119, true
	case 0xF8:
		return HVACError_CUSTOM_ERROR_120, true
	case 0xF9:
		return HVACError_CUSTOM_ERROR_121, true
	case 0xFA:
		return HVACError_CUSTOM_ERROR_122, true
	case 0xFB:
		return HVACError_CUSTOM_ERROR_123, true
	case 0xFC:
		return HVACError_CUSTOM_ERROR_124, true
	case 0xFD:
		return HVACError_CUSTOM_ERROR_125, true
	case 0xFE:
		return HVACError_CUSTOM_ERROR_126, true
	case 0xFF:
		return HVACError_CUSTOM_ERROR_127, true
	}
	return 0, false
}

func HVACErrorByName(value string) (enum HVACError, ok bool) {
	switch value {
	case "NO_ERROR":
		return HVACError_NO_ERROR, true
	case "HEATER_TOTAL_FAILURE":
		return HVACError_HEATER_TOTAL_FAILURE, true
	case "COOLER_TOTAL_FAILURE":
		return HVACError_COOLER_TOTAL_FAILURE, true
	case "FAN_TOTAL_FAILURE":
		return HVACError_FAN_TOTAL_FAILURE, true
	case "TEMPERATURE_SENSOR_FAILURE":
		return HVACError_TEMPERATURE_SENSOR_FAILURE, true
	case "HEATER_TEMPORARY_PROBLEM":
		return HVACError_HEATER_TEMPORARY_PROBLEM, true
	case "COOLER_TEMPORARY_PROBLEM":
		return HVACError_COOLER_TEMPORARY_PROBLEM, true
	case "FAN_TEMPORARY_PROBLEM":
		return HVACError_FAN_TEMPORARY_PROBLEM, true
	case "HEATER_SERVICE_REQUIRED":
		return HVACError_HEATER_SERVICE_REQUIRED, true
	case "COOLER_SERVICE_REQUIRED":
		return HVACError_COOLER_SERVICE_REQUIRED, true
	case "FAN_SERVICE_REQUIRED":
		return HVACError_FAN_SERVICE_REQUIRED, true
	case "FILTER_REPLACEMENT_REQUIRED":
		return HVACError_FILTER_REPLACEMENT_REQUIRED, true
	case "CUSTOM_ERROR_0":
		return HVACError_CUSTOM_ERROR_0, true
	case "CUSTOM_ERROR_1":
		return HVACError_CUSTOM_ERROR_1, true
	case "CUSTOM_ERROR_2":
		return HVACError_CUSTOM_ERROR_2, true
	case "CUSTOM_ERROR_3":
		return HVACError_CUSTOM_ERROR_3, true
	case "CUSTOM_ERROR_4":
		return HVACError_CUSTOM_ERROR_4, true
	case "CUSTOM_ERROR_5":
		return HVACError_CUSTOM_ERROR_5, true
	case "CUSTOM_ERROR_6":
		return HVACError_CUSTOM_ERROR_6, true
	case "CUSTOM_ERROR_7":
		return HVACError_CUSTOM_ERROR_7, true
	case "CUSTOM_ERROR_8":
		return HVACError_CUSTOM_ERROR_8, true
	case "CUSTOM_ERROR_9":
		return HVACError_CUSTOM_ERROR_9, true
	case "CUSTOM_ERROR_10":
		return HVACError_CUSTOM_ERROR_10, true
	case "CUSTOM_ERROR_11":
		return HVACError_CUSTOM_ERROR_11, true
	case "CUSTOM_ERROR_12":
		return HVACError_CUSTOM_ERROR_12, true
	case "CUSTOM_ERROR_13":
		return HVACError_CUSTOM_ERROR_13, true
	case "CUSTOM_ERROR_14":
		return HVACError_CUSTOM_ERROR_14, true
	case "CUSTOM_ERROR_15":
		return HVACError_CUSTOM_ERROR_15, true
	case "CUSTOM_ERROR_16":
		return HVACError_CUSTOM_ERROR_16, true
	case "CUSTOM_ERROR_17":
		return HVACError_CUSTOM_ERROR_17, true
	case "CUSTOM_ERROR_18":
		return HVACError_CUSTOM_ERROR_18, true
	case "CUSTOM_ERROR_19":
		return HVACError_CUSTOM_ERROR_19, true
	case "CUSTOM_ERROR_20":
		return HVACError_CUSTOM_ERROR_20, true
	case "CUSTOM_ERROR_21":
		return HVACError_CUSTOM_ERROR_21, true
	case "CUSTOM_ERROR_22":
		return HVACError_CUSTOM_ERROR_22, true
	case "CUSTOM_ERROR_23":
		return HVACError_CUSTOM_ERROR_23, true
	case "CUSTOM_ERROR_24":
		return HVACError_CUSTOM_ERROR_24, true
	case "CUSTOM_ERROR_25":
		return HVACError_CUSTOM_ERROR_25, true
	case "CUSTOM_ERROR_26":
		return HVACError_CUSTOM_ERROR_26, true
	case "CUSTOM_ERROR_27":
		return HVACError_CUSTOM_ERROR_27, true
	case "CUSTOM_ERROR_28":
		return HVACError_CUSTOM_ERROR_28, true
	case "CUSTOM_ERROR_29":
		return HVACError_CUSTOM_ERROR_29, true
	case "CUSTOM_ERROR_30":
		return HVACError_CUSTOM_ERROR_30, true
	case "CUSTOM_ERROR_31":
		return HVACError_CUSTOM_ERROR_31, true
	case "CUSTOM_ERROR_32":
		return HVACError_CUSTOM_ERROR_32, true
	case "CUSTOM_ERROR_33":
		return HVACError_CUSTOM_ERROR_33, true
	case "CUSTOM_ERROR_34":
		return HVACError_CUSTOM_ERROR_34, true
	case "CUSTOM_ERROR_35":
		return HVACError_CUSTOM_ERROR_35, true
	case "CUSTOM_ERROR_36":
		return HVACError_CUSTOM_ERROR_36, true
	case "CUSTOM_ERROR_37":
		return HVACError_CUSTOM_ERROR_37, true
	case "CUSTOM_ERROR_38":
		return HVACError_CUSTOM_ERROR_38, true
	case "CUSTOM_ERROR_39":
		return HVACError_CUSTOM_ERROR_39, true
	case "CUSTOM_ERROR_40":
		return HVACError_CUSTOM_ERROR_40, true
	case "CUSTOM_ERROR_41":
		return HVACError_CUSTOM_ERROR_41, true
	case "CUSTOM_ERROR_42":
		return HVACError_CUSTOM_ERROR_42, true
	case "CUSTOM_ERROR_43":
		return HVACError_CUSTOM_ERROR_43, true
	case "CUSTOM_ERROR_44":
		return HVACError_CUSTOM_ERROR_44, true
	case "CUSTOM_ERROR_45":
		return HVACError_CUSTOM_ERROR_45, true
	case "CUSTOM_ERROR_46":
		return HVACError_CUSTOM_ERROR_46, true
	case "CUSTOM_ERROR_47":
		return HVACError_CUSTOM_ERROR_47, true
	case "CUSTOM_ERROR_48":
		return HVACError_CUSTOM_ERROR_48, true
	case "CUSTOM_ERROR_49":
		return HVACError_CUSTOM_ERROR_49, true
	case "CUSTOM_ERROR_50":
		return HVACError_CUSTOM_ERROR_50, true
	case "CUSTOM_ERROR_51":
		return HVACError_CUSTOM_ERROR_51, true
	case "CUSTOM_ERROR_52":
		return HVACError_CUSTOM_ERROR_52, true
	case "CUSTOM_ERROR_53":
		return HVACError_CUSTOM_ERROR_53, true
	case "CUSTOM_ERROR_54":
		return HVACError_CUSTOM_ERROR_54, true
	case "CUSTOM_ERROR_55":
		return HVACError_CUSTOM_ERROR_55, true
	case "CUSTOM_ERROR_56":
		return HVACError_CUSTOM_ERROR_56, true
	case "CUSTOM_ERROR_57":
		return HVACError_CUSTOM_ERROR_57, true
	case "CUSTOM_ERROR_58":
		return HVACError_CUSTOM_ERROR_58, true
	case "CUSTOM_ERROR_59":
		return HVACError_CUSTOM_ERROR_59, true
	case "CUSTOM_ERROR_60":
		return HVACError_CUSTOM_ERROR_60, true
	case "CUSTOM_ERROR_61":
		return HVACError_CUSTOM_ERROR_61, true
	case "CUSTOM_ERROR_62":
		return HVACError_CUSTOM_ERROR_62, true
	case "CUSTOM_ERROR_63":
		return HVACError_CUSTOM_ERROR_63, true
	case "CUSTOM_ERROR_64":
		return HVACError_CUSTOM_ERROR_64, true
	case "CUSTOM_ERROR_65":
		return HVACError_CUSTOM_ERROR_65, true
	case "CUSTOM_ERROR_66":
		return HVACError_CUSTOM_ERROR_66, true
	case "CUSTOM_ERROR_67":
		return HVACError_CUSTOM_ERROR_67, true
	case "CUSTOM_ERROR_68":
		return HVACError_CUSTOM_ERROR_68, true
	case "CUSTOM_ERROR_69":
		return HVACError_CUSTOM_ERROR_69, true
	case "CUSTOM_ERROR_70":
		return HVACError_CUSTOM_ERROR_70, true
	case "CUSTOM_ERROR_71":
		return HVACError_CUSTOM_ERROR_71, true
	case "CUSTOM_ERROR_72":
		return HVACError_CUSTOM_ERROR_72, true
	case "CUSTOM_ERROR_73":
		return HVACError_CUSTOM_ERROR_73, true
	case "CUSTOM_ERROR_74":
		return HVACError_CUSTOM_ERROR_74, true
	case "CUSTOM_ERROR_75":
		return HVACError_CUSTOM_ERROR_75, true
	case "CUSTOM_ERROR_76":
		return HVACError_CUSTOM_ERROR_76, true
	case "CUSTOM_ERROR_77":
		return HVACError_CUSTOM_ERROR_77, true
	case "CUSTOM_ERROR_78":
		return HVACError_CUSTOM_ERROR_78, true
	case "CUSTOM_ERROR_79":
		return HVACError_CUSTOM_ERROR_79, true
	case "CUSTOM_ERROR_80":
		return HVACError_CUSTOM_ERROR_80, true
	case "CUSTOM_ERROR_81":
		return HVACError_CUSTOM_ERROR_81, true
	case "CUSTOM_ERROR_82":
		return HVACError_CUSTOM_ERROR_82, true
	case "CUSTOM_ERROR_83":
		return HVACError_CUSTOM_ERROR_83, true
	case "CUSTOM_ERROR_84":
		return HVACError_CUSTOM_ERROR_84, true
	case "CUSTOM_ERROR_85":
		return HVACError_CUSTOM_ERROR_85, true
	case "CUSTOM_ERROR_86":
		return HVACError_CUSTOM_ERROR_86, true
	case "CUSTOM_ERROR_87":
		return HVACError_CUSTOM_ERROR_87, true
	case "CUSTOM_ERROR_88":
		return HVACError_CUSTOM_ERROR_88, true
	case "CUSTOM_ERROR_89":
		return HVACError_CUSTOM_ERROR_89, true
	case "CUSTOM_ERROR_90":
		return HVACError_CUSTOM_ERROR_90, true
	case "CUSTOM_ERROR_91":
		return HVACError_CUSTOM_ERROR_91, true
	case "CUSTOM_ERROR_92":
		return HVACError_CUSTOM_ERROR_92, true
	case "CUSTOM_ERROR_93":
		return HVACError_CUSTOM_ERROR_93, true
	case "CUSTOM_ERROR_94":
		return HVACError_CUSTOM_ERROR_94, true
	case "CUSTOM_ERROR_95":
		return HVACError_CUSTOM_ERROR_95, true
	case "CUSTOM_ERROR_96":
		return HVACError_CUSTOM_ERROR_96, true
	case "CUSTOM_ERROR_97":
		return HVACError_CUSTOM_ERROR_97, true
	case "CUSTOM_ERROR_98":
		return HVACError_CUSTOM_ERROR_98, true
	case "CUSTOM_ERROR_99":
		return HVACError_CUSTOM_ERROR_99, true
	case "CUSTOM_ERROR_100":
		return HVACError_CUSTOM_ERROR_100, true
	case "CUSTOM_ERROR_101":
		return HVACError_CUSTOM_ERROR_101, true
	case "CUSTOM_ERROR_102":
		return HVACError_CUSTOM_ERROR_102, true
	case "CUSTOM_ERROR_103":
		return HVACError_CUSTOM_ERROR_103, true
	case "CUSTOM_ERROR_104":
		return HVACError_CUSTOM_ERROR_104, true
	case "CUSTOM_ERROR_105":
		return HVACError_CUSTOM_ERROR_105, true
	case "CUSTOM_ERROR_106":
		return HVACError_CUSTOM_ERROR_106, true
	case "CUSTOM_ERROR_107":
		return HVACError_CUSTOM_ERROR_107, true
	case "CUSTOM_ERROR_108":
		return HVACError_CUSTOM_ERROR_108, true
	case "CUSTOM_ERROR_109":
		return HVACError_CUSTOM_ERROR_109, true
	case "CUSTOM_ERROR_110":
		return HVACError_CUSTOM_ERROR_110, true
	case "CUSTOM_ERROR_111":
		return HVACError_CUSTOM_ERROR_111, true
	case "CUSTOM_ERROR_112":
		return HVACError_CUSTOM_ERROR_112, true
	case "CUSTOM_ERROR_113":
		return HVACError_CUSTOM_ERROR_113, true
	case "CUSTOM_ERROR_114":
		return HVACError_CUSTOM_ERROR_114, true
	case "CUSTOM_ERROR_115":
		return HVACError_CUSTOM_ERROR_115, true
	case "CUSTOM_ERROR_116":
		return HVACError_CUSTOM_ERROR_116, true
	case "CUSTOM_ERROR_117":
		return HVACError_CUSTOM_ERROR_117, true
	case "CUSTOM_ERROR_118":
		return HVACError_CUSTOM_ERROR_118, true
	case "CUSTOM_ERROR_119":
		return HVACError_CUSTOM_ERROR_119, true
	case "CUSTOM_ERROR_120":
		return HVACError_CUSTOM_ERROR_120, true
	case "CUSTOM_ERROR_121":
		return HVACError_CUSTOM_ERROR_121, true
	case "CUSTOM_ERROR_122":
		return HVACError_CUSTOM_ERROR_122, true
	case "CUSTOM_ERROR_123":
		return HVACError_CUSTOM_ERROR_123, true
	case "CUSTOM_ERROR_124":
		return HVACError_CUSTOM_ERROR_124, true
	case "CUSTOM_ERROR_125":
		return HVACError_CUSTOM_ERROR_125, true
	case "CUSTOM_ERROR_126":
		return HVACError_CUSTOM_ERROR_126, true
	case "CUSTOM_ERROR_127":
		return HVACError_CUSTOM_ERROR_127, true
	}
	return 0, false
}

func HVACErrorKnows(value uint8) bool {
	for _, typeValue := range HVACErrorValues {
		if uint8(typeValue) == value {
			return true
		}
	}
	return false
}

func CastHVACError(structType any) HVACError {
	castFunc := func(typ any) HVACError {
		if sHVACError, ok := typ.(HVACError); ok {
			return sHVACError
		}
		return 0
	}
	return castFunc(structType)
}

func (m HVACError) GetLengthInBits(ctx context.Context) uint16 {
	return 8
}

func (m HVACError) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func HVACErrorParse(ctx context.Context, theBytes []byte) (HVACError, error) {
	return HVACErrorParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func HVACErrorParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (HVACError, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadUint8("HVACError", 8)
	if err != nil {
		return 0, errors.Wrap(err, "error reading HVACError")
	}
	if enum, ok := HVACErrorByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for HVACError")
		return HVACError(val), nil
	} else {
		return enum, nil
	}
}

func (e HVACError) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e HVACError) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteUint8("HVACError", 8, uint8(uint8(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e HVACError) PLC4XEnumName() string {
	switch e {
	case HVACError_NO_ERROR:
		return "NO_ERROR"
	case HVACError_HEATER_TOTAL_FAILURE:
		return "HEATER_TOTAL_FAILURE"
	case HVACError_COOLER_TOTAL_FAILURE:
		return "COOLER_TOTAL_FAILURE"
	case HVACError_FAN_TOTAL_FAILURE:
		return "FAN_TOTAL_FAILURE"
	case HVACError_TEMPERATURE_SENSOR_FAILURE:
		return "TEMPERATURE_SENSOR_FAILURE"
	case HVACError_HEATER_TEMPORARY_PROBLEM:
		return "HEATER_TEMPORARY_PROBLEM"
	case HVACError_COOLER_TEMPORARY_PROBLEM:
		return "COOLER_TEMPORARY_PROBLEM"
	case HVACError_FAN_TEMPORARY_PROBLEM:
		return "FAN_TEMPORARY_PROBLEM"
	case HVACError_HEATER_SERVICE_REQUIRED:
		return "HEATER_SERVICE_REQUIRED"
	case HVACError_COOLER_SERVICE_REQUIRED:
		return "COOLER_SERVICE_REQUIRED"
	case HVACError_FAN_SERVICE_REQUIRED:
		return "FAN_SERVICE_REQUIRED"
	case HVACError_FILTER_REPLACEMENT_REQUIRED:
		return "FILTER_REPLACEMENT_REQUIRED"
	case HVACError_CUSTOM_ERROR_0:
		return "CUSTOM_ERROR_0"
	case HVACError_CUSTOM_ERROR_1:
		return "CUSTOM_ERROR_1"
	case HVACError_CUSTOM_ERROR_2:
		return "CUSTOM_ERROR_2"
	case HVACError_CUSTOM_ERROR_3:
		return "CUSTOM_ERROR_3"
	case HVACError_CUSTOM_ERROR_4:
		return "CUSTOM_ERROR_4"
	case HVACError_CUSTOM_ERROR_5:
		return "CUSTOM_ERROR_5"
	case HVACError_CUSTOM_ERROR_6:
		return "CUSTOM_ERROR_6"
	case HVACError_CUSTOM_ERROR_7:
		return "CUSTOM_ERROR_7"
	case HVACError_CUSTOM_ERROR_8:
		return "CUSTOM_ERROR_8"
	case HVACError_CUSTOM_ERROR_9:
		return "CUSTOM_ERROR_9"
	case HVACError_CUSTOM_ERROR_10:
		return "CUSTOM_ERROR_10"
	case HVACError_CUSTOM_ERROR_11:
		return "CUSTOM_ERROR_11"
	case HVACError_CUSTOM_ERROR_12:
		return "CUSTOM_ERROR_12"
	case HVACError_CUSTOM_ERROR_13:
		return "CUSTOM_ERROR_13"
	case HVACError_CUSTOM_ERROR_14:
		return "CUSTOM_ERROR_14"
	case HVACError_CUSTOM_ERROR_15:
		return "CUSTOM_ERROR_15"
	case HVACError_CUSTOM_ERROR_16:
		return "CUSTOM_ERROR_16"
	case HVACError_CUSTOM_ERROR_17:
		return "CUSTOM_ERROR_17"
	case HVACError_CUSTOM_ERROR_18:
		return "CUSTOM_ERROR_18"
	case HVACError_CUSTOM_ERROR_19:
		return "CUSTOM_ERROR_19"
	case HVACError_CUSTOM_ERROR_20:
		return "CUSTOM_ERROR_20"
	case HVACError_CUSTOM_ERROR_21:
		return "CUSTOM_ERROR_21"
	case HVACError_CUSTOM_ERROR_22:
		return "CUSTOM_ERROR_22"
	case HVACError_CUSTOM_ERROR_23:
		return "CUSTOM_ERROR_23"
	case HVACError_CUSTOM_ERROR_24:
		return "CUSTOM_ERROR_24"
	case HVACError_CUSTOM_ERROR_25:
		return "CUSTOM_ERROR_25"
	case HVACError_CUSTOM_ERROR_26:
		return "CUSTOM_ERROR_26"
	case HVACError_CUSTOM_ERROR_27:
		return "CUSTOM_ERROR_27"
	case HVACError_CUSTOM_ERROR_28:
		return "CUSTOM_ERROR_28"
	case HVACError_CUSTOM_ERROR_29:
		return "CUSTOM_ERROR_29"
	case HVACError_CUSTOM_ERROR_30:
		return "CUSTOM_ERROR_30"
	case HVACError_CUSTOM_ERROR_31:
		return "CUSTOM_ERROR_31"
	case HVACError_CUSTOM_ERROR_32:
		return "CUSTOM_ERROR_32"
	case HVACError_CUSTOM_ERROR_33:
		return "CUSTOM_ERROR_33"
	case HVACError_CUSTOM_ERROR_34:
		return "CUSTOM_ERROR_34"
	case HVACError_CUSTOM_ERROR_35:
		return "CUSTOM_ERROR_35"
	case HVACError_CUSTOM_ERROR_36:
		return "CUSTOM_ERROR_36"
	case HVACError_CUSTOM_ERROR_37:
		return "CUSTOM_ERROR_37"
	case HVACError_CUSTOM_ERROR_38:
		return "CUSTOM_ERROR_38"
	case HVACError_CUSTOM_ERROR_39:
		return "CUSTOM_ERROR_39"
	case HVACError_CUSTOM_ERROR_40:
		return "CUSTOM_ERROR_40"
	case HVACError_CUSTOM_ERROR_41:
		return "CUSTOM_ERROR_41"
	case HVACError_CUSTOM_ERROR_42:
		return "CUSTOM_ERROR_42"
	case HVACError_CUSTOM_ERROR_43:
		return "CUSTOM_ERROR_43"
	case HVACError_CUSTOM_ERROR_44:
		return "CUSTOM_ERROR_44"
	case HVACError_CUSTOM_ERROR_45:
		return "CUSTOM_ERROR_45"
	case HVACError_CUSTOM_ERROR_46:
		return "CUSTOM_ERROR_46"
	case HVACError_CUSTOM_ERROR_47:
		return "CUSTOM_ERROR_47"
	case HVACError_CUSTOM_ERROR_48:
		return "CUSTOM_ERROR_48"
	case HVACError_CUSTOM_ERROR_49:
		return "CUSTOM_ERROR_49"
	case HVACError_CUSTOM_ERROR_50:
		return "CUSTOM_ERROR_50"
	case HVACError_CUSTOM_ERROR_51:
		return "CUSTOM_ERROR_51"
	case HVACError_CUSTOM_ERROR_52:
		return "CUSTOM_ERROR_52"
	case HVACError_CUSTOM_ERROR_53:
		return "CUSTOM_ERROR_53"
	case HVACError_CUSTOM_ERROR_54:
		return "CUSTOM_ERROR_54"
	case HVACError_CUSTOM_ERROR_55:
		return "CUSTOM_ERROR_55"
	case HVACError_CUSTOM_ERROR_56:
		return "CUSTOM_ERROR_56"
	case HVACError_CUSTOM_ERROR_57:
		return "CUSTOM_ERROR_57"
	case HVACError_CUSTOM_ERROR_58:
		return "CUSTOM_ERROR_58"
	case HVACError_CUSTOM_ERROR_59:
		return "CUSTOM_ERROR_59"
	case HVACError_CUSTOM_ERROR_60:
		return "CUSTOM_ERROR_60"
	case HVACError_CUSTOM_ERROR_61:
		return "CUSTOM_ERROR_61"
	case HVACError_CUSTOM_ERROR_62:
		return "CUSTOM_ERROR_62"
	case HVACError_CUSTOM_ERROR_63:
		return "CUSTOM_ERROR_63"
	case HVACError_CUSTOM_ERROR_64:
		return "CUSTOM_ERROR_64"
	case HVACError_CUSTOM_ERROR_65:
		return "CUSTOM_ERROR_65"
	case HVACError_CUSTOM_ERROR_66:
		return "CUSTOM_ERROR_66"
	case HVACError_CUSTOM_ERROR_67:
		return "CUSTOM_ERROR_67"
	case HVACError_CUSTOM_ERROR_68:
		return "CUSTOM_ERROR_68"
	case HVACError_CUSTOM_ERROR_69:
		return "CUSTOM_ERROR_69"
	case HVACError_CUSTOM_ERROR_70:
		return "CUSTOM_ERROR_70"
	case HVACError_CUSTOM_ERROR_71:
		return "CUSTOM_ERROR_71"
	case HVACError_CUSTOM_ERROR_72:
		return "CUSTOM_ERROR_72"
	case HVACError_CUSTOM_ERROR_73:
		return "CUSTOM_ERROR_73"
	case HVACError_CUSTOM_ERROR_74:
		return "CUSTOM_ERROR_74"
	case HVACError_CUSTOM_ERROR_75:
		return "CUSTOM_ERROR_75"
	case HVACError_CUSTOM_ERROR_76:
		return "CUSTOM_ERROR_76"
	case HVACError_CUSTOM_ERROR_77:
		return "CUSTOM_ERROR_77"
	case HVACError_CUSTOM_ERROR_78:
		return "CUSTOM_ERROR_78"
	case HVACError_CUSTOM_ERROR_79:
		return "CUSTOM_ERROR_79"
	case HVACError_CUSTOM_ERROR_80:
		return "CUSTOM_ERROR_80"
	case HVACError_CUSTOM_ERROR_81:
		return "CUSTOM_ERROR_81"
	case HVACError_CUSTOM_ERROR_82:
		return "CUSTOM_ERROR_82"
	case HVACError_CUSTOM_ERROR_83:
		return "CUSTOM_ERROR_83"
	case HVACError_CUSTOM_ERROR_84:
		return "CUSTOM_ERROR_84"
	case HVACError_CUSTOM_ERROR_85:
		return "CUSTOM_ERROR_85"
	case HVACError_CUSTOM_ERROR_86:
		return "CUSTOM_ERROR_86"
	case HVACError_CUSTOM_ERROR_87:
		return "CUSTOM_ERROR_87"
	case HVACError_CUSTOM_ERROR_88:
		return "CUSTOM_ERROR_88"
	case HVACError_CUSTOM_ERROR_89:
		return "CUSTOM_ERROR_89"
	case HVACError_CUSTOM_ERROR_90:
		return "CUSTOM_ERROR_90"
	case HVACError_CUSTOM_ERROR_91:
		return "CUSTOM_ERROR_91"
	case HVACError_CUSTOM_ERROR_92:
		return "CUSTOM_ERROR_92"
	case HVACError_CUSTOM_ERROR_93:
		return "CUSTOM_ERROR_93"
	case HVACError_CUSTOM_ERROR_94:
		return "CUSTOM_ERROR_94"
	case HVACError_CUSTOM_ERROR_95:
		return "CUSTOM_ERROR_95"
	case HVACError_CUSTOM_ERROR_96:
		return "CUSTOM_ERROR_96"
	case HVACError_CUSTOM_ERROR_97:
		return "CUSTOM_ERROR_97"
	case HVACError_CUSTOM_ERROR_98:
		return "CUSTOM_ERROR_98"
	case HVACError_CUSTOM_ERROR_99:
		return "CUSTOM_ERROR_99"
	case HVACError_CUSTOM_ERROR_100:
		return "CUSTOM_ERROR_100"
	case HVACError_CUSTOM_ERROR_101:
		return "CUSTOM_ERROR_101"
	case HVACError_CUSTOM_ERROR_102:
		return "CUSTOM_ERROR_102"
	case HVACError_CUSTOM_ERROR_103:
		return "CUSTOM_ERROR_103"
	case HVACError_CUSTOM_ERROR_104:
		return "CUSTOM_ERROR_104"
	case HVACError_CUSTOM_ERROR_105:
		return "CUSTOM_ERROR_105"
	case HVACError_CUSTOM_ERROR_106:
		return "CUSTOM_ERROR_106"
	case HVACError_CUSTOM_ERROR_107:
		return "CUSTOM_ERROR_107"
	case HVACError_CUSTOM_ERROR_108:
		return "CUSTOM_ERROR_108"
	case HVACError_CUSTOM_ERROR_109:
		return "CUSTOM_ERROR_109"
	case HVACError_CUSTOM_ERROR_110:
		return "CUSTOM_ERROR_110"
	case HVACError_CUSTOM_ERROR_111:
		return "CUSTOM_ERROR_111"
	case HVACError_CUSTOM_ERROR_112:
		return "CUSTOM_ERROR_112"
	case HVACError_CUSTOM_ERROR_113:
		return "CUSTOM_ERROR_113"
	case HVACError_CUSTOM_ERROR_114:
		return "CUSTOM_ERROR_114"
	case HVACError_CUSTOM_ERROR_115:
		return "CUSTOM_ERROR_115"
	case HVACError_CUSTOM_ERROR_116:
		return "CUSTOM_ERROR_116"
	case HVACError_CUSTOM_ERROR_117:
		return "CUSTOM_ERROR_117"
	case HVACError_CUSTOM_ERROR_118:
		return "CUSTOM_ERROR_118"
	case HVACError_CUSTOM_ERROR_119:
		return "CUSTOM_ERROR_119"
	case HVACError_CUSTOM_ERROR_120:
		return "CUSTOM_ERROR_120"
	case HVACError_CUSTOM_ERROR_121:
		return "CUSTOM_ERROR_121"
	case HVACError_CUSTOM_ERROR_122:
		return "CUSTOM_ERROR_122"
	case HVACError_CUSTOM_ERROR_123:
		return "CUSTOM_ERROR_123"
	case HVACError_CUSTOM_ERROR_124:
		return "CUSTOM_ERROR_124"
	case HVACError_CUSTOM_ERROR_125:
		return "CUSTOM_ERROR_125"
	case HVACError_CUSTOM_ERROR_126:
		return "CUSTOM_ERROR_126"
	case HVACError_CUSTOM_ERROR_127:
		return "CUSTOM_ERROR_127"
	}
	return fmt.Sprintf("Unknown(%v)", uint8(e))
}

func (e HVACError) String() string {
	return e.PLC4XEnumName()
}
