/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetWriteStatus is an enum
type BACnetWriteStatus uint8

type IBACnetWriteStatus interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	BACnetWriteStatus_IDLE        BACnetWriteStatus = 0
	BACnetWriteStatus_IN_PROGRESS BACnetWriteStatus = 1
	BACnetWriteStatus_SUCCESSFUL  BACnetWriteStatus = 2
	BACnetWriteStatus_FAILED      BACnetWriteStatus = 3
)

var BACnetWriteStatusValues []BACnetWriteStatus

func init() {
	_ = errors.New
	BACnetWriteStatusValues = []BACnetWriteStatus{
		BACnetWriteStatus_IDLE,
		BACnetWriteStatus_IN_PROGRESS,
		BACnetWriteStatus_SUCCESSFUL,
		BACnetWriteStatus_FAILED,
	}
}

func BACnetWriteStatusByValue(value uint8) (enum BACnetWriteStatus, ok bool) {
	switch value {
	case 0:
		return BACnetWriteStatus_IDLE, true
	case 1:
		return BACnetWriteStatus_IN_PROGRESS, true
	case 2:
		return BACnetWriteStatus_SUCCESSFUL, true
	case 3:
		return BACnetWriteStatus_FAILED, true
	}
	return 0, false
}

func BACnetWriteStatusByName(value string) (enum BACnetWriteStatus, ok bool) {
	switch value {
	case "IDLE":
		return BACnetWriteStatus_IDLE, true
	case "IN_PROGRESS":
		return BACnetWriteStatus_IN_PROGRESS, true
	case "SUCCESSFUL":
		return BACnetWriteStatus_SUCCESSFUL, true
	case "FAILED":
		return BACnetWriteStatus_FAILED, true
	}
	return 0, false
}

func BACnetWriteStatusKnows(value uint8) bool {
	for _, typeValue := range BACnetWriteStatusValues {
		if uint8(typeValue) == value {
			return true
		}
	}
	return false
}

func CastBACnetWriteStatus(structType any) BACnetWriteStatus {
	castFunc := func(typ any) BACnetWriteStatus {
		if sBACnetWriteStatus, ok := typ.(BACnetWriteStatus); ok {
			return sBACnetWriteStatus
		}
		return 0
	}
	return castFunc(structType)
}

func (m BACnetWriteStatus) GetLengthInBits(ctx context.Context) uint16 {
	return 8
}

func (m BACnetWriteStatus) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetWriteStatusParse(ctx context.Context, theBytes []byte) (BACnetWriteStatus, error) {
	return BACnetWriteStatusParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func BACnetWriteStatusParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetWriteStatus, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadUint8("BACnetWriteStatus", 8)
	if err != nil {
		return 0, errors.Wrap(err, "error reading BACnetWriteStatus")
	}
	if enum, ok := BACnetWriteStatusByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for BACnetWriteStatus")
		return BACnetWriteStatus(val), nil
	} else {
		return enum, nil
	}
}

func (e BACnetWriteStatus) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e BACnetWriteStatus) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteUint8("BACnetWriteStatus", 8, uint8(uint8(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e BACnetWriteStatus) PLC4XEnumName() string {
	switch e {
	case BACnetWriteStatus_IDLE:
		return "IDLE"
	case BACnetWriteStatus_IN_PROGRESS:
		return "IN_PROGRESS"
	case BACnetWriteStatus_SUCCESSFUL:
		return "SUCCESSFUL"
	case BACnetWriteStatus_FAILED:
		return "FAILED"
	}
	return fmt.Sprintf("Unknown(%v)", uint8(e))
}

func (e BACnetWriteStatus) String() string {
	return e.PLC4XEnumName()
}
